;
; ENVIRON.ASM
;
; This file is part of DOSZIP
; Copyright (c) 1996 Hjort Nidudsson.
;
; Search environment for variables: COMSPEC, PATH, TEMP and DZ.
;

include		clib.inc
include		dzmain.inc

_DATA		SEGMENT

dzexe		DD	0
dzerrno		DW	0
dzerflag	DW	0
dzcount		DW	0
comspec		DD	0
envpath		DD	0
envtemp		DD	0
envconf		DD	0

_DATA		ENDS

_TEXT		SEGMENT

DZEnviron:	push	di
		mov	ax,envseg
		mov	es,ax
		xor	ax,ax
		mov	di,ax
		mov	cx,7FFFh
		cld
@@cmpcoms:      mov	edx,es:[di]
		cmp	edx,'SMOC'
		je	SHORT @@env_COMSPEC
		cmp	edx,'HTAP'
		je	SHORT @@env_PATH
		cmp	edx,'PMET'
		je	SHORT @@env_TEMP
		cmp	dx,'ZD'
		je	SHORT @@env_DZ
		cmp	dl,al
		jne	SHORT @@envloop
@@toend:	pop	di
		ret
@@envloop:	repnz	scasb
		or	cx,cx
		jz	SHORT @@toend
		jmp	SHORT @@cmpcoms
@@addentry:	mov	[bx],dx
		mov	[bx+2],es
		jmp	SHORT @@envloop
@@env_COMSPEC: 	cmp	DWORD PTR es:[di+4],'=CEP'
		jne	SHORT @@envloop
		mov	dx,di
		add	dx,8
		mov	bx,OFFSET comspec
		jmp	SHORT @@addentry
@@env_PATH:	cmp	BYTE PTR es:[di+4],'='
		jne	SHORT @@envloop
		mov	bx,OFFSET envpath
@@add_TEMP:	mov	dx,di
		add	dx,5
		jmp	SHORT @@addentry
@@env_TEMP:	cmp	BYTE PTR es:[di+4],'='
		jne	SHORT @@envloop
		mov	bx,OFFSET envtemp
		jmp	SHORT @@add_TEMP
@@env_DZ:	cmp	BYTE PTR es:[di+2],'='
		jne	SHORT @@envloop
IFDEF DEBUG
		jmp	SHORT @@envloop
ENDIF
		mov	dx,di
		add	dx,3
		mov	bx,OFFSET envconf
		jmp	SHORT @@addentry

InitDZEXE:	xor	ax,ax
		mov	es,ax
		mov	bx,03C4h
		les	bx,es:[bx]
		mov	eax,es:[bx]
		mov	edx,es:[bx+4]
		les	bx,es:[bx+4]
		cmp	eax,50495A44h
		je	SHORT @@Loaded
		xor	ax,ax
		ret
@@Loaded:	mov	dzexe,edx
		add	bx,208
		mov	ax,es:[bx]
		mov	dzerrno,ax
		mov	ax,es:[bx+2]
		mov	dzerflag,ax
		mov	ax,es:[bx+4]
		mov	dzcount,ax
		ret

_TEXT		ENDS

INITPROC	DZEnviron 0 90
INITPROC	InitDZEXE 0 91

		END
