/*
 * CMHELP.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <dzmain.h>
#include <string.h>

const char cp_copyright[] =
"The Doszip Commander, BETA Version " DOSZIP_VERSION_H
"\n"
"=======================================\n"
"Copyright (c) 1996-2009 Hjort Nidudsson\n"
"\n"
DOSZIP_REVISION;

enum {	OD_MEMORY,
	OD_COMPRESS,
	OD_VIEWER,
	OD_ENVIRON,
	OD_WINDOWS,
	OD_INSTALL,
	OD_TOOLS,
	OD_SHORTKEY,
	OD_README,
	OD_ABOUT,
	OD_OK,
	OD_COUNT	};

static
WORD offset_README_TXT[OD_COUNT - 2] = {
	1449, /* Memory     */
	2014, /* Compress   */
	4416, /* View       */
	6094, /* Environ    */
	7034, /* Windows    */
	7495, /* Install    */
	8033, /* Tools      */
	9500, /* Shortkey   */
	0,    /* README.TXT */
};

int cmabout(void)
{
	stdmsg(cp_about, cp_copyright);
	return 0;
}

int cmhelp(void)
{
	int x;
	DOBJ *d;
	char b[WMAXPATH];

	if ((d = rsopen(IDD_DoszipHelp)) == NULL)
		return 0;
	thelp = cmabout;
	d->object[OD_ABOUT].proc = cmabout;
	strfcat(b, programpath, READMEFILE);
	while ((x = rsevent(IDD_DoszipHelp, d)) > 0) {
		tview(b, offset_README_TXT[x - 1]);
	}
	tdclose(d);
	return 1;
}

/******** Resource begin DoszipHelp *
	{ 0x0C1C,  11,   9, {15, 5,51,14} },
	{ 0x0406,   0, 'M', { 4, 2,24, 1} },
	{ 0x0006,   0, 'C', { 4, 3,28, 1} },
	{ 0x0006,   0, 'V', { 4, 4,26, 1} },
	{ 0x0006,   0, 'E', { 4, 5,26, 1} },
	{ 0x0006,   0, 'W', { 4, 6,35, 1} },
	{ 0x0006,   0, 'I', { 4, 7,39, 1} },
	{ 0x0006,   0, 'T', { 4, 8,39, 1} },
	{ 0x0006,   0, 'S', { 4, 9,19, 1} },
	{ 0x0006,   0, 'R', { 4,10,15, 1} },
	{ 0x4000,   0, 'A', { 5,12, 9, 1} },
	{ 0x0200,   0, 'O', {19,12, 6, 1} },
********* Resource data  *******************/
static int DoszipHelp_RC[] = {
	0x06A1,0x0C1C,0x090B,0x050F,0x0E33,0x0406,0x4D00,0x0204,
	0x0118,0x0006,0x4300,0x0304,0x011C,0x0006,0x5600,0x0404,
	0x011A,0x0006,0x4500,0x0504,0x011A,0x0006,0x5700,0x0604,
	0x0123,0x0006,0x4900,0x0704,0x0127,0x0006,0x5400,0x0804,
	0x0127,0x0006,0x5300,0x0904,0x0113,0x0006,0x5200,0x0A04,
	0x010F,0x4000,0x4100,0x0C05,0x0109,0x0200,0x4F00,0x0C13,
	0x0106,0x33F0,0xF250,0x2A36,0x5050,0xF05C,0x5006,0xF020,
	0x2A04,0x5050,0xF05C,0x5003,0xF020,0x2A1F,0x09F0,0xF020,
	0x2A05,0x06F0,0xF020,0x2A19,0x17F0,0x4820,0x6C65,0xF070,
	0x2050,0x3E3C,0x4D20,0x6D65,0x726F,0x2079,0x6572,0x7571,
	0x7269,0x6D65,0x6E65,0x7374,0x1DF0,0x3C20,0x203E,0x6F43,
	0x706D,0x6572,0x7373,0x6465,0x6620,0x6C69,0x2065,0x7573,
	0x7070,0x726F,0xF074,0x2019,0x3E3C,0x5620,0x6569,0x6577,
	0x2F72,0x6445,0x7469,0x726F,0x7320,0x7075,0x6F70,0x7472,
	0x1BF0,0x3C20,0x203E,0x6E45,0x6976,0x6F72,0x6D6E,0x6E65,
	0x2074,0x6176,0x6972,0x6261,0x656C,0xF073,0x201B,0x3E3C,
	0x5720,0x6E69,0x6F64,0x7377,0x3920,0x2F35,0x3839,0x582F,
	0x2050,0x6F43,0x706D,0x7461,0x6269,0x6C69,0x7469,0xF079,
	0x2012,0x3E3C,0x4920,0x736E,0x6174,0x6C6C,0x6E69,0x2067,
	0x6F43,0x6D6D,0x6E61,0x6564,0x2072,0x6E75,0x6564,0x2072,
	0x6957,0x646E,0x776F,0xF073,0x200E,0x3E3C,0x4320,0x6572,
	0x7461,0x6E69,0x2067,0x2061,0x7375,0x7265,0x6420,0x6665,
	0x6E69,0x6465,0x7420,0x6F6F,0x736C,0x6D20,0x6E65,0xF075,
	0x200E,0x3E3C,0x5320,0x6F68,0x7472,0x656B,0x2079,0x6174,
	0x6C62,0xF065,0x2022,0x3E2D,0x5220,0x4145,0x4D44,0x2E45,
	0x5854,0xF054,0x205B,0x6241,0x756F,0x2074,0xDC20,0x06F0,
	0x4F20,0x206B,0xDC20,0x1FF0,0xF020,0xDF09,0x05F0,0xF020,
	0xDF06,0x19F0,0x2A20,
}; //	438 byte
ROBJ *IDD_DoszipHelp = (ROBJ *)&DoszipHelp_RC;
/******** Resource end   DoszipHelp */
