/*
 * CMDOSKEY.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <io.h>
#include <errno.h>
#include <string.h>
#include <dzmain.h>

#define MAXLINES	16
#define MAXCOMMAND	WMAXPATH
#define DOSKEYSIZE	(MAXLINES*MAXCOMMAND)

const char
	cp_editcommand	[] = "Edit command";

static int doskey_bindex = 0;
static int doskey_isnext = 0;
static int doskey_isedit = 0;

int doskey_read(char *b)
{
	int h,z;

	if ((h = iniopen(OPENCMD_READ)) == -1)
		return 0;
	z = osread(h, b, DOSKEYSIZE);
	close(h);
	return (z == DOSKEYSIZE);
}

int doskey_write(char *b)
{
	int h,z;

	if ((h = iniopen(OPENCMD_WRITE)) != -1) {
		z = oswrite(h, b, DOSKEYSIZE);
		close(h);
		return (z == DOSKEYSIZE);
	}
	return 0;
}

void doskey_delete(void)
{
	char *p = filename_CMD();

	setfattr(p, 0);
	remove(p);
}

int doskey_save(void)
{
	char b[DOSKEYSIZE];

	if (strtrim(com.base) == 0)
		return 0;
	if (doskey_read(b) == 0)
		memzero(b, DOSKEYSIZE);
	memmove(b + MAXCOMMAND, b, DOSKEYSIZE - MAXCOMMAND);
	strcpy(b, com.base);
	doskey_write(b);
	return 1;
}

int cmdoskey_up(void) /* Ctrl+Up */
{
	char b[DOSKEYSIZE];

	if (doskey_read(b) == 0)
		return 0;
	if (doskey_isnext) {
		com.base[0] = 0;
	} else {
		strcpy(com.base, b + (doskey_bindex * MAXCOMMAND));
		if (doskey_bindex == (MAXLINES-1))
			doskey_bindex = 0;
		else
			doskey_bindex++;
	}
	com_hndevent(END);
	doskey_isnext = 0;
	return 1;
}

int cmdoskey_dn(void) /* Ctrl+Dn */
{
	char b[DOSKEYSIZE];

	if (doskey_read(b) == 0)
		return 0;
	if (doskey_isnext == 0) {
		com.base[0] = 0;
	} else {
		if (doskey_bindex == 0)
			doskey_bindex = (MAXLINES-1);
		else
			doskey_bindex--;
		strcpy(com.base, b + (doskey_bindex * MAXCOMMAND));
	}
	com_hndevent(END);
	doskey_isnext = 1;
	return 1;
}

static DOBJ *dialog;
static int edit_history(void) /* F4 */
{
	char b[MAXCOMMAND];

	strcpy(b, dialog->object[dialog->index].data);
	if (tgetline(cp_editcommand, b, 40, MAXCOMMAND)) {
		doskey_isedit++;
		strcpy(dialog->object[dialog->index].data, b);
		tdinit(dialog);
	}
	return 0;
}

static GCMD history[] = {
	{ F4, 	 edit_history	},
	{ 0, 	 NULL		},
};

int cmhistory(void) /* Alt+F8 */
{
	int  x;
	char b[DOSKEYSIZE];
	char *p;
	TOBJ *o;
	RECT rc;

	if ((dialog = rsopen(IDD_History)) == NULL)
		return 0;
	memzero(b, DOSKEYSIZE);
	doskey_read(b);
	doskey_isedit = 0;
	p = b;
	o = dialog->object;
	o[0].data = p;
	o[0].flag &= ~_O_STATE;
	p += MAXCOMMAND;
	for (x = 1; x < MAXLINES && *p; x++, p += MAXCOMMAND) {
		o[x].data = p;
		o[x].flag &= ~_O_STATE;
	}
	o[x].data = history;
	o[x].flag = _O_GLCMD|_O_MOUSE|_O_STATE;
	dialog->count = x + 1;
	dialog->index = doskey_bindex;
	if (dialog->index >= x)
		dialog->index = 0;
	dialog->rc.row = x + 3;
	rc = dialog->rc;
	rc.x = 0;
	rc.y = 1;
	rc.row--;
	rcframe(rc, dialog->wp, 36, 0);
	tdshow(dialog);
	tdinit(dialog);
	if ((x = rsevent(IDD_History, dialog)) == 0) {
		tdclose(dialog);
		return 0;
	}
	doskey_bindex = dialog->index;
	if (doskey_isedit) {
		if (doskey_write(b) == 0)
			return stderror(filename_CMD(), EMEROPEN, 0);
	}
	tdclose(dialog);
	if (x > 0) {
		strcpy(com.base, dialog->object[x-1].data);
		com_hndevent(END);
		return 1;
	}
	return 0;
}

/******** Resource begin History *
	{ 0x041C,  17,   0, {22, 3,36,19} },
	{ 0x8003,   0,   0, { 2, 2,32, 1} },
	{ 0x8003,   0,   0, { 2, 3,32, 1} },
	{ 0x8003,   0,   0, { 2, 4,32, 1} },
	{ 0x8003,   0,   0, { 2, 5,32, 1} },
	{ 0x8003,   0,   0, { 2, 6,32, 1} },
	{ 0x8003,   0,   0, { 2, 7,32, 1} },
	{ 0x8003,   0,   0, { 2, 8,32, 1} },
	{ 0x8003,   0,   0, { 2, 9,32, 1} },
	{ 0x8003,   0,   0, { 2,10,32, 1} },
	{ 0x8003,   0,   0, { 2,11,32, 1} },
	{ 0x8003,   0,   0, { 2,12,32, 1} },
	{ 0x8003,   0,   0, { 2,13,32, 1} },
	{ 0x8003,   0,   0, { 2,14,32, 1} },
	{ 0x8003,   0,   0, { 2,15,32, 1} },
	{ 0x8003,   0,   0, { 2,16,32, 1} },
	{ 0x8003,   0,   0, { 2,17,32, 1} },
	{ 0x8007,   0,   0, { 2,18,32, 1} },
********* Resource data  *******************/
static int History_RC[] = {
	0x06C0,0x041C,0x0011,0x0316,0x1324,0x8003,0x0000,0x0202,
	0x0120,0x8003,0x0000,0x0302,0x0120,0x8003,0x0000,0x0402,
	0x0120,0x8003,0x0000,0x0502,0x0120,0x8003,0x0000,0x0602,
	0x0120,0x8003,0x0000,0x0702,0x0120,0x8003,0x0000,0x0802,
	0x0120,0x8003,0x0000,0x0902,0x0120,0x8003,0x0000,0x0A02,
	0x0120,0x8003,0x0000,0x0B02,0x0120,0x8003,0x0000,0x0C02,
	0x0120,0x8003,0x0000,0x0D02,0x0120,0x8003,0x0000,0x0E02,
	0x0120,0x8003,0x0000,0x0F02,0x0120,0x8003,0x0000,0x1002,
	0x0120,0x8003,0x0000,0x1102,0x0120,0x8007,0x0000,0x1202,
	0x0120,0x24F0,0xF250,0x2A88,0x0EF0,0x4820,0x7369,0x6F74,
	0x7972,0x97F2,0x5020,
}; //	166 byte
ROBJ *IDD_History = (ROBJ *)&History_RC;
/******** Resource end   History */
