/* SPRINTF.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <stdio.h>
#include <stdarg.h>
#include <limits.h>

int sprintf(char *string, const char *format, ...)
{
	FILE o;
	int result;
	va_list ap;

	o.flag = (_IOWRT | _IOSTRG);
	o.bp = o.base = string;
	o.cnt = INT_MAX;
	va_start(ap, format);
	result = _output(&o, format, ap);
	o.bp[0] = '\0';
	//_putc_lk('\0', &o);
	return result;
}
