/*
 * SETMODE.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <io.h>
#include <stdio.h>
#include <fcntl.h>
#include <errno.h>

int setmode(int fh, int mode)
{
	int oldmode;

	if (fh >= _nfile) {
		errno = EBADF;
		return (-1);
	}
	if (!(_osfile[fh] & FH_OPEN)) {
		errno = EBADF;
		return -1;
	} else {
		oldmode = _osfile[fh] & FH_TEXT;
		if ((unsigned)mode == O_BINARY) {
			_osfile[fh] &= ~FH_TEXT;
		} else if (mode == O_TEXT) {
			_osfile[fh] |= FH_TEXT;
		} else {
			errno = EINVAL;
			return -1;
		}
	}
	return(oldmode ? O_TEXT : O_BINARY);
}
