/*
 * CONFIRMF.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <arch.h>
#include <dialog.h>

#define ID_DELETE	1
#define ID_DELETEALL	2
#define ID_SKIPFILE	3
#define ID_CANCEL	4

int confirm_delete_file(const char *name, const char attrib)
{
	if (ISRDONLY(attrib) && (confirmflag & CFREADONY)) {
		switch (confirm_delete(name, MSG_DELRDONLY)) {
		case ID_DELETEALL:
			confirmflag &= ~(CFREADONY|CFDELETEALL);
		case ID_DELETE:
			return 1;
		case ID_SKIPFILE:
			return 0;
		default:
			return -1;
		}
	} else if (ISSYSTEM(attrib) && (confirmflag & CFSYSTEM)) {
		switch (confirm_delete(name, MSG_DELSYSTEM)) {
		case ID_DELETEALL:
			confirmflag &= ~(CFSYSTEM|CFDELETEALL);
		case ID_DELETE:
			return 1;
		case ID_SKIPFILE:
			return 0;
		default:
			return -1;
		}
	} else if (confirmflag & CFDELETEALL) {
		switch (confirm_delete(name, 0)) {
		case ID_DELETEALL:
			confirmflag &= ~(CFDELETEALL);
		case ID_DELETE:
			return 1;
		case ID_SKIPFILE:
			return 0;
		default:
			return -1;
		}
	}
	return 1;
}