;
; INFLATE.ASM
;
; This file is part of DOSZIP
; Copyright (c) 1996 Hjort Nidudsson.
;
; This code is a modified version of code in Info-ZIP distribution
;
; inflate.c -- by Mark Adler.
; explode.c -- by Mark Adler.
;

INCLUDE		clib.inc
INCLUDE		unzip.inc
INCLUDE		alloc.inc

		locals

GLOBAL PASCAL	zip_slide:	DWORD
GLOBAL PASCAL	wzipwrslide:	DIST
GLOBAL PASCAL	wzipgetbyte:	DIST

_TEXT		SEGMENT

dumpb		MACRO	cnt
		mov	cx,cnt
		shr	bb,cl
		sub	bk,cx
		ENDM

needb		MACRO	cnt
		mov	ax,cnt
		call	needbits
		ENDM

; decompress an inflated entry
;
wzipinflate	PROC 	PASCAL FAR
		USES	di
		xor	eax,eax
		mov	wp,ax		; initialize window, bit buffer
		mov	bk,ax
		mov	bb,eax
		mov	result,ax
@@loop:		call	inflate_block	; decompress until the last block
		cmp	result,0
		jnz	SHORT @@error
		or	ax,ax
		jnz	SHORT @@toend
@@mloop:	jmp	SHORT @@loop
@@toend:	push	wp		; flush out slide
		call	wzipwrslide
		or	ax,ax
		jz	SHORT @@error
		cmp	ax,ER_USERABORT
		jne	SHORT @@diskfull
		mov	result,ax
		jmp	SHORT @@error
@@diskfull:	mov	result,ER_DISK
@@error:	call	freeblock
		mov	ax,result
		ret
wzipinflate	ENDP

inflate_block	PROC 	PASCAL		; decompress an inflated block
		USES	di
		needb	1               ; read in last block bit
		mov	di,ax
		and	di,1
		dumpb	1
		needb	2               ; read in block type
		mov	dx,ax
		and	dx,3
		dumpb	2
		cmp	dx,2		; inflate that block type
		je	SHORT @@dynamic
		cmp	dx,1
		je	SHORT @@fixed
		or	dx,dx
		jz	SHORT @@stored
		jmp	SHORT @@error
@@fixed:	call	inflate_fixed
		jmp	SHORT @@result
@@stored:	call	inflate_stored
		jmp	SHORT @@result
@@dynamic:	call	inflate_dynamic
@@result:	mov	result,ax
		jmp	SHORT @@toend
@@error:	mov	result,ER_ZIP
@@toend:        mov	ax,di
		ret
inflate_block	ENDP

; inflate (decompress) the codes in a deflated (compressed) block.
; Return an error code or zero if it all goes well.
;
inflate_codes	PROC 	PASCAL
		USES	si,di
ARG		tl:	DWORD,\	; literal/length and distance decoder tables
		td:	DWORD,\
		ntl:	WORD,\	; number of bits decoded by tl[] and td[]
		ntd:	WORD
LOCAL		n:	WORD,\  ; length and index for copy
		d:	WORD,\
		ml:	WORD,\	; masks for bl and bd bits
		md:	WORD,\
		t:	DWORD	; pointer to table entry

		mov	di,wp	; initialize window position

		;mov	ax,1
		;mov	cx,ntl
		;shl	ax,cl
		;dec	ax
		;mov	ml,ax

		mov	bx,ntl	; precompute masks for speed
		add	bx,bx
		mov	ax,[bx+mask_bits]
		mov     ml,ax
		mov	bx,ntd
		add	bx,bx
		mov	ax,[bx+mask_bits]
		mov     md,ax

@@loop:         needb	ntl    	; do until end of block
		mov	dx,ml
		mov	eax,tl
		mov	t,eax
		call	inflate_codes1
		jbe	SHORT @@endloop1
@@loop1:	cmp	si,99
		jne	SHORT @@11
		mov	ax,1
		jmp	@@toend
@@11:		les	bx,t
		mov	cl,ES:[bx+1]
		shr	bb,cl
		mov	ch,0
		sub	bk,cx
		sub	si,16
		needb	si
		call	inflate_codes2
		ja	SHORT @@loop1
@@endloop1:     xor	cx,cx
		mov	cl,ES:[bx+1]
		shr	bb,cl
		sub	bk,cx
		cmp	si,16
		jne	SHORT @@eob
		mov	ax,ES:[bx+2]
		les	bx,zip_slide
		mov	ES:[bx+di],al
		inc	di
		cmp	di,WSIZE
		jne	SHORT @@1
		push	di
		xor	di,di
		call	wzipwrslide
		or	ax,ax
		je	SHORT @@1
		jmp	@@diskfull
@@1:		jmp	SHORT @@loop
@@eob:		mov	ax,si
		cmp	ax,15
		jne	SHORT @@2
		jmp     @@endloop
@@2:		call	needbits
		mov	bx,si
		and	ax,mask_bits[bx+si]
		les	bx,t
		add	ax,ES:[bx+2]
		mov	n,ax
		dumpb	si
		needb	ntd
		mov	eax,td
		mov	t,eax
		mov	dx,md
		call	inflate_codes1
		jbe	SHORT @@endloop2
@@loop2:        mov	ax,1
		cmp	si,99
		jne	SHORT @@21
		jmp	@@toend
@@21:           xor	cx,cx
		mov	cl,ES:[bx+1]
		shr	bb,cl
		sub	bk,cx
		sub	si,16
		needb	si
		call	inflate_codes2
		ja	SHORT @@loop2
@@endloop2:     xor	cx,cx
		mov	cl,ES:[bx+1]
		shr	bb,cl
		sub	bk,cx
		push	WORD PTR ES:[bx+2]
		needb	si
		mov	bx,si
		mov	dx,mask_bits[bx+si]
		and	dx,ax
		mov	ax,di
		pop	bx
		sub	ax,bx
		sub	ax,dx
		mov	d,ax
		dumpb	si
		mov	wp,di
		mov	bx,n
@@loop3:        mov	dx,d
		call	subcount
		mov	d,dx
		add	d,cx
		call	docopy
		or	ax,ax
		jnz	SHORT @@diskfull
		or	bx,bx
		jnz	SHORT @@loop3
		mov	di,wp
		jmp	@@loop
@@diskfull:     cmp	ax,ER_USERABORT
		je	SHORT @@toend
		mov	ax,ER_DISK
		jmp	SHORT @@toend
@@endloop:	mov	wp,di
		xor	ax,ax
@@toend:	ret
inflate_codes	ENDP

inflate_codes2:	les	bx,t
		mov	eax,ES:[bx+2]
		mov	t,eax
		mov	bx,si
		add	bx,bx
		mov	ax,WORD PTR bb
		and	ax,mask_bits[bx]
		add	ax,ax
		mov	bx,ax
		add	ax,ax
		add	ax,bx
		add	WORD PTR t,ax
		les	bx,t
		jmp	SHORT inflate_codes3
inflate_codes1:	mov	ax,WORD PTR bb
		and	ax,dx
		add	ax,ax
		mov	bx,ax
		add	ax,ax
		add	ax,bx
		add	WORD PTR t,ax
		les	bx,t
inflate_codes3:	mov	al,ES:[bx]
		mov	ah,0
		mov	si,ax
		cmp	ax,16
		ret

docopy:		push	si
		push	di
		push	DS
		les	di,zip_slide
		add	di,wp
		add	wp,cx
		mov	ax,wp
		lds	si,zip_slide
		add	si,dx
		sub	ax,dx
		cld
	rep	movsb
		pop	DS
		pop	di
		pop	si

wrslide:	xor	ax,ax
		cmp	wp,WSIZE
		jne	SHORT @@toend
		push	bx
		push	wp
		mov	wp,0
		call	wzipwrslide
		pop	bx
@@toend:	ret

subcount:	mov	ax,(WSIZE-1)
		and	ax,dx
		mov	dx,ax
		cmp	ax,wp
		ja	SHORT @@1
		mov	ax,wp
@@1:		mov	cx,WSIZE
		sub	cx,ax
		cmp	cx,bx
		jbe	SHORT @@2
		mov	cx,bx
@@2:		sub	bx,cx
		ret

; decompress an inflated type 2 (dynamic Huffman codes) block.
;
inflate_dynamic	PROC 	PASCAL
		USES	si,di
LOCAL		@@m:	WORD,\	; mask for bit lengths table
		@@n:	WORD,\	; number of lengths to get
		@@tl:	DWORD,\ ; literal/length code table
		@@td:	DWORD,\ ; distance code table
		@@bl:	WORD,\  ; lookup bits for tl
		@@bd:	WORD,\  ; lookup bits for td
		@@nb:	WORD,\  ; number of bit length codes
		@@nl:	WORD,\  ; number of literal/length codes
		@@nd:	WORD,\	; number of distance codes
		@@ll:	WORD:[288+32] ; literal l. and distance code lengths

		; read in table lengths

		needb	5
		and	ax,001Fh
		add	ax,257
		mov	@@nl,ax		; number of literal/length codes
		dumpb	5
		needb	5
		and	ax,001Fh
		add	ax,1
		mov	@@nd,ax		; number of distance codes
		dumpb	5
		needb	4
		and	ax,000Fh
		add	ax,4
		mov	@@nb,ax		; number of bit length codes
		dumpb	4
		cmp	@@nl,288	; (286) PKZIP_BUG_WORKAROUND
		ja	SHORT @@bad_length
		cmp	@@nd,32         ;  (30) PKZIP_BUG_WORKAROUND
		jbe	SHORT @@codelengths
@@bad_length:	mov	ax,1		; bad lengths
		jmp	@@toend

; read in bit-length-code lengths
;
@@codelengths:	xor	si,si
		jmp	SHORT @@loop_nb

@@loop1:        needb	3
		mov	bx,si
		add	bx,bx
		mov	ax,border[bx]
		add	ax,ax
		lea	bx,@@ll
		add	bx,ax
		mov	ax,WORD PTR bb
		and	ax,7
		mov	SS:[bx],ax
		dumpb	3
		inc	si
@@loop_nb:	cmp	si,@@nb
		jb	SHORT @@loop1
		lea	dx,@@ll
		jmp	SHORT @@loop_19

@@loop2:	mov	bx,si
		add	bx,bx
		mov	ax,border[bx]
		add	ax,ax
		mov	bx,dx
		add	bx,ax
		xor	ax,ax
		mov	SS:[bx],ax
		inc	si
@@loop_19:	cmp	si,19
		jb	SHORT @@loop2

; build decoding table for trees--single level, 7 bit lookup
;
		mov     @@bl,7

		push	SS
		push	dx
		mov	ax,19
		push	ax
		push	ax
		xor	eax,eax
		push	eax
		push	eax
		lea	ax,@@tl
		push	SS
		push	ax
		lea	ax,@@bl
		push	SS
		push	ax
		call	huft_build
		cmp	@@bl,0
		jne	SHORT @@bit_lengths
		mov	ax,1		; no bit lengths
@@bit_lengths:	or	ax,ax
		jz	SHORT @@readlengths
		cmp	ax,1
		jne	SHORT @@3
		push	ax
		push	@@tl
		call	huft_free
		pop	ax
@@3:		jmp	@@toend         ; incomplete code set

; read in literal and distance code lengths
;
@@readlengths:	mov	ax,@@nl
		add	ax,@@nd
		mov	@@n,ax
		mov	bx,@@bl
		add	bx,bx
		mov	ax,mask_bits[bx]
		mov	@@m,ax
		xor	ax,ax
		mov	si,ax
		mov     di,ax
@@while_ilessn:	cmp	si,@@n
		jb	SHORT @@do
		jmp	@@freetable
@@do:		mov	eax,@@tl
		mov	@@td,eax
		needb	@@bl
		and	ax,@@m
		add	ax,ax
		mov	dx,ax
		add	ax,ax
		add	ax,dx
		add	WORD PTR @@td,ax
		xor	ax,ax
		les	bx,@@td
		mov	al,ES:[bx+1]
		dumpb	ax
		mov	ax,ES:[bx+2]
		cmp	ax,16		; length of code in bits (0..15)
		je	SHORT @@j_equ_16
		ja	SHORT @@j_above_16
		mov	di,ax
		mov	dx,si
		inc	si
		add	dx,dx
		lea	bx,@@ll
		add	bx,dx
		mov	SS:[bx],ax
		jmp	SHORT @@while_ilessn

@@while_j:	mov	ax,dx
		dec	dx
		or	ax,ax
		jz	SHORT @@while_ilessn
		mov	ax,si
		inc	si
		add	ax,ax
		lea	bx,@@ll
		add	bx,ax
		mov	ax,di
		mov	SS:[bx],ax
		jmp	SHORT @@while_j

@@j_equ_16:	needb	2		; repeat last length 3 to 6 times
		and	ax,3
		add	ax,3
		dumpb	2
		mov	dx,ax
		add	ax,si
		cmp	ax,@@n
		jbe	SHORT @@while_j
		mov	ax,1
		jmp	@@toend

@@j_above_16:	cmp	ax,17
		jne	SHORT @@j_above_17
		needb	3		; 3 to 10 zero length codes
		and	ax,7
		add	ax,3
		mov	dx,ax
		dumpb	3
@@llzero:	add	ax,si
		cmp	ax,@@n
		jbe	SHORT @@clear_ll
		mov	ax,1
		jmp	@@toend

@@clear_ll:	xor	di,di
@@next:		mov	ax,dx
		dec	dx
		or	ax,ax
		jz	SHORT @@end_clear
		mov	ax,si
		inc	si
		add	ax,ax
		lea	bx,@@ll
		add	bx,ax
		xor	ax,ax
		mov	SS:[bx],ax
		jmp	SHORT @@next
@@end_clear:	jmp	@@while_ilessn

@@j_above_17:	needb	7
		and	ax,007Fh
		add	ax,11
		mov	dx,ax
		dumpb	7
		jmp	SHORT @@llzero

@@freetable:	push	@@tl		; free decoding table for trees
		call	huft_free

; build the decoding tables for literal/length and distance codes
;
		mov	ax,lbits
		mov	@@bl,ax
		lea	ax,@@ll
		push	SS
		push	ax
		push	@@nl
		push	257
		push	DS
		push	OFFSET cplens
		push	DS
		push	OFFSET cplext
		lea	ax,@@tl
		push	SS
		push	ax
		lea	ax,@@bl
		push	SS
		push	ax
		call	huft_build
		cmp	@@bl,0
		jne	SHORT @@bitl2
		mov	ax,1		; no literals or lengths
@@bitl2:	or	ax,ax
		jz	SHORT @@ok
		cmp	ax,1
		je	SHORT @@error
		jmp	SHORT @@toend   ; incomplete code set
@@error:        push	ax
		push	@@tl
		call	huft_free
		pop	ax
		jmp	SHORT @@toend
@@success:	push	@@tl
		call	huft_free
		push	@@td
		call	huft_free
		xor	ax,ax
@@toend:	ret
@@ok:		mov	ax,dbits
		mov	@@bd,ax
		lea	ax,@@ll
		add	ax,@@nl
		add	ax,@@nl
		push	SS
		push	ax
		push	@@nd
		push	0
		push	DS
		push	OFFSET cpdist
		push	DS
		push	OFFSET cpdext
		push	SS
		lea	ax,@@td
		push	ax
		push	SS
		lea	ax,@@bd
		push	ax
		call	huft_build
		cmp	@@bl,0
		jne	SHORT @@bitl3
		cmp	@@nl,257
		jbe	SHORT @@bitl3
		mov	ax,1		; lengths but no distances
		jmp	SHORT @@error
@@bitl3:	cmp	ax,1
		jne	short @@nopkzip	; PKZIP_BUG_WORKAROUND
		xor	ax,ax
@@nopkzip:	or	ax,ax
		jnz	SHORT @@error
		push	@@tl	; decompress until an end-of-block code
		push	@@td
		push	@@bl
		push	@@bd
		call	inflate_codes
		or	ax,ax
		jz	SHORT @@success
		mov	ax,1
		jmp	SHORT @@toend
inflate_dynamic	ENDP

; "decompress" an inflated type 0 (stored) block.
;
inflate_stored	PROC 	PASCAL
		USES	si
		mov	ax,bk		; go to byte boundary
		and	ax,7
		dumpb	ax
		needb	16              ; get the length and its complement
		mov	si,ax
		dumpb	16
		needb	16
		not	ax
		cmp	ax,si
		je	SHORT @@1
		mov	ax,1            ; error in compressed data
		jmp	SHORT @@toend
@@1:		dumpb	16
@@loop:         or	si,si		; read and output the compressed data
		jz	SHORT @@endloop
		dec	si
		needb	8
		les	bx,zip_slide
		add	bx,wp
		mov	ES:[bx],al
		inc	wp
		cmp	wp,WSIZE
		jne	SHORT @@2
		push	wp
		call	wzipwrslide
		or	ax,ax
		jz	SHORT @@3
		cmp	ax,ER_USERABORT
		je	SHORT @@toend
		mov	ax,ER_DISK
		jmp	SHORT @@toend
@@3:		mov	wp,0
@@2:		dumpb	8
		jmp	SHORT @@loop
@@endloop:	xor	ax,ax
@@toend:	ret
inflate_stored	ENDP

; decompress an inflated type 1 (fixed Huffman codes) block.

inflate_fixed	PROC 	PASCAL
		USES	di
LOCAL		llist:	WORD:[288]	; length list for huft_build
		xor	eax,eax
		cmp	eax,fixed_tl    ; if first time, set up tables
		jz	SHORT @@mklist	; for fixed blocks
		jmp	@@decompress
@@mklist:	lea	di,llist	; literal table
		push	SS
		pop	ES
		cld
		mov	cx,144
		mov	ax,8
	rep	stosw
		mov	cx,112
		mov	ax,9
	rep	stosw
		mov	cx,24
		mov	ax,7
	rep	stosw
		mov	cx,8		; make a complete, but wrong code set
		mov	ax,8
	rep	stosw
		mov	fixed_bl,7
		push	ES
		lea	ax,llist
		push	ax
		push	288
		push	257
		push	DS
		push	OFFSET cplens
		push	DS
		push	OFFSET cplext
		push	DS
		push	OFFSET fixed_tl
		push	DS
		push	OFFSET fixed_bl
		call	huft_build
		or	ax,ax
		jz	SHORT @@1
		xor	edx,edx
		mov	fixed_tl,edx
		jmp	SHORT @@toend
@@1:		lea	di,llist	; distance table
		mov	dx,di
		mov	cx,30
		mov	ax,5
		push	SS
		pop	ES
		cld
	rep	stosw
		mov	fixed_bd,5
		push	ES
		push	dx
		push	30
		push	0
		push	DS
		push	OFFSET cpdist
		push	DS
		push	OFFSET cpdext
		push	DS
		push	OFFSET fixed_td
		push	DS
		push	OFFSET fixed_bd
		call	huft_build
		cmp	ax,1
		jbe	SHORT @@decompress
		push	ax
		push	fixed_tl
		call	huft_free
		xor	eax,eax
		mov	fixed_tl,eax
		pop	ax
		jmp	SHORT @@toend

@@decompress:	push	fixed_tl ; decompress until an end-of-block code
		push	fixed_td
		push	fixed_bl
		push	fixed_bd
		call	inflate_codes
		or	ax,ax
		jz	SHORT @@toend
		mov	ax,1
@@toend:	ret
inflate_fixed	ENDP

freeblock:	xor	eax,eax
		cmp	fixed_tl,eax
		jz	SHORT @@toend
		push	fixed_td
		call	huft_free
		push	fixed_tl
		call	huft_free
		xor	eax,eax
		mov     fixed_td,eax
		mov     fixed_tl,eax
@@toend:	ret

needbits:	push	di
		mov	di,ax
@@next:		cmp	bk,di
		jnb	SHORT @@toend
		call	wzipgetbyte
		mov	cx,bk
		movsx	eax,ax
		shl	eax,cl
		or	bb,eax
		add	bk,8
		jmp	SHORT @@next
@@toend:	pop	di
		mov	ax,WORD PTR bb
		ret

wzipexplode	PROC 	PASCAL FAR
		USES	si,di
LOCAL		ex_tb:	DWORD,\		; literal code table
		ex_tl:	DWORD,\		; length code table
		ex_td:	DWORD,\		; distance code table
		ex_bb:	WORD,\		; bits for tb
		ex_bl:	WORD,\		; bits for tl
		ex_bd:	WORD,\		; bits for td
		ex_l:	WORD:[256]      ; bit lengths for codes
LOCAL		ex_s:	DWORD,\
		ex_t:	DWORD,\
		ex_ml:	WORD,\
		ex_mb:	WORD,\
		ex_md:	WORD,\
		ex_u:	WORD,\
		exbits:	WORD,\
		exmask:	WORD

		mov	ex_bl,7
		mov	ex_bd,8
		cmp	zip_local.lz_csize,200000
		jnb	SHORT @@big
		dec	ex_bd
@@big:		test	zip_local.lz_flag,4
		jnz	SHORT @@tree_256
		jmp	@@nolit

; With literal tree--minimum match length is 3
;
@@tree_256:	mov	ex_bb,9		; base table size for literals
		mov	ax,256
		call	exp_gettree
		or	ax,ax
		jz	SHORT @@huft_256
		jmp	@@toend
@@huft_256:	push	SS
		lea	ax,ex_l
		push	ax
		push	256
		push	256
		xor	eax,eax
		push	eax
		push	eax
		push	SS
		lea	ax,ex_tb
		push	ax
		push	SS
		lea	ax,ex_bb
		push	ax
		call	huft_build
		or	ax,ax
		jz	SHORT @@tree_64
		push	ax
		cmp	ax,1
		jne	SHORT @@popax
		jmp	SHORT @@freetb

@@tree_64:	mov	ax,64
		call	exp_gettree
		or	ax,ax
		jz	SHORT @@huft_64
		jmp	@@toend
@@huft_64:	push	SS
		lea	ax,ex_l
		push	ax
		push	64
		push	0
		push	DS
		push	OFFSET cplen3
		push	DS
		push	OFFSET exextra
		push	SS
		lea	ax,ex_tl
		push	ax
		push	SS
		lea	ax,ex_bl
		push	ax
		call	huft_build
		or	ax,ax
		jnz	SHORT @@error
		jmp	SHORT @@gettree
@@error:	push	ax
		cmp	ax,1
		jnz	SHORT @@freetb
		push	ex_tl
		call	huft_free
@@freetb:	push	ex_tb
		call	huft_free
@@popax:	pop	ax
		jmp	@@toend

@@gettree:	mov	ax,64
		call	exp_gettree
		or	ax,ax
		jz	SHORT @@huft4or8
		jmp	@@toend

@@huft4or8:	push	SS
		lea	ax,ex_l
		push	ax
		push	64
		push	0
		push	DS
		mov	ax,zip_local.lz_flag
		and	ax,2
		jz	SHORT @@cpdist4
		push	OFFSET cpdist8
		push	DS
		push	OFFSET exextra
		push	SS
		lea	ax,ex_td
		push	ax
		push	SS
		lea	ax,ex_bd
		push	ax
		call	huft_build
		or	ax,ax
		jz	SHORT @@lit8
		jmp	@@erhtab
@@lit8:		call	exp_lit8
		jmp	SHORT @@endlit
@@cpdist4:	push	OFFSET cpdist4
		push	DS
		push	OFFSET exextra
		push	SS
		lea	ax,ex_td
		push	ax
		push	SS
		lea	ax,ex_bd
		push	ax
		call	huft_build
		or	ax,ax
		jz	SHORT @@lit4
		jmp	@@erhtab
@@lit4:		call	exp_lit4
@@endlit:	push	ax
		jmp	@@freetdtltb

; No literal tree--minimum match length is 2
;
@@nolit:        xor	eax,eax
		mov	ex_tb,eax
		mov	ax,64
		call	exp_gettree
		jz	SHORT @@nolit_64
		jmp	@@toend

@@nolit_64:	push	SS
		lea	ax,ex_l
		push	ax
		push	64
		push	0
		push	DS
		push	OFFSET cplen2
		push	DS
		push	OFFSET exextra
		push	SS
		lea	ax,ex_tl
		push	ax
		push	SS
		lea	ax,ex_bl
		push	ax
		call	huft_build
		or	ax,ax
		jz	SHORT @@nolit_tree
		cmp	ax,1
		je	SHORT @@freetl
		jmp	@@toend
@@freetl:	push	ax
		push	ex_tl
		call	huft_free
		pop	ax
		jmp	@@toend

@@nolit_tree:	mov	ax,64
		call	exp_gettree
		or	ax,ax
		jz	SHORT @@nolit_huft
		jmp	@@toend

@@nolit_huft:	lea	ax,ex_l
		push	SS
		push	ax
		push	64
		push	0
		push	DS
		mov	ax,zip_local.lz_flag
		and	ax,2
		jz	SHORT @@nolitcpdist4
		push	OFFSET cpdist8
		push	DS
		push	OFFSET exextra
		push	SS
		lea	ax,ex_td
		push	ax
		push	SS
		lea	ax,ex_bd
		push	ax
		call	huft_build
		or	ax,ax
		jz	SHORT @@nolit8
		jmp	SHORT @@erhtab3

@@nolit8:	call	exp_nolit8
		jmp	SHORT @@return3
@@nolitcpdist4:	push	OFFSET cpdist4
		push	DS
		push	OFFSET exextra
		push	SS
		lea	ax,ex_td
		push	ax
		push	SS
		lea	ax,ex_bd
		push	ax
		call	huft_build
		or	ax,ax
		jz	SHORT @@nolit4
		jmp	SHORT @@erhtab3
@@nolit4:	call	exp_nolit4
@@return3:	push	ax
		jmp	SHORT @@6

@@erhtab3:	push	ax
		cmp	ax,1
		jne	SHORT @@4
@@6:		push    ex_td
		call	huft_free
@@4:		push	ex_tl
		jmp	SHORT @@5

@@erhtab:       push	ax
		cmp	ax,1
		jne	SHORT @@erhtab1
@@freetdtltb:	push	ex_td
		call	huft_free
@@erhtab1:	push	ex_tl
		call	huft_free
		push	ex_tb
@@5:		call	huft_free
		pop	ax
@@toend:	ret
wzipexplode	ENDP

exp_lit8	PROC
		mov	exbits,7
		mov	exmask,007Fh
		call	exp_lit
		ret
exp_lit8	ENDP

exp_lit4	PROC
		mov	exbits,6
		mov	exmask,003Fh
		call	exp_lit
		ret
exp_lit4	ENDP

exp_nolit8	PROC
		mov	exbits,7
		mov	exmask,007Fh
		call	exp_nolit
		ret
exp_nolit8	ENDP

exp_nolit4	PROC
		mov	exbits,6
		mov	exmask,003Fh
		call	exp_nolit
		ret
exp_nolit4	ENDP

exp_nolit	PROC
		call	exp_init
@@loop:		xor	eax,eax
		cmp	ex_s,eax
		jz	SHORT @@wrslide
		needb	1
		and	ax,1
		jz	SHORT @@2
		call	exp_wrone
@@3:		or	ax,ax
		jz	SHORT @@loop
		jmp	SHORT @@toend
@@2:		call	exp_docopy
		jmp	SHORT @@3
@@wrslide:	push	wp
		call	wzipwrslide
@@toend:	ret
exp_nolit	ENDP

exp_lit		PROC
		call	exp_init
@@loop:		xor	eax,eax
		cmp	ex_s,eax
		jz	SHORT @@wrslide
		needb	1
		and	ax,1
		jz	SHORT @@2
		dumpb	1
		dec	ex_s
		mov	ax,WORD PTR bb
		call	needbits
		mov	dx,ex_mb
		mov	eax,ex_tb
		call	exp_dowhile
		or	ax,ax
		jnz	SHORT @@toend
		mov	al,ES:[bx+1]
		dumpb	ax
		mov	ax,ES:[bx+2]
		call	exp_wrbyte
		or	ax,ax
		jnz	SHORT @@toend
		jmp	SHORT @@loop
@@2:		call	exp_docopy
		or	ax,ax
		jnz	SHORT @@toend
		jmp	SHORT @@loop
@@wrslide:	push	wp
		call	wzipwrslide
@@toend:	ret
exp_lit		ENDP

exp_gettree	PROC
		mov	di,ax
		call	wzipgetbyte
		inc	ax
		push	ax
		xor	si,si
@@loop:		call	wzipgetbyte
		mov	dx,ax
		and	ax,000Fh
		mov	cx,ax
		inc	cx
		and	dx,00F0h
		shr	dx,4
		inc	dx
		mov	ax,dx
		add	ax,si
		cmp	ax,di
		jbe	SHORT @@2
		pop	ax
		jmp	SHORT @@error
@@2:		lea	bx,ex_l
		mov	ax,si
		add	ax,ax
		add	bx,ax
		mov	SS:[bx],cx
		inc	si
		dec	dx
		jnz	SHORT @@2
		pop	ax
		dec	ax
		jz	SHORT @@3
		push	ax
		jmp	SHORT @@loop
@@3:            cmp	si,di
		jne	SHORT @@error
		jmp	SHORT @@toend
@@error:	mov	ax,4
@@toend:	ret
exp_gettree	ENDP

exp_init:	xor	eax,eax
		mov	bb,eax
		mov	bk,ax
		mov	wp,ax
		mov	ex_u,1
		mov	bx,ex_bb
		add	bx,bx
		mov	ax,mask_bits[bx]
		mov	ex_mb,ax
		mov	bx,ex_bl
		add	bx,bx
		mov	ax,mask_bits[bx]
		mov	ex_ml,ax
		mov	bx,ex_bd
		add	bx,bx
		mov	ax,mask_bits[bx]
		mov	ex_md,ax
		mov	eax,zip_local.lz_fsize
		mov	ex_s,eax
		ret

exp_wrbyte	PROC
		les	bx,zip_slide
		add	bx,wp
		inc	wp
		mov	ES:[bx],al
		xor	ax,ax
		cmp	wp,WSIZE
		jne	SHORT @@toend
		push	wp
		call	wzipwrslide
		or	ax,ax
		jnz	SHORT @@toend
		mov	wp,ax
		mov	ex_u,ax
@@toend:        ret
exp_wrbyte	ENDP

exp_wrone	PROC
		dumpb	1
		dec	ex_s
		needb	8
		call	exp_wrbyte
		dumpb	8
		ret
exp_wrone	ENDP

exp_dowhile	PROC
		mov	ex_t,eax
		mov	ax,WORD PTR bb
		not	ax
		and	ax,dx
		add	ax,ax
		mov	bx,ax
		add	ax,ax
		add	ax,bx
		add	WORD PTR ex_t,ax
		les	bx,ex_t
		xor	ax,ax
		mov	al,ES:[bx]
		mov	si,ax
		xor	ax,ax
		cmp	si,16
		jbe	SHORT @@toend
@@do:		cmp	si,99
		jne	SHORT @@1
		inc	ax
		jmp	SHORT @@toend
@@1:		mov	al,ES:[bx+1]
		dumpb	ax
		sub	si,16
		needb	si
		les	bx,ex_t
		mov	eax,ES:[bx+2]
		mov	ex_t,eax
		mov	bx,si
		add	bx,bx
		mov	ax,WORD PTR bb
		not	ax
		and	ax,mask_bits[bx]
		add	ax,ax
		mov	bx,ax
		add	ax,ax
		add	ax,bx
		add	WORD PTR ex_t,ax
		les	bx,ex_t
		xor	ax,ax
		mov	al,ES:[bx]
		mov	si,ax
		xor	ax,ax
		cmp	si,16
		jbe	SHORT @@toend
		jmp	SHORT @@do
@@toend:	ret
exp_dowhile	ENDP

exp_docopy	PROC
		dumpb	1
		needb	exbits
		and	ax,exmask
		mov	di,ax
		dumpb	exbits
		needb	ex_bd
		mov	dx,ex_md
		mov	eax,ex_td
		call	exp_dowhile
		or	ax,ax
		jnz	SHORT @@toend
		mov	al,ES:[bx+1]
		dumpb	ax
		mov	dx,ES:[bx+2]
		mov	ax,wp
		sub	ax,di
		sub	ax,dx
		mov	di,ax
		needb	ex_bl
		mov	dx,ex_ml
		mov	eax,ex_tl
		call	exp_dowhile
		or	ax,ax
		jnz	SHORT @@toend
		mov	al,ES:[bx+1]
		dumpb	ax
		mov	ax,ES:[bx+2]
		xchg	ax,si
		or	ax,ax
		jz	SHORT @@3
		needb	8
		and	ax,00FFh
		add	si,ax
		dumpb	8
@@3:            xor	eax,eax
		mov	ax,si
		sub	ex_s,eax
		jmp	SHORT @@copy
@@toend:	ret
@@copy:		mov	bx,si
@@loop:		mov	dx,di
		call	subcount
		mov	di,dx
		add	di,cx
		cmp	ex_u,0
		jz	SHORT @@docopy
		cmp	wp,dx
		ja	SHORT @@docopy
		push	di
		xor	ax,ax
		les	di,zip_slide
		add	di,wp
		add	wp,cx
		cld
	rep	stosb
		pop	di
		call	wrslide
		jmp	SHORT @@4
@@docopy:	call	docopy
@@4:		or	ax,ax
		jnz	SHORT @@toend
		cmp	wp,0
		jnz	SHORT @@5
		mov	ex_u,0
@@5:		or	bx,bx
		jnz	SHORT @@loop
		xor	ax,ax
		jmp	SHORT @@toend
exp_docopy	ENDP

huft_build	PROC	PASCAL
		USES	si,di
ARG		@@b:	DWORD,\	; code lengths in bits (all assumed <= BMAX)
		@@n:	WORD,\  ; number of codes (assumed <= N_MAX)
		@@s:	WORD,\  ; number of simple-valued codes (0..s-1)
		@@d:	DWORD,\ ; list of base values for non-simple codes
		@@e:	DWORD,\ ; list of extra bits for non-simple codes
		@@t:	DWORD,\ ; result: starting table
		@@m:	DWORD   ; maximum lookup bits, returns actual

LOCAL		@@a:	WORD,\		; counter for codes of length k
		@@c:	WORD:[MAXBIT+1],\ ; bit length count table
		@@el:	WORD,\		; length of EOB code (value 256)
		@@f:	WORD,\          ; i repeats in table every f entries
		@@g:	WORD,\          ; maximum code length
		@@i:	WORD,\          ; counter, current code
		@@k:	WORD,\          ; number of bits in current code
		@@lx:	WORD:[MAXBIT+1],\ ; memory for l[-1..BMAX-1]
		@@l:	WORD,\          ; stack of bits per table
		@@p:	WORD,\          ; pointer into c[], b[], or v[]
		@@q:	DWORD,\         ; points to current table
		@@r:	HUFT,\          ; table entry for structure assignment
		@@u:	DWORD:[MAXBIT],\ ; table stack
		@@v:	WORD:[MAXCODE],\ ; values in order of bit length
		@@w:	WORD,\          ; bits before this table == (l * h)
		@@x:	WORD:[MAXBIT+1],\ ; bit offsets, then code stack
		@@y:	WORD,\          ; number of dummy codes added
		@@z:	WORD            ; number of entries in current table

		lea	ax,@@lx
		add	ax,2
		mov	@@l,ax

; Generate counts for each bit length
;
		cmp	@@n,256         ; set length of EOB code, if any
		mov	ax,MAXBIT
		jbe	SHORT @@length_EOB
		les	bx,@@b
		mov	ax,ES:[bx+512]
@@length_EOB:	mov	@@el,ax

		xor	ax,ax		; clear bit length count table
		lea	dx,@@c
		mov	di,dx
		push	SS
		pop	ES
		mov	cx,17
		cld
	rep	stosw

		mov	cx,@@n
		les	di,@@b
@@setbitlength:	mov	bx,ES:[di]
		add	di,2
		add	bx,bx
		add	bx,dx
		inc	WORD PTR SS:[bx]
		dec	cx
		jnz	SHORT @@setbitlength

		mov	bx,dx
		mov	ax,@@n
		cmp	ax,SS:[bx]
		jne	SHORT @@minimum_code
		xor	eax,eax		; null input--all zero length codes
		les	bx,@@t
		mov	ES:[bx],eax
		les	bx,@@m
		mov	ES:[bx],ax
		jmp	@@toend

; Find minimum and maximum length, bound *m by those
;
@@minimum_code:	mov	di,1
		xor	ax,ax
@@mincode_loop:	cmp	di,MAXBIT
		ja	SHORT @@minlength
		mov	bx,di
		add	bx,bx
		add	bx,dx
		cmp	ax,SS:[bx]
		jnz	SHORT @@minlength
		inc	di
		jmp	SHORT @@mincode_loop
@@minlength:	mov	@@k,di		; minimum code length

		les	si,@@m
		cmp	ES:[si],di
		jnb	SHORT @@maximum_code
		mov	ES:[si],di
@@maximum_code:	mov	cx,MAXBIT
		xor	ax,ax
@@maxcode_loop:	mov	bx,cx
		add	bx,bx
		add	bx,dx
		cmp	ax,SS:[bx]
		jnz	SHORT @@maxlength
		dec	cx
		jnz	SHORT @@maxcode_loop
@@maxlength:	mov	@@g,cx		; maximum code length

		les	bx,@@m
		cmp	cx,ES:[bx]
		jae	SHORT @@last_length
		mov	ES:[bx],cx

; Adjust last length count to fill out codes, if needed
;
@@last_length:	mov	si,cx   ; si = maximum code length
		mov	cx,di	; di = minimum code length
		mov	ax,1
		shl	ax,cl
		mov	cx,ax

@@input_loop:	cmp	di,si
		jae	SHORT @@test_ci
		mov	bx,di
		add	bx,bx
		add	bx,dx
		sub	cx,SS:[bx]
		cmp	cx,0
		jl	SHORT @@erzip	; bad input: more codes than bits
		add	cx,cx
		inc	di
		jmp	SHORT @@input_loop

@@test_ci:	mov	bx,si
		add	bx,bx
		add	bx,dx
		sub	cx,SS:[bx]
		cmp	cx,0
		jl	SHORT @@erzip

		add	SS:[bx],cx
		mov	@@y,cx

; Generate starting offsets into the value table for each length
;
		xor	ax,ax
		lea	bx,@@x
		add	bx,2
		mov	SS:[bx],ax
		mov	di,dx
		add	di,2

@@makesoffs:	dec	si
		jz	SHORT @@maketable
		add	ax,SS:[di]
		add	di,2
		add	bx,2
		mov	SS:[bx],ax
		jmp	SHORT @@makesoffs

@@erzip:	mov	ax,ER_ZIP
		jmp	@@toend

; Make a table of values in order of bit lengths
;
@@maketable:	;memset(v, 0, sizeof(v))
		xor	cx,cx
		les	si,@@b
@@mkt_next:	mov	ax,ES:[si]
		add	si,2
		or	ax,ax
		jz	SHORT @@mkt_loop
		add	ax,ax
		lea	bx,@@x
		add	bx,ax
		mov	ax,SS:[bx]
		inc	WORD PTR SS:[bx]
		add	ax,ax
		lea	bx,@@v
		add	bx,ax
		mov	SS:[bx],cx
@@mkt_loop:	inc	cx
		cmp	cx,@@n
		jb	SHORT @@mkt_next

; Generate the Huffman codes and for each, make the table entries
;
		xor	eax,eax
		mov	@@i,ax
		mov	@@x,ax
		mov	@@w,ax
		mov	@@lx,ax
		mov	si,-1
		mov	@@u,eax
		mov	@@q,eax
		mov	@@z,ax

		lea	ax,@@v
		mov	@@p,ax
		jmp	@@main_loop

@@loop_w:	mov	@@w,ax
		inc	si

; compute minimum size table less than or equal to *m bits
;
		mov	ax,@@g		; upper limit
		sub	ax,@@w
		mov	@@z,ax
		les	bx,@@m
		cmp	ax,ES:[bx]
		jbe	SHORT @@trykwbit
		mov	ax,ES:[bx]
		mov	@@z,ax

@@trykwbit:	mov	ax,@@k
		sub	ax,@@w
		mov	di,ax
		mov	cx,ax
		mov	ax,1
		shl	ax,cl
		mov	@@f,ax
		mov	dx,@@a
		inc	dx
		cmp	ax,dx
		jbe	SHORT @@kw_table

		sub	@@f,dx
		lea	bx,@@c
		mov	ax,@@k
		add	ax,ax
		add	bx,ax

@@deduct_code:	mov	ax,@@z
		inc	di
		cmp	di,ax
		jnb	SHORT @@kw_table
		mov	ax,@@f
		add	ax,ax
		mov	@@f,ax
		add	bx,2
		cmp	ax,SS:[bx]
		jbe	SHORT @@kw_table
		mov	ax,SS:[bx]
		sub	@@f,ax
		jmp	SHORT @@deduct_code

@@kw_table:	mov	ax,@@w
		add	ax,di
		cmp	ax,@@el
		jbe	SHORT @@set_jentries
		mov	ax,@@el
		cmp	@@w,ax
		jae	SHORT @@set_jentries
		sub	ax,@@w
		mov	di,ax

@@set_jentries:	mov	ax,1
		mov	cx,di
		shl	ax,cl
		mov	@@z,ax

		mov	bx,si
		add	bx,bx
		add	bx,@@l
		mov	SS:[bx],di

		inc	ax
		add	ax,ax
		mov	dx,ax
		add	ax,ax
		add	ax,dx
		push	ax
		call	malloc
		or	ax,ax
		jnz	SHORT @@link_newtbl
		or	si,si		; not enough memory
		jz	SHORT @@nohuf
		push	@@u
		call	huft_free
@@nohuf:	jmp	@@ermem

@@link_newtbl:	les	bx,@@t		; link to list for huft_free()
		add	ax,6
		mov	@@q,eax
		mov	ES:[bx],eax
		sub	ax,4
		mov	@@t,eax
		les	bx,@@t
		xor	eax,eax
		mov	ES:[bx],eax
		mov	ax,si
		shl	ax,2
		lea	bx,@@u
		add	bx,ax
		mov	eax,@@q
		mov	SS:[bx],eax
		mov	ax,si
		or	ax,ax
		je	SHORT @@end_w

; connect to last table, if there is one
;
		add	ax,ax
		lea	bx,@@x		; save pattern for backing up
		add	bx,ax
		mov	dx,@@i
		mov	SS:[bx],dx
		mov	bx,@@l          ; bits to dump before this table
		add	bx,ax
		sub	bx,2
		mov	cx,SS:[bx]
		mov	@@r.bitcnt,cl
		mov	bx,ax           ; bits in this table
		mov	ax,16
		add	ax,di
		mov	@@r.extra,al

		mov	eax,@@q         ; pointer to this table
		mov	DWORD PTR @@r+2,eax

		mov	ax,@@w
		sub	ax,cx
		mov	dx,ax
		mov	ax,1
		mov	cx,@@w
		shl	ax,cl
		dec	ax
		mov	cx,@@i
		and	cx,ax
		mov	ax,cx
		mov	cx,dx
		shr	ax,cl
		add	ax,ax
		mov	dx,ax
		add	ax,ax
		add	dx,ax
		mov	ax,si
		dec	ax
		shl	ax,2
		lea	bx,@@u          ; connect to last table
		add	bx,ax
		mov	ax,SS:[bx]
		add	ax,dx
		mov	ES,SS:[bx+2]
		mov	bx,ax
		mov	ax,WORD PTR @@r
		mov	ES:[bx],ax
		mov	eax,DWORD PTR @@r+2
		mov	ES:[bx+2],eax

@@end_w:	mov	ax,si
		add	ax,ax
		mov	bx,@@l
		add	bx,ax
		mov	ax,@@w
		add	ax,SS:[bx]
		cmp	ax,@@k
		jge 	SHORT @@table_entry
		jmp	@@loop_w

@@table_entry:	mov	ax,@@k
		sub	ax,@@w
		mov	@@r.bitcnt,al
		mov	ax,@@n
		add	ax,ax
		lea	dx,@@v
		add	ax,dx
		mov	bx,@@p
		cmp	ax,bx
		ja	SHORT @@end_blcode
		mov	@@r.extra,99	; out of values--invalid code
		jmp	SHORT @@fill_code

@@end_blcode:	mov	ax,SS:[bx]
		cmp	ax,@@s
		jae	SHORT @@non_simple
		add	@@p,2
		mov	@@r.ubase,ax    ; simple code is just the value
		mov	@@r.extra,16
		cmp	ax,256          ; 256 is end-of-block code
		jb	SHORT @@fill_code
		mov	@@r.extra,15
		jmp	SHORT @@fill_code

@@non_simple:	add	@@p,2		; non-simple--look up in lists
		sub	ax,@@s
		add	ax,ax
		les	bx,@@e
		add	bx,ax
		mov	dl,ES:[bx]
		mov	@@r.extra,dl
		les	bx,@@d
		add	bx,ax
		mov	ax,ES:[bx]
		mov	@@r.ubase,ax

@@fill_code:	mov	cx,@@k
		sub	cx,@@w
		mov	ax,1
		shl	ax,cl
		mov	@@f,ax
		mov	cx,@@w
		mov	ax,@@i
		shr	ax,cl
		mov	cx,ax
		mov	ES,WORD PTR @@q+2

@@fill_loop:	cmp	cx,@@z
		jnb	SHORT @@do_backwards
		mov	ax,cx
		add	ax,ax
		mov	dx,ax
		add	ax,ax
		add	ax,dx
		mov	bx,WORD PTR @@q
		add	bx,ax
		mov	ax,WORD PTR @@r
		mov	ES:[bx],ax
		mov	eax,DWORD PTR @@r+2
		mov	ES:[bx+2],eax
		add	cx,@@f
		jmp	SHORT @@fill_loop

@@do_backwards:	mov	cx,@@k
		dec	cx
		mov	ax,1
		shl	ax,cl
		mov	cx,ax
		mov	di,@@i
@@increment_i:	test	di,cx
		jz	SHORT @@xor_i
		xor	di,cx
		shr	cx,1
		jmp	SHORT @@increment_i
@@xor_i:	xor	di,cx
		mov	@@i,di
@@update_wh:	mov	ax,1		; backup over finished tables
		mov	cx,@@w
		shl	ax,cl
		dec	ax
		mov	dx,di
		and	dx,ax
		mov	bx,si
		add	bx,bx
		lea	ax,@@x
		add	bx,ax
		cmp	dx,SS:[bx]
		je	SHORT @@loop_a
		dec	si
		mov	ax,si
		add	ax,ax
		mov	bx,@@l
		add	bx,ax
		mov	ax,SS:[bx]
		sub	@@w,ax
		jmp	SHORT @@update_wh

@@loop_a:	mov	ax,@@a
		dec	@@a
		or	ax,ax
		jz 	SHORT @@inc_k
		jmp	@@end_w
@@inc_k:	inc	@@k

@@main_loop:	mov	ax,@@k
		cmp	ax,@@g
		jg 	SHORT @@end_main
		mov	bx,@@k
		add	bx,bx
		lea	ax,@@c
		add	bx,ax
		mov	ax,SS:[bx]
		mov	@@a,ax
		jmp	SHORT @@loop_a

@@end_main:	mov	bx,@@l
		mov	ax,SS:[bx]
		les	bx,@@m
		mov     ES:[bx],ax	; return actual size of base table
		mov	ax,1		; Return true (1) --warning error--
		cmp	@@y,0		; if we were given an incomplete table
		je	SHORT @@retok
		cmp	@@g,1
		je	SHORT @@retok
		jmp	SHORT @@toend
@@ermem:	mov	ax,ER_MEM
		jmp	SHORT @@toend
@@retok:	xor	ax,ax
@@toend:	ret
huft_build	ENDP

; Free the malloc'ed tables built by huft_build(), which makes a linked
; list of the tables it made, with the links in a dummy first entry of
; each table.

huft_free	PROC 	PASCAL
ARG		@@huft:	DWORD 		; table to free
		mov	eax,@@huft
@@prev:		or	eax,eax
		jz	SHORT @@toend
		sub	ax,6
		push	eax
		pop	bx
		pop	ES
		push	DWORD PTR ES:[bx+2]
		push	eax
		call	free
		pop	eax
		jmp	SHORT @@prev
@@toend:	ret
huft_free	ENDP

_TEXT		ENDS

_DATA		SEGMENT

; Tables for deflate from PKZIP's appnote.txt.

		; Order of the bit length code lengths
border		DW	16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15

		; Copy lengths for literal codes 257..285
cplens		DW	3,4,5,6,7,8,9,10,11,13,15,17,19,23,27,31,35,43,51
		DW	59,67,83,99,115,131,163,195,227,258,0,0

		; Extra bits for literal codes 257..285
cplext		DW	0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,5
		DW	5,5,5,0,99,99

		; Copy offsets for distance codes 0..29
cpdist		DW	1,2,3,4,5,7,9,13,17,25,33,49,65,97,129,193,257
		DW	385,513,769,1025,1537,2049,3073,4097,6145,8193
		DW	12289,16385,24577

		; Extra bits for distance codes
cpdext		DW	0,0,0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9
		DW	10,10,11,11,12,12,13,13

mask_bits	DW	0000h
		DW	0001h,0003h,0007h,000fh,001fh,003fh,007fh,00ffh
		DW	01ffh,03ffh,07ffh,0fffh,1fffh,3fffh,7fffh,0ffffh

lbits		DW	9	; bits in base literal/length lookup table
dbits		DW	6       ; bits in base distance lookup table

wp		DW	?
bb		DD	?	; bit buffer
bk		DW	?       ; bits in bit buffer

result		DW	?
fixed_bd	DW	0000h
fixed_bl	DW	0000h
fixed_td	DD	00000000h
fixed_tl	DD	00000000h

cplen2		DW	2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17
		DW	18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34
		DW	35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51
		DW	52,53,54,55,56,57,58,59,60,61,62,63,64,65

cplen3		DW	3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18
		DW	19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35
		DW	36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52
		DW	53,54,55,56,57,58,59,60,61,62,63,64,65,66

exextra		DW	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		DW	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		DW	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		DW	8

cpdist4		DW	1,65,129,193,257,321,385,449,513,577,641,705
		DW	769,833,897,961,1025,1089,1153,1217,1281,1345,1409,1473
		DW	1537,1601,1665,1729,1793,1857,1921,1985,2049,2113,2177
		DW	2241,2305,2369,2433,2497,2561,2625,2689,2753,2817,2881
		DW	2945,3009,3073,3137,3201,3265,3329,3393,3457,3521,3585
		DW	3649,3713,3777,3841,3905,3969,4033

cpdist8		DW	1,129,257,385,513,641,769,897,1025,1153,1281
		DW	1409,1537,1665,1793,1921,2049,2177,2305,2433,2561,2689
		DW	2817,2945,3073,3201,3329,3457,3585,3713,3841,3969,4097
		DW	4225,4353,4481,4609,4737,4865,4993,5121,5249,5377,5505
		DW	5633,5761,5889,6017,6145,6273,6401,6529,6657,6785,6913
		DW	7041,7169,7297,7425,7553,7681,7809,7937,8065

_DATA		ENDS

		END
