/* ARJREAD.C--
 * Copyright (c) 2001 Hjort Nidudsson
 *
 * Change history:
 * 20 Apr 2001	- Read ARJ archive
 */

#include <io.h>
#include <string.h>
#include <arch.h>

static int arj_readentry(ARJ *p, int h)
{
	int result;

	if (osread(h, p, sizeof(ARJ)) != sizeof(ARJ))
		return 0;
	_ASSERT(p->type == 2);
	_ASSERT(p->type == 4);
	_ASSERT(p->flag & ARJBACKUP);
	if (p->id != ARJHEADERID)
		return 0;
	if (p->size_head - 34 > WMAXPATH)
		result = osread(h, entryname, WMAXPATH);
	else
		result = osread(h, entryname, p->size_head - 30);
	if (lseek(h, 4L + p->size_head - result - 30, SEEK_CUR) == -1)
		return 0;
	if (osread(h, &result, 2) != 2)
		return 0;
	if (result) { /* Seek to start of next entry */
		if (lseek(h, p->compressed_size + result + 4L, SEEK_CUR) == -1)
			return 0;
	} else {
		if (lseek(h, p->compressed_size, SEEK_CUR) == -1)
			return 0;
	}
	unixtodos(entryname);
	return 1;
}

int warjread(WSUB *q)
{
	fblk *	b;
	ARJ 	entry;
	int	h,extsize;

	wsfree(q);
	if (openarch(q->path, q->file) == 0)
		return ARCHIVE_ERROR;
	h = _ios[__STDI].file;
	ofreest(OSTDI);
	if (osread(h, &entry, ARJHEADERVSIZE) != ARJHEADERVSIZE)
		goto out_error;
	if (entry.id != ARJHEADERID)
		goto out_error;
	if (lseek(h, 8L + entry.size_head, SEEK_SET) == -1L)
		goto out_error;
	if (osread(h, &extsize, 2) != 2)
		goto out_error;
	if (extsize) {
		if (lseek(h, 4L + extsize, SEEK_CUR) == -1L)
			goto out_error;
	}
	if (arj_readentry(&entry, h) == 0)
		goto out_error;
	q->count = 1;
	q->fcb[0] = fbupdir(_A_ARJ);
	do {
		b = wsaddentry(q, _A_ARJ,
			entry.time, entry.date, entry.original_size);
		if (b == NULL)
			continue;
		if (!ISSUBDIR(b->flag) && !*q->flag & _W_LONGNAME)
			strlwr(b->name);
		if (++q->count >= q->maxfb)
			break;
	} while (arj_readentry(&entry, h));
	close(h);
	return q->count;
out_error:
	close(h);
	return ARCHIVE_ERROR;
}
