/* TDIALOG.H--
 * Copyright (c) 2002 Hjort Nidudsson
 *
 * Change history:
 * 18 Apr 2002	- Created
 */
#ifndef __INC_TDIALOG
#define __INC_TDIALOG
#if !defined(__INC_TWINDOW)
 #include <twindow.h>
#endif

#ifdef __cplusplus
 extern "C" {
#endif

extern DOBJ * _CType tdialog;
extern LOBJ * _CType tdllist;

extern BYTE _CType tmaxascii;
extern BYTE _CType tminascii;
extern BYTE _CType tclrascii;

extern int (* _CType thelp)(void);
extern int (* _CType tupdate)(void);
extern int (* _CType tgetevent)(void);

#define tdhide 	twhide
#define tdshow 	twshow
#define tdclose	twclose

DOBJ *_CType rsopen(ROBJ *);
int _CType rsmodal(ROBJ *);
int _CType rsevent(ROBJ *, DOBJ *);
int _CType rsreload(ROBJ *, DOBJ *);

int _CType tdopen(DOBJ *);
int _CType tdinit(DOBJ *);
int _CType tdevent(DOBJ *);
int _CType tdlevent(DOBJ *, LOBJ *);
int _CType tdinitobj(DOBJ *, TOBJ *);
int _CType tdmodal(DOBJ *);
int _CType tdmemsize(DOBJ *);

int _CType getevent(void);
int _CType tupdtime(void);
int _CType tupddate(void);

int _cdecl ermsg(const char *, const char *, ...);
int _cdecl stdmsg(const char *, const char *, ...);

int _CType tdedit(char *__bp, RECT __sc, int __bsize);
int _CType tgetline(const char *__title, char *__buf, int __lsize, int __bsize);
int _CType getxys(int, int, char *, int __lsize, int __bsize);

void _CType pbuttms(int __x, int __y, int __len);
void _CType pbuttset(int __x, int __y, int __len);
void _CType pbuttclr(int __x, int __y, int __len);

void _CType tdsetbitflag(TOBJ *, int __count, WORD __flag, DWORD __bitflag);
DWORD _CType tdgetbitflag(TOBJ *, int __count, WORD __flag);

void _CType scroll_delay(void);

int _CType tdpbuttevent(void);
int _CType tdxcellevent(void);
int _CType tdradioevent(void);
int _CType tdcheckevent(void);
int _CType tdteditevent(void);

typedef struct {
	char *	bp;
	RECT	rc;
	int	bcol;
	int	xpos;
	int	wpos;
	char *	clst;
	char *	clen;
	int	clat;
      } TINFO;

int tihndlevent(TINFO *, int __event);

#ifdef __cplusplus
 }
#endif
#endif /* __INC_TDIALOG */