#include "kernel.h"
#include "internal.h"

int GSScreenWidth		= 0;
int GSScreenHeight		= 0;
int GSScreenDepth		= 0;
int GSScreenRefreshRate	= 0;

//l_ulong FadeTime = 250;
p_bitmap StartLogo = NULL;
TRect StartRect;
//
#define FADE_SPEED			15
//
void ScreenCrazyFadeToBlack ( void )
{
	   p_bitmap bmp   = create_bitmap( GSScreenWidth, GSScreenHeight );
	   p_bitmap trans = create_bitmap( GSScreenWidth, GSScreenHeight );
	   l_int i;
	   //
	   if ( !bmp || !trans )
	   {
		  clear_bitmap( screen );
		  return;
	   }
	   //
	   blit( screen, bmp, 0, 0, SCREEN_W-GSScreenWidth, SCREEN_H-GSScreenHeight, GSScreenWidth, GSScreenHeight );
	   RectAssign(&StartRect,(GSScreenWidth-bmp->w)/2,(GSScreenHeight-bmp->h)/2,(GSScreenWidth-bmp->w)/2+bmp->w-1,(GSScreenHeight-bmp->h)/2+bmp->h-1);
	   set_clip(screen,StartRect.a.x,StartRect.a.y,StartRect.b.x,StartRect.b.y);
	   set_trans_blender(0, 0, 0, 255);
	   for( i = 0; i <= 255; i += FADE_SPEED )
	   {
		  draw_lit_sprite(trans, bmp, 0, 0, i);
		  draw_sprite(screen,trans,StartRect.a.x,StartRect.a.y);
	   }
	   destroy_bitmap( trans );
	   destroy_bitmap( bmp );
	   clear_bitmap( screen );
}
//
l_bool __ScreenRestartGraphics ( void )
{
//	fade_out(4);
	set_color_depth(GSScreenDepth);
	request_refresh_rate(GSScreenRefreshRate);
	if (set_gfx_mode(GFX_AUTODETECT, GSScreenWidth, GSScreenHeight, 0, 0)< 0)
	{
		DebugFatal("Unable to restart screen...");
		return false;
	}
	return true;
}

l_bool __ScreenTextMode ( void )
{
//	ScreenCrazyFadeToBlack();
	set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
	return true;
}

/**
*	NAME:	GSSystemScreenInit
*	DESCRIPTION: Initializes the screen and graphics mode using the values set
*					in the registry.
*	RETURN: 0 on success, else -1
*/
l_int GSSystemScreenInit( l_int fa )
{
	if ( !fa )
	   MsgInit("GSSystemScreenInit");
	//
	if ( KernelMode == KERNEL_RESETUP )
	{
		l_int c = 0;
		//
		printf("\nSeleccionar Nuevo Modo de Video.");
		printf("\nPor Favor Seleccione un Nuevo Modo para el Video :\n");
		printf("1   640x480\n");
		printf("2   800x600\n");
		printf("3  1024x768\n");
		printf("4  1152x864\n");
		printf("5  1280x1024\n");

		while ( !c )
		{
			c = readkey() & 0xFF;
			if ( c == '1' ) { GSScreenWidth = 640;  GSScreenHeight = 480; }
			else if ( c == '2' ) { GSScreenWidth = 800;  GSScreenHeight = 600; }
			else if ( c == '3' ) { GSScreenWidth = 1024; GSScreenHeight = 768; }
			else if ( c == '4' ) { GSScreenWidth = 1152; GSScreenHeight = 864; }
			else if ( c == '5' ) { GSScreenWidth = 1280; GSScreenHeight = 1024; }
			else c = 0;
		}

		printf("\nPor Favor Seleccione la Cantidad de Colores :\n");
		printf("1  256 Colors  (8 bpp)\n");
		printf("2  High Colors (15 bpp)\n");
		printf("3  High Colors (16 bpp)\n");
		printf("4  True Colors (24 bpp)\n");
		printf("5  True Colors (32 bpp)\n");

		c = 0;

		while ( !c )
		{
			c = readkey() & 0xFF;
			if ( c == '1' ) { GSScreenDepth = 8;  }
			else if ( c == '2' ) { GSScreenDepth = 15; }
			else if ( c == '3' ) { GSScreenDepth = 16; }
			else if ( c == '4' ) { GSScreenDepth = 24; }
			else if ( c == '5' ) { GSScreenDepth = 32; }
			else c = 0;
		}
	}
	else if ( KernelMode == KERNEL_SAFE )
	{
		GSScreenWidth 	= 640;
		GSScreenHeight 	= 480;
		GSScreenDepth 	= 16;
		GSScreenRefreshRate = 60;
	}
	else
	{
		GSScreenWidth 		= KeyGetInt("/SYSTEM/SCREEN/WIDTH",800);
		GSScreenHeight 		= KeyGetInt("/SYSTEM/SCREEN/HEIGHT",600);
		GSScreenDepth 		= KeyGetInt("/SYSTEM/SCREEN/DEPTH",16);
		GSScreenRefreshRate	= KeyGetInt("/SYSTEM/SCREEN/REFRESH",60);
	}
	//
	DebugMessage("Initializing screen by these parameters:");
	DebugMessage("- Width:\t\t%i", GSScreenWidth);
	DebugMessage("- Height:\t\t%i", GSScreenHeight);
	DebugMessage("- Depth:\t\t%i", GSScreenDepth);
	DebugMessage("- Refresh Rate:\t\t%i", GSScreenRefreshRate);
	DebugMessage("Installing screen...");

	/**
	 * Set color depth
	 */
	set_color_depth(GSScreenDepth);

	/**
	 * Request refresh rate
	 */
	request_refresh_rate(GSScreenRefreshRate);
	//
	if ( !fa )
	{
	   MsgInitOk();
	   fade_out(1);
	}
	//
	if (set_gfx_mode(GFX_AUTODETECT, GSScreenWidth, GSScreenHeight, 0, 0)< 0)
	{
		GSScreenWidth 	= 640;
		GSScreenHeight 	= 480;
		GSScreenDepth 	= 16;

		set_color_depth(GSScreenDepth);
		if (set_gfx_mode(GFX_AUTODETECT, GSScreenWidth, GSScreenHeight, 0, 0)< 0)
		{
			/**
			*	No graphic mode has been able to be set
			*/
			DebugFatal("Unable to initialise graphics mode");
			return -1;
		}
	}

	if (get_refresh_rate() != GSScreenRefreshRate)
	{
		DebugError("Could not set requested refresh rate, using %iHz instead", get_refresh_rate());
	}

	set_color_conversion( COLORCONV_TOTAL );//| COLORCONV_KEEP_TRANS );
	//
	if ( !fa )
	{
	StartLogo = LoadImage("start.png");
	//
	if ( StartLogo )
	{
	   p_bitmap trans = create_bitmap( GSScreenWidth, GSScreenHeight );
	   l_int i;
	   //
	   if ( StartLogo && StartLogo->w > GSScreenWidth )
	   {
		  p_bitmap b = create_bitmap( GSScreenWidth, GSScreenHeight );
		  //
		  if ( b )
		  {
			 stretch_blit( StartLogo, b, 0, 0, StartLogo->w, StartLogo->h, 0, 0, b->w, b->h );
			 destroy_bitmap( StartLogo );
			 StartLogo = create_bitmap( b->w, b->h );
			 if( StartLogo )
			 {
				blit( b, StartLogo, 0, 0, 0, 0, b->w, b->h );
			 }
			 else
				return 0;
		  }
		  else
			 return 0;
	   }
	   //
	   RectAssign(&StartRect,(GSScreenWidth-StartLogo->w)/2,(GSScreenHeight-StartLogo->h)/2,(GSScreenWidth-StartLogo->w)/2+StartLogo->w-1,(GSScreenHeight-StartLogo->h)/2+StartLogo->h-1);
	   set_clip(screen,StartRect.a.x,StartRect.a.y,StartRect.b.x,StartRect.b.y);
	   set_trans_blender(0, 0, 0, 0);
	   for( i = 255; i >= 0; i -= FADE_SPEED )
	   {
		  draw_lit_sprite( trans, StartLogo, 0, 0, i );
		  draw_sprite(screen,trans,StartRect.a.x,StartRect.a.y);
	   }
	   destroy_bitmap( trans );
	}
	}
	//
	return 0;
}
//
l_int GSSystemScreenDone( void )
{
	MsgInit( "GSSystemScreenDone" );
	__MouseStop();
	DebugMessage ("Cerrando screen...");
	ScreenCrazyFadeToBlack();
	DebugMessage ("Screen done.");
	__ScreenTextMode();
	MsgInit( "GSSystemScreenDone" );
	MsgInitOk();
	//
	return 0;
}
