#include <stdint.h>
//
#define MPEG3_FLOAT32            float
#define MPEG3_INT16              short int
#define MPEG3_INT32              int
#define MPEG3_INT64              long
#define MPEG3_TOC_PREFIX         0x544f4356
#define MPEG3_TOC_PREFIXLOWER    0x746f6376
#define MPEG3_ID3_PREFIX         0x494433
#define MPEG3_RIFF_CODE          0x52494646
#define MPEG3_TS_PACKET_SIZE     188
#define MPEG3_DVD_PACKET_SIZE    0x800
#define MPEG3_SYNC_BYTE          0x47
#define MPEG3_PACK_START_CODE    0x000001ba
#define MPEG3_SEQUENCE_START_CODE  0x000001b3
#define MPEG3_SEQUENCE_END_CODE  0x000001b7
#define MPEG3_SYSTEM_START_CODE  0x000001bb
#define MPEG3_STRLEN             1024
#define MPEG3_PIDMAX             20 
#define MPEG3_PROGRAM_ASSOCIATION_TABLE        0x00
#define MPEG3_CONDITIONAL_ACCESS_TABLE       0x01
#define MPEG3_PACKET_START_CODE_PREFIX       0x000001
#define MPEG3_PRIVATE_STREAM_2   0xbf
#define MPEG3_PADDING_STREAM     0xbe
#define MPEG3_GOP_START_CODE     0x000001b8
#define MPEG3_PICTURE_START_CODE 0x00000100
#define MPEG3_EXT_START_CODE     0x000001b5
#define MPEG3_USER_START_CODE    0x000001b2
#define MPEG3_SLICE_MIN_START    0x00000101
#define MPEG3_SLICE_MAX_START    0x000001af
#define MPEG3_AC3_START_CODE     0x0b77
#define MPEG3_PCM_START_CODE     0x0180
#define MPEG3_MAX_CPUS           256
#define MPEG3_MAX_STREAMS        256
#define MPEG3_MAX_PACKSIZE       262144
#define MPEG3_CONTIGUOUS_THRESHOLD   10 
#define MPEG3_PROGRAM_THRESHOLD  5 
#define MPEG3_SEEK_THRESHOLD     16 
#define AUDIO_UNKNOWN            0
#define AUDIO_MPEG               1
#define AUDIO_AC3                2
#define AUDIO_PCM                3
#define AUDIO_AAC                4
#define AUDIO_JESUS              5
#define MAXFRAMESIZE             1792
#define HDRCMPMASK               0xfffffd00
#define SBLIMIT                  32
#define SSLIMIT                  18
#define SCALE_BLOCK              12
#define MPEG3AUDIO_PADDING       1024
#define MPG_MD_STEREO            	0
#define MPG_MD_JOINT_STEREO      	1
#define MPG_MD_DUAL_CHANNEL      	2
#define MPG_MD_MONO              	3
//
#define AC3_N                    512
#define MAX_AC3_FRAMESIZE        1920 * 2 + 512
//
#define MPEG3_EXP_REUSE          ( 0 )
#define MPEG3_EXP_D15            ( 1 )
#define MPEG3_EXP_D25            ( 2 )
#define MPEG3_EXP_D45            ( 3 )
#define DELTA_BIT_REUSE          ( 0 )
#define DELTA_BIT_NEW            ( 1 )
#define DELTA_BIT_NONE           ( 2 )
#define DELTA_BIT_RESERVED       ( 3 )
//
#define CHROMA420                1 
#define CHROMA422                2
#define CHROMA444                3
#define TOP_FIELD                1 
#define BOTTOM_FIELD             2
#define FRAME_PICTURE            3
#define SEQ_ID                   1 
#define DISP_ID                  2
#define QUANT_ID                 3
#define SEQSCAL_ID               5
#define PANSCAN_ID               7
#define CODING_ID                8
#define SPATSCAL_ID              9
#define TEMPSCAL_ID              10
#define MPERROR                  ( -1 )
#define SC_NONE                  0 
#define SC_DP                    1
#define SC_SPAT                  2
#define SC_SNR                   3
#define SC_TEMP                  4
#define I_TYPE                   1 
#define P_TYPE                   2
#define B_TYPE                   3
#define D_TYPE                   4
#define MB_INTRA                 1 	
#define MB_PATTERN               2
#define MB_BACKWARD              4
#define MB_FORWARD               8
#define MB_QUANT                 16
#define MB_WEIGHT                32
#define MB_CLASS4                64
#define MC_FIELD                 1 
#define MC_FRAME                 2
#define MC_16X8                  2
#define MC_DMV                   3
#define MV_FIELD                 0 
#define MV_FRAME                 1
#define CLIP(                    x ) ( ( x ) >= 0 ? ( ( x ) < 255 ? ( x ) : 255 ) : 0 )
//
#define WINDOWS_POST             	0	
#define WINDOWS_SEND             	1	
#define WINDOWS_HWND             	2
//
#define A52_CHANNEL              0
#define A52_MONO                 1
#define A52_STEREO               2
#define A52_3F                   3
#define A52_2F1R                 4
#define A52_3F1R                 5
#define A52_2F2R                 6
#define A52_3F2R                 7
#define A52_CHANNEL1             8
#define A52_CHANNEL2             9
#define A52_DOLBY                10
#define A52_CHANNEL_MASK         15
#define A52_LFE                  16
#define A52_ADJUST_LEVEL         32
//
#define MM_ACCEL_DJBFFT          	0x00000001
/***************************************************************************/
struct mpeg_block 
{
   char huh;
};
struct mpeg_playkey 
{
   char huh;
};
typedef struct
{
   char huh;
} mpeg_css_t;
typedef struct
{
   FILE *fd;
   mpeg_css_t *css; 
   char path[ MPEG3_STRLEN ];
   long current_byte;
   long total_bytes;
} mpeg_fs_t;
typedef struct
{
   long start_byte;
   double start_time;
   double absolute_start_time;
   double absolute_end_time;
   long end_byte;
   double end_time;
   int program;
} mpeg_demux_timecode_t;
typedef struct
{
   void *file_mpeg;
   mpeg_fs_t *fs;
   long total_bytes; 
   mpeg_demux_timecode_t *timecode_table;
   long timecode_table_size; 
   long timecode_table_allocation; 
} mpeg_title_t;
typedef struct
{
   void* file_mpeg;
   unsigned char *raw_data;
   long raw_offset;
   int raw_size;
   long packet_size;
   int do_audio;
   int do_video;
   unsigned char *data_buffer;
   long data_size;
   long data_position;
   long data_allocated;
   int reverse;
   int error_flag;
   unsigned char next_char;
   double time_offset;
   int generating_timecode;
   mpeg_title_t *titles[ MPEG3_MAX_STREAMS ];
   int total_titles;
   int current_title;
   int astream_table[ MPEG3_MAX_STREAMS ]; 
   int vstream_table[ MPEG3_MAX_STREAMS ]; 
   int total_programs;
   int current_program;
   int current_timecode;
   long current_byte;
   int transport_error_indicator;
   int payload_unit_start_indicator;
   int pid;
   int transport_scrambling_control;
   int adaptation_field_control;
   int continuity_counter;
   int is_padding;
   int pid_table[ MPEG3_PIDMAX ];
   int continuity_counters[ MPEG3_PIDMAX ];
   int total_pids;
   int adaptation_fields;
   double time; 
   int audio_pid;
   int video_pid;
   int astream; 
   int vstream; 
   int aformat; 
   long program_association_tables;
   int table_id;
   int section_length;
   int transport_stream_id;
   long pes_packets;
   double pes_audio_time; 
   double pes_video_time; 
} mpeg_demuxer_t;
typedef struct
{
   unsigned MPEG3_INT32 bfr; 
   int bit_number; 
   int bfr_size; 
   void *file_mpeg; 
   mpeg_demuxer_t *demuxer; 
   unsigned char *input_ptr;
} mpeg_bits_t;
//
typedef struct
{
   float real;
   float imag;
} mpeg_complex_t;
//
typedef struct 
{
   unsigned short blksw[ 5 ];
   unsigned short dithflag[ 5 ];
   int dynrnge;
   int dynrng;
   int dynrng2e;
   int dynrng2;
   int cplstre;
   int cplinu;
   unsigned short chincpl[ 5 ];
   int phsflginu;
   int cplbegf;
   int cplendf;
   unsigned short cplbndstrc[ 18 ];
   unsigned short cplcoe[ 5 ];
   unsigned short mstrcplco[ 5 ];
   unsigned short cplcoexp[ 5 ][ 18 ];
   unsigned short cplcomant[ 5 ][ 18 ];
   unsigned short phsflg[ 18 ];
   unsigned int rematstr;
   unsigned short rematflg[ 4 ];
   int cplexpstr;
   unsigned short chexpstr[ 5 ];
   int lfeexpstr;
   unsigned short chbwcod[ 5 ];
   int cplabsexp;
   unsigned short cplexps[ 18 * 12 / 3 ];
   unsigned short exps[ 5 ][ 252 / 3 ];
   unsigned short gainrng[ 5 ];
   unsigned short lfeexps[ 3 ];
   int baie;
   int sdcycod;
   int fdcycod;
   int sgaincod;
   int dbpbcod;
   int floorcod;
   int snroffste;
   int csnroffst;
   int cplfsnroffst;
   int cplfgaincod;
   unsigned short fsnroffst[ 5 ];
   unsigned short fgaincod[ 5 ];
   int lfefsnroffst;
   int lfefgaincod;
   int cplleake;
   int cplfleak;
   int cplsleak;
   int deltbaie;
   int cpldeltbae;
   unsigned short deltbae[ 5 ];
   int cpldeltnseg;
   unsigned short cpldeltoffst[ 8 ];
   unsigned short cpldeltlen[ 8 ];
   unsigned short cpldeltba[ 8 ];
   unsigned short deltnseg[ 5 ];
   unsigned short deltoffst[ 5 ][ 8 ];
   unsigned short deltlen[ 5 ][ 8 ];
   unsigned short deltba[ 5 ][ 8 ];
   int skiple;
   int skipl;
   short chmant[ 5 ][ 256 ];
   unsigned short cplmant[ 256 ];
   unsigned short lfemant[ 7 ];
   int ncplsubnd;
   int ncplbnd;
   int nchgrps[ 5 ];
   int ncplgrps;
   unsigned short endmant[ 5 ];
   int cplstrtmant;
   int cplendmant;
   unsigned short fbw_exp[ 5 ][ 256 ];
   unsigned short cpl_exp[ 256 ];
   unsigned short lfe_exp[ 7 ];
   unsigned short fbw_bap[ 5 ][ 256 ];
   unsigned short cpl_bap[ 256 ];
   unsigned short lfe_bap[ 7 ];
} mpeg_ac3audblk_t;
typedef struct
{
   int sdecay;
   int fdecay;
   int sgain;
   int dbknee;
   int floor;
   short psd[ 256 ];
   short bndpsd[ 256 ];
   short excite[ 256 ];
   short mask[ 256 ];
} mpeg_ac3_bitallocation_t;
typedef struct
{
   unsigned short m_1[ 3 ];
   unsigned short m_2[ 3 ];
   unsigned short m_4[ 2 ];
   unsigned short m_1_pointer;
   unsigned short m_2_pointer;
   unsigned short m_4_pointer;
} mpeg_ac3_mantissa_t;
typedef struct
{
   int bsid;	
   int bsmod;
   int acmod;
   int cmixlev;
   int surmixlev;
   int dsurmod;
   int lfeon;
   int dialnorm;
   int compre;
   int compr;
   int langcode;
   int langcod;
   unsigned int audprodie;
   int mixlevel;
   int roomtyp;
   int dialnorm2;
   int compr2e;
   int compr2;
   int langcod2e;
   int langcod2;
   int audprodi2e;
   int mixlevel2;
   int roomtyp2;
   int copyrightb;
   int origbs;
   int timecod1e;
   unsigned int timecod1;
   int timecod2e;
   unsigned int timecod2;
   int addbsie;
   int addbsil;
   unsigned char addbsi[ 64 ];
   int nfchans;
} mpeg_ac3bsi_t;
struct al_table 
{
   short bits;
   short d;
};
//
typedef float mpeg_ac3_stream_samples_t[ 6 ][ 256 ];
//
typedef struct
{
   void* file_mpeg;
   void* track;
   mpeg_bits_t *astream;
   int format; 
   int layer; 
   int channels;
   long outscale;
   long framenum;
   long prev_framesize;
   long framesize; 
   float avg_framesize; 
   float *pcm_sample; 
   int pcm_point; 
   long pcm_position; 
   long pcm_size; 
   long pcm_allocated; 
   int sample_seek;
   double percentage_seek;
   unsigned long oldhead;
   unsigned long newhead;
   unsigned long firsthead;
   int bsnum;
   int lsf;
   int mpeg_5;
   int sampling_frequency_code;
   int bitrate_index;
   int bitrate;
   int samples_per_frame;
   int padding;
   int extension;
   int mode;
   int mode_ext;
   int copyright;
   int original;
   int emphasis;
   int error_protection;
   unsigned char bsspace[ 2 ][ MAXFRAMESIZE + 512 ]; 
   unsigned char *bsbuf, *bsbufold;
   long ssize;
   int init;
   int single;
   struct al_table *alloc;
   int II_sblimit;
   int jsbound;
   int bo; 
   float synth_stereo_buffs[ 2 ][ 2 ][ 0x110 ];
   float synth_mono_buff[ 64 ];
   unsigned int layer2_scfsi_buf[ 64 ];
   float mp3_block[ 2 ][ 2 ][ SBLIMIT * SSLIMIT ];
   int mp3_blc[ 2 ];
   unsigned int ac3_framesize_code;
   mpeg_ac3bsi_t ac3_bsi;
   mpeg_ac3audblk_t ac3_audblk;
   mpeg_ac3_bitallocation_t ac3_bit_allocation;
   mpeg_ac3_mantissa_t ac3_mantissa;
   mpeg_complex_t ac3_imdct_buf[ AC3_N / 4 ];
   float ac3_delay[ 6 ][ AC3_N / 2 ];
   mpeg_complex_t *ac3_w[ 7 ];
   mpeg_complex_t ac3_w_1[ 1 ];
   mpeg_complex_t ac3_w_2[ 2 ];
   mpeg_complex_t ac3_w_4[ 4 ];
   mpeg_complex_t ac3_w_8[ 8 ];
   mpeg_complex_t ac3_w_16[ 16 ];
   mpeg_complex_t ac3_w_32[ 32 ];
   mpeg_complex_t ac3_w_64[ 64 ];
   int ac3_lfsr_state;
   unsigned char ac3_buffer[ MAX_AC3_FRAMESIZE ];
   mpeg_ac3_stream_samples_t ac3_samples;
} mpeg_audio_t;
//
typedef struct
{
   int channels;
   int sample_rate;
   mpeg_demuxer_t *demuxer;
   mpeg_audio_t *audio;
   long current_position;
   long total_samples;
} mpeg_atrack_t;
typedef struct
{
   unsigned char *data;
   int buffer_size; 
   int buffer_allocation; 
   int current_position; 
   unsigned MPEG3_INT32 bits;
   int bits_size;
   int done; 
} mpeg_slice_buffer_t;
//
typedef struct
{
   void *video; 
   mpeg_slice_buffer_t *slice_buffer;
   int thread_number; 
   int current_buffer; 
   int buffer_step; 
   int last_buffer; 
   int fault;
   int done;
   int quant_scale;
   int pri_brk;
   short block[ 12 ][ 64 ];
   int sparse[ 12 ];
} mpeg_slice_t;
//
typedef struct 
{
   long hour;
   long minute;
   long second;
   long frame;
} mpeg_timecode_t;
//
typedef struct
{
   void* file_mpeg;
   void* track;
   mpeg_bits_t *vstream;
   int decoder_initted;
   unsigned char **output_rows; 
   int in_x, in_y, in_w, in_h, out_w, out_h;
   int *x_table, *y_table; 
   int color_model;
   int want_yvu; 
   char *y_output, *u_output, *v_output; 
   mpeg_slice_t slice_decoders[ MPEG3_MAX_CPUS ]; 
   int total_slice_decoders; 
   mpeg_slice_buffer_t slice_buffers[ MPEG3_MAX_CPUS ]; 
   int total_slice_buffers; 
   int slice_buffers_initialized; 
   int blockreadsize;
   long maxframe; 
   double percentage_seek; 
   int frame_seek; 
   long framenum; 
   long last_number; 
   int found_seqhdr;
   long bitrate;
   mpeg_timecode_t gop_timecode; 
   long frames_per_gop; 
   long first_gop_frames;
   long first_frame; 
   long last_frame; 
   unsigned char *yuv_buffer[ 5 ]; 
   unsigned char *oldrefframe[ 3 ], *refframe[ 3 ], *auxframe[ 3 ];
   unsigned char *llframe0[ 3 ], *llframe1[ 3 ];
   unsigned char *mpeg_zigzag_scan_table;
   unsigned char *mpeg_alternate_scan_table;
   unsigned char **output_src;
   unsigned char *newframe[ 3 ];
   int horizontal_size, vertical_size, mb_width, mb_height;
   int coded_picture_width, coded_picture_height;
   int chroma_format, chrom_width, chrom_height, blk_cnt;
   int pict_type;
   int forw_r_size, back_r_size, full_forw, full_back;
   int prog_seq, prog_frame;
   int h_forw_r_size, v_forw_r_size, h_back_r_size, v_back_r_size;
   int dc_prec, pict_struct, topfirst, frame_pred_dct, conceal_mv;
   int intravlc;
   int repeatfirst;
   int repeat_count;
   int current_repeat; 
   int secondfield;
   int skip_bframes;
   int stwc_table_index, llw, llh, hm, hn, vm, vn;
   int lltempref, llx0, lly0, llprog_frame, llfieldsel;
   int matrix_coefficients;
   int framerate_code;
   float frame_rate;
   long *cr_to_r, *cr_to_g, *cb_to_g, *cb_to_b;
   long *cr_to_r_ptr, *cr_to_g_ptr, *cb_to_g_ptr, *cb_to_b_ptr;
   int intra_quantizer_matrix[ 64 ], non_intra_quantizer_matrix[ 64 ];
   int chroma_intra_quantizer_matrix[ 64 ], chroma_non_intra_quantizer_matrix[ 64 ];
   int mpeg_2;
   int qscale_type, altscan; 
   int pict_scal; 
   int scalable_mode; 
} mpeg_video_t;
//
typedef struct
{
   int width;
   int height;
   float frame_rate;
   mpeg_demuxer_t *demuxer;
   mpeg_video_t *video;
   long current_position; 
   long total_frames; 
} mpeg_vtrack_t;
typedef struct
{
   mpeg_fs_t *fs; 
   mpeg_demuxer_t *demuxer; 
   int has_audio;
   int has_video;
   int total_astreams;
   int total_vstreams;
   mpeg_atrack_t *atrack[ MPEG3_MAX_STREAMS ];
   mpeg_vtrack_t *vtrack[ MPEG3_MAX_STREAMS ];
   int is_transport_stream;
   int is_program_stream;
   int is_audio_stream; 
   int is_video_stream; 
   long packet_size;
   int last_type_read; 
   int last_stream_read;
   int program; 
   int cpus;
} MPEG;
typedef struct a52_state_s a52_state_t;
//
typedef struct
{
   mpeg_bits_t *stream;
   int samplerate;
   int bitrate;
   int flags;
   int channels;
   void *state; 
   void *output; 
   int framesize;
} mpeg_ac3_t;
struct newhuff 
{
   unsigned int linbits;
   short *table;
};
static short mpeg_tab0[] = 
{
   0
};
static short mpeg_tab1[] =
{
   -5, -3, -1, 17, 1, 16, 0
};
static short mpeg_tab2[] =
{
   -15, -11, -9, -5, -3, -1, 34, 2, 18, -1, 33, 32, 17, -1, 1, 
   16, 0
};
static short mpeg_tab3[] =
{
   -13, -11, -9, -5, -3, -1, 34, 2, 18, -1, 33, 32, 16, 17, -1, 
   1, 0
};
static short mpeg_tab5[] =
{
   -29, -25, -23, -15, -7, -5, -3, -1, 51, 35, 50, 49, -3, -1, 19, 
   3, -1, 48, 34, -3, -1, 18, 33, -1, 2, 32, 17, -1, 1, 16, 
   0
};
static short mpeg_tab6[] =
{
   -25, -19, -13, -9, -5, -3, -1, 51, 3, 35, -1, 50, 48, -1, 19, 
   49, -3, -1, 34, 2, 18, -3, -1, 33, 32, 1, -1, 17, -1, 16, 
   0
};
static short mpeg_tab7[] =
{
   -69, -65, -57, -39, -29, -17, -11, -7, -3, -1, 85, 69, -1, 84, 83, 
   -1, 53, 68, -3, -1, 37, 82, 21, -5, -1, 81, -1, 5, 52, -1,
   80, -1, 67, 51, -5, -3, -1, 36, 66, 20, -1, 65, 64, -11, -7, 
   -3, -1, 4, 35, -1, 50, 3, -1, 19, 49, -3, -1, 48, 34, 18, 
   -5, -1, 33, -1, 2, 32, 17, -1, 1, 16, 0
};
static short mpeg_tab8[] =
{
   -65, -63, -59, -45, -31, -19, -13, -7, -5, -3, -1, 85, 84, 69, 83, 
   -3, -1, 53, 68, 37, -3, -1, 82, 5, 21, -5, -1, 81, -1, 52, 
   67, -3, -1, 80, 51, 36, -5, -3, -1, 66, 20, 65, -3, -1, 4, 
   64, -1, 35, 50, -9, -7, -3, -1, 19, 49, -1, 3, 48, 34, -1, 
   2, 32, -1, 18, 33, 17, -3, -1, 1, 16, 0
};
static short mpeg_tab9[] =
{
   -63, -53, -41, -29, -19, -11, -5, -3, -1, 85, 69, 53, -1, 83, -1, 
   84, 5, -3, -1, 68, 37, -1, 82, 21, -3, -1, 81, 52, -1, 67, 
   -1, 80, 4, -7, -3, -1, 36, 66, -1, 51, 64, -1, 20, 65, -5, 
   -3, -1, 35, 50, 19, -1, 49, -1, 3, 48, -5, -3, -1, 34, 2, 
   18, -1, 33, 32, -3, -1, 17, 1, -1, 16, 0
};
static short mpeg_tab10[] =
{
   -125, -121, -111, -83, -55, -35, -21, -13, -7, -3, -1, 119, 103, -1, 118, 
   87, -3, -1, 117, 102, 71, -3, -1, 116, 86, -1, 101, 55, -9, -3, 
   -1, 115, 70, -3, -1, 85, 84, 99, -1, 39, 114, -11, -5, -3, -1, 
   100, 7, 112, -1, 98, -1, 69, 53, -5, -1, 6, -1, 83, 68, 23, 
   -17, -5, -1, 113, -1, 54, 38, -5, -3, -1, 37, 82, 21, -1, 81, 
   -1, 52, 67, -3, -1, 22, 97, -1, 96, -1, 5, 80, -19, -11, -7, 
   -3, -1, 36, 66, -1, 51, 4, -1, 20, 65, -3, -1, 64, 35, -1, 
   50, 3, -3, -1, 19, 49, -1, 48, 34, -7, -3, -1, 18, 33, -1, 
   2, 32, 17, -1, 1, 16, 0
};
static short mpeg_tab11[] =
{
   -121, -113, -89, -59, -43, -27, -17, -7, -3, -1, 119, 103, -1, 118, 117, 
   -3, -1, 102, 71, -1, 116, -1, 87, 85, -5, -3, -1, 86, 101, 55, 
   -1, 115, 70, -9, -7, -3, -1, 69, 84, -1, 53, 83, 39, -1, 114, 
   -1, 100, 7, -5, -1, 113, -1, 23, 112, -3, -1, 54, 99, -1, 96, 
   -1, 68, 37, -13, -7, -5, -3, -1, 82, 5, 21, 98, -3, -1, 38, 
   6, 22, -5, -1, 97, -1, 81, 52, -5, -1, 80, -1, 67, 51, -1,
   36, 66, -15, -11, -7, -3, -1, 20, 65, -1, 4, 64, -1, 35, 50, 
   -1, 19, 49, -5, -3, -1, 3, 48, 34, 33, -5, -1, 18, -1, 2, 
   32, 17, -3, -1, 1, 16, 0
};
static short mpeg_tab12[] =
{
   -115, -99, -73, -45, -27, -17, -9, -5, -3, -1, 119, 103, 118, -1, 87, 
   117, -3, -1, 102, 71, -1, 116, 101, -3, -1, 86, 55, -3, -1, 115, 
   85, 39, -7, -3, -1, 114, 70, -1, 100, 23, -5, -1, 113, -1, 7, 
   112, -1, 54, 99, -13, -9, -3, -1, 69, 84, -1, 68, -1, 6, 5, 
   -1, 38, 98, -5, -1, 97, -1, 22, 96, -3, -1, 53, 83, -1, 37, 
   82, -17, -7, -3, -1, 21, 81, -1, 52, 67, -5, -3, -1, 80, 4, 
   36, -1, 66, 20, -3, -1, 51, 65, -1, 35, 50, -11, -7, -5, -3, 
   -1, 64, 3, 48, 19, -1, 49, 34, -1, 18, 33, -7, -5, -3, -1, 
   2, 32, 0, 17, -1, 1, 16
};
static short mpeg_tab13[] =
{
   -509, -503, -475, -405, -333, -265, -205, -153, -115, -83, -53, -35, -21, -13, -9, 
   -7, -5, -3, -1, 254, 252, 253, 237, 255, -1, 239, 223, -3, -1, 238,
   207, -1, 222, 191, -9, -3, -1, 251, 206, -1, 220, -1, 175, 233, -1, 
   236, 221, -9, -5, -3, -1, 250, 205, 190, -1, 235, 159, -3, -1, 249, 
   234, -1, 189, 219, -17, -9, -3, -1, 143, 248, -1, 204, -1, 174, 158, 
   -5, -1, 142, -1, 127, 126, 247, -5, -1, 218, -1, 173, 188, -3, -1, 
   203, 246, 111, -15, -7, -3, -1, 232, 95, -1, 157, 217, -3, -1, 245, 
   231, -1, 172, 187, -9, -3, -1, 79, 244, -3, -1, 202, 230, 243, -1, 
   63, -1, 141, 216, -21, -9, -3, -1, 47, 242, -3, -1, 110, 156, 15, 
   -5, -3, -1, 201, 94, 171, -3, -1, 125, 215, 78, -11, -5, -3, -1, 
   200, 214, 62, -1, 185, -1, 155, 170, -1, 31, 241, -23, -13, -5, -1, 
   240, -1, 186, 229, -3, -1, 228, 140, -1, 109, 227, -5, -1, 226, -1, 
   46, 14, -1, 30, 225, -15, -7, -3, -1, 224, 93, -1, 213, 124, -3, 
   -1, 199, 77, -1, 139, 184, -7, -3, -1, 212, 154, -1, 169, 108, -1, 
   198, 61, -37, -21, -9, -5, -3, -1, 211, 123, 45, -1, 210, 29, -5, 
   -1, 183, -1, 92, 197, -3, -1, 153, 122, 195, -7, -5, -3, -1, 167, 
   151, 75, 209, -3, -1, 13, 208, -1, 138, 168, -11, -7, -3, -1, 76, 
   196, -1, 107, 182, -1, 60, 44, -3, -1, 194, 91, -3, -1, 181, 137, 
   28, -43, -23, -11, -5, -1, 193, -1, 152, 12, -1, 192, -1, 180, 106, 
   -5, -3, -1, 166, 121, 59, -1, 179, -1, 136, 90, -11, -5, -1, 43, 
   -1, 165, 105, -1, 164, -1, 120, 135, -5, -1, 148, -1, 119, 118, 178, 
   -11, -3, -1, 27, 177, -3, -1, 11, 176, -1, 150, 74, -7, -3, -1,
   58, 163, -1, 89, 149, -1, 42, 162, -47, -23, -9, -3, -1, 26, 161, 
   -3, -1, 10, 104, 160, -5, -3, -1, 134, 73, 147, -3, -1, 57, 88, 
   -1, 133, 103, -9, -3, -1, 41, 146, -3, -1, 87, 117, 56, -5, -1, 
   131, -1, 102, 71, -3, -1, 116, 86, -1, 101, 115, -11, -3, -1, 25, 
   145, -3, -1, 9, 144, -1, 72, 132, -7, -5, -1, 114, -1, 70, 100, 
   40, -1, 130, 24, -41, -27, -11, -5, -3, -1, 55, 39, 23, -1, 113, 
   -1, 85, 7, -7, -3, -1, 112, 54, -1, 99, 69, -3, -1, 84, 38, 
   -1, 98, 53, -5, -1, 129, -1, 8, 128, -3, -1, 22, 97, -1, 6, 
   96, -13, -9, -5, -3, -1, 83, 68, 37, -1, 82, 5, -1, 21, 81, 
   -7, -3, -1, 52, 67, -1, 80, 36, -3, -1, 66, 51, 20, -19, -11, 
   -5, -1, 65, -1, 4, 64, -3, -1, 35, 50, 19, -3, -1, 49, 3, 
   -1, 48, 34, -3, -1, 18, 33, -1, 2, 32, -3, -1, 17, 1, 16, 
   0
};
static short mpeg_tab15[] =
{
   -495, -445, -355, -263, -183, -115, -77, -43, -27, -13, -7, -3, -1, 255, 239, 
   -1, 254, 223, -1, 238, -1, 253, 207, -7, -3, -1, 252, 222, -1, 237, 
   191, -1, 251, -1, 206, 236, -7, -3, -1, 221, 175, -1, 250, 190, -3, 
   -1, 235, 205, -1, 220, 159, -15, -7, -3, -1, 249, 234, -1, 189, 219,
   -3, -1, 143, 248, -1, 204, 158, -7, -3, -1, 233, 127, -1, 247, 173, 
   -3, -1, 218, 188, -1, 111, -1, 174, 15, -19, -11, -3, -1, 203, 246, 
   -3, -1, 142, 232, -1, 95, 157, -3, -1, 245, 126, -1, 231, 172, -9, 
   -3, -1, 202, 187, -3, -1, 217, 141, 79, -3, -1, 244, 63, -1, 243, 
   216, -33, -17, -9, -3, -1, 230, 47, -1, 242, -1, 110, 240, -3, -1, 
   31, 241, -1, 156, 201, -7, -3, -1, 94, 171, -1, 186, 229, -3, -1, 
   125, 215, -1, 78, 228, -15, -7, -3, -1, 140, 200, -1, 62, 109, -3, 
   -1, 214, 227, -1, 155, 185, -7, -3, -1, 46, 170, -1, 226, 30, -5, 
   -1, 225, -1, 14, 224, -1, 93, 213, -45, -25, -13, -7, -3, -1, 124, 
   199, -1, 77, 139, -1, 212, -1, 184, 154, -7, -3, -1, 169, 108, -1, 
   198, 61, -1, 211, 210, -9, -5, -3, -1, 45, 13, 29, -1, 123, 183, 
   -5, -1, 209, -1, 92, 208, -1, 197, 138, -17, -7, -3, -1, 168, 76, 
   -1, 196, 107, -5, -1, 182, -1, 153, 12, -1, 60, 195, -9, -3, -1, 
   122, 167, -1, 166, -1, 192, 11, -1, 194, -1, 44, 91, -55, -29, -15, 
   -7, -3, -1, 181, 28, -1, 137, 152, -3, -1, 193, 75, -1, 180, 106, 
   -5, -3, -1, 59, 121, 179, -3, -1, 151, 136, -1, 43, 90, -11, -5, 
   -1, 178, -1, 165, 27, -1, 177, -1, 176, 105, -7, -3, -1, 150, 74, 
   -1, 164, 120, -3, -1, 135, 58, 163, -17, -7, -3, -1, 89, 149, -1, 
   42, 162, -3, -1, 26, 161, -3, -1, 10, 160, 104, -7, -3, -1, 134, 
   73, -1, 148, 57, -5, -1, 147, -1, 119, 9, -1, 88, 133, -53, -29,
   -13, -7, -3, -1, 41, 103, -1, 118, 146, -1, 145, -1, 25, 144, -7, 
   -3, -1, 72, 132, -1, 87, 117, -3, -1, 56, 131, -1, 102, 71, -7, 
   -3, -1, 40, 130, -1, 24, 129, -7, -3, -1, 116, 8, -1, 128, 86, 
   -3, -1, 101, 55, -1, 115, 70, -17, -7, -3, -1, 39, 114, -1, 100, 
   23, -3, -1, 85, 113, -3, -1, 7, 112, 54, -7, -3, -1, 99, 69, 
   -1, 84, 38, -3, -1, 98, 22, -3, -1, 6, 96, 53, -33, -19, -9, 
   -5, -1, 97, -1, 83, 68, -1, 37, 82, -3, -1, 21, 81, -3, -1, 
   5, 80, 52, -7, -3, -1, 67, 36, -1, 66, 51, -1, 65, -1, 20, 
   4, -9, -3, -1, 35, 50, -3, -1, 64, 3, 19, -3, -1, 49, 48, 
   34, -9, -7, -3, -1, 18, 33, -1, 2, 32, 17, -3, -1, 1, 16, 
   0
};
static short mpeg_tab16[] =
{
   -509, -503, -461, -323, -103, -37, -27, -15, -7, -3, -1, 239, 254, -1, 223, 
   253, -3, -1, 207, 252, -1, 191, 251, -5, -1, 175, -1, 250, 159, -3, 
   -1, 249, 248, 143, -7, -3, -1, 127, 247, -1, 111, 246, 255, -9, -5, 
   -3, -1, 95, 245, 79, -1, 244, 243, -53, -1, 240, -1, 63, -29, -19, 
   -13, -7, -5, -1, 206, -1, 236, 221, 222, -1, 233, -1, 234, 217, -1, 
   238, -1, 237, 235, -3, -1, 190, 205, -3, -1, 220, 219, 174, -11, -5,
   -1, 204, -1, 173, 218, -3, -1, 126, 172, 202, -5, -3, -1, 201, 125, 
   94, 189, 242, -93, -5, -3, -1, 47, 15, 31, -1, 241, -49, -25, -13, 
   -5, -1, 158, -1, 188, 203, -3, -1, 142, 232, -1, 157, 231, -7, -3, 
   -1, 187, 141, -1, 216, 110, -1, 230, 156, -13, -7, -3, -1, 171, 186, 
   -1, 229, 215, -1, 78, -1, 228, 140, -3, -1, 200, 62, -1, 109, -1, 
   214, 155, -19, -11, -5, -3, -1, 185, 170, 225, -1, 212, -1, 184, 169, 
   -5, -1, 123, -1, 183, 208, 227, -7, -3, -1, 14, 224, -1, 93, 213, 
   -3, -1, 124, 199, -1, 77, 139, -75, -45, -27, -13, -7, -3, -1, 154, 
   108, -1, 198, 61, -3, -1, 92, 197, 13, -7, -3, -1, 138, 168, -1, 
   153, 76, -3, -1, 182, 122, 60, -11, -5, -3, -1, 91, 137, 28, -1, 
   192, -1, 152, 121, -1, 226, -1, 46, 30, -15, -7, -3, -1, 211, 45, 
   -1, 210, 209, -5, -1, 59, -1, 151, 136, 29, -7, -3, -1, 196, 107, 
   -1, 195, 167, -1, 44, -1, 194, 181, -23, -13, -7, -3, -1, 193, 12, 
   -1, 75, 180, -3, -1, 106, 166, 179, -5, -3, -1, 90, 165, 43, -1, 
   178, 27, -13, -5, -1, 177, -1, 11, 176, -3, -1, 105, 150, -1, 74, 
   164, -5, -3, -1, 120, 135, 163, -3, -1, 58, 89, 42, -97, -57, -33, 
   -19, -11, -5, -3, -1, 149, 104, 161, -3, -1, 134, 119, 148, -5, -3, 
   -1, 73, 87, 103, 162, -5, -1, 26, -1, 10, 160, -3, -1, 57, 147, 
   -1, 88, 133, -9, -3, -1, 41, 146, -3, -1, 118, 9, 25, -5, -1, 
   145, -1, 144, 72, -3, -1, 132, 117, -1, 56, 131, -21, -11, -5, -3,
   -1, 102, 40, 130, -3, -1, 71, 116, 24, -3, -1, 129, 128, -3, -1, 
   8, 86, 55, -9, -5, -1, 115, -1, 101, 70, -1, 39, 114, -5, -3, 
   -1, 100, 85, 7, 23, -23, -13, -5, -1, 113, -1, 112, 54, -3, -1, 
   99, 69, -1, 84, 38, -3, -1, 98, 22, -1, 97, -1, 6, 96, -9, 
   -5, -1, 83, -1, 53, 68, -1, 37, 82, -1, 81, -1, 21, 5, -33, 
   -23, -13, -7, -3, -1, 52, 67, -1, 80, 36, -3, -1, 66, 51, 20, 
   -5, -1, 65, -1, 4, 64, -1, 35, 50, -3, -1, 19, 49, -3, -1, 
   3, 48, 34, -3, -1, 18, 33, -1, 2, 32, -3, -1, 17, 1, 16, 
   0
};
static short mpeg_tab24[] =
{
   -451, -117, -43, -25, -15, -7, -3, -1, 239, 254, -1, 223, 253, -3, -1, 
   207, 252, -1, 191, 251, -5, -1, 250, -1, 175, 159, -1, 249, 248, -9, 
   -5, -3, -1, 143, 127, 247, -1, 111, 246, -3, -1, 95, 245, -1, 79, 
   244, -71, -7, -3, -1, 63, 243, -1, 47, 242, -5, -1, 241, -1, 31, 
   240, -25, -9, -1, 15, -3, -1, 238, 222, -1, 237, 206, -7, -3, -1, 
   236, 221, -1, 190, 235, -3, -1, 205, 220, -1, 174, 234, -15, -7, -3, 
   -1, 189, 219, -1, 204, 158, -3, -1, 233, 173, -1, 218, 188, -7, -3, 
   -1, 203, 142, -1, 232, 157, -3, -1, 217, 126, -1, 231, 172, 255, -235,
   -143, -77, -45, -25, -15, -7, -3, -1, 202, 187, -1, 141, 216, -5, -3, 
   -1, 14, 224, 13, 230, -5, -3, -1, 110, 156, 201, -1, 94, 186, -9, 
   -5, -1, 229, -1, 171, 125, -1, 215, 228, -3, -1, 140, 200, -3, -1, 
   78, 46, 62, -15, -7, -3, -1, 109, 214, -1, 227, 155, -3, -1, 185, 
   170, -1, 226, 30, -7, -3, -1, 225, 93, -1, 213, 124, -3, -1, 199, 
   77, -1, 139, 184, -31, -15, -7, -3, -1, 212, 154, -1, 169, 108, -3, 
   -1, 198, 61, -1, 211, 45, -7, -3, -1, 210, 29, -1, 123, 183, -3, 
   -1, 209, 92, -1, 197, 138, -17, -7, -3, -1, 168, 153, -1, 76, 196, 
   -3, -1, 107, 182, -3, -1, 208, 12, 60, -7, -3, -1, 195, 122, -1, 
   167, 44, -3, -1, 194, 91, -1, 181, 28, -57, -35, -19, -7, -3, -1, 
   137, 152, -1, 193, 75, -5, -3, -1, 192, 11, 59, -3, -1, 176, 10, 
   26, -5, -1, 180, -1, 106, 166, -3, -1, 121, 151, -3, -1, 160, 9, 
   144, -9, -3, -1, 179, 136, -3, -1, 43, 90, 178, -7, -3, -1, 165, 
   27, -1, 177, 105, -1, 150, 164, -17, -9, -5, -3, -1, 74, 120, 135, 
   -1, 58, 163, -3, -1, 89, 149, -1, 42, 162, -7, -3, -1, 161, 104, 
   -1, 134, 119, -3, -1, 73, 148, -1, 57, 147, -63, -31, -15, -7, -3, 
   -1, 88, 133, -1, 41, 103, -3, -1, 118, 146, -1, 25, 145, -7, -3, 
   -1, 72, 132, -1, 87, 117, -3, -1, 56, 131, -1, 102, 40, -17, -7, 
   -3, -1, 130, 24, -1, 71, 116, -5, -1, 129, -1, 8, 128, -1, 86, 
   101, -7, -5, -1, 23, -1, 7, 112, 115, -3, -1, 55, 39, 114, -15,
   -7, -3, -1, 70, 100, -1, 85, 113, -3, -1, 54, 99, -1, 69, 84, 
   -7, -3, -1, 38, 98, -1, 22, 97, -5, -3, -1, 6, 96, 53, -1, 
   83, 68, -51, -37, -23, -15, -9, -3, -1, 37, 82, -1, 21, -1, 5, 
   80, -1, 81, -1, 52, 67, -3, -1, 36, 66, -1, 51, 20, -9, -5, 
   -1, 65, -1, 4, 64, -1, 35, 50, -1, 19, 49, -7, -5, -3, -1, 
   3, 48, 34, 18, -1, 33, -1, 2, 32, -3, -1, 17, 1, -1, 16, 
   0
};
static struct newhuff mpeg_ht[] = 
{
   {0 , mpeg_tab0 } , 
   {0 , mpeg_tab1 } , 
   {0 , mpeg_tab2 } , 
   {0 , mpeg_tab3 } , 
   {0 , mpeg_tab0 } , 
   {0 , mpeg_tab5 } , 
   {0 , mpeg_tab6 } , 
   {0 , mpeg_tab7 } , 
   {0 , mpeg_tab8 } , 
   {0 , mpeg_tab9 } ,
   {0 , mpeg_tab10 } , 
   {0 , mpeg_tab11 } , 
   {0 , mpeg_tab12 } , 
   {0 , mpeg_tab13 } , 
   {0 , mpeg_tab0 } , 
   {0 , mpeg_tab15 } , 
   {1 , mpeg_tab16 } , 
   {2 , mpeg_tab16 } , 
   {3 , mpeg_tab16 } , 
   {4 , mpeg_tab16 } , 
   {6 , mpeg_tab16 } , 
   {8 , mpeg_tab16 } , 
   {10, mpeg_tab16 } , 
   {13, mpeg_tab16 } , 
   {4 , mpeg_tab24 } , 
   {5 , mpeg_tab24 } , 
   {6 , mpeg_tab24 } , 
   {7 , mpeg_tab24 } , 
   {8 , mpeg_tab24 } , 
   {9 , mpeg_tab24 } ,
   {11, mpeg_tab24 } , 
   {13, mpeg_tab24 }
};
static short mpeg_tab_c0[] =
{
   -29, -21, -13, -7, -3, -1, 11, 15, -1, 13, 14, -3, -1, 7, 5, 
   9, -3, -1, 6, 3, -1, 10, 12, -3, -1, 2, 1, -1, 4, 8, 
   0
};
static short mpeg_tab_c1[] =
{
   -15, -7, -3, -1, 15, 14, -1, 13, 12, -3, -1, 11, 10, -1, 9, 
   8, -7, -3, -1, 7, 6, -1, 5, 4, -3, -1, 3, 2, -1, 1, 
   0
};
static struct newhuff mpeg_htc[] = 
{
   {0 , mpeg_tab_c0 } , 
   {0 , mpeg_tab_c1 }
};
struct mpeg_bandInfoStruct 
{
   int longIdx[ 23 ];
   int longDiff[ 22 ];
   int shortIdx[ 14 ];
   int shortDiff[ 13 ];
};
typedef struct 
{
   int intra_quantizer_matrix[ 64 ], non_intra_quantizer_matrix[ 64 ];
   int chroma_intra_quantizer_matrix[ 64 ], chroma_non_intra_quantizer_matrix[ 64 ];
   int mpeg_2;
   int qscale_type, altscan; 
   int pict_scal; 
   int scalable_mode; 
} mpeg_layerdata_t;
typedef struct 
{
   char val, len;
} mpeg_VLCtab_t;
typedef struct 
{
   char run, level, len;
} mpeg_DCTtab_t;
typedef struct 
{
   uint8_t bai;	
   uint8_t deltbae;	
   int8_t deltba[ 50 ];	
} ba_t;
typedef struct 
{
   uint8_t exp[ 256 ];	
   int8_t bap[ 256 ];	
} expbap_t;
//
typedef float sample_t;
//
struct a52_state_s 
{
   uint8_t fscod;	
   uint8_t halfrate;	
   uint8_t acmod;	
   uint8_t lfeon;	
   sample_t clev;	
   sample_t slev;	
   int output;	
   sample_t level;	
   sample_t bias;	
   int dynrnge;	
   sample_t dynrng;	
   void * dynrngdata;	
   sample_t ( * dynrngcall ) ( sample_t range, void * dynrngdata );
   uint8_t chincpl;	
   uint8_t phsflginu;	
   uint8_t cplstrtmant;	
   uint8_t cplendmant;	
   uint32_t cplbndstrc;	
   sample_t cplco[ 5 ][ 18 ];	
   uint8_t cplstrtbnd;
   uint8_t ncplbnd;	
   uint8_t rematflg;	
   uint8_t endmant[ 5 ];	
   uint16_t bai;	
   uint8_t csnroffst;	
   ba_t cplba;	
   ba_t ba[ 5 ];	
   ba_t lfeba;	
   uint8_t cplfleak;	
   uint8_t cplsleak;	
   expbap_t cpl_expbap;
   expbap_t fbw_expbap[ 5 ];
   expbap_t lfe_expbap;
   sample_t * samples;
   int downmixed;
};
/***************************************************************************/
//
#define mpeg_bits_tell_percentage(   stream ) mpeg_demux_tell_percentage( ( stream )->demuxer )
#define mpeg_bits_packet_time(   stream ) mpeg_demux_current_time( ( stream )->demuxer )
#define mpeg_bits_time_offset(   stream ) mepg2demux_time_offset( ( stream )->demuxer )
#define mpeg_bits_error(         stream ) mpeg_demux_error( ( stream )->demuxer )
#define mpeg_bits_eof(           stream ) mpeg_demux_eof( ( stream )->demuxer )
#define mpeg_bits_bof(           stream ) mpeg_demux_bof( ( stream )->demuxer )
#define mpeg_demux_error(        demuxer ) ( ( ( mpeg_demuxer_t * )( demuxer ) )->error_flag )
#define mpeg_demux_time_offset(  demuxer ) ( ( ( mpeg_demuxer_t * )( demuxer ) )->time_offset )
#define mpeg_demux_current_time( demuxer ) ( ( ( mpeg_demuxer_t * )( demuxer ) )->time + ( ( mpeg_demuxer_t * )( demuxer ) )->time_offset )
#define mpeg_demux_read_char(    demuxer ) ( ( ( ( mpeg_demuxer_t * )( demuxer ) )->data_position < ( ( mpeg_demuxer_t * )( demuxer ) )->data_size ) ? ( ( mpeg_demuxer_t * )( demuxer ) )->data_buffer[ ( ( mpeg_demuxer_t * )( demuxer ) )->data_position++ ] : mpeg_demux_read_char_packet( demuxer ) )
#define mpeg_demux_read_prev_char(   demuxer ) ( ( ( ( mpeg_demuxer_t * )( demuxer ) )->data_position != 0 ) ? ( ( mpeg_demuxer_t * )( demuxer ) )->data_buffer[ ( ( mpeg_demuxer_t * )( demuxer ) )->data_position-- ] : mpeg_demux_read_prev_char_packet( demuxer ) )
//
static int mpeg_ac3_samplerates[ 9 ] = {44100, 48000, 32000, 22050, 24000, 16000 , 11025 , 12000 , 8000 };
//
#define mpeg_slice_fillbits(     buffer, nbits ) while( ( ( mpeg_slice_buffer_t* )( buffer ) )->bits_size < ( nbits ) ) {if( ( ( mpeg_slice_buffer_t* )( buffer ) )->current_position < ( ( mpeg_slice_buffer_t* )( buffer ) )->buffer_size ) {( ( mpeg_slice_buffer_t* )( buffer ) )->bits <<= 8; ( ( mpeg_slice_buffer_t* )( buffer ) )->bits |= ( ( mpeg_slice_buffer_t* )( buffer ) )->data[ ( ( mpeg_slice_buffer_t* )( buffer ) )->current_position++ ]; } ( ( mpeg_slice_buffer_t* )( buffer ) )->bits_size+= 8; }
#define mpeg_slice_flushbits(    buffer, nbits ) {mpeg_slice_fillbits( ( buffer ), ( nbits ) ); ( ( mpeg_slice_buffer_t* )( buffer ) )->bits_size -= ( nbits ); }
#define mpeg_slice_flushbit(     buffer ) {if( ( ( mpeg_slice_buffer_t* )( buffer ) )->bits_size ) ( ( mpeg_slice_buffer_t* )( buffer ) )->bits_size--; else if( ( ( mpeg_slice_buffer_t* )( buffer ) )->current_position < ( ( mpeg_slice_buffer_t* )( buffer ) )->buffer_size ) {( ( mpeg_slice_buffer_t* )( buffer ) )->bits = ( ( mpeg_slice_buffer_t* )( buffer ) )->data[ ( ( mpeg_slice_buffer_t* )( buffer ) )->current_position++ ]; ( ( mpeg_slice_buffer_t* )( buffer ) )->bits_size = 7; } }
//
static unsigned char mpeg_zig_zag_scan_nommx[ 64 ];
static unsigned char mpeg_alternate_scan_nommx[ 64 ];
static unsigned char mpeg_default_intra_quantizer_matrix[ 64 ];
static double mpeg_frame_rate_table[ 16 ];
static unsigned char mpeg_non_linear_mquant_table[ 32 ];
//
#define mpeg_io_tell(            fs ) ( ( ( mpeg_fs_t * )( fs ) )->current_byte )
#define mpeg_io_eof(             fs ) ( ( ( mpeg_fs_t * )( fs ) )->current_byte >= ( ( mpeg_fs_t * )( fs ) )->total_bytes )
#define mpeg_io_bof(             fs ) 	( ( ( mpeg_fs_t * )( fs ) )->current_byte < 0 )
#define mpeg_io_total_bytes(     fs ) ( ( ( mpeg_fs_t * )( fs ) )->total_bytes )
//
static int mpeg_tabsel_123[ 2 ][ 3 ][ 16 ];
static long mpeg_freqs[ 9 ];
static float mpeg_decwin[ 512 + 32 ];
static float mpeg_cos64[ 16 ], mpeg_cos32[ 8 ], mpeg_cos16[ 4 ], mpeg_cos8[ 2 ], mpeg_cos4[ 1 ];
static float *mpeg_pnts[ 5 ];
static int mpeg_grp_3tab[ 32 * 3 ]; 
static int mpeg_grp_5tab[ 128 * 3 ]; 
static int mpeg_grp_9tab[ 1024 * 3 ]; 
static float mpeg_muls[ 27 ][ 64 ];	
static float mpeg_gainpow2[ 256 + 118 + 4 ];
static long mpeg_intwinbase[ 257 ];
static float mpeg_ispow[ 8207 ];
static float mpeg_aa_ca[ 8 ], mpeg_aa_cs[ 8 ];
static float mpeg_win[ 4 ][ 36 ];
static float mpeg_win1[ 4 ][ 36 ];
static float mpeg_COS1[ 12 ][ 6 ];
static float mpeg_COS9[ 9 ];
static float mpeg_COS6_1, mpeg_COS6_2;
static float mpeg_tfcos36[ 9 ];
static float mpeg_tfcos12[ 3 ];
static float mpeg_cos9[ 3 ], mpeg_cos18[ 3 ];
static float mpeg_tan1_1[ 16 ], mpeg_tan2_1[ 16 ], mpeg_tan1_2[ 16 ], mpeg_tan2_2[ 16 ];
static float mpeg_pow1_1[ 2 ][ 16 ], mpeg_pow2_1[ 2 ][ 16 ], mpeg_pow1_2[ 2 ][ 16 ], mpeg_pow2_2[ 2 ][ 16 ];
static int mpeg_longLimit[ 9 ][ 23 ];
static int mpeg_shortLimit[ 9 ][ 14 ];
//struct mpeg_bandInfoStruct mpeg_bandInfo[ 9 ];
static int mpeg_mapbuf0[ 9 ][ 152 ];
static int mpeg_mapbuf1[ 9 ][ 156 ];
static int mpeg_mapbuf2[ 9 ][ 44 ];
static int *mpeg_map[ 9 ][ 3 ];
static int *mpeg_mapend[ 9 ][ 3 ];
static unsigned int mpeg_n_slen2[ 512 ]; 
static unsigned int mpeg_i_slen2[ 256 ];
static mpeg_VLCtab_t mpeg_PMBtab0[ 8 ];
static mpeg_VLCtab_t mpeg_PMBtab1[ 8 ];
static mpeg_VLCtab_t mpeg_BMBtab0[ 16 ];
static mpeg_VLCtab_t mpeg_BMBtab1[ 8 ];
static mpeg_VLCtab_t mpeg_spIMBtab[ 16 ];
static mpeg_VLCtab_t mpeg_spPMBtab0[ 16 ];
static mpeg_VLCtab_t mpeg_spPMBtab1[ 16 ];
static mpeg_VLCtab_t mpeg_spBMBtab0[ 14 ];
static mpeg_VLCtab_t mpeg_spBMBtab1[ 12 ];
static mpeg_VLCtab_t mpeg_spBMBtab2[ 8 ];
static mpeg_VLCtab_t mpeg_SNRMBtab[ 8 ];
static mpeg_VLCtab_t mpeg_MVtab0[ 8 ];
static mpeg_VLCtab_t mpeg_MVtab1[ 8 ];
static mpeg_VLCtab_t mpeg_MVtab2[ 12 ];
static mpeg_VLCtab_t mpeg_CBPtab0[ 32 ];
static mpeg_VLCtab_t mpeg_CBPtab1[ 64 ];
static mpeg_VLCtab_t mpeg_CBPtab2[ 8 ];
static mpeg_VLCtab_t mpeg_MBAtab1[ 16 ];
static mpeg_VLCtab_t mpeg_MBAtab2[ 104 ];
static mpeg_VLCtab_t mpeg_DClumtab0[ 32 ];
static mpeg_VLCtab_t mpeg_DClumtab1[ 16 ];
static mpeg_VLCtab_t mpeg_DCchromtab0[ 32 ];
static mpeg_VLCtab_t mpeg_DCchromtab1[ 32 ];
static mpeg_DCTtab_t mpeg_DCTtabfirst[ 12 ];
static mpeg_DCTtab_t mpeg_DCTtabnext[ 12 ];
static mpeg_DCTtab_t mpeg_DCTtab0[ 60 ];
static mpeg_DCTtab_t mpeg_DCTtab0a[ 252 ];
static mpeg_DCTtab_t mpeg_DCTtab1[ 8 ];
static mpeg_DCTtab_t mpeg_DCTtab1a[ 8 ];
static mpeg_DCTtab_t mpeg_DCTtab2[ 16 ];
static mpeg_DCTtab_t mpeg_DCTtab3[ 16 ];
static mpeg_DCTtab_t mpeg_DCTtab4[ 16 ];
static mpeg_DCTtab_t mpeg_DCTtab5[ 16 ];
static mpeg_DCTtab_t mpeg_DCTtab6[ 16 ];
//
static int8_t exp_1[ 128 ] = 
{
   -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, 
   -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
   2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
   25, 25, 25
};
static int8_t exp_2[ 128 ] = 
{
   -2, -2, -2, -2, -2, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 
   -2, -2, -2, -2, -2, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 
   -2, -2, -2, -2, -2, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 
   -2, -2, -2, -2, -2, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 
   -2, -2, -2, -2, -2, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 
   25, 25, 25
};
static int8_t exp_3[ 128 ] = 
{
   -2, -1, 0, 1, 2, -2, -1, 0, 1, 2, -2, -1, 0, 1, 2, -2, -1, 0, 1, 2, -2, -1, 0, 1, 2, 
   -2, -1, 0, 1, 2, -2, -1, 0, 1, 2, -2, -1, 0, 1, 2, -2, -1, 0, 1, 2, -2, -1, 0, 1, 2, 
   -2, -1, 0, 1, 2, -2, -1, 0, 1, 2, -2, -1, 0, 1, 2, -2, -1, 0, 1, 2, -2, -1, 0, 1, 2, 
   -2, -1, 0, 1, 2, -2, -1, 0, 1, 2, -2, -1, 0, 1, 2, -2, -1, 0, 1, 2, -2, -1, 0, 1, 2, 
   -2, -1, 0, 1, 2, -2, -1, 0, 1, 2, -2, -1, 0, 1, 2, -2, -1, 0, 1, 2, -2, -1, 0, 1, 2,
   25, 25, 25
};
//
#define Q0                       ( ( -2 << 15 ) / 3.0 )
#define Q1                       ( 0 )
#define Q2                       ( ( 2 << 15 ) / 3.0 )
//
static const sample_t q_1_0[ 32 ] = 
{
   Q0, Q0, Q0, Q0, Q0, Q0, Q0, Q0, Q0, 
   Q1, Q1, Q1, Q1, Q1, Q1, Q1, Q1, Q1, 
   Q2, Q2, Q2, Q2, Q2, Q2, Q2, Q2, Q2, 
   0, 0, 0, 0, 0
};
static const sample_t q_1_1[ 32 ] = 
{
   Q0, Q0, Q0, Q1, Q1, Q1, Q2, Q2, Q2, 
   Q0, Q0, Q0, Q1, Q1, Q1, Q2, Q2, Q2, 
   Q0, Q0, Q0, Q1, Q1, Q1, Q2, Q2, Q2, 
   0, 0, 0, 0, 0
};
static const sample_t q_1_2[ 32 ] = 
{
   Q0, Q1, Q2, Q0, Q1, Q2, Q0, Q1, Q2, 
   Q0, Q1, Q2, Q0, Q1, Q2, Q0, Q1, Q2, 
   Q0, Q1, Q2, Q0, Q1, Q2, Q0, Q1, Q2, 
   0, 0, 0, 0, 0
};
#undef Q0
#undef Q1
#undef Q2
#define Q0                       ( ( -4 << 15 ) / 5.0 )
#define Q1                       ( ( -2 << 15 ) / 5.0 )
#define Q2                       ( 0 )
#define Q3                       ( ( 2 << 15 ) / 5.0 )
#define Q4                       ( ( 4 << 15 ) / 5.0 )
static const sample_t q_2_0[ 128 ] = 
{
   Q0, Q0, Q0, Q0, Q0, Q0, Q0, Q0, Q0, Q0, Q0, Q0, Q0, Q0, Q0, Q0, Q0, Q0, Q0, Q0, Q0, Q0, Q0, Q0, Q0, 
   Q1, Q1, Q1, Q1, Q1, Q1, Q1, Q1, Q1, Q1, Q1, Q1, Q1, Q1, Q1, Q1, Q1, Q1, Q1, Q1, Q1, Q1, Q1, Q1, Q1,
   Q2, Q2, Q2, Q2, Q2, Q2, Q2, Q2, Q2, Q2, Q2, Q2, Q2, Q2, Q2, Q2, Q2, Q2, Q2, Q2, Q2, Q2, Q2, Q2, Q2, 
   Q3, Q3, Q3, Q3, Q3, Q3, Q3, Q3, Q3, Q3, Q3, Q3, Q3, Q3, Q3, Q3, Q3, Q3, Q3, Q3, Q3, Q3, Q3, Q3, Q3, 
   Q4, Q4, Q4, Q4, Q4, Q4, Q4, Q4, Q4, Q4, Q4, Q4, Q4, Q4, Q4, Q4, Q4, Q4, Q4, Q4, Q4, Q4, Q4, Q4, Q4, 
   0, 0, 0
};
static const sample_t q_2_1[ 128 ] = 
{
   Q0, Q0, Q0, Q0, Q0, Q1, Q1, Q1, Q1, Q1, Q2, Q2, Q2, Q2, Q2, Q3, Q3, Q3, Q3, Q3, Q4, Q4, Q4, Q4, Q4, 
   Q0, Q0, Q0, Q0, Q0, Q1, Q1, Q1, Q1, Q1, Q2, Q2, Q2, Q2, Q2, Q3, Q3, Q3, Q3, Q3, Q4, Q4, Q4, Q4, Q4, 
   Q0, Q0, Q0, Q0, Q0, Q1, Q1, Q1, Q1, Q1, Q2, Q2, Q2, Q2, Q2, Q3, Q3, Q3, Q3, Q3, Q4, Q4, Q4, Q4, Q4, 
   Q0, Q0, Q0, Q0, Q0, Q1, Q1, Q1, Q1, Q1, Q2, Q2, Q2, Q2, Q2, Q3, Q3, Q3, Q3, Q3, Q4, Q4, Q4, Q4, Q4, 
   Q0, Q0, Q0, Q0, Q0, Q1, Q1, Q1, Q1, Q1, Q2, Q2, Q2, Q2, Q2, Q3, Q3, Q3, Q3, Q3, Q4, Q4, Q4, Q4, Q4, 
   0, 0, 0
};
static const sample_t q_2_2[ 128 ] = 
{
   Q0, Q1, Q2, Q3, Q4, Q0, Q1, Q2, Q3, Q4, Q0, Q1, Q2, Q3, Q4, Q0, Q1, Q2, Q3, Q4, Q0, Q1, Q2, Q3, Q4, 
   Q0, Q1, Q2, Q3, Q4, Q0, Q1, Q2, Q3, Q4, Q0, Q1, Q2, Q3, Q4, Q0, Q1, Q2, Q3, Q4, Q0, Q1, Q2, Q3, Q4, 
   Q0, Q1, Q2, Q3, Q4, Q0, Q1, Q2, Q3, Q4, Q0, Q1, Q2, Q3, Q4, Q0, Q1, Q2, Q3, Q4, Q0, Q1, Q2, Q3, Q4, 
   Q0, Q1, Q2, Q3, Q4, Q0, Q1, Q2, Q3, Q4, Q0, Q1, Q2, Q3, Q4, Q0, Q1, Q2, Q3, Q4, Q0, Q1, Q2, Q3, Q4,
   Q0, Q1, Q2, Q3, Q4, Q0, Q1, Q2, Q3, Q4, Q0, Q1, Q2, Q3, Q4, Q0, Q1, Q2, Q3, Q4, Q0, Q1, Q2, Q3, Q4, 
   0, 0, 0
};
#undef Q0
#undef Q1
#undef Q2
#undef Q3
#undef Q4
static const sample_t q_3[ 8 ] = 
{
   ( -6 << 15 )/7.0, ( -4 << 15 )/7.0, ( -2 << 15 )/7.0, 0, 
   ( 2 << 15 )/7.0, ( 4 << 15 )/7.0, ( 6 << 15 )/7.0, 0
};
#define Q0                       ( ( -10 << 15 ) / 11.0 )
#define Q1                       ( ( -8 << 15 ) / 11.0 )
#define Q2                       ( ( -6 << 15 ) / 11.0 )
#define Q3                       ( ( -4 << 15 ) / 11.0 )
#define Q4                       ( ( -2 << 15 ) / 11.0 )
#define Q5                       ( 0 )
#define Q6                       ( ( 2 << 15 ) / 11.0 )
#define Q7                       ( ( 4 << 15 ) / 11.0 )
#define Q8                       ( ( 6 << 15 ) / 11.0 )
#define Q9                       ( ( 8 << 15 ) / 11.0 )
#define QA                       ( ( 10 << 15 ) / 11.0 )
static const sample_t q_4_0[ 128 ] = 
{
   Q0, Q0, Q0, Q0, Q0, Q0, Q0, Q0, Q0, Q0, Q0, 
   Q1, Q1, Q1, Q1, Q1, Q1, Q1, Q1, Q1, Q1, Q1, 
   Q2, Q2, Q2, Q2, Q2, Q2, Q2, Q2, Q2, Q2, Q2, 
   Q3, Q3, Q3, Q3, Q3, Q3, Q3, Q3, Q3, Q3, Q3, 
   Q4, Q4, Q4, Q4, Q4, Q4, Q4, Q4, Q4, Q4, Q4, 
   Q5, Q5, Q5, Q5, Q5, Q5, Q5, Q5, Q5, Q5, Q5, 
   Q6, Q6, Q6, Q6, Q6, Q6, Q6, Q6, Q6, Q6, Q6, 
   Q7, Q7, Q7, Q7, Q7, Q7, Q7, Q7, Q7, Q7, Q7, 
   Q8, Q8, Q8, Q8, Q8, Q8, Q8, Q8, Q8, Q8, Q8, 
   Q9, Q9, Q9, Q9, Q9, Q9, Q9, Q9, Q9, Q9, Q9, 
   QA, QA, QA, QA, QA, QA, QA, QA, QA, QA, QA, 
   0, 0, 0, 0, 0, 0, 0
};
static const sample_t q_4_1[ 128 ] =
{
   Q0, Q1, Q2, Q3, Q4, Q5, Q6, Q7, Q8, Q9, QA, 
   Q0, Q1, Q2, Q3, Q4, Q5, Q6, Q7, Q8, Q9, QA, 
   Q0, Q1, Q2, Q3, Q4, Q5, Q6, Q7, Q8, Q9, QA, 
   Q0, Q1, Q2, Q3, Q4, Q5, Q6, Q7, Q8, Q9, QA, 
   Q0, Q1, Q2, Q3, Q4, Q5, Q6, Q7, Q8, Q9, QA, 
   Q0, Q1, Q2, Q3, Q4, Q5, Q6, Q7, Q8, Q9, QA, 
   Q0, Q1, Q2, Q3, Q4, Q5, Q6, Q7, Q8, Q9, QA, 
   Q0, Q1, Q2, Q3, Q4, Q5, Q6, Q7, Q8, Q9, QA, 
   Q0, Q1, Q2, Q3, Q4, Q5, Q6, Q7, Q8, Q9, QA, 
   Q0, Q1, Q2, Q3, Q4, Q5, Q6, Q7, Q8, Q9, QA, 
   Q0, Q1, Q2, Q3, Q4, Q5, Q6, Q7, Q8, Q9, QA, 
   0, 0, 0, 0, 0, 0, 0
};
#undef Q0
#undef Q1
#undef Q2
#undef Q3
#undef Q4
#undef Q5
#undef Q6
#undef Q7
#undef Q8
#undef Q9
#undef QA
static const sample_t q_5[ 16 ] = 
{
   ( -14 << 15 )/15.0, ( -12 << 15 )/15.0, ( -10 << 15 )/15.0, 
   ( -8 << 15 )/15.0, ( -6 << 15 )/15.0, ( -4 << 15 )/15.0, 
   ( -2 << 15 )/15.0, 0 , ( 2 << 15 )/15.0, 
   ( 4 << 15 )/15.0, ( 6 << 15 )/15.0, ( 8 << 15 )/15.0, 
   ( 10 << 15 )/15.0, ( 12 << 15 )/15.0, ( 14 << 15 )/15.0, 
   0
};
static sample_t scale_factor[ 25 ] = 
{
   0.000030517578125, 
   0.0000152587890625, 
   0.00000762939453125, 
   0.000003814697265625,
   0.0000019073486328125, 
   0.00000095367431640625, 
   0.000000476837158203125, 
   0.0000002384185791015625, 
   0.00000011920928955078125, 
   0.000000059604644775390625, 
   0.0000000298023223876953125, 
   0.00000001490116119384765625, 
   0.000000007450580596923828125, 
   0.0000000037252902984619140625, 
   0.00000000186264514923095703125, 
   0.000000000931322574615478515625, 
   0.0000000004656612873077392578125, 
   0.00000000023283064365386962890625, 
   0.000000000116415321826934814453125, 
   0.0000000000582076609134674072265625, 
   0.00000000002910383045673370361328125, 
   0.000000000014551915228366851806640625, 
   0.0000000000072759576141834259033203125, 
   0.00000000000363797880709171295166015625,
   0.000000000001818989403545856475830078125
};
static const uint16_t dither_lut[ 256 ] = 
{
   0x0000, 0xa011, 0xe033, 0x4022, 0x6077, 0xc066, 0x8044, 0x2055, 
   0xc0ee, 0x60ff, 0x20dd, 0x80cc, 0xa099, 0x0088, 0x40aa, 0xe0bb, 
   0x21cd, 0x81dc, 0xc1fe, 0x61ef, 0x41ba, 0xe1ab, 0xa189, 0x0198, 
   0xe123, 0x4132, 0x0110, 0xa101, 0x8154, 0x2145, 0x6167, 0xc176, 
   0x439a, 0xe38b, 0xa3a9, 0x03b8, 0x23ed, 0x83fc, 0xc3de, 0x63cf, 
   0x8374, 0x2365, 0x6347, 0xc356, 0xe303, 0x4312, 0x0330, 0xa321, 
   0x6257, 0xc246, 0x8264, 0x2275, 0x0220, 0xa231, 0xe213, 0x4202, 
   0xa2b9, 0x02a8, 0x428a, 0xe29b, 0xc2ce, 0x62df, 0x22fd, 0x82ec, 
   0x8734, 0x2725, 0x6707, 0xc716, 0xe743, 0x4752, 0x0770, 0xa761, 
   0x47da, 0xe7cb, 0xa7e9, 0x07f8, 0x27ad, 0x87bc, 0xc79e, 0x678f, 
   0xa6f9, 0x06e8, 0x46ca, 0xe6db, 0xc68e, 0x669f, 0x26bd, 0x86ac, 
   0x6617, 0xc606, 0x8624, 0x2635, 0x0660, 0xa671, 0xe653, 0x4642, 
   0xc4ae, 0x64bf, 0x249d, 0x848c, 0xa4d9, 0x04c8, 0x44ea, 0xe4fb, 
   0x0440, 0xa451, 0xe473, 0x4462, 0x6437, 0xc426, 0x8404, 0x2415, 
   0xe563, 0x4572, 0x0550, 0xa541, 0x8514, 0x2505, 0x6527, 0xc536, 
   0x258d, 0x859c, 0xc5be, 0x65af, 0x45fa, 0xe5eb, 0xa5c9, 0x05d8,
   0xae79, 0x0e68, 0x4e4a, 0xee5b, 0xce0e, 0x6e1f, 0x2e3d, 0x8e2c, 
   0x6e97, 0xce86, 0x8ea4, 0x2eb5, 0x0ee0, 0xaef1, 0xeed3, 0x4ec2, 
   0x8fb4, 0x2fa5, 0x6f87, 0xcf96, 0xefc3, 0x4fd2, 0x0ff0, 0xafe1, 
   0x4f5a, 0xef4b, 0xaf69, 0x0f78, 0x2f2d, 0x8f3c, 0xcf1e, 0x6f0f, 
   0xede3, 0x4df2, 0x0dd0, 0xadc1, 0x8d94, 0x2d85, 0x6da7, 0xcdb6, 
   0x2d0d, 0x8d1c, 0xcd3e, 0x6d2f, 0x4d7a, 0xed6b, 0xad49, 0x0d58, 
   0xcc2e, 0x6c3f, 0x2c1d, 0x8c0c, 0xac59, 0x0c48, 0x4c6a, 0xec7b, 
   0x0cc0, 0xacd1, 0xecf3, 0x4ce2, 0x6cb7, 0xcca6, 0x8c84, 0x2c95, 
   0x294d, 0x895c, 0xc97e, 0x696f, 0x493a, 0xe92b, 0xa909, 0x0918, 
   0xe9a3, 0x49b2, 0x0990, 0xa981, 0x89d4, 0x29c5, 0x69e7, 0xc9f6, 
   0x0880, 0xa891, 0xe8b3, 0x48a2, 0x68f7, 0xc8e6, 0x88c4, 0x28d5, 
   0xc86e, 0x687f, 0x285d, 0x884c, 0xa819, 0x0808, 0x482a, 0xe83b, 
   0x6ad7, 0xcac6, 0x8ae4, 0x2af5, 0x0aa0, 0xaab1, 0xea93, 0x4a82, 
   0xaa39, 0x0a28, 0x4a0a, 0xea1b, 0xca4e, 0x6a5f, 0x2a7d, 0x8a6c, 
   0x4b1a, 0xeb0b, 0xab29, 0x0b38, 0x2b6d, 0x8b7c, 0xcb5e, 0x6b4f, 
   0x8bf4, 0x2be5, 0x6bc7, 0xcbd6, 0xeb83, 0x4b92, 0x0bb0, 0xaba1
};
//
#define LEVEL_PLUS6DB            2.0
#define LEVEL_PLUS3DB            1.4142135623730951
#define LEVEL_3DB                0.7071067811865476
#define LEVEL_45DB               0.5946035575013605
#define LEVEL_6DB                0.5
#define EXP_REUSE                ( 0 )
#define EXP_D15                  ( 1 )
#define EXP_D25                  ( 2 )
#define EXP_D45                  ( 3 )
#define DELTA_BIT_REUSE          ( 0 )
#define DELTA_BIT_NEW            ( 1 )
#define DELTA_BIT_NONE           ( 2 )
#define DELTA_BIT_RESERVED       ( 3 )
//
#ifdef WORDS_BIGENDIAN
   #define swab32( x ) ( x )
#else
   #if 0 && defined ( __i386__ )
      #define swab32( x ) __i386_swab32( x )
      static inline const uint32_t __i386_swab32( uint32_t x )
      {
	 __asm__( "bswap %0" : "=r" ( x ) : "0" ( x ) );
         return x;
      }
   #else
      #define swab32( x ) ( ( ( ( uint8_t* )&x )[ 0 ] << 24 ) | ( ( ( uint8_t* )&x )[ 1 ] << 16 ) | ( ( ( uint8_t* )&x )[ 2 ] << 8 ) | ( ( ( uint8_t* )&x )[ 3 ] ) )
   #endif
#endif
//
static uint32_t a52_bits_left;
static uint32_t a52_current_word;
/***************************************************************************/
static float mpeg_xcos1[ AC3_N / 4 ];
static float mpeg_xsin1[ AC3_N / 4 ];
static float mpeg_xcos2[ AC3_N / 8 ];
static float mpeg_xsin2[ AC3_N / 8 ];
/***************************************************************************/
static unsigned char mpeg_bit_reverse_512[] =
{
   0x00, 0x40, 0x20, 0x60, 0x10, 0x50, 0x30, 0x70, 
   0x08, 0x48, 0x28, 0x68, 0x18, 0x58, 0x38, 0x78, 
   0x04, 0x44, 0x24, 0x64, 0x14, 0x54, 0x34, 0x74,
   0x0c, 0x4c, 0x2c, 0x6c, 0x1c, 0x5c, 0x3c, 0x7c, 
   0x02, 0x42, 0x22, 0x62, 0x12, 0x52, 0x32, 0x72, 
   0x0a, 0x4a, 0x2a, 0x6a, 0x1a, 0x5a, 0x3a, 0x7a, 
   0x06, 0x46, 0x26, 0x66, 0x16, 0x56, 0x36, 0x76, 
   0x0e, 0x4e, 0x2e, 0x6e, 0x1e, 0x5e, 0x3e, 0x7e, 
   0x01, 0x41, 0x21, 0x61, 0x11, 0x51, 0x31, 0x71, 
   0x09, 0x49, 0x29, 0x69, 0x19, 0x59, 0x39, 0x79, 
   0x05, 0x45, 0x25, 0x65, 0x15, 0x55, 0x35, 0x75, 
   0x0d, 0x4d, 0x2d, 0x6d, 0x1d, 0x5d, 0x3d, 0x7d, 
   0x03, 0x43, 0x23, 0x63, 0x13, 0x53, 0x33, 0x73, 
   0x0b, 0x4b, 0x2b, 0x6b, 0x1b, 0x5b, 0x3b, 0x7b, 
   0x07, 0x47, 0x27, 0x67, 0x17, 0x57, 0x37, 0x77, 
   0x0f, 0x4f, 0x2f, 0x6f, 0x1f, 0x5f, 0x3f, 0x7f
};
static unsigned char mpeg_bit_reverse_256[] = 
{
   0x00, 0x20, 0x10, 0x30, 0x08, 0x28, 0x18, 0x38, 
   0x04, 0x24, 0x14, 0x34, 0x0c, 0x2c, 0x1c, 0x3c, 
   0x02, 0x22, 0x12, 0x32, 0x0a, 0x2a, 0x1a, 0x3a, 
   0x06, 0x26, 0x16, 0x36, 0x0e, 0x2e, 0x1e, 0x3e,
   0x01, 0x21, 0x11, 0x31, 0x09, 0x29, 0x19, 0x39, 
   0x05, 0x25, 0x15, 0x35, 0x0d, 0x2d, 0x1d, 0x3d, 
   0x03, 0x23, 0x13, 0x33, 0x0b, 0x2b, 0x1b, 0x3b, 
   0x07, 0x27, 0x17, 0x37, 0x0f, 0x2f, 0x1f, 0x3f
};
static float mpeg_window[] = 
{
   0.00014, 0.00024, 0.00037, 0.00051, 0.00067, 0.00086, 0.00107, 0.00130, 
   0.00157, 0.00187, 0.00220, 0.00256, 0.00297, 0.00341, 0.00390, 0.00443, 
   0.00501, 0.00564, 0.00632, 0.00706, 0.00785, 0.00871, 0.00962, 0.01061, 
   0.01166, 0.01279, 0.01399, 0.01526, 0.01662, 0.01806, 0.01959, 0.02121, 
   0.02292, 0.02472, 0.02662, 0.02863, 0.03073, 0.03294, 0.03527, 0.03770, 
   0.04025, 0.04292, 0.04571, 0.04862, 0.05165, 0.05481, 0.05810, 0.06153, 
   0.06508, 0.06878, 0.07261, 0.07658, 0.08069, 0.08495, 0.08935, 0.09389, 
   0.09859, 0.10343, 0.10842, 0.11356, 0.11885, 0.12429, 0.12988, 0.13563, 
   0.14152, 0.14757, 0.15376, 0.16011, 0.16661, 0.17325, 0.18005, 0.18699, 
   0.19407, 0.20130, 0.20867, 0.21618, 0.22382, 0.23161, 0.23952, 0.24757, 
   0.25574, 0.26404, 0.27246, 0.28100, 0.28965, 0.29841, 0.30729, 0.31626, 
   0.32533, 0.33450, 0.34376, 0.35311, 0.36253, 0.37204, 0.38161, 0.39126, 
   0.40096, 0.41072, 0.42054, 0.43040, 0.44030, 0.45023, 0.46020, 0.47019,
   0.48020, 0.49022, 0.50025, 0.51028, 0.52031, 0.53033, 0.54033, 0.55031, 
   0.56026, 0.57019, 0.58007, 0.58991, 0.59970, 0.60944, 0.61912, 0.62873, 
   0.63827, 0.64774, 0.65713, 0.66643, 0.67564, 0.68476, 0.69377, 0.70269, 
   0.71150, 0.72019, 0.72877, 0.73723, 0.74557, 0.75378, 0.76186, 0.76981, 
   0.77762, 0.78530, 0.79283, 0.80022, 0.80747, 0.81457, 0.82151, 0.82831, 
   0.83496, 0.84145, 0.84779, 0.85398, 0.86001, 0.86588, 0.87160, 0.87716, 
   0.88257, 0.88782, 0.89291, 0.89785, 0.90264, 0.90728, 0.91176, 0.91610, 
   0.92028, 0.92432, 0.92822, 0.93197, 0.93558, 0.93906, 0.94240, 0.94560, 
   0.94867, 0.95162, 0.95444, 0.95713, 0.95971, 0.96217, 0.96451, 0.96674, 
   0.96887, 0.97089, 0.97281, 0.97463, 0.97635, 0.97799, 0.97953, 0.98099, 
   0.98236, 0.98366, 0.98488, 0.98602, 0.98710, 0.98811, 0.98905, 0.98994, 
   0.99076, 0.99153, 0.99225, 0.99291, 0.99353, 0.99411, 0.99464, 0.99513, 
   0.99558, 0.99600, 0.99639, 0.99674, 0.99706, 0.99736, 0.99763, 0.99788, 
   0.99811, 0.99831, 0.99850, 0.99867, 0.99882, 0.99895, 0.99908, 0.99919, 
   0.99929, 0.99938, 0.99946, 0.99953, 0.99959, 0.99965, 0.99969, 0.99974, 
   0.99978, 0.99981, 0.99984, 0.99986, 0.99988, 0.99990, 0.99992, 0.99993, 
   0.99994, 0.99995, 0.99996, 0.99997, 0.99998, 0.99998, 0.99998, 0.99999, 
   0.99999, 0.99999, 0.99999, 1.00000, 1.00000, 1.00000, 1.00000, 1.00000, 
   1.00000, 1.00000, 1.00000, 1.00000, 1.00000, 1.00000, 1.00000, 1.00000 
};
/***************************************************************************/
static struct al_table alloc_0[] = 
{
   {4, 0}, {5, 3}, {3, -3}, {4, -7}, {5, -15}, {6, -31}, {7, -63}, {8, -127}, {9, -255}, {10, -511}, 
   {11, -1023}, {12, -2047}, {13, -4095}, {14, -8191}, {15, -16383}, {16, -32767}, 
   {4, 0}, {5, 3}, {3, -3}, {4, -7}, {5, -15}, {6, -31}, {7, -63}, {8, -127}, {9, -255}, {10, -511}, 
   {11, -1023}, {12, -2047}, {13, -4095}, {14, -8191}, {15, -16383}, {16, -32767}, 
   {4, 0}, {5, 3}, {3, -3}, {4, -7}, {5, -15}, {6, -31}, {7, -63}, {8, -127}, {9, -255}, {10, -511}, 
   {11, -1023}, {12, -2047}, {13, -4095}, {14, -8191}, {15, -16383}, {16, -32767}, 
   {4, 0}, {5, 3}, {7, 5}, {3, -3}, {10, 9}, {4, -7}, {5, -15}, {6, -31}, {7, -63}, {8, -127}, 
   {9, -255}, {10, -511}, {11, -1023}, {12, -2047}, {13, -4095}, {16, -32767}, 
   {4, 0}, {5, 3}, {7, 5}, {3, -3}, {10, 9}, {4, -7}, {5, -15}, {6, -31}, {7, -63}, {8, -127}, 
   {9, -255}, {10, -511}, {11, -1023}, {12, -2047}, {13, -4095}, {16, -32767}, 
   {4, 0}, {5, 3}, {7, 5}, {3, -3}, {10, 9}, {4, -7}, {5, -15}, {6, -31}, {7, -63}, {8, -127}, 
   {9, -255}, {10, -511}, {11, -1023}, {12, -2047}, {13, -4095}, {16, -32767}, 
   {4, 0}, {5, 3}, {7, 5}, {3, -3}, {10, 9}, {4, -7}, {5, -15}, {6, -31}, {7, -63}, {8, -127}, 
   {9, -255}, {10, -511}, {11, -1023}, {12, -2047}, {13, -4095}, {16, -32767}, 
   {4, 0}, {5, 3}, {7, 5}, {3, -3}, {10, 9}, {4, -7}, {5, -15}, {6, -31}, {7, -63}, {8, -127}, 
   {9, -255}, {10, -511}, {11, -1023}, {12, -2047}, {13, -4095}, {16, -32767}, 
   {4, 0}, {5, 3}, {7, 5}, {3, -3}, {10, 9}, {4, -7}, {5, -15}, {6, -31}, {7, -63}, {8, -127},
   {9, -255}, {10, -511}, {11, -1023}, {12, -2047}, {13, -4095}, {16, -32767}, 
   {4, 0}, {5, 3}, {7, 5}, {3, -3}, {10, 9}, {4, -7}, {5, -15}, {6, -31}, {7, -63}, {8, -127}, 
   {9, -255}, {10, -511}, {11, -1023}, {12, -2047}, {13, -4095}, {16, -32767}, 
   {4, 0}, {5, 3}, {7, 5}, {3, -3}, {10, 9}, {4, -7}, {5, -15}, {6, -31}, {7, -63}, {8, -127}, 
   {9, -255}, {10, -511}, {11, -1023}, {12, -2047}, {13, -4095}, {16, -32767}, 
   {3, 0}, {5, 3}, {7, 5}, {3, -3}, {10, 9}, {4, -7}, {5, -15}, {16, -32767}, 
   {3, 0}, {5, 3}, {7, 5}, {3, -3}, {10, 9}, {4, -7}, {5, -15}, {16, -32767}, 
   {3, 0}, {5, 3}, {7, 5}, {3, -3}, {10, 9}, {4, -7}, {5, -15}, {16, -32767}, 
   {3, 0}, {5, 3}, {7, 5}, {3, -3}, {10, 9}, {4, -7}, {5, -15}, {16, -32767}, 
   {3, 0}, {5, 3}, {7, 5}, {3, -3}, {10, 9}, {4, -7}, {5, -15}, {16, -32767}, 
   {3, 0}, {5, 3}, {7, 5}, {3, -3}, {10, 9}, {4, -7}, {5, -15}, {16, -32767}, 
   {3, 0}, {5, 3}, {7, 5}, {3, -3}, {10, 9}, {4, -7}, {5, -15}, {16, -32767}, 
   {3, 0}, {5, 3}, {7, 5}, {3, -3}, {10, 9}, {4, -7}, {5, -15}, {16, -32767}, 
   {3, 0}, {5, 3}, {7, 5}, {3, -3}, {10, 9}, {4, -7}, {5, -15}, {16, -32767}, 
   {3, 0}, {5, 3}, {7, 5}, {3, -3}, {10, 9}, {4, -7}, {5, -15}, {16, -32767}, 
   {3, 0}, {5, 3}, {7, 5}, {3, -3}, {10, 9}, {4, -7}, {5, -15}, {16, -32767}, 
   {3, 0}, {5, 3}, {7, 5}, {3, -3}, {10, 9}, {4, -7}, {5, -15}, {16, -32767}, 
   {2, 0}, {5, 3}, {7, 5}, {16, -32767}, 
   {2, 0}, {5, 3}, {7, 5}, {16, -32767}, 
   {2, 0}, {5, 3}, {7, 5}, {16, -32767},
   {2, 0}, {5, 3}, {7, 5}, {16, -32767}
};
static struct al_table alloc_1[] = 
{
   {4, 0}, {5, 3}, {3, -3}, {4, -7}, {5, -15}, {6, -31}, {7, -63}, {8, -127}, {9, -255}, {10, -511}, 
   {11, -1023}, {12, -2047}, {13, -4095}, {14, -8191}, {15, -16383}, {16, -32767}, 
   {4, 0}, {5, 3}, {3, -3}, {4, -7}, {5, -15}, {6, -31}, {7, -63}, {8, -127}, {9, -255}, {10, -511}, 
   {11, -1023}, {12, -2047}, {13, -4095}, {14, -8191}, {15, -16383}, {16, -32767}, 
   {4, 0}, {5, 3}, {3, -3}, {4, -7}, {5, -15}, {6, -31}, {7, -63}, {8, -127}, {9, -255}, {10, -511}, 
   {11, -1023}, {12, -2047}, {13, -4095}, {14, -8191}, {15, -16383}, {16, -32767}, 
   {4, 0}, {5, 3}, {7, 5}, {3, -3}, {10, 9}, {4, -7}, {5, -15}, {6, -31}, {7, -63}, {8, -127}, 
   {9, -255}, {10, -511}, {11, -1023}, {12, -2047}, {13, -4095}, {16, -32767}, 
   {4, 0}, {5, 3}, {7, 5}, {3, -3}, {10, 9}, {4, -7}, {5, -15}, {6, -31}, {7, -63}, {8, -127}, 
   {9, -255}, {10, -511}, {11, -1023}, {12, -2047}, {13, -4095}, {16, -32767}, 
   {4, 0}, {5, 3}, {7, 5}, {3, -3}, {10, 9}, {4, -7}, {5, -15}, {6, -31}, {7, -63}, {8, -127}, 
   {9, -255}, {10, -511}, {11, -1023}, {12, -2047}, {13, -4095}, {16, -32767}, 
   {4, 0}, {5, 3}, {7, 5}, {3, -3}, {10, 9}, {4, -7}, {5, -15}, {6, -31}, {7, -63}, {8, -127}, 
   {9, -255}, {10, -511}, {11, -1023}, {12, -2047}, {13, -4095}, {16, -32767}, 
   {4, 0}, {5, 3}, {7, 5}, {3, -3}, {10, 9}, {4, -7}, {5, -15}, {6, -31}, {7, -63}, {8, -127}, 
   {9, -255}, {10, -511}, {11, -1023}, {12, -2047}, {13, -4095}, {16, -32767},
   {4, 0}, {5, 3}, {7, 5}, {3, -3}, {10, 9}, {4, -7}, {5, -15}, {6, -31}, {7, -63}, {8, -127}, 
   {9, -255}, {10, -511}, {11, -1023}, {12, -2047}, {13, -4095}, {16, -32767}, 
   {4, 0}, {5, 3}, {7, 5}, {3, -3}, {10, 9}, {4, -7}, {5, -15}, {6, -31}, {7, -63}, {8, -127}, 
   {9, -255}, {10, -511}, {11, -1023}, {12, -2047}, {13, -4095}, {16, -32767}, 
   {4, 0}, {5, 3}, {7, 5}, {3, -3}, {10, 9}, {4, -7}, {5, -15}, {6, -31}, {7, -63}, {8, -127}, 
   {9, -255}, {10, -511}, {11, -1023}, {12, -2047}, {13, -4095}, {16, -32767}, 
   {3, 0}, {5, 3}, {7, 5}, {3, -3}, {10, 9}, {4, -7}, {5, -15}, {16, -32767}, 
   {3, 0}, {5, 3}, {7, 5}, {3, -3}, {10, 9}, {4, -7}, {5, -15}, {16, -32767}, 
   {3, 0}, {5, 3}, {7, 5}, {3, -3}, {10, 9}, {4, -7}, {5, -15}, {16, -32767}, 
   {3, 0}, {5, 3}, {7, 5}, {3, -3}, {10, 9}, {4, -7}, {5, -15}, {16, -32767}, 
   {3, 0}, {5, 3}, {7, 5}, {3, -3}, {10, 9}, {4, -7}, {5, -15}, {16, -32767}, 
   {3, 0}, {5, 3}, {7, 5}, {3, -3}, {10, 9}, {4, -7}, {5, -15}, {16, -32767}, 
   {3, 0}, {5, 3}, {7, 5}, {3, -3}, {10, 9}, {4, -7}, {5, -15}, {16, -32767}, 
   {3, 0}, {5, 3}, {7, 5}, {3, -3}, {10, 9}, {4, -7}, {5, -15}, {16, -32767}, 
   {3, 0}, {5, 3}, {7, 5}, {3, -3}, {10, 9}, {4, -7}, {5, -15}, {16, -32767}, 
   {3, 0}, {5, 3}, {7, 5}, {3, -3}, {10, 9}, {4, -7}, {5, -15}, {16, -32767}, 
   {3, 0}, {5, 3}, {7, 5}, {3, -3}, {10, 9}, {4, -7}, {5, -15}, {16, -32767}, 
   {3, 0}, {5, 3}, {7, 5}, {3, -3}, {10, 9}, {4, -7}, {5, -15}, {16, -32767}, 
   {2, 0}, {5, 3}, {7, 5}, {16, -32767}, 
   {2, 0}, {5, 3}, {7, 5}, {16, -32767},
   {2, 0}, {5, 3}, {7, 5}, {16, -32767}, 
   {2, 0}, {5, 3}, {7, 5}, {16, -32767}, 
   {2, 0}, {5, 3}, {7, 5}, {16, -32767}, 
   {2, 0}, {5, 3}, {7, 5}, {16, -32767}, 
   {2, 0}, {5, 3}, {7, 5}, {16, -32767}
};
static struct al_table alloc_2[] = 
{
   {4, 0}, {5, 3}, {7, 5}, {10, 9}, {4, -7}, {5, -15}, {6, -31}, {7, -63}, {8, -127}, {9, -255}, 
   {10, -511}, {11, -1023}, {12, -2047}, {13, -4095}, {14, -8191}, {15, -16383}, 
   {4, 0}, {5, 3}, {7, 5}, {10, 9}, {4, -7}, {5, -15}, {6, -31}, {7, -63}, {8, -127}, {9, -255}, 
   {10, -511}, {11, -1023}, {12, -2047}, {13, -4095}, {14, -8191}, {15, -16383}, 
   {3, 0}, {5, 3}, {7, 5}, {10, 9}, {4, -7}, {5, -15}, {6, -31}, {7, -63}, 
   {3, 0}, {5, 3}, {7, 5}, {10, 9}, {4, -7}, {5, -15}, {6, -31}, {7, -63}, 
   {3, 0}, {5, 3}, {7, 5}, {10, 9}, {4, -7}, {5, -15}, {6, -31}, {7, -63}, 
   {3, 0}, {5, 3}, {7, 5}, {10, 9}, {4, -7}, {5, -15}, {6, -31}, {7, -63}, 
   {3, 0}, {5, 3}, {7, 5}, {10, 9}, {4, -7}, {5, -15}, {6, -31}, {7, -63}, 
   {3, 0}, {5, 3}, {7, 5}, {10, 9}, {4, -7}, {5, -15}, {6, -31}, {7, -63}
};
static struct al_table alloc_3[] =
{
   {4, 0}, {5, 3}, {7, 5}, {10, 9}, {4, -7}, {5, -15}, {6, -31}, {7, -63}, {8, -127}, {9, -255}, 
   {10, -511}, {11, -1023}, {12, -2047}, {13, -4095}, {14, -8191}, {15, -16383}, 
   {4, 0}, {5, 3}, {7, 5}, {10, 9}, {4, -7}, {5, -15}, {6, -31}, {7, -63}, {8, -127}, {9, -255}, 
   {10, -511}, {11, -1023}, {12, -2047}, {13, -4095}, {14, -8191}, {15, -16383}, 
   {3, 0}, {5, 3}, {7, 5}, {10, 9}, {4, -7}, {5, -15}, {6, -31}, {7, -63}, 
   {3, 0}, {5, 3}, {7, 5}, {10, 9}, {4, -7}, {5, -15}, {6, -31}, {7, -63}, 
   {3, 0}, {5, 3}, {7, 5}, {10, 9}, {4, -7}, {5, -15}, {6, -31}, {7, -63}, 
   {3, 0}, {5, 3}, {7, 5}, {10, 9}, {4, -7}, {5, -15}, {6, -31}, {7, -63}, 
   {3, 0}, {5, 3}, {7, 5}, {10, 9}, {4, -7}, {5, -15}, {6, -31}, {7, -63}, 
   {3, 0}, {5, 3}, {7, 5}, {10, 9}, {4, -7}, {5, -15}, {6, -31}, {7, -63}, 
   {3, 0}, {5, 3}, {7, 5}, {10, 9}, {4, -7}, {5, -15}, {6, -31}, {7, -63}, 
   {3, 0}, {5, 3}, {7, 5}, {10, 9}, {4, -7}, {5, -15}, {6, -31}, {7, -63}, 
   {3, 0}, {5, 3}, {7, 5}, {10, 9}, {4, -7}, {5, -15}, {6, -31}, {7, -63}, 
   {3, 0}, {5, 3}, {7, 5}, {10, 9}, {4, -7}, {5, -15}, {6, -31}, {7, -63}
};
static struct al_table alloc_4[] = 
{
   {4, 0}, {5, 3}, {7, 5}, {3, -3}, {10, 9}, {4, -7}, {5, -15}, {6, -31}, {7, -63}, {8, -127}, 
   {9, -255}, {10, -511}, {11, -1023}, {12, -2047}, {13, -4095}, {14, -8191},
   {4, 0}, {5, 3}, {7, 5}, {3, -3}, {10, 9}, {4, -7}, {5, -15}, {6, -31}, {7, -63}, {8, -127}, 
   {9, -255}, {10, -511}, {11, -1023}, {12, -2047}, {13, -4095}, {14, -8191}, 
   {4, 0}, {5, 3}, {7, 5}, {3, -3}, {10, 9}, {4, -7}, {5, -15}, {6, -31}, {7, -63}, {8, -127}, 
   {9, -255}, {10, -511}, {11, -1023}, {12, -2047}, {13, -4095}, {14, -8191}, 
   {4, 0}, {5, 3}, {7, 5}, {3, -3}, {10, 9}, {4, -7}, {5, -15}, {6, -31}, {7, -63}, {8, -127}, 
   {9, -255}, {10, -511}, {11, -1023}, {12, -2047}, {13, -4095}, {14, -8191}, 
   {3, 0}, {5, 3}, {7, 5}, {10, 9}, {4, -7}, {5, -15}, {6, -31}, {7, -63}, 
   {3, 0}, {5, 3}, {7, 5}, {10, 9}, {4, -7}, {5, -15}, {6, -31}, {7, -63}, 
   {3, 0}, {5, 3}, {7, 5}, {10, 9}, {4, -7}, {5, -15}, {6, -31}, {7, -63}, 
   {3, 0}, {5, 3}, {7, 5}, {10, 9}, {4, -7}, {5, -15}, {6, -31}, {7, -63}, 
   {3, 0}, {5, 3}, {7, 5}, {10, 9}, {4, -7}, {5, -15}, {6, -31}, {7, -63}, 
   {3, 0}, {5, 3}, {7, 5}, {10, 9}, {4, -7}, {5, -15}, {6, -31}, {7, -63}, 
   {3, 0}, {5, 3}, {7, 5}, {10, 9}, {4, -7}, {5, -15}, {6, -31}, {7, -63}, 
   {2, 0}, {5, 3}, {7, 5}, {10, 9}, 
   {2, 0}, {5, 3}, {7, 5}, {10, 9}, 
   {2, 0}, {5, 3}, {7, 5}, {10, 9}, 
   {2, 0}, {5, 3}, {7, 5}, {10, 9}, 
   {2, 0}, {5, 3}, {7, 5}, {10, 9}, 
   {2, 0}, {5, 3}, {7, 5}, {10, 9}, 
   {2, 0}, {5, 3}, {7, 5}, {10, 9},
   {2, 0}, {5, 3}, {7, 5}, {10, 9}, 
   {2, 0}, {5, 3}, {7, 5}, {10, 9}, 
   {2, 0}, {5, 3}, {7, 5}, {10, 9}, 
   {2, 0}, {5, 3}, {7, 5}, {10, 9}, 
   {2, 0}, {5, 3}, {7, 5}, {10, 9}, 
   {2, 0}, {5, 3}, {7, 5}, {10, 9}, 
   {2, 0}, {5, 3}, {7, 5}, {10, 9}, 
   {2, 0}, {5, 3}, {7, 5}, {10, 9}, 
   {2, 0}, {5, 3}, {7, 5}, {10, 9}, 
   {2, 0}, {5, 3}, {7, 5}, {10, 9}, 
   {2, 0}, {5, 3}, {7, 5}, {10, 9}, 
   {2, 0}, {5, 3}, {7, 5}, {10, 9}
};
/***************************************************************************/
struct gr_info_s 
{
   int scfsi;
   unsigned part2_3_length;
   unsigned big_values;
   unsigned scalefac_compress;
   unsigned block_type;
   unsigned mixed_block_flag;
   unsigned table_select[ 3 ];
   unsigned subblock_gain[ 3 ];
   unsigned maxband[ 3 ];
   unsigned maxbandl;
   unsigned maxb;
   unsigned region1start;
   unsigned region2start;
   unsigned preflag;
   unsigned scalefac_scale;
   unsigned count1table_select;
   float *full_gain[ 3 ];
   float *pow2gain;
};
struct mpeg_III_sideinfo
{
   unsigned main_data_begin;
   unsigned private_bits;
   struct
   {
      struct gr_info_s gr[ 2 ];
   } ch[ 2 ];
};
static int pretab1[ 22 ] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 3, 3, 3, 2, 0};
static int pretab2[ 22 ] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
#define BITSHIFT                 ( ( sizeof( long ) - 1 ) * 8 )
#define REFRESH_MASK             while( num < BITSHIFT ) {mask |= mpeg_bits_getbits( audio->astream, 8 ) << ( BITSHIFT - num ); num += 8; part2remain -= 8; }
static long mpeg_freqs[ 9 ] = {44100, 48000, 32000, 22050, 24000, 16000 , 11025 , 12000 , 8000 };
static float mpeg_decwin[ 512 + 32 ];
static float mpeg_cos64[ 16 ], mpeg_cos32[ 8 ], mpeg_cos16[ 4 ], mpeg_cos8[ 2 ], mpeg_cos4[ 1 ];
static float *mpeg_pnts[] = {mpeg_cos64, mpeg_cos32, mpeg_cos16, mpeg_cos8, mpeg_cos4 };
static int mpeg_grp_3tab[ 32 * 3 ] = {0, };
static int mpeg_grp_5tab[ 128 * 3 ] = {0, };
static int mpeg_grp_9tab[ 1024 * 3 ] = {0, };
static float mpeg_muls[ 27 ][ 64 ];	
static float mpeg_gainpow2[ 256 + 118 + 4 ];
static float mpeg_ispow[ 8207 ];
static float mpeg_aa_ca[ 8 ], mpeg_aa_cs[ 8 ];
static float mpeg_win[ 4 ][ 36 ];
static float mpeg_win1[ 4 ][ 36 ];
static float mpeg_COS1[ 12 ][ 6 ];
static float mpeg_COS9[ 9 ];
static float mpeg_COS6_1, mpeg_COS6_2;
static float mpeg_tfcos36[ 9 ];
static float mpeg_tfcos12[ 3 ];
static float mpeg_cos9[ 3 ], mpeg_cos18[ 3 ];
static float mpeg_tan1_1[ 16 ], mpeg_tan2_1[ 16 ], mpeg_tan1_2[ 16 ], mpeg_tan2_2[ 16 ];
static float mpeg_pow1_1[ 2 ][ 16 ], mpeg_pow2_1[ 2 ][ 16 ], mpeg_pow1_2[ 2 ][ 16 ], mpeg_pow2_2[ 2 ][ 16 ];
static long mpeg_intwinbase[] = 
{
   0, -1, -1, -1, -1, -1, -1, -2, -2, -2, 
   -2, -3, -3, -4, -4, -5, -5, -6, -7, -7, 
   -8, -9, -10, -11, -13, -14, -16, -17, -19, -21, 
   -24, -26, -29, -31, -35, -38, -41, -45, -49, -53, 
   -58, -63, -68, -73, -79, -85, -91, -97, -104, -111, 
   -117, -125, -132, -139, -147, -154, -161, -169, -176, -183, 
   -190, -196, -202, -208, -213, -218, -222, -225, -227, -228, 
   -228, -227, -224, -221, -215, -208, -200, -189, -177, -163, 
   -146, -127, -106, -83, -57, -29, 2, 36, 72, 111,
   153, 197, 244, 294, 347, 401, 459, 519, 581, 645, 
   711, 779, 848, 919, 991, 1064, 1137, 1210, 1283, 1356, 
   1428, 1498, 1567, 1634, 1698, 1759, 1817, 1870, 1919, 1962, 
   2001, 2032, 2057, 2075, 2085, 2087, 2080, 2063, 2037, 2000, 
   1952, 1893, 1822, 1739, 1644, 1535, 1414, 1280, 1131, 970, 
   794, 605, 402, 185, -45, -288, -545, -814, -1095, -1388, 
   -1692, -2006, -2330, -2663, -3004, -3351, -3705, -4063, -4425, -4788, 
   -5153, -5517, -5879, -6237, -6589, -6935, -7271, -7597, -7910, -8209, 
   -8491, -8755, -8998, -9219, -9416, -9585, -9727, -9838, -9916, -9959, 
   -9966, -9935, -9863, -9750, -9592, -9389, -9139, -8840, -8492, -8092, 
   -7640, -7134, -6574, -5959, -5288, -4561, -3776, -2935, -2037, -1082, 
   -70, 998, 2122, 3300, 4533, 5818, 7154, 8540, 9975, 11455, 
   12980, 14548, 16155, 17799, 19478, 21189, 22929, 24694, 26482, 28289, 
   30112, 31947, 33791, 35640, 37489, 39336, 41176, 43006, 44821, 46617, 
   48390, 50137, 51853, 53534, 55178, 56778, 58333, 59838, 61289, 62684, 
   64019, 65290, 66494, 67629, 68692, 69679, 70590, 71420, 72169, 72835, 
   73415, 73908, 74313, 74630, 74856, 74992, 75038
};
static int mpeg_longLimit[ 9 ][ 23 ];
static int mpeg_shortLimit[ 9 ][ 14 ];
struct mpeg_bandInfoStruct mpeg_bandInfo[ 9 ] = 
{
   {{0, 4, 8, 12, 16, 20, 24, 30, 36, 44, 52, 62, 74, 90, 110, 134, 162, 196, 238, 288, 342, 418, 576}, 
   {4, 4, 4, 4, 4, 4, 6, 6, 8, 8, 10, 12, 16, 20, 24, 28, 34, 42, 50, 54, 76, 158}, 
   {0, 4*3, 8*3, 12*3, 16*3, 22*3, 30*3, 40*3, 52*3, 66*3, 84*3, 106*3, 136*3, 192*3}, 
   {4, 4, 4, 4, 6, 8, 10, 12, 14, 18, 22, 30, 56} } , 
   {{0, 4, 8, 12, 16, 20, 24, 30, 36, 42, 50, 60, 72, 88, 106, 128, 156, 190, 230, 276, 330, 384, 576}, 
   {4, 4, 4, 4, 4, 4, 6, 6, 6, 8, 10, 12, 16, 18, 22, 28, 34, 40, 46, 54, 54, 192}, 
   {0, 4*3, 8*3, 12*3, 16*3, 22*3, 28*3, 38*3, 50*3, 64*3, 80*3, 100*3, 126*3, 192*3}, 
   {4, 4, 4, 4, 6, 6, 10, 12, 14, 16, 20, 26, 66} } , 
   {{0, 4, 8, 12, 16, 20, 24, 30, 36, 44, 54, 66, 82, 102, 126, 156, 194, 240, 296, 364, 448, 550, 576} , 
   {4, 4, 4, 4, 4, 4, 6, 6, 8, 10, 12, 16, 20, 24, 30, 38, 46, 56, 68, 84, 102, 26} , 
   {0, 4*3, 8*3, 12*3, 16*3, 22*3, 30*3, 42*3, 58*3, 78*3, 104*3, 138*3, 180*3, 192*3} , 
   {4, 4, 4, 4, 6, 8, 12, 16, 20, 26, 34, 42, 12} } , 
   {{0, 6, 12, 18, 24, 30, 36, 44, 54, 66, 80, 96, 116, 140, 168, 200, 238, 284, 336, 396, 464, 522, 576}, 
   {6, 6, 6, 6, 6, 6, 8, 10, 12, 14, 16, 20, 24, 28, 32, 38, 46, 52, 60, 68, 58, 54 } , 
   {0, 4*3, 8*3, 12*3, 18*3, 24*3, 32*3, 42*3, 56*3, 74*3, 100*3, 132*3, 174*3, 192*3} , 
   {4, 4, 4, 6, 6, 8, 10, 14, 18, 26, 32, 42, 18 } } , 
   {{0, 6, 12, 18, 24, 30, 36, 44, 54, 66, 80, 96, 114, 136, 162, 194, 232, 278, 330, 394, 464, 540, 576}, 
   {6, 6, 6, 6, 6, 6, 8, 10, 12, 14, 16, 18, 22, 26, 32, 38, 46, 52, 64, 70, 76, 36 } ,
   {0, 4*3, 8*3, 12*3, 18*3, 26*3, 36*3, 48*3, 62*3, 80*3, 104*3, 136*3, 180*3, 192*3} , 
   {4, 4, 4, 6, 8, 10, 12, 14, 18, 24, 32, 44, 12 } } , 
   {{0, 6, 12, 18, 24, 30, 36, 44, 54, 66, 80, 96, 116, 140, 168, 200, 238, 284, 336, 396, 464, 522, 576}, 
   {6, 6, 6, 6, 6, 6, 8, 10, 12, 14, 16, 20, 24, 28, 32, 38, 46, 52, 60, 68, 58, 54 }, 
   {0, 4*3, 8*3, 12*3, 18*3, 26*3, 36*3, 48*3, 62*3, 80*3, 104*3, 134*3, 174*3, 192*3}, 
   {4, 4, 4, 6, 8, 10, 12, 14, 18, 24, 30, 40, 18 } } , 
   {{0, 6, 12, 18, 24, 30, 36, 44, 54, 66, 80, 96, 116, 140, 168, 200, 238, 284, 336, 396, 464, 522, 576} , 
   {6, 6, 6, 6, 6, 6, 8, 10, 12, 14, 16, 20, 24, 28, 32, 38, 46, 52, 60, 68, 58, 54}, 
   {0, 12, 24, 36, 54, 78, 108, 144, 186, 240, 312, 402, 522, 576}, 
   {4, 4, 4, 6, 8, 10, 12, 14, 18, 24, 30, 40, 18} }, 
   {{0, 6, 12, 18, 24, 30, 36, 44, 54, 66, 80, 96, 116, 140, 168, 200, 238, 284, 336, 396, 464, 522, 576} , 
   {6, 6, 6, 6, 6, 6, 8, 10, 12, 14, 16, 20, 24, 28, 32, 38, 46, 52, 60, 68, 58, 54}, 
   {0, 12, 24, 36, 54, 78, 108, 144, 186, 240, 312, 402, 522, 576}, 
   {4, 4, 4, 6, 8, 10, 12, 14, 18, 24, 30, 40, 18} }, 
   {{0, 12, 24, 36, 48, 60, 72, 88, 108, 132, 160, 192, 232, 280, 336, 400, 476, 566, 568, 570, 572, 574, 576}, 
   {12, 12, 12, 12, 12, 12, 16, 20, 24, 28, 32, 40, 48, 56, 64, 76, 90, 2, 2, 2, 2, 2}, 
   {0, 24, 48, 72, 108, 156, 216, 288, 372, 480, 486, 492, 498, 576}, 
   {8, 8, 8, 12, 16, 20, 24, 28, 36, 2, 2, 2, 26} } , 
};
static int mpeg_mapbuf0[ 9 ][ 152 ];
static int mpeg_mapbuf1[ 9 ][ 156 ];
static int mpeg_mapbuf2[ 9 ][ 44 ];
static int *mpeg_map[ 9 ][ 3 ];
static int *mpeg_mapend[ 9 ][ 3 ];
static unsigned int mpeg_n_slen2[ 512 ]; 
static unsigned int mpeg_i_slen2[ 256 ]; 
static unsigned char mpeg_zig_zag_scan_nommx[ 64 ] =
{
   0, 1, 8, 16, 9, 2, 3, 10, 17, 24, 32, 25, 18, 11, 4, 5, 
   12, 19, 26, 33, 40, 48, 41, 34, 27, 20, 13, 6, 7, 14, 21, 28, 
   35, 42, 49, 56, 57, 50, 43, 36, 29, 22, 15, 23, 30, 37, 44, 51, 
   58, 59, 52, 45, 38, 31, 39, 46, 53, 60, 61, 54, 47, 55, 62, 63
};
static unsigned char mpeg_alternate_scan_nommx[ 64 ] =
{
   0, 8, 16, 24, 1, 9, 2, 10, 17, 25, 32, 40, 48, 56, 57, 49, 
   41, 33, 26, 18, 3, 11, 4, 12, 19, 27, 34, 42, 50, 58, 35, 43, 
   51, 59, 20, 28, 5, 13, 6, 14, 21, 29, 36, 44, 52, 60, 37, 45, 
   53, 61, 22, 30, 7, 15, 23, 31, 38, 46, 54, 62, 39, 47, 55, 63
};
static unsigned char mpeg_default_intra_quantizer_matrix[ 64 ] =
{
   8, 16, 19, 22, 26, 27, 29, 34, 
   16, 16, 22, 24, 27, 29, 34, 37, 
   19, 22, 26, 27, 29, 34, 34, 38, 
   22, 22, 26, 27, 29, 34, 37, 40, 
   22, 26, 27, 29, 32, 35, 40, 48, 
   26, 27, 29, 32, 35, 40, 48, 58, 
   26, 27, 29, 34, 38, 46, 56, 69, 
   27, 29, 35, 38, 46, 56, 69, 83
};
static unsigned char mpeg_non_linear_mquant_table[ 32 ] = 
{
   0, 1, 2, 3, 4, 5, 6, 7, 
   8, 10, 12, 14, 16, 18, 20, 22, 
   24, 28, 32, 36, 40, 44, 48, 52, 
   56, 64, 72, 80, 88, 96, 104, 112
};
static double mpeg_frame_rate_table[ 16 ] =
{
   0.0, 
   24000.0/1001.0, 
   24.0, 
   25.0, 
   30000.0/1001.0, 
   30.0, 
   50.0, 
   ( ( 60.0*1000.0 )/1001.0 ), 
   60.0, 
   1, 
   5, 
   10, 
   12, 
   15, 
   0, 
   0, 
};
static unsigned char gClipArray[ 1026 ];
static unsigned short gClipArray16r[ 1026 ], gClipArray16g[ 1026 ], gClipArray16b[ 1026 ];
static unsigned char *gClipArray_ptr=&gClipArray[ 512 ];
static unsigned short *gClipArray_ptr16r=&gClipArray16r[ 512 ];
static unsigned short *gClipArray_ptr16g=&gClipArray16g[ 512 ];
static unsigned short *gClipArray_ptr16b=&gClipArray16b[ 512 ];
static int doClippingArrays=1;
static unsigned char mpeg_601_to_rgb[ 256 ];
typedef struct 
{
   sample_t q1[ 2 ];
   sample_t q2[ 2 ];
   sample_t q4;
   int q1_ptr;
   int q2_ptr;
   int q4_ptr;
} quantizer_t;
static uint8_t halfrate[ 12 ] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3};
static mpeg_VLCtab_t mpeg_PMBtab0[ 8 ] = 
{
   {MPERROR, 0}, 
   {MB_FORWARD, 3}, 
   {MB_PATTERN, 2}, {MB_PATTERN, 2},
   {MB_FORWARD|MB_PATTERN, 1}, {MB_FORWARD|MB_PATTERN, 1}, 
   {MB_FORWARD|MB_PATTERN, 1}, {MB_FORWARD|MB_PATTERN, 1}
};
static mpeg_VLCtab_t mpeg_PMBtab1[ 8 ] = 
{
   {MPERROR, 0}, 
   {MB_QUANT|MB_INTRA, 6}, 
   {MB_QUANT|MB_PATTERN, 5}, {MB_QUANT|MB_PATTERN, 5}, 
   {MB_QUANT|MB_FORWARD|MB_PATTERN, 5}, {MB_QUANT|MB_FORWARD|MB_PATTERN, 5}, 
   {MB_INTRA, 5}, {MB_INTRA, 5}
};
static mpeg_VLCtab_t mpeg_BMBtab0[ 16 ] = 
{
   {MPERROR, 0}, {MPERROR, 0}, 
   {MB_FORWARD, 4}, 
   {MB_FORWARD|MB_PATTERN, 4}, 
   {MB_BACKWARD, 3}, {MB_BACKWARD, 3}, 
   {MB_BACKWARD|MB_PATTERN, 3}, {MB_BACKWARD|MB_PATTERN, 3}, 
   {MB_FORWARD|MB_BACKWARD, 2}, {MB_FORWARD|MB_BACKWARD, 2}, 
   {MB_FORWARD|MB_BACKWARD, 2}, {MB_FORWARD|MB_BACKWARD, 2},
   {MB_FORWARD|MB_BACKWARD|MB_PATTERN, 2}, 
   {MB_FORWARD|MB_BACKWARD|MB_PATTERN, 2}, 
   {MB_FORWARD|MB_BACKWARD|MB_PATTERN, 2}, 
   {MB_FORWARD|MB_BACKWARD|MB_PATTERN, 2}
};
static mpeg_VLCtab_t mpeg_BMBtab1[ 8 ] = 
{
   {MPERROR, 0}, 
   {MB_QUANT|MB_INTRA, 6}, 
   {MB_QUANT|MB_BACKWARD|MB_PATTERN, 6}, 
   {MB_QUANT|MB_FORWARD|MB_PATTERN, 6}, 
   {MB_QUANT|MB_FORWARD|MB_BACKWARD|MB_PATTERN, 5}, 
   {MB_QUANT|MB_FORWARD|MB_BACKWARD|MB_PATTERN, 5}, 
   {MB_INTRA, 5}, {MB_INTRA, 5}
};
static mpeg_VLCtab_t mpeg_spIMBtab[ 16 ] = 
{
   {MPERROR, 0}, 
   {MB_CLASS4, 4}, 
   {MB_QUANT|MB_INTRA, 4},
   {MB_INTRA, 4}, 
   {MB_CLASS4|MB_QUANT|MB_PATTERN, 2}, {MB_CLASS4|MB_QUANT|MB_PATTERN, 2}, 
   {MB_CLASS4|MB_QUANT|MB_PATTERN, 2}, {MB_CLASS4|MB_QUANT|MB_PATTERN, 2}, 
   {MB_CLASS4|MB_PATTERN, 1}, {MB_CLASS4|MB_PATTERN, 1}, 
   {MB_CLASS4|MB_PATTERN, 1}, {MB_CLASS4|MB_PATTERN, 1}, 
   {MB_CLASS4|MB_PATTERN, 1}, {MB_CLASS4|MB_PATTERN, 1}, 
   {MB_CLASS4|MB_PATTERN, 1}, {MB_CLASS4|MB_PATTERN, 1}
};
static mpeg_VLCtab_t mpeg_spPMBtab0[ 16 ] =
{
   {MPERROR, 0}, {MPERROR, 0}, 
   {MB_FORWARD, 4}, 
   {MB_WEIGHT|MB_FORWARD, 4}, 
   {MB_QUANT|MB_FORWARD|MB_PATTERN, 3}, {MB_QUANT|MB_FORWARD|MB_PATTERN, 3}, 
   {MB_WEIGHT|MB_FORWARD|MB_PATTERN, 3}, {MB_WEIGHT|MB_FORWARD|MB_PATTERN, 3}, 
   {MB_FORWARD|MB_PATTERN, 2}, {MB_FORWARD|MB_PATTERN, 2}, 
   {MB_FORWARD|MB_PATTERN, 2}, {MB_FORWARD|MB_PATTERN, 2}, 
   {MB_WEIGHT|MB_QUANT|MB_FORWARD|MB_PATTERN, 2}, 
   {MB_WEIGHT|MB_QUANT|MB_FORWARD|MB_PATTERN, 2}, 
   {MB_WEIGHT|MB_QUANT|MB_FORWARD|MB_PATTERN, 2},
   {MB_WEIGHT|MB_QUANT|MB_FORWARD|MB_PATTERN, 2}
};
static mpeg_VLCtab_t mpeg_spPMBtab1[ 16 ] = 
{
   {MPERROR, 0}, {MPERROR, 0}, 
   {MB_CLASS4|MB_QUANT|MB_PATTERN, 7}, 
   {MB_CLASS4, 7}, 
   {MB_PATTERN, 7}, 
   {MB_CLASS4|MB_PATTERN, 7}, 
   {MB_QUANT|MB_INTRA, 7}, 
   {MB_INTRA, 7}, 
   {MB_QUANT|MB_PATTERN, 6}, {MB_QUANT|MB_PATTERN, 6}, 
   {MB_WEIGHT|MB_QUANT|MB_PATTERN, 6}, {MB_WEIGHT|MB_QUANT|MB_PATTERN, 6}, 
   {MB_WEIGHT, 6}, {MB_WEIGHT, 6}, 
   {MB_WEIGHT|MB_PATTERN, 6}, {MB_WEIGHT|MB_PATTERN, 6}
};
static mpeg_VLCtab_t mpeg_spBMBtab0[ 14 ] = 
{
   {MB_FORWARD, 4}, 
   {MB_FORWARD|MB_PATTERN, 4},
   {MB_BACKWARD, 3}, {MB_BACKWARD, 3}, 
   {MB_BACKWARD|MB_PATTERN, 3}, {MB_BACKWARD|MB_PATTERN, 3}, 
   {MB_FORWARD|MB_BACKWARD, 2}, {MB_FORWARD|MB_BACKWARD, 2}, 
   {MB_FORWARD|MB_BACKWARD, 2}, {MB_FORWARD|MB_BACKWARD, 2}, 
   {MB_FORWARD|MB_BACKWARD|MB_PATTERN, 2}, 
   {MB_FORWARD|MB_BACKWARD|MB_PATTERN, 2}, 
   {MB_FORWARD|MB_BACKWARD|MB_PATTERN, 2}, 
   {MB_FORWARD|MB_BACKWARD|MB_PATTERN, 2}
};
static mpeg_VLCtab_t mpeg_spBMBtab1[ 12 ] = 
{
   {MB_QUANT|MB_FORWARD|MB_PATTERN, 7}, 
   {MB_QUANT|MB_BACKWARD|MB_PATTERN, 7}, 
   {MB_INTRA, 7}, 
   {MB_QUANT|MB_FORWARD|MB_BACKWARD|MB_PATTERN, 7}, 
   {MB_WEIGHT|MB_FORWARD, 6}, {MB_WEIGHT|MB_FORWARD, 6}, 
   {MB_WEIGHT|MB_FORWARD|MB_PATTERN, 6}, {MB_WEIGHT|MB_FORWARD|MB_PATTERN, 6}, 
   {MB_WEIGHT|MB_BACKWARD, 6}, {MB_WEIGHT|MB_BACKWARD, 6}, 
   {MB_WEIGHT|MB_BACKWARD|MB_PATTERN, 6}, {MB_WEIGHT|MB_BACKWARD|MB_PATTERN, 6}
};
static mpeg_VLCtab_t mpeg_spBMBtab2[ 8 ] = 
{
   {MB_QUANT|MB_INTRA, 8}, {MB_QUANT|MB_INTRA, 8}, 
   {MB_WEIGHT|MB_QUANT|MB_FORWARD|MB_PATTERN, 8}, 
   {MB_WEIGHT|MB_QUANT|MB_FORWARD|MB_PATTERN, 8}, 
   {MB_WEIGHT|MB_QUANT|MB_BACKWARD|MB_PATTERN, 9}, 
   {MB_CLASS4|MB_QUANT|MB_PATTERN, 9}, 
   {MB_CLASS4, 9}, 
   {MB_CLASS4|MB_PATTERN, 9}
};
static mpeg_VLCtab_t mpeg_SNRMBtab[ 8 ] = 
{
   {MPERROR, 0}, 
   {0, 3}, 
   {MB_QUANT|MB_PATTERN, 2}, {MB_QUANT|MB_PATTERN, 2}, 
   {MB_PATTERN, 1}, {MB_PATTERN, 1}, {MB_PATTERN, 1}, {MB_PATTERN, 1}
};
static mpeg_VLCtab_t mpeg_MVtab0[ 8 ] =
{
   {MPERROR, 0}, {3, 3}, {2, 2}, {2, 2}, {1, 1}, {1, 1}, {1, 1}, {1, 1}
};
static mpeg_VLCtab_t mpeg_MVtab1[ 8 ] =
{
   {MPERROR, 0}, {MPERROR, 0}, {MPERROR, 0}, {7, 6}, {6, 6}, {5, 6}, {4, 5}, {4, 5}
};
static mpeg_VLCtab_t mpeg_MVtab2[ 12 ] =
{
   {16, 9}, {15, 9}, {14, 9}, {13, 9}, 
   {12, 9}, {11, 9}, {10, 8}, {10, 8}, 
   {9, 8}, {9, 8}, {8, 8}, {8, 8}
};
static mpeg_VLCtab_t mpeg_CBPtab0[ 32 ] =
{
   {MPERROR, 0}, {MPERROR, 0}, {MPERROR, 0}, {MPERROR, 0}, 
   {MPERROR, 0}, {MPERROR, 0}, {MPERROR, 0}, {MPERROR, 0}, 
   {62, 5}, {2, 5}, {61, 5}, {1, 5}, {56, 5}, {52, 5}, {44, 5}, {28, 5}, 
   {40, 5}, {20, 5}, {48, 5}, {12, 5}, {32, 4}, {32, 4}, {16, 4}, {16, 4}, 
   {8, 4}, {8, 4}, {4, 4}, {4, 4}, {60, 3}, {60, 3}, {60, 3}, {60, 3}
};
static mpeg_VLCtab_t mpeg_CBPtab1[ 64 ] =
{
   {MPERROR, 0}, {MPERROR, 0}, {MPERROR, 0}, {MPERROR, 0}, 
   {58, 8}, {54, 8}, {46, 8}, {30, 8}, 
   {57, 8}, {53, 8}, {45, 8}, {29, 8}, {38, 8}, {26, 8}, {37, 8}, {25, 8}, 
   {43, 8}, {23, 8}, {51, 8}, {15, 8}, {42, 8}, {22, 8}, {50, 8}, {14, 8}, 
   {41, 8}, {21, 8}, {49, 8}, {13, 8}, {35, 8}, {19, 8}, {11, 8}, {7, 8}, 
   {34, 7}, {34, 7}, {18, 7}, {18, 7}, {10, 7}, {10, 7}, {6, 7}, {6, 7}, 
   {33, 7}, {33, 7}, {17, 7}, {17, 7}, {9, 7}, {9, 7}, {5, 7}, {5, 7}, 
   {63, 6}, {63, 6}, {63, 6}, {63, 6}, {3, 6}, {3, 6}, {3, 6}, {3, 6}, 
   {36, 6}, {36, 6}, {36, 6}, {36, 6}, {24, 6}, {24, 6}, {24, 6}, {24, 6}
};
static mpeg_VLCtab_t mpeg_CBPtab2[ 8 ] =
{
   {MPERROR, 0}, {0, 9}, {39, 9}, {27, 9}, {59, 9}, {55, 9}, {47, 9}, {31, 9}
};
static mpeg_VLCtab_t mpeg_MBAtab1[ 16 ] =
{
   {MPERROR, 0}, {MPERROR, 0}, {7, 5}, {6, 5}, {5, 4}, {5, 4}, {4, 4}, {4, 4}, 
   {3, 3}, {3, 3}, {3, 3}, {3, 3}, {2, 3}, {2, 3}, {2, 3}, {2, 3}
};
static mpeg_VLCtab_t mpeg_MBAtab2[ 104 ] =
{
   {33, 11}, {32, 11}, {31, 11}, {30, 11}, {29, 11}, {28, 11}, {27, 11}, {26, 11}, 
   {25, 11}, {24, 11}, {23, 11}, {22, 11}, {21, 10}, {21, 10}, {20, 10}, {20, 10}, 
   {19, 10}, {19, 10}, {18, 10}, {18, 10}, {17, 10}, {17, 10}, {16, 10}, {16, 10}, 
   {15, 8}, {15, 8}, {15, 8}, {15, 8}, {15, 8}, {15, 8}, {15, 8}, {15, 8}, 
   {14, 8}, {14, 8}, {14, 8}, {14, 8}, {14, 8}, {14, 8}, {14, 8}, {14, 8}, 
   {13, 8}, {13, 8}, {13, 8}, {13, 8}, {13, 8}, {13, 8}, {13, 8}, {13, 8}, 
   {12, 8}, {12, 8}, {12, 8}, {12, 8}, {12, 8}, {12, 8}, {12, 8}, {12, 8}, 
   {11, 8}, {11, 8}, {11, 8}, {11, 8}, {11, 8}, {11, 8}, {11, 8}, {11, 8}, 
   {10, 8}, {10, 8}, {10, 8}, {10, 8}, {10, 8}, {10, 8}, {10, 8}, {10, 8}, 
   {9, 7}, {9, 7}, {9, 7}, {9, 7}, {9, 7}, {9, 7}, {9, 7}, {9, 7}, 
   {9, 7}, {9, 7}, {9, 7}, {9, 7}, {9, 7}, {9, 7}, {9, 7}, {9, 7}, 
   {8, 7}, {8, 7}, {8, 7}, {8, 7}, {8, 7}, {8, 7}, {8, 7}, {8, 7}, 
   {8, 7}, {8, 7}, {8, 7}, {8, 7}, {8, 7}, {8, 7}, {8, 7}, {8, 7}
};
static mpeg_VLCtab_t mpeg_DClumtab0[ 32 ] =
{
   {1, 2}, {1, 2}, {1, 2}, {1, 2}, {1, 2}, {1, 2}, {1, 2}, {1, 2}, 
   {2, 2}, {2, 2}, {2, 2}, {2, 2}, {2, 2}, {2, 2}, {2, 2}, {2, 2},
   {0, 3}, {0, 3}, {0, 3}, {0, 3}, {3, 3}, {3, 3}, {3, 3}, {3, 3}, 
   {4, 3}, {4, 3}, {4, 3}, {4, 3}, {5, 4}, {5, 4}, {6, 5}, {MPERROR, 0}
};
static mpeg_VLCtab_t mpeg_DClumtab1[ 16 ] =
{
   {7, 6}, {7, 6}, {7, 6}, {7, 6}, {7, 6}, {7, 6}, {7, 6}, {7, 6}, 
   {8, 7}, {8, 7}, {8, 7}, {8, 7}, {9, 8}, {9, 8}, {10, 9}, {11, 9}
};
static mpeg_VLCtab_t mpeg_DCchromtab0[ 32 ] =
{
   {0, 2}, {0, 2}, {0, 2}, {0, 2}, {0, 2}, {0, 2}, {0, 2}, {0, 2}, 
   {1, 2}, {1, 2}, {1, 2}, {1, 2}, {1, 2}, {1, 2}, {1, 2}, {1, 2}, 
   {2, 2}, {2, 2}, {2, 2}, {2, 2}, {2, 2}, {2, 2}, {2, 2}, {2, 2}, 
   {3, 3}, {3, 3}, {3, 3}, {3, 3}, {4, 4}, {4, 4}, {5, 5}, {MPERROR, 0}
};
static mpeg_VLCtab_t mpeg_DCchromtab1[ 32 ] =
{
   {6, 6}, {6, 6}, {6, 6}, {6, 6}, {6, 6}, {6, 6}, {6, 6}, {6, 6}, 
   {6, 6}, {6, 6}, {6, 6}, {6, 6}, {6, 6}, {6, 6}, {6, 6}, {6, 6}, 
   {7, 7}, {7, 7}, {7, 7}, {7, 7}, {7, 7}, {7, 7}, {7, 7}, {7, 7},
   {8, 8}, {8, 8}, {8, 8}, {8, 8}, {9, 9}, {9, 9}, {10, 10}, {11, 10}
};
static mpeg_DCTtab_t mpeg_DCTtabfirst[ 12 ] =
{
   {0, 2, 4}, {2, 1, 4}, {1, 1, 3}, {1, 1, 3}, 
   {0, 1, 1}, {0, 1, 1}, {0, 1, 1}, {0, 1, 1}, 
   {0, 1, 1}, {0, 1, 1}, {0, 1, 1}, {0, 1, 1}
};
static mpeg_DCTtab_t mpeg_DCTtabnext[ 12 ] =
{
   {0, 2, 4}, {2, 1, 4}, {1, 1, 3}, {1, 1, 3}, 
   {64, 0, 2}, {64, 0, 2}, {64, 0, 2}, {64, 0, 2}, 
   {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}
};
static mpeg_DCTtab_t mpeg_DCTtab0[ 60 ] =
{
   {65, 0, 6}, {65, 0, 6}, {65, 0, 6}, {65, 0, 6}, 
   {2, 2, 7}, {2, 2, 7}, {9, 1, 7}, {9, 1, 7}, 
   {0, 4, 7}, {0, 4, 7}, {8, 1, 7}, {8, 1, 7}, 
   {7, 1, 6}, {7, 1, 6}, {7, 1, 6}, {7, 1, 6},
   {6, 1, 6}, {6, 1, 6}, {6, 1, 6}, {6, 1, 6}, 
   {1, 2, 6}, {1, 2, 6}, {1, 2, 6}, {1, 2, 6}, 
   {5, 1, 6}, {5, 1, 6}, {5, 1, 6}, {5, 1, 6}, 
   {13, 1, 8}, {0, 6, 8}, {12, 1, 8}, {11, 1, 8}, 
   {3, 2, 8}, {1, 3, 8}, {0, 5, 8}, {10, 1, 8}, 
   {0, 3, 5}, {0, 3, 5}, {0, 3, 5}, {0, 3, 5}, 
   {0, 3, 5}, {0, 3, 5}, {0, 3, 5}, {0, 3, 5}, 
   {4, 1, 5}, {4, 1, 5}, {4, 1, 5}, {4, 1, 5}, 
   {4, 1, 5}, {4, 1, 5}, {4, 1, 5}, {4, 1, 5}, 
   {3, 1, 5}, {3, 1, 5}, {3, 1, 5}, {3, 1, 5}, 
   {3, 1, 5}, {3, 1, 5}, {3, 1, 5}, {3, 1, 5}
};
static mpeg_DCTtab_t mpeg_DCTtab0a[ 252 ] =
{
   {65, 0, 6}, {65, 0, 6}, {65, 0, 6}, {65, 0, 6}, 
   {7, 1, 7}, {7, 1, 7}, {8, 1, 7}, {8, 1, 7}, 
   {6, 1, 7}, {6, 1, 7}, {2, 2, 7}, {2, 2, 7}, 
   {0, 7, 6}, {0, 7, 6}, {0, 7, 6}, {0, 7, 6}, 
   {0, 6, 6}, {0, 6, 6}, {0, 6, 6}, {0, 6, 6}, 
   {4, 1, 6}, {4, 1, 6}, {4, 1, 6}, {4, 1, 6},
   {5, 1, 6}, {5, 1, 6}, {5, 1, 6}, {5, 1, 6}, 
   {1, 5, 8}, {11, 1, 8}, {0, 11, 8}, {0, 10, 8}, 
   {13, 1, 8}, {12, 1, 8}, {3, 2, 8}, {1, 4, 8}, 
   {2, 1, 5}, {2, 1, 5}, {2, 1, 5}, {2, 1, 5}, 
   {2, 1, 5}, {2, 1, 5}, {2, 1, 5}, {2, 1, 5}, 
   {1, 2, 5}, {1, 2, 5}, {1, 2, 5}, {1, 2, 5}, 
   {1, 2, 5}, {1, 2, 5}, {1, 2, 5}, {1, 2, 5}, 
   {3, 1, 5}, {3, 1, 5}, {3, 1, 5}, {3, 1, 5}, 
   {3, 1, 5}, {3, 1, 5}, {3, 1, 5}, {3, 1, 5}, 
   {1, 1, 3}, {1, 1, 3}, {1, 1, 3}, {1, 1, 3}, 
   {1, 1, 3}, {1, 1, 3}, {1, 1, 3}, {1, 1, 3}, 
   {1, 1, 3}, {1, 1, 3}, {1, 1, 3}, {1, 1, 3}, 
   {1, 1, 3}, {1, 1, 3}, {1, 1, 3}, {1, 1, 3}, 
   {1, 1, 3}, {1, 1, 3}, {1, 1, 3}, {1, 1, 3}, 
   {1, 1, 3}, {1, 1, 3}, {1, 1, 3}, {1, 1, 3}, 
   {1, 1, 3}, {1, 1, 3}, {1, 1, 3}, {1, 1, 3}, 
   {1, 1, 3}, {1, 1, 3}, {1, 1, 3}, {1, 1, 3}, 
   {64, 0, 4}, {64, 0, 4}, {64, 0, 4}, {64, 0, 4}, 
   {64, 0, 4}, {64, 0, 4}, {64, 0, 4}, {64, 0, 4}, 
   {64, 0, 4}, {64, 0, 4}, {64, 0, 4}, {64, 0, 4},
   {64, 0, 4}, {64, 0, 4}, {64, 0, 4}, {64, 0, 4}, 
   {0, 3, 4}, {0, 3, 4}, {0, 3, 4}, {0, 3, 4}, 
   {0, 3, 4}, {0, 3, 4}, {0, 3, 4}, {0, 3, 4}, 
   {0, 3, 4}, {0, 3, 4}, {0, 3, 4}, {0, 3, 4}, 
   {0, 3, 4}, {0, 3, 4}, {0, 3, 4}, {0, 3, 4}, 
   {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, 
   {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, 
   {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, 
   {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, 
   {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, 
   {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, 
   {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, 
   {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, 
   {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, 
   {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, 
   {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, 
   {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, 
   {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, 
   {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, 
   {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2},
   {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, {0, 1, 2}, 
   {0, 2, 3}, {0, 2, 3}, {0, 2, 3}, {0, 2, 3}, 
   {0, 2, 3}, {0, 2, 3}, {0, 2, 3}, {0, 2, 3}, 
   {0, 2, 3}, {0, 2, 3}, {0, 2, 3}, {0, 2, 3}, 
   {0, 2, 3}, {0, 2, 3}, {0, 2, 3}, {0, 2, 3}, 
   {0, 2, 3}, {0, 2, 3}, {0, 2, 3}, {0, 2, 3}, 
   {0, 2, 3}, {0, 2, 3}, {0, 2, 3}, {0, 2, 3}, 
   {0, 2, 3}, {0, 2, 3}, {0, 2, 3}, {0, 2, 3}, 
   {0, 2, 3}, {0, 2, 3}, {0, 2, 3}, {0, 2, 3}, 
   {0, 4, 5}, {0, 4, 5}, {0, 4, 5}, {0, 4, 5}, 
   {0, 4, 5}, {0, 4, 5}, {0, 4, 5}, {0, 4, 5}, 
   {0, 5, 5}, {0, 5, 5}, {0, 5, 5}, {0, 5, 5}, 
   {0, 5, 5}, {0, 5, 5}, {0, 5, 5}, {0, 5, 5}, 
   {9, 1, 7}, {9, 1, 7}, {1, 3, 7}, {1, 3, 7}, 
   {10, 1, 7}, {10, 1, 7}, {0, 8, 7}, {0, 8, 7}, 
   {0, 9, 7}, {0, 9, 7}, {0, 12, 8}, {0, 13, 8}, 
   {2, 3, 8}, {4, 2, 8}, {0, 14, 8}, {0, 15, 8}
};
static mpeg_DCTtab_t mpeg_DCTtab1[ 8 ] =
{
   {16, 1, 10}, {5, 2, 10}, {0, 7, 10}, {2, 3, 10}, 
   {1, 4, 10}, {15, 1, 10}, {14, 1, 10}, {4, 2, 10}
};
static mpeg_DCTtab_t mpeg_DCTtab1a[ 8 ] =
{
   {5, 2, 9}, {5, 2, 9}, {14, 1, 9}, {14, 1, 9}, 
   {2, 4, 10}, {16, 1, 10}, {15, 1, 9}, {15, 1, 9}
};
static mpeg_DCTtab_t mpeg_DCTtab2[ 16 ] =
{
   {0, 11, 12}, {8, 2, 12}, {4, 3, 12}, {0, 10, 12}, 
   {2, 4, 12}, {7, 2, 12}, {21, 1, 12}, {20, 1, 12}, 
   {0, 9, 12}, {19, 1, 12}, {18, 1, 12}, {1, 5, 12}, 
   {3, 3, 12}, {0, 8, 12}, {6, 2, 12}, {17, 1, 12}
};
static mpeg_DCTtab_t mpeg_DCTtab3[ 16 ] =
{
   {10, 2, 13}, {9, 2, 13}, {5, 3, 13}, {3, 4, 13}, 
   {2, 5, 13}, {1, 7, 13}, {1, 6, 13}, {0, 15, 13}, 
   {0, 14, 13}, {0, 13, 13}, {0, 12, 13}, {26, 1, 13},
   {25, 1, 13}, {24, 1, 13}, {23, 1, 13}, {22, 1, 13}
};
static mpeg_DCTtab_t mpeg_DCTtab4[ 16 ] =
{
   {0, 31, 14}, {0, 30, 14}, {0, 29, 14}, {0, 28, 14}, 
   {0, 27, 14}, {0, 26, 14}, {0, 25, 14}, {0, 24, 14}, 
   {0, 23, 14}, {0, 22, 14}, {0, 21, 14}, {0, 20, 14}, 
   {0, 19, 14}, {0, 18, 14}, {0, 17, 14}, {0, 16, 14}
};
static mpeg_DCTtab_t mpeg_DCTtab5[ 16 ] =
{
   {0, 40, 15}, {0, 39, 15}, {0, 38, 15}, {0, 37, 15}, 
   {0, 36, 15}, {0, 35, 15}, {0, 34, 15}, {0, 33, 15}, 
   {0, 32, 15}, {1, 14, 15}, {1, 13, 15}, {1, 12, 15}, 
   {1, 11, 15}, {1, 10, 15}, {1, 9, 15}, {1, 8, 15}
};
static mpeg_DCTtab_t mpeg_DCTtab6[ 16 ] =
{
   {1, 18, 16}, {1, 17, 16}, {1, 16, 16}, {1, 15, 16}, 
   {6, 3, 16}, {16, 2, 16}, {15, 2, 16}, {14, 2, 16},
   {13, 2, 16}, {12, 2, 16}, {11, 2, 16}, {31, 1, 16}, 
   {30, 1, 16}, {29, 1, 16}, {28, 1, 16}, {27, 1, 16}
};
typedef struct complex_s 
{
   sample_t real;
   sample_t imag;
} complex_t;
static complex_t buf[ 128 ];
static uint8_t fftorder[] = 
{
   0, 128, 64, 192, 32, 160, 224, 96, 16, 144, 80, 208, 240, 112, 48, 176, 
   8, 136, 72, 200, 40, 168, 232, 104, 248, 120, 56, 184, 24, 152, 216, 88, 
   4, 132, 68, 196, 36, 164, 228, 100, 20, 148, 84, 212, 244, 116, 52, 180, 
   252, 124, 60, 188, 28, 156, 220, 92, 12, 140, 76, 204, 236, 108, 44, 172, 
   2, 130, 66, 194, 34, 162, 226, 98, 18, 146, 82, 210, 242, 114, 50, 178, 
   10, 138, 74, 202, 42, 170, 234, 106, 250, 122, 58, 186, 26, 154, 218, 90, 
   254, 126, 62, 190, 30, 158, 222, 94, 14, 142, 78, 206, 238, 110, 46, 174, 
   6, 134, 70, 198, 38, 166, 230, 102, 246, 118, 54, 182, 22, 150, 214, 86
};
static sample_t roots16[ 3 ];
static sample_t roots32[ 7 ];
static sample_t roots64[ 15 ];
static sample_t roots128[ 31 ];
static complex_t pre1[ 128 ];
static complex_t post1[ 64 ];
static complex_t pre2[ 64 ];
static complex_t post2[ 32 ];
static const sample_t a52_imdct_window[] = 
{
   0.00014, 0.00024, 0.00037, 0.00051, 0.00067, 0.00086, 0.00107, 0.00130, 
   0.00157, 0.00187, 0.00220, 0.00256, 0.00297, 0.00341, 0.00390, 0.00443, 
   0.00501, 0.00564, 0.00632, 0.00706, 0.00785, 0.00871, 0.00962, 0.01061, 
   0.01166, 0.01279, 0.01399, 0.01526, 0.01662, 0.01806, 0.01959, 0.02121, 
   0.02292, 0.02472, 0.02662, 0.02863, 0.03073, 0.03294, 0.03527, 0.03770, 
   0.04025, 0.04292, 0.04571, 0.04862, 0.05165, 0.05481, 0.05810, 0.06153, 
   0.06508, 0.06878, 0.07261, 0.07658, 0.08069, 0.08495, 0.08935, 0.09389, 
   0.09859, 0.10343, 0.10842, 0.11356, 0.11885, 0.12429, 0.12988, 0.13563, 
   0.14152, 0.14757, 0.15376, 0.16011, 0.16661, 0.17325, 0.18005, 0.18699, 
   0.19407, 0.20130, 0.20867, 0.21618, 0.22382, 0.23161, 0.23952, 0.24757,
   0.25574, 0.26404, 0.27246, 0.28100, 0.28965, 0.29841, 0.30729, 0.31626, 
   0.32533, 0.33450, 0.34376, 0.35311, 0.36253, 0.37204, 0.38161, 0.39126, 
   0.40096, 0.41072, 0.42054, 0.43040, 0.44030, 0.45023, 0.46020, 0.47019, 
   0.48020, 0.49022, 0.50025, 0.51028, 0.52031, 0.53033, 0.54033, 0.55031, 
   0.56026, 0.57019, 0.58007, 0.58991, 0.59970, 0.60944, 0.61912, 0.62873, 
   0.63827, 0.64774, 0.65713, 0.66643, 0.67564, 0.68476, 0.69377, 0.70269, 
   0.71150, 0.72019, 0.72877, 0.73723, 0.74557, 0.75378, 0.76186, 0.76981, 
   0.77762, 0.78530, 0.79283, 0.80022, 0.80747, 0.81457, 0.82151, 0.82831, 
   0.83496, 0.84145, 0.84779, 0.85398, 0.86001, 0.86588, 0.87160, 0.87716, 
   0.88257, 0.88782, 0.89291, 0.89785, 0.90264, 0.90728, 0.91176, 0.91610, 
   0.92028, 0.92432, 0.92822, 0.93197, 0.93558, 0.93906, 0.94240, 0.94560, 
   0.94867, 0.95162, 0.95444, 0.95713, 0.95971, 0.96217, 0.96451, 0.96674, 
   0.96887, 0.97089, 0.97281, 0.97463, 0.97635, 0.97799, 0.97953, 0.98099, 
   0.98236, 0.98366, 0.98488, 0.98602, 0.98710, 0.98811, 0.98905, 0.98994, 
   0.99076, 0.99153, 0.99225, 0.99291, 0.99353, 0.99411, 0.99464, 0.99513, 
   0.99558, 0.99600, 0.99639, 0.99674, 0.99706, 0.99736, 0.99763, 0.99788, 
   0.99811, 0.99831, 0.99850, 0.99867, 0.99882, 0.99895, 0.99908, 0.99919, 
   0.99929, 0.99938, 0.99946, 0.99953, 0.99959, 0.99965, 0.99969, 0.99974, 
   0.99978, 0.99981, 0.99984, 0.99986, 0.99988, 0.99990, 0.99992, 0.99993, 
   0.99994, 0.99995, 0.99996, 0.99997, 0.99998, 0.99998, 0.99998, 0.99999,
   0.99999, 0.99999, 0.99999, 1.00000, 1.00000, 1.00000, 1.00000, 1.00000, 
   1.00000, 1.00000, 1.00000, 1.00000, 1.00000, 1.00000, 1.00000, 1.00000
};
static int hthtab[ 3 ][ 50 ] = 
{
   {0x730, 0x730, 0x7c0, 0x800, 0x820, 0x840, 0x850, 0x850, 0x860, 0x860, 
   0x860, 0x860, 0x860, 0x870, 0x870, 0x870, 0x880, 0x880, 0x890, 0x890, 
   0x8a0, 0x8a0, 0x8b0, 0x8b0, 0x8c0, 0x8c0, 0x8d0, 0x8e0, 0x8f0, 0x900, 
   0x910, 0x910, 0x910, 0x910, 0x900, 0x8f0, 0x8c0, 0x870, 0x820, 0x7e0, 
   0x7a0, 0x770, 0x760, 0x7a0, 0x7c0, 0x7c0, 0x6e0, 0x400, 0x3c0, 0x3c0}, 
   {0x710, 0x710, 0x7a0, 0x7f0, 0x820, 0x830, 0x840, 0x850, 0x850, 0x860, 
   0x860, 0x860, 0x860, 0x860, 0x870, 0x870, 0x870, 0x880, 0x880, 0x880, 
   0x890, 0x890, 0x8a0, 0x8a0, 0x8b0, 0x8b0, 0x8c0, 0x8c0, 0x8e0, 0x8f0, 
   0x900, 0x910, 0x910, 0x910, 0x910, 0x900, 0x8e0, 0x8b0, 0x870, 0x820, 
   0x7e0, 0x7b0, 0x760, 0x770, 0x7a0, 0x7c0, 0x780, 0x5d0, 0x3c0, 0x3c0}, 
   {0x680, 0x680, 0x750, 0x7b0, 0x7e0, 0x810, 0x820, 0x830, 0x840, 0x850, 
   0x850, 0x850, 0x860, 0x860, 0x860, 0x860, 0x860, 0x860, 0x860, 0x860, 
   0x870, 0x870, 0x870, 0x870, 0x880, 0x880, 0x880, 0x890, 0x8a0, 0x8b0, 
   0x8c0, 0x8d0, 0x8e0, 0x8f0, 0x900, 0x910, 0x910, 0x910, 0x900, 0x8f0, 
   0x8d0, 0x8b0, 0x840, 0x7f0, 0x790, 0x760, 0x7a0, 0x7c0, 0x7b0, 0x720}
};
static int8_t baptab[ 305 ] = 
{
   16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 
   16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 
   16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 
   16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 
   16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 
   16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 	
   16, 16, 16, 16, 16, 16, 16, 16, 16, 14, 14, 14, 14, 14, 14, 14, 
   14, 12, 12, 12, 12, 11, 11, 11, 11, 10, 10, 10, 10, 9, 9, 9, 
   9, 8, 8, 8, 8, 7, 7, 7, 7, 6, 6, 6, 6, 5, 5, 5, 
   5, 4, 4, -3, -3, 3, 3, 3, -2, -2, -1, -1, -1, -1, -1, 0, 
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
   0, 0, 0, 0	
};
static int bndtab[ 30 ] =
{
   21, 22, 23, 24, 25, 26, 27, 28, 31, 34, 
   37, 40, 43, 46, 49, 55, 61, 67, 73, 79, 
   85, 97, 109, 121, 133, 157, 181, 205, 229, 253
};
static int8_t latab[ 256 ] = 
{
   -64, -63, -62, -61, -60, -59, -58, -57, -56, -55, -54, -53, 
   -52, -52, -51, -50, -49, -48, -47, -47, -46, -45, -44, -44, 
   -43, -42, -41, -41, -40, -39, -38, -38, -37, -36, -36, -35, 
   -35, -34, -33, -33, -32, -32, -31, -30, -30, -29, -29, -28, 
   -28, -27, -27, -26, -26, -25, -25, -24, -24, -23, -23, -22, 
   -22, -21, -21, -21, -20, -20, -19, -19, -19, -18, -18, -18, 
   -17, -17, -17, -16, -16, -16, -15, -15, -15, -14, -14, -14, 
   -13, -13, -13, -13, -12, -12, -12, -12, -11, -11, -11, -11,
   -10, -10, -10, -10, -10, -9, -9, -9, -9, -9, -8, -8, 
   -8, -8, -8, -8, -7, -7, -7, -7, -7, -7, -6, -6, 
   -6, -6, -6, -6, -6, -6, -5, -5, -5, -5, -5, -5, 
   -5, -5, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, 
   -4, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, 
   -3, -3, -3, -2, -2, -2, -2, -2, -2, -2, -2, -2, 
   -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -1, -1, 
   -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
   -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
   -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
   0, 0, 0, 0
};
static uint32_t * buffer_start;
static uint32_t a52_bits_left;
static uint32_t a52_current_word;
/***************************************************************************/
static inline void mpeg_bits_fill_reverse_bits( mpeg_bits_t* stream, int bits );
static inline void mpeg_bits_fill_bits( mpeg_bits_t* stream, int bits );
static inline unsigned int mpeg_bits_getbyte_noptr( mpeg_bits_t* stream );
static inline unsigned int mpeg_bits_getbit_noptr( mpeg_bits_t* stream );
static inline unsigned int mpeg_bits_getbits( mpeg_bits_t* stream, int bits );
static inline unsigned int mpeg_bits_showbits24_noptr( mpeg_bits_t* stream );
static inline unsigned int mpeg_bits_showbits32_noptr( mpeg_bits_t* stream );
static inline unsigned int mpeg_bits_showbits( mpeg_bits_t* stream, int bits );
static inline unsigned int mpeg_bits_getbits_reverse( mpeg_bits_t* stream, int bits );
static inline unsigned int mpeg_bits_showbits_reverse( mpeg_bits_t* stream, int bits );
static inline unsigned int mpeg_slice_getbit( mpeg_slice_buffer_t *buffer );
static inline unsigned int mpeg_slice_getbits2( mpeg_slice_buffer_t *buffer );
static inline unsigned int mpeg_slice_getbyte( mpeg_slice_buffer_t *buffer );
static inline unsigned int mpeg_slice_getbits( mpeg_slice_buffer_t *slice_buffer, int bits );
static inline unsigned int mpeg_slice_showbits16( mpeg_slice_buffer_t *buffer );
static inline unsigned int mpeg_slice_showbits9( mpeg_slice_buffer_t *buffer );
static inline unsigned int mpeg_slice_showbits5( mpeg_slice_buffer_t *buffer );
static inline unsigned int mpeg_slice_showbits( mpeg_slice_buffer_t *slice_buffer, int bits );
static inline unsigned int mpeg_io_read_int32( mpeg_fs_t *fs );
static inline unsigned int mpeg_io_read_char( mpeg_fs_t *fs );
static inline uint32_t bitstream_get( uint32_t num_bits );
static inline int32_t bitstream_get_2( uint32_t num_bits );
static inline mpeg_bits_t* mpeg_bits_new_stream( MPEG *file_mpeg, mpeg_demuxer_t *demuxer );
static inline int mpeg_bits_delete_stream( mpeg_bits_t* stream );
static inline int mpeg_bits_read_buffer( mpeg_bits_t* stream, unsigned char *buffer, int bytes );
static inline int mpeg_bits_use_ptr( mpeg_bits_t* stream, unsigned char *buffer );
static inline int mpeg_bits_use_demuxer( mpeg_bits_t* stream );
static inline void mpeg_bits_start_reverse( mpeg_bits_t* stream );
static inline void mpeg_bits_start_forward( mpeg_bits_t* stream );
static inline int mpeg_bits_refill( mpeg_bits_t* stream );
static inline int mpeg_bits_byte_align( mpeg_bits_t *stream );
static inline long mpeg_demuxer_total_bytes( mpeg_demuxer_t *demuxer );
static inline int mpeg_bits_seek_end( mpeg_bits_t* stream );
static inline int mpeg_bits_seek_start( mpeg_bits_t* stream );
static inline int mpeg_bits_seek_time( mpeg_bits_t* stream, double time_position );
static inline int mpeg_bits_seek_byte( mpeg_bits_t* stream, long position );
static inline int mpeg_bits_seek_percentage( mpeg_bits_t* stream, double percentage );
static inline int mpeg_bits_getbitoffset( mpeg_bits_t *stream );
static inline mpeg_css_t* mpeg_new_css();
static inline int mpeg_delete_css( mpeg_css_t *css );
static inline int mpeg_get_keys( mpeg_css_t *css, char *path );
static inline int mpeg_decrypt_packet( mpeg_css_t *css, unsigned char *sector );
static inline MPEG* mpeg_new( char *path );
static inline int mpeg_delete( MPEG *file_mpeg );
static inline int mpeg_check_sig( char *path );
static inline MPEG* mpeg_open_copy( char *path, MPEG *old_file );
static inline MPEG* mpeg_open( char *path );
static inline int mpeg_close( MPEG *file_mpeg );
static inline int mpeg_read_toc( MPEG *file_mpeg );
static inline int mpeg_has_audio( MPEG *file_mpeg );
static inline int mpeg_audio_channels( MPEG *file_mpeg, int stream );
static inline int mpeg_sample_rate( MPEG *file_mpeg, int stream );
static inline long mpeg_get_sample( MPEG *file_mpeg, int stream );
static inline long mpeg_audio_samples( MPEG *file_mpeg, int stream );
static inline int mpeg_has_video( MPEG *file_mpeg );
static inline int mpeg_video_width( MPEG *file_mpeg, int stream );
static inline int mpeg_video_height( MPEG *file_mpeg, int stream );
static inline float mpeg_frame_rate( MPEG *file_mpeg, int stream );
static inline long mpeg_video_frames( MPEG *file_mpeg, int stream );
static inline long mpeg_get_frame( MPEG *file_mpeg, int stream );
static inline double mpeg_get_time( MPEG *file_mpeg );
static inline int mpeg_end_of_audio( MPEG *file_mpeg, int stream );
static inline int mpeg_read_frame( MPEG *file_mpeg, int stream, BITMAP *bmp );
static inline int mpeg_drop_frames( MPEG *file_mpeg, long frames, int stream );
static inline int mpeg_read_audio( MPEG *file_mpeg, float *output_f, short *output_i, int channel, long samples, int stream );
static inline mpeg_atrack_t* mpeg_new_atrack( MPEG *file_mpeg, int stream_id, int format, mpeg_demuxer_t *demuxer );
static inline int mpeg_delete_atrack( MPEG *file_mpeg, mpeg_atrack_t *atrack );
static inline unsigned char mpeg_packet_next_char( mpeg_demuxer_t *demuxer );
static inline unsigned char mpeg_packet_read_char( mpeg_demuxer_t *demuxer );
static inline unsigned int mpeg_packet_read_int16( mpeg_demuxer_t *demuxer );
static inline unsigned int mpeg_packet_next_int24( mpeg_demuxer_t *demuxer );
static inline unsigned int mpeg_packet_read_int24( mpeg_demuxer_t *demuxer );
static inline unsigned int mpeg_packet_read_int32( mpeg_demuxer_t *demuxer );
static inline unsigned int mpeg_packet_skip( mpeg_demuxer_t *demuxer, long length );
static inline int mpeg_get_adaptation_field( mpeg_demuxer_t *demuxer );
static inline int mpeg_get_program_association_table( mpeg_demuxer_t *demuxer );
static inline int mpeg_packet_get_data_buffer( mpeg_demuxer_t *demuxer );
static inline int mpeg_get_pes_packet_header( mpeg_demuxer_t *demuxer, unsigned long *pts, unsigned long *dts );
static inline int get_unknown_data( mpeg_demuxer_t *demuxer );
static inline int mpeg_get_pes_packet_data( mpeg_demuxer_t *demuxer, unsigned int stream_id );
static inline int mpeg_get_pes_packet( mpeg_demuxer_t *demuxer );
static inline int mpeg_get_payload( mpeg_demuxer_t *demuxer );
static inline int mpeg_read_transport( mpeg_demuxer_t *demuxer );
static inline int mpeg_get_system_header( mpeg_demuxer_t *demuxer );
static inline unsigned long mpeg_get_timestamp( mpeg_demuxer_t *demuxer );
static inline int mpeg_get_pack_header( mpeg_demuxer_t *demuxer, unsigned int *header );
static inline int mpeg_get_ps_pes_packet( mpeg_demuxer_t *demuxer, unsigned int *header );
static inline int mpeg_read_program( mpeg_demuxer_t *demuxer );
static inline double mpeg_lookup_time_offset( mpeg_demuxer_t *demuxer, long byte );
static inline int mpeg_advance_timecode( mpeg_demuxer_t *demuxer, int reverse );
static inline int mpeg_read_next_packet( mpeg_demuxer_t *demuxer );
static inline int mpeg_read_prev_packet( mpeg_demuxer_t *demuxer );
static inline int mpeg_demux_read_data( mpeg_demuxer_t *demuxer, unsigned char *output, long size );
static inline unsigned int mpeg_demux_read_char_packet( mpeg_demuxer_t *demuxer );
static inline unsigned int mpeg_demux_read_prev_char_packet( mpeg_demuxer_t *demuxer );
static inline mpeg_demux_timecode_t* mpeg_append_timecode( mpeg_demuxer_t *demuxer, mpeg_title_t *title, long prev_byte, double prev_time, long next_byte, double next_time, int dont_store );
static inline mpeg_demux_timecode_t* mpeg_demux_next_timecode( mpeg_demuxer_t *demuxer, int *current_title, int *current_timecode, int current_program );
static inline int mpeg_demux_open_title( mpeg_demuxer_t *demuxer, int title_number );
static inline int mpeg_demux_assign_programs( mpeg_demuxer_t *demuxer );
static inline mpeg_demuxer_t* mpeg_new_demuxer( MPEG *file_mpeg, int do_audio, int do_video, int stream_id );
static inline int mpeg_delete_demuxer( mpeg_demuxer_t *demuxer );
static inline int mpeg_demux_create_title( mpeg_demuxer_t *demuxer, int timecode_search, FILE *toc );
static inline int mpeg_demux_read_titles( mpeg_demuxer_t *demuxer );
static inline int mpeg_demux_copy_titles( mpeg_demuxer_t *dst, mpeg_demuxer_t *src );
static inline double mpeg_demux_length( mpeg_demuxer_t *demuxer );
static inline int mpeg_demux_eof( mpeg_demuxer_t *demuxer );
static inline int mpeg_demux_bof( mpeg_demuxer_t *demuxer );
static inline int mpeg_demux_seek_byte( mpeg_demuxer_t *demuxer, long byte );
static inline int mpeg_demux_seek_time( mpeg_demuxer_t *demuxer, double new_time );
static inline int mpeg_demux_seek_percentage( mpeg_demuxer_t *demuxer, double percentage );
static inline double mpeg_demux_tell_percentage( mpeg_demuxer_t *demuxer );
static inline double mpeg_demux_get_time( mpeg_demuxer_t *demuxer );
static inline mpeg_demuxer_t* mpeg_get_demuxer( MPEG *file_mpeg );
static inline mpeg_fs_t* mpeg_new_fs( char *path );
static inline int mpeg_delete_fs( mpeg_fs_t *fs );
static inline int mpeg_copy_fs( mpeg_fs_t *dst, mpeg_fs_t *src );
static inline long mpeg_io_get_total_bytes( mpeg_fs_t *fs );
static inline int mpeg_io_open_file( mpeg_fs_t *fs );
static inline int mpeg_io_close_file( mpeg_fs_t *fs );
static inline int mpeg_io_read_data( unsigned char *buffer, long bytes, mpeg_fs_t *fs );
static inline int mpeg_io_seek( mpeg_fs_t *fs, long byte );
static inline int mpeg_io_seek_relative( mpeg_fs_t *fs, long bytes );
static inline mpeg_title_t* mpeg_new_title( MPEG *file_mpeg, char *path );
static inline int mpeg_delete_title( mpeg_title_t *title );
static inline int mpeg_copy_title( mpeg_title_t *dst, mpeg_title_t *src );
static inline mpeg_vtrack_t* mpeg_new_vtrack( MPEG *file_mpeg, int stream_id, mpeg_demuxer_t *demuxer );
static inline int mpeg_delete_vtrack( MPEG *file_mpeg, mpeg_vtrack_t *vtrack );
static inline int mpeg_audio_dct64_1( float *out0, float *out1, float *b1, float *b2, float *samples );
static inline int mpeg_audio_dct64( float *a, float *b, float *c );
static inline int mpeg_audio_dct36( float *inbuf, float *o1, float *o2, float *wintab, float *tsbuf );
static inline int mpeg_audio_dct12( float *in, float *rawout1, float *rawout2, float *wi, float *ts );
static inline mpeg_complex_t cmplx_mult( mpeg_complex_t a, mpeg_complex_t b );
static inline int mpeg_audio_imdct_init( mpeg_audio_t *audio );
static inline void swap_cmplx( mpeg_complex_t *a, mpeg_complex_t *b );
static inline void mpeg_audio_ac3_imdct_do_512( mpeg_audio_t *audio, float data[], float *y, int step, float *delay );
static inline void mpeg_audio_ac3_imdct_do_256( mpeg_audio_t *audio, float data[], float *y, int step, float *delay );
static inline int mpeg_audio_head_check( unsigned long head );
static inline int mpeg_audio_decode_header( mpeg_audio_t *audio );
static inline int mpeg_audio_prev_header( mpeg_audio_t *audio );
static inline int mpeg_audio_read_header( mpeg_audio_t *audio );
static inline int mpeg_audio_dolayer1( mpeg_audio_t *audio );
static inline int mpeg_audio_II_select_table( mpeg_audio_t *audio );
static inline int mpeg_audio_II_step_one( mpeg_audio_t *audio, unsigned int *bit_alloc, int *scale );
static inline int mpeg_audio_II_step_two( mpeg_audio_t *audio, unsigned int *bit_alloc, float fraction[ 2 ][ 4 ][ SBLIMIT ], int *scale, int x1 );
static inline int mpeg_audio_dolayer2( mpeg_audio_t *audio );
static inline int mpeg_audio_III_get_scale_factors_1( mpeg_audio_t *audio, int *scf, struct gr_info_s *gr_info, int ch, int gr );
static inline int mpeg_audio_III_get_scale_factors_2( mpeg_audio_t *audio, int *scf, struct gr_info_s *gr_info, int i_stereo );
static inline int mpeg_audio_III_dequantize_sample( mpeg_audio_t *audio, float xr[ SBLIMIT ][ SSLIMIT ], int *scf, struct gr_info_s *gr_info, int sfreq, int part2bits );
static inline int mpeg_audio_III_get_side_info( mpeg_audio_t *audio, struct mpeg_III_sideinfo *si, int channels, int ms_stereo, long sfreq, int single, int lsf );
static inline int mpeg_audio_III_hybrid( mpeg_audio_t *audio, float fsIn[ SBLIMIT ][ SSLIMIT ], float tsOut[ SSLIMIT ][ SBLIMIT ], int ch, struct gr_info_s *gr_info );
static inline int mpeg_audio_III_antialias( mpeg_audio_t *audio, float xr[ SBLIMIT ][ SSLIMIT ], struct gr_info_s *gr_info );
static inline int mpeg_audio_III_i_stereo( mpeg_audio_t *audio, float xr_buf[ 2 ][ SBLIMIT ][ SSLIMIT ], int *scalefac, struct gr_info_s *gr_info, int sfreq, int ms_stereo, int lsf );
static inline int mpeg_audio_read_layer3_frame( mpeg_audio_t *audio );
static inline int mpeg_audio_dolayer3( mpeg_audio_t *audio );
static inline mpeg_audio_t* mpeg_audio_allocate_struct( MPEG *file_mpeg, mpeg_atrack_t *track );
static inline int mpeg_audio_delete_struct( mpeg_audio_t *audio );
static inline int mpeg_audio_replace_buffer( mpeg_audio_t *audio, long new_allocation );
static inline int mpeg_audio_read_frame( mpeg_audio_t *audio );
static inline int mpeg_audio_get_length( mpeg_audio_t *audio, mpeg_atrack_t *track );
static inline int mpeg_audio_seek( mpeg_audio_t *audio, long position );
static inline mpeg_audio_t* mpeg_audio_new( MPEG *file_mpeg, mpeg_atrack_t *track, int format );
static inline int mpeg_audio_delete( mpeg_audio_t *audio );
static inline int mpeg_audio_read_raw( mpeg_audio_t *audio, unsigned char *output, long *size, long max_size );
static inline int mpeg_audio_decode_audio( mpeg_audio_t *audio, float *output_f, short *output_i, int channel, long start_position, long len );
static inline int mpeg_audio_read_pcm_header( mpeg_audio_t *audio );
static inline int mpeg_audio_do_pcm( mpeg_audio_t *audio );
static inline int mpeg_audio_synth_stereo( mpeg_audio_t *audio, float *bandPtr, int channel, float *out, int *pnt );
static inline int mpeg_audio_synth_mono( mpeg_audio_t *audio, float *bandPtr, float *samples, int *pnt );
static inline int mpeg_audio_reset_synths( mpeg_audio_t *audio );
static inline int mpeg_audio_init_layer2( mpeg_audio_t *audio );
static inline int mpeg_audio_init_layer3( mpeg_audio_t *audio );
static inline int mpeg_audio_new_decode_tables( mpeg_audio_t *audio );
static inline int mpeg_video_get_cbp( mpeg_slice_t *slice );
static inline int mpeg_video_clearblock( mpeg_slice_t *slice, int comp, int size );
static inline int mpeg_video_getdclum( mpeg_slice_buffer_t *slice_buffer );
static inline int mpeg_video_getdcchrom( mpeg_slice_buffer_t *slice_buffer );
static inline int mpeg_video_getintrablock( mpeg_slice_t *slice, mpeg_video_t *video, int comp, int dc_dct_pred[] );
static inline int mpeg_video_getinterblock( mpeg_slice_t *slice, mpeg_video_t *video, int comp );
static inline int mpeg_video_getmpeg_2intrablock( mpeg_slice_t *slice, mpeg_video_t *video, int comp, int dc_dct_pred[] );
static inline int mpeg_video_getmpeg_2interblock( mpeg_slice_t *slice, mpeg_video_t *video, int comp );
static inline void mpeg_slice_loop( mpeg_slice_t *slice );
static inline int mpeg_video_get_macroblocks( mpeg_video_t *video, int framenum );
static inline int mpeg_video_allocate_decoders( mpeg_video_t *video, int decoder_count );
static inline int mpeg_video_getpicture( mpeg_video_t *video, int framenum );
static inline int mpeg_video_getseqhdr( mpeg_video_t *video );
static inline int mpeg_video_sequence_extension( mpeg_video_t *video );
static inline int mpeg_video_sequence_display_extension( mpeg_video_t *video );
static inline int mpeg_video_quant_matrix_extension( mpeg_video_t *video );
static inline int mpeg_video_sequence_scalable_extension( mpeg_video_t *video );
static inline int mpeg_video_picture_display_extension( mpeg_video_t *video );
static inline int mpeg_video_picture_coding_extension( mpeg_video_t *video );
static inline int mpeg_video_picture_spatial_scalable_extension( mpeg_video_t *video );
static inline int mpeg_video_picture_temporal_scalable_extension( mpeg_video_t *video );
static inline unsigned int mpeg_bits_next_startcode( mpeg_bits_t* stream );
static inline int mpeg_video_ext_user_data( mpeg_video_t *video );
static inline int mpeg_video_getgophdr( mpeg_video_t *video );
static inline int mpeg_video_getpicturehdr( mpeg_video_t *video );
static inline int mpeg_video_get_header( mpeg_video_t *video, int dont_repeat );
static inline int mpeg_video_ext_bit_info( mpeg_slice_buffer_t *slice_buffer );
static inline int mpeg_video_getslicehdr( mpeg_slice_t *slice, mpeg_video_t *video );
static inline int mpeg_video_idctrow( short *blk );
static inline int mpeg_video_idctcol( short *blk );
static inline void mpeg_video_idct_conversion( short* block );
static inline int mpeg_video_get_macroblock_address( mpeg_slice_t *slice );
static inline int mpeg_video_getsp_imb_type( mpeg_slice_t *slice );
static inline int mpeg_video_getsp_pmb_type( mpeg_slice_t *slice );
static inline int mpeg_video_getsp_bmb_type( mpeg_slice_t *slice );
static inline int mpeg_video_get_imb_type( mpeg_slice_t *slice );
static inline int mpeg_video_get_pmb_type( mpeg_slice_t *slice );
static inline int mpeg_video_get_bmb_type( mpeg_slice_t *slice );
static inline int mpeg_video_get_dmb_type( mpeg_slice_t *slice );
static inline int mpeg_video_get_snrmb_type( mpeg_slice_t *slice );
static inline int mpeg_video_get_mb_type( mpeg_slice_t *slice, mpeg_video_t *video );
static inline int mpeg_video_macroblock_modes( mpeg_slice_t *slice, mpeg_video_t *video, int *pmb_type, int *pstwtype, int *pstwclass, int *pmotion_type, int *pmv_count, int *pmv_format, int *pdmv, int *pmvscale, int *pdct_type );
static inline void mpeg_video_calc_mv( int *pred, int r_size, int motion_code, int motion_r, int full_pel_vector );
static inline void mpeg_video_calc_dmv( mpeg_video_t *video, int DMV[][ 2 ], int *dmvector, int mvx, int mvy );
static inline int mpeg_video_get_mv( mpeg_slice_t *slice );
static inline int mpeg_video_get_dmv( mpeg_slice_t *slice );
static inline void mpeg_video_motion_vector( mpeg_slice_t *slice, mpeg_video_t *video, int *PMV, int *dmvector, int h_r_size, int v_r_size, int dmv, int mvscale, int full_pel_vector );
static inline int mpeg_video_motion_vectors( mpeg_slice_t *slice, mpeg_video_t *video, int PMV[ 2 ][ 2 ][ 2 ], int dmvector[ 2 ], int mv_field_sel[ 2 ][ 2 ], int s, int mv_count, int mv_format, int h_r_size, int v_r_size, int dmv, int mvscale );
static inline int mpeg_video_initdecoder( mpeg_video_t *video );
static inline int mpeg_video_deletedecoder( mpeg_video_t *video );
static inline void mpeg_video_init_scantables( mpeg_video_t *video );
static inline mpeg_video_t* mpeg_video_allocate_struct( MPEG *file_mpeg, mpeg_vtrack_t *track );
static inline int mpeg_video_delete_struct( mpeg_video_t *video );
static inline int mpeg_video_read_frame_backend( mpeg_video_t *video, int skip_bframes );
static inline int* mpeg_video_get_scaletable( int input_w, int output_w );
static inline int mpeg_video_get_firstframe( mpeg_video_t *video );
static inline mpeg_video_t* mpeg_video_new( MPEG *file_mpeg, mpeg_vtrack_t *track );
static inline int mpeg_video_delete( mpeg_video_t *video );
static inline int mpeg_video_read_frame( mpeg_video_t *video, long frame_number, BITMAP *bmp );
static inline int mpeg_video_ditherframe( mpeg_video_t *video, unsigned char **src, BITMAP *bmp );
static inline int mpeg_video_ditherframe444( mpeg_video_t *video, unsigned char *src[] );
static inline int mpeg_video_dithertop( mpeg_video_t *video, unsigned char *src[], BITMAP *bmp );
static inline int mpeg_video_dithertop444( mpeg_video_t *video, unsigned char *src[] );
static inline int mpeg_video_ditherbot( mpeg_video_t *video, unsigned char *src[] );
static inline int mpeg_video_ditherbot444( mpeg_video_t *video, unsigned char *src[] );
static inline int mpeg_video_init_output( void );
static inline int mpeg_video_present_frame( mpeg_video_t *video, BITMAP *bmp );
static inline int mpeg_video_display_second_field( mpeg_video_t *video );
static inline int mpeg_audio_read_ac3_header( mpeg_ac3_t *audio, unsigned char *header );
static inline int mpeg_audio_do_ac3( mpeg_ac3_t *audio, char *frame, int frame_size, float **output, int render );
static inline int a52_syncinfo ( uint8_t * buf, int * flags, int * sample_rate, int * bit_rate );
static inline int a52_frame ( a52_state_t * state, uint8_t * buf, int * flags, sample_t * level, sample_t bias );
static inline void a52_dynrng ( a52_state_t * state, sample_t ( * call ) ( sample_t, void * ), void * data );
static int parse_exponents ( int expstr, int ngrps, uint8_t exponent, uint8_t * dest );
static int parse_deltba ( int8_t * deltba );
static inline int zero_snr_offsets ( int nfchans, a52_state_t * state );
static inline int16_t dither_gen ( void );
static void coeff_get ( sample_t * coeff, expbap_t * expbap, quantizer_t * quantizer, sample_t level, int dither, int end );
static void coeff_get_coupling ( a52_state_t * state, int nfchans, sample_t * coeff, sample_t ( * samples )[ 256 ], quantizer_t * quantizer, uint8_t dithflag[ 5 ] );
static inline int a52_block ( a52_state_t * state );
static inline void rec( unsigned char *s, unsigned char *d, int lx2, int h );
static inline void recc( unsigned char *s, unsigned char *d, int lx2, int h );
static inline void reca( unsigned char *s, unsigned char *d, int lx2, int h );
static inline void recac( unsigned char *s, unsigned char *d, int lx2, int h );
static inline void recvmpeg( unsigned char *s, unsigned char *d, int lx, int lx2, int h );
static inline void recvc( unsigned char *s, unsigned char *d, int lx, int lx2, int h );
static inline void recva( unsigned char *s, unsigned char *d, int lx, int lx2, int h );
static inline void recvac( unsigned char *s, unsigned char *d, int lx, int lx2, int h );
static inline void rech( unsigned char *s, unsigned char *d, int lx2, int h );
static inline void rechc( unsigned char *s, unsigned char *d, int lx2, int h );
static inline void recha( unsigned char *s, unsigned char *d, int lx2, int h );
static inline void rechac( unsigned char *s, unsigned char *d, int lx2, int h );
static inline void rec4( unsigned char *s, unsigned char *d, int lx, int lx2, int h );
static inline void rec4c( unsigned char *s, unsigned char *d, int lx, int lx2, int h );
static inline void rec4a( unsigned char *s, unsigned char *d, int lx, int lx2, int h );
static inline void rec4ac( unsigned char *s, unsigned char *d, int lx, int lx2, int h );
static inline void recon_comp( mpeg_video_t *video, unsigned char *src, unsigned char *dst, int lx, int lx2, int w, int h, int x, int y, int dx, int dy, int addflag );
static void recon( mpeg_video_t *video, unsigned char *src[], int sfield, unsigned char *dst[], int dfield, int lx, int lx2, int w, int h, int x, int y, int dx, int dy, int addflag );
static inline int mpeg_video_reconstruct( mpeg_video_t *video, int bx, int by, int mb_type, int motion_type, int PMV[ 2 ][ 2 ][ 2 ], int mv_field_sel[ 2 ][ 2 ], int dmvector[ 2 ], int stwtype );
static inline int mpeg_video_next_code( mpeg_bits_t* stream, unsigned int code );
static inline int mpeg_video_prev_code( mpeg_bits_t* stream, unsigned int code );
static inline long mpeg_video_goptimecode_to_frame( mpeg_video_t *video );
static inline int mpeg_video_match_refframes( mpeg_video_t *video );
static inline int mpeg_video_seek( mpeg_video_t *video );
static inline int mpeg_video_drop_frames( mpeg_video_t *video, long frames );
static inline int mpeg_new_slice_buffer( mpeg_slice_buffer_t *slice_buffer );
static inline int mpeg_delete_slice_buffer( mpeg_slice_buffer_t *slice_buffer );
static inline int mpeg_expand_slice_buffer( mpeg_slice_buffer_t *slice_buffer );
static inline int mpeg_video_addblock( mpeg_slice_t *slice, mpeg_video_t *video, int comp, int bx, int by, int dct_type, int addflag );
static inline int mpeg_decode_slice( mpeg_slice_t *slice );
static inline int mpeg_new_slice_decoder( void *video, mpeg_slice_t *slice );
static inline int mpeg_delete_slice_decoder( mpeg_slice_t *slice );
static void ( * ifft128 ) ( complex_t * buf );
static void ( * ifft64 ) ( complex_t * buf );
static inline void ifft2 ( complex_t * buf );
static inline void ifft4 ( complex_t * buf );
static inline void ifft8 ( complex_t * buf );
static void ifft_pass ( complex_t * buf, sample_t * weight, int n );
static void ifft16 ( complex_t * buf );
static void ifft32 ( complex_t * buf );
static void ifft64_c ( complex_t * buf );
static void ifft128_c ( complex_t * buf );
static inline void a52_imdct_512 ( sample_t * data, sample_t * delay, sample_t bias );
static inline void a52_imdct_256( sample_t data[], sample_t delay[], sample_t bias );
static inline void a52_imdct_init ( uint32_t mm_accel );
static inline int a52_downmix_init ( int input, int flags, sample_t * level, sample_t clev, sample_t slev );
static inline int a52_downmix_coeff ( sample_t * coeff, int acmod, int output, sample_t level, sample_t clev, sample_t slev );
static void mix2to1 ( sample_t * dest, sample_t * src, sample_t bias );
static void mix3to1 ( sample_t * samples, sample_t bias );
static void mix4to1 ( sample_t * samples, sample_t bias );
static void mix5to1 ( sample_t * samples, sample_t bias );
static void mix3to2 ( sample_t * samples, sample_t bias );
static void mix21to2 ( sample_t * left, sample_t * right, sample_t bias );
static void mix21toS ( sample_t * samples, sample_t bias );
static void mix31to2 ( sample_t * samples, sample_t bias );
static void mix31toS ( sample_t * samples, sample_t bias );
static void mix22toS ( sample_t * samples, sample_t bias );
static void mix32to2 ( sample_t * samples, sample_t bias );
static void mix32toS ( sample_t * samples, sample_t bias );
static void move2to1 ( sample_t * src, sample_t * dest, sample_t bias );
static void zero ( sample_t * samples );
static inline void a52_downmix ( sample_t * samples, int acmod, int output, sample_t bias, sample_t clev, sample_t slev );
static inline void a52_upmix ( sample_t * samples, int acmod, int output );
static inline void a52_bit_allocate ( a52_state_t * state, ba_t * ba, int bndstart, 	 int start, int end, int fastleak, int slowleak, 	 expbap_t * expbap );
static inline void a52_bitstream_set_ptr ( uint8_t * buf );
static inline void bitstream_fill_current( void );
static inline uint32_t a52_bitstream_get_bh( uint32_t num_bits );
static inline int32_t a52_bitstream_get_bh_2( uint32_t num_bits );

