#include "kernel.h"
#include "widget.h"
#include "window.h"
#include "label.h"
#include "button.h"
#include "canvas.h"
//
l_ulong AppVersion	= ULONG_ID( 0, 0, 0, 1 );
char AppName[]	= "About/Welcome";
l_uid	nUID	= "shw:abtwel";
l_uid NeededLibs[]	= { "widget", "button", "label", "window", "" };
//
#define FWIDTH                   410
#define FHEIGHT                  320
//
PTask	MainTask = NULL;
PCanvas	c 	= 0;
PLabel l = 0;
PTimer t = 0;
l_ubig ltime = 0;
PWindow w = 0;
p_bitmap Bmp1;
p_bitmap Bmp2;
p_bitmap Bmp3;
l_int rgb = 246;
//
void TimerPoll( void* A )
{
   WidgetDraw( WIDGET( c ), NULL );
}
//
void DrawCenteredText ( PWidget o, p_bitmap buffer, l_text text )
{
   textout( buffer, default_font, text, ( o->Absolute.a.x+o->Absolute.b.x-text_length( default_font, text ) )/2, o->Absolute.b.y-text_height( default_font ), makecol( 0, 0, 0 ) );
}
//
void FlameDraw ( PWidget o, p_bitmap buffer, PRect w )
{
   static l_int paso    = 0;
   static l_int nb      = 0;
   static l_int ptr_msg = 0;
   l_text Msg[] = { "WinDos Gui for FreeDOS", WinDosTxtVersion, "Program By EL CHANGO v4 and The FreeDOS Team", WinDosTxtCopyRight, WinDosTxtReserved, WinDosTxtEmailArg, "Please Visit www.FreeDOS.org for more info." };
   //
   rectfill( buffer, w->a.x, w->a.y, w->b.x, w->b.y, makecol( rgb, rgb, rgb ) );
   //
   if ( !paso )
   {
	  set_trans_blender( 255, 255, 255, nb++ );
	  draw_trans_sprite( buffer, Bmp1, ( o->Absolute.a.x+o->Absolute.b.x-Bmp1->w )/2, ( o->Absolute.a.y+o->Absolute.b.y-Bmp1->h )/2 );
	  solid_mode();
	  if ( !paso && nb == 0xFF )
		 paso = 1;
   }
   //
   if ( paso == 1 )
   {
	  set_trans_blender( 0, 0, 0, nb-- );
	  draw_trans_sprite( buffer, Bmp1, ( o->Absolute.a.x+o->Absolute.b.x-Bmp1->w )/2, ( o->Absolute.a.y+o->Absolute.b.y-Bmp1->h )/2 );
	  solid_mode();
	  if ( !nb )
		 paso = 2;
   }
   if ( paso == 2 )
   {
	  set_trans_blender( 255, 255, 255, nb++ );
	  draw_trans_sprite( buffer, Bmp2, ( o->Absolute.a.x+o->Absolute.b.x-Bmp1->w )/2, ( o->Absolute.a.y+o->Absolute.b.y-Bmp1->h )/2 );
	  solid_mode();
	  if ( nb == 0xFF )
		 paso = 3;
   }
   if ( paso == 3 )
   {
	  set_trans_blender( 0, 0, 0, nb-- );
	  draw_trans_sprite( buffer, Bmp2, ( o->Absolute.a.x+o->Absolute.b.x-Bmp1->w )/2, ( o->Absolute.a.y+o->Absolute.b.y-Bmp1->h )/2 );
	  solid_mode();
	  if ( !nb )
		 paso = 4;
   }
   if ( paso == 4 )
   {
	  set_trans_blender( 255, 255, 255, nb++ );
	  draw_trans_sprite( buffer, Bmp3, ( o->Absolute.a.x+o->Absolute.b.x-Bmp1->w )/2, ( o->Absolute.a.y+o->Absolute.b.y-Bmp1->h )/2 );
	  solid_mode();
	  if ( nb == 0xFF )
		 paso = 5;
   }
   if ( paso == 5 )
   {
	  set_trans_blender( 0, 0, 0, nb-- );
	  draw_trans_sprite( buffer, Bmp3, ( o->Absolute.a.x+o->Absolute.b.x-Bmp1->w )/2, ( o->Absolute.a.y+o->Absolute.b.y-Bmp1->h )/2 );
	  solid_mode();
	  if ( !nb )
		 paso = 0;
   }
   //
   DrawCenteredText( o, buffer, Msg[ ptr_msg ] );
   if ( paso && ( nb == 0x80 || nb == 0x40 || nb == 0xC0 ) )
   {
	  ptr_msg++;
	  ptr_msg = ( ptr_msg % 7 );
   }
}
//
l_bool AppEventHandler ( PWidget o, PEvent Ev )
{
   if ( Ev->Type == EV_MESSAGE )
   {
	  if ( Ev->Message == WM_CLOSE )
	  {
		 CloseApp( &Me );
		 return true;
	  }
   }
   return false;
}
//
l_int Main ( int argc, l_text *argv )
{
   TRect r;
   PButton b = NULL;
   //
   if ( GSScreenDepth == 8 )
	  return false;
   //
   if ( Me.Ressource )
   {
	  Bmp1 = ListKey( Me.Ressource, "CHANGO" );
	  Bmp2 = ListKey( Me.Ressource, "1" );
	  Bmp3 = ListKey( Me.Ressource, "4" );
   }
   //
   RectAssign( &r, 0, 0, FWIDTH, FHEIGHT );
   w = CreateWindow( &Me, r, "Bienvenido a WinDos", WF_FRAME|WF_CAPTION|WF_MINIMIZE|WF_CENTERED );
   InsertWidget( DeskTop, WIDGET( w ) );
   //
   WIDGET( w )->AppEvHdl = &AppEventHandler;
   WidgetSize( &r, 0, 0, FWIDTH, FHEIGHT );
   c = CreateCanvas( &Me, r );
   WIDGET( c )->Draw = &FlameDraw;
   WIDGET( c )->Flags |= WFForceBuffer;
   InsertWidget( WIDGET( w ), WIDGET( c ) );
   //
   WidgetDrawAll( WIDGET( w ) );
   //
   t = NewTimer( &Me, 25, &TimerPoll, NULL );
   //
   return true;
}
void Close ( void )
{
   KillTimer( t );
   WidgetDispose( WIDGET( w ) );
}
