#define KERNEL_FILE
//
#include "allegro.h"
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include "windos.h"
#include "dynld.h"
#include "internal.h"
#include "widget.h"
#include "version.h"
//
l_int DebugMode = FALSE;
l_int WinDosRunning = FALSE;
//
#define TSS(x) DebugMessage("Type: %s\tSize: %i %i", #x, sizeof(x),sizeof(x)%8);
//
void DMS2Init ( void );
void DMS2DeInit ( void );
//
jmp_buf MainPoint;


/**
*	NAME: GSExit
*	DESCRIPTION: Setting this variable to true ends the main program loop
*		But DO NOT set it directly to true, use the MSG_QUIT event !
*/
extern l_bool GSExit;

/**
*	NAME: KernelMode
*	DESCRIPTION: Defines the kernel mode
*/
l_ulong KernelMode = 0;
//
long Platform = PL_DOS;


/**
*	NAME: Kernel information
*	DESCRIPTION: Information about the kernel itself (version, build)
*/
_PUBLIC char* KernelName		= WinDosTxtVersion;
_PUBLIC char* KernelCopyright	= WinDosTxtCopyRight;
//_PUBLIC int   KernelVersion		= WinDosVersionId;
_PUBLIC char* KernelTextVersion	= WinDosVersionTxt;
//
/**
*	NAME: System driver initialization
*	DESCRIPTION: The main initialization (systems, drivers, ...)
*/
_PRIVATE void  _SystemInit ( void )
{
	DebugMessage ("Iniciando Controladores");

	/*DebugMessage("Starting exception handler...");
		ExceptionHandlerInstall();
	DebugMessage("Exception handler started");*/

	DebugMessage ("Iniciando DynLd...");
	InitDynLd();
	RegisterExports();
	DebugMessage ("DynLd iniciado");

	DebugMessage ("Iniciando VFS...");
	GSSystemVFSInstall();
	DebugMessage ("VFS Iniciado");

	DebugMessage("Iniciando el Registro...");
	NRegistryInit();
	DebugMessage("Registro iniciado");

	DebugMessage("Iniciando text manipulation functions...");
	DebugMessage("	ASCII/UTF-8...");
		InitText();
	DebugMessage("	UTF-16...");
		InitUText();
	DebugMessage("Text manipulation functions iniciado");

	DebugMessage ("Initialize Eventos del Sistema...");
		InitializeEventsSystem();
	DebugMessage ("Eventos del Sistema iniciado");

	DebugMessage ("Install Allegro...");
		install_allegro( SYSTEM_AUTODETECT, NULL, NULL );
		install_keyboard();
	DebugMessage ("Allegro instalado");

	DebugMessage ("Iniciando DMS v2 (Data Management System) ...");
		DMS2Init();
	DebugMessage ("DMS iniciado");

	DebugMessage ("Cargando controladores...");
		RegistryLoadLibraries("/SYSTEM/BASICDRIVERS");
	DebugMessage ("Controladores cargados");

	DebugMessage ("Iniciando Timer ...");
		InitTimer();
	DebugMessage ("Timer iniciado");

	DebugMessage ("Iniciando teclado...");
		GSSystemKeyboardInstall();
	DebugMessage ("Teclado iniciado.");

	DebugMessage ("Iniciando drivers");
		RegistryLoadLibraries("/SYSTEM/DRIVERS");
	DebugMessage ("Dirvers iniciados");

	DebugMessage ("Iniciando screen...");
		GSSystemScreenInit( FALSE );
	DebugMessage ("Screen iniciado");

	DebugMessage ("System fonts...");
		text_mode(-1);
		if ( GSScreenDepth != 8 )
		   antialias_init(default_palette);
		else
		   antialias_init(NULL);
		default_font = FontLoad(KeyGetText("/SYSTEM/FONTS","SYSTEM/FONTS/HELV13.FNT"));
		if ( !default_font )
		   default_font = font;
		   #ifdef NEWFONTSYS
			  InitFontSystem();
		   #endif
	DebugMessage ("System fonts O.k.");

	DebugMessage ("Iniciando mouse...");
		GSSystemMouseInstall();
	DebugMessage ("Mouse iniciado.");


	DebugMessage ("Cargando librerias...");
		RegistryLoadLibraries("/SYSTEM/AUTOLIB");
	DebugMessage ("Librerias cargadas");
	//
	DebugMessage ("Cargando Desktop...");
		RegistryRunEntries("/SYSTEM/STARTUP");
	DebugMessage ("Desktop iniciado");
	//
	MouseSetCursor( CUR_ARROW );
	MouseShow();
	//
	DebugMessage ("Controladores Iniciados Correctamente\n");
	/*
	 * Dirty hack, better said the only way
	 */
/*	{
		void (*func) (void);
		//
		func = (void*)ResolveSymbol(NULL,"DisposeStartupLogo");
		if ( func )
		   func();
	} */
	//
	RegistrySave();
}
/**
*	NAME: System Event Handler
*	DESCRIPTION: System events get handled here.
*/
_PRIVATE void  _SystemEventHandler ( PEvent Event )
{
	if (Event->Type & EV_KEYBOARD)
	{
		if (ALT(Event, KEY_X))
		{
			EventAssign(Event,EV_MESSAGE, MSG_QUIT, NULL, KState, Mouse->State);
			HandleEvent(Event);
			CLEAR_EVENT(Event);
		}

		if (ALT(Event, KEY_F))
		{
			DynLdRun("programs/nav.wde", NULL);
			CLEAR_EVENT(Event);
		}

		if (ALT(Event, KEY_R))
		{
			DynLdRun("programs/regedit.wde", NULL);
			CLEAR_EVENT(Event);
		}

		if (CTRL(Event, KEY_F8))
		{
			p_bitmap shot = create_bitmap(GSScreenWidth, GSScreenHeight);
			blit(screen, shot, 0, 0, 0, 0, GSScreenWidth, GSScreenHeight);
			SaveData2("shot.bmp",shot,TYPE_IMAGE);
			destroy_bitmap(shot);
			CLEAR_EVENT(Event);
		}
		if ( CTRL(Event, KEY_F12) ) {
			p_bitmap shot = create_bitmap(GSScreenWidth, GSScreenHeight);

			MouseHide();
			
			if ( shot ) {
				p_bitmap trans = create_bitmap(GSScreenWidth, GSScreenHeight),o=screen;
				
				blit(screen, shot, 0, 0, 0, 0, GSScreenWidth, GSScreenHeight);
				set_clip(screen,0,0,GSScreenWidth, GSScreenHeight);

				if ( trans ) {
	      	set_trans_blender(0, 0, 0, 0);
			draw_lit_sprite(trans, shot, 0, 0, 192);
	      	o = trans;
      	}
					
	    	rectfill(o,GSScreenWidth/2-57,GSScreenHeight/2-50,
	    	GSScreenWidth/2-7,GSScreenHeight/2+50,makecol(255,255,255));
	    	
			rectfill(o,GSScreenWidth/2+7,GSScreenHeight/2-50,
	    	GSScreenWidth/2+57,GSScreenHeight/2+50,makecol(255,255,255));

	    	textout_centre(o,default_font,"paused",GSScreenWidth/2+5,GSScreenHeight/2+52,makecol(255,255,255));
	    	textout_centre(o,default_font,"press any key",GSScreenWidth/2+5,GSScreenHeight/2+53+text_height(default_font),makecol(255,255,255));
				
		    if ( trans ) {
			    blit(trans, screen, 0, 0, 0, 0, GSScreenWidth, GSScreenHeight);
					destroy_bitmap(trans);
			}
			}

			while ( !keypressed() ); readkey();
			
			if ( shot ) {
				blit(shot, screen, 0, 0, 0, 0, GSScreenWidth, GSScreenHeight);
				destroy_bitmap(shot);
			}
			
			MouseShow();

			CLEAR_EVENT(Event);
		}

	}
}
//
int Program_Int( const char *f, int l)
{
   if ( WinDosRunning == TRUE && !GSExit )
   {
	  SysPoll();
   }
   //
   return TRUE;
}
//
void WinDosExit( void )
{
	/**
	*	Deinitialize the whole system and
	*	shutdown the GUI.
	*/
	ShutDownDynLd(); // Close all applications, and shut down dynamic loader
	GSSystemScreenDone();
	ShutDownTimer();
	GSSystemMouseUninstall();
	ShutdownEventsSystem();
	DMS2DeInit();
	#ifdef NEWFONTSYS
	   UnInitFontSystem();
	#endif
	allegro_exit();
	NRegistryUnInit();
	GSSystemVFSUnInstall();
	if ( DebugMode )
	   GSSystemDebugUninstall();
}
//
int main(int argc, char *argv[])
{
	l_byte a = NULL;
	//
	__djgpp_set_ctrl_c(0);
	setcbrk(0);
	//
	fprintf( stderr, "%s %s\n\n", WinDosTxt, WinDosTxtVersion );
	/**
	 * Select the kernel mode
	 */
	if ( argc > 1 ) if ( argv[1] )
	{
		if (!strcmp(argv[1], "-safe"))
		{
			KernelMode = KERNEL_SAFE;
		}
		else if (!strcmp(argv[1], "-resetup"))
		{
			KernelMode = KERNEL_RESETUP;
		}
		else if (!strcmp(argv[1], "-debug"))
		{
			DebugMode = TRUE;
		}
	}
	//
	if ( DebugMode )
	   GSSystemDebugInstall("windos.dbg");
	//
	InstallEventHandler(_SystemEventHandler);
	_SystemInit();
	//
	atexit( WinDosExit );
	setjmp( MainPoint ); // Secure return point
	//
	WinDosRunning = TRUE;
	while (!GSExit)
	   ;
	WinDosRunning = FALSE;
	//
	return 0;
} END_OF_MAIN();

