#include "kernel.h"
#include "allegro/internal/aintern.h"

unsigned short *std_key_ascii_table;
unsigned short *std_key_capslock_table;
unsigned short *std_key_shift_table;
unsigned short *std_key_control_table;
unsigned short *std_key_empty_table;
static int KeybInstalled=FALSE;

TKeybState KState;

PKeyboardLayout CurrentLayout = 0;
////////////////////////////////////////////////////////////////////////////////
void KeyboardSetLayout ( PKeyboardLayout l )
{
	if ( CurrentLayout )
	   free(CurrentLayout);
	CurrentLayout = malloc(sizeof(TKeyboardLayout));
	if ( !CurrentLayout )
	   return;
	memcpy(CurrentLayout,l,sizeof(TKeyboardLayout));
//  DebugMessage("Set Keyboard Layout <%s>",CurrentLayout->Name);
  _key_ascii_table         = CurrentLayout->ascii_table;
  _key_capslock_table      = CurrentLayout->capslock_table;
  _key_shift_table         = CurrentLayout->shift_table;
  _key_control_table       = CurrentLayout->control_table;
  _key_altgr_lower_table   = CurrentLayout->altgr_lower_table;
  _key_altgr_upper_table   = CurrentLayout->altgr_upper_table;
  _key_accent1_lower_table = CurrentLayout->accent1_lower_table;
  _key_accent1_upper_table = CurrentLayout->accent1_upper_table;
  _key_accent2_lower_table = CurrentLayout->accent2_lower_table;
  _key_accent2_upper_table = CurrentLayout->accent2_upper_table;
  _key_accent3_lower_table = CurrentLayout->accent3_lower_table;
  _key_accent3_upper_table = CurrentLayout->accent3_upper_table;
  _key_accent4_lower_table = CurrentLayout->accent4_lower_table;
  _key_accent4_upper_table = CurrentLayout->accent4_upper_table;
	_key_accent1 = CurrentLayout->accent1;
	_key_accent2 = CurrentLayout->accent2;
	_key_accent3 = CurrentLayout->accent3;
	_key_accent4 = CurrentLayout->accent4;
	_key_accent1_flag = CurrentLayout->accent1_flag;
	_key_accent2_flag = CurrentLayout->accent2_flag;
	_key_accent3_flag = CurrentLayout->accent3_flag;
	_key_accent4_flag = CurrentLayout->accent4_flag;
  _key_standard_kb = FALSE;

}
////////////////////////////////////////////////////////////////////////////////
PKeyboardLayout KeyboardGetLayout ( void )
{
	return CurrentLayout;
}
////////////////////////////////////////////////////////////////////////////////
void KeyboardEventGenerator ( PEvent Event )
{
	if (keypressed())
	{
	   Event->Type = EV_KEYBOARD;
	   KState.Key = readkey();
	   Event->Keyb = KState;
	}
	else
	{
	   Event->Type = EV_NOTHING;
	   KState.Shift = key_shifts;
	   KState.Key = 0;
	}
}
////////////////////////////////////////////////////////////////////////////////
void KeyboardDefaultLayout ( void )
{
	_key_ascii_table 		 = std_key_ascii_table;
	_key_capslock_table      = std_key_capslock_table;
	_key_shift_table         = std_key_shift_table;
	_key_control_table       = std_key_control_table;
	_key_altgr_lower_table   = std_key_empty_table;
	_key_altgr_upper_table   = std_key_empty_table;
	_key_accent1_lower_table = std_key_empty_table;
	_key_accent1_upper_table = std_key_empty_table;
	_key_accent2_lower_table = std_key_empty_table;
	_key_accent2_upper_table = std_key_empty_table;
	_key_accent3_lower_table = std_key_empty_table;
	_key_accent3_upper_table = std_key_empty_table;
	_key_accent4_lower_table = std_key_empty_table;
	_key_accent4_upper_table = std_key_empty_table;
	_key_accent1 = 0;
	_key_accent2 = 0;
	_key_accent3 = 0;
	_key_accent4 = 0;
	_key_accent1_flag = 0;
	_key_accent2_flag = 0;
	_key_accent3_flag = 0;
	_key_accent4_flag = 0;
	_key_standard_kb = TRUE;
}
////////////////////////////////////////////////////////////////////////////////
void KeyboardInstallLayout ( void )
{
	l_text LayoutFile = KeyGetText("/SYSTEM/KEYBOARD/LAYOUTS", "");
	//
	MsgInit("KeyboardInstallLayout");
	if ( TextCompare(LayoutFile,"" ) )
	{
		PFile f = FileOpen(LayoutFile,"rb");
		if ( f )
		{
			PKeyboardLayout CL = malloc(sizeof(TKeyboardLayout));
			//
			if ( CL )
			{
				FileRead(CL,1,sizeof(TKeyboardLayout),f);
				KeyboardSetLayout(CL);
				free(CL);
			}
			FileClose(f);
		}
	}
	else if ( CurrentLayout )
	{
		free( CurrentLayout);
		CurrentLayout = 0;
		KeyboardDefaultLayout();
	}
	MsgInitOk();
}
////////////////////////////////////////////////////////////////////////////////
void GSSystemKeyboardInstall ( void )
{
	MsgInit("GSSystemKeyboardInstall");
	std_key_ascii_table 		= _key_ascii_table;
	std_key_capslock_table 	= _key_capslock_table;
	std_key_shift_table 		= _key_shift_table;
	std_key_control_table 	= _key_control_table;
	std_key_empty_table 		= _key_altgr_lower_table;
	install_keyboard();
	InstallEventGenerator(KeyboardEventGenerator);
	MsgInitOk();
	KeyboardInstallLayout();
	KeybInstalled=TRUE;
}
////////////////////////////////////////////////////////////////////////////////
void GSSystemKeyboardUnInstall ( void )
{
	MsgInit("GSSystemKeyboardUnInstall");
	if ( CurrentLayout )
	   free(CurrentLayout);
	CurrentLayout = NULL;
	KeyboardDefaultLayout();
	MsgInitOk();
}
////////////////////////////////////////////////////////////////////////////////
l_bool __KeyboardStop ( void )
{
	if ( KeybInstalled )
	   remove_keyboard();
	//
	return true;
}
////////////////////////////////////////////////////////////////////////////////
l_bool __KeyboardRestart ( void )
{
	if ( KeybInstalled )
	{
	   install_keyboard();
	   KeyboardInstallLayout();
	}
	return true;
}
////////////////////////////////////////////////////////////////////////////////


