#include "kernel.h"
#include "ft2build.h"

FONT* default_font = 0;
/**
	Loads a font
	@param szFilename Path to the font to load
	@return The loaded font, or default font on failure.
*/
FONT*  FontLoad ( l_text szFilename )
{
	l_text Ext = TextRChr(szFilename, '.');
	//
	if (!Ext)
	{
	   return default_font;
	}
	//
	if (!fopen(szFilename, "rb"))
	{
	   return default_font;
	}

	if (!stricmp(Ext, ".FNT"))
	   return load_font(szFilename);
	else if (!stricmp(Ext, ".TTF"))
	   return load_ttf_font (szFilename, 9, 2);
	else
	   return default_font;
}

#ifdef NEWFONTSYS

/*

	New font system
	
	Work In Progress, !! not working !!

*/


FT_Library FreeTypeLibrary;

PList FontFaces;
PFontFace DefaultFontFace;
PFontSize DefaultFontSize;

PFontFace LoadFontFace ( l_text File ) {
	l_int Error;
	PFontFace o = malloc(sizeof(TFontFace));

	if ( !o )
	   return NULL;
	
 	Error = FT_New_Face( FreeTypeLibrary, File, 0, &o->face ); 

	if ( Error ) {
		
		free(o);
		return NULL;	
		
	}
	
	
	return o;
}


void InitFontSystem ( void ) {
	
	l_int Error;
	//
	MsgInit("InitFontSystem");
	FontFaces = NewList();
	//
	Error = FT_Init_FreeType( &FreeTypeLibrary );
	//
	if ( Error )
	   MsgInitErr();
	//
	MsgInitOk();
}

void UnInitFontSystem ( void )
{
	MsgInit("UnInitFontSystem");
	if ( FontFaces )
	   FreeList(FontFaces);
	MsgInitOk();
}

#endif




