#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include "dynld.h"
#include "zlib.h"
#include<coff.h>
#include <conio.h>
//
typedef struct TResEntrie
{
   char Name[ 32 ];
   unsigned long DataType;
   unsigned long DataEncode;
   unsigned long DataSize;
} TResEntrie;
//
typedef struct TResHead
{
   unsigned long Magic;
   unsigned long FormatVersion;
   unsigned long Entries;
} TResHead;
//
l_bool WriteString ( FILE *f, l_text s )
{
   l_ushort length = strlen( s );
   fwrite( &length, 1, 2, f );
   fwrite( s, 1, length, f );
   //
   return 1;
}
//
int main( int args, char **argv )
{
   char Cmd[ 2048 ] = { 0, 0, 0 };
   FILE *in, *out, *sc;
   FILHDR CoffHead;
   SCNHDR *CoffSections;
   RELOC CoffReloc;
   RELOC *CoffRelocs;
   SYMENT *CoffSymbols;
   char *CoffStrings;
   l_ulong CoffStringsSize;
   unsigned long CoffRelocsSize;
   int verbose = 0;
   //
   TDynLdHeader DynHead;
   void *DynData;
   TDynLdReloc DynReloc;
   char *DynName = "(unknown)";
   char Compress = 0;
   unsigned char d = 0;
   char *RessourceFile = 0;
   l_ulong i;
   //
   if ( args > 1 )
   {
      unsigned char i;
      //
      for( i=1; argv[ i ]; i++ )
      {
         if ( !strcmp( argv[ i ], "-C" ) )
         {
            Compress = 1;
            d++;
         }
         else if ( !strncmp( argv[ i ], "-R", 2 ) )
         {
            RessourceFile = strdup( argv[ i ]+2 );
            d++;
         }
         else if ( !strncmp( argv[ i ], "-V", 2 ) )
         {
            verbose = 1;
            d++;
         }
      }
   }
   //
   memset( &DynHead, 0, sizeof( TDynLdHeader ) );
   DynHead.Magic = ULONG_ID( 'D', 'n', 'L', 'd' );
   DynHead.FileFormatVersion = DYNLDVERSION;
   DynHead.Importations = 0;
   DynHead.Time = time( 0 );
   DynHead.MainOffset = NoneOffset;
   DynHead.CloseOffset = NoneOffset;
   DynHead.LibsOffset = NoneOffset;
   //
   if ( verbose )
   {
      printf( "DynLd Linker [%d.%d.%d.%d]\n", ULID_A( DYNLDVERSION ), ULID_B( DYNLDVERSION ), ULID_C( DYNLDVERSION ), ULID_D( DYNLDVERSION ) );
      printf( " (coff-go32)\n" );
      printf( "Copyright (c) Point Mad, Lukas Lipka. All rights reserved.\n" );
      printf( "\n" );
   }
   if ( args < 3 + d )
   {
      printf( "Usage: DYNLDLNK [-C] [-Rfile] <destination> <source> [source2] [source3] [...]\n" );
      printf( "\t[-C]           Enable Compression (Powered by ZLIB)\n" );
      printf( "\t[-Rfile]       Include ressource file 'file' (DMS res files only)\n" );
      printf( "\t<destination>  Executable (.WDE) / Library (.WDL) to generate\n" );
      printf( "\t<sources>      COFF file/s\n" );
      return 1;
   }
   /**
   *	Print compilation info
   */
   //	if ( RessourceFile && verbose )
   //	 printf( "(i) Ressource file: %s\n", RessourceFile );
   in = fopen( argv[ 2 + d ], "rb" );
   if ( !in )
   {
      printf( "/!\\ Error: Input file do not exists.\n" );
      return 1;
   }
   fread( &CoffHead, 1, FILHSZ, in );
   if ( CoffHead.f_nscns != 1 || args > 3 ) // Multiple sections... Call LD to make a common one
   {
      fclose( in );
      if ( !( sc = fopen( "dynld.ld", "rt" ) ) )
      {
         sc = fopen( "dynld.ld", "wt" );
         if ( sc )
         {
            fprintf( sc , "OUTPUT_FORMAT(\"coff-go32\")\n\nFORCE_COMMON_ALLOCATION\n\nSECTIONS {\n  .text : {\n\t*(.text)\n\t*(.data)\n\t*(.bss)\n\t*(COMMON)\n  }\n}\n" );
            fclose( sc );
            if ( verbose )
               printf( "(i) Script - dynld.ld - generated.\n" );
         }
         else
         {
            printf( "/!\\ Error : Unable to generate dynld.ld script\n" );
            return 1;
         }
      }
	  else
		 fclose( sc );
	  strcpy( Cmd, "ld -X -r -o _tmp.o " );
	  for( i = 2 + d; argv[ i ]; i++ )
	  {
		 strcat( Cmd, argv[ i ] );
		 strcat( Cmd, " " );
	  }
	  strcat( Cmd, " -T dynld.ld" );
	  if ( verbose )
		 printf( "(i) Calling LD (linker)\n" );
	  // -S skipped as LD crash
	  if ( system( Cmd ) )
	  {
		 printf( "/!\\ Error : LD have not return correct code...\n" );
		 return 1;
	  }
	  in = fopen( "_tmp.o", "rb" );
	  if ( !in )
	  {
		 printf( "/!\\ Error: Temporary file do not exists.\n" );
		 return 1;
	  }
	  fread( &CoffHead, 1, FILHSZ, in );
   }
   out = fopen( argv[ 1+d ], "wb+" );
   if ( !out )
   {
	  printf( "/!\\ Error: Unable to open output file.\n" );
	  return 1;
   }
   // Load Coff Sections
   fseek( in, CoffHead.f_opthdr, SEEK_CUR );
   CoffSections = ( SCNHDR * ) malloc( SCNHSZ*CoffHead.f_nscns );
   fread( CoffSections, CoffHead.f_nscns, SCNHSZ, in );
   // Load Coff Data
   DynHead.Size = CoffSections[ 0 ].s_paddr+CoffSections[ 0 ].s_size;
   DynData = ( void* )malloc( DynHead.Size );
   memset( DynData, 0, DynHead.Size );
   fseek( in, CoffSections[ 0 ].s_scnptr, SEEK_SET );
   fread( DynData, 1, CoffSections[ 0 ].s_size, in );
   // Load Coff Symbols
   fseek( in, CoffHead.f_symptr, SEEK_SET );
   CoffSymbols = ( SYMENT * ) malloc( SYMESZ*CoffHead.f_nsyms );
   fread( CoffSymbols, CoffHead.f_nsyms, SYMESZ, in );
   // Load Coff Strings
   fread( &CoffStringsSize, 1, 4, in );
   CoffStrings = ( char * ) malloc( CoffStringsSize-4 );
   memset( CoffStrings, 0, 4 );
   fread( CoffStrings+4, 1, CoffStringsSize-4, in );
   // Load Coff Relocations
   fseek( in, CoffSections[ 0 ].s_relptr, SEEK_SET );
   CoffRelocsSize = RELSZ*CoffSections[ 0 ].s_nreloc;
   CoffRelocs = malloc( CoffRelocsSize );
   fread( CoffRelocs, 1, CoffRelocsSize, in );
   // Write DynHeader
   fwrite( &DynHead, 1, sizeof( TDynLdHeader ), out );
   // Look for Key Data
   for ( i=0;i<CoffHead.f_nsyms;i++ )
   {
	  char *name, nam8[ 9 ];
	  if ( CoffSymbols[ i ].e.e.e_zeroes )
	  {
		 memcpy( nam8, CoffSymbols[ i ].e.e_name, 8 );
		 nam8[ 8 ] = 0;
		 name = nam8;
	  }
	  else
		 name = CoffStrings+CoffSymbols[ i ].e.e.e_offset;
	  //printf( "  %d : 0x%06x : %s\n", i, CoffSymbols[ i ].e_value, name );
	  if ( name[ 0 ] != '.' /*&& CoffSymbols[ i ].e_value*/ )
	  {
		 if ( !strcmp( name+1, "LibMain" ) ) DynHead.MainOffset = CoffSymbols[ i ].e_value;
			if ( !strcmp( name+1, "Main" ) )
		 {
			DynHead.Type = DYNLD_TYPEAPP;
			DynHead.MainOffset = CoffSymbols[ i ].e_value;
			if ( verbose )
			   printf( "Threading App\n" );
		 }
		 if ( !strcmp( name+1, "nUID" ) )
		 memcpy( &DynHead.UID, DynData+CoffSymbols[ i ].e_value, 12 );
			if ( !strcmp( name+1, "AppName" ) )
			DynName = ( char* )DynData+CoffSymbols[ i ].e_value;
		 if ( !strcmp( name+1, "Close" ) )
		 DynHead.CloseOffset = CoffSymbols[ i ].e_value;
			if ( !strcmp( name+1, "NeededLibs" ) )
			DynHead.LibsOffset = CoffSymbols[ i ].e_value;
		 if ( !strcmp( name+1, "AppVersion" ) )
		 memcpy( &DynHead.FileVersion, DynData+CoffSymbols[ i ].e_value, 4 );
			//printf( "  %d : 0x%06x : %s\n", i, CoffSymbols[ i ].e_value, name+1 );
	  }
      i += CoffSymbols[ i ].e_numaux;
   }
   if ( DynHead.MainOffset == NoneOffset )
   {
      printf( "\nWARNING : No Main() is defined.\n" );
      printf( "Example :\n" );
      printf( "#include\"kernel.h\"\n" );
      printf( "l_bool Main ( int argc, l_text *argv ) {\n" );
      printf( "  return true;\n" );
      printf( "}\n" );
   }
   if ( DynHead.CloseOffset == NoneOffset && DynHead.Type != DYNLD_TYPEAPP )
   {
      printf( "\nWARNING : No Close() is defined.\n" );
      printf( "Example :\n" );
      printf( "#include\"kernel.h\"\n" );
      printf( "void Close ( void ) {\n" );
      printf( "}\n" );
   }
   //Write Application name to file
   WriteString( out, DynName );
   // Precalculate relocations
   for ( i=0;i<CoffSections[ 0 ].s_nreloc;i++ ) 
   {
      if ( CoffRelocs[ i ].r_type == RELOC_REL32 && !CoffSymbols[ CoffRelocs[ i ].r_symndx ].e_scnum ) 
      {
         *( long* )( ( ( ( ( long )DynData ) )+CoffRelocs[ i ].r_vaddr ) ) += CoffRelocs[ i ].r_vaddr;
      }
   }
   //Write Data to File ( after haeder and informations text )
   if ( Compress )
   {
      void *Temp;
      //
      DynHead.Compression = 0x01;
      DynHead.OriginalSize = DynHead.Size;
      DynHead.Size = DynHead.OriginalSize+DynHead.OriginalSize/5+12;
      Temp = ( void* )malloc( DynHead.Size );
      compress( Temp, &DynHead.Size, DynData, DynHead.OriginalSize );
      fwrite( Temp, 1, DynHead.Size, out );
      free( Temp );
   }
   else
   {
      fwrite( DynData, 1, DynHead.Size, out );
   }
   // Write Inportaions
   for ( i=0;i<CoffHead.f_nsyms;i++ ) 
   {
	  char *name, nam8[ 9 ];
	  //
      if ( CoffSymbols[ i ].e.e.e_zeroes ) 
      {
         memcpy( nam8, CoffSymbols[ i ].e.e_name, 8 );
         nam8[ 8 ] = 0;
         name = nam8;
	  }
	  else
	  name = CoffStrings+CoffSymbols[ i ].e.e.e_offset;
	  if ( name[ 0 ] != '.' && !CoffSymbols[ i ].e_scnum )
	  {
		 WriteString( out, name+1 );
		 fwrite( &i, 1, 4, out );
		 DynHead.Importations++;
	  }
	  i += CoffSymbols[ i ].e_numaux;
   }
   for ( i=0;i<CoffSections[ 0 ].s_nreloc;i++ )
   {
	  if ( CoffRelocs[ i ].r_type == RELOC_ADDR32 || !CoffSymbols[ CoffRelocs[ i ].r_symndx ].e_scnum )
	  {
		 if ( CoffRelocs[ i ].r_type == RELOC_ADDR32 )
			DynReloc.Type = REL32_ABSOLUTE;
		 else
			DynReloc.Type = REL32_RELATIVE;
         DynReloc.Address = CoffRelocs[ i ].r_vaddr;
         DynReloc.Symbol = CoffRelocs[ i ].r_symndx;
         fwrite( &DynReloc, 1, sizeof( TDynLdReloc ), out );
         DynHead.Relocations++;
      }
   }
   fgetpos( out, &( DynHead.RessourceOffset ) );
   if ( RessourceFile )
   {
      FILE *r = fopen( RessourceFile, "rb" );
      //
      if ( r )
      {
         TResHead Head;
         unsigned long Entries;
         TResEntrie E;
         void *buffer;
         //
         fread( &Head, sizeof( TResHead ), 1, r );
         if ( Head.Magic == ULONG_ID( 'D', 'M', 'S', 'R' ) )
         {
            if ( Head.FormatVersion == ULONG_ID( 0, 0, 0, 1 ) )
            {
               Entries = Head.Entries;
               while ( Entries )
               {
                  fread( &E, sizeof( TResEntrie ), 1, r );
                  fwrite( &E, sizeof( TResEntrie ), 1, out );
                  buffer = malloc( E.DataSize );
                  fread( buffer, E.DataSize, 1, r );
                  fwrite( buffer, E.DataSize, 1, out );
                  Entries--;
               }
               DynHead.RessourceEntries = Head.Entries;
            }
         }
         fclose( r );
      }
   }
   if ( verbose )
   {
      printf( "\nApplication Informations\n" );
      printf( "UID : '%s' Name : '%s' Version : %lu.%lu.%lu.%lu\n", ( char* )&DynHead.UID, DynName, ULID_A( DynHead.FileVersion ), ULID_B( DynHead.FileVersion ), ULID_C( DynHead.FileVersion ), ULID_D( DynHead.FileVersion ) );
      if ( Compress )
         printf( "Compreession : %lu %%\n", DynHead.OriginalSize*100/DynHead.Size );
      //
      if ( DynHead.RessourceEntries )
         printf( "Ressource   : %lu Entrie(s)\n", DynHead.RessourceEntries );
   }
   fseek( out, 0, SEEK_SET );
   fwrite( &DynHead, 1, sizeof( TDynLdHeader ), out );
   free( CoffStrings );
   free( CoffSymbols );
   free( CoffSections );
   free( CoffRelocs );
   free( DynData );
   fclose( in );
   fclose( out );
   remove( "_tmp.o" );
   //
   return 0;
}
