#include <kernel.h>
//
l_ulong AppVersion = ULONG_ID( 0, 0, 0, 1 );
char AppName[] = "Cron";
l_uid nUID = "app:cron";
l_uid NeededLibs[] = { "" };
//
PTimer ClockTimer	= 0;
//
#define VERSION                  0.1
#define LINE_LENGTH              256
#define COMMAND_LENGTH           128
#define DEFAULT_CRONTAB          "crontab.txt"
//
static FILE *cron_file;
//
static l_text *crargs;
static l_int crargc;
void RefreshCron ( void *A )
{
   char input_line[ LINE_LENGTH ];
   char command_line[ COMMAND_LENGTH ];
   int minute, hour, day, month, day_of_week;
   int result, found;
   char *buf;
   struct tm *current_time;
   time_t time_value;
   int run_cron = 1;
   //
   if ( !run_cron )
	  CloseApp( &Me );
   /* get system time */
   time( & time_value );
   current_time = localtime( & time_value );
   if ( !current_time )
   {
	  DebugMessage( "Could not retrieve current time." );
	  CloseApp( &Me );
   }
   /* add on to day of week and to month */
   /* this is to fix the Windows/DOS bug of */
   /* starting at month 0 and Monday as day 0 */
   current_time->tm_wday++;
   current_time->tm_mon++;
   // Principio de cron_file.
   fseek( cron_file, 0L, SEEK_SET );
   /* read in lines from crontab */
   buf = fgets( input_line, LINE_LENGTH, cron_file );
   while ( buf )
   {
	  /* check for comment line */
	  if ( input_line[ 0 ] != '#' )
	  {
		 /* get time when events should happen */
		 sscanf( input_line, "%d %d %d %d %d", &minute, &hour, &day, &month, &day_of_week );
		 /* check if time matches */
		 if ( ( ( current_time->tm_min == minute ) || ( minute == -1 ) ) && ( ( current_time->tm_hour == hour ) || ( hour == -1 ) ) && ( ( current_time->tm_mday == day ) || ( day == -1 ) ) && ( ( current_time->tm_mon == month ) || ( month == -1 ) ) && ( ( current_time->tm_wday == day_of_week ) || ( day_of_week == -1 ) ) )
		 {
			/* time matches, so get command part of line */
			/* search for first non-numeric ( and non-space ) */
			result = 0;
			found = 0;
			while ( ( ( result < strlen( input_line ) ) && ( !found ) ) )
			{
			   if ( ( ( input_line[ result ] < '0' ) || ( input_line[ result ] > '9' ) ) && ( ( input_line[ result ] != ' ' ) && ( input_line[ result ] != '-' ) ) )
				  found = 1;
			   else
				  result++;
			}
			/* copy command line into a seperate varible */
			strncpy( command_line, &( input_line[ result ] ), COMMAND_LENGTH );
			/* make sure the newline character is removed */
			if ( strstr( command_line, "\n" ) )
			   command_line[ strlen( command_line ) - 1 ] = '\0';
			/* if command is equal to "exit" then quit cron */
			DebugMessage( "Cron say Current time is %d %d %d %d %d", current_time->tm_min, current_time->tm_hour, current_time->tm_mday, current_time->tm_mon, current_time->tm_wday );
			if ( ! strcmp( command_line, "exit" ) )
			{
			   DebugMessage( "Exit Cron." );
			   run_cron = 0;
			   CloseApp( &Me );
			}
			/* run the command */
			DebugMessage( "Cron run '%s'", command_line );
			_ParseArgs( command_line, NULL, &crargc, &crargs );
			FileRun( command_line, crargs );
			FreeArgs( crargc, crargs );
		 } /* end of if time matches */
	  } /* end of if line is not commented */
	  /* get next line */
	  buf = fgets( input_line, LINE_LENGTH, cron_file );
   } /* end of while */
}
//
l_int Main( l_int argc, l_text *argv )
{
   /* start by opening file */
   cron_file = fopen( DEFAULT_CRONTAB, "r" );
   if ( !cron_file )
   {
	  DebugMessage( "Could not open crontab file." );
	  CloseApp( &Me );
   }
   //
   ClockTimer = NewTimer( &Me, ( 60 * 1000 ), &RefreshCron, NULL );
   //
   return true;
}
//
void Close ( void )
{
   if ( cron_file )
	  fclose( cron_file );
   //
   KillTimer( ClockTimer );
}
