#ifndef _SOUND_H_INCLUDED_
   #define _SOUND_H_INCLUDED_
   typedef                          struct TSStreamDriver *PSStreamDriver;
   typedef struct TSStream *PSStream;
   typedef struct TSStreamDriver 
   {
      l_ulong Codec; 
      l_int ( *ExtractSample ) ( PSStream s, void *Buffer );
      l_bool ( *SetPosMsec ) ( PSStream s, l_ulong msec );
      l_bool ( *GetPosMsec ) ( PSStream s, l_ulong *msec );
      l_bool ( *GetLengthMsec ) ( PSStream s, l_ulong *msec );
      l_bool ( *Free ) ( PSStream s );
   } TSStreamDriver;
   typedef struct TSStream 
   {
      PSStreamDriver Driver;
      PFile f;
      void *Ex;
      l_bool Finished;
      l_bool Playing;
      l_int voice; 
      struct SAMPLE *samp; 
      l_int len; 
      l_int bufcount; 
      l_int bufnum; 
      l_int active; 
      void *locked; 
   } TSStream;
   #define SSTREAM(                 o ) ( ( PSStream )( o ) )
   PSStream NewSoundStream ( PSStreamDriver Drv, PFile f, void *Ex, l_int len, l_int bits, l_int stereo, l_int freq );
   l_bool PlaySoundStream( PSStream o );
   l_bool PauseSoundStream( PSStream o );
   l_bool SStreamGetPosMsec( PSStream o, l_ulong *msec );
   l_bool SStreamGetLengthMsec( PSStream o, l_ulong *msec );
   l_bool SStreamSetPosMsec( PSStream o, l_ulong msec );
   l_bool SStreamFree( PSStream o ); 
   void SetVolumeMidi ( l_int Volume );
   void SetVolumeDigi ( l_int Volume );
   extern l_int VolumeDigi, VolumeMidi;
#endif
