#ifndef _PLATFORM_H_INCLUDED_
   #define _PLATFORM_H_INCLUDED_
   #ifdef                           DJGPP
      #define _WinDos__DJGPP_
   #endif
   #define _INLINE                  extern __inline__
   #ifdef _WinDos__DJGPP_
      #define LWP_THREAD
   #endif
   extern                           long Platform;
   #define PL_DOS                   0 
   #define PL_WIN                   1 
   #define PL_LNX                   2 
   #ifndef _WinDos__WIN32_
      _INLINE void __farsetsel( unsigned short selector ) 
      {
         if ( !Platform ) { 
            __asm__ __volatile__ ( "movw %w0,%%fs"
         :
         : "rm" ( selector ) );
      }
   }
   _INLINE void __farnspokeb( unsigned long addr, unsigned char val ) 
   {
      if ( !Platform ) 
      {
         __asm__ __volatile__ ( ".byte 0x64\n"
         "	movb %b0,(%k1)"
         :
         : "qi" ( val ), "r" ( addr ) );
      } else
      ( *( ( unsigned char * )( addr ) ) = ( val ) );
   }
   _INLINE void __farnspokew( unsigned long addr, unsigned short val ) 
   {
      if ( !Platform ) 
      {
         __asm__ __volatile__ ( ".byte 0x64\n"
         "	movw %w0,(%k1)"
         :
         : "ri" ( val ), "r" ( addr ) );
      } else
      ( *( ( unsigned short * )( addr ) ) = ( val ) );
   }
   _INLINE void __farnspokel( unsigned long addr, unsigned long val ) 
   {
      if ( !Platform ) 
      {
         __asm__ __volatile__ ( ".byte 0x64\n"
         "	movl %k0,(%k1)"
         :
         : "ri" ( val ), "r" ( addr ) );
      } else
      ( *( ( unsigned long * )( addr ) ) = ( val ) );
   }
   _INLINE unsigned char __farnspeekb( unsigned long addr ) 
   {
      if ( !Platform ) { 
         unsigned char result;
      __asm__ __volatile__ ( ".byte 0x64\n"
      "	movb (%k1),%b0"
      : "=q" ( result )
      : "r" ( addr ) );
      return result;
   } else
   return ( *( ( unsigned char * )( addr ) ) );
}
_INLINE unsigned short __farnspeekw( unsigned long addr ) 
{
   if ( !Platform ) { 
      unsigned short result;
   __asm__ __volatile__ ( ".byte 0x64\n"
   "	movw (%k1),%w0"
   : "=r" ( result )
   : "r" ( addr ) );
   return result;
} else
return ( *( ( unsigned short * )( addr ) ) );
}
_INLINE unsigned long __farnspeekl( unsigned long addr ) 
{
   if ( !Platform ) 
   {
      unsigned long result;
      __asm__ __volatile__ ( ".byte 0x64\n"
      "	movl (%k1),%k0"
      : "=r" ( result )
      : "r" ( addr ) );
      return result;
   } else
   return ( *( ( unsigned long * )( addr ) ) );
}
#define _farsetsel(              seg ) 	__farsetsel( seg )
#define _farnspokeb(             addr, val ) __farnspokeb( addr, val )
#define _farnspokew(             addr, val ) __farnspokew( addr, val )
#define _farnspokel(             addr, val ) __farnspokel( addr, val )
#define _farnspeekb(             addr ) __farnspeekb( addr )
#define _farnspeekw(             addr ) __farnspeekw( addr )
#define _farnspeekl(             addr ) __farnspeekl( addr )
#define __dj_include_sys_farptr_h_
#define ALLEGRO_DJGPP
#endif
#endif                           
