#ifndef __PCI_H__INCLUDED__
   #define __PCI_H__INCLUDED__
   //
   // Defines for PCI stuff
   //
   // Values for GetLastPciError()
   #define PCI_ERR_SUCCESS          0x00 // No error ( success )
   #define PCI_ERR_UNSUPP           0x81 // Unsupported function
   #define PCI_ERR_BADVENID         0x83 // Bad vendor id
   #define PCI_ERR_NODEV            0x86 // Device not found
   #define PCI_ERR_BADREG           0x87 // Bad register number
   // Values for BIOS functions
   #define PCI_INT                  0x1A // PCI BIOS Interrupt
   #define PCI_SIGNATURE            ' ICP' // Signature for INSTALL call
   #define PCI_DEV_MAX              0x1F // Max. value for dev parameter
   #define PCI_FUNC_MAX             0x07 // Max. value for func parameter
   #define PCI_BIOS_INSTALL         0xB101 // PCI Bios installation check
   #define PCI_BIOS_FINDDEV         0xB102 // PCI Bios find device
   #define PCI_BIOS_FINDCLASS       0xB103 // PCI Bios find class
   #define PCI_BIOS_CFG_RD8         0xB108 // PCI Bios Read configuration byte
   #define PCI_BIOS_CFG_RD16        0xB109 // PCI Bios Read configuration word
   #define PCI_BIOS_CFG_RD32        0xB10A // PCI Bios Read configuration dword
   #define PCI_BIOS_CFG_WR8         0xB10B // PCI Bios Write configuration byte
   #define PCI_BIOS_CFG_WR16        0xB10C // PCI Bios Write configuration word
   #define PCI_BIOS_CFG_WR32        0xB10D // PCI Bios Write configuration dword
   // Values for Configuration registers
   // Generic Registers ( For all devices )
   #define PCI_CFG_R16_VENID        0x00 // Vendor ID register
   #define PCI_CFG_R16_DEVID        0x02 // Device ID register
   #define PCI_CFG_R16_CMD          0x04 // Command register
   #define PCI_CFG_R16_STATUS       0x06 // Status register
   #define PCI_CFG_R16_REV          0x08 // Revision ID register
   #define PCI_CFG_R24_CLASS        0x09 // Class code
   #define PCI_CFG_R8_HDRTYPE       0x0E // Class code
   // Registers for device with type 0 header
   // There are may more registers, refer to PCI specification
   #define PCI_CFG_R32_BAR0         0x10 // BAR0
   #define PCI_CFG_R32_BAR1         0x14 // BAR1
   #define PCI_CFG_R32_BAR2         0x18 // BAR2
   #define PCI_CFG_R32_BAR3         0x1C // BAR3
   #define PCI_CFG_R32_BAR4         0x20 // BAR4
   #define PCI_CFG_R32_BAR5         0x24 // BAR5
   #define PCI_CFG_R32_CISPTR       0x28 // Cardbus CIS Pointer
   #define PCI_CFG_R16_SVID         0x2C // Subsystem vendor id
   #define PCI_CFG_R16_SDID         0x2E // Subsystem device id
   #define PCI_CFG_R32_EXROM        0x30 // Expansion ROM base address
   #define PCI_CFG_R8_CAPPTR        0x34 // Capabilities ptr
   #define PCI_CFG_R8_INTLINE       0x3C // Interrupt line
   #define PCI_CFG_R8_INTPIN        0x3D // Interrupt pin
   //
   // PCI BIOS generic interfaces
   //
   l_byte PciGetLastError();
   l_bool IsPciBiosPresent();
   l_byte GetPciBiosVerLo();
   l_byte GetPciBiosVerHi();
   l_byte GetPciBussesInSystem();
   l_ushort GetPciDeviceCount();
   l_bool PciSearchForDevice( l_ushort venid, l_ushort devid, l_byte* bus, l_byte* dev, l_byte* func, l_ushort* marker );
   //
   // PCI configuration registers read access
   //
   l_byte PciReadConfigByte( l_byte bus, l_byte dev, l_byte func, l_byte reg );
   l_ushort PciReadConfigWord( l_byte bus, l_byte dev, l_byte func, l_byte reg );
   l_dword PciReadConfigDWord( l_byte bus, l_byte dev, l_byte func, l_byte reg );
   //
   // PCI configuration registers write access
   //
   l_byte PciWriteConfigByte( l_byte bus, l_byte dev, l_byte func, l_byte reg, l_byte data );
   l_byte PciWriteConfigWord( l_byte bus, l_byte dev, l_byte func, l_byte reg, l_ushort data );
   l_byte PciWriteConfigDWord( l_byte bus, l_byte dev, l_byte func, l_byte reg, l_dword data );
#endif
