#ifndef _LWP_H
   #define _LWP_H
   #include                         <dpmi.h>
   #include <signal.h>
   #include <string.h>
   #include <stdlib.h>
   #include <time.h>
   #define LWP_MAIN                 -1 
   #define LWP_TCP                  -2 
   #define RTC2                     0xF
   #define RTC4                     0xE
   #define RTC8                     0xD
   #define RTC16                    0xC
   #define RTC32                    0xB
   #define RTC64                    0xA
   #define RTC128                   0x9
   #define RTC256                   0x8
   #define RTC512                   0x7
   #define RTC1024                  0x6
   #define RTC2048                  0x5
   #define RTC4096                  0x4
   #define RTC8192                  0x3
   #ifdef __cplusplus
      extern "C" 
      {
      #endif
      typedef volatile struct 
      {
         int owned; 
         int owner_id; 
      } lwp_semaphore;
      typedef struct
      {
         time_t secs; 
         short msecs; 
      } lwp_time;
      typedef void ( *lwp_atkill_fct )( void );
      #define MAX_ATKILL               32
      typedef struct lwp_struct 
      {
         int lwpid;
         struct lwp_struct *next;
         int stklen;
         unsigned int *stack, 
         *stackTop;
         unsigned priority; 
         enum 
         {
            LWP_RUNNING, 
            LWP_SLEEPING, 
            LWP_WAIT_SEMAPHORE, 
            LWP_WAIT_TRUE, 
            LWP_WAIT_FALSE, 
            LWP_DEAD
         } status;
         union 
         {
            lwp_semaphore *what_sema; 
            volatile int *what_int; 
            lwp_time wakeup_time; 
         } waiting;
         void *userptr; 
         lwp_atkill_fct atkill[ MAX_ATKILL ];
      } lwp;
      int lwp_init( int irq, int speed );
      int lwp_spawn( void ( *proc )( void* ), void *arg, int stack_length, unsigned priority );
      int lwp_atkill( void ( *proc )( void ) );
      int lwp_kill( int lwpid );
      int lwp_getpid( void );
      void lwp_setuserptr( void *usrdata );
      void *lwp_getuserptr( void );
      void lwp_yield( void );
      int lwp_getactive( void );
      void lwp_set_priority( unsigned priority );
      unsigned lwp_get_priority( void );
      void lwp_sleep( unsigned int secs, unsigned short msecs );
      void lwp_wait_true( volatile int *what ); 
      void lwp_wait_false( volatile int *what ); 
      void lwp_pulse_true( volatile int *what ); 
      void lwp_pulse_false( volatile int *what ); 
      void lwp_wait_semaphore( lwp_semaphore *sema );
      int lwp_release_semaphore( lwp_semaphore *sema );
      void lwp_init_semaphore( lwp_semaphore *sema );
      extern void _lwp_pm_irq8_timer_hook( void );
      extern void _lwp_pm_irq0_timer_hook( void );
      extern long _lwpasm_start;
      extern long _lwpasm_end;
      int _lwp_lock_data( void *lockaddr, unsigned long locksize );
      int _lwp_unlock_data( void *lockaddr, unsigned long locksize );
      int _lwp_lock_code( void *lockaddr, unsigned long locksize );
      int _lwp_unlock_code( void *lockaddr, unsigned long locksize );
      extern lwp *_lwp_cur;
      extern int _lwp_heavy_dbg;
      volatile void lwp_thread_enable( void );
      volatile void lwp_thread_disable( void );
      #ifdef __cplusplus
      }
   #endif
   #if 0
      #include "lwpconio.h"
      #include "lwpstdio.h"
      #include "lwppc.h"
      #include "lwpstdlib.h"
   #endif
#endif
