#include <setjmp.h>
#include "types.h"
#include "list.h"
#include "stdio.h"
#include "vfile.h"
#include "error.h"
//
#ifndef _DYNLD_H_INCLUDED_
   #define _DYNLD_H_INCLUDED_
   //
   #define DYNLDVERSION             ULONG_ID( 0, 6, 3, 0 )
   #define DynLdStateToFree         0xFF
   #define DYNLD_STRATING           0x01
   #define DYNLD_RUNNING            0x02
   #define DYNLD_TYPELIB            0x00
   #define DYNLD_TYPEAPP            0x01
   //
   typedef struct TConsole *PConsole;
   typedef struct TDialog *PDialog;
   typedef struct TApplication *PApplication;
   //
   typedef struct TApplication 
   {
      l_text Name;
      l_text FileName;
      l_ulong Version;
      void *Data;
      l_int ( *Main )( int argc, l_text *argv );
      void ( *Close )( void );
	  PList	Ressource;
      l_uchar	State; 
	  l_char	Type;
      l_int	ThreadId; 
      l_uid 	 UID;
      l_uid 	*Libs;
	  l_ulong Users;
	  //
	  PConsole 	Cons;
	  PFile 	StdIn;
	  PFile 	StdOut;
	  #ifdef ALLEGRO_H
		 PIcon	Icon;
	  #else
		 void 	*Icon;
	  #endif
	  int 	argc;
	  l_text 	*argv;
	  //
	  PApplication Host;
	  //
	  PDialog Dialog;
   } TApplication;
   //
   #define APPLICATION( o )                   ( ( PApplication )( o ) )
   //
   typedef struct TDynLdHeader
   {
      l_ulong	Magic;
      l_ulong	FileFormatVersion;
      l_ulong	SupportedApiVersion;
      l_ulong	Time;
      l_ulong Relocations;
      l_ulong	Importations;
      l_ulong	Size;
      l_uid UID;
      l_ulong	FileVersion;
      l_ulong	Flags;
      l_uchar	Type;
      l_ulong	MainOffset;
      l_ulong	CloseOffset;
      l_ulong LibsOffset;
      l_uchar	Compression;
      l_ulong	OriginalSize;
      l_ulong RessourceOffset;
      l_ulong	RessourceEntries;
   } TDynLdHeader, *PDynLdHeader;
   //
   typedef struct TDynLdReloc
   {
	  l_ulong	Type;
	  l_ulong	Address;
	  l_ulong	Symbol;
   } TDynLdReloc, *PDynLdReloc;
   //
   typedef struct TDynLdExt
   {
	  l_text	Name;
	  l_ulong	Symbol;
   } TDynLdExt, *PDynLdExt;
   //
   typedef struct TSymbol
   {
	  struct TListItem	Itm;
	  PApplication	App;
   } TSymbol, *PSymbol;
   //
   #define SYMBOL( o )              ( ( PSymbol )( o ) )
   #define NoneOffset               0xFFFFFFFF
   #define REL32_ABSOLUTE           0x01
   #define REL32_RELATIVE           0x02
   //
   void InitDynLd ( void );
   void ShutDownDynLd ( void );
   PApplication DynLdRun ( l_text Filename, l_text Args );
   PApplication DynLdRun2 ( l_text Filename, l_text Args );
   PApplication DynLdRunEx ( l_text Filename, l_int argc, l_text* argv, PApplication Host, PErrorHandler h );
   void CloseApp ( PApplication App );
   PSymbol AddSymbol ( l_text Name, void *Value, PApplication App );
   l_long ResolveSymbol ( PApplication App, l_text Name );
   //
   #define APPEXPORT( Name ) 	        AddSymbol( #Name, &Name, &Me )
   #define APPEXPORTAS( Func, Name )	AddSymbol( Name, &Func, &Me )
   #define SYSEXPORT( Name )        	AddSymbol( #Name, ( void* )&Name, NULL )
   #define SYSEXPORTAS( Func, Name )	AddSymbol( Name, ( void* )&Func, NULL )
   //
   extern TApplication Me;
   void RegisterExports();
   l_bool DynLdInstallLibrary ( l_text file );
   void _ParseArgs ( l_text Args, l_text Initial, int *argc, l_text **argv );
   l_text *DuplicateArgs ( int argc, l_text *argv );
   void FreeArgs ( int argc, l_text *argv );
   void BreakApp ( PApplication App );
   PApplication DynLdCommand ( l_text Command );
   void RegistryLoadLibraries ( l_text Name );
   //
   typedef struct TAppExtender 
   {
      void ( *Init ) ( PApplication App );
      void ( *DeInit ) ( PApplication App );
   } TAppExtender, *PAppExtender;
   //
   PAppExtender InstallAppExtender ( void ( *Init )( PApplication ), void ( *DeInit )( PApplication ) );
   void RemoveAppExtender ( PAppExtender o );
#endif 
