#include <stdio.h>
#include <string.h>
//
typedef struct
{
		unsigned char Ver;
		unsigned char Mayor;
		unsigned char Menor;
		unsigned char Revision;
} VERSION;
VERSION version;
char fin[ 0xFF ];
char arv[ 0xFF ];
//
int main( int argc, char **argv )
{
	FILE *vn,*ivn;
	//
	if ( argc < 3 )
	{
	   fprintf(stderr, "Parametros Insuficientes\n" );
	   return -1;
	}
	strcpy( arv, argv[ 1 ] );
	strcpy( fin, argv[ 2 ] );
	//
	vn = fopen( arv, "rb" );
	if ( !vn )
	{
	   vn = fopen( arv, "wb" );
	   if ( !vn )
	   {
		  fprintf( stderr, ": ERROR Al Cargar Fichero %s\n", arv );
		  return 1;
	   }
	}
	//
	fprintf( stderr,"WinDos ");
	//
	fread( &version, sizeof( VERSION ), 1, vn );
	fclose( vn );
	//
	version.Revision++;
	if ( !version.Revision )
	{
	   version.Menor++;
	   if ( !version.Menor )
	   {
		  version.Mayor++;
		  if ( !version.Mayor )
		  {
			 version.Ver++;
		  }
	   }
	}
	if ( version.Ver == 0x0d )
	   version.Ver++;
	if ( version.Mayor == 0x0d )
	   version.Mayor++;
	if ( version.Menor == 0x0d )
	   version.Menor++;
	if ( version.Revision == 0x0d )
	   version.Revision++;
	//
	vn = fopen( arv, "wb" );
	if ( !vn )
	{
	   fprintf( stderr, ": ERROR Al Actualizar %s\n", arv );
	   return -1;
	}
	fwrite( &version, sizeof( VERSION ), 1, vn );
	fclose( vn );
	//
	ivn = fopen( fin, "wt" );
	if ( !ivn )
	{
	   fprintf( stderr, ": ERROR Al Actualizar Fichero #Include de Version\n" );
	   return -1;
	}
	fprintf( ivn, "#ifndef __WINDOS_VERSION__\n" );
	fprintf( ivn, "   #define __WINDOS_VERSION__\n" );
	fprintf( ivn, "   #ifdef __cplusplus\n" );
	fprintf( ivn, "      extern " ); fputc('"',ivn); fputc('C',ivn); fputc('"',ivn);
	fprintf( ivn, " {\n   #endif\n" );
	fprintf( ivn, "   unsigned int WINDOS_VERSION      = %d;\n", version.Ver );
	fprintf( ivn, "   unsigned int WINDOS_VER_MAJOR    = %d;\n", version.Mayor );
	fprintf( ivn, "   unsigned int WINDOS_VER_MINOR    = %d;\n", version.Menor );
	fprintf( ivn, "   unsigned int WINDOS_VER_REVISION = %d;\n", version.Revision );
	//
	fprintf( ivn, "   char WinDosTxt[]                 = " );
	fputc( '"',ivn);
	fprintf( ivn, "WinDos" );
	fputc( '"',ivn); fprintf( ivn,";\n");
	//
	fprintf( ivn, "   char WinDosTxtVersion[]          = " );
	fputc( '"',ivn);
	fprintf( ivn, "Version %d.%d.%d Revision %d [%s %s]", version.Ver, version.Mayor, version.Menor, version.Revision, __DATE__, __TIME__ );
	fputc( '"',ivn); fprintf( ivn,";\n");
	//
	fprintf( ivn, "   char WinDosVersionTxt[]          = " );
	fputc( '"',ivn);
	fprintf( ivn, "%d.%d.%d.%d", version.Ver, version.Mayor, version.Menor, version.Revision );
	fputc( '"',ivn); fprintf( ivn,";\n");
	//
	fprintf( ivn, "   int KernelVersion                = " );
	fprintf( ivn, "%d%d%d%d", version.Ver, version.Mayor, version.Menor, version.Revision );
	fprintf( ivn,";\n");
	//
	fprintf( ivn, "   char WinDosTxtCopyRight[]        = " );
	fputc( '"',ivn);
	fprintf( ivn, "(c) CopyRight 2008 By EL CHANGO v4.-");
	fputc( '"',ivn); fprintf( ivn,";\n");
	//
	fprintf( ivn, "   char WinDosTxtReserved[]         = " );
	fputc( '"',ivn);
	fprintf( ivn, "All Rights Reserved.");
	fputc( '"',ivn); fprintf( ivn,";\n");
	//
	fprintf( ivn, "   char WinDosTxtEmailArg[]         = " );
	fputc( '"',ivn);
	fprintf( ivn, "El_Chango@Argentina.com");
	fputc( '"',ivn); fprintf( ivn,";\n");
	//
	fprintf( ivn, "   char WinDosTxtEmailMex[]         = " );
	fputc( '"',ivn);
	fprintf( ivn, "El_Chango@Mexico.com");
	fputc( '"',ivn); fprintf( ivn,";\n");
	//
	fprintf( ivn, "   #ifdef __cplusplus\n" );
	fprintf( ivn, "      }\n" );
	fprintf( ivn, "   #endif\n" );
	fprintf( ivn, "#endif\n" );
	//
	fclose( ivn );
	fprintf( stderr, "Version %d.%d.%d Revision %d [%s %s]\n", version.Ver, version.Mayor, version.Menor, version.Revision, __DATE__, __TIME__ );
	//
	return 0;
}
