#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include "dynld.h"
#include "zlib.h"
#include <coff.h>
#include <conio.h>
#include <unistd.h>
#include "nodos.h"
#include "doslfn.h"
/****************************************************************************/
#define VERSION                  "version 0.0.1"
/****************************************************************************/
static int ld_doslfn = 0;
/****************************************************************************/
void Ayuda( void )
{
   printf( "Kgcc.exe [opciones] fichero...\n" );
   printf( "Opciones:\n" );
   printf( "  -v               Muestra la Version y Sale.\n" );
   printf( "  -c               Compila y Ensambla.\n" );
   printf( "  -o <fichero>     Manda la Salida a <fichero>\n" );
   printf( "  -V               Muestra informacion extra.\n" );
   printf( "  -K<fichero>      Genera Ejecutable para WinDos.\n" );
   printf( "  -C               Comprime el Ejecutable para WinDos.\n" );
   printf( "  -R<fichero>      Resource file.\n" );
   printf( "  -LFN             Permite Ficheros de Nombres Largos.\n" );
   printf( "  -G <...>         Pasa <...> a Gcc.Exe\n\n" );
   /* */
   exit( -14 );
}
/****************************************************************************/
typedef struct TResEntrie
{
   char Name[ 32 ];
   unsigned long DataType;
   unsigned long DataEncode;
   unsigned long DataSize;
} TResEntrie;
//
typedef struct TResHead
{
   unsigned long Magic;
   unsigned long FormatVersion;
   unsigned long Entries;
} TResHead;
/****************************************************************************/
l_bool WriteString ( FILE *f, l_text s )
{
   l_ushort length = strlen( s );
   fwrite( &length, 1, 2, f );
   fwrite( s, 1, length, f );
   //
   return 1;
}
/****************************************************************************/
char *chext( char *buffer, char *file )
{
   char *buf = strrchr( file, '.' );
   /* */
   if ( buf )
      strncpy( buffer, file, buf - file );
   /* */
   strcat( buffer, ".o" );
   /* */
   return buffer;
}
/****************************************************************************/
char *dlfnt = NULL;
void load_doslfn( char *param )
{
   int i = 0, j;
   FILE *fp = NULL;
   char rdlfn[ FILENAME_MAX ];
   /* */
   dlfnt = ( char * )malloc( FILENAME_MAX );
   for( j = 0; j < 100; j++ )
   {
	  sprintf( dlfnt, "%s/doslfn%02d.com", getenv( "TEMP" ), i++ );
	  remove( dlfnt );
	  if ( ( fp = fopen( dlfnt, "wb" ) ) != NULL )
		 break;
   }
   if ( !fp )
   {
	  perror( dlfnt );
	  exit( -15 );
   }
   /* */
   fwrite( DOSLFN, 1, LEN_DOSLFN, fp );
   fflush( fp );
   fclose( fp );
   /* */
   sprintf( rdlfn, "%s %s > NUL", dlfnt, param );
   i = system( rdlfn );
}
/****************************************************************************/
void kgcc_exit( void )
{
   char rdlfn[ FILENAME_MAX ], ft[ 0xFF ];
   int i;
   /* */
   if ( dlfnt )
   {
	  sprintf( rdlfn, "%s -u > NUL", dlfnt );
	  i = system( rdlfn );
	  remove( dlfnt );
   }
   /* */
   sprintf( ft, "%s/__kgcc__.tmp", getenv( "TEMP" ) );
   remove( ft );
   //
   if ( ld_doslfn )
	  load_doslfn("-u");
}
/****************************************************************************/
void restore_opgcc( char *filename, char *op )
{
   FILE *fp = fopen( filename, "rt" );
   int i = 0;
   /* */
   if ( !fp )
   {
      perror( filename );
      exit( -20 );
   }
   /* */
   while( !feof( fp ) )
      op[ i++ ] = fgetc( fp );
   op[ i++ ] = 0;
   /* */
   fclose( fp );
}
/****************************************************************************/
int main( int argc, char **argv )
{
   FILE *fp;
   int i;
   int generar_dll = 0;
   char *name_dll=0;//[ 4096 ];
   int compile_file = 0;
   char list_input[ 32 ][ 4096 ];
   char list_obj[ 32 ][ 4096 ];
   int ptr_li = 0;
   int ptr_lo = 0;
   char opgcc1[ 4096 ];
   char opgcc2[ 4096 ];
   int call_gcc = 0;
   char cmd_gcc[ 4096 ];
   char *ke = getenv( "KGCC" );
   int r;
   //
   char Cmd[ 2048 ] = { 0, 0, 0 };
   FILE *in, *out, *sc;
   FILHDR CoffHead;
   SCNHDR *CoffSections;
//   RELOC CoffReloc;
   RELOC *CoffRelocs;
   SYMENT *CoffSymbols;
   char *CoffStrings;
   l_ulong CoffStringsSize;
   unsigned long CoffRelocsSize;
   int verbose = 0;
   //
   TDynLdHeader DynHead;
   void *DynData;
   TDynLdReloc DynReloc;
   char *DynName = "(unknown)";
   char Compress = 0;
   char *RessourceFile = 0;
   char ft[ 0xFF ];
   //
   /* */
   if ( argc < 2 )
	  Ayuda();
   /* */
   strcpy( opgcc1, "" );
   strcpy( opgcc2, "" );
   for( i = 1; i < argc; i++ )
   {
	  if ( argv[ i ][ 0 ] == '-' && argv[ i ][ 1 ] == 'v' )
	  {
         printf( "Kgcc %s\n", VERSION );
         system( "gcc.exe -v" );
         //
         return 0;
      }
      /* */
      if ( argv[ i ][ 0 ] == '-' )
      {
		 if ( argv[ i ][ 1 ] == 'G' )
         {
            int j;
            /* */
			i++;
            for( j = i; j < argc; j++ )
            {
               strcat( opgcc1, argv[ j ] );
			   strcat( opgcc1, " " );
			}
			call_gcc = 1;
			break;
         }
         else if ( argv[ i ][ 1 ] == '@' )
         {
            restore_opgcc( argv[ i ] + 2, opgcc1 );
            call_gcc = 1;
         }
         else if ( argv[ i ][ 1 ] == 'f' || argv[ i ][ 1 ] == 'D' || argv[ i ][ 1 ] == 'm' || argv[ i ][ 1 ] == 'w' )
         {
			strcat( opgcc2, argv[ i ] );
            strcat( opgcc2, " " );
         }
         else if ( argv[ i ][ 1 ] == 'L' )
		 {
            if ( argv[ i ][ 2 ] == 'F' )
            {
               if ( argv[ i ][ 3 ] == 'N' )
			   {
				  ld_doslfn = 1;
			   }
			}
         }
		 else if ( argv[ i ][ 1 ] == 'V' )
		 {
			verbose = 1;
         }
		 else if ( argv[ i ][ 1 ] == 'c' )
         {
            compile_file = 1;
		 }
		 else if ( argv[ i ][ 1 ] == 'C' )
		 {
			Compress = 1;
		 }
		 else if ( argv[ i ][ 1 ] == 'R' )
		 {
			RessourceFile = strdup( argv[ i ] + 2 );
		 }
		 else if ( argv[ i ][ 1 ] == 'K' )
		 {
			generar_dll = 1;
			name_dll = strdup( argv[ i ] + 2 );
		 }
		 else if ( argv[ i ][ 1 ] == 'o' )
         {
            strcpy( list_obj[ ptr_lo++ ], argv[ ++i ] );
         }
         else
         {
			strcat( opgcc1, argv[ i ] );
            strcat( opgcc1, " " );
         }
	  }
	  else
      {
         fp = fopen( argv[ i ], "r" );
         /* */
         if ( fp && compile_file )
		 {
			strcpy( list_input[ ptr_li++ ], argv[ i ] );
		 }
         else
         {
            strcpy( list_obj[ ptr_lo++ ], argv[ i ] );
         }
         /* */
         fclose( fp );
      }
   }
   opgcc1[ strlen( opgcc1 ) - 1 ] = 0;
   opgcc2[ strlen( opgcc2 ) - 1 ] = 0;
   /* */
   if ( ld_doslfn )
	  load_doslfn("");
   /* */
   atexit( kgcc_exit );
   /* */
   sprintf( ft, "%s/__kgcc__.tmp", getenv( "TEMP" ) );
   //
   if ( call_gcc )
   {
	  remove( ft );
	  fp = fopen( ft, "wt" );
	  /* */
	  if ( !fp )
	  {
		 perror( ft );
		 return -1;
	  }
	  /* */
	  sprintf( cmd_gcc, "-I%s/include %s %s\n", ke, opgcc1, opgcc2 );
	  /* */
	  fprintf( fp, "%s\n", cmd_gcc );
	  /* */
	  fflush( fp );
	  fclose( fp );
	  /* */
	  sprintf( cmd_gcc, "gcc.exe @%s", ft );
	  /* */
      r = system( cmd_gcc );
      /* */
	  remove( ft );
	  if ( r )
		 exit( -16 );
	  /* */
	  return 0;
   }
   /* */
   if ( compile_file )
   {
	  fp = fopen( ft, "wt" );
	  /* */
	  if ( !fp )
	  {
		 perror( ft );
		 return -2;
	  }
	  for( i = 0; i < ptr_li; i++ )
      {
		 /* */
		 if ( !list_obj[ i ] )
         {
            chext( list_obj[ i ], list_input[ i ] );
            ptr_lo++;
         }
		 sprintf( cmd_gcc, "-I%s/include %s %s -c %s -o %s", ke, opgcc1, opgcc2, list_input[ i ], list_obj[ i ] );
         /* */
         fprintf( fp, "%s\n", cmd_gcc );
         fflush( fp );
         fclose( fp );
		 /* */
		 sprintf( cmd_gcc, "gcc.exe @%s", ft );
         /* */
         r = system( cmd_gcc );
         /* */
		 remove( ft );
         /* */
		 if ( r )
         {
            exit( -17 );
         }
      }
   }
   /* */
   if ( !generar_dll )
   {
      return 0;
   }
   /* */
   memset( &DynHead, 0, sizeof( TDynLdHeader ) );
   DynHead.Magic = ULONG_ID( 'D', 'n', 'L', 'd' );
   DynHead.FileFormatVersion = DYNLDVERSION;
   DynHead.Importations = 0;
   DynHead.Time = time( 0 );
   DynHead.MainOffset = NoneOffset;
   DynHead.CloseOffset = NoneOffset;
   DynHead.LibsOffset = NoneOffset;
   //
   in = fopen( list_obj[ 0 ], "rb" );
   if ( !in )
   {
	  printf( "/!\\ Error: Input file do not exists.\n" );
	  return 1;
   }
   fread( &CoffHead, 1, FILHSZ, in );
   if ( CoffHead.f_nscns != 1 || argc > 3 ) // Multiple sections... Call LD to make a common one
   {
	  fclose( in );
	  sprintf( ft, "%s/dynld.ld", getenv( "TEMP" ) );
	  if ( !( sc = fopen( ft, "rt" ) ) )
	  {
		 sc = fopen( ft, "wt" );
		 if ( sc )
		 {
			fprintf( sc , "OUTPUT_FORMAT(\"coff-go32\")\n\nFORCE_COMMON_ALLOCATION\n\nSECTIONS {\n  .text : {\n\t*(.text)\n\t*(.data)\n\t*(.bss)\n\t*(COMMON)\n  }\n}\n" );
			fclose( sc );
			if ( verbose )
			   printf( "(i) Script - dynld.ld - generated.\n" );
		 }
		 else
		 {
			printf( "/!\\ Error : Unable to generate dynld.ld script\n" );
			return 1;
		 }
	  }
	  else
		 fclose( sc );
	  strcpy( Cmd, "ld -X -A i386 -d -EL -Ur --sort-common -q -r -o _tmp.o " ); //"ld -X -r -o _tmp.o " );
	  for( i = 0; i < ptr_lo; i++ )
	  {
		 strcat( Cmd, list_obj[ i ] );
		 strcat( Cmd, " " );
	  }
	  strcat( Cmd, " -T " );
	  strcat( Cmd, ft );
	  if ( verbose )
		 printf( "(i) Calling LD (linker)\n" );
	  // -S skipped as LD crash
	  if ( system( Cmd ) )
	  {
		 printf( "/!\\ Error : LD have not return correct code...\n" );
		 return 1;
	  }
	  in = fopen( "_tmp.o", "rb" );
	  if ( !in )
	  {
		 printf( "/!\\ Error: Temporary file do not exists.\n" );
		 return 1;
	  }
	  fread( &CoffHead, 1, FILHSZ, in );
   }
//   printf("Generando %s ",name_dll);
   out = fopen( name_dll, "wb+" );
   if ( !out )
   {
	  printf( "/!\\ Error: Unable to open output file.\n" );
	  return 1;
   }
   for(i=0;i<LEN_NODOS;i++)
	  fputc(NODOS[i],out);
   fprintf(out,"__WinDosExecutableFile__");
   // Load Coff Sections
   fseek( in, CoffHead.f_opthdr, SEEK_CUR );
   CoffSections = ( SCNHDR * ) malloc( SCNHSZ*CoffHead.f_nscns );
   fread( CoffSections, CoffHead.f_nscns, SCNHSZ, in );
   // Load Coff Data
   DynHead.Size = CoffSections[ 0 ].s_paddr+CoffSections[ 0 ].s_size;
   DynData = ( void* )malloc( DynHead.Size );
   memset( DynData, 0, DynHead.Size );
   fseek( in, CoffSections[ 0 ].s_scnptr, SEEK_SET );
   fread( DynData, 1, CoffSections[ 0 ].s_size, in );
   // Load Coff Symbols
   fseek( in, CoffHead.f_symptr, SEEK_SET );
   CoffSymbols = ( SYMENT * ) malloc( SYMESZ*CoffHead.f_nsyms );
   fread( CoffSymbols, CoffHead.f_nsyms, SYMESZ, in );
   // Load Coff Strings
   fread( &CoffStringsSize, 1, 4, in );
   CoffStrings = ( char * ) malloc( CoffStringsSize-4 );
   memset( CoffStrings, 0, 4 );
   fread( CoffStrings+4, 1, CoffStringsSize-4, in );
   // Load Coff Relocations
   fseek( in, CoffSections[ 0 ].s_relptr, SEEK_SET );
   CoffRelocsSize = RELSZ*CoffSections[ 0 ].s_nreloc;
   CoffRelocs = malloc( CoffRelocsSize );
   fread( CoffRelocs, 1, CoffRelocsSize, in );
   // Write DynHeader
   fwrite( &DynHead, 1, sizeof( TDynLdHeader ), out );
   // Look for Key Data
   for ( i=0;i<CoffHead.f_nsyms;i++ )
   {
	  char *name, nam8[ 9 ];
	  if ( CoffSymbols[ i ].e.e.e_zeroes )
	  {
		 memcpy( nam8, CoffSymbols[ i ].e.e_name, 8 );
		 nam8[ 8 ] = 0;
		 name = nam8;
	  }
	  else
		 name = CoffStrings+CoffSymbols[ i ].e.e.e_offset;
	  //printf( "  %d : 0x%06x : %s\n", i, CoffSymbols[ i ].e_value, name );
	  if ( name[ 0 ] != '.' /*&& CoffSymbols[ i ].e_value*/ )
	  {
		 if ( !strcmp( name+1, "LibMain" ) ) DynHead.MainOffset = CoffSymbols[ i ].e_value;
			if ( !strcmp( name+1, "Main" ) )
		 {
			DynHead.Type = DYNLD_TYPEAPP;
			DynHead.MainOffset = CoffSymbols[ i ].e_value;
			if ( verbose )
			   printf( "Threading App\n" );
		 }
		 if ( !strcmp( name+1, "nUID" ) )
			memcpy( &DynHead.UID, DynData+CoffSymbols[ i ].e_value, 12 );
		 if ( !strcmp( name+1, "AppName" ) )
			DynName = ( char* )DynData+CoffSymbols[ i ].e_value;
		 if ( !strcmp( name+1, "Close" ) )
			DynHead.CloseOffset = CoffSymbols[ i ].e_value;
		 if ( !strcmp( name+1, "NeededLibs" ) )
			DynHead.LibsOffset = CoffSymbols[ i ].e_value;
		 if ( !strcmp( name+1, "AppVersion" ) )
			memcpy( &DynHead.FileVersion, DynData+CoffSymbols[ i ].e_value, 4 );
		 //printf( "  %d : 0x%06x : %s\n", i, CoffSymbols[ i ].e_value, name+1 );
	  }
	  i += CoffSymbols[ i ].e_numaux;
   }
   if ( DynHead.MainOffset == NoneOffset && verbose )
   {
	  printf( "\nWARNING : No Main() is defined.\n" );
	  printf( "Example :\n" );
	  printf( "#include\"kernel.h\"\n" );
	  printf( "l_bool Main ( int argc, l_text *argv ) {\n" );
	  printf( "  return true;\n" );
	  printf( "}\n" );
   }
   if ( DynHead.CloseOffset == NoneOffset && DynHead.Type != DYNLD_TYPEAPP && verbose )
   {
	  printf( "\nWARNING : No Close() is defined.\n" );
	  printf( "Example :\n" );
	  printf( "#include\"kernel.h\"\n" );
	  printf( "void Close ( void ) {\n" );
	  printf( "}\n" );
   }
   //Write Application name to file
   WriteString( out, DynName );
   // Precalculate relocations
   for ( i=0;i<CoffSections[ 0 ].s_nreloc;i++ )
   {
	  if ( CoffRelocs[ i ].r_type == RELOC_REL32 && !CoffSymbols[ CoffRelocs[ i ].r_symndx ].e_scnum )
	  {
		 *( long* )( ( ( ( ( long )DynData ) )+CoffRelocs[ i ].r_vaddr ) ) += CoffRelocs[ i ].r_vaddr;
	  }
   }
   //Write Data to File ( after haeder and informations text )
   if ( Compress )
   {
	  void *Temp;
	  //
	  DynHead.Compression = 0x01;
	  DynHead.OriginalSize = DynHead.Size;
	  DynHead.Size = DynHead.OriginalSize+DynHead.OriginalSize/5+12;
	  Temp = ( void* )malloc( DynHead.Size );
	  compress( Temp, &DynHead.Size, DynData, DynHead.OriginalSize );
	  fwrite( Temp, 1, DynHead.Size, out );
	  free( Temp );
   }
   else
   {
	  fwrite( DynData, 1, DynHead.Size, out );
   }
   // Write Inportaions
   for ( i=0;i<CoffHead.f_nsyms;i++ )
   {
	  char *name, nam8[ 9 ];
	  //
	  if ( CoffSymbols[ i ].e.e.e_zeroes )
	  {
		 memcpy( nam8, CoffSymbols[ i ].e.e_name, 8 );
		 nam8[ 8 ] = 0;
		 name = nam8;
	  }
	  else
		 name = CoffStrings+CoffSymbols[ i ].e.e.e_offset;
	  if ( name[ 0 ] != '.' && !CoffSymbols[ i ].e_scnum )
	  {
		 WriteString( out, name+1 );
		 fwrite( &i, 1, 4, out );
		 DynHead.Importations++;
	  }
	  i += CoffSymbols[ i ].e_numaux;
   }
   for ( i=0;i<CoffSections[ 0 ].s_nreloc;i++ )
   {
	  if ( CoffRelocs[ i ].r_type == RELOC_ADDR32 || !CoffSymbols[ CoffRelocs[ i ].r_symndx ].e_scnum )
	  {
		 if ( CoffRelocs[ i ].r_type == RELOC_ADDR32 )
			DynReloc.Type = REL32_ABSOLUTE;
		 else
			DynReloc.Type = REL32_RELATIVE;
		 DynReloc.Address = CoffRelocs[ i ].r_vaddr;
		 DynReloc.Symbol = CoffRelocs[ i ].r_symndx;
		 fwrite( &DynReloc, 1, sizeof( TDynLdReloc ), out );
		 DynHead.Relocations++;
	  }
   }
   fgetpos( out, &( DynHead.RessourceOffset ) );
   if ( RessourceFile )
   {
	  FILE *r = fopen( RessourceFile, "rb" );
	  //
	  if ( r )
	  {
		 TResHead Head;
		 unsigned long Entries;
		 TResEntrie E;
		 void *buffer;
		 //
		 fread( &Head, sizeof( TResHead ), 1, r );
		 if ( Head.Magic == ULONG_ID( 'D', 'M', 'S', 'R' ) )
		 {
			if ( Head.FormatVersion == ULONG_ID( 0, 0, 0, 1 ) )
			{
			   Entries = Head.Entries;
			   while ( Entries )
			   {
				  fread( &E, sizeof( TResEntrie ), 1, r );
				  fwrite( &E, sizeof( TResEntrie ), 1, out );
				  buffer = malloc( E.DataSize );
				  fread( buffer, E.DataSize, 1, r );
				  fwrite( buffer, E.DataSize, 1, out );
				  Entries--;
			   }
			   DynHead.RessourceEntries = Head.Entries;
			}
		 }
		 fclose( r );
	  }
   }
   //
   textcolor( LIGHTGREEN );
   if ( verbose )
   {
	  cprintf( "\n\rApplication Informations\n\r" );
	  cprintf( "UID : '%s' Name : '%s' Version : %lu.%lu.%lu.%lu", ( char* )&DynHead.UID, DynName, ULID_A( DynHead.FileVersion ), ULID_B( DynHead.FileVersion ), ULID_C( DynHead.FileVersion ), ULID_D( DynHead.FileVersion ) );
	  if ( Compress )
		 cprintf( "\n\rCompreession : %lu %%", DynHead.OriginalSize*100/DynHead.Size );
	  //
	  if ( DynHead.RessourceEntries )
		 cprintf( "\n\rRessource   : %lu Entrie(s)", DynHead.RessourceEntries );
   }
   else
   {
	  cprintf( "'%s' Version %lu.%lu.%lu.%lu", DynName, ULID_A( DynHead.FileVersion ), ULID_B( DynHead.FileVersion ), ULID_C( DynHead.FileVersion ), ULID_D( DynHead.FileVersion ) );
   }
   textcolor( LIGHTGRAY );
   cprintf("\n\r");
   //
   fseek( out, LEN_NODOS+24, SEEK_SET );
   fwrite( &DynHead, 1, sizeof( TDynLdHeader ), out );
   free( CoffStrings );
   free( CoffSymbols );
   free( CoffSections );
   free( CoffRelocs );
   free( DynData );
   fclose( in );
   fclose( out );
   remove( "_tmp.o" );
   //
   return 0;
}


