// Associated include file : Graphics/Zone.H

#include "common/common.h"
#include "drivers/drivers.h"
#include "mecanism/mecanism.h"
#include "graphics/grx.h"
#include "graphics/scrzone.h"
#include "graphics/fontsys.h"
#include "graphics/colors.h"
#include "graphics/zone.h"

short     RegTZone;
char     *IdentTZone = "TZone";
TRect     NoClip;
TZone    *MouseActiveZone;
char   	 CurrentMouseAspect;
char      OldMouseAspect;
GrCursor *CurMouse[7];

DEFINE(TZone);

DEFINE_EVENTS_TABLE(TZone,TObject)
  MOUSETEST()
END_EVENTS_TABLE

// Constructors

TZone::TZone()
{ Defaults();
}

TZone::TZone(int X, int Y, int L, int H)
{ Defaults();
  Init(X,Y,L,H);
}

TZone::TZone(TRect R)
{ Defaults();
  Init(R.X1(),R.Y1(),R.Width(),R.Height());
}

void TZone::Defaults(void)
{ // Object identification
  Register=RegTZone;
  Ident=IdentTZone;
  // Other variables default values
  DrawStatus=0;
  Color=ColorAddition=0;
  SetStatus(sfVisible);
  MouseAspect=MouseCursorArrow;
  Clipping=NULL;
  ClipSons=NULL;
  // Give the Rect a dummy value in order to avoid
  // problems that could occurs with an undefined size
  Where=TRect(0,0,100,100);
  Inside=TRect(0,0,100,100);
}

void TZone::Init(int X, int Y, int L, int H)
{ // Herited creations
  TObject::Init();
  // New Creations
  Where=TRect(X,Y,X+L-1,Y+H-1);
  Inside=Where-Where.P1();
  ResetClip();
  Clipping->Insert(new TScreenZone(Inside));
  ClipSons->Insert(new TScreenZone(Inside));
}

void TZone::Done(void)
{ if (MouseActiveZone==this) MouseActiveZone=NULL;
  // Herited Destructions
  TObject::Done();
  // New destructions
  delete Clipping;
  delete ClipSons;
}

void TZone::InitAfterInsert(void)
{ }

// Graphical methods

void TZone::MakeGlobal(TPoint Src, TPoint& Dest)
{ TZone *Z=Father();
  if (Z!=NULL)
  { Z->MakeGlobal(Src,Dest);
    Dest+=Z->Where.P1();
  }
}

void TZone::MakeLocal(TPoint Src, TPoint& Dest)
{ TZone *Z=Father();
  if (Z!=NULL)
  { Z->MakeLocal(Src,Dest);
    Dest-=Z->Where.P1();
  }
}

void TZone::DrawBegin(void)
{ if (!DrawStatus)
  { MakeGlobal(Where.P1(),Corner);
    // MouseClipON();
  }
  DrawStatus++;
}

void TZone::DrawEnd(void)
{ DrawStatus--;
  if (!DrawStatus)
  { // MouseClipOFF();
  }
}

void TZone::Invalidate(TRect What)
{ if (Father()!=NULL)
    Father()->Invalidate(What+Where.P1());
}

void TZone::Invalidate(int X1, int Y1, int X2, int Y2)
{ Invalidate(TRect(X1,Y1,X2,Y2));
}

void TZone::Invalidate()
{ Invalidate(TRect(0,0,Where.Width()-1,Where.Height()-1));
}


void TZone::ShowDrawingNow(void)
{ if (Father()!=NULL)
    Father()->ShowDrawingNow();
}

void TZone::DoDraw(TRect Clip)
{ if (GetStatus(sfVisible))
  { DrawBegin();
    TScreenZone *SZ;
    TRect        W;
    // 1. Lui-meme
    //    Avant ses fils pour pouvoir tracer un fond dans le pere
    //    et voir quand meme les fils (exemple avec TTitleBar et
    //    ses fils TCloseBox...).
    SZ=ClipSons->Son();
    while(SZ!=NULL)
    { W=SZ->Where-Clip;
      if (!W.Empty())
      { // L'intersection entre la zone  tracer et cet objet
        // est non-vide. On le retrace donc.
        GrSetClipBox(W.X1()+Corner.X(),W.Y1()+Corner.Y(),
                     W.X2()+Corner.X(),W.Y2()+Corner.Y());
        Draw(W);
      }
      SZ=SZ->Next();
    }
    // 2. Ses fils
    SZ=Clipping->Son();
    while(SZ!=NULL)
    { W=SZ->Where-Clip;
      if (!W.Empty())
      { TZone *Z=Son();
        TRect  WSon;
        while(Z!=NULL)
        { WSon=W-(Z->Where.P1());
          Z->DoDraw(WSon);
          Z=Z->Next();
        }
      }
      SZ=SZ->Next();
    }
    DrawEnd();
  }
}

void TZone::Draw(TRect )
{ }

void TZone::BecomeActiveZone(void)
{ if (MouseAspect!=CurrentMouseAspect)
	  ChangeMouseAspect(MouseActiveZone->MouseAspect);
}

void TZone::LeaveActiveZone(void)
{ }

void TZone::PutPixel(int X, int Y)
{ GrPlot(X+Corner.X(),Y+Corner.Y(),Color+ColorAddition);
}

void TZone::Bar(int X1, int Y1, int X2, int Y2)
{ GrFilledBox(X1+Corner.X(),Y1+Corner.Y(),X2+Corner.X(),Y2+Corner.Y(),Color+ColorAddition);
}

void TZone::Rectangle(int X1, int Y1, int X2, int Y2)
{ GrBox(X1+Corner.X(),Y1+Corner.Y(),X2+Corner.X(),Y2+Corner.Y(),Color+ColorAddition);
}

void TZone::LineX(int X1, int Y1, int X2)
{ GrHLine(X1+Corner.X(),X2+Corner.X(),Y1+Corner.Y(),Color+ColorAddition);
}

void TZone::LineY(int X1, int Y1, int Y2)
{ GrVLine(X1+Corner.X(),Y1+Corner.Y(),Y2+Corner.Y(),Color+ColorAddition);
}

void TZone::Line(int X1, int Y1, int X2, int Y2)
{ GrLine(X1+Corner.X(),Y1+Corner.Y(),X2+Corner.X(),Y2+Corner.Y(),Color+ColorAddition);
}

int TZone::Frame3D(int Down)
{ return Frame3D(Down,0,0,Where.Width()-1,Where.Height()-1);
}

int TZone::Frame3D(int Down, int X1, int Y1, int X2, int Y2)
{ char c1,c2,c3,c4;
  int  D;
  if ( Down )
  { c1=DarkGray;
    c2=Black;
    c3=FaceGray;
    c4=LightGray;
    D=1;
  }
  else
  { c1=LightGray;
    c2=FaceGray;
    c3=DarkGray;
    c4=Black;
    D=0;
  }
  SetSysColor(c1);          LineX(X1,Y1,X2-1);     LineY(X1,Y1+1,Y2-1);
  SetSysColor(c2);          LineX(X1+1,Y1+1,X2-2); LineY(X1+1,Y1+2,Y2-2);
  SetSysColor(c3);          LineX(X1+1,Y2-1,X2-1); LineY(X2-1,Y1+1,Y2-2);
  SetSysColor(c4);          LineX(X1,Y2,X2);       LineY(X2,Y1,Y2-1);
  return D;
}

void TZone::PutStr(int X, int Y, char *Text, TFont *Font)
{ Font->PutStr(X+Corner.X(),Y+Corner.Y(),Text,Color+ColorAddition);
}

void TZone::PutChar(int X, int Y, char Ch, TFont *Font)
{ Font->PutChar(X+Corner.X(),Y+Corner.Y(),Ch,Color+ColorAddition);
}

void TZone::PutSysStr(int X, int Y, char *Text, TFont *Font)
{ Font->PutSysStr(X+Corner.X(),Y+Corner.Y(),Text,Color+ColorAddition);
}

void TZone::SetSysColor(int C)
{ if ((C>=0)&&(C<=4))
    Color=NoSysColor[C];
}

void TZone::SetColor(int C)
{ Color=C;
}

void TZone::SetWriteMode(int WM)
{ switch(WM)
  { case wmREPLACE : ColorAddition=0;     break;
    case wmXOR     : ColorAddition=GrXOR; break;
    case wmOR      : ColorAddition=GrOR;  break;
    case wmAND     : ColorAddition=GrAND; break;
  }
}

// Manipulations diverses

void TZone::ShrinkInside(TRect& )
{ }

void TZone::Insert(TAtom *A)
{ // Insertion
  TObject::Insert(A);
  // Ajuste les tailles
  ((TZone*)A)->ShrinkInside(Inside);
  // Ajuste le Clip
  CalculateClip();
}

void TZone::UnLink(void)
{ TZone *F=Father();
  if (F!=NULL)
  { TObject::UnLink();
    F->CalculateClip();
    F->Invalidate(Where);
  }
}

// Flux d'objets

void TZone::Read(TDisk *file)
{ TObject::Read(file);
  Where.Read(file);
  Inside.Read(file);
}

void TZone::Write(TDisk *file)
{ TObject::Write(file);
  Where.Write(file);
  Inside.Write(file);
}

// Gestion des vnements

boolean TZone::MouseTest(TPoint W, int )
{ TPoint P;
  MakeLocal(W,P);
  if (GetStatus(sfMouseIn))
  { // Si la souris est dj dedans
    if ((P.X()<Where.X1()) || (P.X()>Where.X2()) ||
        (P.Y()<Where.Y1()) || (P.Y()>Where.Y2())) ClearStatus(sfMouseIn);
  }
  else
  { // Si la souris tait en dehors
    if ((P.X()>=Where.X1()) && (P.X()<=Where.X2()) &&
        (P.Y()>=Where.Y1()) && (P.Y()<=Where.Y2())) SetStatus(sfMouseIn);
  }
  MakeGlobal(Where.P1(),P);
  if (GetStatus(sfMouseIn))
    if (MouseActiveZone==NULL) MouseActiveZone=this;
  return FALSE;
}

void TZone::DoChangeSize(int dX, int dY)
{ TZone *Z;
  if (GetOptions(opCSLoX)) Where.X1()+=dX;
  if (GetOptions(opCSLoY)) Where.Y1()+=dY;
  if (GetOptions(opCSHiX)) Where.X2()+=dX;
  if (GetOptions(opCSHiY)) Where.Y2()+=dY;
  SizeChanged();
  Z=Son();
  while(Z!=NULL)
  { Z->DoChangeSize(dX,dY);
    Z=Z->Next();
  }
  // La position des fils a pu changer. -> update le clipping
  CalculateClip();
}

void TZone::SizeChanged(void)
{ }

void TZone::ResetClip(void)
{ if (Clipping!=NULL) delete Clipping;
  Clipping=new TScreenZone();
  if (ClipSons!=NULL) delete ClipSons;
  ClipSons=new TScreenZone();
}

void TZone::CalculateClip(void)
{ TZone *Z;
  TRect  R;
  ResetClip();
  // Gnre le rectangle de dpart qui couvre toute la zone
  Clipping->Insert(new TScreenZone(Where-Where.P1()));
  ClipSons->Insert(new TScreenZone(Where-Where.P1()));
  // Clip ce rectangle avec touts les enfants qui couvrent
  Z=Son();
  while(Z!=NULL)
  { if (Z->GetStatus(sfVisible))
    { // Clip avec cet enfant
      Z->GetClipRect(R);
      ClipWithRect(ClipSons,R);
    }
    // Zone suivante
    Z=Z->Next();
  }
}

void TZone::ClipWithRect(TScreenZone *Clip, TRect R)
{ TScreenZone *SZ, *SZn;
  // Coupe tous les rectangles selon le masquage par Z
  SZ=Clip->Son();
  while(SZ!=NULL)
  { SZn=SZ->Next();
    // On Clippe ici SZ->Where par Z->Where
    Clip->Clip(SZ,R);
    //
    SZ=SZn;
  }
  // Regroupe les Zones de Clip qui peuvent tre regroupes
  Clip->RegroupZones();
}

void TZone::GetClipRect(TRect& R)
{ R=Where;
}

// --- Functions

void ChangeMouseAspect(int MouseAspect)
{ if ((MouseAspect>=0)&&(MouseAspect<7))
  { GrMouseEraseCursor();
    GrMouseSetCursor(CurMouse[MouseAspect]);
    GrMouseDisplayCursor();
    OldMouseAspect=CurrentMouseAspect;
    CurrentMouseAspect=MouseAspect;
  }
}

void RestoreMouseAspect(void)
{ ChangeMouseAspect(OldMouseAspect);
}