// Associated include file : Graphics/IntLift.H

#include "common/common.h"
#include "drivers/drivers.h"
#include "mecanism/mecanism.h"
#include "graphics/graphics.h"
#include "gadgets/gadgets.h"

// --- TIntLiftLift

// --- TIntegerLift  object

DEFINE(TIntegerLift);

DEFINE_EVENTS_TABLE(TIntegerLift,TZone)
  COMMAND(cmIntegerLiftUp,  doIntegerLiftUp)
  COMMAND(cmIntegerLiftDown,doIntegerLiftDown)
END_EVENTS_TABLE

short RegTIntegerLift;
char *IdentTIntegerLift = "TIntegerLift";

TIntegerLift::TIntegerLift()
{ Defaults();
}

TIntegerLift::TIntegerLift(TEditInteger *_Edit, long _Min, long _Max)
{ Defaults();
  Init(_Edit,_Min,_Max);
}

void TIntegerLift::Defaults(void)
{ // Object identification
  Register=RegTIntegerLift;
  Ident=IdentTIntegerLift;
  // Other default values
  SetOptions(opGetAllEvents);
}

void TIntegerLift::Init(TEditInteger *_Edit, long _Min, long _Max)
{ Edit=_Edit;
  Min=_Min;
  Max=_Max;
  // Herited creations
  TZone::Init(Edit->Where.X2()+2,Edit->Where.Y1(),10,22);
  // New creations
  Insert(Up=new TStdButton(0,0,10,9,cmIntegerLiftUp,0,boImmediate | boRepetition,NULL,new TSysIcone(5,4,ICO_SmallUpArrow)));
  Insert(new TButton(0,9 ,10,4,0/*cm*/,0/*Scan*/,0/*Opts*/));
  Insert(Down=new TStdButton(0,13,10,9,cmIntegerLiftDown,0,boImmediate | boRepetition,NULL,new TSysIcone(5,4,ICO_SmallDownArrow)));
}

//

boolean TIntegerLift::doIntegerLiftUp(void)
{ long Tmp;
  if (CurrentEvent.InfoPtr==Up)
  { // Get current number
    sscanf(Edit->Text,"%ld",&Tmp);
    // Change the number
    Tmp++;
    if (Min!=Max)
    { // perform interval tests
      if (Tmp>Max) Tmp=Max;
    }
    // Set new number
    sprintf(Edit->Text,"%ld",Tmp);
    Edit->TextChanged();
    Edit->Modified();
    return TRUE;
  }
  return FALSE;
}

boolean TIntegerLift::doIntegerLiftDown(void)
{ long Tmp;
  if (CurrentEvent.InfoPtr==Down)
  { // Get current number
    sscanf(Edit->Text,"%ld",&Tmp);
    // Change the number
    Tmp--;
    if (Min!=Max)
    { // perform interval tests
      if (Tmp<Min) Tmp=Min;
    }
    // Set new number
    sprintf(Edit->Text,"%ld",Tmp);
    Edit->TextChanged();
    Edit->Modified();
    return TRUE;
  }
  return FALSE;
}