/* --------------------------------------------------------------------------
        Project S.W.O.R.D
        V2.10

        SubSystem : Demonstration
        Commands  : Group: 10000
        File      : Image/Image.CC
        Author    : Eric NICOLAS
        Overview  : Image Viewer demo program
        UpDate    : Apr 14, 1996

** Copyright (C) 1993-1996 Eric NICOLAS
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
** ------------------------------------------------------------------------*/

#include "sword.H"
#include "ToolBox/image/image.h"

#ifdef __TURBOC__
  #error This demo program will not work with TurboC because of memory limitations
#endif


// ==== DIALOG DATAS =========================================================

struct TMyDialogData
{ int  Checks     PACKED;
  int  Radios     PACKED;
  char String[61] PACKED;
};

static TMyDialogData MyDialogData;
static long          MyDialogResult;


// ----- Hello - Window

TFont *BigFont=NULL;
int    HelloCounter=1;

// ==== HELLO WINDOW OBJECT ==================================================

// This objet draw the inside of the Hello Window, show a uniform light gray
// background, with a big HELLO text

// Declarations

char *IdentTHello = "THello";
short RegTHello;

class THello : public TZone
{ DECLARE(THello);
  // --- Functions
  // Public constructors
                         THello(void);
          THello(int X, int Y, int L, int H);
          THello(TRect& R);
  // Construction / Destruction
          void Defaults(void);
          void Init(int X, int Y, int L, int H);
  // Drawings
  virtual void Draw(TRect Clip);
};

// THello object code

DEFINE(THello)

THello::THello(void)
{ Defaults();
}

THello::THello(int X, int Y, int L, int H)
{ Defaults();
  Init(X,Y,L,H);
}

THello::THello(TRect& R)
{ Defaults();
  Init(R.X1(),R.Y1(),R.Width(),R.Height());
}

void THello::Defaults(void)
{ // Object Identification
  Register=RegTHello;
  Ident=IdentTHello;
  // Other default values
  // Tell the object that it must grow with its parent window
  SetOptions(opCSHiX | opCSHiY);
}

void THello::Init(int X, int Y, int L, int H)
{ // Derived constructions
  TZone::Init(X,Y,L,H);
  // New constructions
  // ...
}

void THello::Draw(TRect )
{ // Select the FaceGray color and draw the background
  SetSysColor(FaceGray);
  Bar(0,0,Where.Width()-1,Where.Height()-1);
  // Select the black color and draw the text
  SetSysColor(Black);
  PutStr(20,20,"Hello World !",BigFont);
  PutStr(20,60,"S. W. O. R. D.",BigFont);
}



// --- Define commands IDs for the menu

#define cmReadJPEG  10000
#define cmReadGIF   10001
#define cmReadBMP   10002
#define cmReadTGA   10003
#define cmReadPPM   10004
#define cmScreenShot 10005
#define cmHelloWindow 10006
#define cmDialogTest 10007

// --- Application object

class TMyApp : public TApp
{ DECLARE(TMyApp);
  DECLARE_EVENTS_TABLE;
  // --- Functions
  public:
  // Public Constructors
            TMyApp(void);
            TMyApp(char *argv0);
  // Overridables
    virtual void      CreateMenuChoices(TMenu *Menu);
    virtual TDesktop *DesktopCreation(void);
    virtual boolean CanClose(void);
  // Handling menu messages
            boolean   doReadJPEG(void);
            boolean   doReadGIF(void);
            boolean   doReadBMP(void);
            boolean   doReadTGA(void);
            boolean   doReadPPM(void);
            boolean   doScrShot(void);
            boolean   doHelloWindow(void);
            boolean   doDialogTest(void);
            void      CreateImageViewer(char *FileName);
};

DEFINE(TMyApp)

DEFINE_EVENTS_TABLE(TMyApp,TApp)
  COMMAND(cmReadJPEG, doReadJPEG)
  COMMAND(cmReadGIF,  doReadGIF)
  COMMAND(cmReadBMP,  doReadBMP)
  COMMAND(cmReadTGA,  doReadTGA)
  COMMAND(cmReadPPM,  doReadPPM)
  COMMAND(cmScreenShot, doScrShot)
  COMMAND(cmHelloWindow, doHelloWindow)
  COMMAND(cmDialogTest,doDialogTest)
END_EVENTS_TABLE

TMyApp::TMyApp(void)
{ Defaults();
}

TMyApp::TMyApp(char *argv0)
{ Defaults();
  Init(argv0);

  // Register THello object
  RegisterObject(new THello(), &RegTHello);
  // Initialize global vars
  BigFont=new TFont("TMS38");
}

boolean TMyApp::doDialogTest(void)
{ TDialog *Dialog;
  TGroupBox *GB;
  int       dX,dY;
  // Build TDialog object
  // Size is 270x278, compute position to center it on the screen
  dX=(GrMaxX()-270)/2;
  dY=(GrMaxY()-278)/2;
  Dialog=new TDialog(dX,dY,270,278,"Dialog sample");
  // Insert controls in the dialog
  // :: One "Other Button" button, disabled for interactions
  Dialog->Insert(new TStdButton(10,30,80,23,0,0,boDisabled,"Other"));
  // :: One Cancel Button
  Dialog->Insert(new TCancelButton(95,30));
  // :: One OK button
  Dialog->Insert(new TOKButton(180,30));
  // :: One Static text
  Dialog->Insert(new TStaticText(10,60,250,20,"Sample application from SWORD package"));
  // :: Check boxes
  GB=new TGroupBox(10,85,250,65);
  GB->Insert(new TCheckBox(10,15,100, boNoCase, 1, "Check Box &A"));
  GB->Insert(new TCheckBox(10,40,100, boNoCase, 2, "Check Box &B"));
  Dialog->Insert(GB);
  // :: Radio buttons
  GB=new TGroupBox(10,160,250,80,"Radio buttons group");
  GB->Insert(new TRadioBox(10, 25,100, boNoCase, 1, "Radio &C"));
  GB->Insert(new TRadioBox(120,25,100, boNoCase | boDisabled, 2, "Radio &D"));
  GB->Insert(new TRadioBox(10, 50,100, boNoCase, 3, "Radio &E"));
  GB->Insert(new TRadioBox(120,50,100, boNoCase, 4, "Radio &F"));
  Dialog->Insert(GB);
  // :: Edit Line
  Dialog->Insert(new TEditLine(10,245,250,60,10));
  // Execute the dialog

  MyDialogResult=ExecDialog(Dialog,&MyDialogData);
  return TRUE;
}


boolean TMyApp::doHelloWindow(void)
{ // Create a title with the window number within
  // Rq: this can be a local var because the stdwindow object
  //     will keep a copy of the title
  char Title[20];
  sprintf(Title,"Hello Word #%d !",HelloCounter);
  // Create the window
  TWindow *Window=new TStdWindow(100,100,300,300,Title,
                                 opWinSizeable | opWinCloseBox |
                                 opWinMinimizeBox | opWinMaximizeBox );
  // Insert the "Hello" viewer inside the window
  Window->Insert(new THello(Window->Inside));
  // Insert the window in the desktop (show the window)
  Desktop->Insert(Window);
  // Get ready for the next hello window
  HelloCounter++;
  return TRUE;
}


void TMyApp::CreateMenuChoices(TMenu *Menu)
{ TMenu *MenuImage;
  // Create Sub Menu "Open Image"
  MenuImage=new TMenu("Open Image");
    MenuImage->Insert(new TMenuChoice("&JPEG test image",0,cmReadJPEG));
    MenuImage->Insert(new TMenuChoice("&GIF test image",0,cmReadGIF));
    MenuImage->Insert(new TMenuChoice("&BMP test image",0,cmReadBMP));
    MenuImage->Insert(new TMenuChoice("&TGA test image",0,cmReadTGA));
    MenuImage->Insert(new TMenuChoice("&PPM test image",0,cmReadPPM));
    MenuImage->Insert(new TMenuChoice("&Screenshot",0,cmScreenShot));


  // Create Menu Choices for Main Menu
  Menu->Insert(new TMenuChoice("&Open Image",MenuImage));
  Menu->Insert(new TMenuChoice("&Edition",0,10,sfDisabled));
  Menu->Insert(new TMenuChoice());
  Menu->Insert(new TMenuChoice("&Quit",ScanAltQ,cmQuit));
  Menu->Insert(new TMenuChoice("&Hello Window",0,cmHelloWindow));
  Menu->Insert(new TMenuChoice("&Test dialog",0,cmDialogTest));
}

boolean TMyApp::CanClose(void)
{ if (MessageBox("Confirmation","Are you sure that you want to quit",
                                          "Mandelbrot fractal viewer program from SWORD package ?",
                                          mbYes | mbNo)==cmYes) return TRUE;
  else return FALSE;
}


void TMyApp::CreateImageViewer(char *FileName)
{ // Create the TImage object, and then load the image from disk
  TImage *Image=new TImage(0,0);
  Image->Load(FileName);
  if (Error)
  {
    delete Image;
    return;
  }
  // Create the ImageViewer object to see the image
  Desktop->Insert(new TImageViewer(100,100,400,400,"Image Viewer",Image));
}

TDesktop *TMyApp::DesktopCreation(void)
{ char      FName[50];
  TDesktop *D;
  // Get the screen resolution and compute the name of
  // the image to load as the desktop background
  sprintf(FName,"backgrds/bkg_%d.jpg",GrMaxX()+1);
  // Create the desktop with image
  D=new TBkgDesktop(FName);
  if (Error) FatalError();
  return D;
}

boolean TMyApp::doReadJPEG(void)
{ CreateImageViewer("Images/Image.JPG");
  return TRUE;
}

boolean TMyApp::doReadGIF(void)
{ CreateImageViewer("Images/Kenya.GIF");
  BeginPhase("test");
  return TRUE;
}

boolean TMyApp::doReadBMP(void)
{ CreateImageViewer("Images/A029.BMP");
  return TRUE;
}


boolean TMyApp::doScrShot(void)
{
  signed int error=0;
  error = GrSaveContextToPpm( GrScreenContext(), "scrshot.ppm", NULL);
  if (!error)
     MessageBox("Confirmation","Screenshot is taken!",
                                          "Look into the home directory.",
                                          mbOK);
  else
     MessageBox("Confirmation","Screenshot is NOT taken!",
                                          " ",
                                          mbOK);

  return TRUE;
}


boolean TMyApp::doReadTGA(void)
{ CreateImageViewer("Images/Drums.TGA");
  return TRUE;
}

boolean TMyApp::doReadPPM(void)
{ CreateImageViewer("Images/Myst4.PPM");
  return TRUE;
}

// ==== Main Program

int main(char , char *argv[])
{ TMyApp *MyApp;

  // Application identification
  ShortVersion="Image";
  LongVersion ="Image Sample. Copyright (C) 1993-1996 The SWORD Group";

  // Initialize default values for dialog's controls
  MyDialogData.Checks=1;     // Check box A is checked
  MyDialogData.Radios=3;     // Radio button E is actived
  strcpy(MyDialogData.String,"Sample text edit");


  // Create, run and destroy the Application object
  MyApp=new TMyApp(argv[0]);
  MyApp->Run();
  delete MyApp;

  return 0;
}
