/* --------------------------------------------------------------------------
	Project S.W.O.R.D
	V2.10

	SubSystem : Samples programs : create Dialog box
	File      : Samples/Dialog/Dialog.CC
	Author    : Eric NICOLAS
	Overview  : Dialog sample program main file
	UpDate    : Apr 14, 1996

** Copyright (C) 1993-1996 Eric NICOLAS
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
** ------------------------------------------------------------------------*/

#include "sword.h"

#define cmDialogTest 10000

// ==== DIALOG DATAS =========================================================

struct TMyDialogData
{ int  Checks     PACKED;
  int  Radios     PACKED;
  char String[61] PACKED;
};

static TMyDialogData MyDialogData;
static long          MyDialogResult;

// ==== APPLICATION OBJECT ===================================================

// This object is the application object. Construct the dialog, and
// wait for cmOK command for exiting the application

class TDialogApp : public TApp
{ DECLARE(TDialogApp);
  DECLARE_EVENTS_TABLE;
  public:
  // Public constructor
            TDialogApp(void);
            TDialogApp(char *argv0);
  // Overridables
    virtual boolean CanClose(void);
    virtual void    CreateMenuChoices(TMenu *Menu);
  // Events handling
            boolean doDialogTest(void);
};

DEFINE(TDialogApp)

DEFINE_EVENTS_TABLE(TDialogApp,TApp)
  COMMAND(cmDialogTest,doDialogTest)
END_EVENTS_TABLE

TDialogApp::TDialogApp(void)
{ Defaults();
}

TDialogApp::TDialogApp(char *argv0)
{ Defaults();
  Init(argv0);
}

void TDialogApp::CreateMenuChoices(TMenu *Menu)
{ Menu->Insert(new TMenuChoice("&Test dialog",0,cmDialogTest));
  Menu->Insert(new TMenuChoice());
  Menu->Insert(new TMenuChoice("&Quit",ScanAltQ,cmQuit));
}

boolean TDialogApp::CanClose(void)
{ if (MessageBox("Confirmation","Are you sure that you want to quit",
                 "this marvellous sample program from SWORD package ?",
                 mbYes | mbNo)==cmYes) return TRUE;
  else return FALSE;
}

boolean TDialogApp::doDialogTest(void)
{ TDialog *Dialog;
  TGroupBox *GB;
  int       dX,dY;
  // Build TDialog object
  // Size is 270x278, compute position to center it on the screen
  dX=(GrMaxX()-270)/2;
  dY=(GrMaxY()-278)/2;
  Dialog=new TDialog(dX,dY,270,278,"Dialog sample");
  // Insert controls in the dialog
  // :: One "Other Button" button, disabled for interactions
  Dialog->Insert(new TStdButton(10,30,80,23,0,0,boDisabled,"Other"));
  // :: One Cancel Button
  Dialog->Insert(new TCancelButton(95,30));
  // :: One OK button
  Dialog->Insert(new TOKButton(180,30));
  // :: One Static text
  Dialog->Insert(new TStaticText(10,60,250,20,"Sample application from SWORD package"));
  // :: Check boxes
  GB=new TGroupBox(10,85,250,65);
  GB->Insert(new TCheckBox(10,15,100, boNoCase, 1, "Check Box &A"));
  GB->Insert(new TCheckBox(10,40,100, boNoCase, 2, "Check Box &B"));
  Dialog->Insert(GB);
  // :: Radio buttons
  GB=new TGroupBox(10,160,250,80,"Radio buttons group");
  GB->Insert(new TRadioBox(10, 25,100, boNoCase, 1, "Radio &C"));
  GB->Insert(new TRadioBox(120,25,100, boNoCase | boDisabled, 2, "Radio &D"));
  GB->Insert(new TRadioBox(10, 50,100, boNoCase, 3, "Radio &E"));
  GB->Insert(new TRadioBox(120,50,100, boNoCase, 4, "Radio &F"));
  Dialog->Insert(GB);
  // :: Edit Line
  Dialog->Insert(new TEditLine(10,245,250,60,10));
  // Execute the dialog
  MyDialogResult=ExecDialog(Dialog,&MyDialogData);
  return TRUE;
}

// ==== MAIN PROGRAMM ========================================================

int main(char , char *argv[])
{ TDialogApp *MyDialogApp;

  // Application identification
  ShortVersion="Dialog";
  LongVersion ="Dialog Sample. Copyright (C) 1993-1996 The SWORD Group";

  // Initialize default values for dialog's controls
  MyDialogData.Checks=1;     // Check box A is checked
  MyDialogData.Radios=3;     // Radio button E is actived
  strcpy(MyDialogData.String,"Sample text edit");

  // Execute Application
  MyDialogApp=new TDialogApp(argv[0]);
  MyDialogApp->Run();
  delete MyDialogApp;

  // Print results of dialog in text mode after the application finished
  printf("'Dialog' application finished.\n"
         "You quit the dialog last time by clicking on ");
  switch(MyDialogResult)
  { case cmOK     : printf("OK\n");     break;
    case cmCancel : printf("Cancel\n"); break;
  }
  printf("Check box selected    : ");
  if (MyDialogData.Checks & 1) printf("A ");
  if (MyDialogData.Checks & 2) printf("B ");
  printf("\nRadio button selected : ");
  switch(MyDialogData.Radios)
  { case 1 : printf("C\n"); break;
    case 2 : printf("D\n"); break;
    case 3 : printf("E\n"); break;
    case 4 : printf("F\n"); break;
  }
  printf("Line typed            : %s\n",MyDialogData.String);
  return 0;
}