/* --------------------------------------------------------------------------
	Project S.W.O.R.D
	V2.10

	SubSystem : Basic objects, General use mecanisms
	File      : Include/Mecanism/Atom.H
	Author    : Eric NICOLAS
	Overview  : Object TAtom : Linked lists, Objects streams
	UpDate    : Fev 28, 1996

** Copyright (C) 1993-1996 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
** ------------------------------------------------------------------------*/

#ifndef _MECANISM_ATOM_H_
#define _MECANISM_ATOM_H_

// Macros for easy declarations of objects

#define DECLARE(a)                     \
  public:                              \
	virtual ~a(void);                   \
	virtual TAtom* Duplicate()

#define DEFINE(a)                      \
	a::~a(void)                         \
	{ if (!Destroyed)                   \
	  { Done();                         \
		 Destroyed=TRUE;                 \
	  }                                 \
	}                                   \
													\
	TAtom* a::Duplicate(void)           \
	{ return new a();                   \
	}

// --- TAtom object

extern short RegTAtom;
extern char *IdentTAtom;

class TAtom
{ DECLARE(TAtom);
  protected:
	 TAtom*  _Next;
	 TAtom*  _Previous;
	 TAtom*  _Son;
	 TAtom*  _Father;
	 boolean Destroyed;
  public:
	 short   Register;
	 char*   Ident;
  public:
  // Public constructor
			 TAtom(void);
  // Creation / Destruction
  			 void     Defaults(void);
			 void     Init(void);
			 void     Done(void);
  // Linked lists
			 void     LinkBefore(TAtom* A);
			 void     Link(TAtom* A);
  virtual void     UnLink(void);
  virtual void     InsertBefore(TAtom* A);
  virtual void     Insert(TAtom* A);
			 TAtom*   First(void);
			 TAtom*   Last(void);
			 TAtom*   Son(void);
			 TAtom*   Father(void);
          TAtom*   Next(void);
          TAtom*   Previous(void);
  // Objects streams
  virtual void     Write(TDisk *file);
  virtual void     Read(TDisk *file);
};

// --- Registration managment

void   InitRegister(void);
void   DoneRegister(void);

void   RegisterObject(TAtom* A, short *Register);

TAtom* ReadObject(TDisk *file);
void   WriteObject(TDisk *file, TAtom *A);

void   ReadString(TDisk *file, char **Text);
void   WriteString(TDisk *file, char *Text);
void   ReadInt(TDisk *file, int *Value);
void   WriteInt(TDisk *file, int Value);

// Inline functions

inline TAtom* TAtom::Son(void)
{ return _Son;
}

inline TAtom* TAtom::Father(void)
{ return _Father;
}

inline TAtom* TAtom::Next(void)
{ return _Next;
}

inline TAtom* TAtom::Previous(void)
{ return _Previous;
}

#endif // _MECANISM_ATOM_H_

/* --------------------------------------------------------------------------
** HISTORY
** --------------------------------------------------------------------------
** 2.10:
**   20/02/96 :EN: First History remark. Copying code V2.00->V2.10
**   28/02/96 :EN: A step to a good model of Creating/Destructing objects
** ------------------------------------------------------------------------*/
