/* --------------------------------------------------------------------------
	Project S.W.O.R.D
	V2.10

	SubSystem : Little usefull graphical objects
	File      : Include/Gadgets/StdWin.H
	Author    : Eric NICOLAS
	Overview  : TStdWin object : Standard window
	UpDate    : Apr 08, 1996

** Copyright (C) 1993-1996 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
** ------------------------------------------------------------------------*/

#ifndef _GADGETS_STDWIN_H_
#define _GADGETS_STDWIN_H_

class TWindowFrameCorner;
class TStdWindow;

// --- TWindowFrameCorner

extern short RegTWindowFrameCorner;
extern char *IdentTWindowFrameCorner;

class TWindowFrameCorner : public TZone
{ DECLARE(TWindowFrameCorner);
  DECLARE_EVENTS_TABLE;
  // --- Datas
  protected:
    TSysIcone *Drawing;
    int        Number;
  public:
  // Public constructors
          TWindowFrameCorner(void);
          TWindowFrameCorner(int X, int Y, char *Descr, int NCurs, int _Number, int _Options);
  // Construction / Destruction
          void Defaults(void);
          void Init(int X, int Y, char *Descr, int NCurs, int _Number, int _Options);
          void Done(void);
  // Graphics
  virtual void Draw(TRect Clip);
  // Mouse interaction
          boolean       MouseLDown(TPoint Where, int Buttons);
  // Linked list
          TStdWindow   *Father(void);
};

// --- TStdWindow

extern short RegTStdWindow;
extern char *IdentTStdWindow;

class TStdWindow : public TWindow
{ DECLARE(TStdWindow);
  DECLARE_EVENTS_TABLE;
  // --- Datas
  protected:
  // --- Functions
  public:
  // Public constructors
          TStdWindow(void);
          TStdWindow(int X, int Y, int L, int H, char *Title, int Options);
          TStdWindow(TRect R, char *Title, int Options);
  // Construction / Destruction
          void     Defaults(void);
          void     Init(int X, int Y, int L, int H, char *Title, int Options);
  //
  virtual void     Draw(TRect Clip);
  virtual void     ChangeSize(int CornerNo, TPoint mWhere);
  // Events handling
          boolean  doChangeSelect(void);
};

// Inline methods

inline TStdWindow *TWindowFrameCorner::Father(void)
{ return (TStdWindow*)(TZone::Father());
}

#endif // _GADGETS_STDWIN_H_

/* --------------------------------------------------------------------------
** HISTORY
** --------------------------------------------------------------------------
** 2.10:
**   21/02/96 :EN: First History remark. Copying code V2.00->V2.10
**   29/02/96 :EN: Moving from struct to class. Adding Defaults() method.
**   03/03/96 :EN: Changing color scheme so that it can be user-modified
**   01/04/96 :EN: Adding DECLARE_COMMAND... macros
**   08/04/96 :EN: Changing from DECLARE_COMMAND... to DECLARE_EVENTS...
** ------------------------------------------------------------------------*/
