/*
  Textwindow under GEM.

  void init_textmode(int br,int lin,WORD x,WORD y)
      Initilaize the textwindow
      br  = number of columns of textwindow
      lin = number of lines of textwindow
      x   = X - Position of textwindow
      y   = Y - Position of textwindow

  void close_textmode()
      Closes the textwindow

  void clreol()
      Clears form cursorposition to end of line

  void clrscr()
      Clears the textwindow

  void gotoxy(int xg,int yg)
      Sets the writeposition in textwindow

  void gemprintf(char *fmt,...)
      Like printf the following styles are implemented
      %c,%s,%d,%u for a new line you must \n like when using printf.
      %u ( is a bit buggy )
*/

#include <stdio.h>
#include <dos.h>
#include <string.h>
#include <stdarg.h>

#ifdef __TURBOC__
 #define __BORLANDC__
#endif
#ifdef __BORLANDC__
 #include "portab.h"
 #include "aes.h"    
 #include "vdi.h"    
 #include "rclib.h"
#endif
#ifdef __PACIFIC__
 #include <ppdgem.h>
#endif

/*---------------------------------------------------------------------------
#define SCROLL 0
//-------------------------------------------------------------------------*/

/* Variables needed for Textwindow under GEM*/
short OUT;
WORD  pxy[4],Col;
GRECT Out,work_area;
WORD  xp,yp; /* Cursor Position in Output Window */
int  breite,hoehe;  /* Sizes in char of the output Window */
int  zh; /* Height of a char. Is different between CGA,EGA,VGA (8,14,16) */
WORD vdi_handle;
/*-------------------------------------------------------------------------*/

#ifdef __BORLANDC__
GLOBAL WORD   contrl[11];   
GLOBAL WORD   intin[80];    
GLOBAL WORD   ptsin[256];   
GLOBAL WORD   intout[45];   
GLOBAL WORD   ptsout[12];
#endif
/*-------------------------------------------------------------------------*/
void set_clip(WORD clip_flag,GRECT *s_area)
{
   rc_grect_to_array(s_area, pxy);
   vs_clip(vdi_handle, clip_flag, pxy);
}


VOID clr(GRECT *clip_area) 
{
   set_clip(TRUE, clip_area);
   vsf_interior(vdi_handle, 1);
   vsf_color(vdi_handle, WHITE);
   vswr_mode(vdi_handle,MD_REPLACE);
   vsl_type (vdi_handle,FIS_SOLID);
   rc_grect_to_array(&work_area, pxy);
   vsf_color(vdi_handle, WHITE);
   #ifdef __BORLANDC__
   graf_mouse(M_OFF,(MFORM *)0l);
   #endif
   #ifdef __PACIFIC__
   graf_mouse(M_OFF,0);
   #endif
   vr_recfl(vdi_handle, pxy);   /* clear entire message area   */
   set_clip(FALSE, clip_area);
   #ifdef __BORLANDC__
   graf_mouse(M_ON,(MFORM *)0l);
   #endif
   #ifdef __PACIFIC__
   graf_mouse(M_ON,0);
   #endif
}
void scroll()
{
  /* Not implemented now */
   clr(&Out);
   xp=0;
   yp=1;
}
void close_textmode()
{
   int i;
   wind_close(OUT);
}
void init_textmode(int br,int lin,WORD x,WORD y)
{
   int i;
   WORD gl_wchar,gl_hchar,gl_wbox,gl_hbox; 
   char *titel="Textmode Window";
   xp=0;yp=1; /* Cursor position initialize */
   Col=BLACK;
   if (lin<0) lin=1;
   if (br<0) br=1;
   if (br>80) br=80;
   if (lin>24) lin=24;
   breite=br;
   hoehe=lin;
   vdi_handle = graf_handle(&gl_wchar, &gl_hchar,&gl_wbox, &gl_hbox);
   zh=gl_hchar;
   OUT=wind_create(NAME,0,0,br*8, lin*zh);
   wind_set(OUT, WF_NAME, FPOFF(titel), FPSEG(titel), 0, 0);     
   wind_open(OUT, x,y, br*8, lin*zh);
   wind_get(OUT, WF_WXYWH, &Out.g_x,&Out.g_y, &Out.g_w,&Out.g_h);
   wind_get(OUT, WF_WXYWH, &work_area.g_x,&work_area.g_y, &work_area.g_w,&work_area.g_h);

}
void clrscr()
{
   clr(&Out);
   xp=0;
   yp=1;
}
VOID put(char ch,GRECT *clip_area)
{
   WORD   ycurr;
   char cha[2];
   cha[0]=ch;
   cha[1]='\0';
   set_clip(TRUE, clip_area);

   vsf_interior(vdi_handle, 1);
   vsf_color(vdi_handle, WHITE);
   rc_grect_to_array(&work_area, pxy);
   #ifdef __BORLANDC__
   graf_mouse(M_OFF,(MFORM *)0l);
   #endif
   #ifdef __PACIFIC__
   graf_mouse(M_OFF,0);
   #endif

   vsl_color(vdi_handle,WHITE);
   vswr_mode(vdi_handle,MD_REPLACE);
   vsl_type (vdi_handle,FIS_SOLID);
   vsf_color(vdi_handle,WHITE);
   vst_color(vdi_handle,Col);
   vswr_mode(vdi_handle, 1);
   vst_effects(vdi_handle,0);
   v_gtext(vdi_handle, work_area.g_x+(xp*8), work_area.g_y+(yp*zh), cha);
   set_clip(FALSE, clip_area);
   #ifdef __BORLANDC__
   graf_mouse(M_ON,(MFORM *)0l);
   #endif
   #ifdef __PACIFIC__
   graf_mouse(M_ON,0);
   #endif
   vst_color(vdi_handle,Col);
   xp=xp+1;
   if (xp==breite)
   {
     xp=0;
     yp=yp+1;
   }
   if (yp==hoehe)
   {
     #ifndef SCROLL
      yp=1;
      xp=0;
      clr(&Out);
     #else
      yp=yp-1;
      xp=0;
      scroll();
     #endif
   }
}

void gotoxy(int xg,int yg)
{
  xg=xg-1;
  if (xg>breite) xg=breite;
  if (yg>hoehe) yg=hoehe;
  if (xg<0) xg=0;
  if (yg<1) yg=1;
  xp=xg;
  yp=yg;
}
void textcolor(WORD co)
{
  Col=co;
}
void clreol()
{
  WORD c,xo;
  WORD i;
  xo=xp;
  c=Col;
  for (i=xp;i<breite+1;i++)
  {
    xp=i;
    put(' ',&Out);
  }
  Col=c;
  xp=xo;
}
void gemprintf(char *fmt,...)
{
   va_list ap;
   char outp[128];
   char *p, *sval;
   int ival,i;
   unsigned uns;
   double dval;
   va_start(ap,fmt);
   for (p=fmt;*p;p++)
   {
    if (*p == 10)
    {
     xp=0;
     yp=yp+1;
     if (yp>=hoehe)
     {
       #ifndef SCROLL
        yp=1;
        xp=0;
        clr(&Out);
       #else
        yp=yp-1;
        xp=0;
        scroll();
       #endif
     }
     continue;
    }
    if (*p == 13)
    {
     xp=0;
     continue;
    }
    if (*p != '%')
    {
      put(*p,&Out);
      continue;
    }
   switch (*++p) {
    case 'd':
      ival=va_arg(ap,int);
      sprintf(outp,"%d",ival);
      for (i=0;i<strlen(outp);i++) put(outp[i],&Out);
      break;
    case 'u':
      uns=va_arg(ap,unsigned);
      sprintf(outp,"%u",uns);
      for (i=0;i<strlen(outp);i++) put(outp[i],&Out);
      break;
    case 'c':
      outp[0]=va_arg(ap,char);
      put(outp[0],&Out);
      break;
    case 's':
     for (sval=va_arg(ap,char *);*sval;sval++) put(*sval,&Out);
     break;
    default:
      put(*p,&Out);
      break;
   }
   va_end(ap);
  }
} 

char readchr()
{
  WORD echo_xy [2];
  BYTE string [2];

  echo_xy [0] = 0;
  echo_xy [1] = 0;

  vrq_string (vdi_handle, 1, 0, echo_xy, string);
  return(string[0]);
}
