#include <graphics.h>
#include <color.h>
#include <process.h>
#include <conio.h>
#include <stdio.h>
#include <alloc.h>
#include <stdlib.h>
#include <string.h>
#include <io.h>
#include <dir.h>
#include <fcntl.h>
#include <dos.h>
#include "defines.h"
#include "maus.h"

#define EINSTELLUNGEN_DATEIID  "DBDV2.50EINSTELLUNGEN"
#define GRP_MAXICONBYTES       640
#define COPYSIZE               32750
#define NO_VGA                 1

char *FEHLER_msg[]= { "The installation program ended successfully.         ",
                      "A VGA Graphics Card is required.     "},
     globalmaus, msg_to_Klick= AUS;
struct REGPACK RP;

extern int CritHandler();
extern int Decomp( int X, int Y, int Laenge, int Hoehe, char *Quelle, char *Ziel);

char *strnistr( char *s1, char *s2, size_t maxlen)
{
   int find= 1;
   unsigned len, i;

   len= strlen( s2);
   for( i= 0; ( *s1!= '\0')&& ( i<= ( ( long)maxlen- len)); i++)
      if(( find= memicmp( s1++, s2, len))== 0)
         break;
   return( ( find) ? ( NULL) : ( --s1));
}

int DriveSize( int LW)                                     /* 0=A, 1=B, ... */
{
   RP.r_ax= 0x0800;
   RP.r_dx= LW;
   intr( DISK_INT, &RP);
   if( RP.r_flags& CARRY_FLAG)          /* Fkt. nicht vorhanden -> XT-360KB */
      return( DD_525);
   else
      return( LO( RP.r_bx));
}

int ExistLaufwerk( int LW)                                 /* 0=A, 1=B, ... */
{
   RP.r_ax= 0x4408;
   RP.r_bx= LW+ 1;
   intr( DOS_INT, &RP);
   if( RP.r_ax!= 15)
   {
      if( !((( LW== 0)|| ( LW== 1))&& ( DriveSize( LW)== 0))) /* A: oder B: */
         return( 0);
   }
   return( -1);
}

int Laufwerksart( int LW)                                  /* 0=A, 1=B, ... */
{
   /*
      0= FLOPPY_525
      1= FLOPPY_35
      2= NETZWERK
      3= FESTPLATTE
      4= DOUBLEDENSITY
      5= RAMDISK
      6= CD_ROM
     -1= NO_DRIVE -> Laufwerk konnte nicht erkannt werden (existiert nicht)
   */

   char *dpb_ptr, buf[ 512];

   RP.r_ax= 0x4409;
   RP.r_bx= LW+ 1;
   RP.r_dx= 0x0000;
   intr( DOS_INT, &RP);
   if( RP.r_flags& CARRY_FLAG)
      return( NO_DRIVE);
   if( RP.r_dx& 0x1000)
   {
      RP.r_ax= 0x150B;
      RP.r_bx= 0;
      RP.r_cx= LW+ 1;
      intr( MULTIPLEX_INT, &RP);
      if(( RP.r_bx== 0xADAD)&& ( RP.r_ax== 0))
         return( CD_ROM);
      else
         return( NETZWERK);
   }
   RP.r_ax= 0x4408;
   intr( DOS_INT, &RP);
   if( RP.r_flags& CARRY_FLAG)
   {
      if( RP.r_ax== 1)
      {
         if( !absread( LW, 1, 0, buf))
         {
            if( !strncmp( &buf[ 3], "D_D_VOL", 7))
               return( DOUBLEDENSITY);
         }
      }
      return( NO_DRIVE);
   }
   if( RP.r_ax== 0)                                    /* Diskettenlaufwerk */
   {
      switch( DriveSize( LW))
      {
         case DD_525:
         case HD_525:
            return( FLOPPY_525);
         default:
            return( FLOPPY_35);
      }
   }
   RP.r_ax= 0x3200;
   RP.r_dx= LW+ 1;
   intr( DOS_INT, &RP);
   dpb_ptr= MK_FP( RP.r_ds, RP.r_bx);
   if( *( dpb_ptr+ 0x04)== 0)
      return( RAMDISK);
   else
      return( FESTPLATTE);
}

static int Copy( int x, int y, int laenge, int hoehe, char *q_path, char *z_path, char Balken_an_aus)
{
   int q_handle= 0, z_handle= 0, attrib= 0, xsp= 0, schreiben= 0, lesen= 0;
   int q_fehler= 0, z_fehler= 0;
   long datlaenge= 0, z_sp= 0;
   struct ftime ft;
   char *datptr;

   attrib= _chmod( q_path, 0);                /* Attribute speichern */
   if(( q_handle= open( q_path, O_RDONLY| O_BINARY))== -1)
      return( -1);
   getftime( q_handle, &ft);
   if(( z_handle= _creat( z_path, attrib))== -1)
      return( -3);
   if(( datptr= malloc( COPYSIZE))== NULL)
   {
      unlink( z_path);
      return( -4);
   }
   if(( datlaenge= filelength( q_handle))> 0)
   {
      do
      {
         if(( lesen= read( q_handle, datptr, COPYSIZE))== -1)
         {
            unlink( z_path);
            free( datptr);
            return( -5);
         }
         if(( schreiben= write( z_handle, datptr, lesen))== -1)
         {
            unlink( z_path);
            free( datptr);
            return( -6);
         }
         z_sp+= schreiben;
         if( Balken_an_aus== AN)
         {
            ShowMouse( AUS);
            Balken( x, y, laenge, hoehe, z_sp, datlaenge, &xsp);
            ShowMouse( AN);
         }
      }while( lesen&& ( lesen== schreiben));
   }
   q_fehler= close( q_handle);
   setftime( z_handle, &ft);
   z_fehler= close( z_handle);
   if(( lesen!= schreiben)|| ( q_fehler)|| ( z_fehler))
   {
      unlink( z_path);
      free( datptr);
      return( -7);
   }
   free( datptr);
   return( 0);
}

int MkDir( char *path)
{
   char pathsp[ MAXPATH], teil_dir[ MAXPATH], *dir_ptr;

   if( access( path, 0))
   {
      strcpy( pathsp, path);
      dir_ptr= strtok( pathsp, "\\");
      strcpy( teil_dir, dir_ptr);
      do
      {
         strcat( teil_dir, "\\");
         if(( dir_ptr= strtok( NULL, "\\"))!= 0)
         {
            strcat( teil_dir, dir_ptr);
            if( access( teil_dir, 0))
               if( mkdir( teil_dir))    /* Verzeichnis konnte nicht erstellt werden */
                  return( -1);
         }
      }while( dir_ptr);
   }
   else
      return( 1);                       /* Verzeichnis existiert schon */
   return( 0);                          /* alles o.k. */
}

typedef struct{ char *Q_File,
                     *Z_File,
                     *Msg;
                int  X,
                     Y;
              }Copy_File;

int main( void)
{
   struct dfree dfree;
   struct ffblk ffblk;
   WORD f_length;
   BOOL _EXEC= 0;
   int gdriver= DETECT, gmode, i, Fehler= 0, X_dummy= 0, Y_dummy= 0, ret= 0,
       ret_val= 0, done, Anz_Icons, work_Icon, x_sp, handle, bak_handle,
       lw_art, dir_len;
   char auto_AUTOEXEC_BAT= AN, *q_ptr, *p_ptr, *mem_ptr, *tmp_ptr, *e_ptr,
        programm_verzeichnis[ MAXDIR]= "C:\\DSK2",
        icon_verzeichnis[ MAXDIR]= "C:\\DSK2\\DBD_AICO",
        quell_verzeichnis[ MAXPATH],
        programm_verzeichnis_sp[ MAXDIR],
        icon_verzeichnis_sp[ MAXDIR],
        tmp_array[ 100];
   Copy_File Dateien[]= { { "DBD.BA~",      "DBD.BAT",      "Unpack DBD.BA~ ...",       25, 364},
			  { "DESKTOP2.EX~", "DESKTOP2.EXE", "Unpack DESKTOP2.EX~ ...",  25, 384},
			  { "RESOURCE.DB~", "RESOURCE.DB2", "Unpack RESOURCE.DB~ ...",  25, 404},
			  { "WAIT.CO~",     "WAIT.COM",     "Unpack WAIT.CO~ ...",     323, 364},
			  { "DESKTOP2.DO~", "DESKTOP2.DOC", "Unpack DESKTOP2.DO~ ...", 323, 384},
			  { "EINSTELL.DB~", "EINSTELL.DB2", "Unpack EINSTELL.DB~ ...", 323, 404} };
   void *arg_ptr[ 3];
   char *msg[]= { "Click here to start installation              ",
                  "Click here to abort the installation program             ",
                  "Enter a directory name in the form DRIVE:\\DIRECTORY            ",
                  "Enter a directory name in the form DRIVE:\\DIRECTORY            ",
                  "Check in the HINTs               " };
   WORD mauspos[]= { BUTTON|   FRAME| KEY| DEFBUTTON| MSG, 450, 519,  28,  80, ALT_S,
                     BUTTON|   FRAME| KEY| MSG,            523, 592,  28,  80, ESC,
		     INPUT|    FRAME| KEY| MSG,             35, 123, 399, MAXDIR- 1, 'i',
		     INPUT|    FRAME| KEY| MSG,             35, 159, 399, MAXDIR- 1, 'c',
		     CHECKBOX| FRAME| KEY| MSG,             36, 187, 'd',
                     };
   MAUSStruct MS= { DEFAULT, DEFAULT, 640, 480, 5, INIT, NULL, AN};

   arg_ptr[ 0]= programm_verzeichnis;
   arg_ptr[ 1]= icon_verzeichnis;
   arg_ptr[ 2]= &auto_AUTOEXEC_BAT;
   MS.x= &X_dummy;
   MS.y= &Y_dummy;
   MS.msg= msg;
   MS.mauspos= mauspos;
   MS.arg_ptr= arg_ptr;
   if( registerbgidriver( EGAVGA_driver)>= 0)
   {
      initgraph( &gdriver, &gmode, "");
      if( graphresult()== grOk)
      {
         if( getgraphmode()== VGAHI)                       /* 640 x 480 VGA */
         {
            SetPal();                              /* Farbtabelle verndern */
            harderr( CritHandler);                   /* Fatal_Error Handler */
            if( InitMouse()== 0)
               globalmaus= AUS;
            else
               globalmaus= AN;
            MouseArt( maus_pfeil);              /* neuen Mauspfeil anzeigen */
            MSpeed( 8);                  /* neue Mausgeschwindigkeit setzen */
            PCX_Window( MS.x, MS.y, "IOVL.RES");
            ShowMouse( AN);
            do
            {
               switch( __CheckMousepos( &MS))
               {
                  case 0:                                          /* Start */
                     if( !strncmp( programm_verzeichnis+ 1, ":\\", 2)&& !strncmp( icon_verzeichnis+ 1, ":\\", 2))
                     {
                        getdfree( *programm_verzeichnis- 64, &dfree);
                        if( dfree.df_sclus!= 0xFFFF)             /* kein Fehler */
                        {
                           if(( ( long)dfree.df_avail* ( long)dfree.df_bsec* ( long)dfree.df_sclus)>= 2048000)   /* 2 MByte */
                           {
                              if( strcmp( programm_verzeichnis, icon_verzeichnis))
                              {
                                 ret_val= 0;
                                 strcpy( programm_verzeichnis_sp, programm_verzeichnis);
                                 strcpy( icon_verzeichnis_sp, icon_verzeichnis);
                                 PrintStatus( "Creating program directory ...      ");
                                 if( MkDir( programm_verzeichnis)!= -1)
                                 {
                                    if( *( getcwd( quell_verzeichnis, MAXPATH)+ 3)!= '\0')
                                       strcat( quell_verzeichnis, "\\");
                                    q_ptr= strrchr( quell_verzeichnis, '\\')+ 1;
                                    if( *( programm_verzeichnis+ 3)!= '\0')
                                       strcat( programm_verzeichnis, "\\");
                                    p_ptr= strrchr( programm_verzeichnis, '\\')+ 1;
                                    for( i= 0; i< sizeof( Dateien)/ sizeof( Copy_File); i++)
                                    {
                                       strcpy( q_ptr, Dateien[ i].Q_File);
                                       strcpy( p_ptr, Dateien[ i].Z_File);
                                       PrintStatus( Dateien[ i].Msg);
                                       if( Decomp( Dateien[ i].X, Dateien[ i].Y, 112, 5, quell_verzeichnis, programm_verzeichnis)!= 0)
                                       {
                                          sprintf( tmp_array, "Could not unpack file %s", Dateien[ i].Q_File);
                                          ErrorMsg( tmp_array);
                                          ret_val= -1;
                                          break;
                                       }
                                    }
                                    if( !ret_val)                     /* kein Fehler */
                                    {
                                       PrintStatus( " Changing system installation file (EINSTELL.DB2) ...");
                                       if(( handle= _open( programm_verzeichnis, O_RDWR))!= -1)
                                       {
                                          lseek( handle, sizeof( EINSTELLUNGEN_DATEIID)- 1, SEEK_SET);
                                          if( _write( handle, icon_verzeichnis, strlen( icon_verzeichnis)+ 1)== -1)
                                          {
                                             ErrorMsg( "Could not change system installation (EINSTELL.DB2)       ");
                                             ret_val= -1;
                                          }
                                          _close( handle);
                                       }
                                       else
                                       {
                                          ErrorMsg( "Could not change system installation (EINSTELL.DB2)       ");
                                          ret_val= -1;
                                       }
                                       if( !ret_val)                  /* kein Fehler */
                                       {
                                          x_sp= 0;
                                          if( *( icon_verzeichnis+ 3)!= '\0')
                                             strcat( icon_verzeichnis, "\\");
                                          p_ptr= strrchr( icon_verzeichnis, '\\')+ 1;
                                          PrintStatus( "Creating icon directory ...            ");
                                          if( MkDir( icon_verzeichnis)!= -1)
                                          {
                                             q_ptr= strrchr( strcpy( q_ptr, "DBD_AICO\\*.ICO"), '\\')+ 1;
                                             PrintStatus( "Copying icons ... ");
                                             for( i= 0, Anz_Icons= 0, work_Icon= 0; ( i< 2)&& !ret_val; i++)
                                             {
                                                done= findfirst( quell_verzeichnis, &ffblk, FA_NORMAL);
                                                while( !done)
                                                {
                                                   if( !i)
                                                      Anz_Icons++;
                                                   else
                                                   {
                                                      strcpy( q_ptr, ffblk.ff_name);
                                                      strcpy( p_ptr, ffblk.ff_name);
                                                      if( Copy( 0, 0, 0, 0, quell_verzeichnis, icon_verzeichnis, AUS)!= 0)
                                                      {
                                                         sprintf( tmp_array, "Could not copy icon %s", ffblk.ff_name);
                                                         ErrorMsg( tmp_array);
                                                         ret_val= -1;
                                                         break;
                                                      }
                                                      work_Icon++;
                                                      ShowMouse( AUS);
                                                      Balken( 25, 424, 410, 5, ( long)work_Icon, ( long)Anz_Icons, &x_sp);
                                                      ShowMouse( AN);
                                                   }
                                                   done= findnext( &ffblk);
                                                }
                                             }
                                             if( !ret_val)      /* kein Fehler */
                                             {
                                                _EXEC= 1;
                                                ret= 1;
                                                if( auto_AUTOEXEC_BAT== AN)
                                                {
                                                   PrintStatus( "   Changing file AUTOEXEC.BAT ...");
                                                   if(( tmp_ptr= getenv( "COMSPEC"))== NULL)
                                                   {
                                                      strcpy( tmp_array, "C:\\AUTOEXEC.BAT");
                                                      for( i= 'C'; i<= 'Z'; i++)
                                                      {
                                                         if( !ExistLaufwerk( i- 'A')&& (( lw_art= Laufwerksart( i- 'A'))!= FLOPPY_525)&& ( lw_art!= FLOPPY_35))
                                                         {
                                                            sprintf( tmp_array, "%c:\\AUTOEXEC.BAT", i);
                                                            if( access( tmp_array, 0)== 0)
                                                               break;
                                                         }
                                                      }
                                                   }
                                                   else
                                                      strcpy( strncpy( tmp_array, tmp_ptr, 3)+ 3, "AUTOEXEC.BAT");
                                                   if( access( tmp_array, 0))
                                                   {
                                                      ErrorMsg( "Could not find AUTOEXEC.BAT     ");
                                                   }
                                                   else
                                                   {
                                                      if(( handle= _open( tmp_array, O_RDWR))== -1)
                                                      {
                                                         ErrorMsg( "Could not open AUTOEXEC.BAT     ");
                                                      }
                                                      else
                                                      {
                                                         f_length= filelength( handle);
                                                         dir_len= strlen( programm_verzeichnis_sp);
                                                         if(( mem_ptr= malloc( f_length+ dir_len+ 10))== NULL)
                                                         {
                                                            ErrorMsg( "Not enough memory to change AUTOEXEC.BAT      ");
                                                         }
                                                         else
                                                         {
                                                            if( _read( handle, mem_ptr, f_length)== -1)
                                                            {
                                                               ErrorMsg( "Could not read AUTOEXEC.BAT    ");
                                                            }
                                                            else
                                                            {
                                                               *( mem_ptr+ f_length)= '\0';
                                                               strcpy( strrchr( tmp_array, '\\')+ 1, "AUTOEXEC.BAK");
                                                               if(( bak_handle= _creat( tmp_array, FA_ARCH))== -1)
                                                               {
                                                                  ErrorMsg( "Could not create AUTOEXEC.BAK     ");
                                                               }
                                                               else
                                                               {
                                                                  if( _write( bak_handle, mem_ptr, f_length)== -1)
                                                                  {
                                                                     ErrorMsg( "Could not write AUTOEXEC.BAK       ");
                                                                  }
                                                                  _close( bak_handle);
                                                               }
                                                               if(( tmp_ptr= strnistr( mem_ptr, "PATH", f_length))!= NULL)
                                                               {
                                                                  if( strnistr( tmp_ptr, programm_verzeichnis_sp, strchr( tmp_ptr, '\r')- tmp_ptr)== NULL)
                                                                  {
                                                                     memmove( tmp_ptr+ 6+ dir_len, tmp_ptr+ 5, strlen( tmp_ptr+ 5)+ 1);
                                                                     *( strncpy( tmp_ptr+ 5, programm_verzeichnis_sp, dir_len)+ dir_len)= ';';
                                                                  }
                                                               }
                                                               else
                                                               {
                                                                  if(( tmp_ptr= strnistr( mem_ptr, "ECHO OFF", f_length))!= NULL)
                                                                     e_ptr= strchr( tmp_ptr, '\r')+ 2;
                                                                  else
                                                                     e_ptr= mem_ptr;
                                                                  memmove( e_ptr+ 7+ dir_len, e_ptr, strlen( e_ptr)+ 1);
                                                                  strncpy( e_ptr, "PATH ", 5);
                                                                  strncpy( strncpy( e_ptr+ 5, programm_verzeichnis_sp, dir_len)+ dir_len, "\r\n", 2);
                                                               }
                                                               lseek( handle, 0L, SEEK_SET);
                                                               if( _write( handle, mem_ptr, strlen( mem_ptr))== -1)
                                                               {
                                                                  ErrorMsg( "Could not write AUTOEXEC.BAT       ");
                                                               }
                                                            }
                                                            free( mem_ptr);
                                                         }
                                                         _close( handle);
                                                      }
                                                   }
                                                }
                                                ClearStatus();
                                             }
                                          }
                                          else
                                          {
                                             ErrorMsg( "Unable to create icon directory         ");
                                             ret_val= -1;
                                          }
                                       }
                                    }
                                 }
                                 else
                                 {
                                    ErrorMsg( "Unable to create program directory");
                                    ret_val= -1;
                                 }
                                 strcpy( programm_verzeichnis, programm_verzeichnis_sp);
                                 strcpy( icon_verzeichnis, icon_verzeichnis_sp);
                              }
                              else
                                 Hinweis( "Program and icon directories must be separate        ");
                           }
                           else
                           {
                              ErrorMsg( "Not enough free disk space (min. 2 MByte)");
                              ret_val= -1;
                           }
                        }
                        else
                        {
                           ErrorMsg( "Error in detecting free disk space");
                           ret_val= -1;
                        }
                     }
                     else
                        Hinweis( "The drive must be given as part of the directory name  ");
                     break;
                  case 1:                                        /* Beenden */
                     ret= 1;
                     break;
                  case 2:                            /* Programmverzeichnis */
                     strupr( programm_verzeichnis);
                     MS.statsp= REINIT;
                     break;
                  case 3:                                /* Iconverzeichnis */
                     strupr( icon_verzeichnis);
                     MS.statsp= REINIT;
                     break;
               }
            }while( !ret);
         }
         else
            Fehler= NO_VGA;
         closegraph();
      }
      else
         Fehler= NO_VGA;
   }
   else
      Fehler= NO_VGA;
   puts( FEHLER_msg[ Fehler]);
   if( _EXEC)
   {
      setdisk( *programm_verzeichnis_sp- 'A');
      chdir( programm_verzeichnis_sp);
   }
   return( _EXEC);
}
