#ifndef _XMS_H
#define _XMS_H

#include "typedef.h"

#define ERR_NOERR          0x00                              /* kein Fehler */
#define ERR_NOTIMPLEMENTED 0x80        /* angegebene Funktion nicht bekannt */
#define ERR_VDISKFOUND     0x81                   /* VDISK-RAMDISK entdeckt */
#define ERR_A20            0x82             /* Fehler auf Adressleitung A20 */
#define ERR_GENERAL        0x8E                /* allgemeiner Treiberfehler */
#define ERR_UNRECOVERABLE  0x8F                  /* nicht-behebbarer Fehler */
#define ERR_HMANOTEXIST    0x90                      /* keine HMA vorhanden */
#define ERR_HMAINUSE       0x91                     /* HMA bereits vergeben */
#define ERR_HMAMINSIZE     0x92                    /* zu wenig Platz in HMA */
#define ERR_HMANOTALLOCED  0x93                      /* HMA nicht allokiert */
#define ERR_A20STILLON     0x94                /* Adressleitung A20 noch an */
#define ERR_OUTOMEMORY     0xA0           /* kein extended Memory mehr frei */
#define ERR_OUTOHANDLES    0xA1                  /* alle XMS-Handles belegt */
#define ERR_INVALIDHANDLE  0xA2                        /* ungltiges Handle */
#define ERR_SHINVALID      0xA3                   /* Source-Handle ungltig */
#define ERR_SOINVALID      0xA4                   /* Source-Offset ungltig */
#define ERR_DHINVALID      0xA5              /* Destination-Handle ungltig */
#define ERR_DOINVALID      0xA6              /* Destination-Offset ungltig */
#define ERR_LENINVALID     0xA7       /* ungltige Lnge fr Move- Funktion */
#define ERR_OVERLAP        0xA8                    /* verbotene berlappung */
#define ERR_PARITY         0xA9                          /* Partits-Fehler */
#define ERR_EMBUNLOCKED    0xAA                   /* UMB ist nicht gesperrt */
#define ERR_EMBLOCKED      0xAB                    /* UMB ist noch gesperrt */
#define ERR_LOCKOVERFLOW   0xAC            /* berlauf des UMB-Sperrzhlers */
#define ERR_LOCKFAIL       0xAD           /* UMB kann nicht gesperrt werden */
#define ERR_UMBSIZETOOBIG  0xB0                  /* kleinerer UMB verfgbar */
#define ERR_NOUMBS         0xB1                  /* kein UMB mehr verfgbar */
#define ERR_INVALIDUMB     0xB2          /* UMB-Segmentadresse ist ungltig */

typedef struct                              /* Informationen fr XMS-Aufruf */
         {
	  unsigned AX,                /* nur die Register AX, BX, DX und SI */
		   BX,                /* werden je nach aufgerufener Funk-  */
		   DX,                /* tion bentigt, dazu noch eine Seg- */
		   SI,                /* mentadresse                        */
		   Segment;
	 } XMSRegs;

typedef struct                        /* eine extended-Memory-Move-Struktur */
         {
	  long LenB;                             /* Anzahl zu versch. Bytes */
	  int  SHandle;                                    /* Source-Handle */
	  long SOffset;                                    /* Source-Offset */
	  int  DHandle;                               /* Destination-Handle */
	  long DOffset;                               /* Destination-Offset */
         } EMMS;

extern void far *XMSPtr;            /* Zeiger Extended-Memory-Manager (XMM) */
extern BYTE XMSErr;                     /* Fehlercode der letzten Operation */
extern BOOL XMSTreiber;                  /* != 0 wenn XMS-Treiber vorhanden */

extern void XMSCopy( int VonHandle, long VonOffset, int NachHandle, long NachOffset, WORD LenW);

#endif  /* _XMS_H */