#ifndef _MOUSE_OP_H
#define _MOUSE_OP_H

#include "typedef.h"
#include "glbl_set.h"

#define CODE_FILTER      0x80FF                  /* Filter fr Elemententyp */

#define FRAME            0x4000           /* Element darf eingerahmt werden */
#define KEY              0x2000     /* Element beinhaltet Tastenkombination */
#define MSG              0x1000       /* Element hat Meldung in einem Array */
#define DEFBUTTON        0x0800           /* Element wird zuerst Eingerahmt */
#define _IF              0x0400    /* Auswertung wenn Bedingung erfllt ist */
#define RETURN_INPUT     0x0200        /* Input kehrt nur bei RETURN zurck */
#define IGN_CASE         0x0100     /* Input ignoriert Gro/Kleinschreibung */

#define KLICKAREA        0x8000      /* Flche auf die geklickt werden kann */
#define PUSHAREA         0x8001       /* aktiv ohne Loslassen der Maustaste */
#define RADIOBUTTON      0x8002                 /* spezifiziert Radiobutton */
#define CHECKBOX         0x8003                    /* spezifiziert Checkbox */
#define MOVEWINDOW       0x8004           /* Fenster soll verschoben werden */
#define BUTTON           0x8005                        /* normaler Schalter */
#define BUTTON2          0x8006             /* Flche als normaler Schalter */
#define HOTAREA          0x8007   /* Flche wird durch Cursorberflug aktiv */
#define LAUFLEISTE       0x8008        /* Flche beinhaltet eine Laufleiste */
#define INPUT            0x8009        /* Flche stellt eine Inputzeile dar */
#define FILEINPUT        0x800A           /* Inputzeile mit Dateiauswahlbox */
#define DIRINPUT         0x800B           /* Inputzeile mit Verzeichnisbaum */
#define BUTTON3          0x800C      /* andere Flche als normaler Schalter */
#define ROLLBALKEN       0x800D                  /* spezifiziert Rollbalken */
#define TASTE            0xA00E        /* beinhaltet eine Tastenkombination */
#define INPUT_TABLE      0x800F           /* Inputzeile mit Pulldowntabelle */
#define DOUBLE_KLICKAREA 0x8010   /* auf Flche mu doppelt geklickt werden */
#define KLICK_TABLE      0x8011        /* nicht editierbare Pulldowntabelle */
#define NOT_USE_KEY      0xA012             /* liefert alle Tastenanschlge */
#define FILEINPUTNOBOX   0x8013          /* Inputzeile fr Dateien ohne Box */
#define DIRINPUTNOBOX    0x8014    /* Inputzeile mit Verzeichnisse ohne Box */
#define FILE_INPUT_TABLE 0x8015  /* Inputzeile mit Pulldowntabelle fr Dat. */
#define DIR_INPUT_TABLE  0x8016 /* Inputzeile mit Pulldowntabelle fr Verz. */

#define POINTER_ONE_UP    0          /* Konstanten des Elementes ROLLBALKEN */
#define POINTER_ONE_DOWN  1
#define POINTER_ONE_LEFT  0
#define POINTER_ONE_RIGHT 1
#define ONE_ELEMENT_UP    2
#define ONE_ELEMENT_DOWN  3
#define ONE_ELEMENT_LEFT  2
#define ONE_ELEMENT_RIGHT 3
#define ELEMENT_RANDOM    4
#define POINTER_RETURN    5

#define TAB_RET          0
#define MAUS_RET         1
#define TASTE_RET        2
#define INIT_RET         3

#define IGNORE_CASE      0x0001
#define VERZEICHNIS      0x0002
#define NORM_TEXT        0x0004

#define FUNC_RETURN	 0x0002

#define DEFAULT      0
#define INIT         -2     /* Initialisieren aller Elemente und Strukturen */
#define REINIT       -3               /* Wiederinitalisieren aller Elemente */
#define LWAUSWAHL    1

#define NOTHING      0                                   /* keine Maustaste */
#define LEFT         1                                   /* linke Maustaste */
#define RIGHT        2                                  /* rechte Maustaste */
#define MIDDLE       4                                /* mittlere Maustaste */
#define TWO          3                                  /* beide Maustasten */

#define WAITONLY     2            /* nur auf Loslassen der Maustaste warten */

#define ALT              0x4000
#define ALT_FILTER       0xBFFF
#define STRG             0x2000
#define STRG_FILTER      0xDFFF
#define SHIFT            0x1000
#define SHIFT_FILTER     0xEFFF
#define EXTENDED         0x0800
#define EXTENDED_FILTER  0xF7FF

#define SHIFT_PRESS      0x03
#define SHIFTLEFT_PRESS  0x02
#define SHIFTRIGHT_PRESS 0x01
#define ALT_PRESS        0x08
#define STRG_PRESS       0x04

enum{  DAT_INSTALLATIONSDATEN,
       ICO_FR,
       ICO_GRUPPE,
       ICO_OWNERBUTTON,
       PCX_ALARM,
       PCX_FRAGE,
       PCX_ATTRIBUTE_EINZELN,
       PCX_ATTRIBUTE,
       PCX_ATTRIBUTE_VOREINSTELLUNG,
       PCX_AUTOINSTALLATION,
       PCX_CDPLAYER,
       PCX_KOMMANDOZEILE,
       PCX_DATEIMANAGER,
       PCX_DATEIAUSWAHLBOX,
       PCX_FILTER,
       PCX_DATEISORTIERUNG,
       PCX_VERZEICHNISBAUM,
       PCX_DISKAUFFRISCHEN,
       PCX_DISKVERGLEICHEN,
       PCX_DISKKOPIEREN,
       PCX_DISKINFO,
       PCX_DISKLOESCHEN,
       PCX_DISKPRUEFEN,
       PCX_EDIT_MENU,
       PCX_BEENDEN,
       PCX_MEHR,
       PCX_FATINFO,
       PCX_FINDFILE,
       PCX_FINDTEXT,
       PCX_FORMATIEREN_1,
       PCX_FORMATIEREN_2,
       PCX_ZEIGE_ZEILE,
       PCX_GRUPPE_UMNENNEN,
       PCX_GRUPPENINSTALLATION,
       PCX_GRUPPE,
       PCX_ICONAUSWAHL,
       PCX_ICON_EXTRAHIEREN,
       PCX_INFO,
       PCX_KOPIEREN,
       PCX_KOP_VERS_FRAGE,
       PCX_DISKLABEL,
       PCX_EDITOR_LEISTE,
       PCX_EDITOR_VIEWER,
       PCX_VIEWER_LEISTE,
       PCX_LOESCHEN,
       PCX_LWANWAHL,
       PCX_LWAUSWAHL,
       PCX_PARAMETERFENSTER,
       PCX_PRG_START,
       PCX_PROGRAMM_GRUPPE_AUSWAHL,
       PCX_PROGRAMMINSTALLATION,
       PCX_PROGRAMMANAGER,
       PCX_SORTIEREN,
       PCX_PROGRAMM_UMNENNEN,
       PCX_Q_Z_INFO,
       PCX_RECHNER,
       PCX_RENAME_EINZELN,
       PCX_RENAME,
       PCX_RENAME_VOREINSTELLUNG,
       PCX_SB_VOLUME,
       PCX_FARBENSETZEN,
       PCX_MAUSEINSTELLUNGEN,
       PCX_EDITOR_SPEICHERN_UNTER,
       PCX_TEXT_SUCHEN,
       PCX_SYSTEMEINSTELLUNGEN,
       PCX_UHRSTELLEN,
       PCX_VERSCHIEBEN,
       PCX_VERSION,
       PCX_VERSCHIEDENES_SETZEN,
       PCX_VERZEICHNIS_ERSTELLEN,
       PCX_PRINT,
       PCX_VIEWFILTER,
       PCX_VIEWER_HEX_ASCII,
       TXT_FLEXLIBRARY_DEFAULT,
       VOC_ALARM,
       VOC_ERROR,
       VOC_READY,
       VOC_HINWEIS,
    };

enum{  ALT_A= EXTENDED| ALT| 30,
       ALT_B= EXTENDED| ALT| 48,
       ALT_C= EXTENDED| ALT| 46,
       ALT_D= EXTENDED| ALT| 32,
       ALT_E= EXTENDED| ALT| 18,
       ALT_F= EXTENDED| ALT| 33,
       ALT_G= EXTENDED| ALT| 34,
       ALT_H= EXTENDED| ALT| 35,
       ALT_I= EXTENDED| ALT| 23,
       ALT_J= EXTENDED| ALT| 36,
       ALT_K= EXTENDED| ALT| 37,
       ALT_L= EXTENDED| ALT| 38,
       ALT_M= EXTENDED| ALT| 50,
       ALT_N= EXTENDED| ALT| 49,
       ALT_O= EXTENDED| ALT| 24,
       ALT_P= EXTENDED| ALT| 25,
       ALT_Q= EXTENDED| ALT| 16,
       ALT_R= EXTENDED| ALT| 19,
       ALT_S= EXTENDED| ALT| 31,
       ALT_T= EXTENDED| ALT| 20,
       ALT_U= EXTENDED| ALT| 22,
       ALT_V= EXTENDED| ALT| 47,
       ALT_W= EXTENDED| ALT| 17,
       ALT_X= EXTENDED| ALT| 45,
       ALT_Y= EXTENDED| ALT| 21,
       ALT_Z= EXTENDED| ALT| 44,
       ALT_PAGE_UP   = EXTENDED| ALT| 153,
       ALT_PAGE_DOWN = EXTENDED| ALT| 161,
       ALT_POS1      = EXTENDED| ALT| 151,
       ALT_ENDE      = EXTENDED| ALT| 159 };

enum{  STRG_RETURN      = 10,          /* wird nur Programmintern verwendet */
       STRG_INSERT      = EXTENDED| STRG| 146,
       STRG_DELETE      = EXTENDED| STRG| 147,
       STRG_POS1        = EXTENDED| STRG| 119,
       STRG_ENDE        = EXTENDED| STRG| 117,
       STRG_CURSOR_UP   = EXTENDED| STRG| 141,
       STRG_CURSOR_DOWN = EXTENDED| STRG| 145,
       STRG_CURSOR_LEFT = EXTENDED| STRG| 115,
       STRG_CURSOR_RIGHT= EXTENDED| STRG| 116,
       STRG_PAGE_UP     = EXTENDED| STRG| 132,
       STRG_PAGE_DOWN   = EXTENDED| STRG| 118,
       STRG_TAB         = EXTENDED| STRG| 148,
       STRG_SHIFT_POS1  = EXTENDED| STRG| SHIFT| 119,
       STRG_SHIFT_ENDE  = EXTENDED| STRG| SHIFT| 117,
       STRG_K           = STRG| 11,
       STRG_D           = STRG| 4,
       STRG_ESC         = STRG| 27 };

enum{  SHIFT_TAB         = 15,         /* wird nur Programmintern verwendet */
       SHIFT_INSERT      = EXTENDED| SHIFT| 82,
       SHIFT_DELETE      = EXTENDED| SHIFT| 83,
       SHIFT_CURSOR_UP   = EXTENDED| SHIFT| 72,
       SHIFT_CURSOR_DOWN = EXTENDED| SHIFT| 80,
       SHIFT_CURSOR_LEFT = EXTENDED| SHIFT| 75,
       SHIFT_CURSOR_RIGHT= EXTENDED| SHIFT| 77,
       SHIFT_PAGE_UP     = EXTENDED| SHIFT| 73,
       SHIFT_PAGE_DOWN   = EXTENDED| SHIFT| 81,
       SHIFT_POS1        = EXTENDED| SHIFT| 71,
       SHIFT_ENDE        = EXTENDED| SHIFT| 79 };

enum{  F1       = EXTENDED| 59,
       F2       = EXTENDED| 60,
       F3       = EXTENDED| 61,
       F4       = EXTENDED| 62,
       F5       = EXTENDED| 63,
       F6       = EXTENDED| 64,
       F7       = EXTENDED| 65,
       F8       = EXTENDED| 66,
       F9       = EXTENDED| 67,
       F10      = EXTENDED| 68,
       F11      = EXTENDED| 133,
       F12      = EXTENDED| 134,
       SHIFT_F1 = EXTENDED| SHIFT| 84,
       SHIFT_F2 = EXTENDED| SHIFT| 85,
       SHIFT_F3 = EXTENDED| SHIFT| 86,
       SHIFT_F4 = EXTENDED| SHIFT| 87,
       SHIFT_F5 = EXTENDED| SHIFT| 88,
       SHIFT_F6 = EXTENDED| SHIFT| 89,
       SHIFT_F7 = EXTENDED| SHIFT| 90,
       SHIFT_F8 = EXTENDED| SHIFT| 91,
       SHIFT_F9 = EXTENDED| SHIFT| 92,
       SHIFT_F10= EXTENDED| SHIFT| 93,
       SHIFT_F11= EXTENDED| SHIFT| 135,
       SHIFT_F12= EXTENDED| SHIFT| 136,
       STRG_F1  = EXTENDED| STRG| 94,
       STRG_F2  = EXTENDED| STRG| 95,
       STRG_F3  = EXTENDED| STRG| 96,
       STRG_F4  = EXTENDED| STRG| 97,
       STRG_F5  = EXTENDED| STRG| 98,
       STRG_F6  = EXTENDED| STRG| 99,
       STRG_F7  = EXTENDED| STRG| 100,
       STRG_F8  = EXTENDED| STRG| 101,
       STRG_F9  = EXTENDED| STRG| 102,
       STRG_F10 = EXTENDED| STRG| 103,
       STRG_F11 = EXTENDED| STRG| 137,
       STRG_F12 = EXTENDED| STRG| 138,
	};

enum{  HOME=         EXTENDED| 71,
       END=          EXTENDED| 79,
       CURSOR_UP=    EXTENDED| 72,
       CURSOR_DOWN=  EXTENDED| 80,
       CURSOR_LEFT=  EXTENDED| 75,
       CURSOR_RIGHT= EXTENDED| 77,
       PAGE_UP=      EXTENDED| 73,
       PAGE_DOWN=    EXTENDED| 81,
       INSERT=       EXTENDED| 82,
       DELETE=       EXTENDED| 83,
       ESC=          27,
       RETURN=       13,
       BACKSPACE=     8,
       TAB=           9,
       SPACE=        32 };

#ifndef MS_DEF

#define MS_DEF

#include "savescr.h"

#define MAX_INTERN_TASTEN  25

typedef struct
	{
	   int *x, *y, xlength, ylength, spotanz, statsp;
	   char **msg, statzeile;
	   WORD *mauspos;
	   void **arg_ptr;
	   int framesp, frame_ptr_sp, frame_ret, frame_pos_at_element,
	       frame_msg_sp, anz_intern_Tasten, Last_mauspos, Last_arg_ptr,
	       Last_msg;
	   WORD intern_Tasten[ MAX_INTERN_TASTEN][ 4], dup_flag, duplicate;
	   char Taste_Maus;
	   saveall sa;
	}MAUSStruct;

#endif

extern WORD maus_pfeil[];        /* Cursor- und ScreenMask eines Mauspfeils */
extern WORD maus_nach[];
extern WORD maus_sanduhr[];
extern WORD File_DragDrop[];
extern WORD maus_text[];
extern void *last_maus_cursor;  /* Zeigt auf das momentane Mauscursor_Array */

#ifndef ROLLBALKEN_DEF

#define ROLLBALKEN_DEF

typedef struct{ int x, y, x_y;
		char lage;
		int minstep, maxstep;
		long min, max, proz;
		int greifx_y;
		char ret_val, button_flag;
		int maus_to_Zeiger_ref, Zeiger_pos;
		long proz_sp;
		void *button;
	      }RBalken;                       /* Struktur eines Rollbalkens */

#endif

typedef struct
	{
	   unsigned char Taste, Sondertaste;
	}not_use_key_struct;

struct MouseStat                      /* Speicher des letzten Mausstatusses */
       {
	  WORD x, y, buttons;
       };
extern struct MouseStat MStat;        /* Speicher des letzten Mausstatusses */
extern BOOL _InputInsert;

int __CheckMousepos( MAUSStruct *MS);
void ReinitWindow( MAUSStruct *MS);
void RBalken_Begin( MAUSStruct *MS, RBalken *RB);

#endif  /* _MOUSE_OP_H */
