/*  GLBL_SET.C  Saves and restores global settings
 *  Copyright (C) 1991-1998  Felix Ritter
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <graphics.h>
#include <dir.h>
#include <dos.h>
#include <stdio.h>
#include <string.h>
#include "pal_op.h"
#include "filemgr.h"
#include "mouse_op.h"

#define EINSTELLUNGEN_DATEIID  "DBDV2.50EINSTELLUNGEN"

char default_icon_path[ MAXDIR], editor_path[ MAXPATH]= "", anwender_prg[ MAXPATH]= "";

view_filter_struct l_DATWIN_VF= { AT_EGAL, AT_EGAL, AT_EGAL, AT_EGAL};

BOOL BOOL_save[ 13]= { 0, AN, AN, AN, AN, AUS, AUS, AN, AN, AN, FALSE, FALSE, FALSE};

char char_save[  5]= { 8, 5, EGA_BLACK, EGA_LIGHTBLUE, EGA_LIGHTCYAN};

BYTE BYTE_save[  9]= { PROGRAMM_MANAGER, GRP_vor_PRG, PUZZLE_SCHONER, DRAG_DROP_KOPIEREN,
		       SORT_FILE, SORT_FILE, 0, HD_35, SOUNDBLASTER};

WORD WORD_save[  1]= { 150};

int int_save[ 98]= {  10,  40,  50,   4, 150, 100,
		     150, 100, 150, 130, 150,  70,
		     150,  80, 320, 140,  40, 160,
		     100, 200, 320,  50, 136, 100,
		      30,  40, 250, 175, 190, 300,
		      75, 190, 300, 100, 160, 170,
		      30, 200, 300, 200, 200, 300,
		      40,  30, 200, 200, 200, 170,
		     250, 250, 150, 200, 200, 200,
		     100, 100, 200, 170, 200, 200,
		     200, 200, 300, 200, 198, 200,
		      80, 250, 250, 220, 400, 160,
		     286,  15, 100, 100, 430, 100,
		     200, 130, 280, 260, 150, 210,
		      85, 110, 100, 110, 200, 200,
		     260, 200, 203, 200,  60, 120,
		     200, 200};

void GRPdir_to_Anz( GRP_struct *GRP)
{
   char *tmp_ptr;

   if(( tmp_ptr= strrchr( GRP->gruppendir, '\\'))!= NULL)
   {
      *tmp_ptr= '\0';
      strcpy( GRP->gruppe, tmp_ptr+ 1);
   }
   else
   {
      strcpy( GRP->gruppe, GRP->gruppendir);
      *GRP->gruppendir= HGRP_ID;
   }
}

int RestoreSys_Temp( void)
{
   FILE *inhalt;
   struct dosdate_t d;
   int ret_val= 1;
   BOOL restore_exist= 0;
   char datei_ID[ sizeof( EINSTELLUNGEN_DATEIID)- 1];

   if( ExistDatei( "DB2_EINS.TMP"))
   {
      install= 1;
      restore_exist= 1;
   }
   else
   {
      if( ExistDatei( "EINSTELL.DB2"))
	 restore_exist= 1;
   }
   if( restore_exist)
   {
      if(( inhalt= fopen( prgexe_path, "rb"))!= NULL)
      {
	 if( fread( datei_ID, sizeof( datei_ID), 1, inhalt)== 1)
	 {
	    if( !strncmp( datei_ID, EINSTELLUNGEN_DATEIID, sizeof( EINSTELLUNGEN_DATEIID)- 1))
	    {
	       if(( fread( default_icon_path, sizeof( default_icon_path), 1, inhalt)!= 1)|| ( fread( OwnerButtonICO_ptr, GRP_MAXICONBYTES, 1, inhalt)!= 1)|| ( fread( anwender_prg, sizeof( anwender_prg), 1, inhalt)!= 1)|| ( fread( editor_path, sizeof( editor_path), 1, inhalt)!= 1)|| ( fread( ( *( GRP_struct *)GRP_struct_ptr).gruppendir, GRP_MAXGRUPPENDIR, 1, inhalt)!= 1)|| ( fread( &l_DATWIN_VF, sizeof( view_filter_struct), 1, inhalt)!= 1)|| ( fread( BOOL_save, sizeof( BOOL_save), 1, inhalt)!= 1)|| ( fread( char_save, sizeof( char_save), 1, inhalt)!= 1)|| ( fread( BYTE_save, sizeof( BYTE_save), 1, inhalt)!= 1)|| ( fread( WORD_save, sizeof( WORD_save), 1, inhalt)!= 1)|| ( fread( int_save, sizeof( int_save), 1, inhalt)!= 1))
	       {
		  ErrorMsg( READ_ERROR"EINSTELL.DB2 or DB2_EINS.TMP");
		  Info_Frage( 100, 200, "The installations could\nnot be read back\nproperly/at all.\nProblems may occur.", INFO);
		  ret_val= -1;
	       }
	       else
	       {
		  _dos_getdate( &d);
		  l_DATWIN_VF.nach_ff_fdate= l_DATWIN_VF.vor_ff_fdate= ( d.day& 0x1F)| (( d.month& 0x0F)<< 5)| ((( d.year- 1980)& 0x7F)<< 9);
		  l_DATWIN_VF.aktiv= AUS;
		  GRPdir_to_Anz( GRP_struct_ptr);
		  if( !install)
		     veraendert= 0;
		  ret_val= 0;
	       }
	       fclose( inhalt);
	    }
	 }
	 else
	    ErrorMsg( READ_ERROR"EINSTELL.DB2 or DB2_EINS.TMP");
      }
      else
	 ErrorMsg( OPEN_ERROR"EINSTELL.DB2 or DB2_EINS.TMP");
   }
   return( ret_val);               /* 0= o.k., 1= nicht gelesen, -1= Fehler */
}

int saveSystem( char *file)
{
   FILE *inhalt;
   int ret_val= 0;

   strcpy( prgexe_ptr, file);
   if(( inhalt= fopen( prgexe_path, "wb"))== NULL)
   {
      ErrorMsg( CREAT_ERROR"EINSTELL.DB2 or DB2_EINS.TMP");
      ret_val= -1;
   }
   else
   {
      if(( fwrite( EINSTELLUNGEN_DATEIID, sizeof( EINSTELLUNGEN_DATEIID)- 1, 1, inhalt)!= 1)|| ( fwrite( default_icon_path, sizeof( default_icon_path), 1, inhalt)!= 1)|| ( fwrite( OwnerButtonICO_ptr, GRP_MAXICONBYTES, 1, inhalt)!= 1)|| ( fwrite( anwender_prg, sizeof( anwender_prg), 1, inhalt)!= 1)|| ( fwrite( editor_path, sizeof( editor_path), 1, inhalt)!= 1)|| ( fwrite( ( *( GRP_struct *)GRP_struct_ptr).gruppendir, GRP_MAXGRUPPENDIR, 1, inhalt)!= 1)|| ( fwrite( &l_DATWIN_VF, sizeof( view_filter_struct), 1, inhalt)!= 1)|| ( fwrite( BOOL_save, sizeof( BOOL_save), 1, inhalt)!= 1)|| ( fwrite( char_save, sizeof( char_save), 1, inhalt)!= 1)|| ( fwrite( BYTE_save, sizeof( BYTE_save), 1, inhalt)!= 1)|| ( fwrite( WORD_save, sizeof( WORD_save), 1, inhalt)!= 1)|| ( fwrite( int_save, sizeof( int_save), 1, inhalt)!= 1))
      {
	 ErrorMsg( WRITE_ERROR"EINSTELL.DB2 or DB2_EINS.TMP");
	 ret_val= -1;
	 fclose( inhalt);
	 unlink( prgexe_path);
      }
      else
      {
	 fclose( inhalt);
	 veraendert= AUS;
      }
   }
   return( ret_val);
}

int SaveSysDial( void)
{
   int ret_val= 0, ret= 0;
   char *msg[]= { "Protect installations of the program",
		  "Quit Desktop     ",
		  "Return to desktop    " };
   WORD mauspos[]= { BUTTON| FRAME| KEY|            MSG,  74, 202,  35,  71, 's',
		     BUTTON| FRAME| KEY| DEFBUTTON| MSG,  25, 116,  87, 118, RETURN,
		     BUTTON| FRAME| KEY|            MSG, 126, 217,  87, 118, 'a',
		     MOVEWINDOW };
   MAUSStruct MS= { DEFAULT, DEFAULT, 243, 131, 4, INIT, NULL, AN};

   MS.x= &exitx;
   MS.y= &exity;
   MS.msg= msg;
   MS.mauspos= mauspos;
   if( veraendert)
   {
      PCX_Window( MS.x, MS.y, PCX_BEENDEN, &MS.sa, SHADOW);
      do
      {
	 switch( __CheckMousepos( &MS))
	 {
	    case 0:                                              /* Sichern */
	       ret_val= saveSystem( "EINSTELL.DB2");
	       break;
	    case 2:                                              /* Abbruch */
	       ret_val= 1;
	    case 1:                                                   /* OK */
	       ret= 1;
	       break;
	 }
      }while( !ret);
      ShowMouse( AUS);
      BigScreenRestore( &MS.sa, *MS.x, *MS.y);
      ShowMouse( AN);
   }
   return( ret_val);     /* 0== OK, 1== Abbruch */
}
