/*  FINDER.C  File finder
 *  Copyright (C) 1991-1998  Felix Ritter
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <dos.h>
#include <graphics.h>
#include <stdlib.h>
#include <conio.h>
#include <io.h>
#include <alloc.h>
#include <fcntl.h>
#include <process.h>
#include <sys\stat.h>
#include <string.h>
#include <time.h>
#include <dir.h>
#include <stdio.h>
#include <ctype.h>
#include "pal_op.h"
#include "filemgr.h"
#include "mouse_op.h"

extern BYTE Get_Call_mode( void);

#define TEXT_FIND      0
#define FILE_FIND      1
#define MAX_FINDTEXT   51
#define BUFSIZE        20000

int IsASCII( BYTE zeichen)
{
   switch( zeichen)
   {
      case 225:    /*  */
      case 129:    /*  */
      case 132:    /*  */
      case 148:    /*  */
      case 142:    /*  */
      case 153:    /*  */
      case 154:    /*  */
      case  32:    /* SPACE */
      case  13:    /* CR  */
      case  10:    /* LF  */
      case   9:    /* TAB */
	 return( 1);
      default:
	 return( isascii( zeichen)&& isprint( zeichen));
   }
}

typedef struct ffblk ffblk;
typedef struct ftime ftime;

#pragma warn -dup /* WARNUNG: 'Redefinition of 'macro' is not identical' unterdrcken */

#define TMP_ARRAY               ( char *)t_arg_ptr[ 0]
#define FILE_TEXT_FIND       ( *( BYTE *)t_arg_ptr[ 1])
#define IGNORE_CASE          ( *( BOOL *)t_arg_ptr[ 2])
#define FINDTEXT                ( char *)t_arg_ptr[ 3]
#define FINDER_FILE             ( FILE *)t_arg_ptr[ 4]
#define ANZ_FILE_FOUND       ( *( long *)t_arg_ptr[ 5])
#define ANZ_SPOTS_FOUND      ( *( long *)t_arg_ptr[ 6])
#define NEW_DIR_FLAG         ( *( BOOL *)t_arg_ptr[ 7])

#pragma warn +dup /* WARNUNG: 'Redefinition of 'macro' is not identical' erlauben */

BOOL isTxtFile( char *filename)
{
   FILE *file;
   BOOL txtfile= FALSE;
   BYTE buffer[ 150];
   void *old_maus_cursor= last_maus_cursor;
   unsigned nread, i= 0;

   PrintStatus( "Checking file format...");
   MouseArt( maus_sanduhr);
   if(( file= fopen( filename, "rb"))!= NULL)
   {
      if((( nread= fread( buffer, 1, 150, file))== 150)|| ( nread== filelength( fileno( file))))
      {
	 while( IsASCII( *( buffer+ i))&& ( i< nread))
	    i++;
	 txtfile= ( i>= ( nread- 1));
      }
      fclose( file);
   }
   MouseArt( old_maus_cursor);
   ClearStatus();
   return( txtfile);
}

long _textfind( void **t_arg_ptr, ffblk *ffblk_ptr)
{
   FILE *dat;
   char suchstr[ MAX_FINDTEXT];
   BYTE *mem_ptr;
   BOOL bindatei;
   unsigned numread, i= 0, crpos, z, startpos, znr, suchlen, suchndx= 0;
   long off, k, treffer= 0;

   if(( mem_ptr= malloc( BUFSIZE))!= NULL)
   {
      suchlen= stpcpy( suchstr, FINDTEXT)- suchstr;
      if( IGNORE_CASE)
	 strupr( suchstr);
      if(( dat= fopen( ffblk_ptr->ff_name, "rb"))!= NULL)
      {
	 if((( numread= fread( mem_ptr, 1, 256, dat))== 256)|| ( numread== filelength( fileno( dat))))
	 {
	    while( IsASCII( *( mem_ptr+ i))&& ( i< numread))
	       i++;
	    ( i< ( numread- 1)) ? ( bindatei= 1) : ( bindatei= 0);
	    rewind( dat);
	    znr= 1;                               /* Zeilennr fr Textdatei */
	    off= 0;                                /* Offset fr Binrdatei */
	    crpos= 0;                        /* Anfangsindex des letzten CR */
	    do
	    {
	       if( Break( 200, 275, "Really abort\ncurrent function?"))
		  treffer= -2;
	       else
	       {
		  numread= fread( mem_ptr, 1, BUFSIZE, dat);
		  i= 0;
		  while(( numread> 0)&& ( i<= numread))
		  {
		     if( *( suchstr+ suchndx)== ( ( IGNORE_CASE) ? ( toupper( *( mem_ptr+ i))) : ( *( mem_ptr+ i))))
		     {
			if( suchndx== ( suchlen- 1))
			{
			   if( treffer== 0)   /* erster Treffer in der Datei ? */
			   {
			      if( NEW_DIR_FLAG)
			      {
				 fprintf( FINDER_FILE, "\n %s \n", TMP_ARRAY);
				 NEW_DIR_FLAG= 0;
			      }
			      fprintf( FINDER_FILE, "           %-12s %9ld bytes  %02d.%02d.%02d  %02d:%02d\n", ffblk_ptr->ff_name, ffblk_ptr->ff_fsize, ffblk_ptr->ff_fdate& 0x1F, ( ffblk_ptr->ff_fdate>> 5)& 0xF, ( ffblk_ptr->ff_fdate>> 9)+ 80, ffblk_ptr->ff_ftime>> 11, ( ffblk_ptr->ff_ftime>> 5)& 0x3F);
			   }
			   suchndx= 0;             /* Nach Treffer Rcksetzen */
			   if( !bindatei)
			   {
			      fprintf( FINDER_FILE, "           -   line :  %7d: ", znr);
			      k= crpos;
			      while(( k<= numread)&& ( *( mem_ptr+ k)!= '\r')&& ( k<= crpos+ 40))
				 putc( *( mem_ptr+ k++), FINDER_FILE);
			   }
			   else
			   {
			      fprintf( FINDER_FILE, "           -  Offset:  %7ld: ", off);
			      k= i- suchlen;
			      while(( k<= numread)&& ( k<= i- suchlen+ 34))
			      {
				 putc(( ( IsASCII( *( mem_ptr+ k))&& ( *( mem_ptr+ k)!= '\r')&& ( *( mem_ptr+ k)!= '\n')) ? ( *( mem_ptr+ k)) : ( '.')), FINDER_FILE);
				 k++;
			      }
			   }
			   fprintf( FINDER_FILE, "\n");
			   treffer++;
			}
			else
			   suchndx++;
		     }
		     else
		     {
			if( suchndx> 0)                     /* if( suchndx> 1) */
			   suchndx= 0;
			if( !bindatei)
			{
			   if( *( mem_ptr+ i)== '\n')
			   {
			      znr++;
			      crpos= i+ 1;
			   }
			}
		     }
		     i++;
		     off++;
		  }
	       }
	    }
	    while(( numread> 0)&& ( treffer>= 0));
	 }
	 else
	    treffer= -1;
	 fclose( dat);
      }
      else
	 treffer= -1;
      free( mem_ptr);
   }
   else
      treffer= -1;
   if( treffer== -1)
      fprintf( FINDER_FILE, " Error in file %s!!!\n", ffblk_ptr->ff_name);
   if( treffer> 0)
   {
      ANZ_SPOTS_FOUND+= treffer;
      ANZ_FILE_FOUND++;
   }
   return( treffer);     /* -2 -> Break */
}

int _findTexttree( void **t_arg_ptr, ffblk *ffblk_ptr)
{
   long result;

   if( Get_Call_mode()== FILE_SEARCH)
   {
      if( FILE_TEXT_FIND== FILE_FIND)
      {
	 if( NEW_DIR_FLAG)
	 {
	    fprintf( FINDER_FILE, "\n %s \n", TMP_ARRAY);
	    NEW_DIR_FLAG= 0;
	 }
	 fprintf( FINDER_FILE, "           %-12s %9ld bytes  %02d.%02d.%02d  %02d:%02d\n", ffblk_ptr->ff_name, ffblk_ptr->ff_fsize, ffblk_ptr->ff_fdate& 0x1F, ( ffblk_ptr->ff_fdate>> 5)& 0xF, ( ffblk_ptr->ff_fdate>> 9)+ 80, ffblk_ptr->ff_ftime>> 11, ( ffblk_ptr->ff_ftime>> 5)& 0x3F);
	 if(( ++ANZ_FILE_FOUND% 5)== 0)
	 {
	    sprintf( TMP_ARRAY, "%7ld", ANZ_FILE_FOUND);
	    MOverTextxy( ffx+ 100, ffy+ 292, TMP_ARRAY, 7);
	 }
      }
      else
      {
	 if(( result= _textfind( t_arg_ptr, ffblk_ptr))> 0)
	 {
	    sprintf( TMP_ARRAY, "%7ld", ANZ_SPOTS_FOUND);
	    MOverTextxy( ffx+ 100, ffy+ 292, TMP_ARRAY, 7);
	 }
	 else
	 {
	    if( result== -2)                                       /* Break */
	       return( -1);
	 }
      }
   }
   else
   {
      getcwd( TMP_ARRAY, MAXDIR);
      NEW_DIR_FLAG= 1;
   }
   return( 0);
}

int _Finder( void)
{
   FILE *finder_file= NULL;
   int ret= 0, ret_val= 0, i, X_tree= 300, anzlw= 1, X_lw= 190, Y_lw= 200;
   char Suchmuster[ 13]= "*.*", start_dir[ MAXDIR]= "", Findtext[ MAX_FINDTEXT]= "", Ergebnisdatei[ MAXPATH]= "FINDERXXXXXX",
	Ignore_case= 1, Saveergebnis= 0, lw[ 26], tmp_array[ MAXPATH];
   long anz_file_found= 0L, anz_spots_found= 0L;
   BOOL new_dir_flag= 0;
   BYTE file_text_find;
   void *arg_ptr[ 7], *t_arg_ptr[ 8];
   WORD mauspos[]= { BUTTON|   FRAME| KEY,              5,  27,   5,  21, ESC,
		     INPUT| IGN_CASE|    FRAME| KEY| DEFBUTTON,  18,  44, 144,  12, 'd',
		     DIRINPUT| IGN_CASE| FRAME| KEY,             18,  79, 273, MAXDIR- 1, 245, 37, LWAUSWAHL, 'v',
		     INPUT|    FRAME| KEY,             18, 122, 273, MAX_FINDTEXT- 1, 't',
		     CHECKBOX| FRAME| KEY,             18, 145, 'g',
		     CHECKBOX| FRAME| KEY,             18, 164, 'e',
		     FILEINPUTNOBOX| IGN_CASE| FRAME| KEY,       70, 182, 221, MAXPATH- 1, 'n',
		     BUTTON|   FRAME| KEY,             34, 103, 223, 275, 's',
		     BUTTON|   FRAME| KEY,            120, 189, 223, 275, 'x',
		     BUTTON|   FRAME| KEY,            206, 275, 223, 275, 'a',
		     MOVEWINDOW };
   MAUSStruct MS= { DEFAULT, DEFAULT, 310, 310, 11, INIT, NULL, AUS};

   mktemp( Ergebnisdatei);
   arg_ptr[ 0]= Suchmuster;
   arg_ptr[ 1]= start_dir;
   arg_ptr[ 2]= &X_tree;
   arg_ptr[ 3]= Findtext;
   arg_ptr[ 4]= &Ignore_case;
   arg_ptr[ 5]= &Saveergebnis;
   arg_ptr[ 6]= Ergebnisdatei;
   MS.x= &ffx;
   MS.y= &ffy;
   MS.mauspos= mauspos;
   MS.arg_ptr= arg_ptr;
   PCX_Window( MS.x, MS.y, PCX_FINDTEXT, &MS.sa, SHADOW);
   do
   {
      switch( __CheckMousepos( &MS))
      {
	 case 7:                                              /* Dateisuche */
	    file_text_find= FILE_FIND;
	    MOverTextxy( *MS.x+ 12, *MS.y+ 292, "Matched          0 times       ", 35);
	    goto GO;
	 case 8:                                               /* Textsuche */
	    if( *Findtext== '\0')
	    {
	       Hinweis( "Keinen Text zum Suchen definiert");
	       continue;
	    }
	    file_text_find= TEXT_FIND;
	    MOverTextxy( *MS.x+ 12, *MS.y+ 292, "Text matched     0 times       ", 35);
	    GO:
	    ;
	    ret_val= 0;
	    if( !Saveergebnis)
	    {
	       *prgexe_ptr= '\0';
	       strcpy( stpcpy( Ergebnisdatei, prgexe_path), "FINDERXXXXXX");
	       mktemp( Ergebnisdatei+ ( prgexe_ptr- prgexe_path));
	    }
	    if(( finder_file= fopen( Ergebnisdatei, "wt"))== NULL)
	    {
	       ErrorMsg( CREAT_ERROR"'Results file'");
	       continue;
	    }
	    if( file_text_find== FILE_FIND)
	       fprintf( finder_file, " The file (search pattern) '%s' is in the following directories:      \n", Suchmuster);
	    else
	       fprintf( finder_file, " The text '%s' is in the following files:         \n", Findtext);
	    t_arg_ptr[ 0]= tmp_array;
	    t_arg_ptr[ 1]= &file_text_find;
	    t_arg_ptr[ 2]= &Ignore_case;
	    t_arg_ptr[ 3]= Findtext;
	    t_arg_ptr[ 4]= finder_file;
	    t_arg_ptr[ 5]= &anz_file_found;
	    t_arg_ptr[ 6]= &anz_spots_found;
	    t_arg_ptr[ 7]= &new_dir_flag;
	    if( *start_dir== '\0')
	    {
	       memset( lw, 0, sizeof( lw));
	       if(( anzlw= LW_Anwahl( &X_lw, &Y_lw, lw, "Select all drives to be searched                         ", NOTHING, ALL_DRIVES))> 0)
	       {
		  for( i= 0; i< anzlw; i++)
		  {
		     if(( ret_val= LW_TREE_Funktion( lw[ i], Suchmuster, _findTexttree, t_arg_ptr, DIR_SEARCH_VOR| FILE_SEARCH))!= 0)
			break;
		  }
	       }
	    }
	    else
	       ret_val= TREE_Funktion( start_dir, Suchmuster, _findTexttree, t_arg_ptr, DIR_SEARCH_VOR| FILE_SEARCH);
	    if( file_text_find== FILE_FIND)
	       fprintf( finder_file, "\n The file (search pattern) has been found %ld times", anz_file_found);
	    else
	       fprintf( finder_file, "\n The text has been found %ld times in %ld files ", anz_spots_found, anz_file_found);
	    fclose( finder_file);
	    if( anzlw> 0)
	    {
	       switch( ret_val)
	       {
		  case 0:                                        /* alles o.k. */
		     ReadySound();
		     _Editor_Viewer( Ergebnisdatei, VIEW_ASCII, NULL);
		     break;
		  case -3:                  /* falsches Verzeichnis eingegeben */
		  case -4:
		     ErrorMsg( "Could not change to the given directory");
		     break;
	       }
	    }
	    else
	       ret_val= -1;
	    if(( ret_val!= 0)|| ( !Saveergebnis))   /* Fehler aufgetreten ? */
	       unlink( Ergebnisdatei);
	    break;
	 case 0:                                                     /* ESC */
	 case 9:                                                 /* Abbruch */
	    ret= 1;
	    break;
      }
   }while( !ret);
   ShowMouse( AUS);
   BigScreenRestore( &MS.sa, *MS.x, *MS.y);
   ShowMouse( AN);
   return( Saveergebnis);                        /* 1-> Datei wurde erzeugt */
}
