/*  FILEMGR.C  File manager
 *  Copyright (C) 1991-1998  Felix Ritter
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <dos.h>
#include <graphics.h>
#include <stdlib.h>
#include <conio.h>
#include <io.h>
#include <alloc.h>
#include <fcntl.h>
#include <stdio.h>
#include <process.h>
#include <sys\stat.h>
#include <string.h>
#include <time.h>
#include <dir.h>
#include <direct.h>
#include <bios.h>
#include <ctype.h>
#include "pal_op.h"
#include "filemgr.h"
#include "mouse_op.h"
#include "xms.h"

#define DIRECTORYBEZEICHNUNG  "> DIR <"
#define FESTANW               20
#define UNSICHTBAR            2
#define NOREVERSE             0
#define KOPIEREN              0
#define VERSCHIEBEN           1
#define UMBENENNEN            2
#define MARKIEREN             0
#define RENAME                1
#define MAX_PATH_TAB_ENTRY    5
#define MIN_X_LEFT_DIR        12
#define MAX_X_LEFT_DIR        349
#define MIN_Y_LEFT_DIR        99
#define MAX_Y_LEFT_DIR        322
#define X_LEFT_DIR_TASTEN     354
#define MIN_X_RIGHT_DIR       386
#define MAX_X_RIGHT_DIR       606
#define MIN_Y_RIGHT_DIR       99
#define MAX_Y_RIGHT_DIR       322
#define X_RIGHT_DIR_TASTEN    611
#define X_TO_DIRANF_L         3
#define X_TO_DIREND_L         335
#define X_TO_TASTANF_L        342
#define X_TO_DIRANF_R         3
#define X_TO_DIREND_R         215
#define X_TO_TASTANF_R        225
#define DIRBEZEICHNUNGS_POS   14
#define FILEEXT_POS           10
#define SYS_ATTRIBUT_POS      25
#define SYS_FILE              10
#define XREF_DATEIAUSWFENSTER 17
#define YREF_DATEIAUSWFENSTER 100
#define ENTRY_LENGTH          42

#define ANWAHL                0
#define RENAME                1

#define NICHT_BEARBEITEN      '@'
#define ABGEWAEHLT            0
#define ANGEWAEHLT            1
#define GELOESCHT             2
#define NEU_DAZU              3

char newbaum[ 26];
char aktivwindow= LEFT, Sort_Typ;
extended_DatManag_struct *_extDatManag= NULL;

extern WORD Is_Window_EXE( char *file);
extern unsigned Text_Imagesize( void);
extern int cmps( char **elem1, char **elem2);                   /* FRMAIN.C */
extern char *MakeShowPath( char *, char *, int);

extern view_filter_struct l_DATWIN_VF;

extern void *ButtonDown( int x1, int y1, int x2, int y2);
extern void ButtonUp( void *mem_ptr, int x1, int y1, int x2, int y2);

void Datum( int x, int y, char *dir);
void _View_Filter( DATWINStruct *l_DW, MAUSStruct *d_MS, char *l_path_tab_ptr[]);

long Get_Datsize( char *entry)
{
   char entry_sp[ 8];

   strncpy( entry_sp, &entry[ 14], 7);
   entry_sp[ 7]= '\0';
   if( entry_sp[ 6]== 'M')                               /* Angabe in MByte */
   {
      entry_sp[ 5]= '\0';
      return( ( long)( atof( entry_sp)* 1048576.0));
   }
   else
      return( atol( entry_sp));
}

char Art_of_Entry( char *direntry)
{
   int i;

   typedef struct
	   {
	      char *bez;
	      char  val;
	   }F_EXT_struct;

   F_EXT_struct F_EXT[]= { "EXE", EXE,
			   "COM", COM,
			   "BAT", BAT,
			   "TXT", TXT,
			   "DOC", TXT,
			   "CPP", TXT,
			   "C  ", TXT,
			   "H  ", TXT,
			   "INC", TXT,
			   "ASM", TXT,
			   "PAS", TXT,
			   "PCX", PCX,
			   "BMP", BMP,
			   "ICO", ICO,
			   "VOC", VOC,
			   "WAV", WAV,
			 };

   if( !strncmp( direntry+ DIRBEZEICHNUNGS_POS, DIRECTORYBEZEICHNUNG, sizeof( DIRECTORYBEZEICHNUNG)- 1))
      return( DIR);
   for( i= 0; i< ( sizeof( F_EXT)/ sizeof( F_EXT_struct)); i++)
      if( strncmp( direntry+ FILEEXT_POS, F_EXT[ i].bez, 3)== 0)
	 return( F_EXT[ i].val);
   return( -1);
}

void ClearFileIcon( int x, int y)
{
   setfillstyle( SOLID_FILL, EGA_LIGHTGRAY);
   bar( x, y, x+ 8, y+ 8);
}

void FileIcon( int x, int y, char *direntry, BOOL mark)
{
   sFlex  *flex_ptr= FlexTable;
   size_t  cmpLen;

   if( *direntry!= NICHT_BEARBEITEN)
   {
      if( strncmp( direntry+ DIRBEZEICHNUNGS_POS, DIRECTORYBEZEICHNUNG, sizeof( DIRECTORYBEZEICHNUNG)- 1)== 0)
      {
	 if( mark)
	 {
	    setfillstyle( SOLID_FILL, EGA_RED);
	    bar( x+ 1, y+ 2, x+ 7, y+ 8);
	 }
	 setcolor( EGA_BLACK);
	 line( x+ 8, y+ 2, x+ 8, y+ 7);
	 line( x+ 8, y+ 8, x   , y+ 8);
	 line( x+ 1, y+ 1, x+ 4, y+ 1);
	 line( x+ 5, y+ 2, x+ 7, y+ 2);
	 line( x   , y+ 7, x   , y+ 2);
	 setcolor( EGA_DARKGRAY);
	 line( x+ 9, y+ 3, x+ 9, y+ 8);
	 line( x+ 9, y+ 9, x+ 1, y+ 9);
	 setcolor( ( mark) ? EGA_LIGHTRED : EGA_WHITE);
	 line( x+ 1, y+ 2, x+ 1, y+ 7);
	 line( x+ 2, y+ 2, x+ 4, y+ 2);
	 line( x+ 5, y+ 3, x+ 7, y+ 3);
      }
      else
      {
	 if( mark)
	 {
	    setfillstyle( SOLID_FILL, EGA_RED);
	    bar( x+ 4, y+ 1, x+ 7, y+ 3);
	    bar( x+ 1, y+ 4, x+ 7, y+ 8);
	 }
	 setcolor( EGA_BLACK);
	 line( x+ 8, y+ 1, x+ 8, y+ 8);
	 line( x+ 8, y+ 9, x   , y+ 9);
	 line( x+ 3, y   , x+ 8, y   );
	 line( x   , y+ 8, x   , y+ 3);
	 line( x+ 1, y+ 3, x+ 3, y+ 3);
	 line( x+ 3, y+ 2, x+ 3, y+ 1);
	 line( x+ 1, y+ 2, x+ 2, y+ 1);
	 setcolor( EGA_DARKGRAY);
	 line( x+ 9, y+  2, x+ 9, y+  9);
	 line( x+ 9, y+ 10, x+ 1, y+ 10);
	 setcolor( ( mark) ? EGA_LIGHTRED : EGA_WHITE);
	 line( x+ 1, y+ 4, x+ 1, y+ 8);
	 line( x+ 4, y+ 1, x+ 7, y+ 1);
	 line( x+ 2, y+ 2, x+ 2, y+ 2);
	 if( FlexTable)
	 {
	    while( flex_ptr)
	    {
	       if(( strncmp( direntry+ FILEEXT_POS, flex_ptr->filter+ 2, cmpLen= strcspn( direntry+ FILEEXT_POS, " "))== 0)&&
		  ( *( flex_ptr->filter+ 2+ cmpLen)== '\0'))
	       {
		  setcolor( ( mark) ? EGA_BLACK : EGA_LIGHTBLUE);
		  line( x+ 5, y+ 3, x+ 6, y+ 3);
		  line( x+ 2, y+ 5, x+ 2, y+ 5);
		  line( x+ 4, y+ 5, x+ 6, y+ 5);
		  line( x+ 2, y+ 7, x+ 6, y+ 7);
		  break;
	       }
	       flex_ptr= flex_ptr->next;
	    }
	 }
      }
   }
}

char *Path_to_Dir( char *dir, char *path)
{
   char *tmp_ptr;

   if(( tmp_ptr= strrchr( path, '\\'))!= NULL)
   {
      *( strncpy( dir, path, tmp_ptr- path)+ ( tmp_ptr- path))= '\0';
      if( *( dir+ 2)== '\0')
	 strcat( dir, "\\");
   }
   else
      *dir= '\0';
   return( dir);
}

char *Get_Filter( char *filter_sp, char *path)
{
   char *tmp_ptr;

   if(( tmp_ptr= strrchr( path, '\\'))!= NULL)
      strcpy( filter_sp, tmp_ptr+ 1);
   else
      strcpy( filter_sp, "*.*");
   return( filter_sp);
}

char *Paste_Filter_to_Dir( char *dir, char *filter)
{
   if( *( dir+ strlen( dir)- 1)!= '\\')
      strcat( dir, "\\");
   strcat( dir, filter);
   return( dir);
}

BOOL _Filter( char *file, char *filter, int r_a)
{
   int i;
   BOOL zutreffend= TRUE;
   char filesp[]= "        .   ", filtersp[]= "????????.???", *ptr, *flag, *eptr, *fptr;

   if(( flag= ptr= strchr( file, '.'))== NULL)
      ptr= file+ strlen( file);
   strncpy( filesp, file, ptr- file);
   if( flag)
      strncpy( filesp+ 9, ptr+ 1, strlen( file)- ( ptr- file)- 1);
   if(( flag= ptr= strchr( filter, '.'))== NULL)
   {
      ptr= filter+ strlen( filter);
      strnset( filtersp+ 9, SPACE, 3);
   }
   if( *( ptr- 1)!= '*')
      strnset( filtersp, SPACE, 8);
   strncpy( filtersp, filter, ptr- filter);
   if( flag)
   {
      if( *( filter+ strlen( filter)- 1)!= '*')
	 strnset( filtersp+ 9, SPACE, 3);
      strncpy( filtersp+ 9, ptr+ 1, strlen( filter)- ( ptr- filter)- 1);
   }
   else
      strnset( filtersp+ 9, SPACE, 3);
   if( r_a== RENAME)
   {
      for( i= 0; i< 12; i++)
      {
	 if(( filtersp[ i]== '*')|| ( filtersp[ i]== '?'))
	    file[ i]= filesp[ i];
	 else
	    file[ i]= filtersp[ i];
      }
      file[ 12]= '\0';
      if(( eptr= strchr( file+ 9, SPACE))!= NULL)
      {
	 if( eptr== ( file+ 9))
	    eptr--;
	 *eptr= '\0';
      }
      if(( eptr= strchr( file, SPACE))!= NULL)
      {
	 fptr= strrchr( eptr, SPACE);
	 memmove( eptr, fptr+ 1, strlen( fptr));
      }
   }
   else
   {
      for( i= 0; i< 12; i++)
      {
	 if(( filtersp[ i]!= '*')&& ( filtersp[ i]!= '?')&& ( filtersp[ i]!= filesp[ i]))
	 {
	    zutreffend= FALSE;
	    break;
	 }
      }
   }
   return( zutreffend);
}

int Sortfilter( char **elem1, char **elem2)
{
   char ret, val_elem1;

   if(( ret= ((( val_elem1= strncmp( *elem1+ DIRBEZEICHNUNGS_POS, DIRECTORYBEZEICHNUNG, sizeof( DIRECTORYBEZEICHNUNG)- 1))!= 0)- ( strncmp( *elem2+ DIRBEZEICHNUNGS_POS, DIRECTORYBEZEICHNUNG, sizeof( DIRECTORYBEZEICHNUNG)- 1)!= 0)))== 0)
   {
      if( !val_elem1)                                    /* zwei Directorys */
	 ret= strcmp( *elem1+ 1, *elem2+ 1);
      else
      {
	 switch( Sort_Typ)
	 {
	    case SORT_SIZE:
	       if(( ret= ( *( *elem1+ 20)== 'M'))== ( *( *elem2+ 20)== 'M')) /* Megabytes */
	       {
		  if(( ret= memcmp( *elem1+ 14, *elem2+ 14, 7))!= 0) /* Dateien sind unterschiedlich gro */
		     return( ret);
	       }
	       else
	       {
		  if( ret)
		     return( 1);
		  else
		     return( -1);
	       }
	       goto FILE_NAME;
	    case SORT_EXT:
	       if(( ret= memcmp( *elem1+ 10, *elem2+ 10, 3))!= 0)  /* Extensionen ungleich */
		  return( ret);
	    case SORT_FILE:
	       FILE_NAME:
	       ;
	       return( memcmp( *elem1+  1, *elem2+  1, 12));
	    case SORT_DATE:
	       if( !( ret= memcmp( *elem1+ 33, *elem2+ 33, 2)))         /* Jahre gleich */
	       {
		  if( !( ret= memcmp( *elem1+ 30, *elem2+ 30, 2)))      /* Monate gleich */
		  {
		     if(( ret= memcmp( *elem1+ 27, *elem2+ 27, 2))!= 0) /* Tage ungleich */
			return( ret);
		  }
		  else
		     return( ret);
	       }
	       else
		  return( ret);
	       goto FILE_NAME;
	    case SORT_TIME:
	       if(( ret= memcmp( *elem1+ 36, *elem2+ 36, 5))!= 0)  /* Zeit ungleich */
		  return( ret);
	       goto FILE_NAME;
	 }
      }
   }
   return( ret);
}

int Entry_find( char **elem1, char **elem2)
{
   return( strncmp( *elem1+ 1, *elem2+ 1, 12));
}

void FreeArray( DATWINStruct *DW)
{
   int i;

   for( i= 0; i< DW->RB->max; i++)
   {
      if( DW->dir_entrys[ i]!= NULL)
      {
	 free( DW->dir_entrys[ i]);
	 DW->dir_entrys[ i]= NULL;
      }
   }
}

int Read_DirEntrys( DATWINStruct *o_DW)
{
   RBalken RB;
   DATWINStruct DW;
   typedef int ( *fcmp) ( const void *, const void *);
   struct textsettingstype text;
   struct ffblk ffblk;
   BOOL _filter;
   size_t anz_elem;
   int dir_entry, anz_directorys, ret_val= 0, cmp_dir;
   char dat_suchweg[ MAXDIR+ DW_MAXFILTER], tmp_array[ MAXDIR+ DW_MAXFILTER], *tmp_ptr, **find, *filter_ptr, filter_sp[ MAXDIR+ DW_MAXFILTER];

   DW.RB= &RB;
   anz_elem= o_DW->RB->max;
   o_DW->anz_mark= 0;
   o_DW->gesbyte_mark= 0L;
   if(( cmp_dir= stricmp( Path_to_Dir( dat_suchweg, o_DW->verzeichnis), Path_to_Dir( tmp_array, o_DW->old_verzeichnis)))!= 0)
      FreeArray( o_DW);
   PrintStatus( "Reading and sorting files ...       ");
   ShowMouse( AUS);
   if( o_DW->Win_Typ== LEFT)
      ClearTextN( *o_DW->X+ XREF_DATEIAUSWFENSTER+ 10, *o_DW->Y+ YREF_DATEIAUSWFENSTER+ 231, 39);
   else
      ClearTextN( *o_DW->X+ XREF_DATEIAUSWFENSTER+  6, *o_DW->Y+ YREF_DATEIAUSWFENSTER+ 231, 26);
   ShowMouse( AN);
   dir_entry= findfirst( Paste_Filter_to_Dir( dat_suchweg, "*.*"), &ffblk, FA_DIREC| FA_RDONLY| FA_HIDDEN| FA_SYSTEM| FA_ARCH);
   while( !dir_entry&& ( *ffblk.ff_name== '.'))  /* '.' und '..' berspringen */
      dir_entry= findnext( &ffblk);
   for( DW.RB->max= 0L, anz_directorys= 0; !dir_entry&& ( DW.RB->max< 999L); )
   {
      if( !l_DATWIN_VF.aktiv|| ( ffblk.ff_attrib& FA_DIREC)|| (
	(( l_DATWIN_VF.Archiv== AT_EGAL)|| ( l_DATWIN_VF.Archiv== (( ffblk.ff_attrib& FA_ARCH)>> 5)& 0x01))&&
	(( l_DATWIN_VF.Hidden== AT_EGAL)|| ( l_DATWIN_VF.Hidden== (( ffblk.ff_attrib& FA_HIDDEN)>> 1)& 0x01))&&
	(( l_DATWIN_VF.RDonly== AT_EGAL)|| ( l_DATWIN_VF.RDonly==  ( ffblk.ff_attrib& FA_RDONLY)& 0x01))&&
	(( l_DATWIN_VF.System== AT_EGAL)|| ( l_DATWIN_VF.System== (( ffblk.ff_attrib& FA_SYSTEM)>> 2)& 0x01))&&
	 ( !l_DATWIN_VF.nach_Datum|| ( ffblk.ff_fdate>= l_DATWIN_VF.nach_ff_fdate))&&
	 ( !l_DATWIN_VF.vor_Datum|| ( ffblk.ff_fdate<= l_DATWIN_VF.vor_ff_fdate))))
      {
	 if(( _filter= (( ffblk.ff_attrib& FA_DIREC)!= 0))== TRUE)
	 {
	    if(( DW.dir_entrys[ DW.RB->max]= malloc( ENTRY_LENGTH))!= NULL)
	    {
	       sprintf( DW.dir_entrys[ DW.RB->max], "@%-12s "DIRECTORYBEZEICHNUNG" .... ", ffblk.ff_name);
	       anz_directorys++;
	    }
	    else
	    {
	       ret_val= -1;
	       break;
	    }
	 }
	 else
	 {
	    filter_ptr= strtok( Get_Filter( filter_sp, o_DW->verzeichnis), ";,");
	    while( filter_ptr)
	    {
	       if( strlen( filter_ptr)<= ( MAXFILE- 1+ MAXEXT- 1))
		  _filter|= _Filter( ffblk.ff_name, filter_ptr, ANWAHL);

	       filter_ptr= strtok( NULL, ";,");
	    }
	    if( _filter)
	    {
	       if(( DW.dir_entrys[ DW.RB->max]= malloc( ENTRY_LENGTH))!= NULL)
	       {
		  if( ffblk.ff_fsize> 9999999L)
		     sprintf( DW.dir_entrys[ DW.RB->max], "@             %5.1f M .... ", ( float)ffblk.ff_fsize/ ( float)1048576L);
		  else
		     sprintf( DW.dir_entrys[ DW.RB->max], "@             %7ld .... ", ffblk.ff_fsize);
		  if(( tmp_ptr= strchr( ffblk.ff_name, '.'))!= NULL)
		  {
		     memcpy( DW.dir_entrys[ DW.RB->max]+ 1, ffblk.ff_name, tmp_ptr- ffblk.ff_name);
		     memcpy( DW.dir_entrys[ DW.RB->max]+ 10, tmp_ptr+ 1, strchr( tmp_ptr+ 1, '\0')- ( tmp_ptr+ 1));
		  }
		  else
		     memcpy( DW.dir_entrys[ DW.RB->max]+ 1, ffblk.ff_name, strchr( ffblk.ff_name, '\0')- ffblk.ff_name);
	       }
	       else
	       {
		  ret_val= -1;
		  break;
	       }
	    }
	 }
	 if( _filter)
	 {
	    sprintf( DW.dir_entrys[ DW.RB->max]+ 27, "%2u.%.2u.%2u %2u:%.2u", ffblk.ff_fdate& 0x001F, ( ffblk.ff_fdate& 0x01E0)>> 5, ((( ffblk.ff_fdate& 0xFE00)>> 9)> 19) ? ( 80) : ((( ffblk.ff_fdate& 0xFE00)>> 9)+ 80), ( ffblk.ff_ftime& 0xF800)>> 11, ( ffblk.ff_ftime& 0x07E0)>> 5);
	    if( ffblk.ff_attrib& FA_ARCH)
	       *( DW.dir_entrys[ DW.RB->max]+ 22)= 'A';
	    if( ffblk.ff_attrib& FA_HIDDEN)
	       *( DW.dir_entrys[ DW.RB->max]+ 23)= 'H';
	    if( ffblk.ff_attrib& FA_RDONLY)
	       *( DW.dir_entrys[ DW.RB->max]+ 24)= 'R';
	    if( ffblk.ff_attrib& FA_SYSTEM)
	       *( DW.dir_entrys[ DW.RB->max]+ 25)= 'S';
	    if( o_DW->Win_Typ== RIGHT)
	       *( DW.dir_entrys[ DW.RB->max]+ 26)= '\0';
	    if(( cmp_dir== 0)&& (( find= lfind( &DW.dir_entrys[ DW.RB->max], o_DW->dir_entrys, &anz_elem, sizeof( char *), ( fcmp)Entry_find))!= NULL))
	    {
	       if(( *DW.dir_entrys[ DW.RB->max++]= **find)== ANGEWAEHLT)
	       {
		  o_DW->anz_mark++;
		  o_DW->gesbyte_mark+= ffblk.ff_fsize;
	       }
	    }
	    else
	       *DW.dir_entrys[ DW.RB->max++]= ABGEWAEHLT;
	 }
      }
      dir_entry= findnext( &ffblk);
   }
   if( cmp_dir== 0)
      FreeArray( o_DW);
   if( !ret_val)                              /* kein Fehler aufgetreten */
   {
      Sort_Typ= o_DW->Sort_Typ; /* globale Variable fr Sortfilter() setzen */
      if( DW.RB->max== 0L)                /* keine Eintrge im Dateifenster */
      {
	 if(( DW.dir_entrys[ DW.RB->max]= malloc( 28))!= NULL)
	    *( strcpy( DW.dir_entrys[ DW.RB->max++], "@No files found    ")+ 27)= '\0'; /* wegen Gro-/Kleinschaltung des Dateifensters */
	 else
	    goto SPEICHERMANGEL;
      }
      else
	 qsort( DW.dir_entrys, DW.RB->max, sizeof( char *), ( fcmp)Sortfilter);
      strcpy( o_DW->old_verzeichnis, o_DW->verzeichnis);
      o_DW->RB->max= DW.RB->max;
      memcpy( o_DW->dir_entrys, DW.dir_entrys, DW.RB->max* sizeof( char *));
      if( o_DW->anz_mark== 0)
	 sprintf( tmp_array, "%d File(s) %d Dirs.", ( WORD)DW.RB->max- ( WORD)anz_directorys, ( WORD)anz_directorys);
      else
      {
	 if( o_DW->gesbyte_mark> 9999999L)
	    sprintf( tmp_array, "%d File(s) %.2f Mbyte", o_DW->anz_mark, ( float)o_DW->gesbyte_mark/ ( float)1048576L);
	 else
	    sprintf( tmp_array, "%d File(s) %ld bytes", o_DW->anz_mark, o_DW->gesbyte_mark);
      }
      setcolor( datcolor);
      gettextsettings( &text);
      settextjustify( CENTER_TEXT, text.vert);
      ShowMouse( AUS);
      outtextxy( *o_DW->X+ XREF_DATEIAUSWFENSTER+ ( ( o_DW->Win_Typ== LEFT) ? ( 168) : ( 110)), *o_DW->Y+ YREF_DATEIAUSWFENSTER+ 231, tmp_array);
      ShowMouse( AN);
      settextjustify( text.horiz, text.vert);
      if( !dir_entry)
	 Info_Frage( 250, 250, "There are more than 999\nfiles matching the\nfilter.  Not all\nfiles can be\ndisplayed.", INFO);
   }
   else                                                /* Speicherfehler */
   {
      SPEICHERMANGEL:
      ;
      for( ret_val= 0; ret_val< DW.RB->max; ret_val++) /* Speicher freigeben */
	 free( DW.dir_entrys[ ret_val]);
      ErrorMsg( KEIN_SPEICHER);
      if( DW.RB->max> 10L)  /* Speichermangel nicht ganz so fatal */
	 ret_val= NOT_MEMORY;
      else
	 ret_val= FATAL_MEMORY;
      o_DW->RB->max= 0L;
   }
   ClearStatus();
   return( ret_val); /* -1= nicht genug Speicher, -2= Kein Speicher mehr !!! -> Programm beenden */
}

void BalkenShow_Rohling( int X, int Y, int X_len, int Zeiger_pos, char an_aus)
{
   int y;

   y= Y+ YREF_DATEIAUSWFENSTER+ 1+ ( Zeiger_pos* 14);
   setlinestyle( DOTTED_LINE, 0, NORM_WIDTH);
   if( an_aus== AN)
      setcolor( EGA_LIGHTBLUE);
   else
      setcolor( EGA_LIGHTGRAY);
   ShowMouse( AUS);
   rectangle( X, y, X+ X_len, y+ 10);
   ShowMouse( AN);
   setlinestyle( SOLID_LINE, 0, NORM_WIDTH);
}

void BalkenShow_L( int X, int Y, int Zeiger_pos, char an_aus)
{
   BalkenShow_Rohling( X+ XREF_DATEIAUSWFENSTER+ X_TO_DIRANF_L+ 10, Y, X_TO_DIREND_L- X_TO_DIRANF_L- 10, Zeiger_pos, an_aus);
}

void BalkenShow_R( int X, int Y, int Zeiger_pos, char an_aus)
{
   BalkenShow_Rohling( X+ XREF_DATEIAUSWFENSTER+ X_TO_DIRANF_R+ 10, Y, X_TO_DIREND_R- X_TO_DIRANF_R- 10, Zeiger_pos, an_aus);
}

void _BalkenShow_L( int X, int Y, int Zeiger_pos, char an_aus)
{
   if( aktivwindow== LEFT)
      BalkenShow_Rohling( X+ XREF_DATEIAUSWFENSTER+ X_TO_DIRANF_L+ 5, Y- 1, X_TO_DIREND_L- X_TO_DIRANF_L- 10, Zeiger_pos, an_aus);
}

void _BalkenShow_R( int X, int Y, int Zeiger_pos, char an_aus)
{
   if( aktivwindow== RIGHT)
      BalkenShow_Rohling( X+ XREF_DATEIAUSWFENSTER+ X_TO_DIRANF_R+ 5+ MIN_X_RIGHT_DIR- MIN_X_LEFT_DIR, Y- 1, X_TO_DIREND_R- X_TO_DIRANF_R- 10, Zeiger_pos, an_aus);
}

void ScrollUpWindow( int x, int y, int x2, int y2, int dist)
{
   ScrScl( x, y, x2, y2, -dist);
   setfillstyle( SOLID_FILL, EGA_LIGHTGRAY);
   bar( x, y2- dist, x2, y2);
}

void ScrollDownWindow( int x, int y, int x2, int y2, int dist)
{
   ScrScl( x, y, x2, y2, dist);
   setfillstyle( SOLID_FILL, EGA_LIGHTGRAY);
   bar( x, y, x2, y+ dist- 1);
}

void _Show_Reverse( DATWINStruct *DW, int entry_nr, BYTE maske)
{
   int x, xend, y;

   if( DW->Win_Typ== LEFT)
   {
      x=    *DW->X+ XREF_DATEIAUSWFENSTER+ X_TO_DIRANF_L+ 11;
      xend= *DW->X+ XREF_DATEIAUSWFENSTER+ X_TO_DIREND_L- 1;
   }
   else
   {
      x=    *DW->X+ XREF_DATEIAUSWFENSTER+ X_TO_DIRANF_R+ 11;
      xend= *DW->X+ XREF_DATEIAUSWFENSTER+ X_TO_DIREND_R- 1;
   }
   y= *DW->Y+ YREF_DATEIAUSWFENSTER+ 3+ ( entry_nr* 14);
   setcolor( maske);
   setlinestyle( SOLID_LINE, 0, THICK_WIDTH);
   setwritemode( XOR_PUT);
   line( x, y,    xend, y   );
   line( x, y+ 3, xend, y+ 3);
   line( x, y+ 6, xend, y+ 6);
   setlinestyle( SOLID_LINE, 0, NORM_WIDTH);
   setwritemode( COPY_PUT);
}

void ReverseEntry( DATWINStruct *DW, int entry_nr)
{
   _Show_Reverse( DW, entry_nr, 0x0F);
}

void Drag_Drop_Mark( DATWINStruct *DW, int entry_nr)
{
   _Show_Reverse( DW, entry_nr, 0x08);
}

void Dir_Up_Down( DATWINStruct *DW, char Richtung, char reverse)
{
   int x, xend;

   if( DW->Win_Typ== LEFT)
   {
      x=    *DW->X+ XREF_DATEIAUSWFENSTER+ X_TO_DIRANF_L;
      xend= *DW->X+ XREF_DATEIAUSWFENSTER+ X_TO_DIREND_L;
   }
   else
   {
      x=    *DW->X+ XREF_DATEIAUSWFENSTER+ X_TO_DIRANF_R;
      xend= *DW->X+ XREF_DATEIAUSWFENSTER+ X_TO_DIREND_R;
   }
   ShowMouse( AUS);
   if( DW->entry_mark!= -1)
   {
      Drag_Drop_Mark( DW, DW->entry_mark);
      DW->entry_mark= -1;
   }
   if( Richtung== UP)
   {
      ScrollUpWindow( x, *DW->Y+ YREF_DATEIAUSWFENSTER+ 16, xend, *DW->Y+ YREF_DATEIAUSWFENSTER+ 223, 14);
      FileIcon( x, *DW->Y+ YREF_DATEIAUSWFENSTER+ 212, DW->dir_entrys[ DW->RB->proz+ 15L], FALSE);
      setcolor( datcolor);
      outtextxy( x+ 12, *DW->Y+ YREF_DATEIAUSWFENSTER+ 213, &DW->dir_entrys[ DW->RB->proz+ 15L][ 1]);
      if(( reverse!= NOREVERSE)&& ( DW->dir_entrys[ DW->RB->proz+ 15L][ 0]== ANGEWAEHLT))
	 ReverseEntry( DW, 15);
   }
   else
   {
      ScrollDownWindow( x, *DW->Y+ YREF_DATEIAUSWFENSTER+ 2, xend, *DW->Y+ YREF_DATEIAUSWFENSTER+ 206, 14);
      FileIcon( x, *DW->Y+ YREF_DATEIAUSWFENSTER+ 2, DW->dir_entrys[ DW->RB->proz], FALSE);
      setcolor( datcolor);
      outtextxy( x+ 12, *DW->Y+ YREF_DATEIAUSWFENSTER+ 3, &DW->dir_entrys[ DW->RB->proz][ 1]);
      if(( reverse!= NOREVERSE)&& ( DW->dir_entrys[ DW->RB->proz][ 0]== ANGEWAEHLT))
	 ReverseEntry( DW, 0);
   }
   ShowMouse( AN);
}

void DirEntry( DATWINStruct *DW)
{
   int x, xend, ypos, i;

   setfillstyle( SOLID_FILL, EGA_LIGHTGRAY);
   if( DW->Win_Typ== LEFT)
   {
      x=    *DW->X+ XREF_DATEIAUSWFENSTER+ X_TO_DIRANF_L;
      xend= *DW->X+ XREF_DATEIAUSWFENSTER+ X_TO_DIREND_L;
   }
   else
   {
      x=    *DW->X+ XREF_DATEIAUSWFENSTER+ X_TO_DIRANF_R;
      xend= *DW->X+ XREF_DATEIAUSWFENSTER+ X_TO_DIREND_R;
   }
   ShowMouse( AUS);
   bar( x, *DW->Y+ YREF_DATEIAUSWFENSTER+ 1, xend, *DW->Y+ YREF_DATEIAUSWFENSTER+ 222);
   DW->entry_mark= -1;
   for( i= DW->RB->proz, ypos= *DW->Y+ YREF_DATEIAUSWFENSTER- 12; ( i< ( DW->RB->proz+ 16L))&& ( i< DW->RB->max); i++)
   {
      FileIcon( x, ypos+= 14, DW->dir_entrys[ i], FALSE);
      setcolor( datcolor);
      outtextxy( x+ 12, ypos+ 1, &DW->dir_entrys[ i][ 1]);
      if( DW->dir_entrys[ i][ 0]== ANGEWAEHLT)
	 ReverseEntry( DW, i- DW->RB->proz);
   }
   if( DW->RB->Zeiger_pos>= DW->RB->max)
      DW->RB->Zeiger_pos= 0;
   ShowMouse( AN);
}

void Resort_DirEntrys( DATWINStruct *DW)
{
   typedef int ( *fcmp) ( const void *, const void *);

   Sort_Typ= DW->Sort_Typ;      /* globale Variable fr Sortfilter() setzen */
   qsort( DW->dir_entrys, DW->RB->max, sizeof( char *), ( fcmp)Sortfilter);
   DirEntry( DW);
}

void GesDat( DATWINStruct *DW)
{
   struct textsettingstype text;
   char puf[ 40];

   ShowMouse( AUS);
   if( DW->Win_Typ== LEFT)
      ClearTextN( *DW->X+ XREF_DATEIAUSWFENSTER+ 10, *DW->Y+ YREF_DATEIAUSWFENSTER+ 231, 39);
   else
      ClearTextN( *DW->X+ XREF_DATEIAUSWFENSTER+  6, *DW->Y+ YREF_DATEIAUSWFENSTER+ 231, 26);
   setcolor( datcolor);
   if( DW->gesbyte_mark> 9999999L)
      sprintf( puf, "%d File(s) %.2f Mbyte", DW->anz_mark, ( float)DW->gesbyte_mark/ ( float)1048576L);
   else
      sprintf( puf, "%d File(s) %ld bytes", DW->anz_mark, DW->gesbyte_mark);
   gettextsettings( &text);
   settextjustify( CENTER_TEXT, text.vert);
   if( DW->Win_Typ== LEFT)
      outtextxy( *DW->X+ XREF_DATEIAUSWFENSTER+ 168, *DW->Y+ YREF_DATEIAUSWFENSTER+ 231, puf);
   else
      outtextxy( *DW->X+ XREF_DATEIAUSWFENSTER+ 110, *DW->Y+ YREF_DATEIAUSWFENSTER+ 231, puf);
   ShowMouse( AN);
   settextjustify( text.horiz, text.vert);
}

void DirBalken( int taste, DATWINStruct *DW)
{
   long datsize;

   switch( taste)
   {
      case 1:                                                       /* Entf */
	 if(( DW->Win_Typ== RIGHT)&& ( *DW->dir_entrys[ DW->RB->proz+ DW->RB->Zeiger_pos]!= NICHT_BEARBEITEN))
	    Datum( *DW->X+ XREF_DATEIAUSWFENSTER- 106, *DW->Y+ YREF_DATEIAUSWFENSTER- 11+ ( DW->RB->Zeiger_pos* 14), &DW->dir_entrys[ DW->RB->proz+ DW->RB->Zeiger_pos][ 27]);
	 break;
      case 0:                                                       /* Einf */
	 if( *DW->dir_entrys[ DW->RB->proz+ DW->RB->Zeiger_pos]!= NICHT_BEARBEITEN)
	 {
	    ShowMouse( AUS);
	    ReverseEntry( DW, DW->RB->Zeiger_pos);
	    datsize= Get_Datsize( DW->dir_entrys[ DW->RB->proz+ DW->RB->Zeiger_pos]);
	    if( DW->dir_entrys[ DW->RB->proz+ DW->RB->Zeiger_pos][ 0]== ANGEWAEHLT)
	    {
	       DW->dir_entrys[ DW->RB->proz+ DW->RB->Zeiger_pos][ 0]= ABGEWAEHLT;
	       DW->anz_mark--;
	       DW->gesbyte_mark-= datsize;
	    }
	    else
	    {
	       DW->dir_entrys[ DW->RB->proz+ DW->RB->Zeiger_pos][ 0]= ANGEWAEHLT;
	       DW->anz_mark++;
	       DW->gesbyte_mark+= datsize;
	    }
	    GesDat( DW);
	    ShowMouse( AN);
	    extended_ungetch( CURSOR_DOWN);     /* Balken eine Zeile tiefer */
	 }
	 break;
   }
}

void Aktiv_Passiv( char ausw)
{
   if( ausw== RIGHT)
   {
      Draw_Tal_Berg( 12, 323, 349, 344, BERG);
      Draw_Tal_Berg( 15, 326, 346, 341, TAL);
      Draw_Tal_Berg( 386, 323, 606, 344, TAL);
      Draw_Tal_Berg( 389, 326, 603, 341, BERG);
   }
   else
   {
      Draw_Tal_Berg( 12, 323, 349, 344, TAL);
      Draw_Tal_Berg( 15, 326, 346, 341, BERG);
      Draw_Tal_Berg( 386, 323, 606, 344, BERG);
      Draw_Tal_Berg( 389, 326, 603, 341, TAL);
   }
}

void *ShowAktivWindow( DATWINStruct *l_DW, DATWINStruct *r_DW, void **arg_ptr)
{
   ShowMouse( AUS);
   ClearTextN( 12, 28, 6);
   ClearTextN( 386, 28, 6);
   if( aktivwindow== LEFT)
   {
      arg_ptr[ 2]= l_DW->RB;      /* wegen selben Tastaturcodes vertauschen */
      arg_ptr[ 4]= r_DW->RB;
      arg_ptr[ 3]= _BalkenShow_L;
      arg_ptr[ 5]= _BalkenShow_R;
      Aktiv_Passiv( LEFT);
      setcolor( datcolor);
      outtextxy( 12, 28, "Source");
      outtextxy( 386, 28, " Dest");
      BalkenShow_L( *l_DW->X, *l_DW->Y, l_DW->RB->Zeiger_pos, AN);
      BalkenShow_R( *r_DW->X, *r_DW->Y, r_DW->RB->Zeiger_pos, AUS);
      ShowMouse( AN);
      return( l_DW);
   }
   else
   {
      arg_ptr[ 2]= r_DW->RB;
      arg_ptr[ 4]= l_DW->RB;
      arg_ptr[ 3]= _BalkenShow_R;
      arg_ptr[ 5]= _BalkenShow_L;
      Aktiv_Passiv( RIGHT);
      setcolor( datcolor);
      outtextxy( 12, 28, " Dest");
      outtextxy( 386, 28, "Source");
      BalkenShow_L( *l_DW->X, *l_DW->Y, l_DW->RB->Zeiger_pos, AUS);
      BalkenShow_R( *r_DW->X, *r_DW->Y, r_DW->RB->Zeiger_pos, AN);
      ShowMouse( AN);
      return( r_DW);
   }
}

int ShowDInfo( DATWINStruct *DW)
{
   struct DOSERROR info;
   struct ffblk ffblk;
   char buffer[ 12], *ptr;
   int x, ret= 0;
   
   if( DW->stat_dyn== DW_FEST)
   {
      if( DW->Win_Typ== LEFT)
	 x= 69;
      else
	 x= 449;
      sprintf( buffer, "%c:\\*.*", *DW->verzeichnis);
      if( findfirst( buffer, &ffblk, FA_LABEL))
      {
	 dosexterr( &info);
	 if( info.de_exterror== 83)
	 {
	    buffer[ 0]= '\0';
	    ret= -1;
	 }
	 else
	    strcpy( buffer, "no names ");
      }
      else
      {
	 if(( ptr= strchr( ffblk.ff_name, '.'))!= NULL)  /* Dateipunkt lschen */
	    memmove( ptr, ptr+ 1, strlen( ptr+ 1)+ 1);
	 sprintf( buffer, "%-11s", ffblk.ff_name);
      }
      setcolor( datcolor);
      ShowMouse( AUS);
      setfillstyle( SOLID_FILL, EGA_LIGHTGRAY);
      bar( x+ 33, 24, x+ 122, 35);
      outtextxy( x+ 33, 26, buffer);
      ShowDrive( x, 16, Laufwerksart( *DW->verzeichnis- 'A'));
      setcolor( EGA_BLUE);
      line( x+ 18, 24, x+ 18, 25);
      line( x+ 19, 26, x+ 20, 27);
      ShowMouse( AN);
   }
   return( ret);                          /* -1= Fehler beim Lesen, 0= O.K. */
}

void LoescheVar( MAUSStruct *MS, DATWINStruct *DW, char *path_tab_ptr[])
{
   int v_cmp;
   char dir1[ MAXDIR], dir2[ MAXDIR];

   DW->entry_mark= -1;
   MS->statsp= REINIT;
   v_cmp= strcmp( Path_to_Dir( dir1, DW->old_verzeichnis), Path_to_Dir( dir2, DW->verzeichnis));
   if( !ShowDInfo( DW))
   {
      if( Read_DirEntrys( DW)== FATAL_MEMORY)
	 ExitMsg( MEMORY_EXIT);
      _EntryInPullTable( path_tab_ptr, MAX_PATH_TAB_ENTRY, DW->verzeichnis, TRUE);
   }
   else
   {
      if(( DW->dir_entrys[ 0]= malloc( 28))!= NULL)
      {
	 *( strcpy( DW->dir_entrys[ 0], "@DRIVE ?: NOT READY!      ")+ 27)= '\0'; /* wegen Gro-/Kleinschaltung des Dateifensters */
	 *( DW->dir_entrys[ 0]+ 10)= *DW->verzeichnis;
	 DW->RB->max= 1L;
      }
      else
	 ExitMsg( MEMORY_EXIT);
   }
   if( v_cmp== 0)
   {
      if(( DW->RB->proz+ DW->RB->maxstep)> DW->RB->max)
      {
	 if(( DW->RB->proz= DW->RB->max- DW->RB->maxstep)< 0L)
	    DW->RB->proz= 0L;
      }
   }
   else
      DW->RB->proz= 0L;
   DirEntry( DW);
}

int MkDir( char *path)
{
   char teil_dir[ MAXDIR], t_dir[ MAXDIR], *dir_ptr;

   if( access( path, 0))
   {
      dir_ptr= strtok( path, "\\");
      strcpy( teil_dir, dir_ptr);
      do
      {
	 strcat( teil_dir, "\\");
	 if(( dir_ptr= strtok( NULL, "\\"))!= NULL)
	 {
	    if( access( strcat( teil_dir, dir_ptr), 0))
	    {
	       if( mkdir( teil_dir))    /* Verzeichnis konnte nicht erstellt werden */
	       {
		  ErrorMsg( "Directory could not be created (incomplete)");
		  return( -1);
	       }
	    }
	 }
      }while( dir_ptr);
   }
   else
   {
      Hinweis( "The directory already exists");
      return( 1);                       /* Verzeichnis existiert schon */
   }
   newbaum[ toupper( path[ 0])- 'A']= 1;
   return( 0);                          /* alles o.k. */
}

void _MakeDir( MAUSStruct *d_MS, DATWINStruct *l_DW, DATWINStruct *r_DW, char *path_tab_ptr_l[], char *path_tab_ptr_r[], char Quelle)
{
   DATWINStruct *q_DW;
   int ret= 0, X_tree= 10, status;
   char dir[ MAXDIR]= "", start_dir[ MAXDIR], tmp_array[ MAXDIR+ MAXDIR];
   void *arg_ptr[ 3];
   char *msg[]= { "Enter subdirectory name or complete path (with drive)             "};
   WORD mauspos[]= { BUTTON|        FRAME| KEY,              5,  27,   5,  21, ESC,
		     DIRINPUTNOBOX| IGN_CASE| FRAME| KEY| DEFBUTTON| MSG,  18,  44, 219, MAXDIR- 1, 'v',
		     DIRINPUT| IGN_CASE|      FRAME| KEY,             18,  79, 273, MAXDIR- 1, 245,  37, LWAUSWAHL, 't',
		     BUTTON|        FRAME| KEY,             18, 150, 109, 134, RETURN,
		     BUTTON|        FRAME| KEY,            160, 291, 109, 134, 'a',
		     MOVEWINDOW };
   MAUSStruct MS= { DEFAULT, DEFAULT, 310, 151, 6, INIT, NULL, AN};

   if( Quelle== LEFT)
      q_DW= l_DW;
   else
      q_DW= r_DW;
   arg_ptr[ 0]= dir;
   arg_ptr[ 1]= Path_to_Dir( start_dir, q_DW->verzeichnis);
   arg_ptr[ 2]= &X_tree;
   MS.x= &X_verzeichnis;
   MS.y= &Y_verzeichnis;
   MS.msg= msg;
   MS.mauspos= mauspos;
   MS.arg_ptr= arg_ptr;
   PCX_Window( MS.x, MS.y, PCX_VERZEICHNIS_ERSTELLEN, &MS.sa, SHADOW);
   do
   {
      switch( status= __CheckMousepos( &MS))
      {
	 case 3:                                                      /* OK */
	    *( strncpy( tmp_array, dir, 3)+ 3)= '\0';
	    if( !strncmp( tmp_array+ 1, ":\\", 2)&& !access( tmp_array, 0))
	       MkDir( dir);
	    else
	    {
	       if( !access( start_dir, 0))
	       {
		  if( strlen( Paste_Filter_to_Dir( strcpy( tmp_array, start_dir), dir))>= MAXDIR)
		  {
		     ErrorMsg( "The total length of the directory is too big (64)   ");
		     break;
		  }
		  else
		     MkDir( tmp_array);
	       }
	       else
	       {
		  ErrorMsg( "The parent directory does not exist");
		  break;
	       }
	    }
	 case 0:                                                     /* ESC */
	 case 4:                                                 /* Abbruch */
	    ret= 1;
	    break;
      }
   }while( !ret);
   ShowMouse( AUS);
   BigScreenRestore( &MS.sa, *MS.x, *MS.y);
   ShowMouse( AN);
   if( status== 3)
   {
      LoescheVar( d_MS, l_DW, path_tab_ptr_l);
      LoescheVar( d_MS, r_DW, path_tab_ptr_r);
   }
}

void Datum( int x, int y, char *dir)
{
   int poly[ 10];
   char datum[ 20];
   void *scr_ptr;

   if(( scr_ptr= malloc( imagesize( 0, 0, 81, 26)))!= NULL)
   {
      poly[ 0]= x+ 240;
      poly[ 1]= y- 4;
      poly[ 2]= x+ 295;
      poly[ 3]= y- 4;
      poly[ 4]= x+ 295;
      poly[ 5]= y+ 21;
      poly[ 6]= x+ 215;
      poly[ 7]= y+ 21;
      poly[ 8]= x+ 240;
      poly[ 9]= y- 4;
      setfillstyle( SOLID_FILL, EGA_LIGHTGRAY);
      *( strcpy( datum, dir)+ 8)= '\0';
      ShowMouse( AUS);
      getimage( x+ 215, y- 4, x+ 296, y+ 22, scr_ptr);
      setcolor( 0x08);
      setwritemode( XOR_PUT);
      line( x+ 216, y+ 22, x+ 296, y+ 22);
      line( x+ 296, y+ 22, x+ 296, y- 3);
      setwritemode( COPY_PUT);
      setcolor( datcolor);
      fillpoly( 5, poly);
      drawpoly( 5, poly);
      outtextxy( x+ 253, y, datum+ 9);
      outtextxy( x+ 229, y+ 11, datum);
      ShowMouse( AN);
      Klick();
      ShowMouse( AUS);
      putimage( x+ 215, y- 4, scr_ptr, COPY_PUT);
      ShowMouse( AN);
      free( scr_ptr);
   }
   else
      ErrorMsg( KEIN_SPEICHER);
}

void DatEntry_Balken( int X, int Y, int Zeiger_pos, char an_aus)
{
   if( aktivwindow== LEFT)
      BalkenShow_L( X- 5, Y- 1, Zeiger_pos, an_aus);
   else
      BalkenShow_R( X+ MIN_X_RIGHT_DIR- MIN_X_LEFT_DIR- 5, Y- 1, Zeiger_pos, an_aus);
}

void ClearDatMark( DATWINStruct *DW)
{
   if( DW->entry_mark!= -1)
   {
      ShowMouse( AUS);
      Drag_Drop_Mark( DW, DW->entry_mark);
      ShowMouse( AN);
      DW->entry_mark= -1;
   }
}

char ShowDatMark( DATWINStruct *DW)
{
   char entry_nr;

   entry_nr= ( MStat.y- ( *DW->Y+ YREF_DATEIAUSWFENSTER))/ 14;
   if( entry_nr!= DW->entry_mark)
   {
      if( entry_nr< ( DW->RB->max- DW->RB->proz))
      {
	 ShowMouse( AUS);
	 if( DW->entry_mark!= -1)                   /* kein Balken sichtbar */
	    Drag_Drop_Mark( DW, DW->entry_mark);
	 Drag_Drop_Mark( DW, entry_nr);
	 ShowMouse( AN);
	 DW->entry_mark= entry_nr;
      }
      else
	 entry_nr= -2;
   }
   return( entry_nr);
}

void MarkEntry( DATWINStruct *DW, int status)
{
   if(( *DW->dir_entrys[ DW->RB->proz+ status]!= NICHT_BEARBEITEN)&& ( DW->dir_entrys[ DW->RB->proz+ status][ 0]!= ANGEWAEHLT))
   {
      DW->dir_entrys[ DW->RB->proz+ status][ 0]= ANGEWAEHLT;
      DW->anz_mark++;
      DW->gesbyte_mark+= Get_Datsize( DW->dir_entrys[ DW->RB->proz+ status]);
      ShowMouse( AUS);
      ReverseEntry( DW, status);
      ShowMouse( AN);
      GesDat( DW);
   }
}

char AnztoDatei( DATWINStruct *DW, char *datei, int status)
{
   char Art;

   strncpy( datei, &DW->dir_entrys[ DW->RB->proz+ status][ 1], 13);  /* 13-> falls Eintrag Directory ist */
   *strchr( datei, SPACE)= '\0';
   if(( Art= Art_of_Entry( DW->dir_entrys[ DW->RB->proz+ status]))!= DIR)
   {
      strcat( datei, ".");
      strncat( datei, &DW->dir_entrys[ DW->RB->proz+ status][ FILEEXT_POS], 3);
      *strchr( datei, SPACE)= '\0';
   }
   return( Art);
}

void ShowSource( DATWINStruct *DW, int dragEntry, BOOL mark)
{
   int i, fileIconX, fileIconY;

   ShowMouse( AUS);
   fileIconX= ( DW->Win_Typ== LEFT) ? *DW->X+ XREF_DATEIAUSWFENSTER+ X_TO_DIRANF_L : *DW->X+ XREF_DATEIAUSWFENSTER+ X_TO_DIRANF_R;
   fileIconY= *DW->Y+ YREF_DATEIAUSWFENSTER+ 2+ ( dragEntry* 14);
   if( !mark)
      ClearFileIcon( fileIconX, fileIconY);
   FileIcon( fileIconX, fileIconY, DW->dir_entrys[ DW->RB->proz+ dragEntry], mark);
   for( i= DW->RB->proz, fileIconY= *DW->Y+ YREF_DATEIAUSWFENSTER+ 2; ( i< ( DW->RB->proz+ 16L))&& ( i< DW->RB->max); i++, fileIconY+= 14)
      if( *DW->dir_entrys[ i]== ANGEWAEHLT)
      {
	 if( !mark)
	    ClearFileIcon( fileIconX, fileIconY);
	 FileIcon( fileIconX, fileIconY, DW->dir_entrys[ i], mark);
      }
   ShowMouse( AN);
}

#define MAXFILTER                            31
#define MAXFILTER_ENTRY                      5
#define ZUTREFFENDES_ANWAEHLEN               0
#define ALLES_AUSSER_ZUTREFFENDES_ANWAEHLEN  1
#define ZUTREFFENDES_ABWAEHLEN               2
#define ALLES_AUSSER_ZUTREFFENDES_ABWAEHLEN  3

int Anwahl( DATWINStruct *l_DW, DATWINStruct *r_DW, MAUSStruct *MS, char *l_path_tab_ptr[], char *r_path_tab_ptr[], char *filter_tab_ptr[])
{
   DATWINStruct *q_DW, *DW;
   struct ffblk ffblk;
   char **q_path_tab_ptr, ext[ 6]= "*.", tmp_array[ MAXDIR+ DW_MAXFILTER],
	filename[ 13], Entry_art= !DIR;
   BOOL DragDrop= 0, shiftPressed;
   void *old_maus_cursor= last_maus_cursor,
	*mem_ptr;
   BYTE ZElem[]= { 7, 8, 14, 26, 28, 35, 36, 37, 39, 43, 44, 45, 46, 47, 48, 64};
   int status= -1, nach_status, DD_element= -1, altstatus= -1, y, i,
       old_X, old_Y, array_index, ptr_index, old_DD_element= -1,
       old_DD_msg= -1,  x1, y1, x2, y2;
   long datsize;

   if( aktivwindow== LEFT)
   {
      q_DW= l_DW;
      q_path_tab_ptr= l_path_tab_ptr;
   }
   else
   {
      q_DW= r_DW;
      q_path_tab_ptr= r_path_tab_ptr;
   }
   if( MStat.buttons== RIGHT)
   {
      do
      {
	 if( MStat.y> ( *q_DW->Y+ YREF_DATEIAUSWFENSTER+ 222))
	 {
	    if(( q_DW->RB->proz+ 16L)< q_DW->RB->max)
	    {
	       q_DW->RB->proz++;
	       DatEntry_Balken( *MS->x, *MS->y, q_DW->RB->Zeiger_pos, AUS);
	       Dir_Up_Down( q_DW, UP, NOREVERSE);
	       DatEntry_Balken( *MS->x, *MS->y, q_DW->RB->Zeiger_pos, AN);
	       status= 15;
	    }
	    else
	       status= -1;
	    altstatus= -1;
	    i= 1;
	    _ViewAnfasser( MS, q_DW->RB);
	 }
	 if( MStat.y< ( *q_DW->Y+ YREF_DATEIAUSWFENSTER))
	 {
	    if( q_DW->RB->proz> 0L)
	    {
	       q_DW->RB->proz--;
	       DatEntry_Balken( *MS->x, *MS->y, q_DW->RB->Zeiger_pos, AUS);
	       Dir_Up_Down( q_DW, DOWN, NOREVERSE);
	       DatEntry_Balken( *MS->x, *MS->y, q_DW->RB->Zeiger_pos, AN);
	       status= 0;
	    }
	    else
	       status= -1;
	    altstatus= -1;
	    i= 1;
	    _ViewAnfasser( MS, q_DW->RB);
	 }
	 if( !i)
	 {
	    altstatus= status;
	    status= ( MStat.y- ( *q_DW->Y+ YREF_DATEIAUSWFENSTER))/ 14;
	 }
	 if((( status> -1)&& ( status!= altstatus))&& ( status< ( q_DW->RB->max- q_DW->RB->proz)))
	 {
	    if( *q_DW->dir_entrys[ q_DW->RB->proz+ status]!= NICHT_BEARBEITEN)
	    {
	       datsize= Get_Datsize( q_DW->dir_entrys[ q_DW->RB->proz+ status]);
	       if( q_DW->dir_entrys[ q_DW->RB->proz+ status][ 0]== ANGEWAEHLT)
	       {
		  q_DW->dir_entrys[ q_DW->RB->proz+ status][ 0]= ABGEWAEHLT;
		  q_DW->anz_mark--;
		  q_DW->gesbyte_mark-= datsize;
	       }
	       else
	       {
		  q_DW->dir_entrys[ q_DW->RB->proz+ status][ 0]= ANGEWAEHLT;
		  q_DW->anz_mark++;
		  q_DW->gesbyte_mark+= datsize;
		  i= 0;
	       }
	       if( !i)
	       {
		  ShowMouse( AUS);
		  ReverseEntry( q_DW, status);
		  ShowMouse( AN);
	       }
	    }
	 }
	 i= 0;
      }while( MouseStat()== RIGHT);
      GesDat( q_DW);
   }
   else
   {
      status= ( MStat.y- ( *q_DW->Y+ YREF_DATEIAUSWFENSTER))/ 14;
      if(( status>= 0)&& ( status< ( q_DW->RB->max- q_DW->RB->proz)))
      {
	 old_X= MStat.x;
	 old_Y= MStat.y;
	 while( MouseStat()!= NOTHING)
	 {
	    if((( MStat.x!= old_X)|| ( MStat.y!= old_Y))&& (( abs( MStat.x- old_X)>= 3)|| ( abs( MStat.y- old_Y)>= 3)))
	    {
	       if( *q_DW->dir_entrys[ q_DW->RB->proz+ status]== NICHT_BEARBEITEN)
		  break;
	       if( !DragDrop)
	       {
		  ClearDatMark( q_DW);
		  ShowSource( q_DW, status, TRUE);
		  MouseArt( File_DragDrop);
		  DragDrop= 1;
	       }
	       if(( old_DD_element>= 0)&& !IsMouseInArea( x1, y1, x2, y2))
	       {
		  ButtonUp( mem_ptr, x1, y1, x2, y2);
		  old_DD_element= -1;
	       }
	       if(( DD_element= DragDrop_Element( MS, ZElem, sizeof( ZElem)- 1+ ( _extDatManag!= NULL)))>= 0)
	       {
		  if( old_DD_msg!= DD_element)
		  {
		     PrintStatus( "This element can be a target for Drag and Drop   ");
		     old_DD_msg= DD_element;
		  }
		  if( GetArrayIndexofElement( MS, DD_element, &array_index, &ptr_index))
		  {
		     switch( MS->mauspos[ array_index]& CODE_FILTER)
		     {
			case BUTTON:
			case BUTTON2:
			case BUTTON3:
			   if( old_DD_element!= DD_element)
			   {
			      GetObjectRect( MS, array_index, &x1, &y1, &x2, &y2);
			      if( old_DD_element< 0)
			      {
				 mem_ptr= ButtonDown( x1, y1, x2, y2);
				 old_DD_element= DD_element;
			      }
			   }
			   break;
		     }
		  }
		  switch( DD_element)
		  {
		     case 26:                 /* linkes Dateimanagerfenster */
			if( ShowDatMark( l_DW)== -2)
			   ClearDatMark( l_DW);
			break;
		     case 28:                /* rechtes Dateimanagerfenster */
			if( ShowDatMark( r_DW)== -2)
			   ClearDatMark( r_DW);
			break;
		     default:
			ClearDatMark( l_DW);
			ClearDatMark( r_DW);
			break;
		  }
	       }
	       else
	       {
		  ClearDatMark( l_DW);
		  ClearDatMark( r_DW);
		  if( old_DD_msg>= 0)
		  {
		     ClearStatus();
		     old_DD_msg= -1;
		  }
	       }
	    }
	 }
	 ClearDatMark( l_DW);
	 ClearDatMark( r_DW);
	 if( old_DD_msg>= 0)
	    ClearStatus();
	 if( old_DD_element>= 0)
	    ButtonUp( mem_ptr, x1, y1, x2, y2);
	 DD_element= -1;
	 if( DragDrop)
	 {
	    ShowSource( q_DW, status, FALSE);
	    MouseArt( old_maus_cursor);
	    shiftPressed= ( _bios_keybrd( _NKEYBRD_SHIFTSTATUS)& SHIFT_PRESS);
	    DD_element= DragDrop_Element( MS, ZElem, sizeof( ZElem)- 1+ ( _extDatManag!= NULL));
	    switch( DD_element)
	    {
	       case 7:
	       case 8:
		  if( aktivwindow== ( DD_element- 6))
		  {
		     *( strncpy( ext+ 2, q_DW->dir_entrys[ status+ q_DW->RB->proz]+ FILEEXT_POS, 3)+ 3)= '\0';
		     _EntryInPullTable( q_path_tab_ptr, MAX_PATH_TAB_ENTRY, Paste_Filter_to_Dir( Path_to_Dir( tmp_array, q_DW->verzeichnis), ext), TRUE);
		  }
		  else
		  {
		     MarkEntry( q_DW, status);
		     _Kop_Vers( MS, l_DW, r_DW, l_path_tab_ptr, r_path_tab_ptr, aktivwindow, NULL, ( shiftPressed) ? ( drag_drop_work^ 1) : drag_drop_work);
		     DD_element= -1;
		  }
		  break;
	       case 14:
		  Path_to_Dir( tmp_array, l_DW->verzeichnis);
		  if( AnztoDatei( l_DW, filename, status)!= DIR)
		  {
		     if( !findfirst( Paste_Filter_to_Dir( tmp_array, filename), &ffblk, FA_RDONLY| FA_HIDDEN| FA_SYSTEM| FA_ARCH))
		     {
			l_DATWIN_VF.nach_ff_fdate= l_DATWIN_VF.vor_ff_fdate= ffblk.ff_fdate;
			l_DATWIN_VF.nach_Datum= AN;
			l_DATWIN_VF.vor_Datum= AN;
			l_DATWIN_VF.Archiv= (( ffblk.ff_attrib& FA_ARCH)!= 0);
			l_DATWIN_VF.Hidden= (( ffblk.ff_attrib& FA_HIDDEN)!= 0);
			l_DATWIN_VF.RDonly= (( ffblk.ff_attrib& FA_RDONLY)!= 0);
			l_DATWIN_VF.System= (( ffblk.ff_attrib& FA_SYSTEM)!= 0);
			l_DATWIN_VF.aktiv= AN;
		     }
		     else
		     {
			ErrorMsg( "Cannot find the file");
			DD_element= -1;
		     }
		  }
		  else
		  {
		     Hinweis( "This function only sets a display filter for files.       ");
		     DD_element= -1;
		  }
		  break;
	       case 43:
		  *( strncpy( ext+ 2, q_DW->dir_entrys[ status+ q_DW->RB->proz]+ FILEEXT_POS, 3)+ 3)= '\0';
		  _EntryInPullTable( filter_tab_ptr, MAXFILTER_ENTRY, ext, TRUE);
		  break;
	       case 26:                       /* linke Dateifenstereintrge */
	       case 28:                      /* rechte Dateifenstereintrge */
		  DW= ( ( DD_element== 26) ? ( l_DW) : ( r_DW));
		  nach_status= ( MStat.y- ( *DW->Y+ YREF_DATEIAUSWFENSTER))/ 14;
		  if( nach_status>= 0)
		  {
		     Path_to_Dir( tmp_array, DW->verzeichnis);
		     if((( Entry_art= AnztoDatei( DW, filename, nach_status))== DIR)&& ( nach_status< ( DW->RB->max- DW->RB->proz)))
			Paste_Filter_to_Dir( tmp_array, filename);
		     if(( DW!= q_DW)|| (( DW== q_DW)&& ( Entry_art== DIR)&& ( status!= nach_status)))
		     {
			MarkEntry( q_DW, status);
			_Kop_Vers( MS, l_DW, r_DW, l_path_tab_ptr, r_path_tab_ptr, aktivwindow, tmp_array, ( shiftPressed) ? ( drag_drop_work^ 1) : drag_drop_work);
		     }
		     else
		     {
			if(( status!= nach_status)&& (( Entry_art== EXE)|| ( Entry_art== COM)|| ( Entry_art== BAT)))
			{
			   if( AnztoDatei( q_DW, filename, status)!= DIR)
			      _Exec( MS, nach_status, l_DW, r_DW, l_path_tab_ptr, r_path_tab_ptr, aktivwindow, filename);
			}
		     }
		  }
		  DD_element= -1;
		  break;
	       case 64:
		  _InputInsert= TRUE;
		  AnztoDatei( q_DW, tmp_array, status);
		  strtokeys( tmp_array);
		  MStat.buttons= LEFT;
		  GetArrayIndexofElement( MS, DD_element, &array_index, &ptr_index);
		  if( !( _Input( MS->mauspos[ array_index+ 1]+ *MS->x, MS->mauspos[ array_index+ 2]+ *MS->y, MS->mauspos[ array_index+ 3], ( char *)MS->arg_ptr[ ptr_index+ 1], MS->mauspos[ array_index+ 4], MS->mauspos[ array_index]& CODE_FILTER, ( MS->mauspos[ array_index]& IGN_CASE )!= 0)& FUNC_RETURN))
		     DD_element= -1;
		  break;
	       default:
		  if( DD_element!= -1)
		     MarkEntry( q_DW, status);
		  else
		     Hinweis( "This element is not a target for Drag&Drop");
		  break;
	    }
	 }
	 else
	 {
	    delay( klickwait);
	    if( MouseStat()!= NOTHING)
	    {
	       while( MouseStat()!= NOTHING)   /* auf Loslassen der Maustaste warten */
		 ;
	       if((( MStat.y- ( *q_DW->Y+ YREF_DATEIAUSWFENSTER))/ 14)== status)
	       {
		  _Exec( MS, status, l_DW, r_DW, l_path_tab_ptr, r_path_tab_ptr, aktivwindow, NULL);
	       }
	    }
	    else
	    {
	       if(( q_DW->Win_Typ== RIGHT)&& ( *q_DW->dir_entrys[ q_DW->RB->proz+ status]!= NICHT_BEARBEITEN))
	       {
		  y= *q_DW->Y+ YREF_DATEIAUSWFENSTER- 11+ ( status* 14);
		  Datum( *q_DW->X+ XREF_DATEIAUSWFENSTER- 106, y, &q_DW->dir_entrys[ q_DW->RB->proz+ status][ 27]);
	       }
	    }
	 }
      }
   }
   return( DD_element);
}

#define DATEIEN_ANWAEHLEN        0
#define VERZEICHNISSE_ANWAEHLEN  1
#define ALLES_ABWAEHLEN          2

void All_Auswahl( DATWINStruct *DW, BYTE Mode)
{
   int l;
   char Art;
   BOOL work= 0;
   long datsize;

   for( l= 0; l< DW->RB->max; l++)
   {
      if(( l!= 0)|| ( *DW->dir_entrys[ l]!= NICHT_BEARBEITEN))
      {
	 datsize= Get_Datsize( DW->dir_entrys[ l]);
	 Art= Art_of_Entry( DW->dir_entrys[ l]);
	 if((( Art!= DIR)&& ( Mode== DATEIEN_ANWAEHLEN))|| (( Art== DIR)&& ( Mode== VERZEICHNISSE_ANWAEHLEN)))
	 {
	    if( DW->dir_entrys[ l][ 0]== ABGEWAEHLT)
	    {
	       work= 1;
	       DW->dir_entrys[ l][ 0]= ANGEWAEHLT;
	       DW->anz_mark++;
	       DW->gesbyte_mark+= datsize;
	    }
	 }
	 if( Mode== ALLES_ABWAEHLEN)
	 {
	    if( DW->dir_entrys[ l][ 0]== ANGEWAEHLT)
	    {
	       work= 1;
	       DW->dir_entrys[ l][ 0]= ABGEWAEHLT;
	       DW->anz_mark--;
	       DW->gesbyte_mark-= datsize;
	    }
	 }
      }
   }
   GesDat( DW);
   if( work)
      DirEntry( DW);
}

void Auswahl( DATWINStruct *DW, char *filter_tab_ptr[], char filterwahl)
{
   int l, ret= 0;
   long datsize;
   char filter_sp[ MAXFILTER], *filter_ptr, dir_sp[ 25];
   BOOL _filter, work= 0;
   void *arg_ptr[ 5];
   WORD mauspos[]= { BUTTON|      FRAME| KEY,              5,  27,   5,  21, ESC,
		     INPUT_TABLE| IGN_CASE| FRAME| KEY,             13,  46, 183, MAXFILTER- 1, MAXFILTER_ENTRY, 'd',
		     RADIOBUTTON| FRAME| KEY,             19,  80, ZUTREFFENDES_ANWAEHLEN,              'z',
		     RADIOBUTTON| FRAME| KEY,             19,  99, ALLES_AUSSER_ZUTREFFENDES_ANWAEHLEN, 'e',
		     RADIOBUTTON| FRAME| KEY,             19, 118, ZUTREFFENDES_ABWAEHLEN,              'u',
		     RADIOBUTTON| FRAME| KEY,             19, 137, ALLES_AUSSER_ZUTREFFENDES_ABWAEHLEN, 'l',
		     BUTTON|      FRAME| KEY| DEFBUTTON,  22,  96, 164, 206, RETURN,
		     BUTTON|      FRAME| KEY,            113, 187, 164, 206, 'a',
		     MOVEWINDOW };
   MAUSStruct MS= { DEFAULT, DEFAULT, 210, 222, 9, INIT, NULL, AUS};

   arg_ptr[ 0]= filter_tab_ptr;
   arg_ptr[ 1]= arg_ptr[ 2]= arg_ptr[ 3]= arg_ptr[ 4]= &filterwahl;
   MS.x= &filter_X;
   MS.y= &filter_Y;
   MS.mauspos= mauspos;
   MS.arg_ptr= arg_ptr;
   PCX_Window( MS.x, MS.y, PCX_FILTER, &MS.sa, SHADOW);
   do
   {
      switch( __CheckMousepos( &MS))
      {
	 case 6:                                                      /* OK */
	    for( l= 0; l< DW->RB->max; l++)
	    {
	       if((( l!= 0)|| ( *DW->dir_entrys[ l]!= NICHT_BEARBEITEN))&& ( Art_of_Entry( DW->dir_entrys[ l])!= DIR))
	       {
		  strncpy( dir_sp, &DW->dir_entrys[ l][ 1], 20);
		  dir_sp[ 20]= '\0';
		  dir_sp[ 12]= '\0';
		  dir_sp[  8]= '.';
		  datsize= Get_Datsize( dir_sp- 1);
		  _filter= 0;
		  filter_ptr= strtok( strcpy( filter_sp, filter_tab_ptr[ 0]), ";,");
		  while( filter_ptr)
		  {
		     _filter|= _Filter( dir_sp, filter_ptr, ANWAHL);
		     filter_ptr= strtok( NULL, ";,");
		  }
		  if(( _filter&& ( filterwahl== ZUTREFFENDES_ANWAEHLEN))|| ( !_filter&& ( filterwahl== ALLES_AUSSER_ZUTREFFENDES_ANWAEHLEN)))
		  {
		     if( DW->dir_entrys[ l][ 0]== ABGEWAEHLT)
		     {
			work= 1;
			DW->dir_entrys[ l][ 0]= ANGEWAEHLT;
			DW->anz_mark++;
			DW->gesbyte_mark+= datsize;
		     }
		  }
		  else
		  {
		     if(( _filter&& ( filterwahl== ZUTREFFENDES_ABWAEHLEN))|| ( !_filter&& ( filterwahl== ALLES_AUSSER_ZUTREFFENDES_ABWAEHLEN)))
		     {
			if( DW->dir_entrys[ l][ 0]== ANGEWAEHLT)
			{
			   work= 1;
			   DW->dir_entrys[ l][ 0]= ABGEWAEHLT;
			   DW->anz_mark--;
			   DW->gesbyte_mark-= datsize;
			}
		     }
		  }
	       }
	    }
	    ret= 2;
	    break;
	 case 0:                                                     /* ESC */
	 case 7:                                                 /* Abbruch */
	    ret= 1;
	    break;
      }
   }while( !ret);
   ShowMouse( AUS);
   BigScreenRestore( &MS.sa, *MS.x, *MS.y);
   ShowMouse( AN);
   if( ret== 2)
   {
      if( work)                    /* wurde eine Dateimarkierung gendert ? */
      {
	 GesDat( DW);
	 DirEntry( DW);
      }
      else
	 Hinweis( "No matches found              ");
   }
}

void ShowIcoFile( char *path)
{
   struct textsettingstype text;
   WORD mauspos[]= { BUTTON| FRAME| KEY,              3,  25,   3,  20, ESC,
		     BUTTON| FRAME| KEY| DEFBUTTON,  34, 116,  84, 106, RETURN,
		     MOVEWINDOW
		     };
   MAUSStruct MS= { DEFAULT, DEFAULT, 150, 120, 3, INIT, NULL, AUS};

   MS.x= &icodatx;
   MS.y= &icodaty;
   MS.mauspos= mauspos;
   gettextsettings( &text);
   ShowMouse( AUS);
   BigScreenSave( &MS.sa, *MS.x, *MS.y, *MS.x+ 153, *MS.y+ 123);
   PutPaper( *MS.x, *MS.y, *MS.x+ 150, *MS.y+ 120, EGA_LIGHTGRAY, AN, AN, "Icon");
   Button( *MS.x+ 35, *MS.y+ 85, *MS.x+ 115, *MS.y+ 105, "OK", 0);
   settextjustify( CENTER_TEXT, text.vert);
   setcolor( EGA_BLACK);
   outtextxy( *MS.x+ 75, *MS.y+ 70, strrchr( path, '\\')+ 1);
   settextjustify( text.horiz, text.vert);
   ShowPicture( *MS.x+ 60, *MS.y+ 30, path);
   ShowMouse( AN);
   while( __CheckMousepos( &MS)== -1)
      ;
   ShowMouse( AUS);
   BigScreenRestore( &MS.sa, *MS.x, *MS.y);
   ShowMouse( AN);
}

int Start_PRG( char *path, char *parameter)
{
   int ret_val= 0, ret= 0, LW, X_dateiauswahlbox= 120, Y_dateiauswahlbox= 30, X_verzeichnisbaum= 100, X_lwausw= 130, Y_lwausw= 200;
   void *arg_ptr[ 4];
   char tmp_array[ 25];
   char *msg[]= { "File selector is available         ",
		  "Directory tree can be used         ",
		  "Drive can be selected          " };
   WORD mauspos[]= { BUTTON|    FRAME| KEY,                   5,  27,   5,  21, ESC,
		     FILEINPUT| IGN_CASE| FRAME| KEY| DEFBUTTON| MSG,  18,  85, 195, MAXPATH- 1,  36, 112, DEFAULT, 'n',
		     BUTTON|    FRAME| KEY|            MSG,  93, 139, 112, 146, 'p',
		     BUTTON|    FRAME| KEY|            MSG, 150, 196, 112, 146, 'l',
		     BUTTON|    FRAME| KEY,                  30, 104, 170, 212, RETURN,
		     BUTTON|    FRAME| KEY,                 128, 202, 170, 212, 'a',
		     MOVEWINDOW };
   MAUSStruct MS= { DEFAULT, DEFAULT, 233, 235, 7, INIT, NULL, AN};

   arg_ptr[ 0]= parameter;
   arg_ptr[ 1]= &X_dateiauswahlbox;
   arg_ptr[ 2]= &Y_dateiauswahlbox;
   ( char *)arg_ptr[ 3]= "*.*";
   MS.x= &X_prg_run;
   MS.y= &Y_prg_run;
   MS.msg= msg;
   MS.mauspos= mauspos;
   MS.arg_ptr= arg_ptr;
   PCX_Window( MS.x, MS.y, PCX_PRG_START, &MS.sa, SHADOW);
   setcolor( datcolor);
   ShowMouse( AUS);
   outtextxy( *MS.x+ 21, *MS.y+ 52, MakeShowPath( path, tmp_array, 23));
   ShowMouse( AN);
   do
   {
      switch( __CheckMousepos( &MS))
      {
	 case 2:                                         /* Verzeichnisbaum */
	    if( !ShowTree( parameter, &X_verzeichnisbaum, DEFAULT))
	       MS.statsp= REINIT;
	    break;
	 case 3:                                              /* LW-Auswahl */
	    if(( LW= LW_Auswahl( &X_lwausw, &Y_lwausw, "", NOTHING, ALL_DRIVES))>= 0)
	    {
	       sprintf( parameter, "%c:", 'A'+ LW);
	       MS.statsp= REINIT;
	    }
	    break;
	 case 0:                                                     /* ESC */
	 case 5:                                                 /* Abbruch */
	    ret_val= 1;
	 case 4:                                                      /* OK */
	    ret= 1;
	    break;
      }
   }while( !ret);
   ShowMouse( AUS);
   BigScreenRestore( &MS.sa, *MS.x, *MS.y);
   ShowMouse( AN);
   return( ret_val);            /* 0= o.k., 1= Abbruch */
}

BOOL WriteExecStartBAT( char *pfad, char *para, char FlexDirect)
{
   //              BAT_FLEX                        BAT_DIRECT
   // pfad    Directory der Datei        kompl. Suchweg der auszuf. Datei
   // para    auszuf. Kommandozeile      eventl. Parameter

   FILE *bat;
   BOOL ret_val= TRUE;
   unsigned delta;
   char verz[ MAXDIR], *ext_ptr, *exec_ptr;

   strcpy( prgexe_ptr, "~DSK##20.BAT");
   if(( bat= fopen( prgexe_path, "wt"))== NULL)
   {
      ErrorMsg( CREAT_ERROR"~DSK##20.BAT");
      ret_val= FALSE;
   }
   else
   {
      if( FlexDirect== BAT_DIRECT)
	 Path_to_Dir( verz, pfad);
      else
	 strcpy( verz, pfad);
      if( fprintf( bat, "%c:\nCD %s\n", *verz, verz)== EOF)
      {
	 ErrorMsg( WRITE_ERROR"~DSK##20.BAT");
	 ret_val= FALSE;
      }
      else
      {
	 if( FlexDirect== BAT_DIRECT)
	    exec_ptr= pfad;
	 else
	 {
	    if(( ext_ptr= strpbrk( para, " \t"))!= NULL)
	    {
	       if((( delta= ( ptrdiff_t)ext_ptr- ( ptrdiff_t)para)+ 1)> sizeof( verz))
		   delta= sizeof( verz)- 1;
	       *( strncpy( verz, para, delta)+ delta)= '\0';
	    }
	    else
	       *( strncpy( verz, para, sizeof( verz))+ sizeof( verz))= '\0';
	    if(( exec_ptr= searchpath( verz))== NULL)
	       exec_ptr= verz;
	 }
	 if(( ext_ptr= strrchr( exec_ptr, '.'))!= NULL)
	 {
	    if( !stricmp( ++ext_ptr, "BAT"))
	    {
	       if( fprintf( bat, "CALL ")== EOF)
	       {
		  ErrorMsg( WRITE_ERROR"~DSK##20.BAT");
		  ret_val= FALSE;
	       }
	    }
	    else
	    {
	       if( !stricmp( ext_ptr, "EXE")&& ( Is_Window_EXE( exec_ptr)> 0))
	       {
		  if( fprintf( bat, "WIN ")== EOF)
		  {
		     ErrorMsg( WRITE_ERROR"~DSK##20.BAT");
		     ret_val= FALSE;
		  }
	       }
	    }
	 }
	 if( ret_val== TRUE)
	 {
	    if(( FlexDirect== BAT_DIRECT)&& fwrite( pfad, strlen( pfad), 1, bat)!= 1)
	    {
	       ErrorMsg( WRITE_ERROR"~DSK##20.BAT");
	       ret_val= FALSE;
	    }
	    else
	    {
	       if( *para!= '\0')
	       {
		  if( fprintf( bat, " %s", para)== EOF)
		  {
		     ErrorMsg( WRITE_ERROR"~DSK##20.BAT");
		     ret_val= FALSE;
		  }
	       }
	       if( ret_val== TRUE)
	       {
		  getcwd( verz, MAXDIR);
		  if( fprintf( bat, "\n%c:\nCD %s\n", *verz, verz)== EOF)
		  {
		     ErrorMsg( WRITE_ERROR"~DSK##20.BAT");
		     ret_val= FALSE;
		  }
	       }
	    }
	 }
      }
      fclose( bat);
   }
   return( ret_val);
}

extern BOOL FlexExtension( char *filedir, char *filename);
extern BOOL isTxtFile( char *filename);

int _Exec( MAUSStruct *MS, int status, DATWINStruct *l_DW, DATWINStruct *r_DW, char *path_tab_ptr_l[], char *path_tab_ptr_r[], char Quelle, char *parameter)
{
   SaveFWindow_struct l_SFW= { SFW_LEER};
   SaveFWindow_struct r_SFW= { SFW_LEER};
   DATWINStruct *DW;
   char **tab_ptr;
   int ret_val= 0, extsp;
   char pfad[ MAXPATH], dir[ MAXDIR], buffer[ MAXPATH]= "", name[ 15];

   if( Quelle== LEFT)
   {
      DW= l_DW;
      tab_ptr= path_tab_ptr_l;
   }
   else
   {
      DW= r_DW;
      tab_ptr= path_tab_ptr_r;
   }
   extsp= AnztoDatei( DW, name, status);
   Paste_Filter_to_Dir( strcpy( pfad, Path_to_Dir( dir, DW->verzeichnis)), name);
   switch( extsp)
   {
      case DIR:
	 Get_Filter( buffer, DW->verzeichnis);
	 Paste_Filter_to_Dir( Paste_Filter_to_Dir( Path_to_Dir( DW->verzeichnis, DW->verzeichnis), name), buffer);
	 LoescheVar( MS, DW, tab_ptr);
	 break;
      case EXE:
      case COM:
      case BAT:
	 if( parameter!= NULL)
	    strcpy( buffer, parameter);
	 if( Start_PRG( pfad, buffer)== 0)
	 {
	    if( WriteExecStartBAT( pfad, buffer, BAT_DIRECT))
	    {
	       SaveFilewindow( &l_SFW, l_DW, path_tab_ptr_l, SFW_PERM_PLATTE);
	       SaveFilewindow( &r_SFW, r_DW, path_tab_ptr_r, SFW_PERM_PLATTE);
	       ExitMsg( 0);
	    }
	 }
	 break;
      default:
	 if( FlexExtension( dir, name))
	 {
	    SaveFilewindow( &l_SFW, l_DW, path_tab_ptr_l, SFW_PERM_PLATTE);
	    SaveFilewindow( &r_SFW, r_DW, path_tab_ptr_r, SFW_PERM_PLATTE);
	    ExitMsg( 0);
	 }
	 switch( extsp)
	 {
	    case ICO:
	       ShowIcoFile( pfad);
	       break;
	    case VOC:
	    case WAV:
	       _voc_play( pfad);
	       break;
	    default:
	       _Editor_Viewer( pfad, ( isTxtFile( pfad)) ? VIEW_ASCII : VIEW_HEX, NULL);
	       break;
	 }
	 break;
   }
   return( ret_val);
}

int MakePfad( char *dir, char *retpath, char *dirarray[], int nr)
{
   char *tmp_ptr, arraysp[ 13];

   *( strncpy( arraysp, dirarray[ nr]+ 1, 12)+ 12)= '\0';
   *strchr( arraysp, SPACE)= '\0';
   Paste_Filter_to_Dir( strcpy( retpath, dir), arraysp);
   if( strncmp( dirarray[ nr]+ DIRBEZEICHNUNGS_POS, DIRECTORYBEZEICHNUNG, sizeof( DIRECTORYBEZEICHNUNG)- 1)== 0)
      return( DIR);
   if(( tmp_ptr= strchr( arraysp+ 9, SPACE))!= NULL)
      *tmp_ptr= '\0';
   if( tmp_ptr!= arraysp+ 9)                    // Dateiextension vorhanden
      strcat( strcat( retpath, "."), arraysp+ 9);
   return( 0);
}

void Balken( int x, int y, int laenge, int hoehe, long wert, long grundwert, int *xsp)
{
   int xend, max;

   setcolor( EGA_LIGHTRED);
   setfillstyle( SOLID_FILL, EGA_RED);
   max= x+ laenge+ 3;
   if(( grundwert== 0)|| (( xend= x+ (( double)wert* ( double)laenge/ ( double)grundwert))> max))
      xend= max;
   if( x!= xend)
   {
      bar( x+ *xsp, y+ 1, xend, y+ hoehe);
      if( *xsp== 0)
	 line( x+ *xsp, y, x+ *xsp, y+ hoehe);
      line( x+ *xsp, y, xend, y);
   }
   *xsp= xend- x;
}

#define MAXCOPYSIZE 65534

int Copy( int x, int y, int laenge, int hoehe, char *q_path, char *z_path)
{
   struct ftime ft;
   int ret_val= 0, q_handle, z_handle, xsp= 0;
   unsigned schreiben, lesen;
   long datlaenge, z_sp= 0;
   unsigned long copy_len;
   char *mem_ptr;

   setfillstyle( SOLID_FILL, EGA_LIGHTGRAY);
   ShowMouse( AUS);
   bar( x, y, x+ laenge, y+ hoehe);
   ShowMouse( AN);
   if(( copy_len= coreleft())> MAXCOPYSIZE)
      copy_len= MAXCOPYSIZE;
   if(( mem_ptr= malloc( copy_len))!= NULL)
   {
      if(( q_handle= _open( q_path, O_RDONLY| O_BINARY))!= -1)
      {
	 if(( datlaenge= filelength( q_handle))> 0)
	 {
	    if(( z_handle= _creat( z_path, _chmod( q_path, 0)))!= -1)
	    {
	       getftime( q_handle, &ft);
	       do
	       {
		  if(( ( int)( lesen= _read( q_handle, mem_ptr, copy_len))== -1)|| ( ( int)( schreiben= _write( z_handle, mem_ptr, lesen))== -1))
		     ret_val= -4;
		  else
		  {
		     ShowMouse( AUS);
		     Balken( x, y, laenge, hoehe, z_sp+= schreiben, datlaenge, &xsp);
		     ShowMouse( AN);
		  }
	       }while( lesen&& ( lesen== schreiben)&& ( ret_val== 0));
	       if( lesen!= schreiben)
		  ret_val= -5;
	       setftime( z_handle, &ft);
	       _close( z_handle);
	       if( ret_val!= 0)
		  unlink( z_path);
	    }
	    else
	       ret_val= -3;
	 }
	 _close( q_handle);
      }
      else
	 ret_val= -2;
      free( mem_ptr);
   }
   else
      ret_val= -1;
   return( ret_val);
}

void Viewen( MAUSStruct *d_MS, DATWINStruct *l_DW, DATWINStruct *r_DW, char *path_tab_ptr_l[], char *path_tab_ptr_r[], char Quelle)
{
   DATWINStruct *q_DW;
   char **q_tab;
   char p_dir[ MAXPATH];
   int l;

   if( Quelle== LEFT)
   {
      q_DW= l_DW;
      q_tab= path_tab_ptr_l;
   }
   else
   {
      q_DW= r_DW;
      q_tab= path_tab_ptr_r;
   }
   if( q_DW->anz_mark== 0)
   {
      Hinweis( "No file marked for viewing  ");
   }
   else
   {
      Path_to_Dir( p_dir, q_DW->verzeichnis);
      for( l= 0; l< q_DW->RB->max; l++)
      {
	 if( *q_DW->dir_entrys[ l]== ANGEWAEHLT)
	 {
	    MakePfad( p_dir, p_dir, q_DW->dir_entrys, l);
	    _Editor_Viewer( p_dir, VIEW, NULL);
	    *q_DW->dir_entrys[ l]= ABGEWAEHLT;
	    break;
	 }
      }
      LoescheVar( d_MS, q_DW, q_tab);
   }
}

void Editieren( MAUSStruct *d_MS, DATWINStruct *l_DW, DATWINStruct *r_DW, char *path_tab_ptr_l[], char *path_tab_ptr_r[], char Quelle)
{
   SaveFWindow_struct l_SFW= { SFW_LEER};
   SaveFWindow_struct r_SFW= { SFW_LEER};
   DATWINStruct *q_DW;
   char **q_tab;
   char p_dir[ MAXPATH], *argv[ 4];
   int l, arr_offset;

   if( interner_Editor|| ( *editor_path!= '\0'))
   {
      if( !interner_Editor&& access( editor_path, 0))
	 Hinweis( "The external editor does not exist");
      else
      {
	 ( Quelle== LEFT) ? ( q_DW= l_DW) : ( q_DW= r_DW);
	 if( q_DW->anz_mark== 0)
	 {
	    Hinweis( "No file marked for editing        ");
	 }
	 else
	 {
	    Path_to_Dir( p_dir, q_DW->verzeichnis);
	    for( l= 0; l< q_DW->RB->max; l++)
	    {
	       if( *q_DW->dir_entrys[ l]== ANGEWAEHLT)
	       {
		  MakePfad( p_dir, p_dir, q_DW->dir_entrys, l);
		  *q_DW->dir_entrys[ l]= ABGEWAEHLT;
		  if( interner_Editor)
		     _Editor_Viewer( p_dir, EDIT, NULL);
		  else
		  {
		     if( WriteStartBAT()== 0)
		     {
			SaveFilewindow( &l_SFW, l_DW, path_tab_ptr_l, SFW_PERM_PLATTE);
			SaveFilewindow( &r_SFW, r_DW, path_tab_ptr_r, SFW_PERM_PLATTE);
			saveSystem( "DB2_EINS.TMP");
			Free_All_Resourcen();
			argv[ 0]= "WIN";
			argv[ 1]= editor_path;
			argv[ 2]= p_dir;
			argv[ 3]= NULL;
			( Is_Window_EXE( editor_path)> 0) ? ( arr_offset= 0) : ( arr_offset= 1);
			if( execvp( argv[ arr_offset], &argv[ arr_offset])== -1)
			   exit( 0);
		     }
		  }
		  break;
	       }
	    }
	    LoescheVar( d_MS, l_DW, path_tab_ptr_l);
	    LoescheVar( d_MS, r_DW, path_tab_ptr_r);
	 }
      }
   }
   else
      Hinweis( "No external editor specified (System setup->More...)    ");
}

void Icon_extrahieren( MAUSStruct *d_MS, DATWINStruct *l_DW, DATWINStruct *r_DW, char *path_tab_ptr_l[], char *path_tab_ptr_r[], char Quelle)
{
   DATWINStruct *q_DW;
   char **q_tab;
   char dir[ MAXDIR], path[ MAXPATH], iconpathsp[ MAXDIR], *f_ptr;
   BOOL work= 0;
   WORD lf_nr;
   int l, X_tree= 300, ret= 0;
   void *arg_ptr[ 2];
   WORD mauspos[]= { BUTTON|   FRAME| KEY,              5,  27,   5,  21, ESC,
		     DIRINPUT| IGN_CASE| FRAME| KEY,             21,  47, 175, MAXDIR- 1, 205,  38, LWAUSWAHL, 'z',
		     BUTTON|   FRAME| KEY| DEFBUTTON,  48, 125, 111, 163, RETURN,
		     BUTTON|   FRAME| KEY,            146, 223, 111, 163, 'a',
		     MOVEWINDOW };
   MAUSStruct MS= { DEFAULT, DEFAULT, 273, 183, 5, INIT, NULL, AUS};

   arg_ptr[ 0]= strcpy( iconpathsp, default_icon_path);
   arg_ptr[ 1]= &X_tree;
   ( Quelle== LEFT) ? ( q_DW= l_DW) : ( q_DW= r_DW);
   if( q_DW->anz_mark== 0)
   {
      Hinweis( "No file(s) marked for extracting icons         ");
   }
   else
   {
      MS.x= &X_ICO_extrakt;
      MS.y= &Y_ICO_extrakt;
      MS.mauspos= mauspos;
      MS.arg_ptr= arg_ptr;
      PCX_Window( MS.x, MS.y, PCX_ICON_EXTRAHIEREN, &MS.sa, SHADOW);
      do
      {
	 switch( __CheckMousepos( &MS))
	 {
	    case 2:                                                   /* OK */
	       strcat( iconpathsp, "\\");
	       f_ptr= path+ strlen( Path_to_Dir( dir, q_DW->verzeichnis))+ 1;
	       for( l= 0; l< q_DW->RB->max; l++)
	       {
		  if( *q_DW->dir_entrys[ l]== ANGEWAEHLT)
		  {
		     if( Break( 200, 275, "Really abort\nfunction?"))
			break;
		     if( MakePfad( dir, path, q_DW->dir_entrys, l)!= DIR)
		     {
			setcolor( datcolor);
			ShowMouse( AUS);
			ClearTextN( *MS.x+ 24, *MS.y+ 88, 12);
			outtextxy(  *MS.x+ 24, *MS.y+ 88, f_ptr);
			ShowMouse( AN);
			lf_nr= 0;
			WinEXEIcons( path, iconpathsp, &lf_nr); /* z_path --> LW:\PATH\ */
			if( lf_nr> 0)
			{
			   ShowMouse( AUS);
			   setfillstyle( SOLID_FILL, EGA_LIGHTGRAY);
			   bar( *MS.x+ 58, *MS.y+ 121, *MS.x+ 89, *MS.y+ 152);
			   ShowPicture( *MS.x+ 58, *MS.y+ 121, iconpathsp);
			   ShowMouse( AN);
			}
			*q_DW->dir_entrys[ l]= ABGEWAEHLT;
			work= 1;
		     }
		  }
	       }
	    case 0:                                                  /* ESC */
	    case 3:                                              /* Abbruch */
	       ret= 1;
	       break;
	 }
      }while( !ret);
      ShowMouse( AUS);
      BigScreenRestore( &MS.sa, *MS.x, *MS.y);
      ShowMouse( AN);
      if( work)
      {
	 LoescheVar( d_MS, l_DW, path_tab_ptr_l);
	 LoescheVar( d_MS, r_DW, path_tab_ptr_r);
      }
   }
}

int Sort_Krit( int *x, int *y, DATWINStruct *DW, BYTE *Sort_Typ)
{
   int ret_val= 0, ret= 0;
   char sortsp;
   void *arg_ptr[ 5];
   WORD mauspos[]= { BUTTON|      FRAME| KEY,              5,  27,   5,  21, ESC,
		     RADIOBUTTON| FRAME| KEY| MSG,        25,  41, SORT_FILE, 'n',
		     RADIOBUTTON| FRAME| KEY| MSG,        25,  60, SORT_EXT,  'e',
		     RADIOBUTTON| FRAME| KEY| MSG,        25,  79, SORT_SIZE, 'g',
		     RADIOBUTTON| FRAME| KEY| MSG,        25,  98, SORT_DATE, 'd',
		     RADIOBUTTON| FRAME| KEY| MSG,        25, 117, SORT_TIME, 'z',
		     BUTTON|      FRAME| KEY| DEFBUTTON,  16,  90, 142, 184, RETURN,
		     BUTTON|      FRAME| KEY,            101, 175, 142, 184, 'a',
		     MOVEWINDOW};
   MAUSStruct MS= { DEFAULT, DEFAULT, 192, 199, 9, INIT, NULL, AUS};

   sortsp= DW->Sort_Typ;
   arg_ptr[ 0]= arg_ptr[ 1]= arg_ptr[ 2]= arg_ptr[ 3]= arg_ptr[ 4]= &sortsp;
   MS.x= x;
   MS.y= y;
   MS.mauspos= mauspos;
   MS.arg_ptr= arg_ptr;
   PCX_Window( MS.x, MS.y, PCX_DATEISORTIERUNG, &MS.sa, SHADOW);
   do
   {
      switch( __CheckMousepos( &MS))
      {
	 case 6:                                                  /* Return */
	    if( DW->Sort_Typ!= sortsp)
	    {
	       ret_val= 1;
	       veraendert= 1;
	       *Sort_Typ= sortsp;
	    }
	 case 0:                                                     /* Esc */
	 case 7:                                                 /* Abbruch */
	    ret= 1;
	    break;
      }
   }while( !ret);
   ShowMouse( AUS);
   BigScreenRestore( &MS.sa, *x, *y);
   ShowMouse( AN);
   return( ret_val);
}

void DOS_Schirm( void)
{
   saveall sa;
   int G_mode, Taste;

   if( Save_DOS)
   {
      ShowMouse( AUS);
      SaveAll( &sa);
      G_mode= getgraphmode();
      restorecrtmode();
      Show_Text_Screen();
      while(( MouseStat()== NOTHING)&& (( Taste= kbhit())== 0))
	 ;
      if( Taste)
      {
	 if( !getch())
	    getch();
      }
      else
	 while( MouseStat()!= NOTHING);
      screensp= 0;
      setgraphmode( G_mode);
      MouseArt( maus_pfeil);                       /* neuen Mauspfeil anzeigen */
      SetPal();                                       /* Farbtabelle verndern */
      RestoreAll( &sa);
      ShowMouse( AN);
   }
   else
      Info_Frage( 220, 200, "The saving of the\nDOS screen is\ndeactivated.\n(System setup->More...)", INFO);
}

void New_File_Edit( DATWINStruct *l_DW, DATWINStruct *r_DW, char Quelle)
{
   char Path[ MAXPATH]= "";

   _Editor_Viewer( Path, EDIT, ( Quelle== LEFT) ? l_DW : r_DW);
}

void More_Datmanager( MAUSStruct *d_MS, DATWINStruct *l_DW, DATWINStruct *r_DW, char *path_tab_ptr_l[], char *path_tab_ptr_r[], char Quelle)
{
   int lw, ret= 0;
   BOOL _reload= 0;
   char *msg[]= { "View the contents of the DOS screen   ",
		  "Search for files or their contents on chosen disks          ",
		  "Create a new text file for editing ",
		  "Display information about a disk (FAT, sectors, free space, etc.)  ",
		  "Make a number of copies from a disk                ",
		  "Compare a number of disks with a disk                  ",
		  "Quickly erase a disk, or completely overwrite it       ",
		  "Format disk         ",
		  "Give a disk a name (label)                        ",
		  "Display the File Allocation Table (FAT) of a disk        ",
		  "Refresh the magnetic surface of an older disk    ",
		  "Verify the physical readability of a disk             "};
   WORD mauspos[]= { BUTTON| FRAME| KEY,                   5,  27,   5,  21, ESC,
		     BUTTON| FRAME| KEY|            MSG,   9,  78,  27,  79, 'o',
		     BUTTON| FRAME| KEY|            MSG,  81, 150,  27,  79, 'd',
		     BUTTON| FRAME| KEY|            MSG, 153, 222,  27,  79, 'n',
		     BUTTON| FRAME| KEY| DEFBUTTON| MSG,   9,  78, 107, 159, 'i',
		     BUTTON| FRAME| KEY|            MSG,  81, 150, 107, 159, 'k',
		     BUTTON| FRAME| KEY|            MSG, 153, 222, 107, 159, 'v',
		     BUTTON| FRAME| KEY|            MSG,   9,  78, 162, 214, 'l',
		     BUTTON| FRAME| KEY|            MSG,  81, 150, 162, 214, 'f',
		     BUTTON| FRAME| KEY|            MSG, 153, 222, 162, 214, 'b',
		     BUTTON| FRAME| KEY|            MSG,   9,  78, 217, 269, 'a',
		     BUTTON| FRAME| KEY|            MSG,  81, 150, 217, 269, 'u',
		     BUTTON| FRAME| KEY|            MSG, 153, 222, 217, 269, 'p',
		     MOVEWINDOW};
   MAUSStruct MS= { DEFAULT, DEFAULT, 232, 280, 14, INIT, NULL, AN};

   MS.x= &X_ext_datm;
   MS.y= &Y_ext_datm;
   MS.msg= msg;
   MS.mauspos= mauspos;
   PCX_Window( MS.x, MS.y, PCX_MEHR, &MS.sa, SHADOW);
   do
   {
      switch( __CheckMousepos( &MS))
      {
	 case 0:                                                     /* ESC */
	    ret= 1;
	    break;
	 case 1:                                              /* DOS-Schirm */
	    DOS_Schirm();
	    break;
	 case 2:                                             /* Superfinder */
	    if( _Finder())
	       _reload= 1;
	    break;
	 case 3:                                    /* neue Datei editieren */
	    New_File_Edit( l_DW, r_DW, Quelle);
	    _reload= 1;
	    break;
	 case 4:                                                /* Diskinfo */
	    DiskInfo( LWAUSWAHL);
	    break;
	 case 5:                                                /* Diskcopy */
	    DCopy_DComp( KOPIE);
	    break;
	 case 6:                                                /* Diskcomp */
	    DCopy_DComp( VERGLEICH);
	    break;
	 case 7:                                             /* Disklschen */
	    Disk_Loeschen();
	    break;
	 case 8:                                             /* Formatieren */
	    Formatieren();
	    break;
	 case 9:                                                   /* Label */
	    if((( lw= DiskLabel( LWAUSWAHL))!= -1)&& ( *MS.y> 54))
	    {
	       if( *l_DW->verzeichnis== lw)
		  ShowDInfo( l_DW);
	       if( *r_DW->verzeichnis== lw)
		  ShowDInfo( r_DW);
	    }
	    break;
	 case 10:                                           /* FAT anzeigen */
	    ShowFAT();
	    break;
	 case 11:                                       /* Disk auffrischen */
	    Disk_Auffrischen_Pruefen( AUFFRISCHEN);
	    break;
	 case 12:                                            /* Disk prfen */
	    Disk_Auffrischen_Pruefen( PRUEFEN);
	    break;
      }
   }while( !ret);
   ShowMouse( AUS);
   BigScreenRestore( &MS.sa, *MS.x, *MS.y);
   ShowMouse( AN);
   if( _reload)
   {
      LoescheVar( d_MS, l_DW, path_tab_ptr_l);
      LoescheVar( d_MS, r_DW, path_tab_ptr_r);
   }
}

int DATWIN_Uebernehmen( DATWINStruct *z_DW, char *z_path_tab_ptr[], DATWINStruct *q_DW, MAUSStruct *z_MS)
{
   typedef int ( *fcmp) ( const void *, const void *);
   int ret_val= 0;

   FreeArray( z_DW);
   z_DW->anz_mark=            q_DW->anz_mark;
   z_DW->gesbyte_mark=        q_DW->gesbyte_mark;
   z_DW->entry_mark=          -1;
   strcpy( z_DW->old_verzeichnis, strcpy( z_DW->verzeichnis, q_DW->verzeichnis));
   z_DW->RB->min=             q_DW->RB->min;
   z_DW->RB->proz=            q_DW->RB->proz;
   z_DW->RB->Zeiger_pos=      q_DW->RB->Zeiger_pos;
   for( z_DW->RB->max= 0L; z_DW->RB->max< q_DW->RB->max; z_DW->RB->max++)
   {
      if(( z_DW->dir_entrys[ z_DW->RB->max]= malloc( ENTRY_LENGTH))!= NULL)
      {
	 memcpy( z_DW->dir_entrys[ z_DW->RB->max], q_DW->dir_entrys[ z_DW->RB->max], ENTRY_LENGTH);
	 if( z_DW->Win_Typ== RIGHT)
	    z_DW->dir_entrys[ z_DW->RB->max][ 26]= '\0';
	 else
	    z_DW->dir_entrys[ z_DW->RB->max][ 26]= SPACE;
      }
      else
      {
	 for( ret_val= 0; ret_val< z_DW->RB->max; ret_val++)
	    free( z_DW->dir_entrys[ ret_val]);
	 ErrorMsg( KEIN_SPEICHER);
	 if( z_DW->RB->max> 10L)      /* Speichermangel nicht ganz so fatal */
	    ret_val= NOT_MEMORY;
	 else
	    ret_val= FATAL_MEMORY;
	 z_DW->RB->max= 0;
	 break;
      }
   }
   if( !ret_val)
   {
      if( z_DW->Sort_Typ!= q_DW->Sort_Typ)
      {
	 Sort_Typ= z_DW->Sort_Typ;    /* globale Variable fr Sortfilter() setzen */
	 qsort( z_DW->dir_entrys, z_DW->RB->max, sizeof( char *), ( fcmp)Sortfilter);
      }
      ShowDInfo( z_DW);
      DirEntry( z_DW);
      GesDat( z_DW);
      _EntryInPullTable( z_path_tab_ptr, MAX_PATH_TAB_ENTRY, z_DW->verzeichnis, TRUE);
      z_MS->statsp= REINIT;
   }
   return( ret_val);
}

void newLW( int *X_lw, int *Y_lw, DATWINStruct *DW, MAUSStruct *MS, char *path_tab_ptr[])
{
   int LW;
   char tmp_array[ DW_MAXFILTER];

   if(( LW= LW_Auswahl( X_lw, Y_lw, "Which drive should be displayed in the file window?      ", NOTHING, ALL_DRIVES| DRIVE_READY))>= 0)
   {
      Get_Filter( tmp_array, DW->verzeichnis);
      Paste_Filter_to_Dir( _getdcwd( LW+ 1, DW->verzeichnis, MAXDIR), tmp_array);
      *DW->old_verzeichnis= '\0';
      LoescheVar( MS, DW, path_tab_ptr);
   }
}

void Root( DATWINStruct *DW, MAUSStruct *MS, char *path_tab_ptr[])
{
   char tmp_array[ DW_MAXFILTER];

   if( strrchr( DW->verzeichnis, '\\')> ( DW->verzeichnis+ 2))
   {
      strcpy( DW->verzeichnis+ 3, Get_Filter( tmp_array, DW->verzeichnis));
      LoescheVar( MS, DW, path_tab_ptr);
   }
   else
      Hinweis( "You are already in the root directory      ");
}

void VaterVerzeichnis( DATWINStruct *DW, MAUSStruct *MS, char *path_tab_ptr[])
{
   char tmp_array[ DW_MAXFILTER], *tmp_ptr;

   Get_Filter( tmp_array, DW->verzeichnis);
   if(( tmp_ptr= strrchr( DW->verzeichnis, '\\'))> ( DW->verzeichnis+ 2))
   {
      while(( *( --tmp_ptr)!= '\\')&& ( tmp_ptr> DW->verzeichnis))
	 ;
      if( *tmp_ptr== '\\')
	 strcpy( tmp_ptr+ 1, tmp_array);
      LoescheVar( MS, DW, path_tab_ptr);
   }
   else
      Hinweis( "You are already in the root directory      ");
}

void newPath_Enter( DATWINStruct *DW, MAUSStruct *MS, char *path_tab_ptr[])
{
   if( *( stpcpy( DW->verzeichnis, path_tab_ptr[ 0])- 1)== '\\')
   {
      strcat( path_tab_ptr[ 0], "*.*");   /* verhindert, da der ungltige Eintrag in die Tabelle bernommen wird */
      strcat( DW->verzeichnis, "*.*");
   }
   *DW->old_verzeichnis= '\0';
   LoescheVar( MS, DW, path_tab_ptr);
}

void Reload_Path( DATWINStruct *DW, MAUSStruct *MS, char *path_tab_ptr[])
{
   char tmp_dir[ MAXPATH], tmp_array[ DW_MAXFILTER];

   if( !DiskReady( *DW->verzeichnis- 'A'))
   {
      if( access( Path_to_Dir( tmp_dir, DW->verzeichnis), 0))
      {
	 sprintf( tmp_dir, "%c:\\", *DW->verzeichnis);
	 if( access( tmp_dir, 0))
	    return;
	 strcpy( DW->verzeichnis, strcat( tmp_dir, Get_Filter( tmp_array, DW->verzeichnis)));
      }
      *DW->old_verzeichnis= '\0';
      LoescheVar( MS, DW, path_tab_ptr);
   }
}

void Tree( int *X, DATWINStruct *DW, MAUSStruct *MS, char *path_tab_ptr[])
{
   char tmp_array[ DW_MAXFILTER];

   Get_Filter( tmp_array, DW->verzeichnis);
   if( !ShowTree( DW->verzeichnis, X, DW->verzeichnis[ 0]))
   {
      Paste_Filter_to_Dir( DW->verzeichnis, tmp_array);
      *DW->old_verzeichnis= '\0';
      LoescheVar( MS, DW, path_tab_ptr);
   }
}

typedef struct ffblk ffblk;

#define _PATH                   ( char *)arg_ptr[ 0]

int _findfiletree( void **arg_ptr, ffblk *ffblk_ptr)
{
   Paste_Filter_to_Dir( getcwd( _PATH, MAXPATH), ffblk_ptr->ff_name);
   return( -1);        /* Fehler wird vorgetuscht, um die Suche zu beenden */
}

void _FindFile( DATWINStruct *DW, MAUSStruct *D_MS, char *path_tab_ptr[])
{
   int ret= 0, i, anzlw, X_lw= 190, Y_lw= 200, X_tree= 300;
   BOOL Found= 0;
   char path[ MAXPATH]= "", start_dir[ MAXDIR]= "", lw[ 26];
   void *arg_ptr[ 3];
   WORD mauspos[]= { BUTTON|   FRAME| KEY,              5,  27,   5,  21, ESC,
		     INPUT| IGN_CASE|    FRAME| KEY| DEFBUTTON,  18,  44, 144,  12, 'd',
		     DIRINPUT| IGN_CASE| FRAME| KEY,             18,  79, 273, MAXDIR- 1, 245,  37, LWAUSWAHL, 'v',
		     BUTTON|   FRAME| KEY,             18, 150, 109, 134, RETURN,
		     BUTTON|   FRAME| KEY,            160, 291, 109, 134, 'a',
		     MOVEWINDOW };
   MAUSStruct MS= { DEFAULT, DEFAULT, 310, 151, 6, INIT, NULL, AUS};

   arg_ptr[ 0]= path;
   arg_ptr[ 1]= start_dir;
   arg_ptr[ 2]= &X_tree;
   MS.x= &X_findfile;
   MS.y= &Y_findfile;
   MS.mauspos= mauspos;
   MS.arg_ptr= arg_ptr;
   PCX_Window( MS.x, MS.y, PCX_FINDFILE, &MS.sa, SHADOW);
   do
   {
      switch( __CheckMousepos( &MS))
      {
	 case 3:                                                      /* OK */
	    if( *start_dir== '\0')
	    {
	       memset( lw, 0, sizeof( lw));
	       if(( anzlw= LW_Anwahl( &X_lw, &Y_lw, lw, "Select all drives to be searched                          ", NOTHING, ALL_DRIVES))> 0)
	       {
		  for( i= 0; i< anzlw; i++)
		  {
		     if(( ret= LW_TREE_Funktion( lw[ i], path, _findfiletree, arg_ptr, FILE_SEARCH))!= 0)
			break;
		  }
	       }
	       else
		  ret= -2;                                       /* Abbruch */
	    }
	    else
	       ret= TREE_Funktion( start_dir, path, _findfiletree, arg_ptr, FILE_SEARCH);
	    switch( ret)
	    {
	       case 0:
		  Hinweis( "Could not find the file (search pattern)  ");
		  break;
	       case -1:                            /* Suche war erfolgreich */
		  Found= 1;
		  break;
	       case -3:                  /* falsches Verzeichnis eingegeben */
	       case -4:
		  ErrorMsg( "Could not change to the directory given");
		  ret= 0;
		  break;
	    }
	    break;
	 case 0:                                                     /* ESC */
	 case 4:                                                 /* Abbruch */
	    ret= 1;
	    break;
      }
   }while( !ret);
   ShowMouse( AUS);
   BigScreenRestore( &MS.sa, *MS.x, *MS.y);
   ShowMouse( AN);
   if( Found)
   {
      strcpy( DW->verzeichnis, path);
      LoescheVar( D_MS, DW, path_tab_ptr);
   }
}

extern BYTE Get_Call_mode( void);
extern char *Tausender_Gruppen( char *, unsigned long);

#define _Q_CLUSTER               ( *( unsigned *)arg_ptr[ 0])
#define _Z_CLUSTER               ( *( unsigned *)arg_ptr[ 1])
#define _ANZ_DIRS                ( *( unsigned *)arg_ptr[ 2])
#define _ANZ_FILES               ( *( unsigned *)arg_ptr[ 3])
#define _FILESLEN           ( *( unsigned long *)arg_ptr[ 4])
#define _Q_BEDARF           ( *( unsigned long *)arg_ptr[ 5])
#define _Z_BEDARF           ( *( unsigned long *)arg_ptr[ 6])
#define _Q_DW                 ( ( DATWINStruct *)arg_ptr[ 7])
#define _TMP_ARRAY                      ( char *)arg_ptr[ 8]
#define _DIR                            ( char *)arg_ptr[ 9]

int _Q_info( void **arg_ptr, ffblk *ffblk_ptr)
{
   BOOL work= 0;
   char *tmp_ptr;
   int i;

   getcwd( _TMP_ARRAY, MAXDIR);
   if( Get_Call_mode()== DIR_SEARCH_VOR)
   {
      if( stricmp( _TMP_ARRAY, _DIR))
      {
	 if(( tmp_ptr= _TMP_ARRAY+ strlen( _TMP_ARRAY)- strlen( ffblk_ptr->ff_name))== _TMP_ARRAY+ 3)
	    *tmp_ptr= '\0';
	 else
	    *( tmp_ptr- 1)= '\0';
	 if( !stricmp( _TMP_ARRAY, _DIR))
	 {
	    for( i= 0; i< _Q_DW->RB->max; i++)
	    {
	       AnztoDatei( _Q_DW, _TMP_ARRAY, i- _Q_DW->RB->proz);
	       if( _Filter( _TMP_ARRAY, ffblk_ptr->ff_name, ANWAHL))
	       {
		  if( *_Q_DW->dir_entrys[ i]== ANGEWAEHLT)
		     work= 1;
		  break;
	       }
	    }
	    if( work)
	       _ANZ_DIRS++;
	    else
	       return( EXIT_DIR);
	 }
	 else
	    _ANZ_DIRS++;
      }
   }
   else
   {
      if( !stricmp( _TMP_ARRAY, _DIR))
      {
	 for( i= 0; i< _Q_DW->RB->max; i++)
	 {
	    AnztoDatei( _Q_DW, _TMP_ARRAY, i- _Q_DW->RB->proz);
	    if( _Filter( _TMP_ARRAY, ffblk_ptr->ff_name, ANWAHL))
	    {
	       if( *_Q_DW->dir_entrys[ i]== ANGEWAEHLT)
		  work= 1;
	       break;
	    }
	 }
      }
      else
	 work= 1;
      if( work)
      {
	 _ANZ_FILES++;
	 _FILESLEN+= ffblk_ptr->ff_fsize;
	 _Q_BEDARF+= (( ffblk_ptr->ff_fsize+ ( _Q_CLUSTER- 1))/ _Q_CLUSTER)* _Q_CLUSTER;
	 _Z_BEDARF+= (( ffblk_ptr->ff_fsize+ ( _Z_CLUSTER- 1))/ _Z_CLUSTER)* _Z_CLUSTER;
      }
   }
   return( 0);
}

int X_q_z_info= 60, Y_q_z_info= 58;

void Q_Z_Info( DATWINStruct *l_DW, DATWINStruct *r_DW, char Quelle)
{
   struct textsettingstype text;
   DATWINStruct *q_DW, *z_DW;
   struct diskfree_t q_free, z_free;
   int ret= 0, status;
   long Z_free;
   unsigned Q_Cluster, Z_Cluster, Anz_dirs= 0, Anz_files= 0;
   unsigned long Fileslen= 0L, Q_Bedarf= 0L, Z_Bedarf= 0L;
   char tmp_array[ MAXDIR], dir[ MAXDIR];
   void *arg_ptr[ 10];
   char *msg[]= { "Show physical and logical information on the source drive  ",
		  "Show physical and logical information on the target drive  "};
   WORD mauspos[]= { BUTTON| FRAME| KEY,                   5,  27,   5,  21, ESC,
		     BUTTON| FRAME| KEY|            MSG, 273, 342, 263, 315, 'u',
		     BUTTON| FRAME| KEY|            MSG, 347, 416, 263, 315, 'i',
		     BUTTON| FRAME| KEY| DEFBUTTON,      421, 490, 263, 315, RETURN,
		     MOVEWINDOW };
   MAUSStruct MS= { DEFAULT, DEFAULT, 507, 325, 5, INIT, NULL, AN};

   if( Quelle== LEFT)
   {
      q_DW= l_DW;
      z_DW= r_DW;
   }
   else
   {
      q_DW= r_DW;
      z_DW= l_DW;
   }
   MS.x= &X_q_z_info;
   MS.y= &Y_q_z_info;
   MS.msg= msg;
   MS.mauspos= mauspos;
   PCX_Window( MS.x, MS.y, PCX_Q_Z_INFO, &MS.sa, SHADOW);
   if( !_dos_getdiskfree( *q_DW->verzeichnis- 64, &q_free)&& !_dos_getdiskfree( *z_DW->verzeichnis- 64, &z_free))
   {
      Q_Cluster= q_free.sectors_per_cluster* q_free.bytes_per_sector;
      Z_Cluster= z_free.sectors_per_cluster* z_free.bytes_per_sector;
      arg_ptr[ 0]= &Q_Cluster;
      arg_ptr[ 1]= &Z_Cluster;
      arg_ptr[ 2]= &Anz_dirs;
      arg_ptr[ 3]= &Anz_files;
      arg_ptr[ 4]= &Fileslen;
      arg_ptr[ 5]= &Q_Bedarf;
      arg_ptr[ 6]= &Z_Bedarf;
      arg_ptr[ 7]= q_DW;
      arg_ptr[ 8]= tmp_array;
      arg_ptr[ 9]= Path_to_Dir( dir, q_DW->verzeichnis);
      if( !( ret= TREE_Funktion( Path_to_Dir( tmp_array, q_DW->verzeichnis), "*.*", _Q_info, arg_ptr, DIR_SEARCH_VOR| FILE_SEARCH)))
      {
	 setcolor( EGA_BLACK);
	 ShowMouse( AUS);
	 sprintf( tmp_array, "%u", Anz_dirs);
	 outtextxy( *MS.x+ 384, *MS.y+ 69, tmp_array);
	 sprintf( tmp_array, "%u", Anz_files);
	 outtextxy( *MS.x+ 384, *MS.y+ 84, tmp_array);
	 outtextxy( *MS.x+ 384, *MS.y+ 99, Tausender_Gruppen( tmp_array, Fileslen));
	 outtextxy( *MS.x+ 384, *MS.y+ 114, Tausender_Gruppen( tmp_array, Q_Bedarf));
	 outtextxy( *MS.x+ 384, *MS.y+ 129, Tausender_Gruppen( tmp_array, ( long)q_free.avail_clusters* ( long)q_free.bytes_per_sector* ( long)q_free.sectors_per_cluster));
	 outtextxy( *MS.x+ 384, *MS.y+ 179, Tausender_Gruppen( tmp_array, Z_Bedarf));
	 outtextxy( *MS.x+ 384, *MS.y+ 194, Tausender_Gruppen( tmp_array, Z_free= ( long)z_free.avail_clusters* ( long)z_free.bytes_per_sector* ( long)z_free.sectors_per_cluster));
	 gettextsettings( &text);
	 settextjustify( CENTER_TEXT, text.vert);
	 outtextxy( *MS.x+ 253, *MS.y+ 230, ( Z_Bedarf> Z_free) ? ( "Selected files incompatible with target medium! ") : ( "Selected files compatible with target medium.    "));
	 settextjustify( text.horiz, text.vert);
	 ShowMouse( AN);
	 do
	 {
	    switch( status= __CheckMousepos( &MS))
	    {
	       case 1:                                           /* Q_Diskinfo */
	       case 2:                                           /* Z_Diskinfo */
		  DiskInfo( ( status== 1) ? ( *q_DW->verzeichnis) : ( *z_DW->verzeichnis));
		  break;
	       case 0:                                                  /* ESC */
	       case 3:                                                   /* OK */
		  ret= 1;
		  break;
	    }
	 }while( !ret);
      }
      else
      {
	 if( ret!= -2)
	    ErrorMsg( "Could not set directory (drive)");
      }
   }
   else
      ErrorMsg( "Error calculating free disk space");
   ShowMouse( AUS);
   BigScreenRestore( &MS.sa, *MS.x, *MS.y);
   ShowMouse( AN);
}

#define SFW_TMP_PLATTE     1   /* es wird nur eine temporre Datei angelegt */
#define SFW_XMS            2   /* die Daten werden im Extended-Memory gespeichert */

/* nur diese beiden Typen sind als Funktionsparameter zugelassen !!!

#define SFW_TMP            3   -> Daten werden temporr gespeichert (...wo ermittelt die Funktion)
#define SFW_PERM_PLATTE    4   -> wird dauerhaft auf Festplatte gespeichert

*/

void FreeSFW( SaveFWindow_struct *SFW)
{
   switch( SFW->mode)
   {
      case SFW_XMS:
	 XMSFreeMem( SFW->XMS_handle);
	 break;
      case SFW_TMP_PLATTE:
	 fclose( SFW->file);
	 break;
   }
   SFW->mode= SFW_LEER;
}

int SaveFilewindow( SaveFWindow_struct *SFW, DATWINStruct *DW, char *path_tab_ptr[], BYTE Mode)
{
   int ret_val= 0, i;
   unsigned long offset;

   FreeSFW( SFW);
   strcpy( DW->old_verzeichnis, DW->verzeichnis);
   if( Mode== SFW_TMP)
   {
      if(( SFW->XMS_handle= XMSGetMem((( DW->RB->max* ((( ENTRY_LENGTH+ 1)/ 2)* 2))+ (( sizeof( DATWINStruct)/ 2)* 2)+ (( sizeof( RBalken)/ 2)* 2)+ 1023)>> 10))!= 0)
	 SFW->mode= SFW_XMS;
      else
      {
	 if(( SFW->file= tmpfile())!= NULL)
	    SFW->mode= SFW_TMP_PLATTE;
	 else
	    ret_val= -1;
      }
   }
   else
   {
      strcpy( prgexe_ptr, ( DW->Win_Typ== LEFT) ? "~LDM##20.SAV" : "~RDM##20.SAV");
      if(( SFW->file= fopen( prgexe_path, "wb"))!= NULL)
	 SFW->mode= SFW_PERM_PLATTE;
      else
	 ret_val= -1;
   }
   switch( SFW->mode)
   {
      case SFW_XMS:
	 XMSCopy( 0, ( ptrdiff_t)DW->RB, SFW->XMS_handle, 0, ( sizeof( RBalken)+ 1)/ 2);
	 offset= (( sizeof( RBalken)+ 1)/ 2)* 2;
	 XMSCopy( 0, ( ptrdiff_t)DW, SFW->XMS_handle, offset, ( sizeof( DATWINStruct)+ 1)/ 2);
	 offset+= (( sizeof( DATWINStruct)+ 1)/ 2)* 2;
	 for( i= 0; i< DW->RB->max; i++)
	 {
	    XMSCopy( 0, ( ptrdiff_t)DW->dir_entrys[ i], SFW->XMS_handle, offset, ( ENTRY_LENGTH+ 1)/ 2);
	    offset+= (( ENTRY_LENGTH+ 1)/ 2)* 2;
	 }
	 break;
      case SFW_TMP_PLATTE:
      case SFW_PERM_PLATTE:
	 if(( fwrite( DW->RB, sizeof( RBalken), 1, SFW->file)== 1)&& ( fwrite( DW, sizeof( DATWINStruct), 1, SFW->file)== 1))
	 {
	    for( i= 0; i< DW->RB->max; i++)
	    {
	       if( fwrite( DW->dir_entrys[ i], ENTRY_LENGTH, 1, SFW->file)!= 1)
	       {
		  ret_val= -2;
		  break;
	       }
	    }
	    if(( ret_val== 0)&& ( SFW->mode== SFW_PERM_PLATTE))
	    {
	       for( i= 0; i< MAX_PATH_TAB_ENTRY; i++)
	       {
		  if( fwrite( path_tab_ptr[ i], MAXDIR+ DW_MAXFILTER, 1, SFW->file)!= 1)
		  {
		     ret_val= -2;
		     break;
		  }
	       }
	    }
	 }
	 else
	    ret_val= -2;
	 if( SFW->mode== SFW_PERM_PLATTE)
	    fclose( SFW->file);
	 break;
   }
   if( ret_val!= 0)
      SFW->mode= SFW_LEER;
   return( ret_val);
}

void ShowSortFrame( DATWINStruct *DW, MAUSStruct *MS, int B_Rev, int Stat, char an_aus)
{
   int array_index, ptr_index;

   if(( Stat- B_Rev)< ( ( DW->Win_Typ== LEFT) ? 5 : 3))
   {
      GetArrayIndexofElement( MS, Stat, &array_index, &ptr_index);
      ShowMouse( AUS);
      setcolor( ( an_aus== AN) ? EGA_LIGHTBLUE : EGA_LIGHTGRAY);
      rectangle( MS->mauspos[ array_index+ 1]+ *MS->x, MS->mauspos[ array_index+ 3]+ *MS->y, MS->mauspos[ array_index+ 2]+ *MS->x, MS->mauspos[ array_index+ 4]+ *MS->y);
      ShowMouse( AN);
   }
}

int SortFrame( DATWINStruct *DW, MAUSStruct *MS, int B_Rev, int Button)
{
   int l;

   if( DW->Sort_Typ!= ( Button- B_Rev))
   {
      for( l= 0; l< 2; l++)
	 ShowSortFrame( DW, MS, B_Rev, ( l== 0) ? ( B_Rev+ DW->Sort_Typ) : Button, l);
      veraendert= 1;
      DW->Sort_Typ= Button- B_Rev;
      Resort_DirEntrys( DW);
      MS->statsp= REINIT;
   }
   return( DW->Sort_Typ);
}

#define SORTTYP_KLICKAREA_LEFTBEGIN    52
#define SORTTYP_KLICKAREA_RIGHTBEGIN   57

int LoadFilewindow( SaveFWindow_struct *SFW, MAUSStruct *MS, DATWINStruct *DW, char *path_tab_ptr[], BYTE Mode)
{
   RBalken tmp_RB;
   DATWINStruct tmp_DW;
   int ret_val= 0, i;
   char Typ;
   unsigned long offset;

   Typ= DW->Sort_Typ;
   if( Mode== SFW_PERM_PLATTE)
      SFW->mode= Mode;
   switch( SFW->mode)
   {
      case SFW_XMS:
	 XMSCopy( SFW->XMS_handle, 0, 0, ( ptrdiff_t)&tmp_RB, sizeof( RBalken)/ 2);
	 offset= (( sizeof( RBalken)+ 1)/ 2)* 2;
	 XMSCopy( SFW->XMS_handle, offset, 0, ( ptrdiff_t)&tmp_DW, sizeof( DATWINStruct)/ 2);
	 offset+= (( sizeof( DATWINStruct)+ 1)/ 2)* 2;
	 FreeArray( DW);
	 for( i= 0; i< tmp_RB.max; i++)
	 {
	    if(( DW->dir_entrys[ i]= malloc((( ENTRY_LENGTH+ 1)/ 2)* 2))!= NULL)
	    {
	       XMSCopy( SFW->XMS_handle, offset, 0, ( ptrdiff_t)DW->dir_entrys[ i], ( ENTRY_LENGTH+ 1)/ 2);
	       offset+= (( ENTRY_LENGTH+ 1)/ 2)* 2;
	    }
	    else
	    {
	       ret_val= -3;
	       break;
	    }
	 }
	 break;
      case SFW_PERM_PLATTE:
	 strcpy( prgexe_ptr, ( DW->Win_Typ== LEFT) ? "~LDM##20.SAV" : "~RDM##20.SAV");
	 if(( SFW->file= fopen( prgexe_path, "rb"))== NULL)
	 {
	    ret_val= -1;
	    break;
	 }
      case SFW_TMP_PLATTE:
	 rewind( SFW->file);
	 if(( fread( &tmp_RB, sizeof( RBalken), 1, SFW->file)== 1)&& ( fread( &tmp_DW, sizeof( DATWINStruct), 1, SFW->file)== 1))
	 {
	    FreeArray( DW);
	    for( i= 0; i< tmp_RB.max; i++)
	    {
	       if(( DW->dir_entrys[ i]= malloc( ENTRY_LENGTH))!= NULL)
	       {
		  if( fread( DW->dir_entrys[ i], ENTRY_LENGTH, 1, SFW->file)!= 1)
		  {
		     ret_val= -2;
		     break;
		  }
	       }
	       else
	       {
		  ret_val= -3;
		  break;
	       }
	    }
	    if(( ret_val== 0)&& ( SFW->mode== SFW_PERM_PLATTE))
	    {
	       for( i= 0; i< MAX_PATH_TAB_ENTRY; i++)
	       {
		  if( fread( path_tab_ptr[ i], MAXDIR+ DW_MAXFILTER, 1, SFW->file)!= 1)
		  {
		     ret_val= -2;
		     break;
		  }
	       }
	    }
	 }
	 else
	    ret_val= -2;
	 if( SFW->mode== SFW_PERM_PLATTE)
	 {
	    fclose( SFW->file);
	    unlink( prgexe_path);
	 }
	 break;
      default:
	 ret_val= -4;
	 break;
   }
   if( ret_val!= -4)
   {
      if( ret_val== 0)
      {
	 DW->RB->max= tmp_RB.max;
	 DW->RB->proz= tmp_RB.proz;
	 DW->RB->Zeiger_pos= tmp_RB.Zeiger_pos;
	 memcpy( &DW->anz_mark, &tmp_DW.anz_mark, 10+ MAXDIR+ DW_MAXFILTER);
	 strcpy( DW->verzeichnis, DW->old_verzeichnis);
      }
      else
	 *DW->old_verzeichnis= '\0';
      LoescheVar( MS, DW, path_tab_ptr);
      i= ( ( DW->Win_Typ== LEFT) ? SORTTYP_KLICKAREA_LEFTBEGIN : SORTTYP_KLICKAREA_RIGHTBEGIN);
      ShowSortFrame( DW, MS, i, i+ Typ, AUS);
      ShowSortFrame( DW, MS, i, i+ DW->Sort_Typ, AN);
   }
   return( ret_val);
}

int Ptr_Table( void *ptr_array[], int anz_ptr, void *new_ptr)
{
   int i, l;

   for( i= --anz_ptr; ( i>= 0)&& ( ( ptrdiff_t)ptr_array[ i]!= ( ptrdiff_t)new_ptr); i--)
      ;
   if( i< 0)
      i= anz_ptr;
   for( l= i; l> 0; l--)
      ptr_array[ l]= ptr_array[ l- 1];
   ptr_array[ 0]= new_ptr;
   return( i>= 0);                      /* 1 -> Eintrag war schon vorhanden */
}

#define MAX_SFW   5

void pop_SFW( int X, int Y, int Laenge, char *SFW_dir[], SaveFWindow_struct *SFW[], MAUSStruct *MS, DATWINStruct *DW, char *path_tab_ptr[])
{
   int entry;

   if(( entry= PullDown( X, Y, Laenge, SFW_dir, MAX_SFW, VERZEICHNIS))>= 0)
   {
      if( LoadFilewindow( SFW[ entry], MS, DW, path_tab_ptr, SFW_TMP)== 0)
      {
	 _EntryInPullTable( SFW_dir, MAX_SFW, DW->verzeichnis, TRUE);
	 Ptr_Table( ( void **)SFW, MAX_SFW, ( void *)SFW[ entry]);
      }
   }
}

void push_SFW( SaveFWindow_struct *SFW[], DATWINStruct *DW, char *SFW_dir[])
{
   int entry;

   for( entry= 0; ( entry< MAX_SFW)&& ( SFW[ entry]->mode!= SFW_LEER); entry++)
   {
      if( stricmp( SFW_dir[ entry], DW->verzeichnis)== 0)
	 break;
   }
   if( entry>= MAX_SFW)         /* Verzeichnis wurde noch nicht gespeichert */
      entry= MAX_SFW- 1;
   if( SaveFilewindow( SFW[ entry], DW, NULL, SFW_TMP)== 0)
   {
      _EntryInPullTable( SFW_dir, MAX_SFW, DW->verzeichnis, TRUE);
      Ptr_Table( ( void **)SFW, MAX_SFW, ( void *)SFW[ entry]);
   }
}

#define MAXARGUMENTE 20
#define MAXARGLEN    124

void Anwender_Funktion( DATWINStruct *l_DW, DATWINStruct *r_DW, char *path_tab_ptr_l[], char *path_tab_ptr_r[], char Quelle)
{
   SaveFWindow_struct l_SFW= { SFW_LEER};
   SaveFWindow_struct r_SFW= { SFW_LEER};
   DATWINStruct *q_DW;
   char **q_tab;
   char dir[ MAXDIR], path[ MAXPATH], *argv[ 3+ MAXARGUMENTE];
   int l, i, arr_offset, arg_len;

   if( *anwender_prg!= '\0')
   {
      if( access( anwender_prg, 0)== 0)
      {
	 ( Quelle== LEFT) ? ( q_DW= l_DW) : ( q_DW= r_DW);
	 if( WriteStartBAT()== 0)
	 {
	    argv[ 0]= "WIN ";
	    argv[ 1]= anwender_prg;
	    ( Is_Window_EXE( anwender_prg)> 0) ? ( arr_offset= 0) : ( arr_offset= 1);
	    arg_len= strlen( anwender_prg);
	    if( arr_offset== 0)
	       arg_len+= 4;
	    Path_to_Dir( dir, q_DW->verzeichnis);
	    for( l= 0, i= 2; ( l< q_DW->RB->max)&& ( i< MAXARGUMENTE+ 2); l++)
	    {
	       if( *q_DW->dir_entrys[ l]== ANGEWAEHLT)
	       {
		  MakePfad( dir, path, q_DW->dir_entrys, l);
		  arg_len+= strlen( path)+ 1;
		  if(( arg_len> MAXARGLEN)|| (( argv[ i++]= strdup( path))== NULL))
		     break;
		  *q_DW->dir_entrys[ l]= ABGEWAEHLT;
	       }
	    }
	    argv[ i]= NULL;
	    SaveFilewindow( &l_SFW, l_DW, path_tab_ptr_l, SFW_PERM_PLATTE);
	    SaveFilewindow( &r_SFW, r_DW, path_tab_ptr_r, SFW_PERM_PLATTE);
	    saveSystem( "DB2_EINS.TMP");
	    Free_All_Resourcen();
	    if( execvp( argv[ arr_offset], &argv[ arr_offset])== -1)
	       exit( 0);
	 }
      }
      else
	 Hinweis( "The user program does not exist     ");
   }
   else
      Hinweis( "No user program specified (System setup->More...)        ");
}

void _View_Filter( DATWINStruct *l_DW, MAUSStruct *d_MS, char *l_path_tab_ptr[])
{
   view_filter_struct VF_sp;
   int ret= 0, ret_val= 0,
       nach_tag, nach_monat, nach_jahr, vor_tag, vor_monat, vor_jahr;
   void *arg_ptr[ 27];
   WORD mauspos[]= { BUTTON|      FRAME| KEY,              5,  27,   5,  21, ESC,
		     RADIOBUTTON| FRAME,                  41,  80, AT_GESETZT,
		     RADIOBUTTON| FRAME,                  41,  99, AT_EGAL,
		     RADIOBUTTON| FRAME,                  41, 118, AT_GELOESCHT,
		     RADIOBUTTON| FRAME,                 153,  80, AT_GESETZT,
		     RADIOBUTTON| FRAME,                 153,  99, AT_EGAL,
		     RADIOBUTTON| FRAME,                 153, 118, AT_GELOESCHT,
		     RADIOBUTTON| FRAME,                 265,  80, AT_GESETZT,
		     RADIOBUTTON| FRAME,                 265,  99, AT_EGAL,
		     RADIOBUTTON| FRAME,                 265, 118, AT_GELOESCHT,
		     RADIOBUTTON| FRAME,                 377,  80, AT_GESETZT,
		     RADIOBUTTON| FRAME,                 377,  99, AT_EGAL,
		     RADIOBUTTON| FRAME,                 377, 118, AT_GELOESCHT,
		     CHECKBOX|    FRAME| KEY,             33, 152, 'n',
		     LAUFLEISTE|  FRAME| KEY,             33, 169, 202,    1,   31,   1, CURSOR_LEFT, CURSOR_RIGHT,
		     LAUFLEISTE|  FRAME| KEY,             33, 193, 202,    1,   12,   1, 'q', 'w',
		     LAUFLEISTE|  FRAME| KEY,             33, 217, 202, 1980, 1999,   1, 'y', 'x',
		     CHECKBOX|    FRAME| KEY,            264, 152, 'v',
		     LAUFLEISTE|  FRAME| KEY,            264, 169, 202,    1,   31,   1, 'd', 'f',
		     LAUFLEISTE|  FRAME| KEY,            264, 193, 202,    1,   12,   1, 'u', 'i',
		     LAUFLEISTE|  FRAME| KEY,            264, 217, 202, 1980, 1999,   1, 'j', 'k',
		     CHECKBOX|    FRAME| KEY,             44, 270, 'z',
		     BUTTON|      FRAME| KEY| DEFBUTTON, 301, 375, 257, 299, RETURN,
		     BUTTON|      FRAME| KEY,            403, 477, 257, 299, 'a',
		     MOVEWINDOW };
   MAUSStruct MS= { DEFAULT, DEFAULT, 500, 314, 25, INIT, NULL, AUS};

   memcpy( &VF_sp, &l_DATWIN_VF, sizeof( view_filter_struct));
   nach_tag=     VF_sp.nach_ff_fdate& 0x001F;
   nach_monat= ( VF_sp.nach_ff_fdate& 0x01E0)>> 5;
   nach_jahr= (( VF_sp.nach_ff_fdate& 0xFE00)>> 9)+ 1980;
   vor_tag=     VF_sp.vor_ff_fdate& 0x001F;
   vor_monat= ( VF_sp.vor_ff_fdate& 0x01E0)>> 5;
   vor_jahr= (( VF_sp.vor_ff_fdate& 0xFE00)>> 9)+ 1980;
   arg_ptr[  0]= arg_ptr[  1]= arg_ptr[  2]= &VF_sp.Archiv;
   arg_ptr[  3]= arg_ptr[  4]= arg_ptr[  5]= &VF_sp.Hidden;
   arg_ptr[  6]= arg_ptr[  7]= arg_ptr[  8]= &VF_sp.RDonly;
   arg_ptr[  9]= arg_ptr[ 10]= arg_ptr[ 11]= &VF_sp.System;
   arg_ptr[ 12]= &VF_sp.nach_Datum;
   ( char *)arg_ptr[ 13]= "%d Days";
   arg_ptr[ 14]= &nach_tag;
   ( char *)arg_ptr[ 15]= "%d Months";
   arg_ptr[ 16]= &nach_monat;
   ( char *)arg_ptr[ 17]= "%d Years";
   arg_ptr[ 18]= &nach_jahr;
   arg_ptr[ 19]= &VF_sp.vor_Datum;
   ( char *)arg_ptr[ 20]= "%d Days";
   arg_ptr[ 21]= &vor_tag;
   ( char *)arg_ptr[ 22]= "%d Months";
   arg_ptr[ 23]= &vor_monat;
   ( char *)arg_ptr[ 24]= "%d Years";
   arg_ptr[ 25]= &vor_jahr;
   arg_ptr[ 26]= &VF_sp.aktiv;
   MS.x= &X_view_filter;
   MS.y= &Y_view_filter;
   MS.mauspos= mauspos;
   MS.arg_ptr= arg_ptr;
   PCX_Window( MS.x, MS.y, PCX_VIEWFILTER, &MS.sa, SHADOW);
   do
   {
      switch( __CheckMousepos( &MS))
      {
	 case 14:                                 /* LAUFLEISTE 'nach Datum' */
	 case 15:
	 case 16:
	    VF_sp.nach_Datum= AN;
	 case 1:                                               /* Attribute */
	 case 2:
	 case 3:
	 case 4:
	 case 5:
	 case 6:
	 case 7:
	 case 8:
	 case 9:
	 case 10:
	 case 11:
	 case 12:
	 case 13:                                     /* Datum-aktiv Button */
	 case 17:
	    VF_sp.aktiv= AN;
	    MS.statsp= REINIT;
	    break;
	 case 18:                                 /* LAUFLEISTE 'vor Datum' */
	 case 19:
	 case 20:
	    VF_sp.vor_Datum= AN;
	    VF_sp.aktiv= AN;
	    MS.statsp= REINIT;
	    break;
	 case 22:                                                     /* OK */
	    VF_sp.nach_ff_fdate= ( nach_tag& 0x1F)| (( nach_monat& 0x0F)<< 5)| ((( nach_jahr- 1980)& 0x7F)<< 9);
	    VF_sp.vor_ff_fdate= ( vor_tag& 0x1F)| (( vor_monat& 0x0F)<< 5)| ((( vor_jahr- 1980)& 0x7F)<< 9);
	    memcpy( &l_DATWIN_VF, &VF_sp, sizeof( view_filter_struct));
	    veraendert= AN;
	    ret_val= 1;
	 case 0:                                                     /* ESC */
	 case 23:                                                /* Abbruch */
	    ret= 1;
	    break;
      }
   }while( !ret);
   ShowMouse( AUS);
   BigScreenRestore( &MS.sa, *MS.x, *MS.y);
   ShowMouse( AN);
   if( ret_val== 1)
      LoescheVar( d_MS, l_DW, l_path_tab_ptr);
}

void EntrySearch( int *SearchPosIndex, int Taste, DATWINStruct *l_DW, DATWINStruct *r_DW, MAUSStruct *MS, char Quelle)
{
   DATWINStruct *q_DW;
   int i;
   long old_pos, old_zeiger;
   static char searchstr[ 9];

   q_DW= ( ( Quelle== LEFT) ? l_DW: r_DW);
   if((( q_DW->Sort_Typ== SORT_FILE)|| ( q_DW->Sort_Typ== SORT_EXT))&& ( *SearchPosIndex< ( ( q_DW->Sort_Typ== SORT_FILE) ? 8: 3)))
   {
      if( *SearchPosIndex== 0)
	 memset( searchstr, '\0', sizeof( searchstr));
      searchstr[ *SearchPosIndex]= Taste;
      for( i= 0; i< q_DW->RB->max; i++)
      {
	 if( !strnicmp( &q_DW->dir_entrys[ i][ ( q_DW->Sort_Typ== SORT_FILE) ? 1 : FILEEXT_POS], searchstr, *SearchPosIndex+ 1)&& ( Art_of_Entry( q_DW->dir_entrys[ i])!= DIR))
	 {
	    ( *SearchPosIndex)++;
	    old_pos= q_DW->RB->proz;
	    old_zeiger= q_DW->RB->Zeiger_pos;
	    if( q_DW->RB->max> q_DW->RB->maxstep)
	    {
	       if( i<= ( q_DW->RB->max- q_DW->RB->maxstep))
	       {
		  q_DW->RB->proz= i;
		  q_DW->RB->Zeiger_pos= 0;
	       }
	       else
		  q_DW->RB->Zeiger_pos= i- ( q_DW->RB->proz= q_DW->RB->max- q_DW->RB->maxstep);
	       q_DW->RB->proz_sp= q_DW->RB->proz;
	    }
	    else
	       q_DW->RB->Zeiger_pos= i;
	    if(( old_pos!= q_DW->RB->proz)|| ( old_zeiger!= q_DW->RB->Zeiger_pos))
	       DirEntry( q_DW);
	    MS->statsp= REINIT;
	    break;
	 }
      }
   }
   else
      Hinweis( "Only possible when sorted by name or extension      ");
}

void SaveKommando( void)
{
   FILE *save;
   BOOL Fehler= FALSE;

   if( _extDatManag!= NULL)
   {
      strcpy( prgexe_ptr, "~DKO##20.SAV");
      if(( save= fopen( prgexe_path, "wt"))== NULL)
	 ErrorMsg( CREAT_ERROR"~DKO##20.SAV");
      else
      {
	 if( fwrite( _extDatManag->Zeile, sizeof( _extDatManag->Zeile), 1, save)!= 1)
	 {
	    ErrorMsg( WRITE_ERROR"~DKO##20.SAV");
	    Fehler= TRUE;
	 }
	 fclose( save);
	 if( Fehler)
	    unlink( prgexe_path);
      }
   }
}

void ReShowKommando( MAUSStruct *MS)
{
   int X_Kommandozeile= 0, Y_Kommandozeile= Y_KOMMANDO;

   if( _extDatManag!= NULL)
   {
      _ShowStatus= FALSE;
      PCX_Window( &X_Kommandozeile, &Y_Kommandozeile, PCX_KOMMANDOZEILE, NULL, NO_SHADOW);
      *( BOOL *)MS->arg_ptr[  6]= TRUE;
      *( BOOL *)MS->arg_ptr[  7]= TRUE;
      MS->arg_ptr[  8]= _extDatManag->Zeile;
      *( BOOL *)MS->arg_ptr[  9]= TRUE;
      *( BOOL *)MS->arg_ptr[ 10]= TRUE;
   }
}

BOOL ShowKommando( MAUSStruct *MS)
{
   int X_Kommandozeile= 0, Y_Kommandozeile= Y_KOMMANDO;
   BOOL Fehler= TRUE;

   if( _extDatManag== NULL)
   {
      if(( _extDatManag= calloc( 1, sizeof( extended_DatManag_struct)))!= NULL)
      {
	 _ShowStatus= FALSE;
	 PCX_Window( &X_Kommandozeile, &Y_Kommandozeile, PCX_KOMMANDOZEILE, &_extDatManag->sa, NO_SHADOW);
	 *( BOOL *)MS->arg_ptr[  6]= TRUE;
	 *( BOOL *)MS->arg_ptr[  7]= TRUE;
	 MS->arg_ptr[  8]= _extDatManag->Zeile;
	 *( BOOL *)MS->arg_ptr[  9]= TRUE;
	 *( BOOL *)MS->arg_ptr[ 10]= TRUE;
	 if( MS->statsp!= INIT)
	    MS->statsp= REINIT;
	 Fehler= FALSE;
      }
      else
	 ErrorMsg( KEIN_SPEICHER);
   }
   return( !Fehler);
}

void RestoreKommando( MAUSStruct *MS)
{
   FILE *save;

   if(( _extDatManag== NULL)&& ExistDatei( "~DKO##20.SAV"))
   {
      if( ShowKommando( MS))
      {
	 if(( save= fopen( prgexe_path, "rt"))== NULL)
	    ErrorMsg( OPEN_ERROR"~DKO##20.SAV");
	 else
	 {
	    if( fread( _extDatManag->Zeile, sizeof( _extDatManag->Zeile), 1, save)!= 1)
	    {
	       ErrorMsg( READ_ERROR"~DKO##20.SAV");
	       *_extDatManag->Zeile= '\0';
	    }
	    fclose( save);
	    unlink( prgexe_path);
	 }
      }
   }
}

void FreeKommandoRes( BOOL fromDatManag)
{
   if( _extDatManag!= NULL)
   {
      ShowMouse( AUS);
      BigScreenRestore( &_extDatManag->sa, 0, Y_KOMMANDO);
      ShowMouse( AN);
      if( !fromDatManag)
	 SaveKommando();
      free( _extDatManag);
      _extDatManag= NULL;
      _ShowStatus= TRUE;
   }
}

void FreeKommando( MAUSStruct *MS)
{
   if( _extDatManag!= NULL)
   {
      *( BOOL *)MS->arg_ptr[  6]= FALSE;
      *( BOOL *)MS->arg_ptr[  7]= FALSE;
      MS->arg_ptr[  8]= NULL;
      *( BOOL *)MS->arg_ptr[  9]= FALSE;
      *( BOOL *)MS->arg_ptr[ 10]= FALSE;
      FreeKommandoRes( TRUE);
      MS->statsp= REINIT;
   }
}

void RUNKommando( DATWINStruct *l_DW, DATWINStruct *r_DW, char *path_tab_ptr_l[], char *path_tab_ptr_r[], char Quelle)
{
   SaveFWindow_struct l_SFW= { SFW_LEER};
   SaveFWindow_struct r_SFW= { SFW_LEER};
   DATWINStruct *q_DW;
   FILE *bat;
   char dir[ MAXDIR];

   q_DW= ( ( Quelle== LEFT) ? l_DW: r_DW);
   if(( _extDatManag!= NULL)&& ( *_extDatManag->Zeile!= '\0'))
   {
      strcpy( prgexe_ptr, "~DSK##20.BAT");
      if(( bat= fopen( prgexe_path, "wt"))== NULL)
	 ErrorMsg( CREAT_ERROR"~DSK##20.BAT");
      else
      {
	 strcpy( prgexe_ptr, "WAIT");
	 if( fprintf( bat, "%c:\nCD %s\nCOMMAND /C %s\n%s\n", *q_DW->verzeichnis, Path_to_Dir( dir, q_DW->verzeichnis), _extDatManag->Zeile, prgexe_path)== EOF)
	    ErrorMsg( WRITE_ERROR"~DSK##20.BAT");
	 else
	 {
	    getcwd( dir, sizeof( dir));
	    if( fprintf( bat, "%c:\nCD %s\n", *dir, dir)== EOF)
	       ErrorMsg( WRITE_ERROR"~DSK##20.BAT");
	    else
	    {
	       fclose( bat);
	       SaveFilewindow( &l_SFW, l_DW, path_tab_ptr_l, SFW_PERM_PLATTE);
	       SaveFilewindow( &r_SFW, r_DW, path_tab_ptr_r, SFW_PERM_PLATTE);
	       ExitMsg( 0);
	    }
	 }
	 fclose( bat);
      }
   }
}

void DateiManager( int Status_saved)
{
   SaveFWindow_struct l_SFW_array[ MAX_SFW]= { SFW_LEER}, *l_SFW[ MAX_SFW];
   SaveFWindow_struct r_SFW_array[ MAX_SFW]= { SFW_LEER}, *r_SFW[ MAX_SFW];
   RBalken l_RB= { 354, 86, 345, VERT_DIR, 1, 16, 0L};
   RBalken r_RB= { 611, 86, 345, VERT_DIR, 1, 16, 0L};
   DATWINStruct l_DW= { DEFAULT, DEFAULT, 0, 0L,  LEFT, SORT_FILE, -1, DW_FEST, ""};
   DATWINStruct r_DW= { DEFAULT, DEFAULT, 0, 0L, RIGHT, SORT_FILE, -1, DW_FEST, ""};
   void *akt_DW;
   not_use_key_struct NUK;
   int SearchPosIndex= 0;
   BOOL Kommandozeile_sichtbar= FALSE;
   int status,
       min_x_left_dir= MIN_X_LEFT_DIR- XREF_DATEIAUSWFENSTER,   min_y_left_dir= MIN_Y_LEFT_DIR- YREF_DATEIAUSWFENSTER,
       min_x_right_dir= MIN_X_RIGHT_DIR- XREF_DATEIAUSWFENSTER, min_y_right_dir= MIN_Y_RIGHT_DIR- YREF_DATEIAUSWFENSTER,
       Dummy= 0, ret= 0;
   char typ,
	l_SFW_tab[ MAX_SFW][ MAXDIR+ DW_MAXFILTER]= { "", "", "", "", ""},
	*l_SFW_tab_ptr[ MAX_SFW],
	r_SFW_tab[ MAX_SFW][ MAXDIR+ DW_MAXFILTER]= { "", "", "", "", ""},
	*r_SFW_tab_ptr[ MAX_SFW],
	pfad_tab_l[ MAX_PATH_TAB_ENTRY][ MAXDIR+ DW_MAXFILTER]= { "", "", "", "", ""},
	*path_tab_ptr_l[ MAX_PATH_TAB_ENTRY],
	pfad_tab_r[ MAX_PATH_TAB_ENTRY][ MAXDIR+ DW_MAXFILTER]= { "", "", "", "", ""},
	*path_tab_ptr_r[ MAX_PATH_TAB_ENTRY],
	filter_tab[ MAXFILTER_ENTRY][ MAXFILTER]= { "*.*", "", "", "", ""},
	*filter_tab_ptr[ MAXFILTER_ENTRY];
   void *arg_ptr[ 12];
   char *msg[]= { "Set clock and alarm(s)",
		  "Read in the path of the drive in the left file window again",
		  "Give the drive in the left file window a new name (label)         ",
		  "Show the contents of the left file window in the right",
		  "Read in the path of the drive in the right file window again  ",
		  "Give the drive in the right file window a new name (label)         ",
		  "Show the contents of the right file window in the left",
		  "Set the path for the left file window      ",
		  "Set the path for the right file window       ",
		  "Select a new drive file the left file window       ",
		  "Show the root directory of the drive                            ",
		  "Show the parent directory of the drive (DOS command CD..)",
		  "Show the directory tree of the drive and possibly select a directory",
		  "Set the sort criterion for the left file window    ",
		  "Select which files will be shown (by attributes, times)             ",
		  "Search for a file (filter) on the drive in the left file window",
		  "Show information on the source and target directories      ",
		  "Save the left file window into memory (for later recall)      ",
		  "Recall a saved file window into the left file window        ",
		  "Select a new drive for the right file window    ",
		  "Show the root directory of the drive                            ",
		  "Show the parent directory of the drive (DOS command CD..)",
		  "Show the directory tree of the drive and possibly select a directory",
		  "Set the sort criterion for the right file window      ",
		  "Save the right file window into memory (for later recall)      ",
		  "Recall a saved file window into the right file window        ",
		  "Select file, start program, display icon, view file ...             ",
		  "Select a visible extract of the left file window     ",
		  "Select file, start program, display icon, view file ...             ",
		  "Select a visible extract of the right file window      ",
		  "Make the left file window active (source)      ",
		  "Make the right file window active (source)       ",
		  "Select all files in the active file window     ",
		  "Select all directories in the active file window   ",
		  "Deselect all files and directories in the active file window     ",
		  "Copy selected files in the source window onto the target drive ",
		  "Move selected files in the source window onto the target drive     ",
		  "Change attributes/creation time of selected files  ",
		  "Create new (sub)directory         ",
		  "Copy icons from a MS Windows Program file (*.EXE)              ",
		  "Call up submenu for the selection of further file manager functions",
		  "Go to Program Manager      ",
		  "End the program and change to the current file window directory  ",
		  "(De)select files in the file window with the help of wildcards (*,?)",
		  "Erase selected files in the current file window       ",
		  "Rename selected files in the current file window         ",
		  "Edit selected file(s) in the current file window     ",
		  "View selected file(s) in the current file window        ",
		  "Call up user specified function with the selected files       ",
		  "Call up quick reference guide (key combinations) for the program",
		  "Call up a DOS shell (return by typing EXIT)",
		  "Quit program    ",
		  "Call up DOS command line  "};
   WORD mauspos[]= { DOUBLE_KLICKAREA|        KEY|            MSG, 580, 632,   4,  20, SHIFT_F10,  /* Uhr, ... */
		     BUTTON2|          FRAME| KEY|            MSG,  69,  89,  16,  27, SHIFT_F1,   /* links erneut lesen */
		     DOUBLE_KLICKAREA|        KEY|            MSG,  95, 193,  23,  36, SHIFT_F2,   /* links Label */
		     BUTTON2|          FRAME| KEY|            MSG, 345, 375,  25,  37, SHIFT_F3,   /* nach rechts bernehmen */
		     BUTTON2|          FRAME| KEY|            MSG, 449, 469,  16,  27, SHIFT_F5,   /* rechts erneut lesen */
		     DOUBLE_KLICKAREA|        KEY|            MSG, 475, 573,  23,  36, SHIFT_F6,   /* rechts Label */
		     BUTTON2|          FRAME| KEY|            MSG, 602, 632,  25,  37, SHIFT_F7,   /* nach links bernehmen */
		     FILE_INPUT_TABLE| IGN_CASE| FRAME| KEY|            MSG,   7,  40, 368, MAXDIR+ DW_MAXFILTER- 2, MAX_PATH_TAB_ENTRY, SHIFT_F4,
		     FILE_INPUT_TABLE| IGN_CASE| FRAME| KEY|            MSG, 381,  40, 251, MAXDIR+ DW_MAXFILTER- 2, MAX_PATH_TAB_ENTRY, SHIFT_F8,
		     BUTTON3|          FRAME| KEY|            MSG,   7,  48,  60,  82, F1,         /* links LW-Auswahl */
		     BUTTON3|          FRAME| KEY|            MSG,  49,  90,  60,  82, F2,         /* links Root */
		     BUTTON3|          FRAME| KEY|            MSG,  91, 132,  60,  82, F3,         /* links CD.. */
		     BUTTON3|          FRAME| KEY|            MSG, 133, 174,  60,  82, F4,         /* links Baum */
		     BUTTON3|          FRAME| KEY|            MSG, 175, 216,  60,  82, F5,         /* links Sortierung */
		     BUTTON3|          FRAME| KEY|            MSG, 217, 258,  60,  82, SHIFT_F9,   /* Anzeigefilter */
		     BUTTON3|          FRAME| KEY|            MSG, 259, 300,  60,  82, F6,         /* Datei suchen */
		     BUTTON3|          FRAME| KEY|            MSG, 301, 333,  60,  82, F12,        /* Q-Z Info */
		     BUTTON3|          FRAME| KEY|            MSG, 334, 354,  60,  82, STRG_F1,    /* links -> push */
		     BUTTON3|          FRAME| KEY|            MSG, 355, 375,  60,  82, STRG_F2,    /* links <- pop */
		     BUTTON3|          FRAME| KEY|            MSG, 381, 422,  60,  82, F7,         /* rechts LW-Auswahl */
		     BUTTON3|          FRAME| KEY|            MSG, 423, 464,  60,  82, F8,         /* rechts Root */
		     BUTTON3|          FRAME| KEY|            MSG, 465, 506,  60,  82, F9,         /* rechts CD.. */
		     BUTTON3|          FRAME| KEY|            MSG, 507, 548,  60,  82, F10,        /* rechts Baum */
		     BUTTON3|          FRAME| KEY|            MSG, 549, 590,  60,  82, F11,        /* rechts Sortierung */
		     BUTTON3|          FRAME| KEY|            MSG, 591, 611,  60,  82, STRG_F7,    /* rechts -> push */
		     BUTTON3|          FRAME| KEY|            MSG, 612, 632,  60,  82, STRG_F8,    /* rechts <- pop */
		     PUSHAREA|                                MSG,  12, 349,  99, 322,
		     ROLLBALKEN|              KEY|            MSG, CURSOR_UP, CURSOR_DOWN, PAGE_UP, PAGE_DOWN, HOME, END, RETURN,
		     PUSHAREA|                                MSG, 386, 606,  99, 322,
		     ROLLBALKEN|              KEY|            MSG, CURSOR_UP, CURSOR_DOWN, PAGE_UP, PAGE_DOWN, HOME, END, RETURN,
		     KLICKAREA|               KEY|            MSG,  12, 349, 324, 343, CURSOR_LEFT,
		     KLICKAREA|               KEY|            MSG, 386, 606, 324, 343, CURSOR_RIGHT,
		     BUTTON2|          FRAME| KEY|            MSG,  10,  43, 353, 377, '+',        /* alle Dateien anwhlen */
		     BUTTON2|          FRAME| KEY|            MSG,  45,  77, 353, 377, '*',        /* alle Unterverzeichnisse anwhlen */
		     BUTTON2|          FRAME| KEY|            MSG,  10,  77, 379, 403, '-',        /* alle Eintrge abwhlen */
		     BUTTON2|          FRAME| KEY|            MSG,  79, 146, 353, 403, ALT_C,      /* Kopieren */
		     BUTTON2|          FRAME| KEY|            MSG, 148, 215, 353, 403, ALT_M,      /* Verschieben */
		     BUTTON2|          FRAME| KEY|            MSG, 217, 284, 353, 403, ALT_A,      /* Attribute */
		     BUTTON2|          FRAME| KEY|            MSG, 286, 353, 353, 403, ALT_T,      /* Verzeichnis */
		     BUTTON2|          FRAME| KEY|            MSG, 355, 422, 353, 403, ALT_I,      /* Icon lsen */
		     BUTTON2|          FRAME| KEY|            MSG, 424, 491, 353, 403, ALT_O,      /* mehr... */
		     BUTTON2|          FRAME| KEY| DEFBUTTON| MSG, 493, 560, 353, 403, ALT_M,      /* Programmanager */
		     BUTTON2|          FRAME| KEY|            MSG, 562, 629, 353, 403, ALT_N,      /* CD-Ende */
		     BUTTON2|          FRAME| KEY|            MSG,  10,  77, 405, 455, ALT_F,      /* Filterwahl */
		     BUTTON2|          FRAME| KEY|            MSG,  79, 146, 405, 455, ALT_D,      /* Lschen */
		     BUTTON2|          FRAME| KEY|            MSG, 148, 215, 405, 455, ALT_R,      /* Umnennen */
		     BUTTON2|          FRAME| KEY|            MSG, 217, 284, 405, 455, ALT_E,      /* Editieren */
		     BUTTON2|          FRAME| KEY|            MSG, 286, 353, 405, 455, ALT_V,      /* Anzeigen */
		     BUTTON2|          FRAME| KEY|            MSG, 355, 422, 405, 455, ALT_Q,      /* Anwenderfunktion */
		     BUTTON2|          FRAME| KEY|            MSG, 424, 491, 405, 455, ALT_H,      /* Hilfe */
		     BUTTON2|          FRAME| KEY|            MSG, 493, 560, 405, 455, ALT_P,      /* Prompt */
		     BUTTON2|          FRAME| KEY|            MSG, 562, 629, 405, 455, ALT_X,      /* Beenden */
		     KLICKAREA,                                     37,  73,  84,  96,
		     KLICKAREA,                                     97, 122,  84,  96,
		     KLICKAREA,                                    139, 167,  84,  96,
		     KLICKAREA,                                    248, 280,  84,  96,
		     KLICKAREA,                                    308, 339,  84,  96,
		     KLICKAREA,                                    411, 447,  84,  96,
		     KLICKAREA,                                    471, 496,  84,  96,
		     KLICKAREA,                                    513, 541,  84,  96,
		     TASTE,                                        INSERT,
		     TASTE,                                        DELETE,
		     TASTE,                                        ESC,
		     BUTTON2|        _IF|   FRAME| KEY,             10,  31, 459, 475, STRG_ESC,
		     FILEINPUTNOBOX| _IF| RETURN_INPUT| FRAME| KEY, 33, 459, 509, 127, STRG_K,
		     BUTTON2|        _IF|   FRAME,                 544, 569, 459, 475,
		     BUTTON2|        _IF|   FRAME| KEY,            571, 606, 459, 475, STRG_D,
		     KLICKAREA|               KEY|            MSG,  10, 605, 460, 474, SPACE,
		     NOT_USE_KEY,

		     /* gehren nicht unmittelbar zum -mauspos-, werden fr den Dateibalken bentigt */

		     HOTAREA,                                       12, 349,  99, 322,
		     HOTAREA,                                      386, 606,  99, 322
		     };
   MAUSStruct MS= { DEFAULT, DEFAULT, 640, 480, 69, INIT, NULL, AN};

   l_DW.RB= &l_RB;
   r_DW.RB= &r_RB;
   l_DW.verzeichnis= dmanager_path1;
   r_DW.verzeichnis= dmanager_path2;
   l_DW.Sort_Typ= sortfilterauswahllinks;
   r_DW.Sort_Typ= sortfilterauswahlrechts;
   if( DriveOK( l_DW.verzeichnis[ 0]- 'A'))
      Paste_Filter_to_Dir( getcwd( l_DW.verzeichnis, MAXPATH), "*.*");
   if( DriveOK( r_DW.verzeichnis[ 0]- 'A'))
      sprintf( r_DW.verzeichnis, "%c:\\*.*", 'A'+ getdisk());
   strcpy( pfad_tab_l[ 0], l_DW.verzeichnis);
   strcpy( pfad_tab_r[ 0], r_DW.verzeichnis);
   for( status= 0; status< MAX_PATH_TAB_ENTRY; status++)
   {
      path_tab_ptr_l[ status]= pfad_tab_l[ status];
      path_tab_ptr_r[ status]= pfad_tab_r[ status];
   }
   for( status= 0; status< MAX_SFW; status++)
   {
      l_SFW_tab_ptr[ status]= l_SFW_tab[ status];
      r_SFW_tab_ptr[ status]= r_SFW_tab[ status];
      l_SFW[ status]= &l_SFW_array[ status];
      r_SFW[ status]= &r_SFW_array[ status];
   }
   for( status= 0; status< MAXFILTER_ENTRY; status++)
      filter_tab_ptr[ status]= filter_tab[ status];
   arg_ptr[ 0]= path_tab_ptr_l;   /* arg_ptr[ 2], [ 3], [ 4] u. [ 5] siehe ShowAktivWindow() */
   arg_ptr[ 1]= path_tab_ptr_r;
   arg_ptr[  6]= &Kommandozeile_sichtbar;
   arg_ptr[  7]= &Kommandozeile_sichtbar;
   arg_ptr[  8]= NULL;
   arg_ptr[  9]= &Kommandozeile_sichtbar;
   arg_ptr[ 10]= &Kommandozeile_sichtbar;
   arg_ptr[ 11]= &NUK;
   MS.x= MS.y= &Dummy;
   l_DW.X= &min_x_left_dir;
   l_DW.Y= &min_y_left_dir;
   r_DW.X= &min_x_right_dir;
   r_DW.Y= &min_y_right_dir;
   MS.msg= msg;
   MS.mauspos= mauspos;
   MS.arg_ptr= arg_ptr;
   for( status= 0; status< 26; status++)
      newbaum[ status]= 0;
   PCX_Window( &Dummy, &Dummy, PCX_DATEIMANAGER, NULL, NO_SHADOW);
   uhrsp= -1;
   Clock();
   ShowMouse( AUS);
   DrawIcon( 384, 408, OwnerButtonICO_ptr);
   ShowMouse( AN);
   akt_DW= ShowAktivWindow( &l_DW, &r_DW, arg_ptr);
   if( Status_saved)
   {
      __CheckMousepos( &MS);                              /* Initialisieren */
      LoadFilewindow( l_SFW[ 0], &MS, &l_DW, path_tab_ptr_l, SFW_PERM_PLATTE);
      LoadFilewindow( r_SFW[ 0], &MS, &r_DW, path_tab_ptr_r, SFW_PERM_PLATTE);
   }
   else
   {
      ShowDInfo( &l_DW);
      ShowDInfo( &r_DW);
      if(( Read_DirEntrys( &l_DW)== FATAL_MEMORY)|| ( Read_DirEntrys( &r_DW)== FATAL_MEMORY))
	 ExitMsg( MEMORY_EXIT);
      DirEntry( &l_DW);
      DirEntry( &r_DW);
   }
   ShowSortFrame( &l_DW, &MS,  SORTTYP_KLICKAREA_LEFTBEGIN,  SORTTYP_KLICKAREA_LEFTBEGIN+ l_DW.Sort_Typ, AN);
   ShowSortFrame( &r_DW, &MS, SORTTYP_KLICKAREA_RIGHTBEGIN, SORTTYP_KLICKAREA_RIGHTBEGIN+ r_DW.Sort_Typ, AN);
   if( _extDatManag== NULL)
      RestoreKommando( &MS);
   else
      ReShowKommando( &MS);
   #ifdef COPYRIGHT
      if( !install)
	 FR_Adresse();
   #endif
   install= AN;
   do
   {
      if((( status= __CheckMousepos( &MS))!= 68)&& ( status!= -1))
	 SearchPosIndex= 0;
      AUSWERTEN:
      ;
      switch( status)
      {
	 case 0:                                             /* Uhr stellen */
	    SetClock();
	    break;
	 case 1:                                      /* links erneut lesen */
	    Reload_Path( &l_DW, &MS, path_tab_ptr_l);
	    break;
	 case 2:                                   /* linkes Laufwerk LABEL */
	    DiskLabel( *l_DW.verzeichnis);
	    break;
	 case 3:                                        /* links --> rechts */
	    if( DATWIN_Uebernehmen( &r_DW, path_tab_ptr_r, &l_DW, &MS)== FATAL_MEMORY)
	       ExitMsg( MEMORY_EXIT);
	    break;
	 case 4:                                     /* rechts erneut lesen */
	    Reload_Path( &r_DW, &MS, path_tab_ptr_r);
	    break;
	 case 5:                                  /* rechtes Laufwerk LABEL */
	    DiskLabel( *r_DW.verzeichnis);
	    break;
	 case 6:                                        /* rechts --> links */
	    if( DATWIN_Uebernehmen( &l_DW, path_tab_ptr_l, &r_DW, &MS)== FATAL_MEMORY)
	       ExitMsg( MEMORY_EXIT);
	    break;
	 case 7:                                 /* linker Suchweg gendert */
	    newPath_Enter( &l_DW, &MS, path_tab_ptr_l);
	    break;
	 case 8:                                /* rechter Suchweg gendert */
	    newPath_Enter( &r_DW, &MS, path_tab_ptr_r);
	    break;
	 case 9:                          /* links neues Laufwerk auswhlen */
	    newLW( &datlaufwlinksx, &datlaufwlinksy, &l_DW, &MS, path_tab_ptr_l);
	    break;
	 case 10:                                              /* links CD\ */
	    Root( &l_DW, &MS, path_tab_ptr_l);
	    break;
	 case 11:                                             /* links CD.. */
	    VaterVerzeichnis( &l_DW, &MS, path_tab_ptr_l);
	    break;
	 case 12:                                 /* linker Verzeichnisbaum */
	    Tree( &DAT_l_x_baum, &l_DW, &MS, path_tab_ptr_l);
	    break;
	 case 13:                                 /* links Sortierkriterium */
	    if( Sort_Krit( &X_sortkrit_l, &Y_sortkrit_l, &l_DW, &typ))
	       sortfilterauswahllinks= SortFrame( &l_DW, &MS, SORTTYP_KLICKAREA_LEFTBEGIN, SORTTYP_KLICKAREA_LEFTBEGIN+ typ);
	    break;
	 case 14:                                          /* Anzeigefilter */
	    _View_Filter( &l_DW, &MS, path_tab_ptr_l);
	    break;
	 case 15:                       /* Datei auf linkem Laufwerk suchen */
	    _FindFile( &l_DW, &MS, path_tab_ptr_l);
	    break;
	 case 16:                                               /* Q-Z Info */
	    Q_Z_Info( &l_DW, &r_DW, aktivwindow);
	    break;
	 case 17:                         /* linkes Fenster in den Speicher */
	    push_SFW( l_SFW, &l_DW, l_SFW_tab_ptr);
	    break;
	 case 18:                   /* gespeichertes Fenster links anzeigen */
	    pop_SFW( 7, 83, 368, l_SFW_tab_ptr, l_SFW, &MS, &l_DW, path_tab_ptr_l);
	    break;
	 case 19:                        /* rechts neues Laufwerk auswhlen */
	    newLW( &datlaufwrechtsx, &datlaufwrechtsy, &r_DW, &MS, path_tab_ptr_r);
	    break;
	 case 20:                                             /* rechts CD\ */
	    Root( &r_DW, &MS, path_tab_ptr_r);
	    break;
	 case 21:                                            /* rechts CD.. */
	    VaterVerzeichnis( &r_DW, &MS, path_tab_ptr_r);
	    break;
	 case 22:                                /* rechter Verzeichnisbaum */
	    Tree( &DAT_r_x_baum, &r_DW, &MS, path_tab_ptr_r);
	    break;
	 case 23:                                /* rechts Sortierkriterium */
	    if( Sort_Krit( &X_sortkrit_r, &Y_sortkrit_r, &r_DW, &typ))
	       sortfilterauswahlrechts= SortFrame( &r_DW, &MS, SORTTYP_KLICKAREA_RIGHTBEGIN, SORTTYP_KLICKAREA_RIGHTBEGIN+ typ);
	    break;
	 case 24:                        /* rechtes Fenster in den Speicher */
	    push_SFW( r_SFW, &r_DW, r_SFW_tab_ptr);
	    break;
	 case 25:                  /* gespeichertes Fenster rechts anzeigen */
	    pop_SFW( 381, 83, 251, r_SFW_tab_ptr, r_SFW, &MS, &r_DW, path_tab_ptr_r);
	    break;
	 case 26:                             /* linke Dateifenstereintrge */
	    if( aktivwindow== RIGHT)
	    {
	       aktivwindow= LEFT;
	       akt_DW= ShowAktivWindow( &l_DW, &r_DW, arg_ptr);
	    }
	    if(( status= Anwahl( &l_DW, &r_DW, &MS, path_tab_ptr_l, path_tab_ptr_r, filter_tab_ptr))!= -1)
	       goto AUSWERTEN;
	    break;
	 case 27:                                      /* linker Rollbalken */
	    if( aktivwindow== RIGHT)
	       goto R_ROLLBALKEN;
	    L_ROLLBALKEN:
	    ;
	    switch( l_RB.ret_val)
	    {
	       case ONE_ELEMENT_UP:
		  Dir_Up_Down( &l_DW, DOWN, !NOREVERSE);
		  break;
	       case ONE_ELEMENT_DOWN:
		  Dir_Up_Down( &l_DW, UP, !NOREVERSE);
		  break;
	       case ELEMENT_RANDOM:
		  DirEntry( &l_DW);
		  break;
	       case POINTER_RETURN:
		  _Exec( &MS, l_DW.RB->Zeiger_pos, &l_DW, &r_DW, path_tab_ptr_l, path_tab_ptr_r, LEFT, NULL);
		  break;
	    }
	    break;
	 case 28:
	    if( aktivwindow== LEFT)          /* rechte Dateifenstereintrge */
	    {
	       aktivwindow= RIGHT;
	       akt_DW= ShowAktivWindow( &l_DW, &r_DW, arg_ptr);
	    }
	    if(( status= Anwahl( &l_DW, &r_DW, &MS, path_tab_ptr_l, path_tab_ptr_r, filter_tab_ptr))!= -1)
	       goto AUSWERTEN;
	    break;
	 case 29:                                     /* rechter Rollbalken */
	    if( aktivwindow== RIGHT)
	       goto L_ROLLBALKEN;
	    R_ROLLBALKEN:
	    ;
	    switch( r_RB.ret_val)
	    {
	       case ONE_ELEMENT_UP:
		  Dir_Up_Down( &r_DW, DOWN, !NOREVERSE);
		  break;
	       case ONE_ELEMENT_DOWN:
		  Dir_Up_Down( &r_DW, UP, !NOREVERSE);
		  break;
	       case ELEMENT_RANDOM:
		  DirEntry( &r_DW);
		  break;
	       case POINTER_RETURN:
		  _Exec( &MS, r_DW.RB->Zeiger_pos, &l_DW, &r_DW, path_tab_ptr_l, path_tab_ptr_r, RIGHT, NULL);
		  break;
	    }
	    break;
	 case 30:                          /* <--  aktives Fenster wechseln */
	    if( aktivwindow== RIGHT)
	    {
	       aktivwindow= LEFT;
	       akt_DW= ShowAktivWindow( &l_DW, &r_DW, arg_ptr);
	    }
	    break;
	 case 31:                          /* -->  aktives Fenster wechseln */
	    if( aktivwindow== LEFT)
	    {
	       aktivwindow= RIGHT;
	       akt_DW= ShowAktivWindow( &l_DW, &r_DW, arg_ptr);
	    }
	    break;
	 case 32:                                  /* alle Dateien anwhlen */
	    All_Auswahl( akt_DW, DATEIEN_ANWAEHLEN);
	    break;
	 case 33:                            /* alle Verzeichnisse anwhlen */
	    All_Auswahl( akt_DW, VERZEICHNISSE_ANWAEHLEN);
	    break;
	 case 34:                                 /* alle Eintrge abwhlen */
	    All_Auswahl( akt_DW, ALLES_ABWAEHLEN);
	    break;
	 case 35:                                               /* Kopieren */
	 case 36:                                            /* Verschieben */
	    _Kop_Vers( &MS, &l_DW, &r_DW, path_tab_ptr_l, path_tab_ptr_r, aktivwindow, NULL, status- 35);
	    break;
	 case 37:                                              /* Attribute */
	    _Attribute( &MS, &l_DW, &r_DW, path_tab_ptr_l, path_tab_ptr_r, aktivwindow);
	    break;
	 case 38:                                            /* Verzeichnis */
	    _MakeDir( &MS, &l_DW, &r_DW, path_tab_ptr_l, path_tab_ptr_r, aktivwindow);
	    break;
	 case 39:                                      /* Icons extrahieren */
	    Icon_extrahieren( &MS, &l_DW, &r_DW, path_tab_ptr_l, path_tab_ptr_r, aktivwindow);
	    break;
	 case 40:                                                /* mehr... */
	    More_Datmanager( &MS, &l_DW, &r_DW, path_tab_ptr_l, path_tab_ptr_r, aktivwindow);
	    break;
	 case 41:                                         /* Programmanager */
	    ret= 1;
	    break;
	 case 42:                                         /* EXIT mit CHDIR */
	    if( aktivwindow== LEFT)
	    {
	       setdisk( *l_DW.verzeichnis- 'A');
	       chdir( Path_to_Dir( l_DW.verzeichnis, l_DW.verzeichnis));
	    }
	    else
	    {
	       setdisk( *r_DW.verzeichnis- 'A');
	       chdir( Path_to_Dir( r_DW.verzeichnis, r_DW.verzeichnis));
	    }
	    ExitMsg( 255);
	    break;
	 case 43:                                             /* Filterwahl */
	    Auswahl( ( aktivwindow== LEFT) ? &l_DW : &r_DW, filter_tab_ptr, ZUTREFFENDES_ANWAEHLEN);
	    break;
	 case 44:                                                /* Lschen */
	    _Loeschen( &MS, &l_DW, &r_DW, path_tab_ptr_l, path_tab_ptr_r, aktivwindow);
	    break;
	 case 45:                                             /* Umbenennen */
	    _Rename( &MS, &l_DW, &r_DW, path_tab_ptr_l, path_tab_ptr_r, aktivwindow);
	    break;
	 case 46:                                                 /* Editor */
	    Editieren( &MS, &l_DW, &r_DW, path_tab_ptr_l, path_tab_ptr_r, aktivwindow);
	    break;
	 case 47:                                               /* Anzeigen */
	    Viewen( &MS, &l_DW, &r_DW, path_tab_ptr_l, path_tab_ptr_r, aktivwindow);
	    break;
	 case 48:                                      /* anwenderdefiniert */
	    Anwender_Funktion( &l_DW, &r_DW, path_tab_ptr_l, path_tab_ptr_r, aktivwindow);
	    break;
	 case 49:                                                  /* Hilfe */
	    strcpy( prgexe_ptr, "DESKTOP2.DOC");
	    _Editor_Viewer( prgexe_path, VIEW_ASCII, NULL);
	    break;
	 case 50:                                                 /* Prompt */
	    Prompt( &l_DW, &r_DW, path_tab_ptr_l, path_tab_ptr_r);
	    break;
	 case 51:                                                   /* EXIT */
	    ExitMsg( 255);
	    break;
	 case SORTTYP_KLICKAREA_LEFTBEGIN:   /* bei nderungen auch bei manueller Einstellung ndern */
	 case SORTTYP_KLICKAREA_LEFTBEGIN+ 1:
	 case SORTTYP_KLICKAREA_LEFTBEGIN+ 2:
	 case SORTTYP_KLICKAREA_LEFTBEGIN+ 3:
	 case SORTTYP_KLICKAREA_LEFTBEGIN+ 4:
	    sortfilterauswahllinks= SortFrame( &l_DW, &MS, SORTTYP_KLICKAREA_LEFTBEGIN, status);
	    break;
	 case SORTTYP_KLICKAREA_RIGHTBEGIN:   /* bei nderungen auch bei manueller Einstellung ndern */
	 case SORTTYP_KLICKAREA_RIGHTBEGIN+ 1:
	 case SORTTYP_KLICKAREA_RIGHTBEGIN+ 2:
	    sortfilterauswahlrechts= SortFrame( &r_DW, &MS, SORTTYP_KLICKAREA_RIGHTBEGIN, status);
	    break;
	 case 60:                                                   /* Einf */
	 case 61:                                                   /* Entf */
	    DirBalken( status- 60, ( aktivwindow== LEFT) ? &l_DW : &r_DW);
	    break;
	 case 62:                                                    /* ESC */
	    SearchPosIndex= 0;
	    break;
	 case 63:                               /* Kommandozeile ausblenden */
	    FreeKommando( &MS);
	    break;
	 case 64:                                /* Kommandozeile verlassen */
	 case 65:
	    RUNKommando( &l_DW, &r_DW, path_tab_ptr_l, path_tab_ptr_r, aktivwindow);
	    break;
	 case 66:                                         /* DOS betrachten */
	    DOS_Schirm();
	    break;
	 case 67:
	    ShowKommando( &MS);                 /* Kommandozeile einblenden */
	    break;
	 case 68:
	    EntrySearch( &SearchPosIndex, NUK.Taste, &l_DW, &r_DW, &MS, aktivwindow);
	    break;
      }
      for( status= sizeof( mauspos)/ 2- 10; status<= sizeof( mauspos)/ 2- 5; status+= 5)
      {
	 if( Is_Mouse_at_Element( &MS, status, DEFAULT))
	 {
	    switch( status)
	    {
	       case sizeof( mauspos)/ 2- 10: /* Cursor auf linkem Dateifenster */
		  if( ShowDatMark( &l_DW)== -2)
		     ClearDatMark( &l_DW);
		  break;
	       case sizeof( mauspos)/ 2- 5: /* Cursor auf rechtem Dateifenster */
		  if( ShowDatMark( &r_DW)== -2)
		     ClearDatMark( &r_DW);
		  break;
	    }
	    break;
	 }
      }
      if( status> sizeof( mauspos)/ 2- 5)
      {
	 ClearDatMark( &l_DW);
	 ClearDatMark( &r_DW);
      }
   }while( !ret);
   _ShowStatus= TRUE;
   FreeArray( &l_DW);
   FreeArray( &r_DW);
   for( status= 0; status< MAX_SFW; status++);
   {
      FreeSFW( l_SFW[ status]);
      FreeSFW( r_SFW[ status]);
   }
}
