Program MakeKeyb;

{
        MAKEKEYB, keyboard driver file editor for FreeDOS XKEYB

                Copyright (C) 2006 by Francesco Zamblera
                  under the GNU General Public License

                           vilnergoy@yahoo.it


    This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

    This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
}

USES    crt,dos;

CONST   maxcombi = 100;

var     KeyMap : Array [32..255] of char;
        Mappings: Array [128..255] of string[2];
        TOP : byte;
        KeybFile, KeybTemplate: text;
        combinations: array [1..maxcombi] of string;
        Maps, FontFile, OutputFile, dr: String;
        r: char;

Procedure LoadFont (FontName: String);

{         This is a modified version of Kurt Zammit's Pascal program GNUCHCP
          Seek the original version at www.freepascal.org
}

Var
  Buffer: array[0..2047] of byte;
  F: file;
  Regs: Registers;

begin
  if FontName = '' then
  begin
    with Regs do
    begin
      AH:=$11;
      AL:=$04;
      BH:=0;
      BL:=0;
      Intr($10, Regs);
    end
  end
  else begin
        Assign(F, FontName + '.dat');
        Reset(F,1);
        BlockRead(F, Buffer, 2048);
        Close(F);
        with Regs do
             begin
                  AH:=$11;
                  AL:=$10;
                  BH:=16;
                  BL:=0;
                  CX:=128;
                  DX:=128;
                  BP:=Ofs(Buffer);
                  ES:=Seg(Buffer);
                  Intr($10, Regs)
             end
       end;
end;

Procedure WriteCombi;
var i: byte; c,k: string;
begin
 if top > 1 then writeln (KeybFile,'[COMBI]');
 for i := 1 to TOP-1 do
     begin
      c := combinations[i];
      write(KeybFile,keymap[ord(c[1])] + '    ');
      delete(c,1,1);
      while c <> ''
            do begin
                write (KeybFile,keymap[ord(c[1])] +
                      c[2]);
                delete(c,1,2);
                if c <> '' then write(KeybFile,' ');
               end;
      writeln(KeybFile)
     end
end;

Procedure AddToCombi (c: char; comb: string);
var i: byte; found: boolean;
begin
 i := 0;
 repeat
     inc(i);
     found := combinations[i][1] = comb[1]
 until found or (i = top);
 if found then combinations[i] := combinations[i] + comb[2] + c
          else begin
                combinations[Top] := comb[1] + comb[2] + c;
                inc(TOP)
               end
end;

Procedure BindKeys;
var i: byte; c: string; OK: boolean;
begin
 writeln; writeln;
 for i := 128 to 255 do
     repeat
       write ('Bind "', chr(i), '" to: '); readln(c);
       OK := length(c) in [0..2];
       case length(c) of
               0:  ;
               1:  keymap[ord(c[1])] := chr(i);
               2:  AddToCombi(chr(i),c);
               else writeln ('Please enter one or two characters')
              end;
       if OK then Mappings[i] := c
     until OK
end;

Procedure SkipWhite(s: string; var i: byte);
begin
 while s[i] in [#10, #13, ' ', #8] do inc(i)
end;

Procedure SkipItem(s:string; var i: byte);
begin
  while not (s[i] in [#10, #13, ' ', #8]) do inc(i)
end;

Procedure WriteKeys;
var line: String; i: byte; scan: boolean;
begin
 reset(KeybTemplate);
 rewrite(KeybFile);
 scan := true;
 while not eof(KeybTemplate)
       do begin
           readln(KeybTemplate, line);
           if line = '[SHIFT]' then scan := false;
           if scan then begin
                         i := 1;
                         SkipWhite(line,i);
                         SkipItem(line,i); SkipWhite(line,i);
                         if line[i+1] = ' '
                            then line[i] := keymap[ord(line[i])];
                         SkipItem(line,i); SkipWhite(line,i);
                         if line[i+1] = ' '
                            then line[i] := keymap[ord(line[i])];
                         writeln(KeybFile, line)
                        end
          end
end;

Procedure InitKeyMap;
var i: byte;
begin
 for i := 32 to 255 do keymap[i] := chr(i)
end;

Procedure Greet;
begin
 Writeln('This is MAKEKEYB 1.0');

 Writeln; Writeln
end;

Procedure Init;
var dr: String;
begin
 clrscr;
 Greet;
 InitKeyMap; TOP := 1;
 Write('Input font file: '); readln(FontFile);
 Write('Input keyboard driver: '); readln(dr);
 assign(KeybTemplate, dr + '.key');
 OutputFile := FontFile + '_' + dr + '.key';
 assign(KeybFile,OutputFile);
 reset(KeybTemplate); close(KeybTemplate);
 loadfont(FontFile)
end;

Procedure WriteMap;
 var MapFile: text; i: byte;
begin
  Maps := copy(OutputFile,1,length(OutputFile)-4) + '.map';
  assign(MapFile,Maps); rewrite(MapFile);
  writeln(MapFile,'CHAR KEY(S)');
  writeln(MapFile);
  for i := 128 to 255 do writeln (MapFile,chr(i) + '       ' + Mappings[i]);
  close(MapFile);

end;

begin
 init;
 BindKeys;
 repeat
   WriteKeys;
   WriteCombi;
   WriteMap;
   writeln; writeln('Output written to ', OutputFile,';');
   writeln ('Keyboard mappings written to ', Maps, '.');
   close(KeybFile); close(KeybTemplate);
   writeln; write('Make more drivers [y/n]? '); readln(r);
   if r in ['y','Y'] then begin
                           Write('Input keyboard driver: '); readln(dr);
                           assign(KeybTemplate, dr + '.key');
                           OutputFile := FontFile + '_' + dr + '.key';
                           assign(KeybFile,OutputFile)
                          end;
 until r in ['n', 'N'];
 LoadFont('')
end.
