{**********************************************************************
Copyright (C) 2009 by Salvatore Licciardi

Web http://www.webalice.it/turylicciardi    eMail turylicciardi@tiscali.it

 This program is free software: you can redistribute it and/or modify it under
 the terms of the GNU General Public License as published by the Free Software
 Foundation, version 3 of the License.
 This program is distributed in the hope  that it will be useful , but WITHOUT
 ANY WARRANTY without even the implied warranty  of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.
 See the GNU General Public License for more details. You should have received
 a copy of the GNU General Public License along with this program. If not, see
 http://www.gnu.org/licenses/

 **********************************************************************}

unit T_notes;      // per editor a partire dalla versione 2.53
{$MODE ObjFpc}
{$H+}  // longstring

{$ifdef Win64}
 {$define Win32}
{$endif}
{$ifdef Go32v2}
 {$define TxtCrt}
{$endif}
{$ifdef Win32}
 {$define TxtVideo}
{$endif}
{$ifdef OS2}
 {$define TxtVideo}
{$endif}
{$ifdef Linux}
 {$define TxtCrt}
{$endif}

interface

uses {$ifdef TxtCrt}Crt{$else}Video, TxtVideo{$endif};

type Indicatore_Appunti=object

     public
      constructor init;
      destructor  destroy;
      procedure   Nuovo_Stato_Appunti(num_elementi_appunti:longint);  // ver 2.53
      procedure   Refresh_Stato_Appunti;     // ver 2.53
      procedure   Set_pos_XY(x,y:byte);      // ver 2.53
      function    Get_pos_X:byte;            // ver 2.53
      function    Get_pos_Y:byte;            // ver 2.53
      function    Get_Indicatore:char;       // ver 2.56

     private
      pos_x,pos_y:byte;
      stato_appunti:char;

     protected

     end;

implementation

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

constructor Indicatore_Appunti.init;
begin
stato_appunti:=' ';
pos_x:=1;
pos_y:=1;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

destructor Indicatore_Appunti.destroy;
begin
init;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure   Indicatore_Appunti.Set_pos_XY(x,y:byte);    // ver 2.53
begin
pos_x:=x;
pos_y:=y;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function    Indicatore_Appunti.Get_pos_X:byte;              // ver 2.53
begin
exit(pos_x);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function    Indicatore_Appunti.Get_pos_Y:byte;              // ver 2.53
begin
exit(pos_y);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Indicatore_Appunti.Refresh_Stato_Appunti; // ver 2.53
{$ifdef TxtCrt}var precedente_x,precedente_y:byte;{$endif}
begin
{$ifdef TxtCrt}
 precedente_x:=whereX;
 precedente_y:=whereY;
 gotoxy(pos_x,pos_y);
 TextColor(15);
 TextBackground(blue);
 write(stato_appunti);
 gotoxy(precedente_x,precedente_y);
{$else}
 if GetCharXY(pos_x-1,pos_y-1)<>stato_appunti then OutTextXY(pos_x-1,pos_y-1,stato_appunti,0,blue{backcolor},15{textcolor});
{$endif}
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Indicatore_Appunti.Nuovo_Stato_Appunti(num_elementi_appunti:longint);  // ver 2.53
begin
if num_elementi_appunti=0 then
   if stato_appunti=' ' then Exit
                        else
                         begin
                         stato_appunti:=' ';
                         refresh_stato_appunti;
                         exit;
                         end;
case stato_appunti of
     '\' : stato_appunti:='|';
     '|' : stato_appunti:='/';
     '/' : stato_appunti:='-';
     '-' : stato_appunti:='\';
     ' ' : stato_appunti:='-';
     end;
refresh_stato_appunti;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function Indicatore_Appunti.Get_Indicatore:char;  // ver 2.56
begin
exit(stato_appunti);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

end.

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

Versione:    Data:     Righe:  Modifica:

2.5.3       25/02/05      ?     inizio.
