{**********************************************************************
Copyright (C) 2009 by Salvatore Licciardi

Web http://www.webalice.it/turylicciardi    eMail turylicciardi@tiscali.it

 This program is free software: you can redistribute it and/or modify it under
 the terms of the GNU General Public License as published by the Free Software
 Foundation, version 3 of the License.
 This program is distributed in the hope  that it will be useful , but WITHOUT
 ANY WARRANTY without even the implied warranty  of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.
 See the GNU General Public License for more details. You should have received
 a copy of the GNU General Public License along with this program. If not, see
 http://www.gnu.org/licenses/

 **********************************************************************}

{ Contiene principalmente procedure relative alla versione 1.xx }

unit T_EDIT1x;
{$GOTO on}
{$MACRO on}
{$MODE objfpc}
{$H+}  // longstring

interface
{$ifdef Win64}
 {$define Win32}
{$endif}
{$ifdef Go32v2}
 {$define TxtCrt}
{$endif}
{$ifdef Win32}
 {$define TxtVideo}
{$endif}
{$ifdef OS2}
 {$define TxtVideo}
{$endif}
{$ifdef Linux}
 {$define TxtCrt}
{$endif}

 uses Crt,Sysutils,Math,Video,Keyboard,
      {$ifdef Go32v2}
       MsMouse,
       {$else}
       Mouse,Dos,
      {$endif}
      Altro32,Altro32D,Type_var,Lista_S,
      {$ifdef TxtCrt}
       Menu_X,Menu_Y;
      {$endif}
      {$ifdef TxtVideo}
       Menu_X_V,Menu_Y_V,TxtVideo;
      {$endif}

function  Tasto__Ctrl_Fine():boolean;
function  Foglio(riga:integer):integer;
procedure Pulisci1; {cancella menu (in basso) }
procedure Tasto__Sinistra;
procedure Sonoro;
procedure Colore;   {sfondo blu  e testo bianco}
procedure Normale;  {sfondo nero e testo grigio}

                       {*** SOLO VALORI ***}
function  MemAvail():longint;  { a partire da FPC 1.9.6   ver 2.52 }
function  Free:boolean;
function  Dim_File:longint;
procedure M_Stampa__Numero_Copie;    {out: copie}
function  get_cfg_htm():shortstring;                                // ver 2.77

                       {*** SOLO MESSAGGI ***}
function  ShellError:boolean;  // ver 1.83
function  AskSaveShell:char;   // ver 1.83
function  Tasti_SNA(x1,y1:byte):char;  // update 1.84
function  Tasti_SN(x1,y1:byte):char;   // update 1.84
procedure ErrorTextMode;               // ver 1.83
procedure M_opzioni__Configura1;       // configurazione EDITOR     update 1.82 , 1.84
procedure Hd_Low;
procedure Mess_Err_Inc;
procedure ErrFormato;
procedure Metti_X(x1,y1:byte; var bool:boolean);
procedure Righe_Finite;
{$ifdef TxtCrt}
procedure writeLBin(str:string);    {i caratteri non stampabili divengono '.'}
procedure writeBin(const c:char);   {i caratteri non stampabili divengono '.'}
{$endif}
{$ifdef TxtVideo}
procedure writeLBinXY(x,y:word; str:string);    {i caratteri non stampabili divengono '.'}
procedure writeBinXY(const x,y:word; const c:char);   {i caratteri non stampabili divengono '.'}
{$endif}
procedure BinSfinal;
procedure Pre_Tasti(x,y:byte);
procedure Sovrascrivere(percorso_nomefilex:string);
procedure Save_Ask;

                       {*** DI USO FREQUENTE legati ad ESC ***}
procedure ESC;         {premere Esc,Spazio,Invio o cliccarvi per continuare}
procedure Attrib;
procedure No_Selezione;
procedure Err_Print;
procedure Err_Backup;
procedure ErrParametro(stringa:string);
procedure Err_Sostituto;
procedure NoBackup;
procedure Need_Save;
procedure Open_Error1;
procedure Open_Error3;
procedure Open_Error4;
procedure InvalidName;
procedure CercaSalva;
procedure Not_Found;

                       {***VARIE***}
function  riga_menu():byte;   // ver 2.20
procedure Set_Cursore_X(valore:integer);           // ver 2.25
procedure Str_Int_multiplo(var n,m:integer; i,ii:integer);  {per le stringhe --> integer}
procedure Str_Int(var n:integer; i,ii:integer);  {per le stringhe --> integer}
procedure Si_No_Str(var s:string);
procedure Convert(var stringa:string);
procedure Da_A_Graph;
procedure Barra_Verticale;
function  Da_A_2(var val_da,val_a:int64; min_da,max_a:int64; testo_da,testo_a,messaggio:shortstring):boolean;  // update ver 2.83
function  Num_byte():longint; {calcola quanti bytes ci sono nel foglio fino al punto indicato dal cursore}
function  maxr():integer;
function  Tasto__Ctrl_Pag_Su():boolean; // posizionamento sulla prima riga della pagina
procedure Tasto__Ins;
procedure Azzera_Selezione;    {richiede Selez}
procedure Scambio;             {richiede Selez}
procedure M_opzioni__ASCII;
procedure Ord32_255(var testo:string; var x:byte; o:integer; c:char);
procedure Init;     {inizializzazione di tutto il testo restante}
procedure Evidenzia_Selezione;
procedure Info(ricerca:boolean);
procedure Info;
procedure M_speciale__Copia_Righe;         // copia dalla riga N a . . . }
procedure M_modifica__Copia_Selezione;
function  IniFile:boolean;
function  Din_Mem_Free(num:longint):boolean;    // ver 1.60 per Appunti
function  Zero(str:string; count:byte):string;  // ver 1.80
function  nomeLungo(s:string; l:byte):string;
function  open_ASK(nomefile:string):char;   //  ver 1.82
procedure open_ASK_comune(nomefile:string); //  ver 2.52
procedure Estensioni_note(c:char);          //  update ver 1.82
procedure Estensioni_non_note(c:char);      //  update ver 1.82
procedure M_opzioni__Velocita;              //  ver 1.80
function  num_elementi_appunti:longint;     //  ver 2.30
function  Cerca(find:boolean; str:string; var posto:byte):string;  // update 1.84
procedure No_OS;  { ver 1.81 }
procedure rimuovi_ultimo_appunto;                             // ver 2.58
function  nuovi_appunti(var indice_appunti:longint):boolean;  // ver 2.58
procedure fix_position;                     // ver 2.62
function  undo__x_prepara():string;         // ver 2.62
procedure undo__x_ripristina(s:string);     // ver 2.62
procedure Svuota_Tastiera;                  // ver 2.62
procedure beta_test;                        // ver 2.75  premendo il tasto F12
function  sono_Appunti():boolean;           // ver 3.28

{
NON INTERFACCIATI
procedure Modif;
function  setup_language():char;   // ver 3.30
}

implementation

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure beta_test;  // ver 2.75  premendo il tasto F12
begin
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function sono_Appunti():boolean; // ver 3.28
begin
Exit(copy(nomefile,1,1)='*');
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function MemAvail():longint;  { a partire da FPC 1.9.6 }
begin
memAvail:=high(longint) div 2;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure rimuovi_ultimo_appunto; // ver 2.58
var i:longint;
begin
appunti[0].destroy;
for i:=0 to length(appunti)-2 do appunti[i]:=appunti[i+1];
appunti[length(appunti)-1].destroy;
setlength(appunti,length(appunti)-1);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function nuovi_appunti(var indice_appunti:longint):boolean;  // ver 2.58
begin
if Num_Notes>0 then
   while length(appunti)>=Num_Notes do
         rimuovi_ultimo_appunto;  // lo fa in realta' una sola volta
indice_appunti:=length(appunti);  // non c'e' il +1 perche' parte da 0
setlength(appunti,indice_appunti+1);
Appunti[indice_appunti].init;
exit(true);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure fix_position; // ver 2.62
begin
if x_riga-x_min>79 then x_min:=x_riga-79;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Set_Cursore_X(valore:integer);     // ver 2.25
begin  // x_min e' la x minima della riga
x:=byte(valore);
x_riga:=x;
if x>=80 then x:=80;
x_reale:=x;
if x_min>x_riga then
                begin
                x_min:=x_riga;
                x:=1;
                x_reale:=x;
                end;
fix_position;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Tasto__Ins;   {R ins}
begin
if binario then Exit;
ins:=not ins;
if ins then CursorBig else CursorOn;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

{$ifdef TxtCrt}
procedure color_posiz(const posiz:byte);  { ver 1.80 }
begin
textcolor(white);
cursoroff;
gotoxy(13,riga_menu+3);   // frequenza
write(' ');
gotoxy(13,riga_menu+4);   // ritardo
write(' ');
gotoxy(64,riga_menu+3);   // orizzontale
write(' ');
gotoxy(64,riga_menu+4);   // verticale
write(' ');
gotoxy(34,riga_menu+1);   // OK
write(' ');
gotoxy(41,riga_menu+1);   // ESC
write(' ');
gotoxy(38,riga_menu+3);   // frequenza
write(' ');
gotoxy(38,riga_menu+4);   // ritardo
write(' ');
gotoxy(79,riga_menu+3);   // orizzontale
write(' ');
gotoxy(79,riga_menu+4);   // verticale
write(' ');
gotoxy(39,riga_menu+1);   // OK
write(' ');
gotoxy(47,riga_menu+1);   // ESC
write(' ');
case posiz of
     1: gotoxy(13,riga_menu+3);   // frequenza
     2: gotoxy(13,riga_menu+4);   // ritardo
     3: gotoxy(64,riga_menu+3);   // orizzontale
     4: gotoxy(64,riga_menu+4);   // verticale
     5: gotoxy(34,riga_menu+1);   // OK
     6: gotoxy(41,riga_menu+1);   // ESC
     end;
write('[');
case posiz of
     1: gotoxy(38,riga_menu+3);   // frequenza
     2: gotoxy(38,riga_menu+4);   // ritardo
     3: gotoxy(79,riga_menu+3);   // orizzontale
     4: gotoxy(79,riga_menu+4);   // verticale
     5: gotoxy(39,riga_menu+1);   // OK
     6: gotoxy(47,riga_menu+1);   // ESC
     end;
write(']');
textcolor(lightgreen);
end;
{$endif}

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

{$ifdef TxtCrt}
procedure vuoto(posiz,lunghezza:byte);  { ver 1.81 }
var i:byte;
    str:string;
begin
case posiz of
     1: gotoxy(13+lunghezza+1,riga_menu+3);   // frequenza
     2: gotoxy(13+lunghezza+1,riga_menu+4);   // ritardo
     3: gotoxy(64+lunghezza+1,riga_menu+3);   // orizzontale
     4: gotoxy(64+lunghezza+1,riga_menu+4);   // verticale
     end;
str:='';
if posiz in [1,2] then for i:=whereX to 38 do str:=str+' '
                  else if posiz in [3,4] then for i:=whereX to 79 do str:=str+' ';
if posiz in [1..4] then write(str);
end;
{$endif}

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure M_opzioni__Velocita;  //  ver 1.80
{$ifdef Go32v2}
var old_posiz,posiz,lastD,lastU,posto_frequenza,posto_verticale,posto_ritardo,posto_orizzontale:byte;
    app:longint;
    c,s_frequenza,s_ritardo,s_orizzontale,s_verticale:string;
    insert_frequenza,insert_orizzontale,insert_verticale,insert_ritardo,cliccato:boolean;
    error:word;
label OK;
begin
posto_frequenza:=2;
insert_frequenza:=false;
posto_ritardo:=2;
insert_orizzontale:=false;
posto_orizzontale:=2;
insert_ritardo:=false;
posto_verticale:=3;
insert_verticale:=false;
frequenza:=0;
ritardo:=0;
s_frequenza:='0';
s_ritardo:='0';
s_orizzontale:='8';
s_verticale:='16';
posiz:=6; // posiz=1 frequenza | 2 ritardo | 3 orizzontale | 4 verticale | 5 OK | 6 Esc
pulisci1;
gotoxy(1,riga_menu+1);
write('                                                              ');
gotoxy(20-Lingue.get_length_txt(48) div 2,riga_menu+1);
write(Lingue.get_txt(49)); //  'Tastiera'
gotoxy(60-Lingue.get_length_txt(49) div 2,riga_menu+1);
write(Lingue.get_txt(50)); //  'Mouse'
gotoxy(35,riga_menu+1);
textcolor(red);
textbackground(7);
write('<ok>');
gotoxy(42,riga_menu+1);
write('<esc>');
textcolor(white);
textbackground(blue);
gotoxy(1,riga_menu+3);
write('                                                              ');
gotoxy(2,riga_menu+3);
write(Lingue.get_txt(51));  // 'Frequenza:'
gotoxy(42,riga_menu+3);
write(Lingue.get_txt(52));  // 'velocit Orizzontale:'
gotoxy(1,riga_menu+4);
clreol;
gotoxy(1,riga_menu+4);
write('                                                            ');
gotoxy(2,riga_menu+4);
write(Lingue.get_txt(53)); // 'Ritardo:'
gotoxy(42,riga_menu+4);
write(Lingue.get_txt(54)); // 'velocit Verticale:'
gotoxy(40,riga_menu+1);
write(c_U2);  // ''
gotoxy(40,riga_menu+2);
write(c_U2);
gotoxy(40,riga_menu+3);
write(c_U2);
gotoxy(40,riga_menu+4);
write(c_U2);
textcolor(lightgreen);
gotoxy(14,riga_menu+3);
write('0');
gotoxy(14,riga_menu+4);
write('0');
gotoxy(65,riga_menu+3);
write('8');
gotoxy(65,riga_menu+4);
write('16');
color_posiz(posiz);
posiz:=1;
old_posiz:=7;
textcolor(13);
gotoxy(lingue.get_pos_rosso(51),riga_menu+3);
write(Lingue.get_char(51));    // 'F'
gotoxy(lingue.get_pos_rosso(52),riga_menu+3);
write(Lingue.get_char(52));    // 'O'
gotoxy(lingue.get_pos_rosso(53),riga_menu+4);
write(Lingue.get_char(53));    // 'R'
gotoxy(lingue.get_pos_rosso(54),riga_menu+4);
write(Lingue.get_char(54));    // 'V'
showmouse;
showmouse;
repeat
 if (old_posiz<>posiz) then
                    begin
                    cursoroff;
                    color_posiz(posiz);
                    hidemouse;
                    showmouse;
                    old_posiz:=posiz;
                    end;
 if (old_posiz=posiz)and(posiz<5) then color_posiz(posiz); // ver 1.85
 case posiz of
     1: begin  // frequenza
        gotoxy(13,riga_menu+3);
        hidemouse;
        s_frequenza:=ReadString(s_frequenza,14,37,0,topo,true,mancino,insert_frequenza,lastD,lastU,posto_frequenza);
        showmouse;
        if lastd=0 then
           case lastU of
                9: begin       // tab
                   vuoto(posiz,length(s_frequenza));
                   inc(posiz);
                   end;
                7: posiz:=6;   // Shift+Tab
               27: Exit;       // esco totalmente
               13: begin       // era valido l'input numerico?
                   Val_Try(trim(s_frequenza),app,error);
                   if app<255 then frequenza:=app
                              else error:=1;
                   if (error>0) or (frequenza<0) or (frequenza>31) then sonoro
                                                                   else
                                                                    begin
                                                                    vuoto(posiz,length(s_frequenza));
                                                                    inc(posiz);
                                                                    end;
                   end;
               end;
        end;
     2: begin   // ritardo
        gotoxy(14,riga_menu+4);
        hidemouse;
        s_ritardo:=ReadString(s_ritardo,14,37,0,topo,true,mancino,insert_ritardo,lastD,lastU,posto_ritardo);
        showmouse;
        if lastd=0 then
           case lastU of
                9: begin       // tab
                   vuoto(posiz,length(s_ritardo));
                   inc(posiz);
                   end;
                7: posiz:=1;   // Shift+Tab
               27: Exit;       // esco totalmente
               13: begin       // era valido l'input numerico?
                   Val_Try(trim(s_ritardo),app,error);
                   if app<255 then ritardo:=app
                              else error:=1;
                   if (error>0) or (ritardo<0) or (ritardo>3) then sonoro
                                                              else
                                                              begin
                                                              vuoto(posiz,length(s_ritardo));
                                                              inc(posiz);
                                                              end;
                   end;
               end;
        end;
     3: begin   // orizzontale
        gotoxy(65,riga_menu+3);
        hidemouse;
        s_orizzontale:=ReadString(s_orizzontale,65,78,0,topo,true,mancino,insert_orizzontale,lastD,lastU,posto_orizzontale);
        showmouse;
        if lastd=0 then
           case lastU of
                9: begin       // tab
                   vuoto(posiz,length(s_orizzontale));
                   inc(posiz);
                   end;
                7: posiz:=2;   // Shift+Tab
               27: Exit;       // esco totalmente
               13: begin       // era valido l'input numerico?
                   Val_Try(trim(s_orizzontale),MOrizzontale,error);
                   if (error>0) then sonoro
                                else
                                 begin
                                 vuoto(posiz,length(s_orizzontale));
                                 inc(posiz);
                                 end;
                   end;
               end;
        end;
     4: begin   // verticale
        gotoxy(65,riga_menu+4);
        hidemouse;
        s_verticale:=ReadString(s_verticale,65,78,0,topo,true,mancino,insert_verticale,lastD,lastU,posto_verticale);
        showmouse;
        if lastd=0 then
           case lastU of
                9: begin       // tab
                   vuoto(posiz,length(s_verticale));
                   inc(posiz);
                   end;
                7: posiz:=3;   // Shift+Tab
               27: Exit;       // esco totalmente
               13: begin       // era valido l'input numerico?
                   Val_Try(trim(s_verticale),MVerticale,error);
                   if (error>0) then sonoro
                                else
                                 begin
                                 vuoto(posiz,length(s_verticale));
                                 inc(posiz);
                                 end;
                   end;
               end;
        end;
     6: if (PollKeyEvent<>0) or (not topo) then     // ESC
           begin
           c:=KeyEventToString(TranslateKeyEvent(GetKeyEvent));
           if from_alt_to_char(c)<>#0 then c:=from_alt_to_char(c);
           if (pos('SHIFT ',c)<>0)and(length(c)=7) then c:=upcase(c[7]);
           if length(c)=1 then c:=upcase(c);
           if (c='SHIFT Key with scancode 3840') then posiz:=5 else // Shift+Tab
           if (c=#13)or(c=#27)or(c=#32) then Exit
                                        else
           if c=#9  then posiz:=1 else
           if c='F' then posiz:=1 else
           if c='R' then posiz:=2 else
           if c='O' then posiz:=3 else
           if c='V' then posiz:=4;
           end;
     5: if (PollKeyEvent<>0) or (not topo) then     // OK
           begin
           c:=KeyEventToString(TranslateKeyEvent(GetKeyEvent));
           if from_alt_to_char(c)<>#0 then c:=from_alt_to_char(c);
           if (pos('SHIFT ',c)<>0)and(length(c)=7) then c:=upcase(c[7]);
           if length(c)=1 then c:=upcase(c);
           if (c='SHIFT Key with scancode 3840') then posiz:=4 else // Shift+Tab
           if (c=#27) then Exit
                      else
           if (c=#13)or(c=#32) then
                   begin
                   OK:
                   Val_Try(trim(s_frequenza),frequenza,error);
                   if (error>0) or (frequenza<0) or (frequenza>31) then
                          begin
                          posiz:=1;
                          sonoro;
                          Continue;
                          end;
                   Val_Try(trim(s_ritardo),ritardo,error);
                   if (error>0) or (ritardo<0) or (ritardo>3) then
                          begin
                          posiz:=2;
                          sonoro;
                          Continue;
                          end;
                   Val_Try(trim(s_orizzontale),MOrizzontale,error);
                   if (error>0) then
                          begin
                          posiz:=3;
                          sonoro;
                          Continue;
                          end;
                   Val_Try(trim(s_verticale),MVerticale,error);
                   if (error>0) then
                          begin
                          posiz:=4;
                          sonoro;
                          Continue;
                          end;
                   Editor_Ini.Set_modifica(true);
                   Editor_Ini.Aggiorna('OPZIONI','MouseOrizzontale',intToStr(MOrizzontale));
                   Editor_Ini.Aggiorna('OPZIONI','MouseVerticale',intToStr(MVerticale));
                   Editor_Ini.Aggiorna('OPZIONI','Ritardo',intToStr(Ritardo));
                   Editor_Ini.Aggiorna('OPZIONI','Frequenza',intToStr(Frequenza));
                   SetMouseSpeed(MOrizzontale,MVerticale);
                   keyspeed(byte(ritardo),byte(frequenza));
                   Exit;
                   end else
           if (c=#9) then inc(posiz) else
           if upcase(c)=Lingue.get_charUp(51){'F'} then posiz:=1 else
           if upcase(c)=Lingue.get_charUp(53){'R'} then posiz:=2 else
           if upcase(c)=Lingue.get_charUp(52){'O'} then posiz:=3 else
           if upcase(c)=Lingue.get_char(54){'V'} then posiz:=4;
           end;
     end;  // case degli stati di posiz
 cliccato:=Doppio_Click.Mouse_Up(mox,moy,stato);
 if cliccato then stato:=1
             else stato:=0;
 if stato=1 then
           begin
           lastD:=moy;
           lastU:=mox;
           end;
 if lastD=255 then
              begin
              case char(lastU) of
                 'F': posiz:=1;
                 'R': posiz:=2;
                 'O': posiz:=3;
                 'V': posiz:=4;
                 end
              end else
 if lastD=riga_menu+1 then
          begin
          vuoto(1,length(s_frequenza));
          vuoto(2,length(s_ritardo));
          vuoto(3,length(s_orizzontale));
          vuoto(4,length(s_verticale));
          if (lastU>34) and (lastU<39) then goto OK;
          if (lastU>41) and (lastU<47) then Exit;
          end else
 if lastD=riga_menu+3 then
          begin
          vuoto(1,length(s_frequenza));
          vuoto(2,length(s_ritardo));
          vuoto(3,length(s_orizzontale));
          vuoto(4,length(s_verticale));
          if (lastU>13) and (lastU<39) then posiz:=1;
          if (lastU>64) and (lastU<79) then posiz:=3;
          end else
 if lastD=riga_menu+4 then
          begin
          vuoto(1,length(s_frequenza));
          vuoto(2,length(s_ritardo));
          vuoto(3,length(s_orizzontale));
          vuoto(4,length(s_verticale));
          if (lastU>62) and (lastU<79) then posiz:=4;
          if (lastU>11) and (lastU<39) then posiz:=2;
          end;
until false;
{$else}
begin
{$endif}
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Mess_Err_Inc;
begin
pulisci1;
hidemouse;
gotoxy(40-Lingue.get_length_txt(55) div 2,riga_menu+1);
write(Lingue.get_txt(55));    // 'Impossibile effettuare l'' operazione di incolla.'
gotoxy(40-Lingue.get_length_txt(56) div 2,riga_menu+2);
write(Lingue.get_txt(56));    // 'Memoria insufficiente. Tutte le righe sono state usate.'
showmouse;
showmouse;
Esc;
gotoxy(1,riga_menu+4);
write('                                                                    ');
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Righe_Finite;
begin
pulisci1;
hidemouse;
gotoxy(40-Lingue.get_length_txt(57) div 2,riga_menu+2);
writeln(Lingue.get_txt(57));   //  'L''area per il testo e'' tutta usata.'
gotoxy(40-Lingue.get_length_txt(58) div 2,riga_menu+3);
writeln(Lingue.get_txt(58));   // 'Impossibile scrivere altre informazioni.'
showmouse;
Esc;
HideMouse;
colore;
pulisci1;
gotoxy(2,riga_menu+4);
write('                                                                         ');
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function maxr():integer;    // update ver 2.88
begin
if mem_automatica and (not binario) then exit(32767)      // 2^15 -1
                                    else exit(max_righe);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function Num_byte():longint;
begin
num_byte:=(iy-1)*lunghezza_riga+x_riga;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Pulisci1; {cancella menu (in basso) }
var i:byte;
begin
HideMouse;
colore;
for i:=riga_menu+1 to riga_menu+3 do
   begin
   gotoxy(1,i);
   clreol;
   end;
ShowMouse;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Colore;   {sfondo blu e testo bianco}
begin
TextColor(15);
TextBackground(blue);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Normale;  {sfondo nero e testo grigio}
begin
TextColor(7);
TextBackground(black);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Sonoro;
begin
sound(300);
delay2(0);
Tast_Vuota;
nosound;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function Foglio(riga:integer):integer;
begin
foglio:=((riga-1) div (riga_menu-1) )+1;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure NoBackup;
begin
pulisci1;
gotoxy(40-Lingue.get_length_txt(59) div 2,riga_menu+1);
write(Lingue.get_txt(59));     //   'Se il file e'' di tipo esadecimale,'
gotoxy(40-Lingue.get_length_txt(60) div 2,riga_menu+2);
write(Lingue.get_txt(60));     // 'non e'' possibile creare un file di backup.'
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure ErrFormato;
begin
pulisci1;
gotoxy(40-Lingue.get_length_txt(61) div 2,riga_menu+1);
write(Lingue.get_txt(61));  // 'Impossibile cambiare il formato.'
gotoxy(40-Lingue.get_length_txt(62) div 2,riga_menu+2);
write(Lingue.get_txt(62));  // 'Salvare prima il testo in un file.'
ShowMouse;
Esc;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure BinSfinal;
begin
pulisci1;
gotoxy(40-Lingue.get_length_txt(63) div 2,riga_menu+1);
write(Lingue.get_txt(63));     //  'Se il file e'' di tipo esadecimale,'
gotoxy(40-Lingue.get_length_txt(64) div 2,riga_menu+2);
write(Lingue.get_txt(64));     // 'e'' obbligatorio salvare anche gli spazi finali.'
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure ESC;  { <ESC> , premere Esc,Spazio,Invio o cliccarvi per continuare }
var c:string;
    str:string;
    i:byte;
    cliccato:boolean;
begin
ShowMouse;  {Necessario: non modifica il colore del testo o dello sfondo}
HideMouse;
colore;
cursorOff;
gotoxy(1,riga_menu+4);
write('                                    ');
TextColor(red);
TextBackground(7);
gotoxy(37,riga_menu+4);
write('<esc>');
colore;
gotoxy(42,riga_menu+4);
str:='';
for i:=1 to (max_larghezza-whereX) do str:=str+' ';
write(str);
textcolor(white);
gotoxy(36,riga_menu+4);
write('[');
gotoxy(42,riga_menu+4);
write(']');
ShowMouse;
sonoro;
c:=#0;
mox:=0;
moy:=0;
stato:=0;
repeat
 if (PollKeyEvent<>0) or (not topo) then c:=KeyEventToString(TranslateKeyEvent(GetKeyEvent));
 cursoroff;
 if topo then
    begin
    {$ifdef Go32v2}
    cliccato:=Doppio_Click.Mouse_Up(mox,moy,stato);
    {$else}
    cliccato:=Doppio_Click.Mouse_Down(mox,moy,stato);
    {$endif}
    if cliccato then stato:=1
                else stato:=0;
    sleep(5);
    end;
until (c=#27)or(c=#13)or(c=' ')or((mox>36)and(mox<42)and(moy=riga_menu+4)and(stato=1));
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Attrib;
begin
colore;
HideMouse;
showmouse;
gotoxy(1,riga_menu+2);
clreol;
gotoxy(40-Lingue.get_length_txt(65) div 2,riga_menu+2);
write(Lingue.get_txt(65));  // 'Impossibile salvare il file con questo nome.'
gotoxy(1,riga_menu+3);
clreol;
gotoxy(40-Lingue.get_length_txt(66) div 2,riga_menu+3);
write(Lingue.get_txt(66));  // 'Controllarne il percorso, l''unita'', lo spazio e gli attributi.'
Esc;
colore;
gotoxy(1,riga_menu+2);
clreol;
gotoxy(1,riga_menu+3);
clreol;
gotoxy(1,riga_menu+4);
write('                                                                      ');
ShowMouse;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure No_Selezione;
begin
pulisci1;
gotoxy(40-Lingue.get_length_txt(67) div 2,riga_menu+2);
write(Lingue.get_txt(67));  // 'Bisogna prima selezionare una parte del testo.'
ShowMouse;
Esc;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Err_Print;
begin
pulisci1;
gotoxy(40-Lingue.get_length_txt(68) div 2,riga_menu+1);
write(Lingue.get_txt(68));   // 'Impossibile stampare.'
gotoxy(40-Lingue.get_length_txt(69) div 2,riga_menu+2);
write(Lingue.get_txt(69));   // 'Possibili cause: stampante spenta, inchiostro e/o carta esauriti.'
Esc;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Err_Backup;
begin
colore;
HideMouse;
gotoxy(1,riga_menu+2);
clreol;
gotoxy(1,riga_menu+3);
clreol;
gotoxy(40-Lingue.get_length_txt(70) div 2,riga_menu+3);
write(Lingue.get_txt(70));     //  'Errore durante la creazione del file di Backup.'
Esc;
colore;
gotoxy(1,riga_menu+2);
clreol;
gotoxy(1,riga_menu+3);
clreol;
gotoxy(1,riga_menu+4);
write('                                                                      ');
ShowMouse;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure ErrParametro(stringa:string);
begin
pulisci1;
gotoxy(2,riga_menu+1);
write(Lingue.get_txt(71));    // 'Impossibile accedere a '
textcolor(white);
textbackground(red);
write(TruncPath(stringa,50));
textbackground(Blue);
gotoxy(2,riga_menu+2);
write(Lingue.get_txt(72)); //  'Possibili cause: percorso e/o nome di file non esistente o non valido.'
ShowMouse;
Esc;
normale;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Err_Sostituto;
begin
pulisci1;
gotoxy(40-Lingue.get_length_txt(73) div 2,riga_menu+1);
write(Lingue.get_txt(73));    //  'Operazione di sostituzione interrotta.'
gotoxy(40-Lingue.get_length_txt(74) div 2,riga_menu+2);
write(Lingue.get_txt(74));    //  'Con il formato esadecimale bisogna sostituire le parole con altre'
gotoxy(40-Lingue.get_length_txt(75) div 2,riga_menu+3);
write(Lingue.get_txt(75));    //  'della stessa lunghezza.'
Esc;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Pre_Tasti(x,y:byte);
begin
HideMouse;
gotoxy(x,y);
textcolor(red);
textbackground(7);
write('<ok>');
gotoxy(x+6,y);
write('<esc>');
colore;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Sovrascrivere(percorso_nomefilex:string);
begin
{$ifdef TxtVideo}
windowsStr(0,riga_menu,max_larghezza-1,riga_menu+2,' ',255,blue,white);
updatescreen(false);
{$endif}
HideMouse;
gotoxy(1,riga_menu+2);
colore;
write(Lingue.get_txt(76));  // 'Il file esiste gia'': '
textcolor(white);
textbackground(red);
write(TruncPath(percorso_nomefilex,55));
colore;
gotoxy(1,riga_menu+3);
write('                                                                     ');
gotoxy(30-Lingue.get_length_txt(77),riga_menu+4);  //  giusto 30-
write(Lingue.get_txt(77));   // 'Sostituirlo ? '
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Save_Ask;      // update ver 2.45
begin
HideMouse;
colore;
{$ifdef TxtCrt}
gotoxy(31-Lingue.get_length_txt(78),riga_menu+3);
write(Lingue.get_txt(78));  // 'Salvare le modifiche ?  '
{$endif}
{$ifdef TxtVideo}
OutTextXY(31-Lingue.get_length_txt(78),riga_menu+2,Lingue.get_txt(78),0,blue,white);   // '       Salvare le modifiche ?  '
{$endif}
ShowMouse;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Need_Save;
begin
pulisci1;
gotoxy(3,riga_menu+2);
write(Lingue.get_txt(79));  //  ' Per poter passare ad un'' altra parte del file, devi prima salvare questa.'
gotoxy(27-Lingue.get_length_txt(80),riga_menu+4);
write(Lingue.get_txt(80));  // 'Salvarla ?'
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure CercaSalva;
begin
pulisci1;
gotoxy(40-Lingue.get_length_txt(81) div 2,riga_menu+2);
write(Lingue.get_txt(81)); // 'E'' necessario salvare le modifiche per poter applicare tale funzione'
Esc;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure InvalidName;
begin
HideMouse;
colore;
gotoxy(40-Lingue.get_length_txt(82) div 2,riga_menu+2);
write(Lingue.get_txt(82)); // 'Il nome del file indicato non e'' valido. Sceglierne uno diverso.'
Esc;
HideMouse;
colore;
gotoxy(2,riga_menu+4);
write('                                                                         ');
gotoxy(1,riga_menu+2);
write('                                                                         ');
Info(false);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

{$ifdef TxtCrt}
procedure writeBin(const c:char);  {i caratteri non stampabili divengono '.'}
begin
if binario then
           if ord(c) in unprintable then write('.')
                                    else write(c)
           else
            if WhereX<max_larghezza then write(c);
end;
{$endif}

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function Fix(s:shortstring):shortstring;  {i caratteri non stampabili divengono '.' , e riga allungata di caratteri, con spazi aggiunti alla fine}
var i:integer;      // torna la riga di 79 caratteri nella schermata con spazi vuoti
begin    // scelti i tipi ShotString, per questione di efficenza al video
s:=copy_end(s,2);
for i:=1 to length(s) do
    if ord(s[i]) in unprintable then s[i]:='.';
while length(s)<255 do s:=s+' ';
result:=copy(s,x_min,x_min+79);
if length(result)>79 then setlength(result,79);
while length(result)<79 do result:=result+' ';
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function Fix_(s:shortstring):shortstring;  { i caratteri non stampabili divengono '.' }
var i:integer;      // torna la riga di 79 caratteri nella schermata
begin    // scelti i tipi ShotString, per questione di efficenza al video
s:=copy_end(s,2);
for i:=1 to length(s) do
    if ord(s[i]) in unprintable then s[i]:='.';
result:=copy(s,x_min,x_min+79);
if length(result)>79 then setlength(result,79);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

{$ifdef TxtVideo}
procedure writeBinXY(const x,y:word; const c:char);  {i caratteri non stampabili divengono '.'}
begin
if binario then
           if ord(c) in unprintable then outtextxy(x,y,'.')
                                    else outtextxy(x,y,c)
           else
            if WhereX<max_larghezza then outtextxy(x,y,c);
end;
{$endif}

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

{$ifdef TxtCrt}
procedure writeLBin(str:string);  {i caratteri non stampabili divengono '.'}
var i:byte;                       { ver 1.60 }
begin
for i:=2 to length(str) do if ord(str[i]) in unprintable then str[i]:='.';
while length(str)<max_larghezza do str:=str+' ';
write(copy_end(str,2));
end;
{$endif}

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

{$ifdef TxtVideo}
procedure writeLBinXY(x,y:word; str:string);  {i caratteri non stampabili divengono '.'}
var i:byte;                      // ver 1.84
begin
for i:=2 to length(str) do if ord(str[i]) in unprintable then str[i]:='.';
while length(str)<max_larghezza do str:=str+' ';
outtextXY(x,y,copy_end(str,2));
end;
{$endif}

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Modif;
begin
{$ifdef TxtCrt}
gotoxy(max_larghezza-1,riga_menu+4);
textcolor(white);
if modifica then write(pallino_modifica)   {testo modificato}
            else write(' ');
{$else}
if modifica then
             begin
             if GetCharXY(max_larghezza-2,riga_menu+3)<>pallino_modifica then OutTextXY(max_larghezza-2,riga_menu+3,pallino_modifica,0,blue,white);
             end
            else
             begin
             if GetCharXY(max_larghezza-2,riga_menu+3)<>' ' then OutTextXY(max_larghezza-2,riga_menu+3,' ',0,blue,white);
             end;
{$endif}
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Da_A_Graph;
begin
colore;
gotoxy(70,riga_menu+4);
write('          ');
gotoxy(1,riga_menu+1);
DelLine;
DelLine;
DelLine;
{$ifdef TxtVideo}
outtextxy(0,riga_menu-1,GetStringXY(0,riga_menu+3,28));
gotoxy(1,riga_menu+2);
clreol;
gotoxy(1,riga_menu+3);
clreol;
gotoxy(1,riga_menu+4);
clreol;
{$endif}
modif;
stato_appunti.Refresh_Stato_Appunti; // ver 2.53
textcolor(white);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

{$ifdef TxtCrt}
procedure Barra_Verticale;
var quanto,posv:integer;
begin
quanto:=ymax div (riga_menu-2);
if quanto=0 then quanto:=1;
posV:=iy div quanto+1; // originale: senza +1

if posV>riga_menu-3 then posV:=riga_menu-2;
if posV<2 then posV:=2;
if verticale<>posV then
   begin
   hidemouse;
   textbackground(blue);
   textcolor(white);
   gotoxy(max_larghezza,verticale);
   write(c_B);    //  ''
   verticale:=byte(posV);
   gotoxy(max_larghezza,verticale);
   write(c_S);    //  #9
   gotoxy(x,y);
   ShowMouse;
   end;
end;
{$endif}

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

{$ifdef TxtVideo}
procedure Barra_Verticale;
var quanto,posv:integer;
begin
quanto:=ymax div (riga_menu-2);
if quanto=0 then quanto:=1;
posV:=iy div quanto;

if posV>riga_menu-3 then posV:=riga_menu-2;
if posV<2 then posV:=2;
if verticale<>posV then
   begin
   outtextxy(max_larghezza-1,verticale-1,c_B,0,blue,white);  // 
   verticale:=byte(posV);
   outtextxy(max_larghezza-1,verticale-1,c_S,0,blue,white);   // #9
   updatescreen(false);
   end;
end;
{$endif}

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Metti_X(x1,y1:byte; var bool:boolean);
var x2,y2:byte;
begin
HideMouse;
x2:=whereX;
y2:=whereY;
bool:=not bool;
gotoxy(x1,y1);    {posto in cui scrivere}
colore;
if bool then write('X')
        else write(' ');
gotoxy(x2,y2);    {posto vecchio cursore}
ShowMouse;
ShowMouse;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Open_Error1;
begin
pulisci1;
if not binario then
   begin
   gotoxy(40-Lingue.get_length_txt(83) div 2,riga_menu+1);
   write(Lingue.get_txt(83));  // 'Editor non puo'' caricare tutto il testo del file appena aperto.'
   gotoxy(40-Lingue.get_length_txt(84) div 2,riga_menu+2);
   write(Lingue.get_txt(84));  // 'Si consiglia di salvarlo con un nome differente.'
   end;
Esc;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Open_Error3;
begin
pulisci1;
gotoxy(40-Lingue.get_length_txt(85) div 2,riga_menu+2);
writeln(Lingue.get_txt(85)); //  'Errore in lettura.  File in uso da un'' altra applicazione o errore HardWare.'
Esc;
gotoxy(1,riga_menu+2);
clreol;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Open_Error4;
begin
pulisci1;
gotoxy(40-Lingue.get_length_txt(86) div 2,riga_menu+2);
writeln(Lingue.get_txt(86));  // 'Errore in lettura. Controllare gli attributi del file, che non sia in uso da'
gotoxy(40-Lingue.get_length_txt(87) div 2,riga_menu+3);
writeln(Lingue.get_txt(87)); //  'un'' altra applicazione, che sia presente o che vi sia un errore HardWare.'
Esc;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Azzera_Selezione;
begin
with old_selezionato do
         begin
         y2:=0;
         x2:=0;
         y1:=0;
         x1:=0;
         end;
selezionato:=old_selezionato;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Scambio;
begin
if selezionato.y2<selezionato.y1 then
       begin
       Exchange(selezionato.y1,selezionato.y2);
       Exchange(selezionato.x1,selezionato.x2);
       end;
if (selezionato.y2=selezionato.y1)and(selezionato.x1>selezionato.x2) then
       Exchange(selezionato.x1,selezionato.x2);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

{$ifdef TxtCrt}
procedure M_opzioni__ASCII;
var j,i,old_off,offset:integer;
    cliccato:boolean;
    x,y:byte;
    c,str:string;
label start,start2;

begin
offset:=0;
hidemouse;
colore;
clrscr;
gotoxy(40-Lingue.get_length_txt(88) div 2,1);
textcolor(LightCyan);
writeln(Lingue.get_txt(88));  // 'Tavola dei caratteri ASCII'
textcolor(lightred);
gotoxy(20-Lingue.get_length_txt(89) div 2,3);
write(Lingue.get_txt(89));    // 'Numero Decimale'
textcolor(yellow);
gotoxy(40-Lingue.get_length_txt(90) div 2,3);
write(Lingue.get_txt(90));    // 'Numero Esadecimale'
textcolor(white);
gotoxy(60-Lingue.get_length_txt(91) div 2,3);
write(Lingue.get_txt(91));    // 'Carattere ASCII'
writeln;
writeln;
TextColor(lightgreen);

str:='';
for j:=1 to 9 do
    begin
    for i:=1 to 8 do str:=str+c_D1;  //  ''
    str:=str+c_CU1;
    end;
str:=copy(str,1,length(str)-1);
writeln(str); // era writeln('');

str:='';
for j:=1 to 9 do
    begin
    for i:=1 to 8 do str:=str+c_D1;
    str:=str+c_CD1;
    end;
str:=copy(str,1,length(str)-1);
gotoxy(1,23);
writeln(str); // era writeln('');
TextColor(red);
textBackground(7);
gotoxy(1,24);
write('<Pag',c_FU,'>'); // #24
gotoxy(9,24);
write(c_FU);   // #24
gotoxy(1,25);
write  ('<Pag',c_FD,'>');   // #25
gotoxy(9,25);
write(c_FD);    // #25
                               start:
colore;
showmouse;
gotoxy(1,6);
for i:=0+offset to 152+offset do
    begin
    TextColor(lightred);
    write(i:3,' ');
    TextColor(yellow);
    write(HexStr(i,2));
    x:=whereX;
    y:=wherey;
    TextColor(White);
    if i<256 then
              if byte(i) in unprintable then write('  ') {bel,BackSpace ...}
                                        else write(' ',char(i));
    if (i>255)and(i<=260) then
        begin
        gotoxy(wherex-8,wherey);
        write('          ');
        end;
    gotoxy(x+3,y);
    if whereX>max_larghezza-5 then writeln;
    end;
TextColor(10);
for x:=1 to 8 do
    for j:=0 to 16 do
        begin
        gotoxy(x*9,6+j);
        write(c_U1);  // ''
        end;
TextColor(red);
TextBackground(7);
gotoxy(37,25);
write('<esc>');
hidemouse;
showmouse;
showmouse;
cursoroff;
repeat
if (PollKeyEvent<>0) or (not topo) then
   begin
   c:=KeyEventToString(TranslateKeyEvent(GetKeyEvent));
   start2:
   if (c='Home')or(c='PgUp') then
               begin      {inizio,pagSu #71,#73}
               if offset<9 then Continue;
               offset:=0;
               goto start;
               end else
   if (c='Up') then
               begin      {su #72}
               old_off:=offset;
               if offset>8 then offset:=offset-9
                           else offset:=0;
               if offset=old_off then Continue;
               goto start;
               end else
   if (c='End')or(c='PgDn') then
               begin      {fine/pagGiu #79,#81}
               if offset>=108 then Continue;
               offset:=108;
               goto start;
               end else
   if (c='Down') then
               begin      {giu #80}
               old_off:=offset;
               offset:=offset+9;
               if offset>108 then offset:=108;
               if old_off=offset then Continue;
               goto start;
               end;
   end
  else {tasto non premuto}
   begin
   cliccato:=Doppio_Click.Mouse_Down(mox,moy,stato);
   if cliccato then stato:=1
               else stato:=0;
   if (stato=1) and (mox=9) and (moy=24) then  {Su}
      begin
      c:='Up';  // #72
      delay2(5);
      goto start2;
      end else
   if (stato=1) and (mox=9) and (moy=25) then  {Giu}
      begin
      c:='Down';  // #80
      delay2(5);
      goto start2;
      end;
   {$ifdef go32v2}
   cliccato:=Doppio_Click.Mouse_Up(mox,moy,stato);
   if cliccato then stato:=1
               else stato:=0;
   {$endif}
   if (stato=1) and (mox>0) and (mox<7) and (moy=24) then  {pagSu}
      begin
      c:='PgUp';  // #71
      goto start2;
      end else
   if (stato=1) and (mox>0) and (mox<7) and (moy=25) then  {pagGiu}
      begin
      c:='PgDn';  // #79
      goto start2;
      end;
   end;
until (c=#27)or(c=#13)or(c=' ')or((mox>36)and(mox<42)and(moy=25)and(stato=1));
if ins then CursorBig else CursorOn;
Evidenzia_Selezione;
end;
{$endif}

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

{$ifdef TxtVideo}
procedure M_opzioni__ASCII;

{---------------------------------------------------------------------------}

function space(s:string; n:byte):string;
begin
while length(s)<n do s:=' '+s;
exit(s);
end;

{---------------------------------------------------------------------------}

var j,i,x,old_off,offset:integer;
    cliccato:boolean;
    c,str:string;
label start,start2;
begin
offset:=0;
cursorOff;
outtextxy(0,0,' ',0,blue,white,ScreenWidth*ScreenHeight);
gotoxy(1,1);
outtextxy(39-Lingue.get_length_txt(88) div 2,0,Lingue.get_txt(88),0,255,LightCyan);   // 'Tavola dei caratteri ASCII'
outtextxy(19-Lingue.get_length_txt(89) div 2,2,Lingue.get_txt(89),255,255,lightred);  // 'Numero Decimale'
outtextxy(39-Lingue.get_length_txt(90) div 2,2,Lingue.get_txt(90),255,255,yellow);    // 'Numero Esadecimale'
outtextxy(59-Lingue.get_length_txt(91) div 2,2,Lingue.get_txt(91));                   // 'Carattere ASCII'

str:='';
for j:=1 to 9 do
    begin
    for i:=1 to 8 do str:=str+c_D1;  //  ''
    str:=str+c_CU1;
    end;
outtextxy(0,4,copy(str,1,length(str)-1),255,255,lightgreen); // era ('');

str:='';
for j:=1 to 9 do
    begin
    for i:=1 to 8 do str:=str+c_D1;
    str:=str+c_CD1;
    end;
outtextxy(0,22,copy(str,1,length(str)-1),255,255,lightgreen);

outtextxy(0,23,'<Pag'+c_FU+'>',255,7,red);  // #24
outtextxy(8,23,c_FU,255,7,red);   // #24
outtextxy(0,24,'<Pag'+c_FD+'>',255,7,red); // #25
outtextxy(8,24,c_FD,255,7,red);  // #25
outtextxy(36,24,'<esc>',255,7,red);
for x:=1 to 8 do for i:=0 to 16 do outtextxy(x*9-1,5+i,c_U1{''},255,255,lightgreen);
        start:
x:=-1;
j:=-1;
for i:=0+offset to 152+offset do
    begin
    inc(x);
    if (x mod 9)=0 then
                   begin
                   x:=0;
                   inc(j);
                   end;
    if i<256 then outtextxy(x*9,5+j,space(inttostr(i),3),255,255,lightred);
    if i<256 then outtextxy(x*9+3,5+j,' '+HexStr(i,2),255,255,yellow);
    if i<256 then if byte(i) in unprintable then outtextxy(x*9+6,5+j,'  ',255,255,White)
                                            else outtextxy(x*9+6,5+j,' '+char(i),255,255,White);
    if i>255 then outtextxy(x*9,5+j,'        ');
    end;
updatescreen(false);
repeat
if (PollKeyEvent<>0) or (not topo) then
   begin
   c:=KeyEventToString(TranslateKeyEvent(GetKeyEvent));
   start2:
   if (c='Home')or(c='PgUp') then
               begin      {inizio,pagSu #72,#73}
               if offset<9 then Continue;
               offset:=0;
               goto start;
               end else
   if (c='Up') then
               begin      {su #72}
               old_off:=offset;
               if offset>8 then offset:=offset-9
                           else offset:=0;
               if offset=old_off then Continue;
               goto start;
               end else
   if (c='End')or(c='PgDn') then
               begin      {fine/pagGiu #79,#81}
               if offset>=108 then Continue;
               offset:=108;
               goto start;
               end else
   if (c='Down') then
               begin      {giu #80}
               old_off:=offset;
               offset:=offset+9;
               if offset>108 then offset:=108;
               if old_off=offset then Continue;
               goto start;
               end;
   end
  else {gestione mouse}
   begin
   cliccato:=Doppio_Click.Mouse_Down(mox,moy,stato);
   if cliccato then stato:=1
               else stato:=0;
   if (stato=1) and (mox=9) and (moy=24) then  {Su}
      begin
      c:='Up'; // #72
      delay2(5);
      goto start2;
      end else
   if (stato=1) and (mox=9) and (moy=25) then  {Giu}
      begin
      c:='Down';  // #80
      delay2(5);
      goto start2;
      end;
   {$ifdef go32v2}
   cliccato:=Doppio_Click.Mouse_Up(mox,moy,stato);
   if cliccato then stato:=1
               else stato:=0;
   {$endif}
   if (stato=1) and (mox>0) and (mox<7) and (moy=24) then  {pagSu}
      begin
      c:='PgUp';  // #71
      goto start2;
      end else
   if (stato=1) and (mox>0) and (mox<7) and (moy=25) then  {pagGiu}
      begin
      c:='PgDn';  // #79
      goto start2;
      end;
   end;
until (c=#27)or(c=#13)or(c=' ')or((mox>36)and(mox<42)and(moy=25)and(stato=1));
if ins then CursorBig else CursorOn;
ForceUpdateXY(0,0,ScreenWidth*ScreenHeight);
SetTextColorXY(0,0,7,(riga_menu-1)*ScreenWidth);
SetBackColorXY(0,0,black,(riga_menu-1)*ScreenWidth);
WindowsBackColor(max_larghezza-1,0,max_larghezza-1,(riga_menu-2),blue);
WindowsTextColor(max_larghezza-1,0,max_larghezza-1,(riga_menu-2),white);
Evidenzia_Selezione;
end;
{$endif}

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Ord32_255(var testo:string; var x:byte; o:integer; c:char);
var tab:boolean;                               // o == lunghezza_riga+1
    old_x:integer;
begin
{$ifdef TxtCrt}
cursoroff;
{$endif}
tab:=(not binario)and(c=#9);
if tab then c:=' ';
hidemouse;
old_x:=x;
if (length(testo)=x_riga)and(length(testo)<o) then  // scrivo a fine riga
   begin
   testo:=testo+c;
   Set_Cursore_X(x_riga+1);  // pare ok
   if old_x<80 then
               begin
               x:=old_x+1;
               x_reale:=x;
               end;
   end else
if (ins=false)and(length(testo)>x_riga)and(length(testo)<o) then
   begin  // scrivo dentro la riga
   Set_Cursore_X(x_riga+1);
   if old_x<80 then
               begin
               x:=old_x+1;
               x_reale:=x;
               end;
   insert(c,testo,x_riga);
   end else
if ins and(length(testo)>x_riga)and(length(testo)<=o) then
   begin
   testo[x_riga+1]:=c;
   Set_Cursore_X(x_riga+1);
   if old_x<80 then
               begin
               x:=old_x+1;
               x_reale:=x;
               end;
   end;
showmouse;
if (not tab) and (not no_update) then evidenzia_selezione;
{$ifdef TxtCrt}
if ins then CursorBig else CursorOn;
{$endif}
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function Tasto__Ctrl_Pag_Su():boolean; // ver 1.81 posizionamento sulla prima riga della schermata
var old_x,old_x_reale,old_iy,old_y,old_x_min,old_x_riga:integer;
begin
old_x:=x;
old_x_reale:=x_reale;
old_iy:=iy;
old_y:=y;
old_x_min:=x_min;
old_x_riga:=x_riga;
iy:=iy-y+1;
y:=1;
if x_riga-x+1>length(testo[iy]) then x_riga:=length(testo[iy])
                                else x_riga:=byte(max(x_riga-x+1,1));
x_min:=x_riga;
x:=1;
x_reale:=x;
result:=(old_x<>x)or(old_x_reale<>x_reale)or(old_iy<>iy)or(old_y<>y)or(old_x_min<>x_min)or(old_x_riga<>x_riga);
if (old_x_min<>x_min) then Evidenzia_Selezione
                      else gotoxy(x,y);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Init;
var i:integer;
begin
for i:=ymax+1 to min(maxr(),length(testo)-1) do testo[i]:=#13  {inizializzazione di tutto il testo restante}
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Adiacenza_Selezione;          // update 2.25
begin   {la prima volta che seleziona}
if (selezionato.x1=0) then
         begin
         Azzera_Selezione;
         Exit;
         end;
if selezione_quadrata and (testo[0]='shift_destra') then
   begin
   if (selezionato.x1=old_selezionato.x1)and(selezionato.y1=selezionato.y2)
      and(selezionato.y1=old_selezionato.y2)and(old_selezionato.y1<>old_selezionato.y2) then
         begin
         selezionato.y1:=old_selezionato.y1;
         if old_selezionato.x2<>old_selezionato.x1 then
            selezionato.x1:=selezionato.x1+1;
         selezionato.x2:=old_selezionato.x2;
         exit;
         end;
   end;
if selezione_quadrata and (testo[0]='shift_sinistra') and (old_selezionato.x1<>0) then
   begin
   if (selezionato.x1+1=old_selezionato.x1)and(selezionato.y2=old_selezionato.y2) then
      begin
      selezionato.x2:=old_selezionato.x2;
      selezionato.y1:=old_selezionato.y1;
      selezionato.y2:=old_selezionato.y2;
      exit;
      end;
   if (old_selezionato.x1=old_selezionato.x2)and(selezionato.x1=selezionato.x2)
      and(old_selezionato.x1=selezionato.x1) then
         begin
         Azzera_Selezione;
         exit;
         end;
   end;
if selezione_quadrata and (testo[0]='shift_giu') then
   begin
   if (selezionato.x2=old_selezionato.x1)and(old_selezionato.y1=old_selezionato.y2)and(old_selezionato.y1-old_selezionato.y2=0) then
      begin
      selezionato.x2:=old_selezionato.x2;
      exit;
      end;
   if (selezionato.x1=old_selezionato.x1)and(selezionato.y1=old_selezionato.y2) then
      begin
      selezionato.y1:=old_selezionato.y1;
      selezionato.x2:=old_selezionato.x2;
      exit;
      end;
   if (selezionato.x1=selezionato.x2)and(selezionato.y2=selezionato.y1+1)and
      (selezionato.x1=old_selezionato.x1) then
      begin
      if old_selezionato.y1=old_selezionato.y2 then
                                                begin
                                                selezionato:=old_selezionato;
                                                inc(selezionato.y2);
                                                end
                                               else
                                                begin
                                                selezionato:=old_selezionato;
                                                inc(selezionato.y1);
                                                end;
      exit;
      end;
   if (selezionato.x1=selezionato.x2)and(selezionato.y2=selezionato.y1+1)and
      (selezionato.x2=old_selezionato.x2) then
      begin
      if old_selezionato.y1=old_selezionato.y2 then
                                                begin
                                                selezionato:=old_selezionato;
                                                inc(selezionato.y2);
                                                end
                                               else
                                                begin
                                                if old_selezionato.y1=selezionato.y1 then
                                                   begin
                                                   selezionato:=old_selezionato;
                                                   inc(selezionato.y1);
                                                   end else
                                                if old_selezionato.y2+1=selezionato.y2 then
                                                   begin
                                                   selezionato.x1:=old_selezionato.x1;
                                                   selezionato.x2:=byte(x_riga);
                                                   selezionato.y1:=old_selezionato.y1;
                                                   selezionato.y2:=iy;
                                                   end;
                                                end;
      exit;
      end;
   end;

if selezione_quadrata and (testo[0]='shift_su') then
   begin
   if (selezionato.x1=old_selezionato.x1)and(selezionato.y1+1=selezionato.y2)and
      (selezionato.y2=old_selezionato.y1) then
      begin         // caso base del successivo
      selezionato:=old_selezionato;
      selezionato.y1:=iy;
      exit;
      end;
   if (selezionato.x1=old_selezionato.x1)and(selezionato.y1+1=selezionato.y2)
      and(selezionato.x1=selezionato.x2+1)and(selezionato.y2=old_selezionato.y2) then
         begin
         selezionato:=old_selezionato;
         selezionato.y2:=iy;
         exit;
         end;

   if (selezionato.x2+1=old_selezionato.x2)and(selezionato.y1+1=selezionato.y2)and
      (selezionato.y2=old_selezionato.y1) then
      begin         // caso base del successivo
      selezionato:=old_selezionato;
      selezionato.y1:=iy;
      exit;
      end;
   if (selezionato.x2+1=old_selezionato.x2)and(selezionato.y1+1=selezionato.y2)
      and(selezionato.x1=selezionato.x2+1)and(selezionato.y2=old_selezionato.y2) then
         begin
         selezionato:=old_selezionato;
         selezionato.y2:=iy;
         exit;
         end;
   end;
          {da riga x a x-1}
if (old_selezionato.x1=1) and (selezionato.y1=old_selezionato.y1-1)and
   {se ero all'inizio, e ora sulla riga precedente}
   (selezionato.x2=max(length(testo[selezionato.y2])-1,1)) then
       begin    // max con 1, aggiunto per shift_su tra 2 righe
       selezionato.y2:=old_selezionato.y2;
       selezionato.x2:=old_selezionato.x2;
       Exit;
       end;

if ( (old_selezionato.x2=length(testo[old_selezionato.y2])-1) or
   (old_selezionato.x2=length(testo[old_selezionato.y2])) ) and
   {se ero alla fine, e ora sulla riga successiva}
   (selezionato.y1=old_selezionato.y2+1)and(selezionato.x1=1) then
       begin
       if old_selezionato.y1=0 then inc(old_selezionato.y1); {X=1, Y=1}
       selezionato.y1:=old_selezionato.y1;
       selezionato.x1:=old_selezionato.x1;
       Exit;
       end;

if ((old_selezionato.x2=selezionato.x1-1)or(old_selezionato.x2=selezionato.x1))and
   (old_selezionato.y2=selezionato.y1) then { <old><nuova selez> }
   begin
   if (selezionato.x1=selezionato.x2)and(selezionato.y1=selezionato.y2)and
      (old_selezionato.x1=old_selezionato.x2)and(old_selezionato.y1=old_selezionato.y2)
      and(testo[0]='shift_destra')and(x_riga-1=selezionato.x1)and(x_riga-1=old_selezionato.x1) then
                          begin
                          Azzera_Selezione;
                          exit;
                          end;
   if (selezionato.x1=selezionato.x2)and(selezionato.y1=selezionato.y2)and
      (old_selezionato.x1=old_selezionato.x2)and(old_selezionato.y1=old_selezionato.y2)
      and(testo[0]='shift_sinistra')and(x=selezionato.x1)and(x_riga=old_selezionato.x1) then
                          begin
                          Azzera_Selezione;
                          exit;
                          end;
   if (testo[0]<>'ctrl_shift_fine')and(testo[0]<>'ctrl_shift_pag_giu')and(testo[0]<>'shift_inizio')and(testo[0]<>'shift_fine')and
      (testo[0]<>'shift_sinistra')and(testo[0]<>'ctrl_shift_sinistra') then
         begin
         selezionato.x1:=old_selezionato.x1;
         selezionato.y1:=old_selezionato.y1;
         Exit;
         end;
   end;
if ((selezionato.x2=old_selezionato.x1-1)or(selezionato.x2=old_selezionato.x1))
   and (old_selezionato.y1=selezionato.y2)then { <nuova selez><old> }
       if (testo[0]<>'ctrl_shift_pag_giu')and(testo[0]<>'shift_inizio')and(testo[0]<>'shift_fine')and(testo[0]<>'shift_destra')and(testo[0]<>'ctrl_shift_destra') then
                     begin
                     selezionato.x2:=old_selezionato.x2;
                     selezionato.y2:=old_selezionato.y2;
                     Exit;
                     end;
                           { <nuova selez><old> su righe diverse }
if (selezionato.y2=old_selezionato.y1-1)and( selezionato.x2=length(testo[selezionato.y2])-1 ) and
   ( old_selezionato.x1=1 ) then  // ver 1.85
    begin
    selezionato.x2:=old_selezionato.x2;
    selezionato.y2:=old_selezionato.y2;
    Exit;
    end;

if old_selezionato.x1<>0 then    // deselezione   ver 1.85
if (testo[0]='ctrl_shift_pag_su')or(testo[0]='ctrl_shift_inizio') then
   begin
   if (old_selezionato.y2=selezionato.y2)and(selezionato.x2-1=old_selezionato.x2) then
       begin
       selezionato.x2:=old_selezionato.x1-1;
       if selezionato.x2=0 then
          begin
          dec(selezionato.y2);
          selezionato.x2:=length(testo[selezionato.y2])-1;
          end;
       end else
   end else
if (testo[0]='ctrl_shift_pag_giu')or(testo[0]='ctrl_shift_fine') then
   begin
   if (selezionato.x1=old_selezionato.x1)and(selezionato.y1=old_selezionato.y1)and
      (selezionato.x2=old_selezionato.x2)and(selezionato.y2=old_selezionato.y2) then
      Azzera_Selezione else
   if (selezionato.x1=old_selezionato.x1)and(old_selezionato.y1=selezionato.y1) then
      begin
      selezionato.y1:=old_selezionato.y2;
      selezionato.x1:=old_selezionato.x2+1;
      if selezionato.x1>=length(testo[selezionato.y1]) then
         begin
         selezionato.x1:=1;
         inc(selezionato.y1);
         end;
      end;
   if (selezionato.y2=selezionato.y1)and(selezionato.x2<selezionato.x1) then Azzera_Selezione;
   end else
if testo[0]='shift_inizio' then
   begin
   if (old_selezionato.y1<>old_selezionato.y2)and(selezionato.x2=old_selezionato.x2)
      and(old_selezionato.y2=iy) then
         begin
         dec(selezionato.y2);
         selezionato.x2:=length(testo[selezionato.y2])-1;
         selezionato.x1:=old_selezionato.x1;
         selezionato.y1:=old_selezionato.y1;
         end else
   if (selezionato.x2+1=old_selezionato.x1)and(selezionato.y2=old_selezionato.y1) then
      begin            // update ver 1.90
      selezionato.x2:=old_selezionato.x2;
      selezionato.y2:=old_selezionato.y2;
      selezionato.x1:=1;
      end else
   if (old_selezionato.y1=old_selezionato.y2)and(old_selezionato.y1=iy)and
      (selezionato.x2=old_selezionato.x2) then
      selezionato.x2:=old_selezionato.x1-1;
   if (selezionato.y2=selezionato.y1)and(selezionato.x2<selezionato.x1) then Azzera_Selezione;
   end else
if testo[0]='shift_fine' then
   begin
   if (old_selezionato.x2+1=selezionato.x1)and(selezionato.y1=old_selezionato.y2) then
      begin            // update ver 1.90
      selezionato.x1:=old_selezionato.x1;
      selezionato.y1:=old_selezionato.y1;
      selezionato.x2:=length(testo[iy])-1;
      end else
   if (old_selezionato.y1=old_selezionato.y2)and(selezionato.x1=old_selezionato.x1)
      and(old_selezionato.y1=iy) then
         selezionato.x1:=old_selezionato.x2+1
         else
   if (old_selezionato.y1<>old_selezionato.y2)and(old_selezionato.y1=iy)and
      (selezionato.x1=old_selezionato.x1) then
      begin
      inc(selezionato.y1);
      selezionato.x1:=1;
      selezionato.x2:=old_selezionato.x2;
      selezionato.y2:=old_selezionato.y2;
      end;
   if (selezionato.y2=selezionato.y1)and(selezionato.x2<selezionato.x1) then Azzera_Selezione;
   end else
if testo[0]='ctrl_shift_sinistra' then
   begin
   if (selezionato.x1<old_selezionato.x1)and(selezionato.x2=old_selezionato.x2)
      and(old_selezionato.y1=selezionato.y1)and(old_selezionato.y2=selezionato.y2) then
         begin
         selezionato.x1:=byte(x_riga);
         selezionato.x2:=old_selezionato.x1-1;
         end else
   if (selezionato.x2=old_selezionato.x2)and(old_selezionato.y2=selezionato.y2) then
       begin
       selezionato.x1:=old_selezionato.x1;
       selezionato.y1:=old_selezionato.y1;
       selezionato.y2:=iy;
       selezionato.x2:=x_riga-1;
       if length(testo[iy])=1 then selezionato.x2:=1; // update ver 1.90
       if selezionato.x2=0 then
           begin
           dec(selezionato.y2);
           selezionato.x2:=length(testo[selezionato.y2])-1;
           Set_Cursore_X(selezionato.x2+1); // simula Tasto__Sinistra (successive 3 righe)  update ver 1.90
           iy:=selezionato.y2;
           y:=byte(max(1,y-1));
           end;
       if (selezionato.y2=selezionato.y1)and(selezionato.x2<selezionato.x1) then Azzera_Selezione;
       end
   end else
if testo[0]='ctrl_shift_destra' then
   begin
   if (selezionato.x2>old_selezionato.x2)and(selezionato.x1=old_selezionato.x1)
      and(old_selezionato.y1=selezionato.y1)and(old_selezionato.y2=selezionato.y2) then
         begin
         selezionato.x1:=old_selezionato.x2+1;
         selezionato.x2:=x_riga-1;
         if (selezionato.y2=selezionato.y1)and(selezionato.x2<selezionato.x1) then Azzera_Selezione;
         end else
   if (selezionato.x1=old_selezionato.x1)and(old_selezionato.y1=selezionato.y1) then
       begin
       selezionato.x1:=byte(x_riga);
       selezionato.y1:=old_selezionato.y1;
       selezionato.y2:=old_selezionato.y2;
       selezionato.x2:=old_selezionato.x2;
       if selezionato.x1>=length(testo[selezionato.y1]) then
            begin
            inc(selezionato.y1);
            selezionato.x1:=1;
            Set_Cursore_X(1);  // simula destraX (successive 3 righe)  update ver 1.90
            inc(iy);
            y:=byte(min(riga_menu-1,y+1));
            if (selezionato.y2=selezionato.y1)and(selezionato.x2<selezionato.x1) then Azzera_Selezione;
            end;
       end
   end else
if testo[0]='shift_sinistra' then
   begin
   if (selezionato.x2=old_selezionato.x2)and(selezionato.x1=old_selezionato.x2)
      and(selezionato.y2=old_selezionato.y2) then
          begin
          selezionato:=old_selezionato;
          dec(selezionato.x2);
          if selezionato.x2=0 then
             begin
             dec(selezionato.y2);
             selezionato.x2:=byte(max(length(testo[selezionato.y2])-1,1)); // update ver 1.90
             if (selezionato.y2=selezionato.y1)and(selezionato.x2<selezionato.x1) then Azzera_Selezione;
             end;
          end;
   end else
if testo[0]='shift_destra' then
   begin
   if (selezionato.x1=selezionato.x2)and(selezionato.y1=selezionato.y2)and
      (old_selezionato.x1=1)and(old_selezionato.y1=selezionato.y1+1) then
      {selezionato:=old_selezionato}  // WAS (rimosso in ver 3.23) update ver 1.90
      else
   if (selezionato.x1=old_selezionato.x1)and(old_selezionato.y1=selezionato.y1) then
       begin
       inc(selezionato.x1);
       selezionato.y1:=old_selezionato.y1;
       selezionato.y2:=old_selezionato.y2;
       selezionato.x2:=old_selezionato.x2;
       if selezionato.x1>=length(testo[selezionato.y1]) then
            begin
            inc(selezionato.y1);
            selezionato.x1:=1;
            if (selezionato.y2=selezionato.y1)and(selezionato.x2<selezionato.x1) then Azzera_Selezione;
            end;
       end
   end else
if testo[0]='shift_giu' then
    begin
    if (old_selezionato.y1+1=old_selezionato.y2)and(old_selezionato.x1-1=old_selezionato.x2)
       and(selezionato.y1+1=selezionato.y2)and(selezionato.x1-1=selezionato.x2) then Azzera_Selezione else
    if (selezionato.y1+1=selezionato.y2)and(selezionato.x2=1)and(selezionato.x1=1) then
        begin
        selezionato.y2:=old_selezionato.y2;
        selezionato.x2:=old_selezionato.x2;
        inc(selezionato.y1);
        selezionato.x1:=1;
        end else
    if (old_selezionato.y2=old_selezionato.y1+1)and(selezionato.x1=old_selezionato.x1) then
         begin
         if old_selezionato.x2<old_selezionato.x1 then
                begin
                selezionato.x1:=old_selezionato.x2+1;
                selezionato.x2:=x_riga-1;
                end
               else
                begin
                selezionato.x1:=byte(x_riga);
                selezionato.x2:=old_selezionato.x2;
                end;
         selezionato.y1:=iy;
         selezionato.y2:=iy;
         end
        else
    if (selezionato.y2-1=old_selezionato.y2)and(selezionato.y1=old_selezionato.y1)and(selezionato.x1=old_selezionato.x1) then
       begin                // vado verso sotto
       selezionato.x1:=old_selezionato.x2+1;
       if selezionato.x1>=length(testo[selezionato.y1])-1 then
          begin
          inc(selezionato.y1);
          selezionato.x1:=1;
          end;
       selezionato.x2:=x_riga-1; // non puo' essere 0, per i casi successivi
       selezionato.y2:=iy;
       end else
    if (selezionato.y1=old_selezionato.y1)and(selezionato.x1=1)and(selezionato.y2=old_selezionato.y2)and(selezionato.x1=old_selezionato.x1) then
       begin                // vado verso sotto
       selezionato.x1:=old_selezionato.x2+1;
       selezionato.x2:=length(testo[iy-1])-1;
       if (selezionato.y2<selezionato.y1)and(selezionato.x2=length(testo[selezionato.y2])-1)and(selezionato.x1=1) then Azzera_Selezione;
       if (selezionato.y2=selezionato.y1)and(selezionato.x2<selezionato.x1) then Azzera_Selezione;
       end else
    if (selezionato.y1=old_selezionato.y1)and(selezionato.x1=old_selezionato.x1) then
       begin                // vado verso sotto
       selezionato.x1:=selezionato.x2+1;
       selezionato.y1:=selezionato.y2;
       if selezionato.x2>=length(testo[selezionato.y2])-1 then
          begin
          inc(selezionato.y1);
          selezionato.x1:=1;
          end;
       selezionato.x2:=old_selezionato.x2;
       selezionato.y2:=old_selezionato.y2;
       if (selezionato.y1=selezionato.y2)and(selezionato.x1>selezionato.x2) then
          begin
          selezionato.x1:=selezionato.x2+1;
          selezionato.x2:=x_riga-1;
          end;
       if (selezionato.y2<selezionato.y1)and(selezionato.x2=length(testo[selezionato.y2])-1)and(selezionato.x1=1) then Azzera_Selezione;
       if (selezionato.y2=selezionato.y1)and(selezionato.x2<selezionato.x1) then Azzera_Selezione;
       end;
    end else
if testo[0]='shift_su' then
    begin
    if (selezionato.y1=selezionato.y2)and(selezionato.x1=1)and
       ((selezionato.x2=1)or(selezionato.x2=length(testo[iy])-1)) and
       (old_selezionato.y2=selezionato.y2+1) then
        begin
        selezionato.y1:=old_selezionato.y1;
        selezionato.x1:=old_selezionato.x1;
        dec(selezionato.y2);
        selezionato.x2:=byte(max(length(testo[selezionato.y2])-1,1));
        end else
    if (selezionato.y1+1=old_selezionato.y1)and(selezionato.y2=old_selezionato.y2)and(selezionato.x2=old_selezionato.x2) then
       begin                // vado verso sotto
       selezionato.x1:=byte(x_riga);
       if selezionato.x1>=length(testo[selezionato.y1])-1 then
          begin
          dec(selezionato.y1);
          selezionato.x1:=1;
          end;
       selezionato.x2:=old_selezionato.x1-1;
       if selezionato.x2=0 then
          begin
          dec(selezionato.y2);
          selezionato.x2:=length(testo[selezionato.y2]);
          end;
       if (selezionato.y2<selezionato.y1)and(selezionato.x2=length(testo[selezionato.y2])-1)and(selezionato.x1=1) then Azzera_Selezione;
       if (selezionato.y2=selezionato.y1)and(selezionato.x2<selezionato.x1) then Azzera_Selezione;
       end else
    if (old_selezionato.y2=old_selezionato.y1)and(selezionato.x1=old_selezionato.x1) then
         begin
         selezionato.x2:=old_selezionato.x1-1;
         if selezionato.x2=0 then
                begin
                dec(selezionato.y2);
                selezionato.x2:=length(testo[selezionato.y2])-1;
                if selezionato.y1>selezionato.y2 then Azzera_Selezione;
                end;
         end else
    if (old_selezionato.y1<>old_selezionato.y2)and(selezionato.y2=old_selezionato.y2)and(selezionato.x2=old_selezionato.x2) then
       begin                // vado verso sopra
       selezionato.x2:=selezionato.x1-1;
       selezionato.y2:=selezionato.y1;
       if selezionato.x2=0 then
          begin
          dec(selezionato.y2);
          selezionato.x2:=byte(max(length(testo[selezionato.y2])-1,1));
          end;
       selezionato.x1:=old_selezionato.x1;
       selezionato.y1:=old_selezionato.y1;
       if (selezionato.y1=selezionato.y2)and(selezionato.x1>selezionato.x2) then
          begin
          selezionato.x2:=selezionato.x1-1;
          selezionato.x1:=byte(x_riga);
          end;
       if (selezionato.y2<selezionato.y1)and(selezionato.x2=length(testo[selezionato.y2])-1)and(selezionato.x1=1) then Azzera_Selezione;
       if (selezionato.y2=selezionato.y1)and(selezionato.x2<selezionato.x1) then Azzera_Selezione;
       end;
    end;
testo[0]:='';
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Info;      {1.1}        {informazioni sul testo, in basso}
begin
Info(false);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

{$ifdef TxtCrt}
procedure Info(ricerca:boolean);      {informazioni sul testo, in basso}
var c:char;
    str:string;
begin
cursoroff;
colore;
if binario then
     begin
     if x_riga<length(testo[iy]) then
          begin
          c:=testo[iy][x_riga+1];
          str:=HexStr(ord(c),2)+'h'+c_D2;
          if ord(c)<10 then str:=str+'00'+inttostr(ord(c))+'d';
          if (ord(c)<100) and (ord(c)>9) then str:=str+'0'+inttostr(ord(c))+'d';
          if (ord(c)>=100) then str:=str+inttostr(ord(c))+'d';
          end
         else str:=c_D2+c_D2+c_D2+c_D2+c_D2+c_D2+c_D2+c_D2;
     gotoxy(73,riga_menu);
     write(str);
     end;
gotoxy(1,riga_menu);
write(c_D2+c_D2+c_D2+c_D2+c_D2+c_D2+c_D2+c_D2);
gotoxy(1,riga_menu);
write(inttostr(foglio(ymax))+':'+inttostr(ymax));
modif;
stato_appunti.Refresh_Stato_Appunti; // ver 2.53
if ricerca then gotoxy(1,riga_menu+1)
           else gotoxy(1,riga_menu+4);
textcolor(yellow);
write(Lingue.get_txt(92));    // 'Pag.'
textcolor(white);
write(foglio(iy),' ');
textcolor(yellow);
write(Lingue.get_txt(93));    // 'Col.'
textcolor(white);
write(x_riga,' ');
textcolor(yellow);
write(Lingue.get_txt(94));    // 'Riga '
textcolor(white);
write(iy);
while (not (ord(Char_Video) in [ord('I'),ord('[')]))and (wherex<70) do write(' ');
if binario then
   begin
   str:='['+Dim_Punto(num_byte()+tot)+']'; {*** calcola la posizione del byte}
   while length(str)<14 do str:=' '+str+' ';
   gotoxy(33,riga_menu+4); {lo stampa centrato}
   write(str);
   end;
gotoxy(x,y);
normale;
if ins then CursorBig else CursorOn;
stato_appunti.Refresh_Stato_Appunti; // ver 2.53
hideMouse;
ShowMouse;
end;
{$endif}

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

{$ifdef TxtVideo}
procedure Info(ricerca:boolean);     {informazioni sul testo, in basso}
var c:char;                          // update 1.84  2.00
    str:shortstring;
    str1:string;
    pos_:byte;
begin
settextcolorXY(0,riga_menu-1,white,ScreenWidth);
settextcolorXY(0,riga_menu+1,white,ScreenWidth*3);
setbackcolorXY(0,riga_menu-1,blue,ScreenWidth*3);
if sono_Appunti() then str:=' '+nomefile+' '
   else
    begin
    str:=percorso+nomefile;   // come in grafica
    GetLongName(str);
    str:=' '+nomeLungo(TruncPath(str,60),60)+' ';
    end;
while length(str)<max_larghezza do str:=c_D2+str+c_D2;
setlength(str,max_larghezza);
outtextxy(0,riga_menu-1,str);

if binario then
     begin
     if x_riga<length(testo[iy]) then
          begin
          c:=testo[iy][x_riga+1];
          str:=HexStr(ord(c),2)+'h'+c_D2;
          if ord(c)<10 then str:=str+'00'+inttostr(ord(c))+'d';
          if (ord(c)<100) and (ord(c)>9) then str:=str+'0'+inttostr(ord(c))+'d';
          if (ord(c)>=100) then str:=str+inttostr(ord(c))+'d';
          end
         else
          str:=c_D2+c_D2+c_D2+c_D2+c_D2+c_D2+c_D2+c_D2;
     ForceUpdatexy(72,riga_menu-1,length(str));
     outtextxy(72,riga_menu-1,str);
     end;
outtextXY(0,riga_menu-1,c_D2+c_D2+c_D2+c_D2+c_D2+c_D2+c_D2+c_D2);
outtextxy(0,riga_menu-1,inttostr(foglio(ymax))+':'+inttostr(ymax));
str:=Lingue.get_txt(92)+inttostr(foglio(iy))+'  '+Lingue.get_txt(93)+inttostr(x_riga)+'  '+Lingue.get_txt(94)+inttostr(iy);
while length(str)<max_larghezza do str:=str+' ';

if binario then
   begin
   str1:='['+Dim_Punto(num_byte()+tot)+']'; {*** calcola la posizione del byte}
   while length(str1)<14 do str1:=' '+str1+' ';
   insert(str1,str,33); {centrato}
   end;
if modifica then str[max_larghezza-1]:=pallino_modifica;
str[max_larghezza-2]:=stato_appunti.Get_indicatore;
setlength(str,max_larghezza);
outtextxy(0,riga_menu+3,str);
ForceUpdateXY(0,riga_menu+3,ScreenWidth);
if ins then CursorBig else CursorOn;

pos_:=13+lingue.get_length_txt(159)+lingue.get_length_txt(160)+lingue.get_length_txt(161)+lingue.get_pos_rosso(162);
if (GetTextColorXY(2,riga_menu)=lightred) and (GetCharXY(2,riga_menu)='F') and
   (GetTextColorXY(3,riga_menu)=yellow) and (GetCharXY(pos_,riga_menu)=lingue.get_char(162){'S'}) then
                                                            else ListaX.mostra;
updatescreen(false);
stato_appunti.Refresh_Stato_Appunti; // ver 2.53
setcursorpos(x-1,y-1);
end;
{$endif}

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

{$ifdef TxtCrt}
procedure Evidenzia_Selezione_non_quadrata;
var start_iy,end_iy:integer;
    i,ii:byte;
    app:string;
begin
if (selezionato.y1<>0) and (selezionato.x1=0) then inc(selezionato.x1);
if adiacente then Adiacenza_Selezione;
scambio;
adiacente:=false;
if iy<y then y:=byte(iy);  // update ver 1.80
start_iy:=iy-y+1;
end_iy:=start_iy+(riga_menu-2);
if end_iy>ymax then end_iy:=ymax;
if selezionato.x1=0 then Azzera_Selezione;
cursoroff;
HideMouse;
for i:=1 to riga_menu-1 do
    begin
    gotoxy(1,i);
    if (start_iy-1+i=selezionato.y1)and(selezionato.y1<>selezionato.y2) then
       begin        {la parte iniziale: destra selezionata}
       textbackground(black);
       textcolor(7);
       write(copy(fix(testo[start_iy-1+i]),1,selezionato.x1-x_min));
       textbackground(7);
       textcolor(black);
       write(copy(fix_(testo[start_iy-1+i]),selezionato.x1-x_min+1,length(testo[start_iy-1+i])-(selezionato.x1-x_min+1) ));
       end;
    if (start_iy-1+i=selezionato.y2)and(selezionato.y1<>selezionato.y2) then
       begin        {la parte finale: sinistra selezionata}
       textbackground(7);
       textcolor(black);
       if length(testo[selezionato.y2])>1 then
          write(copy(fix_(testo[selezionato.y2]),1,selezionato.x2-x_min+1));
       textbackground(black);
       textcolor(7);
       write(copy_end(fix(testo[selezionato.y2]),selezionato.x2+2-x_min));
       end;
    if (start_iy-1+i<selezionato.y1) or (start_iy-1+i>selezionato.y2)
       or (selezionato.y1=0) or (i>ymax) then
          begin                 {tutta la riga normale}
          textbackground(black);
          textcolor(7);
          if start_iy-1+i<=ymax then write(fix(testo[start_iy-1+i]));
          end;
    if (start_iy-1+i>selezionato.y1) and (start_iy-1+i<selezionato.y2)
       and (selezionato.y1<>0) then
          begin                {tutta la riga selezionata}
          textbackground(7);
          textcolor(black);
          write(copy(fix(testo[start_iy-1+i]),1,length(testo[start_iy-1+i])-x_min));
          end;
    if (start_iy-1+i=selezionato.y1) and (selezionato.y1=selezionato.y2)
       and (selezionato.y1<>0) then
          begin                {centro della riga selezionata}
          textbackground(black);
          textcolor(7);
          write(copy(fix(testo[selezionato.y2]),1,selezionato.x1-x_min));
          textbackground(7);
          textcolor(black);
          write(copy(fix_(testo[selezionato.y2]),selezionato.x1-x_min+1,selezionato.x2-selezionato.x1+1-max(x_min-selezionato.x1,0)));
          textbackground(black);
          textcolor(7);
          write(copy_end(fix(testo[selezionato.y2]),selezionato.x2-x_min+2));
          end;
    app:='';
    for ii:=whereX to 79 do app:=app+' ';
    if app<>'' then
       begin
       textbackground(black);
       textcolor(7);
       write(app);
       end;
    end;    {for}
ShowMouse;
Barra_Verticale;
Info(false);
normale;
if ins then CursorBig else CursorOn;
hidemouse;
ShowMouse;
end;
{$endif}

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

{$ifdef TxtCrt}
procedure Evidenzia_Selezione_quadrata; // ver 2.25
var start_iy,end_iy:integer;
    i,ii:byte;
    app:string;
begin
if (selezionato.y1<>0) and (selezionato.x1=0) then inc(selezionato.x1);
if adiacente then Adiacenza_Selezione;
scambio;
adiacente:=false;
if iy<y then y:=byte(iy);  // update ver 1.80
start_iy:=iy-y+1;
end_iy:=start_iy+(riga_menu-2);
if end_iy>ymax then end_iy:=ymax;
if selezionato.x1=0 then Azzera_Selezione;
cursoroff;
HideMouse;
for i:=1 to riga_menu-1 do
       begin
       gotoxy(1,i);
       if (start_iy-1+i<selezionato.y1)or(start_iy-1+i>selezionato.y2)
          or (selezionato.x1=0) then
              begin                 {tutta la riga normale}
              textbackground(black);
              textcolor(7);
              if start_iy-1+i<=ymax then write(fix(testo[start_iy-1+i]));
              end;
       if (start_iy-1+i>=selezionato.y1)and(start_iy-1+i<=selezionato.y2)
          and(selezionato.y1<>0) then
             begin                {riga selezionata nella parte centrale}
             textbackground(black);
             textcolor(7);
             write(copy(fix(testo[start_iy-1+i]),1,byte(min(selezionato.x1,selezionato.x2))-x_min));
             textbackground(7);
             textcolor(black);
             write(copy(fix_(testo[start_iy-1+i]),selezionato.x1-x_min+1,selezionato.x2-selezionato.x1+1-max(x_min-selezionato.x1,0)));
             textbackground(black);
             textcolor(7);
             write(copy_end(fix(testo[start_iy-1+i]),selezionato.x2-x_min+2));
             end;
       app:='';
       for ii:=whereX to 79 do app:=app+' ';
       if app<>'' then write(app);
       end;    {for}
ShowMouse;
Barra_Verticale;
Info(false);
normale;
if ins then CursorBig else CursorOn;
hidemouse;
ShowMouse;
end;
{$endif}

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

{$ifdef TxtCrt}
procedure Evidenzia_Selezione;   // update 2.25
var scambio_:byte;
begin
if no_update then exit; // ver 3.14
if selezione_quadrata then
                       begin
                       Evidenzia_Selezione_quadrata;
                       if selezionato.x1>selezionato.x2 then
                          if stato=1 then
                              begin
                              scambio_:=selezionato.x1;
                              selezionato.x1:=selezionato.x2;
                              selezionato.x2:=scambio_;
                              Evidenzia_Selezione_quadrata;
                              scambio_:=selezionato.x1;
                              selezionato.x1:=selezionato.x2;
                              selezionato.x2:=scambio_;
                              end
                             else  // stato=0, c'e' una piccola differenza nella selezione del testo a causa di shift_su
                              begin
                              scambio_:=selezionato.x1;
                              selezionato.x1:=selezionato.x2+1;
                              selezionato.x2:=scambio_;
                              Evidenzia_Selezione_quadrata;
                              scambio_:=selezionato.x1-1;
                              selezionato.x1:=selezionato.x2;
                              selezionato.x2:=scambio_;
                              end;
                       end
                      else Evidenzia_Selezione_non_quadrata;
end;
{$endif}

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

{$ifdef TxtVideo}
procedure Evidenzia_Selezione_non_quadrata;  // update 2.00 , 2.10 , 2.62
var start_iy,end_iy:integer;
    i:byte;
    t:shortstring;
const vuoto79='                                                                               ';
begin
HideMouse;
if (selezionato.y1<>0) and (selezionato.x1=0) then inc(selezionato.x1);
if adiacente then Adiacenza_Selezione;
scambio;
adiacente:=false;
if iy<y then y:=byte(iy);  // update ver 1.80
start_iy:=iy-y+1;
end_iy:=start_iy+(riga_menu-2);
if end_iy>ymax then end_iy:=ymax;
if selezionato.x1=0 then Azzera_Selezione;
for i:=1 to riga_menu-1 do
    begin
    if no_update then exit;
    OutTextXY(0,i-1,vuoto79,0,black,7); // inizialmente tutto testo grigio su sfondo nero
    if start_iy-1+i>ymax then Continue;
    t:=testo[start_iy-1+i];
    if (start_iy-1+i=selezionato.y1)and(selezionato.y1<>selezionato.y2) then
             begin        {la parte iniziale: destra selezionata}
             OutTextXY(0,i-1,copy(fix(t),1,selezionato.x1-x_min),0,black,7);
             outTextXY(byte(max(selezionato.x1-x_min,0)),i-1,copy_end(fix_(t),selezionato.x1-x_min+1),0,7,black);
             end else
    if (start_iy-1+i=selezionato.y2)and(selezionato.y1<>selezionato.y2) then
             begin        {la parte finale: sinistra selezionata}
             OutTextXY(0,i-1,copy(fix(t),1,min(selezionato.x2-x_min+1,length(t)-1)),0,7,black);
             outTextXY(byte(max(selezionato.x2-x_min+1,0)),i-1,copy(fix(t),selezionato.x2-x_min+2,79),0,black,7);
             end else
    if (start_iy-1+i<selezionato.y1)or(start_iy-1+i>selezionato.y2)or(selezionato.y1=0) then
       outTextXY(0,i-1,fix(t),0,black,7) else {tutta la riga normale}
    if (start_iy-1+i>selezionato.y1)and(start_iy-1+i<selezionato.y2)and(selezionato.y1<>0) then
             begin                {tutta la riga selezionata}
             outTextXY(0,i-1,fix(t),0,black,7);
             outTextXY(0,i-1,fix_(t),0,7,black);
             end else
    if (start_iy-1+i=selezionato.y1)and(selezionato.y1=selezionato.y2)and(selezionato.y1<>0)then
             begin                {centro della riga selezionata}
             OutTextXY(0,i-1,fix(copy(t,1,selezionato.x1)),0,black,7);
             OutTextXY(byte(max(selezionato.x1-x_min,0)),i-1,copy(fix_(t),selezionato.x1-x_min+1,selezionato.x2+1-selezionato.x1),0,7,black);
             OutTextXY(byte(max(selezionato.x2-x_min+1,0)),i-1,copy(fix(t),selezionato.x2-x_min+2,79),0,black,7);
             end;
    end;
Info(false);
Barra_Verticale;
ShowMouse;
normale;
if ins then CursorBig else CursorOn;
hidemouse;
ShowMouse;
_start:=-1;
_end:=maxr+1;
end;
{$endif}

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

{$ifdef TxtVideo}
procedure Evidenzia_Selezione_quadrata;  // update 2.25
var start_iy,end_iy,lunghezza_selezione:integer;
    i:byte;
const vuoto79='                                                                               ';
begin
HideMouse;
if (selezionato.y1<>0) and (selezionato.x1=0) then inc(selezionato.x1);
if adiacente then Adiacenza_Selezione;
scambio;
adiacente:=false;
if iy<y then y:=byte(iy);  // update ver 1.80
start_iy:=iy-y+1;
end_iy:=start_iy+(riga_menu-2);
if end_iy>ymax then end_iy:=ymax;
if selezionato.x1=0 then Azzera_Selezione;

for i:=1 to riga_menu-1 do
    begin            {tutta la riga normale}
    OutTextXY(0,i-1,vuoto79,0,black,7); // inizialmente tutto testo grigio su sfondo nero
    if start_iy-1+i>ymax then Continue;
    OutTextXY(0,i-1,fix(testo[start_iy-1+i]),0,black,7);
    if (start_iy-1+i>=selezionato.y1)and(start_iy-1+i<=selezionato.y2)and(length(testo[start_iy-1+i])>1) then
       begin                // centro della riga selezionata
       lunghezza_selezione:=byte(max(min(max(selezionato.x1,selezionato.x2),length(testo[start_iy-1+i])-1)-min(selezionato.x1,selezionato.x2)+1  - max(x_min-byte(min(selezionato.x1,selezionato.x2)),0),0));
       SetTextColorXY(byte(max(min(selezionato.x1-1,selezionato.x2)-x_min+1,0)),i-1,black,byte(lunghezza_selezione));
       SetBackColorXY(byte(max(min(selezionato.x1-1,selezionato.x2)-x_min+1,0)),i-1,    7,byte(lunghezza_selezione));
       end;
    end;
Info(false);
Barra_Verticale;
ShowMouse;
normale;
if ins then CursorBig else CursorOn;
hidemouse;
ShowMouse;
_start:=-1;
_end:=maxr+1;
end;
{$endif}

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

{$ifdef TxtVideo}
procedure Evidenzia_Selezione; // ver 2.25
var scambio:byte;
begin
if no_update then exit; // ver 3.14
if selezione_quadrata then
                       begin
                       Evidenzia_Selezione_quadrata;
                       if selezionato.x1>selezionato.x2 then
                              begin
                              scambio:=selezionato.x1;
                              selezionato.x1:=selezionato.x2+1;
                              selezionato.x2:=scambio;
                              Evidenzia_Selezione_quadrata;
                              scambio:=selezionato.x1-1;
                              selezionato.x1:=selezionato.x2;
                              selezionato.x2:=scambio;
                              end;
                       end
                      else Evidenzia_Selezione_non_quadrata;
end;
{$endif}

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Select(k:char;x1,y1:byte);
begin
{$ifdef TxtCrt}
colore;
HideMouse;
case K of
 'n' : begin
       gotoxy(x1+11,y1);
       write(' ');
       gotoxy(x1+17,y1);
       write(' ');
       gotoxy(x1-1,y1);
       write(' ');
       gotoxy(x1+4,y1);
       write(' ');
       gotoxy(x1+5,y1);
       write('[');
       gotoxy(x1+10,y1);
       write(']');
       gotoxy(x,y);
       end;
 's' : begin
       gotoxy(x1+11,y1);
       write(' ');
       gotoxy(x1+17,y1);
       write(' ');
       gotoxy(x1-1,y1);
       write('[');
       gotoxy(x1+4,y1);
       write(']');
       gotoxy(x1+5,y1);
       write(' ');
       gotoxy(x1+10,y1);
       write(' ');
       gotoxy(x,y);
       end;
 'a' : begin
       gotoxy(x1+11,y1);
       write('[');
       gotoxy(x1+17,y1);
       write(']');
       gotoxy(x1-1,y1);
       write(' ');
       gotoxy(x1+4,y1);
       write(' ');
       gotoxy(x1+5,y1);
       write(' ');
       gotoxy(x1+10,y1);
       write(' ');
       gotoxy(x,y);
       end;
end; {case}
ShowMouse;
{$endif}
{$ifdef TxtVideo}
dec(x1);
dec(y1);
case K of
 'n' : begin
       outtextxy(x1+11,y1,' ',255,blue,white);
       outtextxy(x1+17,y1,' ',255,blue,white);
       outtextxy(x1-1,y1,' ',255,blue,white);
       outtextxy(x1+4,y1,' ',255,blue,white);
       outtextxy(x1+5,y1,'[',255,blue,white);
       outtextxy(x1+10,y1,']',255,blue,white);
       gotoxy(x,y);
       end;
 's' : begin
       outtextxy(x1+11,y1,' ',255,blue,white);
       outtextxy(x1+17,y1,' ',255,blue,white);
       outtextxy(x1-1,y1,'[',255,blue,white);
       outtextxy(x1+4,y1,']',255,blue,white);
       outtextxy(x1+5,y1,' ',255,blue,white);
       outtextxy(x1+10,y1,' ',255,blue,white);
       gotoxy(x,y);
       end;
 'a' : begin
       outtextxy(x1+11,y1,'[',255,blue,white);
       outtextxy(x1+17,y1,']',255,blue,white);
       outtextxy(x1-1,y1,' ',255,blue,white);
       outtextxy(x1+4,y1,' ',255,blue,white);
       outtextxy(x1+5,y1,' ',255,blue,white);
       outtextxy(x1+10,y1,' ',255,blue,white);
       gotoxy(x,y);
       end;
end; {case}
updatescreen(false);
{$endif}
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function Tasti_SNA(x1,y1:byte):char; // update 1.84, 3.30
var old_c,c,messaggio:string;
    cliccato:boolean;
    tasto_affermativo:char;
label tab;
begin
HideMouse;
if testo[0]='??' then messaggio:='<Ok>  <'+Lingue.get_txt(96)+'>  <esc>' // setup del programma
                 else messaggio:='<'+Lingue.get_txt(95)+'>  <'+Lingue.get_txt(96)+'>  <esc>';
if testo[0]='??' then tasto_affermativo:='O' // Ok
                 else tasto_affermativo:=Lingue.get_charUp(95);
{$ifdef TxtCrt}
textcolor(red);
textbackground(7);
gotoxy(x1,y1);
write(messaggio);   // '<Ok>  <No>  <esc>'
{$endif}
{$ifdef TxtVideo}
outtextxy(x1-1,y1-1,messaggio,255,7,red);
{$endif}
colore;
gotoxy(x1+4,y1);
write('  ');
gotoxy(x1+10,y1);          {il mouse puo' cliccare su SI,NO,ESC=annulla}
write('  ');               {oppure premendo i tasti S,N,Esc}
Select('a',x1,y1);
sonoro;
ShowMouse;
tast_vuota;
c:='a';  {Annulla e' predefinito}
ShowMouse;
ShowMouse;
repeat
 if (PollKeyEvent<>0) or (not topo) then
        begin
        old_c:=c;
        c:=KeyEventToString(TranslateKeyEvent(GetKeyEvent));
        if from_alt_to_char(c)<>#0 then c:=from_alt_to_char(c);
        if (pos('SHIFT ',c)<>0)and(length(c)=7) then c:=upcase(c[7]);
        if length(c)=1 then c:=upcase(c);
        if from_alt_to_char(c)=tasto_affermativo     {'S'} then c:='S' {ALT+S}
                                   else
        if from_alt_to_char(c)=Lingue.get_charUp(96) {'N'} then c:='N' {ALT+N}
                                   else
        if (c='Right')or(c='Down') then goto tab  // #77,#80
                                   else
        if (c='Left')or(c='Up')or(c='SHIFT Key with scancode 3840') then // shift+tab
                         begin // #72,#75
                         if (old_c='s') then old_c:='n'
                                        else
                         if (old_c='n') then old_c:='a'
                                        else
                         if (old_c='a') then old_c:='s';
                         goto tab;
                         end else
        if (c=#27) then c:='A'
                   else
        if (c=#13)or(c=#32) then c:=upcase(old_c)
                            else
        if c=tasto_affermativo     then c:='S' else
        if c=Lingue.get_charUp(96) then c:='N' else
        if (c=#9) then
                  begin
                  tab:
                  if (old_c='s') then c:='n'
                                 else
                  if (old_c='n') then c:='a'
                                 else
                  if (old_c='a') then c:='s';
                  Select(c[1],x1,y1);
                  end
                 else
                  c:=old_c;
        end
       else   // il mouse
        begin
        {$ifdef go32v2}
         cliccato:=Doppio_Click.Mouse_Up(mox,moy,stato);
        {$else}
         cliccato:=Doppio_Click.Mouse_Down(mox,moy,stato);
        {$endif}
        if cliccato then stato:=1
                    else stato:=0;
        if (stato=1) and (moy=y1) then
            begin
            if (mox>x1-1)  and (mox<4+x1)  then c:='S';
            if (mox>5+x1)  and (mox<10+x1) then c:='N';
            if (mox>11+x1) and (mox<17+x1) then c:='A';
            end;
        sleep(5);
        end;
until (c='S')or(c='N')or(c='A');
Tasti_SNA:=c[1];
{$ifdef TxtCrt}
textcolor(white);
textbackground(blue);
gotoxy(1,y1);
clreol;           // copre la risposta SNA   update 2.52
{$endif}
{$ifdef TxtVideo}
TxtVideo.TxtBackground(blue);
TxtVideo.TxtColor(white);
setcursorpos(0,y1-1);
TxtClreol;        // copre la risposta SNA   update 2.52
{$endif}
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function Tasti_SN(x1,y1:byte):char;  // update 1.84
var old_c,c:string;
    cliccato:boolean;
label tab;
begin
{$ifdef TxtCrt}
HideMouse;
textcolor(red);
textbackground(7);
gotoxy(x1,y1);
write('<'+Lingue.get_txt(95)+'>  <'+Lingue.get_txt(96)+'>');
{$endif}
{$ifdef TxtVideo}
outtextxy(x1-1,y1-1,'<'+Lingue.get_txt(95)+'>  <'+Lingue.get_txt(96)+'>',255,7,red);
outtextxy(x1+10,y1-1,'              ',255,blue,red);
{$endif}
colore;
gotoxy(x1+4,y1);
write('  ');
gotoxy(x1+10,y1);          {il mouse puo' cliccare su SI,NO}
write('  ');               {oppure premendo i tasti S,N}
Select('n',x1,y1);
sonoro;
ShowMouse;
tast_vuota;
c:='n';  {No e' predefinito}
ShowMouse;
ShowMouse;
repeat
 if (PollKeyEvent<>0) or (not topo) then
        begin
        old_c:=c;
        c:=KeyEventToString(TranslateKeyEvent(GetKeyEvent));
        if from_alt_to_char(c)<>#0 then c:=from_alt_to_char(c);
        if (pos('SHIFT ',c)<>0)and(length(c)=7) then c:=upcase(c[7]);
        if length(c)=1 then c:=upcase(c);
        if (c=#27) then c:='N'
                   else
        if c=Lingue.get_charUp(95) {'S'} then c:='S' {S}
                                     else
        if c=Lingue.get_charUp(96) {'N'} then c:='N' {N}
                                     else
        if from_alt_to_char(c)=Lingue.get_charUp(95) {'S'} then c:='S' {ALT+S}
                                     else
        if from_alt_to_char(c)=Lingue.get_charUp(96) {'N'} then c:='N' {ALT+N}
                                     else
        if (c='Left')or(c='Right')or(c='Up')or(c='Down')or(c='SHIFT Key with scancode 3840') then goto tab
                                     else
        if (c=#13)or(c=#32) then c:=upcase(old_c)
                                     else
        if (c=#9) then
                   begin
                   tab:
                   if (old_c='s') then c:='n'
                                  else
                   if (old_c='n') then c:='s';
                   Select(c[1],x1,y1);
                   end
                  else
                   if (c<>Lingue.get_charUp(95){'S'})and(c<>Lingue.get_charUp(96){'N'}) then c:=old_c;
        end
       else   // il mouse
        begin
        {$ifdef go32v2}
         cliccato:=Doppio_Click.Mouse_Up(mox,moy,stato);
        {$else}
         cliccato:=Doppio_Click.Mouse_Down(mox,moy,stato);
        {$endif}
        if cliccato then stato:=1
                    else stato:=0;
        if (stato=1) and (moy=y1) then
           begin
           if (mox>x1-1) and (mox<4+x1)  then c:='S';
           if (mox>5+x1) and (mox<10+x1) then c:='N';
           end;
        sleep(5);
        end;
until (c='S')or(c='N');
Tasti_SN:=c[1];
{$ifdef TxtCrt}
textcolor(white);
textbackground(blue);
gotoxy(1,y1);
clreol;           // copre la risposta SN   update 2.52
{$endif}
{$ifdef TxtVideo}
TxtVideo.TxtBackground(blue);
TxtVideo.TxtColor(white);
setcursorpos(0,y1-1);
TxtClreol;        // copre la risposta SN   update 2.52
{$endif}
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Err(x:byte; riga:longint; stringa:string);
begin
if wherex<>1 then write(invio+invio);
case x of
     1: writeln(Lingue.get_txt(97));  // 'Impossibile aprire il file EDITOR.INI'
     2: writeln(Lingue.get_txt(98));  // 'Impossibile leggere dal file EDITOR.INI'
     3: begin
        writeln(Lingue.get_txt(99),dim_punto(riga),Lingue.get_txt(100)); // '--- Valore non valido nella riga n '   ' di EDITOR.INI :'
        writeln(stringa);
        end;
     4: writeln(Lingue.get_txt(101),stringa);  // 'Memoria esaurita. Impossibile associare l''estensione: '
     5: begin
        writeln(Lingue.get_txt(102),dim_punto(riga),Lingue.get_txt(100)); // '--- Impostazione sconosciuta nella riga '
        writeln(stringa);
        end;
     end;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function is_parametro_os(s:string):boolean; // ver 2.59
var testa:string;
begin
testa:=upcase(copy(trimLeft(s),1,3));  // da "xxx_yyy" torna true se xxx e' OS
is_parametro_os:= (copy(s,4,1)='_')and( (testa='WIN')or(testa='DOS')or(testa='OS2')or(testa='LNX') );
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function this_is_parametro_os(var opz:string):boolean; // ver 2.59
var s,testa:string;
begin
this_is_parametro_os:=false;
s:=trimLeft(opz);  // da "xxx_yyy" torna true se xxx e' OS
testa:=upcase(copy(s,1,3));
if (copy(s,4,1)='_')and(os_prog=testa) then
            begin
            opz:=copy(s,4,length(s));
            this_is_parametro_os:=true;
            end;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function get_cfg_htm():shortstring;   // ver 2.77
var sep:char;
begin
sep:=Editor_Ini.separatore_valori();
exit(intToStr(bool(htm.titolo))+sep+           // :boolean;
     intToStr(bool(htm.fine_riga_br))+sep+     // :boolean;     // <br> (predefinito) , altrimenti <p></p>
     htm.colore_testo+sep+       //:string[6]  // FFFFFF  r,g,b; stringa vuota=ignora
     htm.colore_sfondo+sep+      //:string[6]  // FFFFFF  r,g,b; stringa vuota=ignora
     intToStr(htm.h)+sep+        //:byte;      // 0..6: <h>  ,  0=ignora
     intToStr(htm.size)+sep+     //:integer;   // 0=ignora
     intToStr(htm.allinea)+sep+  //:integer;   // 0=ignora, 1=sinistra, 2=destra, 3=centro, 4=giustificato
     intToStr(bool(htm.corsivo))+sep+    // :boolean;   // 0=stampatello, 1=corsivo (tutte le righe)
     intToStr(bool(htm.grassetto))+sep+  // :boolean;   // 0=ignora, 1=grassetto (tutte le righe)
     intToStr(bool(htm.sottolineato))+sep+ // :boolean;   // 0=ignora, 1=sottolineato (tutte le righe)
     intToStr(htm.size_rtf) );   // ver 2.96
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function setup_language():char;   // ver 3.30
var messaggio1,messaggio2,messaggio3:string;
begin
messaggio1:='You have not chosen any language. The default language is Italian.';
messaggio2:='If you don''t choose, do you want to show this dialog at the next start ?';
messaggio3:='';
while length(messaggio1)<80 do messaggio1:=' '+messaggio1+' ';
setlength(messaggio1,80);
while length(messaggio2)<80 do messaggio2:=' '+messaggio2+' ';
setlength(messaggio2,80);
while length(messaggio3)<80 do messaggio3:=messaggio3+' ';
cursorOff;
normale;
clrscr;
colore;
showmouse;
gotoxy(1,riga_menu);
write(messaggio3);
gotoxy(1,riga_menu+1);
write(messaggio1);
gotoxy(1,riga_menu+2);
write(messaggio2);
gotoxy(1,riga_menu+3);
write(messaggio3);
Doppio_Click.init;
testo[0]:='??';
result:=Tasti_SNA(32,riga_menu+3);
Doppio_Click.destroy;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function M_opzioni__Cambia_Lingua2():string;   // ver 3.30
var file_lingua,the_files:string;
begin
the_files:='*.lng';
file_lingua:=SfogliaFile(15,2,true,true,topo,mancino,' First boot?  Please, select your language... ',pathof(paramstr(0)){percorso},the_files,ClickDelay,ScreenHeight-4,
         '   Name: ','List',' elements',
         ' Data: ',' Time: ',' Attrib: ','    Search files ... ','N','L'); // 'Cambia lingua'
if FExpand2(pathOf(file_lingua))=FExpand2(pathOf(paramstr(0))) then file_lingua:=nameOf(file_lingua);
exit(file_lingua);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function IniFile():boolean;  { ver 1.50  IniFile==true== Errore in .ini file , editor.ini }
var ilGruppo{E,T,F,R,O,V...},fileis,gruppo,app1,coda,old_SaveShell:string;
    ini:text;    {file di testo}
    carica_lng,posiz1,posiz2:integer;
    pos_,app,val,riga,i:longint;
    YY,MM,DD,code:word;
    file_lng,htm_cfg,t,s_tipo,s_valore,s_commento,riga_letta_originale:string;
    opzione_sconosciuta,gia_aggiornato:boolean;
    rimuovi_righe:Lista_Esadecimale;
label carica_lingua,ripeti_setup;
begin
gia_aggiornato:=false;
opzione_sconosciuta:=false;
IniFile:=false;
gruppo:='';
rimuovi_righe.init;
fileis:={pathOf}(ParamStr(0));
fileis:=pathOf(fileis)+'editor.ini';
  // non fare  fileis:=pathOf(ParamStr(0))+'Editor.ini';  // crash anomalo
if Exist(fileis)<=0 then Exit;
assign(ini,fileis);
{$i-}
reset(ini);
{$i+}
if ioresult<>0 then
               begin
               Err(1,0,'');
               IniFile:=true;
               Exit;
               end;
riga:=0;
app:=0;
while true do
      begin
      {$i-}
      if EOF(ini) then Break;
      {$i+}
      if ioresult<>0 then ;
      {$i-}
      readln(ini,fileis);
      {$i+}
      if ioresult<>0 then
                     begin
                     Err(2,0,'');
                     IniFile:=true;
                     Break;
                     end;
      riga_letta_originale:=fileis;
      if riga=MaxLongint then
         begin
         IniFile:=true;
         break;
         end;
      inc(riga);
      s_tipo:='';
      s_valore:='';
      s_commento:='';
      posiz1:=pos(';',fileis);                    {; commenti}
      if posiz1>0 then
                  begin
                  if posiz1>1 then s_commento:=' ';
                  s_commento:=s_commento+copy(fileis,posiz1,length(fileis));
                  delete(fileis,posiz1,length(fileis));
                  end;
      fileis:=Trim(fileis);        {spazi}
      if fileis='' then
         begin
         if gruppo='OPZIONI' then Editor_Ini.input(s_tipo+Editor_Ini.separatore_opzioni()+s_valore+Editor_Ini.separatore_opzioni()+s_commento);
         continue;
         end;
      posiz1:=pos('[',fileis);                   {determina il gruppo}
      if posiz1=1 then
         begin
         posiz2:=pos(']',fileis);
         if posiz2=0 then
                     begin
                     Err(5,riga,fileis);
                     gruppo:='SCONOSCIUTO';
                     IniFile:=true;
                     continue;
                     end;
         if upcase(copy(fileis,posiz1+1,posiz2-2))='OPZIONI' then
                                                              begin
                                                              gruppo:='OPZIONI';
                                                              s_tipo:='['+gruppo+']';
                                                              s_commento:=' ; Editor '+ver+', configurazione del '+{$I %DATE%}+' '+{$I %TIME%}+', FPC '+{$I %FPCVERSION};
                                                              DeCodeDate(Date,YY,MM,DD);
                                                              s_commento:=' ; Editor '+ver+', configurazione del '+IntToStr(yy)+'/'+Zero(IntToStr(mm),2)+'/'+Zero(IntToStr(dd),2)+' - '+TimeToStr(Time)+', FPC '+{$I %FPCVERSION};
                                                              Editor_Ini.input(s_tipo+Editor_Ini.separatore_opzioni()+s_valore+Editor_Ini.separatore_opzioni()+s_commento);
                                                              end else
         if upcase(copy(fileis,posiz1+1,posiz2-2))='RECENTI' then gruppo:='RECENTI' else
         if upcase(copy(fileis,posiz1+1,posiz2-2))='VISUALIZZA' then gruppo:='VISUALIZZA' else
                                                              begin
                                                              gruppo:='SCONOSCIUTO';
                                                              s_tipo:='['+copy(fileis,posiz1+1,posiz2-2)+']';
                                                              Err(5,riga,fileis);
                                                              IniFile:=true;
                                                              end;
         Continue;
         end
        else {dentro OPZIONI}
         begin
         if gruppo='OPZIONI' then
            begin
            posiz1:=pos('=',fileis);
            if posiz1=0 then
                        begin
                        Err(5,riga,fileis);
                        IniFile:=true;
                        end
               else
                begin
                ilGruppo:=#0;
                app1:=upcase(trim(copy(fileis,1,posiz1-1)));
                if is_parametro_os(app1) then
                         begin
                         if this_is_parametro_os(app1) then
                                begin
                                app1:=copy(app1,2,length(app1)); // tolgo il '_'
                                s_tipo:=os_prog+'_'+app1;
                                end
                               else  // e' parametro per altro OS
                                begin
                                Editor_Ini.input(riga_letta_originale);
                                continue;
                                end;
                         end
                        else
                         s_tipo:=trim(copy(fileis,1,posiz1-1));
                if app1='LANGUAGE' then IlGruppo:='LANGUAGE' else // ver 3.20
                if app1='HTM' then IlGruppo:='HTM' else // ver 2.77
                if app1='DEFAULT_PATH' then IlGruppo:='DP' else // ver 2.45
                if app1='CLICKDELAY' then IlGruppo:='CD' else // ver 1.85
                if app1='ESA' then IlGruppo:='E' else
                if app1='TXT' then IlGruppo:='T' else
                if app1='ASK' then IlGruppo:='A' else
                if app1='FREQUENZA' {rate} then IlGruppo:='F' else
                if app1='RITARDO' {delay} then IlGruppo:='R' else
                if app1='MOUSEORIZZONTALE' then IlGruppo:='O' else
                if app1='MOUSEVERTICALE' then IlGruppo:='V' else
                if app1='RUNSHELL' then IlGruppo:='S' else
                if app1='RUNEDIT' then IlGruppo:='D' else
                if app1='SAVESHELL' then IlGruppo:='L' else
                if app1='AUTODETECT' then IlGruppo:='U' else
                if app1='FILES' then IlGruppo:='I' else
                if app1='LUNGHEZZA_RIGA_TXT' then IlGruppo:='LUNGHEZZA_RIGA_TXT' else
                if app1='LUNGHEZZA_RIGA_ESA' then IlGruppo:='LUNGHEZZA_RIGA_ESA' else
                if app1='/SF' then IlGruppo:='/SF' else
                if app1='/SL' then IlGruppo:='/SL' else
                if app1='/BK' then IlGruppo:='/BK' else
                if app1='/CL' then IlGruppo:='/CL' else
                if app1='/US' then IlGruppo:='/US' else
                if app1='/DM' then IlGruppo:='/DM' else
                if app1='/D0' then IlGruppo:='/D0' else
                if app1='/D1' then IlGruppo:='/D1' else
                if app1='/D2' then IlGruppo:='/D2' else
                if app1='PRINTER' then IlGruppo:='P' else
                if app1='BARRAPAG' then IlGruppo:='B' else
                if app1='MANCINO' then IlGruppo:='M' else
                if app1='TAB' then IlGruppo:='TAB' else
                if app1='HOME' then IlGruppo:='HOME' else  // ver 2.25
                if app1='END' then IlGruppo:='END' else    // ver 2.25
                if app1='SALVA_TAB' then IlGruppo:='SALVA_TAB' else
                if app1='NUM_NOTES' then IlGruppo:='NUM_NOTES' else // ver 2.58
                if app1='SELEZIONE_QUADRATA' then IlGruppo:='SELEZIONE_QUADRATA' else // ver 2.63
                if app1='SALVA_CONFIGURAZIONE' then IlGruppo:='SALVA_CONFIGURAZIONE' else // ver 2.68
                if app1='SALVA_RECENTI' then IlGruppo:='SALVA_RECENTI' else // ver 2.68
                if app1='SALVA_VISUALIZZA' then IlGruppo:='SALVA_VISUALIZZA' else // ver 2.68
                if app1='MAX_RIGHE_TXT' then IlGruppo:='MAX_RIGHE_TXT' else // ver 2.73
                if app1='MAX_RIGHE_ESA' then IlGruppo:='MAX_RIGHE_ESA' else // ver 2.73
                if app1='/N' then IlGruppo:='/N' else // ver 2.85
                if app1='/MEM' then IlGruppo:='/MEM' else // ver 2.88
                if app1='FONT' then IlGruppo:='FONT' else // ver 2.95
                if app1='' then
                           else
                            begin
                            Err(5,riga,fileis);
                            IniFile:=true;
                            end;
                if (ilGruppo='E') or (ilGruppo='T') or (ilGruppo='A') then
                          begin
                          app1:=upcase(copy_end(fileis,posiz1+1));
                          while app1<>'' do
                                begin
                                Testa_Coda(app1,',',app1,coda);
                                if app1[1]=',' then app1:=Copy_end(app1,2);
                                if (app1<>'')and(app1[length(app1)]=',') then app1:=Copy(app1,1,length(app1)-1);
                                if (pos('*',app1)>0)or(pos('?',app1)>0) then
                                    begin
                                    IniFile:=true;
                                    Err(3,riga,app1);
                                    end
                                   else
                                    if Estensioni.input_iniziale(strnew(stringtopchar(ilGruppo+app1)))=nil
                                            then
                                             begin
                                             Err(3,riga,fileis); {gestire memoria esaurita}
                                             IniFile:=true;
                                             end;
                                app1:=coda;
                                end;
                          end else
                if (ilGruppo='LANGUAGE') then  // ver 3.20 lingua
                   begin
                   file_lng:=trim(copy_end(fileis,pos('=',fileis)+1));
                   if file_lng='?' then // ver 3.30
                      begin
                      ripeti_setup:
                      clrscr;
                      {$ifdef TxtCrt}
                      writeln(invio+'  EdiTury');
                      writeln('  ver ',ver);
                      {$endif}
                      {$ifdef TxtVideo}
                      OutTextXY(1,1,' EdiTury');
                      OutTextXY(1,2,' ver '+ver);
                      TxtBackground(black);
                      TxtClrScr;
                      updatescreen(true);
                      {$endif}
                      file_lng:=M_opzioni__Cambia_Lingua2;
                      if file_lng<>'' then
                                      begin
                                      app:=-2;
                                      goto carica_lingua;
                                      end
                                     else
                                      case setup_language() of
                                           'S': ; // mostra ancora la domanda al prossimo riavvio
                                           'N': begin
                                                writeln(s_tipo+Editor_Ini.separatore_opzioni()+s_valore+Editor_Ini.separatore_opzioni()+s_commento);
                                                Editor_Ini.input(s_tipo+'='+Editor_Ini.separatore_opzioni()+s_valore+Editor_Ini.separatore_opzioni()+s_commento);
                                                gia_aggiornato:=true;
                                                Editor_Ini.Aggiorna('OPZIONI'{nome_gruppo},'Language'{nome_tipo},''{valore});
                                                Editor_Ini.Set_Modifica(true); // accetta l'italiano come default
                                                end;
                                           'A': goto ripeti_setup;
                                           end;
                      end else
                   if file_lng<>'' then
                      begin
                      carica_lingua:
                      carica_lng:=lingue.Carica(file_lng);
                      if carica_lng=0 then
                                  begin
                                  Est_note:=Lingue.get_charUp(140){'P'};
                                  Est_non_note:=Lingue.get_charUp(144){'/'};
                                  if app=-2 then
                                     begin
                                     app:=0;
                                     Editor_Ini.Aggiorna('OPZIONI'{nome_gruppo},'Language'{nome_tipo},file_lng{valore});
                                     Editor_Ini.Set_Modifica(true);
                                     end;
                                  end
                                 else
                                  begin
                                  case carica_lng of
                                       1: writeln(invio+Lingue.get_txt(537));  // 'Errore nel contenuto del file della nuova lingua.'
                                       2: writeln(invio+Lingue.get_txt(536));  // 'Errore nel leggere il file della nuova lingua.'
                                       3: writeln(invio+Lingue.get_txt(538));  // 'File della lingua non trovato.'
                                       end;
                                  app:=-1;
                                  end;
                      end
                   end else
                if (ilGruppo='FONT') then  // ver 2.95
                          htm.font:=trim(copy_end(fileis,posiz1+1))
                          else
                if (ilGruppo='R') then
                          begin
                          Val_Try(trim(copy_end(fileis,posiz1+1)),app,Code);
                          if code<>0 then app:=-1;
                          if (app>3) or (app<0) then
                                                  begin
                                                  ritardo:=0;
                                                  app:=-1;
                                                  end
                                                else ritardo:=app;
                          end else
                if (ilGruppo='NUM_NOTES') then  // ver 2.58
                          begin
                          Val_Try(trim(copy_end(fileis,posiz1+1)),app,Code);
                          if code<>0 then app:=-1;
                          Num_Notes:=0; // predefinito
                          if app<0 then app:=-1
                                   else num_notes:=app;
                          end else
                if (ilGruppo='TAB') then
                          begin
                          Val_Try(trim(copy_end(fileis,posiz1+1)),app,Code);
                          if code<>0 then app:=-1;
                          if (app>254) or (app<1) then app:=-1
                                                  else Tab_num:=app;
                          end else
                if (ilGruppo='F') then
                          begin
                          Val_Try(trim(copy_end(fileis,posiz1+1)),app,Code);
                          if code<>0 then app:=-1;
                          if (app>31) or (app<0) then
                                                  begin
                                                  frequenza:=0;
                                                  app:=-1;
                                                  end
                                                 else frequenza:=app;
                          end else
                if (ilGruppo='O') then
                          begin
                          Val_Try(trim(copy_end(fileis,posiz1+1)),app,Code);
                          if code<>0 then app:=-1;
                          if app<0 then MOrizzontale:=8
                                   else MOrizzontale:=app;
                          end else
                if (ilGruppo='MAX_RIGHE_TXT') then    // ver 2.73
                          begin
                          Val_Try(trim(copy_end(fileis,posiz1+1)),app,Code);
                          if code<>0 then app:=-1;
                          if app<1 then next_MAX_RIGHE_TXT:=6000+2
                                   else next_MAX_RIGHE_TXT:=app+2;
                          end else
                if (ilGruppo='MAX_RIGHE_ESA') then    // ver 2.73
                          begin
                          Val_Try(trim(copy_end(fileis,posiz1+1)),app,Code);
                          if code<>0 then app:=-1;
                          if app<1 then next_MAX_RIGHE_ESA:=810+2
                                   else next_MAX_RIGHE_ESA:=app+2;
                          end else
                if (ilGruppo='V') then
                          begin
                          Val_Try(trim(copy_end(fileis,posiz1+1)),app,Code);
                          if code<>0 then app:=-1;
                          if app<0 then MVerticale:=16
                                   else MVerticale:=app;
                          end else
                if (ilGruppo='CD') then  // ver 1.85
                          begin
                          Val_Try(trim(copy_end(fileis,posiz1+1)),app,Code);
                          if code<>0 then app:=-1;
                          if app>100 then app:=-1;
                          if app<0 then ClickDelay:=0
                                   else ClickDelay:=min(app,100);
                          end else
                if (ilGruppo='S') then RunShell:=trim(copy_end(fileis,posiz1+1)) else
                if (ilGruppo='I') then
                          begin
                          if (copy(the_files,length(the_files),1)=';') then The_Files:=The_Files+trim(copy_end(fileis,posiz1+1))
                                                                       else if the_files='' then The_Files:=trim(copy_end(fileis,posiz1+1))
                                                                                            else The_Files:=The_Files+';'+trim(copy_end(fileis,posiz1+1));
                          for app:=1 to length(The_Files) do if The_Files[app]=',' then The_Files[app]:=';';
                          end else
                if (ilGruppo='D') then RunEdit:=trim(copy_end(fileis,posiz1+1)) else
                if (ilGruppo='U') then
                          begin
                          app1:=upcase(trim(copy_end(fileis,posiz1+1)));
                          if app1='TRUE' then AutoDetect:=true else
                             if app1='FALSE' then AutoDetect:=false else app:=-1;
                          end else
                if (ilGruppo='B') then
                          begin
                          app1:=upcase(trim(copy_end(fileis,posiz1+1)));
                          if app1='TRUE' then barra_pag:=true else
                             if app1='FALSE' then barra_pag:=false else app:=-1;
                          end else
                if (ilGruppo='END') then  // ver 2.25
                          begin
                          app1:=upcase(trim(copy_end(fileis,posiz1+1)));
                          if app1='TRUE' then Fine_:=true else
                             if app1='FALSE' then Fine_:=false else app:=-1;
                          end else
                if (ilGruppo='HOME') then  // ver 2.25
                          begin
                          app1:=upcase(trim(copy_end(fileis,posiz1+1)));
                          if app1='TRUE' then Home:=true else
                             if app1='FALSE' then Home:=false else app:=-1;
                          end else
                if (ilGruppo='M') then
                          begin
                          app1:=upcase(trim(copy_end(fileis,posiz1+1)));
                          if app1='TRUE' then mancino:=true else
                             if app1='FALSE' then mancino:=false else app:=-1;
                          end else
                if (ilGruppo='SALVA_TAB') then
                          begin
                          app1:=upcase(trim(copy_end(fileis,posiz1+1)));
                          if app1='TRUE' then salva_tab:=true else
                             if app1='FALSE' then salva_tab:=false else app:=-1;
                          end else
                if (ilGruppo='SELEZIONE_QUADRATA') then  // ver 2.63
                          begin
                          app1:=upcase(trim(copy_end(fileis,posiz1+1)));
                          if app1='TRUE' then selezione_quadrata:=true else
                             if app1='FALSE' then selezione_quadrata:=false else app:=-1;
                          end else
                if (ilGruppo='L') then
                          begin
                          old_SaveShell:=SaveShell;
                          SaveShell:=upcase(trim(copy_end(fileis,posiz1+1)));
                          if (SaveShell='ST')or(SaveShell='SE')or(SaveShell='STI')or
                             (SaveShell='SEI')or(SaveShell='N')or(SaveShell='C')or
                             (SaveShell='AI')or(SaveShell='A') then
                                                               else
                                                                begin
                                                                app:=-1;
                                                                SaveShell:=old_SaveShell;
                                                                end;
                          end else
                if (ilGruppo='/SF') then
                          begin
                          app1:=upcase(trim(copy_end(fileis,posiz1+1)));
                          if (opzioni_da_terminale[2]='0') then
                          if app1='TRUE' then SFinal:=true else
                             if app1='FALSE' then SFinal:=false else app:=-1;
                          end else
                if (ilGruppo='/SL') then
                          begin
                          app1:=upcase(trim(copy_end(fileis,posiz1+1)));
                          if (opzioni_da_terminale[3]='0') then
                          if app1='TRUE' then SL:=true else
                             if app1='FALSE' then SL:=false else app:=-1;
                          end else
                if (ilGruppo='/BK') then
                          begin
                          app1:=upcase(trim(copy_end(fileis,posiz1+1)));
                          if (opzioni_da_terminale[4]='0') then
                          if app1='TRUE' then BK:=true else
                             if app1='FALSE' then BK:=false else app:=-1;
                          end else
                if (ilGruppo='/CL') then
                          begin
                          app1:=upcase(trim(copy_end(fileis,posiz1+1)));
                          if (opzioni_da_terminale[5]='0') then
                          if app1='TRUE' then CL:=true else
                             if app1='FALSE' then CL:=false else app:=-1;
                          end else
                if (ilGruppo='/US') then
                          begin
                          app1:=upcase(trim(copy_end(fileis,posiz1+1)));
                          if (opzioni_da_terminale[6]='0') then
                          if app1='TRUE' then UnoS:=true else
                             if app1='FALSE' then UnoS:=false else app:=-1;
                          end else
                if (ilGruppo='/DM') then
                          begin
                          app1:=upcase(trim(copy_end(fileis,posiz1+1)));
                          if (opzioni_da_terminale[7]='0') then
                          if app1='TRUE' then topo:=false else
                             if app1='FALSE' then topo:={$ifdef Go32v2}mousefound{$else}(detectmouse>0){$endif}
                                             else app:=-1;
                          end else
                if (ilGruppo='/N') then
                          begin  // ver 2.85 non apre i files da terminale gia' caricati precedentemente
                          app1:=upcase(trim(copy_end(fileis,posiz1+1)));
                          if (opzioni_da_terminale[10]='0') then
                          if app1='TRUE' then apri_file_caricati:=false else
                             if app1='FALSE' then apri_file_caricati:=true else app:=-1;
                          end else
                if (ilGruppo='/MEM') then
                          begin  // ver 2.88 memoria automatica per file di testo troppo lunghi
                          app1:=upcase(trim(copy_end(fileis,posiz1+1)));
                          if (opzioni_da_terminale[11]='0') then
                          if app1='TRUE' then mem_automatica:=true else
                             if app1='FALSE' then mem_automatica:=false else app:=-1;
                          end else
                if (ilGruppo='/D0') then
                          begin
                          app1:=upcase(trim(copy_end(fileis,posiz1+1)));
                          if (opzioni_da_terminale[8]='0') then
                          if app1='TRUE' then delimitatore:=0{lineending} else
                             if app1='FALSE' then
                                             else app:=-1;
                          end
                   else
                if (ilGruppo='/D1') then
                          begin
                          app1:=upcase(trim(copy_end(fileis,posiz1+1)));
                          if (opzioni_da_terminale[8]='0') then
                          if app1='TRUE' then delimitatore:=1{#10} else
                             if app1='FALSE' then
                                             else app:=-1;
                          end
                   else
                if (ilGruppo='/D2') then
                          begin
                          app1:=upcase(trim(copy_end(fileis,posiz1+1)));
                          if (opzioni_da_terminale[8]='0') then
                          if app1='TRUE' then delimitatore:=2{#13+#10} else
                             if app1='FALSE' then
                                             else app:=-1;
                          end
                   else
                if (ilGruppo='SALVA_CONFIGURAZIONE') then
                          begin
                          app1:=upcase(trim(copy_end(fileis,posiz1+1)));
                          if app1='TRUE' then editor_ini.set_salva_configurazione(true) else
                             if app1='FALSE' then editor_ini.set_salva_configurazione(false)
                                             else app:=-1;
                          end
                   else
                if (ilGruppo='SALVA_RECENTI') then
                          begin
                          app1:=upcase(trim(copy_end(fileis,posiz1+1)));
                          if app1='TRUE' then editor_ini.set_salva_recenti(true) else
                             if app1='FALSE' then editor_ini.set_salva_recenti(false)
                                             else app:=-1;
                          end
                   else
                if (ilGruppo='SALVA_VISUALIZZA') then
                          begin
                          app1:=upcase(trim(copy_end(fileis,posiz1+1)));
                          if app1='TRUE' then editor_ini.set_salva_visualizza(true) else
                             if app1='FALSE' then editor_ini.set_salva_visualizza(false)
                                             else app:=-1;
                          end
                   else
                if (ilGruppo='P') and (opzioni_da_terminale[9]='0') then
                          begin
                          app1:=upcase(trim(copy_end(fileis,posiz1+1)));
                          if (app1='COM1')or(app1='COM2')or(app1='COM3')or(app1='COM4')
                             or(app1='LPT1')or(app1='LPT2')or(app1='LPT3')or(app1='LPT4')
                             or(app1='LPT5')or(app1='LPT6')or(app1='LPT7')or(app1='LPT8')
                             or(app1='LPT9') then
                                              begin
                                              {$ifndef Linux}
                                              Stampante.Set_Printer(app1);
                                              {$endif}
                                              end
                                             else app:=-1;
                          end else
                if (ilGruppo='LUNGHEZZA_RIGA_TXT') and (opzioni_da_terminale[1]='0') then  // ver 2.69
                          begin
                          Val_Try(trim(copy_end(fileis,posiz1+1)),app,Code);
                          if code<>0 then app:=-1
                                     else
                                     if (app>=1)and(app<=254) then next_length_TXT:=app
                                                              else app:=-1;
                          end else
                if (ilGruppo='LUNGHEZZA_RIGA_ESA') and (opzioni_da_terminale[1]='0') then  // ver 2.69
                          begin
                          Val_Try(trim(copy_end(fileis,posiz1+1)),app,Code);
                          if code<>0 then app:=-1
                                     else
                                     if (app>=1)and(app<=254) then next_length_ESA:=app
                                                              else app:=-1;
                          end else
                if (ilGruppo='HTM') then  // ver 2.77
                          begin
                          htm_cfg:=trim(copy_end(fileis,posiz1+1));
                          pos_:=0;
                          while htm_cfg<>'' do
                                begin
                                testa_coda(htm_cfg,',',t,htm_cfg);
                                t:=trim(copy_end(t,2));
                                inc(pos_);
                                if t='' then continue;
                                case pos_ of
                                     1: if t='1' then htm.titolo:=true else
                                        if t='0' then htm.titolo:=false
                                                 else app:=-1;
                                     2: if t='1' then htm.fine_riga_br:=true else
                                        if t='0' then htm.fine_riga_br:=false
                                                 else app:=-1;
                                   3,4: begin
                                        if length(t)>6 then app:=-1 else
                                           for i:=1 to length(t) do
                                               if not (t[i] in ['0'..'9','a'..'f','A'..'F']) then
                                                  begin
                                                  app:=-1;
                                                  break;
                                                  end;
                                        if app<>-1 then
                                                   if pos_=3 then htm.colore_testo:=t
                                                             else htm.colore_sfondo:=t;  // pos=4
                                        end;
                                     5: if (length(t)=1)and(t[1] in ['0'..'6']) then htm.h:=ord(t[1])-48
                                                                                else app:=-1;
                                     6: begin
                                        Val_Try(t,val,Code);
                                        if code<>0 then app:=-1
                                                   else
                                                   if (val>=0)and(val<=7) then htm.size:=val
                                                                          else app:=-1;
                                        end;
                                     7: if length(t)=1 then
                                           if t[1] in ['0'..'4'] then htm.allinea:=ord(t[1])-48
                                                                 else app:=-1
                                           else app:=-1;
                                     8: if t='1' then htm.corsivo:=true else
                                        if t='0' then htm.corsivo:=false
                                                 else app:=-1;
                                     9: if t='1' then htm.grassetto:=true else
                                        if t='0' then htm.grassetto:=false
                                                 else app:=-1;
                                    10: if t='1' then htm.sottolineato:=true else
                                        if t='0' then htm.sottolineato:=false
                                                 else app:=-1;
                                    11: begin // ver 2.96
                                        Val_Try(t,val,Code);
                                        if code<>0 then app:=-1
                                                   else
                                                   if (val>=0)and(val<=max_rtf_size) then htm.size_rtf:=val
                                                                                     else app:=-1;
                                        end;
                                     else app:=-1;
                                     end;  // case
                                end;   // del while delle opzioni
                          if app=-1 then
                              begin;
                              Editor_Ini.Set_modifica(true);
                              Editor_Ini.Aggiorna('OPZIONI'{nome_gruppo},'Htm'{nome_tipo},get_cfg_htm(){valore});
                              end
                             else
                              begin
                              s_valore:=copy_end(fileis,posiz1+1);
                              Editor_Ini.input(s_tipo+Editor_Ini.separatore_opzioni()+'='+s_valore+Editor_Ini.separatore_opzioni()+s_commento);
                              end; // quando linguage =? bisogna prima reinserire la riga a poi aggiornarla
                          end else
                if (ilGruppo='DP') then  // update 2.45
                          begin
                          start_dir_default_path:=Fexpand2(trim(copy_end(fileis,posiz1+1)));
                          {$i-}
                          chdir(start_dir_default_path);
                          {$i+}
                          if IOResult<>0 then
                                          begin
                                          app:=-1;
                                          {$I-}
                                          getdir(0,start_dir_default_path);
                                          {$I+}
                                          if IOResult <> 0 then;
                                          end
                                         else
                                          begin
                                          app:=0;
                                          if start_dir_default_path[length(start_dir_default_path)]<>pathdelim then start_dir_default_path:=start_dir_default_path+pathdelim;
                                          end;
                          end
                         else  // ver 2.76 non salva le opzioni sconosciute/errate
                          begin
                          opzione_sconosciuta:=true;
                          end;
                if app<0 then
                         begin
                         Err(3,riga,fileis);
                         app:=0;
                         IniFile:=true;
                         gia_aggiornato:=true;          // ver 3.30 Le righe errate non verranno salvate
                         Editor_Ini.Set_Modifica(true); // ver 3.30
                         rimuovi_righe.input(intToStr(riga));
                         end;
                if (ilGruppo<>'HTM')and(ilGruppo<>'T')and(ilGruppo<>'E')and(ilGruppo<>'A') then // ver 2.75  salta l'associazione delle estensioni
                     begin
                     if opzione_sconosciuta then    // ver 2.76
                        begin
                        Editor_Ini.Set_Modifica(true);
                        opzione_sconosciuta:=false;
                        Continue;
                        end;
                     if gia_aggiornato then gia_aggiornato:=false
                                       else
                                       begin
                                       s_valore:=copy_end(fileis,posiz1+1);
                                       Editor_Ini.input(s_tipo+Editor_Ini.separatore_opzioni()+'='+s_valore+Editor_Ini.separatore_opzioni()+s_commento);
                                       end;
                     end;
                end;
            end else
         if gruppo='RECENTI' then     // per i files chiusi
                             begin
                             posiz1:=pos('=',fileis);
                             if posiz1=0 then
                                         begin
                                         Err(5,riga,fileis);
                                         IniFile:=true;
                                         end
                                        else
                                         if upcase(trim(copy(fileis,1,posiz1-1)))<>'FILE' then
                                                      begin
                                                      Err(5,riga,fileis);
                                                      IniFile:=true;
                                                      end
                                                     else
                                                      Editor_Ini.Input_File_Recenti(trim(copy_end(fileis,posiz1+1)));
                             end else
         if gruppo='VISUALIZZA' then  // per i files aperti
                             begin
                             posiz1:=pos('=',fileis);
                             if posiz1=0 then
                                         begin
                                         Err(5,riga,fileis);
                                         IniFile:=true;
                                         end
                                        else
                                         if upcase(trim(copy(fileis,1,posiz1-1)))<>'FILE' then
                                                      begin
                                                      Err(5,riga,fileis);
                                                      IniFile:=true;
                                                      end
                                                     else
                                                      Editor_Ini.Input_File_Aperti(trim(copy_end(fileis,posiz1+1)));
                             end else
         if gruppo='SCONOSCIUTO' then
                                 begin
                                 Err(5,riga,fileis);
                                 IniFile:=true;
                                 end;
         end;
      end;
Editor_Ini.Reverse_File_Recenti;
rimuovi_righe.destroy;
{$i-}
close(ini);
{$i+}
if IOResult<>0 then ;
{$ifdef Go32v2}
 SetMouseSpeed(MOrizzontale,MVerticale);
 keyspeed(byte(ritardo),byte(frequenza));
{$endif}
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure No_OS;
begin
pulisci1;
gotoxy(40-Lingue.get_length_txt(103) div 2,riga_menu+2);
write(Lingue.get_txt(103));  // 'Funzione non implementabile in questa versione.'
Esc;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function nomeLungo(s:string; l:byte):string;
var i:byte;
begin
if length(s)>l then
   begin
   setlength(s,l);
   for i:=0 to 3 do s[l-i]:='.';
   end;
nomelungo:=s;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Estensioni_non_note(c:char);  //  ver 1.82
begin
if c=est_non_note then Exit;
if c=#0 then c:=est_non_note //serve per mostrare la prima volta, la X in Configura
        else est_non_note:=c;
hidemouse;
if c=Lingue.get_charUp(142){'A'} then
   begin
   gotoxy(57,21);
   write('*');
   gotoxy(57,22);
   write(' ');
   gotoxy(57,23);
   write(' ');
   est_non_note:=Lingue.get_charUp(142){'A'};
   end;
if c=Lingue.get_charUp(143){'X'} then
   begin
   gotoxy(57,21);
   write(' ');
   gotoxy(57,22);
   write('*');
   gotoxy(57,23);
   write(' ');
   est_non_note:=Lingue.get_charUp(143){'X'};
   end;
if c=Lingue.get_charUp(144){'/'} then
   begin
   gotoxy(57,21);
   write(' ');
   gotoxy(57,22);
   write(' ');
   gotoxy(57,23);
   write('*');
   est_non_note:=Lingue.get_charUp(144){'/'};
   end;
showmouse;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Estensioni_note(c:char);  //  update ver 1.82
begin
if c=est_note then Exit;
if c=#0 then c:=est_note //serve per mostrare la prima volta, la X in Configura
        else est_note:=c;
hidemouse;
if c=Lingue.get_charUP(137){'E'} then
   begin
   gotoxy(57,15);
   write('*');
   gotoxy(57,16);
   write(' ');
   gotoxy(57,17);
   write(' ');
   gotoxy(57,18);
   write(' ');
   est_note:=Lingue.get_charUP(137){'E'};
   end;
if c=Lingue.get_charUP(140){'P'} then
   begin
   gotoxy(57,15);
   write(' ');
   gotoxy(57,16);
   write(' ');
   gotoxy(57,17);
   write(' ');
   gotoxy(57,18);
   write('*');
   est_note:=Lingue.get_charUP(140){'P'};
   end;
if c=Lingue.get_charUP(138){'T'} then
   begin
   gotoxy(57,15);
   write(' ');
   gotoxy(57,16);
   write('*');
   gotoxy(57,17);
   write(' ');
   gotoxy(57,18);
   write(' ');
   est_note:=Lingue.get_charUP(138){'T'};
   end;
if c=Lingue.get_charUP(139){'C'} then
   begin
   gotoxy(57,15);
   write(' ');
   gotoxy(57,16);
   write(' ');
   gotoxy(57,17);
   write('*');
   gotoxy(57,18);
   write(' ');
   est_note:=Lingue.get_charUP(139){'C'};
   end;
showmouse;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure open_ASK_comune(nomefile:string);  // ver 1.82    update 2.00 , 2.52
{$ifdef TxtVideo}
var s:string;
{$endif}
begin
{$ifdef TxtCrt}
pulisci1;
showmouse;
gotoxy(1,riga_menu+1);
write(Lingue.get_txt(104));  // 'Aprire il file '
textbackground(red);
write(nomeLungo(TruncPath(nomefile,45),45));
textbackground(blue);
write(Lingue.get_txt(105));  // ' in esadecimale ?'
{$endif}
{$ifdef TxtVideo}  // ver 2.00
TxtBlink(0);
TxtBackground(blue);
setcursorPos(0,riga_menu);
TxtClreol;
setcursorPos(0,riga_menu+1);
TxtClreol;
setcursorPos(0,riga_menu+2);
TxtClreol;
OutTextXY(1,riga_menu,Lingue.get_txt(104),0,blue,white); // 'Aprire il file '
s:=nomeLungo(TruncPath(nomefile,45),45);
OutTextXY(16,riga_menu,s,0,red,white);
OutTextXY(length(s)+16,riga_menu,'                                                              ',0,blue,white);
OutTextXY(length(s)+16,riga_menu,Lingue.get_txt(105),0,blue,white);  // ' in esadecimale ?'
{$endif}
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function open_ASK(nomefile:string):char;  // ver 1.82    update 2.00 , 2.52
begin
open_ASK_comune(nomefile);
exit(Tasti_SNA(32,riga_menu+3));
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function Zero(str:string; count:byte):string;  {ver 1.80}
begin
while length(str)<count do str:='0'+str;
zero:=str;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function num_elementi_appunti:longint;
begin    //  ver 2.30 , update 2.40 , 2.52 , 2.58
if (appunti_usato<0) then Exit(0);
if appunti_usato>length(appunti)-1 then appunti_usato:=length(appunti)-1;  // controllo estremo
exit(Appunti[appunti_usato].numelementi);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function Din_Mem_Free(num:longint):boolean; {arrotondare num per ecceso: pointer da considerare}
begin      // num_righe da mettere in memoria      ver 1.60 , update 2.58
Din_Mem_Free:=true;
if memAvail>num*(lunghezza_riga+10) then Exit;
pulisci1;
hidemouse;
gotoxy(40-Lingue.get_length_txt(106) div 2,riga_menu+1);
write(Lingue.get_txt(106)); // 'Memoria insufficiente per effettuare l''operazione.'
gotoxy(40-Lingue.get_length_txt(107) div 2,riga_menu+2);
write(Lingue.get_txt(107));  // 'Svuotare gli Appunti, Annulla e Ripristina per liberarla, quindi riprovare.'
Din_Mem_Free:=false;
ShowMouse;
Esc;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Not_Found; {cerca stringa}
begin
pulisci1;
if selezione then
              begin
              gotoxy(40-Lingue.get_length_txt(108) div 2,riga_menu+1);
              writeln(Lingue.get_txt(108))  // 'Stringa non trovata (dentro il testo selezionato):'
              end
             else
              begin
              gotoxy(40-Lingue.get_length_txt(109) div 2,riga_menu+1);
              writeln(Lingue.get_txt(109)); // 'Stringa non trovata:'
              end;
gotoxy(39-length(cerco) div 2 -1,riga_menu+2);
write('"');
textcolor(lightgreen);   {10}
write(cerco);
textcolor(white);
write('"');
Esc;
{$ifdef TxtVideo}
ForceUpdateXY(0,riga_menu-1,ScreenWidth*5);
{$endif}
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Si_No_Str(var s:string);
var stato_,lastD,lastU,posto:byte;
    c:string;
    cliccato,insert:boolean;
label tab;
begin
ShowMouse;
insert:=false;
posto:=1;
gotoxy(1,riga_menu+4);
stato_:=1;
gotoxy(1,riga_menu+3);
Pre_Tasti(35,riga_menu+3);
repeat
 if stato_=1 then
              begin
              textcolor(lightgreen);
              gotoxy(1,riga_menu+4);
              s:=ReadString(s,1,70,0,topo,true,mancino,insert,lastD,lastU,posto);
              if (lastU=27)and(lastD=0)and(s='') then Exit;
              if (lastU=13)and(lastD=0) then
                 if s='' then Exit
                         else break;
              if (lastD=0)and(lastU=9) then goto Tab else
              if (lastD=0)and(lastU=7) then
                  begin
                  inc(stato_);
                  goto Tab; // shift+tab
                  end;
              end;
 if (PollKeyEvent<>0) or (not topo) then
               begin
               c:=KeyEventToString(TranslateKeyEvent(GetKeyEvent));
               if (c='Down')or(c='Right') then
                  begin
                  lastD:=0;
                  lastU:=9;
                  end else
               if (c='Left')or(c='Up')or(c='SHIFT Key with scancode 3840') then  // shift+tab
                  begin
                  lastD:=0;
                  lastU:=9;
                  if stato_=3 then stato_:=1
                              else
                  if stato_=2 then stato_:=3;
                  end else
               if length(c)=1 then
                               begin
                               lastU:=ord(c[1]);
                               LastD:=0;
                               end
                              else
                               begin
                               lastU:=1;   // carattere non valido
                               LastD:=255;
                               end;
               if (stato_ in [2,3]) and (lastU in [13,32]) then
                                      begin
                                      gotoxy(34,riga_menu+3);
                                      write(' ');
                                      gotoxy(39,riga_menu+3);
                                      write('  ');
                                      gotoxy(46,riga_menu+3);
                                      write(' ');
                                      end;
               if stato_=2 then
                           if lastU in [13,32] then break;
               if stato_=3 then
                           if lastU in [13,32] then
                                               begin
                                               s:='';
                                               Exit;
                                               end;
               if (stato_ in [2,3]) and (lastU=27) and (lastD=0) then
                      begin
                      s:='';
                      Exit;
                      end;
               end
              else
               begin  // controllo mouse
               {$ifdef Go32v2}
                cliccato:=Doppio_Click.Mouse_Up(mox,moy,stato);
               {$else}
                cliccato:=Doppio_Click.Mouse_Down(mox,moy,stato);
               {$endif}
               if cliccato then stato:=1
                           else stato:=0;
               if stato=1 then
                          begin
                          lastU:=mox;
                          lastD:=moy;
                          end
                         else
                          begin
                          mox:=0; // sempre senza senso
                          moy:=0;
                          end;
               end;
 if (lastD=0)and(lastU=9) then
                          begin
                          Tab:
                          lastU:=0;
                          inc(stato_);  {tab}
                          if stato_>3 then
                                      begin
                                      stato_:=1;
                                      gotoxy(34,riga_menu+3);
                                      write(' ');
                                      gotoxy(39,riga_menu+3);
                                      write('  ');
                                      gotoxy(46,riga_menu+3);
                                      write(' ');
                                      end;
                          if stato_ in [2,3] then
                                              begin
                                              cursorOff;
                                              colore;
                                              end
                                             else cursorOn;
                          if stato_=2 then
                                      begin
                                      gotoxy(34,riga_menu+3);
                                      write('[');
                                      gotoxy(39,riga_menu+3);
                                      write('] ');
                                      gotoxy(46,riga_menu+3);
                                      write(' ');
                                      end;
                          if stato_=3 then
                                      begin
                                      gotoxy(34,riga_menu+3);
                                      write(' ');
                                      gotoxy(39,riga_menu+3);
                                      write(' [');
                                      gotoxy(46,riga_menu+3);
                                      write(']');
                                      end;
                          end;
 if (lastU>40)and(lastU<46)and(lastD=riga_menu+3) then
          begin
          s:='';
          Exit;  // ESC
          end;
 if (lastU>34)and(lastU<39)and(lastD=riga_menu+3) then break; // OK
 if (lastU>0)and(lastU<70)and(lastD=riga_menu+4) then
     begin
     stato_:=1;
     posto:=lastU;
     gotoxy(34,riga_menu+3);
     write(' ');
     gotoxy(39,riga_menu+3);
     write('  ');
     gotoxy(46,riga_menu+3);
     write(' ');
     end;
until false;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Str_Int_multiplo(var n,m:integer; i,ii:integer);  {per le stringhe --> integer}
var pos_err:word;
    stringa,stringa1,stringa2,stringa3:string;
    pos1,pos2:integer;
label multiplo;
begin
gotoxy(1,riga_menu+4);
write('                                              ');
gotoxy(1,riga_menu+4);
stringa:=IntToStr(n);
repeat
 Si_No_Str(stringa);
 if stringa='' then
       begin
       n:=0;
       Exit;           {ESC}
       end
      else
       begin
       stringa1:=trim(stringa);
       stringa3:=stringa1;
       pos1:=pos(',',stringa1);
       if pos1=0 then pos1:=255;
       pos2:=pos(';',stringa1);
       if pos2=0 then pos2:=255;
       pos1:=min(pos1,pos2);
       if pos1=255 then  // non ci sono ";" o ","    Cerco " "
                     begin
                     pos1:=pos(' ',stringa1);
                     if pos1=0 then //input semplice
                                begin           {OK: 1 solo valore inserito}
                                Val_Try(Stringa1,n,pos_err);
                                if IntToStr(n)<>stringa1 then pos_err:=1;
                                if (pos_err>0)or not ((n>=i)and(n<=ii)) then
                                             begin
                                             sonoro;
                                             gotoxy(1,riga_menu+4);
                                             write('                                              ');
                                             gotoxy(1,riga_menu+4);
                                             Continue;
                                             end;
                                m:=-1;
                                Exit;
                                end
                               else goto multiplo;
                     end
                   else
                     begin
                     multiplo:
                     stringa2:=trim(Copy_end(stringa3,pos1+1));
                     stringa1:=trim(Copy(stringa3,1,pos1-1));
                     Val_Try(Stringa1,n,pos_err);
                     if IntToStr(n)<>trim(Copy(stringa3,1,pos1-1)) then pos_err:=1;
                     if (pos_err>0) or not ((n>=i)and(n<=ii)) then
                        begin
                        sonoro;
                        gotoxy(1,riga_menu+4);
                        write('                                              ');
                        gotoxy(1,riga_menu+4);
                        Continue;
                        end;
                     Val_Try(Stringa2,m,pos_err);
                     if IntToStr(m)<>trim(Copy_end(stringa3,pos1+1)) then pos_err:=1;
                     if (pos_err>0) or not ((m>=i)and(m<=ii)) or (n>m) then
                        begin
                        sonoro;
                        gotoxy(1,25);
                        write('                                              ');
                        gotoxy(1,25);
                        Continue;
                        end;
                     Exit;
                     end;
       end;
until false;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Str_Int(var n:integer; i,ii:integer);  {per le stringhe --> integer}
var pos_err:word;
    stringa:string;
begin
gotoxy(1,riga_menu+4);
write('                                              ');
gotoxy(1,riga_menu+4);
textcolor(lightgreen);
stringa:=IntToStr(n);
repeat
 Si_No_Str(stringa);
 if stringa='' then
       begin
       n:=0;
       Exit;           {ESC}
       end
      else
       begin           {OK}
       Val_Try(Stringa,n,pos_err);
       if IntToStr(n)<>stringa then pos_err:=1;
       if (pos_err>0)or not ((n>=i)and(n<=ii)) then
                    begin
                    sonoro;
                    gotoxy(1,riga_menu+4);
                    write('                                              ');
                    gotoxy(1,riga_menu+4);
                    Continue;
                    end;
       Exit;
       end;
until false;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure M_speciale__Copia_Righe;      // update ver 2.30
var a:integer;
    s:string;
    val_da,val_a:int64;
begin
Da_A_graph;
colore;
ShowMouse;
val_da:=1;
val_a:=ymax;
if not Da_A_2(val_da,val_a,1,ymax,Lingue.get_txt(20){'Dalla riga: '},Lingue.get_txt(21){'Alla riga: '},Lingue.get_txt(112){'Copia il testo'}) then Exit;
if not Din_Mem_Free(val_a-val_da+1) then Exit;
nuovi_appunti(appunti_usato);
for a:=val_a downto val_da do
    begin
    s:=Copy_end(testo[a],2);
    if s='' then s:=#13;
    Appunti[appunti_usato].input(s);
    end;
stato_appunti.nuovo_stato_appunti(1);  // ver 2.53
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function Da_A_2(var val_da,val_a:int64; min_da,max_a:int64; testo_da,testo_a,messaggio:shortstring):boolean;  { update ver 2.83 }
var tmp,posto_da,posto_a,old_stato_interno,stato_interno,stato:byte;
    insert,cliccato:boolean;
    stringa_da,stringa_a,c:shortstring;
    error:word;
begin
old_stato_interno:=0;
while length(testo_da)<12 do testo_da:=' '+testo_da;
while length(testo_a)<12 do testo_a:=' '+testo_a;
if min_da>max_a then exchange(min_da,max_a);
Da_A_2:=true;
insert:=false;
stato_interno:=1;
colore;
tmp:=byte(max(40-(length(messaggio)div 2),1));
gotoxy(tmp,riga_menu+1); //  senza TMP (cioe' direttamente col typecasting) il GOTO non funziona: strano
write(messaggio);
Pre_Tasti(35,riga_menu+2);
gotoxy(1,riga_menu+3);
write(testo_da,val_da);
gotoxy(1,riga_menu+4);
write(testo_a,val_a);
hidemouse;
ShowMouse;
stringa_da:=IntToStr(val_da);
stringa_a:=IntToStr(val_a);

repeat
 case stato_interno of
      3,4: begin
           if (PollKeyEvent=0) and topo then
               begin
               sleep(5);
               {$ifdef go32v2}
               cliccato:=Doppio_Click.Mouse_Up(mox,moy,stato);
               {$else}
               cliccato:=Doppio_Click.Mouse_Down(mox,moy,stato);
               {$endif}
               if cliccato then
                  begin
                  if (mox>34)and(mox<39)and(moy=riga_menu+2) then // ok
                           begin
                           if val_a<val_da then stato_interno:=1
                                           else break;
                           end else
                  if (mox>40)and(mox<46)and(moy=riga_menu+2) then exit(false) else
                  if (mox>12)and(mox<34)and(moy=riga_menu+3) then stato_interno:=1 else
                  if (mox>12)and(mox<34)and(moy=riga_menu+4) then stato_interno:=2;
                  end;
               end
              else
               begin
               c:=KeyEventToString(TranslateKeyEvent(GetKeyEvent));
               if length(c)=1 then c:=upcase(c);
               if (c=#27) then Exit(false) else
               if (c=#13)or(c=#32) then
                   begin
                   if stato_interno=4 then Exit(false);
                   if stato_interno=3 then
                      begin  // ok
                      if val_da>val_a then stato_interno:=1
                                      else exit;
                      end;
                   end else
               if (c=#9)or(c='Right')or(c='Down') then
                   begin
                   inc(stato_interno);
                   if stato_interno>4 then stato_interno:=1;
                   end else
               if (c='Left')or(c='Up')or(c='SHIFT Key with scancode 3840') then dec(stato_interno); // shift +tab
               end;
           if old_stato_interno<>stato_interno then
              begin
              old_stato_interno:=stato_interno;
              case stato_interno of
                   3: begin
                      gotoxy(34,riga_menu+2);
                      write('[');
                      gotoxy(39,riga_menu+2);
                      write(']');
                      gotoxy(40,riga_menu+2);
                      write(' ');
                      gotoxy(46,riga_menu+2);
                      write(' ');
                      cursorOff;
                      end;
                   4: begin
                      gotoxy(40,riga_menu+2);
                      write('[');
                      gotoxy(46,riga_menu+2);
                      write(']');
                      gotoxy(34,riga_menu+2);
                      write(' ');
                      gotoxy(39,riga_menu+2);
                      write(' ');
                      cursorOff;
                      end;
                   else
                      begin
                      gotoxy(34,riga_menu+2);
                      write(' ');
                      gotoxy(39,riga_menu+2);
                      write('  ');
                      gotoxy(46,riga_menu+2);
                      write(' ');
                      cursorOn;
                      end;
                   end; // del case
              end;
           end;
      1: repeat
          gotoxy(13,riga_menu+3);
          stringa_da:=ReadString(stringa_da,13,33,0,topo,true,mancino,insert,moy,mox,posto_da);
          if (mox=27)and(moy=0)and(stringa_da='') then exit(false);
          if (mox=7) and (moy=0) then stato_interno:=4 else
          if ((mox=13)or(mox=9)) and(moy=0)and(stringa_da='') then
                                  begin
                                  stringa_da:=IntToStr(val_da);
                                  write(stringa_da);
                                  hidemouse;
                                  showmouse;
                                  end;
          Val_Try(stringa_da,val_da,error);
          if (error>0)or(val_da<min_da)or(val_da>max_a) then
                 begin
                 error:=1;
                 sonoro;
                 Continue;
                 end;
          if ((mox=13)or(mox=9)) and(moy=0) then stato_interno:=2 else
          if (mox>34)and(mox<39)and(moy=riga_menu+2) then // ok
              begin
              if val_da>val_a then stato_interno:=1
                              else exit;
              end else
          if (mox>40)and(mox<46)and(moy=riga_menu+2) then exit(false) else
          if (mox>12)and(mox<34)and(moy=riga_menu+3) then stato_interno:=1 else
          if (mox>12)and(mox<34)and(moy=riga_menu+4) then stato_interno:=2;
         until error=0;
      2: repeat
          gotoxy(13,riga_menu+4);
          stringa_a:=ReadString(stringa_a,13,33,0,topo,true,mancino,insert,moy,mox,posto_a);
          if (mox=27)and(moy=0)and(stringa_a='') then exit(false);
          if ((mox=13)or(mox=9)) and(moy=0)and(stringa_a='') then
          if stringa_a='' then
                          begin
                          stringa_a:=IntToStr(val_a);
                          write(stringa_a);
                          hidemouse;
                          showmouse;
                          end;
          Val_Try(stringa_a,val_a,error);
          if (error>0)or(val_a>max_a)or(val_a<min_da) then
                 begin
                 error:=1;
                 sonoro;
                 Continue;
                 end;
          if ((mox=13)or(mox=9)) and(moy=0) then stato_interno:=3 else
          if (mox=7) and (moy=0) then stato_interno:=1 else
          if (mox>34)and(mox<38)and(moy=riga_menu+2) then
              begin  // ok
              if val_da>val_a then stato_interno:=1
                              else exit; // add ver 2.87
              end else
          if (mox>40)and(mox<46)and(moy=riga_menu+2) then exit(false) else
          if (mox>12)and(mox<34)and(moy=riga_menu+3) then stato_interno:=1 else
          if (mox>12)and(mox<34)and(moy=riga_menu+4) then stato_interno:=2;
         until error=0;
      end;  // del case
until false;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Copia_Selezione_non_quadrata;  // update ver 2.30
var a:integer;
    app:string;
begin
nuovi_appunti(appunti_usato);
if (selezionato.y1<>selezionato.y2) then
   begin
   app:=testo[selezionato.y2];
   if (length(app)>1) then app:=copy(app,1,selezionato.x2+1);
   Appunti[appunti_usato].input(copy_end(app,2));
   for a:=selezionato.y2-1 downto selezionato.y1+1 do Appunti[appunti_usato].input(copy_end(testo[a],2));
   app:=testo[selezionato.y1];
   if (length(app)>1) then delete(app,1,selezionato.x1);
   Appunti[appunti_usato].input(app);
   end
  else
   if (selezionato.x1<>selezionato.x2) then
       begin    { (selezionato.y1=selezionato.y2) }
       app:=testo[selezionato.y1];
       if length(app)>1 then app:=copy(app,1,selezionato.x2+1);
       delete(app,1,selezionato.x1);
       if (app='')and (not binario) then app:=#13; // ho selezionato un invio   update ver 1.85
       Appunti[appunti_usato].input(app);
       end
      else  //  (selezionato.x1=selezionato.x2) and (selezionato.y1=selezionato.y2)
       begin
       app:=copy(testo[selezionato.y1],selezionato.x2+1,1);
       if app='' then app:=#13;
       Appunti[appunti_usato].input(app);
       end;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Copia_Selezione_quadrata; // ver 2.25
var a:integer;
begin
nuovi_appunti(appunti_usato);
for a:=selezionato.y2 downto selezionato.y1 do
    if selezionato.x1<selezionato.x2 then Appunti[appunti_usato].input(copy(testo[a],selezionato.x1+1,selezionato.x2-selezionato.x1+1))
                                     else Appunti[appunti_usato].input(copy(testo[a],selezionato.x2+1,selezionato.x1-selezionato.x2+1));
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure M_modifica__Copia_Selezione;
begin
if selezionato.x1=0 then
       begin
       no_selezione;
       exit;
       end;
if not Din_Mem_Free(selezionato.y2-selezionato.y1+1) then Exit;
if selezione_quadrata then Copia_Selezione_quadrata
                      else Copia_Selezione_non_quadrata;
stato_appunti.nuovo_stato_appunti(1);  // ver 2.53
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Convert(var stringa:string);
var i:integer;  // inserisce #13 (invio) dove e' necessario, per ctrl des/sin
    v:char;
const Insieme = ['0'..'9','a'..'z','A'..'Z'];
begin
if stringa=#13 then stringa:=#13+'X'
               else stringa:=Copy(stringa,1,length(stringa)-1)+#13+'X';
i:=0;
repeat
 inc(i);
 if stringa[i] in Insieme then
    else stringa[i]:=#13;
 if (i>1) and (stringa[i] in Insieme) and (stringa[i-1] in Insieme) then
    repeat
     v:=UpCase(stringa[i]);
     if v in Insieme then stringa[i]:=#13
                     else dec(i,2);
     inc(i);
    until not(v in Insieme)or(i>length(stringa));
until i>=length(stringa);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function Dim_File:longint;
var b:longint;
    i:integer;
begin
b:=0;
for i:=1 to ymax do if binario then b:=b-1+length(testo[i])
                               else b:=b+1+length(testo[i]);
Dim_File:=b;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function Free:boolean;
begin
if SysUtils.diskfree(0)>Dim_File then free:=true
                                 else free:=false;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Hd_Low;
begin
pulisci1;
gotoxy(1,riga_menu+1);
writeln(Lingue.get_txt(113)); // 'Spazio su disco insufficiente per salvare il file: '
textbackground(red);
write(nomeLungo(TruncPath(percorso+nomefile,70),70));
textbackground(blue);
gotoxy(1,riga_menu+3);
write(Lingue.get_txt(114){'Liberare almeno '},Dim_Punto(Dim_File),Lingue.get_txt(115){' byte sull''unita'' e riprovare.'});
Esc;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure M_Stampa__Numero_Copie;    {out: copie}
var new_copie:integer;
{$define max_copie:=100} // oppure const max_copie=100;
begin
da_a_graph;
gotoxy(1,riga_menu+3);
write(Lingue.get_txt(116)+' (max ',max_copie,') :');  // 'Numero copie'
ShowMouse;
ShowMouse;
new_copie:=copie;
Str_int(new_copie,0,max_copie);
if new_copie<>0 then copie:=new_copie;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function Tasto__Ctrl_Fine():boolean; // posizionamento sul punto estremo del testo (maxX,maxY)
var old_x_riga,old_iy,old_y,old_x,old_x_min:integer;
begin
old_x_riga:=x_riga;
old_iy:=iy;
old_y:=y;
old_x:=x;
old_x_min:=x_min;
iy:=ymax;
y:=byte(min(riga_menu-1,iy));
x_riga:=length(testo[ymax]);
x:=byte(min(x_riga,80));
x_reale:=x;
x_min:=max(1,length(testo[ymax])-79);
result:=(old_iy<>iy)or(old_y<>y)or(old_x<>x)or(old_x_min<>x_min)or(old_x_riga<>x_riga);
if (old_iy<1+iy-riga_menu) and (not result) then
   begin
   gotoxy(x,y);
   Exit;
   end;
if result then Evidenzia_Selezione;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Tasto__Sinistra; {K sin}
var old_x_min:integer;
begin
old_x_min:=x_min;
if (x_riga=1)and(iy=1) then sonoro;
if x_riga>1 then
             begin
             x_riga:=x_riga-1;
             if x>1 then
                    begin
                    x:=x-1;
                    x_reale:=x
                    end
                   else
                    begin
                    if x_min>1 then x_min:=x_min-1;
                    end;
             end
            else
             if iy>1 then       { risale di una riga }
                begin
                dec(iy);
                dec(y);
                if y=0 then
                   begin
                   y:=1;
                   Evidenzia_Selezione;
                   end;
                Set_Cursore_X(length(testo[iy]));
                end;
if old_x_min<>x_min then Evidenzia_Selezione;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function ShellError():boolean; // ver 1.83
begin
pulisci1;
gotoxy(1,riga_menu+1);
writeln(Lingue.get_txt(117)); // 'File non salvato correttamente. Andare ugualmente in Shell ? '
Exit(Tasti_SN(35,riga_menu+3)='S');
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function AskSaveShell():char;
begin
pulisci1;
gotoxy(1,riga_menu+1);
writeln(Lingue.get_txt(118));  // 'Salvare il file prima di andare in Shell ?'
exit(Tasti_SNA(30,riga_menu+4));
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure ErrorTextMode;  // ver 1.83    al ritorno dalla Shell
begin
if (ScreenWidth<max_larghezza)or(ScreenHeight<riga_menu+4) then
    begin
    clrscr;
    writeln(Lingue.get_txt(119)); // 'Editor potrebbe non funzionare correttamente,'
    writeln(Lingue.get_txt(120),max_larghezza,Lingue.get_txt(121),min_righe_video,Lingue.get_txt(122)); // 'poiche'' non e'' stato eseguito nella modalita'' testo minima: '  ' colonne e '  ' righe.'
    writeln(Lingue.get_txt(123));  // 'Si consiglia di chiudere Editor, correggere il problema e riprovare.'
    write  (Lingue.get_txt(124));  // 'Premere un tasto per continuare ...'
    GetKeyEvent;
    end;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure M_opzioni__Configura1;  // configurazione EDITOR     update 1.82 , 1.84 , 2.69
{$define Stato_Cursore:=
          begin
          case stato_ of
             1: gotoxy(45,4);
             2: gotoxy(45,5);
             3: gotoxy(45,6);
             4: gotoxy(45,7);
             5: gotoxy(45,8);
             6: gotoxy(45,10);
             7: gotoxy(45,11);
             8: gotoxy(45,12);
             9: gotoxy(57,15);
            10: gotoxy(57,16);
            11: gotoxy(57,17);
            12: gotoxy(57,18);
            13: gotoxy(57,21);
            14: gotoxy(57,22);
            15: gotoxy(57,23);
            end;
          cursorON;
          end  }
{$define stato_OK:=
         begin
         gotoxy(34,25);
         write(' ');
         gotoxy(39,25);
         write('  ');
         gotoxy(46,25);
         write(' ');
         end; }
{$define assegna_stato:=
           begin
           if c[1] = Lingue.get_charUp(137) then stato_:=9 else  // 'E'
           if c[1] = Lingue.get_charUp(138) then stato_:=10 else // 'T'
           if c[1] = Lingue.get_charUp(139) then stato_:=11 else // 'C'
           if c[1] = Lingue.get_charUp(140) then stato_:=12 else // 'P'
           if c[1] = Lingue.get_charUp(142) then stato_:=13 else // 'A'
           if c[1] = Lingue.get_charUp(143) then stato_:=14 else // 'X'
           if c[1] = Lingue.get_charUp(144) then stato_:=15 else // '/'
           if c[1] = Lingue.get_charUp(131) then stato_:=5 else  // 'N'
           if c[1] = Lingue.get_charUp(133) then stato_:=6 else  // 'M'
           if c[1] = Lingue.get_charUp(129) then stato_:=3 else  // 'R'
           if c[1] = Lingue.get_charUp(130) then stato_:=4 else  // 'B'
           if c[1] = Lingue.get_charUp(128) then stato_:=2 else  // 'L'
           if c[1] = Lingue.get_charUp(127) then stato_:=1;      // 'S'
           end; }
var cliccato,old_bk,old_sl,old_CL,old_sfinal,old_unoS,insert,modifica_configura1:boolean;
    old_est_note,old_est_non_note:char;
    posto,posto2,posto1,stato_:byte;
    old_next_length_ESA,old_next_length_TXT:integer;
    error:word;
    stringa,c:shortstring;
    old_max_righe,i:longint;
const tasto_ok=16;
label theMouse,tasti,read_uscita;
begin
modifica_configura1:=true;
hidemouse;
stato_:=tasto_ok;
cursoroff;
textcolor(lightred);
textbackground(blue);
clrscr;
gotoxy(40-Lingue.get_length_txt(125) div 2,1);
writeln(Lingue.get_txt(125)+invio); //  'Configurazione 1 di Editor'

textcolor(white);
writeln(Lingue.get_txt(126)); // 'Impostazioni valide solo per il formato testo:'
writeln(Lingue.get_txt(127)); // '- Salva anche gli spazi finali             [ ]'
writeln(Lingue.get_txt(128)); // '- Consenti cursore libero                  [ ]'
writeln(Lingue.get_txt(129)); // '- Lascia un solo spazio fra parole         [ ]'
writeln(Lingue.get_txt(130)); // '- Salva creando il file di backup (.BAK)   [ ]'
writeln(Lingue.get_txt(131),dim_punto(ymax),' ,'); // '- Numero massimo di righe utilizzabili     [        ]  (minimo '
writeln(Lingue.get_txt(132),' 6.000)'); // '                                                        suggerito'
// Se diminuito, l''annulla precedente non sara'' possibile.
gotoxy(1,10);
// Impostazioni valide per entrambi i formati
writeln(Lingue.get_txt(133));  // '- Modalita'' sola lettura                   [ ]     (disattiva cursore libero)'
writeln(Lingue.get_txt(134));  // '- Lunghezza della riga nel formato TXT     [    ]  (da 1 a 254, suggerito 254)'
writeln(Lingue.get_txt(135));  // '- Lunghezza della riga nel formato ESA     [    ]  (da 1 a 254, suggerito 79)'
writeln;
writeln(Lingue.get_txt(136));  // '- Associa le estensioni note con il formato'
writeln(Lingue.get_txt(137));  // '                                       esadecimale ESA ( )'
writeln(Lingue.get_txt(138));  // '                                       testo TXT       ( )'
writeln(Lingue.get_txt(139));  // '                                       chiedi ESA/TXT  ( )'
writeln(Lingue.get_txt(140));  // '                                       predefinito     ( )'
writeln;
writeln(Lingue.get_txt(141));  // '- Associa le estensioni non note con il formato'
writeln(Lingue.get_txt(142));  // '                                       esadecimale ESA ( )'
writeln(Lingue.get_txt(143));  // '                                       testo TXT       ( )'
writeln(Lingue.get_txt(144));  // '                                       chiedi ESA/TXT  ( )'
gotoxy(34,25);
write('[    ]');
showmouse;
Pre_Tasti(35,25);
old_bk:=bk;     {salvo i valori prima di modificarli}
old_sl:=sl;
if mem_automatica then max_righe:=length(testo)-2;
old_max_righe:=max_righe;
old_next_length_TXT:=next_length_TXT;
old_next_length_ESA:=next_length_ESA;
old_CL:=CL;
old_sfinal:=sfinal;
old_unoS:=unoS;
old_est_note:=est_note;
old_est_non_note:=est_non_note;
Estensioni_note(#0);
Estensioni_non_note(#0);
textcolor(13);
gotoxy(Lingue.get_pos_rosso(127),4);
write(Lingue.get_char(127));  // S
gotoxy(Lingue.get_pos_rosso(128),5);
write(Lingue.get_char(128));  // l
gotoxy(Lingue.get_pos_rosso(129),6);
write(Lingue.get_char(129));  // r
gotoxy(Lingue.get_pos_rosso(130),7);
write(Lingue.get_char(130));  // b
gotoxy(Lingue.get_pos_rosso(131),8);
write(Lingue.get_char(131));  // N
gotoxy(Lingue.get_pos_rosso(133),10);
write(Lingue.get_char(133));  // M
gotoxy(Lingue.get_pos_rosso(134),11);
write(Lingue.get_char(134));  // g
gotoxy(Lingue.get_pos_rosso(135),12);
write(Lingue.get_char(135));  // h
gotoxy(Lingue.get_pos_rosso(137),15);
write(Lingue.get_char(137));  // e
gotoxy(Lingue.get_pos_rosso(138),16);
write(Lingue.get_char(138));  // t
gotoxy(Lingue.get_pos_rosso(139),17);
write(Lingue.get_char(139));  // c
gotoxy(Lingue.get_pos_rosso(140),18);
write(Lingue.get_char(140));  // p
gotoxy(Lingue.get_pos_rosso(142),21);
write(Lingue.get_char(142));  // A
gotoxy(Lingue.get_pos_rosso(143),22);
write(Lingue.get_char(143));  // X
gotoxy(Lingue.get_pos_rosso(144),23);
write(Lingue.get_char(144));  // /
insert:=false;
posto:=1;
posto1:=1;
posto2:=1;
Metti_X(45,7,BK);  {sono ripetuti per non annullare il vero valore}
Metti_X(45,7,BK);
Metti_X(45,6,UnoS);
Metti_X(45,6,UnoS);
Metti_X(45,5,CL);
Metti_X(45,5,CL);
Metti_X(45,4,sfinal);
Metti_X(45,4,sfinal);
Metti_X(45,10,SL);
Metti_X(45,10,SL);
gotoxy(45,8);
write(max_righe);
gotoxy(45,11);
write(next_length_TXT);
gotoxy(45,12);
write(next_length_ESA);
showmouse;
repeat
 if (PollKeyEvent=0) and topo then
           begin
           sleep(5);
           {$ifdef go32v2}
            cliccato:=Doppio_Click.Mouse_Up(mox,moy,stato);
           {$else}
            cliccato:=Doppio_Click.Mouse_Down(mox,moy,stato);
           {$endif}
           if cliccato then stato:=1
                       else stato:=0;
    theMouse:
           if (stato=1)and(moy= 7)and(mox=45) then
                                              begin
                                              Metti_X(45,7,BK);
                                              stato_OK;
                                              gotoxy(45,7);
                                              stato_:=4;
                                              end else
           if (stato=1)and(moy= 6)and(mox=45) then
                                              begin
                                              Metti_X(45,6,UnoS);
                                              stato_OK;
                                              gotoxy(45,6);
                                              stato_:=3;
                                              end else
           if (stato=1)and(moy= 5)and(mox=45) then
                                              begin
                                              Metti_X(45,5,CL);
                                              stato_OK;
                                              gotoxy(45,5);
                                              stato_:=2;
                                              end else
           if (stato=1)and(moy= 4)and(mox=45) then
                                              begin
                                              Metti_X(45,4,Sfinal);
                                              stato_OK;
                                              gotoxy(45,4);
                                              stato_:=1;
                                              end else
           if (stato=1)and(moy=10)and(mox=45) then
                                              begin
                                              Metti_X(45,10,SL);
                                              stato_OK;
                                              gotoxy(45,10);
                                              stato_:=6;
                                              end else
           if (stato=1)and(moy=15)and(mox=57) then
                                              begin
                                              Estensioni_note(Lingue.get_charUp(137){'E'});
                                              stato_OK;
                                              gotoxy(57,15);
                                              stato_:=8;
                                              end else
           if (stato=1)and(moy=16)and(mox=57) then
                                              begin
                                              Estensioni_note(Lingue.get_charUp(138){'T'});
                                              stato_OK;
                                              gotoxy(57,16);
                                              stato_:=9;
                                              end else
           if (stato=1)and(moy=17)and(mox=57) then
                                              begin
                                              Estensioni_note(Lingue.get_charUp(139){'C'});
                                              stato_OK;
                                              gotoxy(57,17);
                                              stato_:=10;
                                              end else
           if (stato=1)and(moy=18)and(mox=57) then
                                              begin
                                              Estensioni_note(Lingue.get_charUp(140){'P'});
                                              stato_OK;
                                              gotoxy(57,18);
                                              stato_:=11;
                                              end else
           if (stato=1)and(moy=21)and(mox=57) then
                                              begin
                                              Estensioni_non_note(Lingue.get_charUp(142){'A'});
                                              stato_OK;
                                              gotoxy(57,21);
                                              stato_:=12;
                                              end else
           if (stato=1)and(moy=22)and(mox=57) then
                                              begin
                                              Estensioni_non_note(Lingue.get_charUp(143){'X'});
                                              stato_OK;
                                              gotoxy(57,22);
                                              stato_:=13;
                                              end else
           if (stato=1)and(moy=23)and(mox=57) then
                                              begin
                                              Estensioni_non_note(Lingue.get_charUp(144){'/'});
                                              stato_OK;
                                              gotoxy(57,23);
                                              stato_:=14;
                                              end;
           if stato=1 then if stato_<tasto_ok then cursorON
                                              else cursorOFF;
           if (stato=1)and(mox>40)and(mox<46)and(moy=25) then  {ESC}
                     begin
                read_uscita:
                     modifica_configura1:=false;
                     bk:=old_bk;     {ripristino i valori originali}
                     sl:=old_sl;
                     max_righe:=old_max_righe;
                     next_length_TXT:=old_next_length_TXT;
                     next_length_ESA:=old_next_length_ESA;
                     CL:=old_CL;
                     sfinal:=old_sfinal;
                     unoS:=old_unoS;
                     est_note:=old_est_note;
                     est_non_note:=old_est_non_note;
                     Break;
                     end;
           if (stato=1)and(mox>34)and(mox<39)and(moy=25) then break;  {INVIO}
           if (stato=1)and(mox>44)and(mox<53)and(moy=8) then  // Numero righe
                   begin
                   stato_OK;
                   stato_:=5;
                   repeat
                    gotoxy(wherex,8);
                    stringa:=ReadString(IntToStr(max_righe),45,52,0,topo,true,mancino,insert,moy,mox,posto1);
                    if (mox=27)and(moy=0)and(stringa='') then
                               begin
                               updatescreen(true);
                               Evidenzia_Selezione;
                               goto read_uscita;
                               end;
                    if stringa='' then
                                  begin
                                  stringa:=inttostr(old_max_righe);
                                  write(stringa);
                                  hidemouse;
                                  showmouse;
                                  end;
                    Val_Try(stringa,max_righe,error);
                    if (error>0)or(max_righe<ymax) then
                                 begin
                                 error:=1;
                                 sonoro;
                                 Continue;
                                 end;
                    if moy=255 then  // ALT+?
                       // was   if char(mox) in ['E','T','C','P','A','/','X','M','R','B','L','S','H','G'] then
                       if upcase(char(mox)) in [Lingue.get_charUP(137){E},Lingue.get_charUP(138){T},Lingue.get_charUP(139){C},
                         Lingue.get_charUP(140){P},Lingue.get_charUP(142){A},Lingue.get_charUP(144){/},Lingue.get_charUP(143){X},Lingue.get_charUP(133){M},
                         Lingue.get_charUP(129){R},Lingue.get_charUP(130){B},Lingue.get_charUP(128){L},
                         Lingue.get_charUP(127){S},Lingue.get_charUP(135){H},Lingue.get_charUP(134){G}] then
                                    begin
                                    cursorOff;
                                    c:=char(mox);
                                    goto tasti;
                                    end
                                   else
                                    begin
                                    error:=1; // basta che sia <> da 0
                                    Continue;
                                    end;
                   until error=0;
                   stato:=bool(moy>0);
                   if (moy=0) and (mox=13) then break;
                   if (moy=0) and (mox=7) then // shift+tab
                                          begin
                                          stato_OK;
                                          stato_:=4;
                                          gotoxy(45,7);
                                          mox:=45;
                                          moy:=4;
                                          stato:=0;
                                          cursoron;
                                          end
                                         else
                   if (moy=0) and (mox=9) then
                                          begin
                                          stato_OK;
                                          stato_:=6;
                                          gotoxy(45,10);
                                          mox:=45;
                                          moy:=10;
                                          stato:=0;
                                          cursoron;
                                          end
                                         else
                                          cursoroff;
                   goto theMouse;
                   end;

           if (stato=1)and(mox>44)and(mox<49)and(moy=11) then  // lunghezza riga TXT
                   begin
                   stato_OK;
                   stato_:=6;
                   repeat
                    gotoxy(wherex,11);
                    stringa:=ReadString(IntToStr(next_length_TXT),45,48,0,topo,true,mancino,insert,moy,mox,posto);
                    if (mox=27)and(moy=0)and(stringa='') then
                               begin
                               updatescreen(true);
                               Evidenzia_Selezione;
                               goto read_uscita;
                               end;
                    if stringa='' then
                                  begin
                                  stringa:=inttostr(old_next_length_TXT);
                                  write(stringa);
                                  hidemouse;
                                  showmouse;
                                  end;
                    Val_Try(stringa,next_length_TXT,error);
                    if (error>0)or(next_length_TXT>254)or(next_length_TXT<1) then
                                 begin
                                 error:=1;
                                 sonoro;
                                 Continue;
                                 end;
                    if moy=255 then  // ALT+?
                       if upcase(char(mox)) in [Lingue.get_charUP(137){E},Lingue.get_charUP(138){T},Lingue.get_charUP(139){C},
                         Lingue.get_charUP(140){P},Lingue.get_charUP(142){A},Lingue.get_charUP(144){/},Lingue.get_charUP(143){X},Lingue.get_charUP(133){M},
                         Lingue.get_charUP(129){R},Lingue.get_charUP(130){B},Lingue.get_charUP(128){L},
                         Lingue.get_charUP(127){S},Lingue.get_charUP(135){H},Lingue.get_charUP(131){N}] then
                         // was   if char(mox) in ['E','T','C','P','A','/','X','M','R','B','L','S','H','N'] then
                                    begin
                                    cursorOff;
                                    c:=char(mox);
                                    goto tasti;
                                    end
                                   else
                                    begin
                                    error:=1; // basta che sia <> da 0
                                    Continue;
                                    end;
                   until error=0;
                   stato:=bool(moy>0);
                   if (moy=0) and (mox=13) then break;
                   if (moy=0) and (mox=7) then  // Shift+tab
                                          begin
                                          stato_OK;
                                          stato_:=6;
                                          gotoxy(45,10);
                                          mox:=45;
                                          moy:=10;
                                          stato:=1;
                                          cursoron;
                                          continue;
                                          end else
                   if (moy=0) and (mox=9) then
                                          begin
                                          stato_OK;
                                          stato_:=8;
                                          gotoxy(45,12);
                                          mox:=45;
                                          moy:=12;
                                          stato:=1;
                                          cursoron;
                                          end
                                         else
                                          cursoroff;
                   goto theMouse;
                   end;
           if (stato=1)and(mox>44)and(mox<49)and(moy=12) then  // lunghezza riga ESA
                   begin
                   stato_OK;
                   stato_:=8;
                   repeat
                    gotoxy(wherex,12);
                    stringa:=ReadString(IntToStr(next_length_ESA),45,48,0,topo,true,mancino,insert,moy,mox,posto2);
                    if (mox=27)and(moy=0)and(stringa='') then
                               begin
                               updatescreen(true);
                               Evidenzia_Selezione;
                               goto read_uscita;
                               end;
                    if stringa='' then
                                  begin
                                  stringa:=inttostr(old_next_length_ESA);
                                  write(stringa);
                                  hidemouse;
                                  showmouse;
                                  end;
                    Val_Try(stringa,next_length_ESA,error);
                    if (error>0)or(next_length_ESA>254)or(next_length_ESA<1) then
                                 begin
                                 error:=1;
                                 sonoro;
                                 Continue;
                                 end;
                    if moy=255 then  // ALT+?
                       if upcase(char(mox)) in [Lingue.get_charUP(137){E},Lingue.get_charUP(138){T},Lingue.get_charUP(139){C},
                         Lingue.get_charUP(140){P},Lingue.get_charUP(142){A},Lingue.get_charUP(144){/},Lingue.get_charUP(143){X},Lingue.get_charUP(133){M},
                         Lingue.get_charUP(129){R},Lingue.get_charUP(130){B},Lingue.get_charUP(128){L},
                         Lingue.get_charUP(127){S},Lingue.get_charUP(134){G},Lingue.get_charUP(131){N}] then
                         // was    if char(mox) in ['E','T','C','P','A','/','X','M','R','B','L','S','G','N'] then
                                    begin
                                    cursorOff;
                                    c:=char(mox);
                                    goto tasti;
                                    end
                                   else
                                    begin
                                    error:=1; // basta che sia <> da 0
                                    Continue;
                                    end;
                   until error=0;
                   stato:=bool(moy>0);
                   if (moy=0) and (mox=13) then break;
                   if (moy=0) and (mox=7) then // shift+tab
                                          begin
                                          stato_OK;
                                          stato_:=7;
                                          gotoxy(45,11);
                                          cursoron;
                                          continue;
                                          end else
                   if (moy=0) and (mox=9) then
                                          begin
                                          stato_OK;
                                          stato_:=9;
                                          gotoxy(57,15);
                                          cursoron;
                                          end
                                         else
                                          cursoroff;
                   goto theMouse;
                   end;
           end
          else
           begin
           c:=KeyEventToString(TranslateKeyEvent(GetKeyEvent));
           if (pos('SHIFT ',c)<>0)and(length(c)=7) then c:=upcase(c[7]);
           if from_alt_to_char(c)<>#0 then c:=from_alt_to_char(c);
           if length(c)=1 then c:=upcase(c);
           if c=#32 then
                    case stato_ of
                      6 : c:=Lingue.get_charUp(133); // 'M'
                      3 : c:=Lingue.get_charUp(129); // 'R'
                      4 : c:=Lingue.get_charUp(130); // 'B'
                      2 : c:=Lingue.get_charUp(128); // 'L'
                      1 : c:=Lingue.get_charUp(127); // 'S'
                      9 : c:=Lingue.get_charUp(137); // 'E'
                     10 : c:=Lingue.get_charUp(138); // 'T'
                     11 : c:=Lingue.get_charUp(139); // 'C'
                     12 : c:=Lingue.get_charUp(140); // 'P'
                     13 : c:=Lingue.get_charUp(142); // 'A'
                     14 : c:=Lingue.get_charUp(143); // 'X'
                     15 : c:=Lingue.get_charUp(144); // '/'
                     16 : c:=#13;
                     17 : c:=#27;
                    end;
  tasti:   if (c=#9) then
                    begin
                    inc(stato_);
                    if stato_>tasto_ok+1 then
                                 begin
                                 stato_:=1;
                                 gotoxy(40,25);
                                 write(' ');
                                 gotoxy(46,25);
                                 write(' ');
                                 end;
                    if stato_<tasto_ok then
                                  begin
                                  stato_cursore;
                                  if stato_=5 then
                                       begin
                                       c:=Lingue.get_charUP(131){'N'};
                                       stato:=1;
                                       mox:=45;
                                       moy:=8;
                                       goto theMouse;
                                       end;
                                  if stato_=7 then
                                       begin
                                       c:=Lingue.get_charUP(134){'G'};
                                       stato:=1;
                                       mox:=45;
                                       moy:=11;
                                       goto theMouse;
                                       end;
                                  if stato_=8 then
                                       begin
                                       c:=Lingue.get_charUP(135){'H'};
                                       stato:=1;
                                       mox:=45;
                                       moy:=12;
                                       goto theMouse;
                                       end;
                                  end
                                 else
                                  begin
                                  cursorOFF;
                                  if stato_=tasto_ok then
                                               begin
                                               gotoxy(34,25);
                                               write('[');
                                               gotoxy(39,25);
                                               write(']');
                                               end
                                              else // tasto ESC
                                               begin
                                               gotoxy(34,25);
                                               write(' ');
                                               gotoxy(39,25);
                                               write(' [');
                                               gotoxy(46,25);
                                               write(']');
                                               end;
                                  end;
                    end else
           if (c=#27) then
                    begin
                    stato:=1;
                    mox:=41;
                    moy:=25;
                    goto theMouse;
                    end else
           if (c=#13) then
                    begin
                    if stato_<>tasto_ok then break
                                  else
                                   begin
                                   stato:=1;
                                   mox:=41;
                                   moy:=25;
                                   goto themouse; {ESC}
                                   end;
                    end else
           if (upcase(c)=Lingue.get_charUP(127){'S'}) then Metti_X(45,4,sfinal)
                      else
           if (upcase(c)=Lingue.get_charUP(128){'L'}) then Metti_X(45,5,CL)
                      else
           if (upcase(c)=Lingue.get_charUP(129){'R'}) then Metti_X(45,6,unoS)
                      else
           if (upcase(c)=Lingue.get_charUP(130){'B'}) then Metti_X(45,7,BK)
                      else
           if (upcase(c)=Lingue.get_charUP(133){'M'}) then Metti_X(45,10,SL)
                      else
           if (upcase(c)=Lingue.get_charUP(134){'G'}) then
                      begin
                      stato:=1;
                      mox:=45;
                      moy:=11;
                      goto theMouse;
                      end else
           if (upcase(c)=Lingue.get_charUP(135){'H'}) then
                      begin
                      stato:=1;
                      mox:=45;
                      moy:=12;
                      goto theMouse;
                      end else
           if (upcase(c)=Lingue.get_charUP(131){'N'}) then
                      begin
                      stato:=1;
                      mox:=45;
                      moy:=8;
                      goto theMouse;
                      end;
           if length(c)=1 then
              begin
              // was  if (c[1] in ['E','T','C','P'])
              if upcase(c[1]) in [Lingue.get_charUP(137){E},Lingue.get_charUP(138){T},Lingue.get_charUP(139){C},
                          Lingue.get_charUP(140){P}] then Estensioni_note(c[1]);
              // was    if (c[1] in ['A','/','X']) then
              if upcase(c[1]) in [Lingue.get_charUP(142){A},Lingue.get_charUP(144){/},Lingue.get_charUP(143){X}] then Estensioni_non_note(c[1]);
              // was    if (c[1] in ['E','T','C','P','A','/','X','M','R','B','L','S']) then
              if upcase(c[1]) in [Lingue.get_charUP(137){E},Lingue.get_charUP(138){T},Lingue.get_charUP(139){C},
                          Lingue.get_charUP(140){P},Lingue.get_charUP(142){A},Lingue.get_charUP(144){/},Lingue.get_charUP(143){X},Lingue.get_charUP(133){M},
                          Lingue.get_charUP(129){R},Lingue.get_charUP(130){B},Lingue.get_charUP(128){L},
                          Lingue.get_charUP(127){S}] then
                                            begin
                                            stato_OK;
                                            assegna_stato;
                                            stato_cursore;
                                            end;
              assegna_stato;
              end;
           if (c='Down')or(c='Right') then
                          begin  // freccia giu'/destra  #80,#77
                          c:=#9;
                          goto tasti;
                          end else
           if (c='Up')or(c='Left')or(c='SHIFT Key with scancode 3840') then // shift+tab
                          begin // freccia su/sinistra  #72,#75
                          if stato_ in [tasto_ok,tasto_ok+1] then
                                 begin
                                 gotoxy(34,25);
                                 write(' ');
                                 gotoxy(39,25);
                                 write('  ');
                                 gotoxy(46,25);
                                 write(' ');
                                 end;
                          if stato_=2 then stato_:=tasto_ok+1
                             else if stato_=1 then stato_:=tasto_ok
                                  else dec(stato_,2);
                          c:=#9;
                          goto tasti;
                          end;
           end;
until false;
{$ifdef TxtVideo}
ForceUpdateXY(0,0,ScreenWidth*ScreenHeight);
SetTextColorXY(0,0,7,(riga_menu-1)*ScreenWidth);
SetBackColorXY(0,0,black,(riga_menu-1)*ScreenWidth);
WindowsBackColor(ScreenWidth-1,0,ScreenWidth-1,riga_menu-2,blue);
WindowsTextColor(ScreenWidth-1,0,ScreenWidth-1,riga_menu-2,white);
{$endif}
if modifica_configura1 then
      begin
      if SL then CL:=false; // ver 3.15
      if max_righe<old_max_righe then
         begin  // perche' annullando taglia/elimina, potrebbe non trovare righe disponibili
         Ripristina_Txt.Destroy;
         Ripristina_Selezione.Destroy;
         Annulla_Txt.destroy;
         Annulla_Esa.destroy;
         end;
      setlength(testo,max_righe+2); //  ver 2.73
      for i:=old_max_righe+2 to max_righe+1 do testo[i]:=#13; // azzera le nuove righe per sicurezza
      Editor_Ini.Set_modifica(modifica_configura1);
      Editor_Ini.Aggiorna('OPZIONI'{nome_gruppo},'/BK'{nome_tipo},boolToStr(bk));
      Editor_Ini.Aggiorna('OPZIONI','/SL',boolToStr(sl));
      Editor_Ini.Aggiorna('OPZIONI','Lunghezza_Riga_TXT',intToStr(next_length_TXT));
      Editor_Ini.Aggiorna('OPZIONI','Lunghezza_Riga_ESA',intToStr(next_length_ESA));
      Editor_Ini.Aggiorna('OPZIONI','/CL',boolToStr(cl));
      Editor_Ini.Aggiorna('OPZIONI','/SF',boolToStr(sfinal));
      Editor_Ini.Aggiorna('OPZIONI','/US',boolToStr(unos));
      end;
Evidenzia_Selezione;
stato:=0;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure stato_2a; // ver 1.84
begin
hidemouse;
textcolor(white);
gotoxy(25,riga_menu+3);
write('[');
gotoxy(30,riga_menu+3);
write('] ');
gotoxy(37,riga_menu+3);
write(' ');
cursorOff;
showmouse;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure stato_3a;   // ver 1.84
begin
hidemouse;
textcolor(white);
gotoxy(25,riga_menu+3);
write(' ');
gotoxy(30,riga_menu+3);
write(' [');
gotoxy(37,riga_menu+3);
write(']');
cursorOff;
showmouse;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure pulisci_quadre2;  // ver 1.84
begin
hidemouse;
textcolor(white);
gotoxy(25,riga_menu+3);
write(' ');
gotoxy(30,riga_menu+3);
write('  ');
gotoxy(37,riga_menu+3);
write(' ');
cursorOff;
showmouse;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure info_ricerca; // ver 2.25
var riga_inizio,colonna_inizio,riga_fine,colonna_fine:integer;
    x,y:byte;
begin   // simile ad un pezzo di "info"
if binario then Exit;
x:=whereX;
y:=whereY;
if sotto_ and (not selezione) then  // verso sotto e non selezione
   begin
   riga_inizio:=iy;
   colonna_inizio:=x_riga;
   riga_fine:=ymax;
   colonna_fine:=length(testo[riga_fine]);
   end else
if sotto_ and selezione then  // verso sotto e selezione
   begin
   riga_inizio:=selezionato.y1;
   colonna_inizio:=selezionato.x1;
   riga_fine:=selezionato.y2;
   colonna_fine:=selezionato.x2;
   end else
if (not sotto_) and selezione then  // verso sopra e selezione
   begin
   riga_inizio:=selezionato.y2;
   colonna_inizio:=selezionato.x2;
   riga_fine:=selezionato.y1;
   colonna_fine:=selezionato.x1;
   end else
if (not sotto_) and (not selezione) then  // verso sopra e non selezione
   begin
   riga_inizio:=iy;
   colonna_inizio:=x_riga;
   riga_fine:=1;
   colonna_fine:=1;
   end;
colore;
gotoxy(1,riga_menu+1);
write('                                         ');
gotoxy(1,riga_menu+1);
write(Lingue.get_txt(145));   // 'Da '
textcolor(yellow);
write(Lingue.get_txt(92));    // 'Pag.'
textcolor(white);
write(foglio(riga_inizio),' ');
textcolor(yellow);
write(Lingue.get_txt(93));    // 'Col.'
textcolor(white);
write(colonna_inizio,' ');
textcolor(yellow);
write(Lingue.get_txt(94));   // 'Riga '
textcolor(white);
write(riga_inizio);
gotoxy(1,riga_menu+2);
write('                                         ');
gotoxy(1,riga_menu+2);
write(Lingue.get_txt(149));   // 'A  '
textcolor(yellow);
write(Lingue.get_txt(92));    // 'Pag.'
textcolor(white);
write(foglio(riga_fine),' ');
textcolor(yellow);
write(Lingue.get_txt(93));    // 'Col.'
textcolor(white);
write(colonna_fine,' ');
textcolor(yellow);
write(Lingue.get_txt(94));    // 'Riga '
textcolor(white);
write(riga_fine);
textcolor(10);
gotoxy(x,y);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function Cerca(find:boolean; str:string; var posto:byte):string;     // update 1.84 , 2.25
var old_stato_,stato_,x,yy,lastD,lastU,max_stato:byte; {find: per cerca/sostituisci, tutto: se sostituire ovunque}
    c,app:string;              {per le stringhe da cercare}
    old_per_riga,old_selezione,old_ignora,old_sotto_,old_pint,old_jolly,old_sc,old_tutto,insert,cliccato:boolean;
begin
{$define MyExit:=begin
                 ignora:=old_ignora;
                 selezione:=old_selezione;
                 sotto_:=old_sotto_;
                 pInt:=old_pInt;
                 jolly:=old_jolly;
                 sc:=old_sc;
                 tutto:=old_tutto;
                 per_riga:=old_per_riga;
                 Exit('');
                 end }
{$define On_:=begin
             old_stato_:=stato_;
             pulisci_quadre2;
             cursoron;
             end; }
max_stato:=10;
app:=str;
if posto=0 then       // e' la prima volta che eseguo la maschera
   begin
   old_ignora:=ignora;
   old_sotto_:=sotto_;
   old_pInt:=pInt;
   old_selezione:=selezione;
   old_jolly:=jolly;
   old_sc:=sc;
   old_tutto:=tutto;
   old_per_riga:=per_riga;
   old_stato_:=0;
   stato_:=1;
   Metti_X(58,riga_menu+2,ignora);     {ALT+I}
   Metti_X(58,riga_menu+2,ignora);     {ALT+I}
   Metti_X(58,riga_menu+3,sotto_);     {ALT+V}
   Metti_X(58,riga_menu+3,sotto_);     {ALT+V}
   Metti_X(58,riga_menu+1,pInt);       {ALT+P}
   Metti_X(58,riga_menu+1,pInt);       {ALT+P}
   Metti_X(78,riga_menu+2,jolly);      {ALT+J}
   Metti_X(78,riga_menu+2,jolly);      {ALT+J}
   if find and (not binario) then
      begin
      Metti_X(78,riga_menu+4,per_riga);      {ALT+r}
      Metti_X(78,riga_menu+4,per_riga);      {ALT+r}
      Metti_X(78,riga_menu+1,sc);      {ALT+C}
      Metti_X(78,riga_menu+1,sc);      {ALT+C}
      end;

   if (selezionato.x1<>0)and not binario then Metti_X(78,riga_menu+3,selezione)   {ALT+S}
                                         else selezione:=false;
   if (selezionato.x1<>0)and not binario then Metti_X(78,riga_menu+3,selezione);  {ALT+S}
   if binario then
              begin
              gotoxy(65,riga_menu+1);
              write('               '); {cancella la scritta conteggio}
              end;
   Pre_Tasti(26,riga_menu+3);
   if not find then
               begin
               textcolor(white);
               gotoxy(Lingue.get_X(150),riga_menu+1);
               write(Lingue.get_txt(150));  // 'Ovunque   [ ]'
               textcolor(13);
               gotoxy(Lingue.get_pos_rosso(150),riga_menu+1);
               write(Lingue.get_char(150));
               Metti_X(78,riga_menu+1,tutto); {ALt+O}
               Metti_X(78,riga_menu+1,tutto); {ALt+O}
               end;
   gotoxy(1,riga_menu+4);
   colore;
   write('                              ');
   gotoxy(1,riga_menu+4);
   textcolor(10);
   textbackground(blue);
   write(app);
   insert:=false;
   yy:=40;
   posto:=length(app)+1;
   end;
if find then info_ricerca; // solo se e' ricerca (e non sostituisci),  mostra gli estremi della selezione
ShowMouse;
ShowMouse;
repeat
textcolor(lightgreen);
textbackground(blue);
c:=#1;
if stato_=1 then
     begin
     gotoxy(1,riga_menu+4);
     app:=ReadString(app,1,YY,0,topo,true,mancino,insert,lastD,lastU,posto);
     if lastD=255 then c:=upcase(char(lastU));
     if (lastU=7) and (lastD=0) then c:='Up'; // shift+tab
     end
    else
     if (PollKeyEvent<>0) or (not topo) then
                begin
                c:=KeyEventToString(TranslateKeyEvent(GetKeyEvent));
                if from_alt_to_char(c)<>#0 then c:=from_alt_to_char(c);
                if (pos('SHIFT ',c)<>0)and(length(c)=7) then c:=upcase(c[7]);
                if length(c)=1 then
                               begin
                               lastU:=ord(upcase(c[1]));
                               LastD:=0;
                               end
                              else
                               begin
                               lastU:=1;   // carattere non valido
                               LastD:=255;
                               end;
                end
               else
                begin
                {$ifdef  go32v2}
                 cliccato:=Doppio_Click.Mouse_Up(mox,moy,stato);
                {$else}
                 cliccato:=Doppio_Click.Mouse_Down(mox,moy,stato);
                {$endif}
                if cliccato then stato:=1
                            else stato:=0;
                if stato=1 then
                     begin
                     lastU:=mox;
                     lastD:=moy;  //  da aggiornare gotoxy e stato_
                     end
                    else
                     begin
                     lastU:=0;
                     lastD:=0;
                     end;
                end;
  if ((lastD=0)and(lastU=27)) or ((lastD=0)and(lastU=13)and(stato_=3)) or
     ((lastU>31)and(lastU<37)and(lastD=riga_menu+3)) then MyExit;      {ESC}
  if (lastD=0)and(lastU=13) then
     if stato_=3 then MyExit
                 else break;
  if (lastU=32)and(lastD=0) then  // spazio
      case stato_ of
           2: break;
           3: MyExit;
           4: Metti_X(58,riga_menu+1,pInt);   {ALT+P}
           5: Metti_X(58,riga_menu+2,ignora); {ALT+I}
           6: begin
              Metti_X(58,riga_menu+3,sotto_); {ALT+V}
              info_ricerca;
              end;
           7: begin
              if find and not binario then Metti_X(78,riga_menu+1,sc);  {ALT+C}
              if not find then Metti_X(78,riga_menu+1,tutto);           {ALT+O ovunque}
              end;
           8: Metti_X(78,riga_menu+2,jolly);  {ALT+J}
           9: if (selezionato.x1<>0)and not binario then
                                                    begin
                                                    Metti_X(78,riga_menu+3,selezione);  {ALT+S}
                                                    info_ricerca;
                                                    end;
           10: if find and (not binario) then Metti_X(78,riga_menu+4,per_riga);
           end;
  if (c='Up')or(c='SHIFT Key with scancode 3840') then  // freccia su  o  shift+tab
     begin
     old_stato_:=stato_;
     case stato_ of
        1: begin
           if find and (not binario) and (stato_=1) then stato_:=9;
           if ( (not find) or binario) and (stato_=1) then
                if selezionato.x1<>0 then stato_:=6
                                     else stato_:=7;   {ricerca per riga da saltare}
           end;
        8: if binario then stato_:=5
                      else stato_:=6;
       10: if selezionato.x1<>0 then stato_:=8
                                else stato_:=7;
       else dec(stato_,2);
       end;
     if stato_=0 then pulisci_quadre2;
     lastD:=0;
     lastU:=9;
     end;
  if (lastU>0)and(lastU<=59)and(riga_menu+4=lastD) then  // ver 2.20
     begin
     old_stato_:=stato_;
     stato_:=1;
     pulisci_quadre2;
     end;
  if ( (lastD=0)and(lastU=9) ) or (c='Down') then
     begin    // freccia giu' o tasto tab
     old_stato_:=stato_;
     inc(stato_);
     if binario and (stato_=7) then inc(stato_);  {conteggio}
     if (stato_=9) and (selezionato.x1=0) then inc(stato_);         // selezione
     if (stato_=10) and ( (not find) or binario) then inc(stato_);  // per riga
     if stato_>max_stato then stato_:=1;
     if (stato_>3) and (stato_<max_stato+1) then
        begin
        if old_stato_ in [2,3] then pulisci_quadre2;
        cursorOn;
        end;
     case stato_ of
          2: stato_2a;
          3: stato_3a;
          4: gotoxy(58,riga_menu+1);
          5: gotoxy(58,riga_menu+2);
          6: gotoxy(58,riga_menu+3);
          7: gotoxy(78,riga_menu+1);
          8: gotoxy(78,riga_menu+2);
          9: gotoxy(78,riga_menu+3);
         10: gotoxy(78,riga_menu+4);
          end;
     end;
  if (lastU>25)and(lastU<30)and(lastD=riga_menu+3) then Break;   {OK}
  if ( (lastD=riga_menu+2)and(lastU=58) ) or (upcase(c)=Lingue.get_charUp(396){'I'}) then
     begin
     On_;                          {ALT+I ignora}
     stato_:=5;
     gotoxy(58,riga_menu+2);
     Metti_X(58,riga_menu+2,ignora);
     end else
  if ((selezionato.x1<>0) and (not binario) and (not selezione_quadrata) ) and    // ver 2.25
     ( ( (lastD=riga_menu+3)and(lastU=78) ) or (upcase(c)=Lingue.get_charUp(398){'S'}) ) then
     begin
     On_;                          {ALT+S selezione}
     stato_:=9;
     Metti_X(78,riga_menu+3,selezione);
     info_ricerca;
     gotoxy(78,riga_menu+3);
     end else
  if ( (lastD=riga_menu+1)and(lastU=58) ) or (upcase(c)=Lingue.get_charUp(394){'P'}) then
     begin
     On_;                                  {ALT+P parola intera}
     stato_:=4;
     gotoxy(58,riga_menu+1);
     Metti_X(58,riga_menu+1,pInt);
     if jolly then Metti_X(78,riga_menu+2,jolly);  {disabilita Jolly}
     end else
  if ( (lastD=riga_menu+2)and(lastU=78) ) or (upcase(c)='J') then {ALT+J}
     begin
     stato_:=8;
     gotoxy(78,riga_menu+2);
     Metti_X(78,riga_menu+2,jolly);
     if pInt then Metti_X(58,riga_menu+1,pInt);  {disabilita pInt}
     end else
  if ( (lastD=riga_menu+3)and(lastU=58) ) or (upcase(c)=Lingue.get_charUp(397){'V'}) then
     begin                                           {ALT+V verso sotto}
     On_;
     stato_:=6;
     Metti_X(58,riga_menu+3,sotto_);
     info_ricerca;
     gotoxy(58,riga_menu+3);
     end else
  if (not find) and ( ( (lastD=riga_menu+1)and(lastU=78) ) or (upcase(c)=Lingue.get_charUp(150){'O'}) ) then
     begin                       {ALT+O ovunque}
     On_;
     stato_:=7;
     gotoxy(78,riga_menu+1);
     Metti_X(78,riga_menu+1,tutto);
     end else
  if find and (not binario) and ( ( (lastD=riga_menu+1)and(lastU=78) ) or (upcase(c)=Lingue.get_charUp(395){'C'}) )  then
     begin
     On_;
     stato_:=7;               {ALT+C conteggio}
     gotoxy(78,riga_menu+1);
     Metti_X(78,riga_menu+1,SC);
     end else
  if find and (not binario) and ( ( (lastD=riga_menu+4)and(lastU=78) ) or (upcase(c)=Lingue.get_charUp(540){'r'}) )  then
     begin
     On_;
     stato_:=10;         {ALT+R Per riga}
     gotoxy(78,riga_menu+4);
     Metti_X(78,riga_menu+4,per_riga);
     end;

until false;
gotoxy(1,riga_menu+4);
textbackground(blue);
cerca:=app;
app:='';
for x:=1 to 63 do app:=app+' ';
write(app);
if pInt then cerca:=Trim(cerca);
if jolly and find then if Pos('?',cerca)=0 then jolly:=false;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function riga_menu():byte;  // ver 2.20
begin
Exit(max_righe_video-4);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function undo__x_prepara():string;
begin
result:=char(x)+char(x_min);
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure undo__x_ripristina(s:string);
var add:byte;
begin  // posizione 2= X, posizione 3=x_min . Si suppone che la riga abbia lunghezza valida
x:=ord(s[2]);
if x>80 then
         begin
         add:=x-80;
         x:=80;
         end
        else add:=0;
x_min:=byte(ord(s[3])+add);
x_riga:=x_min+x-1;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure Svuota_Tastiera;
begin
while PollKeyEvent<>0 do GetKeyEvent;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

end.

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

Versione:    Data:     Righe:   Modifica:

2.2.0      07/10/04    4668     inserita tutta la stampa
2.1.0      12/10/03    4419     5rimosso mantieni_sfondo;
2.0.0      27/04/03      ?      inizio conversione;
1.8.4      11/07/02    4771     opzioni lanciabili dal prompt anche nel .ini;
1.8.4      13/06/02    4300     con TIPO (poi rinominato come Configura);
1.8.3      26/05/02    3832     menu con Y fissa;
1.8.3      16/05/02    3090     con ShellError,AskSaveShell;
1.8.3      06/05/02    3052     con nomeLungo;
1.8.1      13/02/02    2400     con mantieni_sfondo;
1.8.1      28/01/02    2327     con Frequenza, Ritardo, MouseOrizzontale/Verticale per Editor.Ini;
1.8.1      23/12/01    2105     per la versione 1.8.1 : con opzioni /DM e /-DM;
1.8.0      14/12/01    2105     per la versione 1.8.0 : con annulla;
1.6.0      28/08/01    1816     per la versione 1.6.0 : velocizzata;
1.5.5      19/08/01    1780     per la versione 1.5.5;
1.068.031  29/03/01    1605     con open_error 1 2 3 4;
1.062.030  10/03/01    1574     4senza cerco_lungo, mouse25;
1.062.029  07/03/01    1611     3continuo con SFGLF16: elimino Extra_Percorso;
1.062.028  05/03/01    1627     2continuo con SFGLF16: elimino correggi_nome;
1.062.027  04/03/01    1672     1inizio con SFGLF16: elimino le parti del TEMPO: tempo,cornicetta;
1.062.026  13/10/00    1720     con funzione Tasti_SN/A + Select;
1.062.025  20/07/00    1310     con Ord32_255,Mouse25;
1.061.024  19/07/00    1245     con ASCII;
1.060.023  11/07/00    1103     con Azzera,Scambio;
1.058.022  01/07/00    1070     con FindFirstJolly;
1.057.021  16/06/00    1060     con Open_Error,Metti_X;
1.055.020  09/06/00    1031     con Anteprima_Stampa,StampaM,Print_Now;
1.054.017  08/06/00     927     con Err_Vai_Blocco;
1.053.016  07/06/00     913     con stampa;
1.03*.015  06/06/00     898     con Modif,Da_A_Graph,Barra_Verticale;
1.03*.014  01/06/00     841     con dos_file;
1.03*.013  28/05/00     816     con var posm;
1.03*.012  27/05/00     767     con var binario;
1.03*.011  26/05/00     745     con Need_Save;
1.03*.010  20/05/00     733     con NoSaveBin;
1.03*.009      ?        712     continuo con solo messaggi;
1.03*.008  25/04/00     629     continuo legati ad ESC;
1.03*.007  23/04/00     605     con legati ad ESC;
1.023.006  14/03/00     377     con BinSfinal;
1.022.005  06/03/00     377     con solo valori;
1.019.004  19/01/00     285     con solo messaggi;
1.012.003  16/01/00     185     con writeLbin,writeBin;
1.010.002  08/12/99     174     solo per Editor.pas;
  ...        ...        ...       ...
1.000.001  12/09/99      ?      inizio.
