; *** mini-gestionnaire de clavier franais *** (Ninho)
; inspir par: *** deutscher tastaturtreiber *** (Japheth)

; *** Resident part

; ! This module MUST be linked LAST (as in link KBINST+KBRES) !

; *** Summary, main mods from KeybGR :
; #1 and 2 could/should be backported to Keybgr too.

; 1. Fixed Numpad '/' key
; 2. Fixed (relocated) keys in ALT state
; 3. Changed translation tables, added new ones
; 4. Ditched Numpad '.' processing
; 5. Ctrl+French comma : no effect (was returning control M)
; 6. Dead key circumflex/diaeresis

; 8. removed old dev driver stuff
; 9. chain int 15/4F on Control Alt DEL (only)
;10. New memory scheme (cf. inst module).
;11. int15/8FF4 scheme for communication w/ resident (1.95)
;12. Use int 16/05 for stuffing key into BIOS's buffer
;13. Int 15 entry now at the start, to ease future compatibility

; 0. WONTDO: old typewriter mode for CapsLock/Shift.

; -----------------------------------------------
		.286
 KBRES SEGMENT PUBLIC PARA 'code' 

 include kbfr.inc

; -------------------
introu15 proc far
; Info: this is at the start to help make our protocol resilient to changes.

         PUSHF  ; inherited flags preserved as a service for ...
                ; ...others checking Cy on entry (they shoudln't)
         STI    ; let breathe
         CMP     AX, 8FF4h       ; is our API being called ?

;  Next 'jne' can have its displacement modified dynamically !
kon = offset not8FF4  -offset vjne -2   ; used by inst/comm module
koff= offset ch15popf -offset vjne -2
kvar EQU this byte +1
PUBLIC kvar
vjne:   jne      not8FF4  ; change to 'jne ch15popf' to disable Fr tanslation !

; ---------------------------------------------------------------------

; here our private protocol int15/AX=8FF4 API v0.0 (KB 1.95+)
        cmp     BX, 1     ; KB TSR id
        jne     ch15popf  ; chain (future TSRs sharing this API ?)
        POP     AX        ; balance stack
        mov     BX, CS    ; return resident segment
        mov     AX, 0100h ; AH=TSRid; AL=API level
        IRET
; ---------------------------------------------------------------------

not8FF4:
        cmp     AH, 4Fh
        je      i154F
; chaining to previous int 15 handler(s) :
ch15popf: POPF          ; others may....
          CLI           ; .... depend on this
        db      0EAh    ; JMP far -> previous handler
orgint15 dd     0

; ---------------------------------------------------------------------
; int 15/4F :   examine scan code
i154F:
        POPF        ; balance stack
; Fast IRET to the BIOS on 'release' type events
        cmp     AL, 80h
        jnb     FastIret

; also fast IRET on Shift & Capslock
        cmp     al,36h  ; RShift
        je      FastIret
        cmp     al,2Ah  ; LShift
        je      FastIret
        cmp     al,3Ah  ; CAPS
        je      FastIret

; else go examine & translate scan code
        pusha
        mov     bp,sp
        push    es
        push	ds
        push    40h
        pop     ds
       call    trans    ; or inline TODO
        pop     ds
        pop     es
        popa
FastIret: iret

;-------  Tables :  ---------------------------------------------------


;--- AltGr keys

altgrkeytab label byte
       db 03h           ;2 -> ~
       db 04h           ;3 -> #
       db 05h           ;4 -> {
       db 06h           ;5 -> [
       db 07h           ;6 -> |
       db 08h           ;7 -> `
       db 09h           ;8 -> \
       db 0Ah           ;9 -> ^
       db 0Bh           ;0 -> @
       db 0Ch           ;) -> ]
       db 0Dh           ;] -> }
ALTGRTABSIZ equ $ - altgrkeytab
       db '~'
       db '#'
       db '{'
       db '['
       db '|'
       db '`'
       db '\'
       db '^'
       db '@'
       db ']'
       db '}'

;--- control, standard & alt ; Collapsed tables!
ctrlkeytab label byte   ; original controls,
alttrans label byte     ; translated alts
       db 1Eh
       db 2Ch
       db 10h
       db 32h
       db 11h
       db 27h
CTRLTABSIZ equ $ - ctrlkeytab ; translated controls, *ASCII*
       db 17 ;base 10 ! ; Ctl Q
       db 23            ; Ctl W
       db 01            ; Ctl A
       db 0FEh          ; Ctl ',' shall be dropped!
       db 26            ; Ctl Z
       db 13            ; Ctl M

stdkeytab label byte
altkeytab label byte    ; shared 6 bytes from stdkeytab
       db 10h            ;A, Am. Q
       db 11h            ;Z, Am. W
       db 1eh            ;Q  Am. A
       db 27h            ;M  Am. ';'
       db 2Ch            ;W  Am. Z
       db 32h            ;,? Am. M ; moved for new ALT process
ALTTABSIZ equ $ - altkeytab

       db 02h            ;1
       db 03h            ;2
       db 04h            ;3
       db 05h            ;4
       db 06h            ;5
       db 07h            ;6
       db 08h            ;7
       db 09h            ;8
       db 0ah            ;9
       db 0bh            ;0
       db 0ch            ;)

       db 1bh            ;$
       db 28h            ;%
       db 29h            ;
       db 2Bh            ;*

       db 33h            ;;.
       db 34h            ;:/
       db 35h            ;!
       db 56h            ;<>
STDTABSIZ equ $ - stdkeytab

       db 'a'
       db 'z'
       db 'q'
       db 'm'
       db 'w'
L02B3X label byte        ;CAPS-LOCK insensitive keys
       db ','

       db '&'
       db ''
       db '"'
       db "'"
       db '('
       db '-'
       db ''
       db '_'
       db ''
       db ''
       db ')'

       db '$'
       db ''
       db ''
       db '*'
       db ';'
       db ':'
       db '!'
       db '<'

       db 'A'
       db 'Z'
       db 'Q'
       db 'M'
       db 'W'
       db '?'

       db '1'
       db '2'
       db '3'
       db '4'
       db '5'
       db '6'
       db '7'
       db '8'
       db '9'
       db '0'
       db ''

       db ''
       db '%'
       db ''           ; define as shifted 
       db ''
       db '.'
       db '/'
       db ''
       db '>'

compkeytab label byte   ; compositions using circumflex or diaeresis
       db 10h   ; Fr. A
       db 18h   ; O
       db 16h   ; U
; the above 3 combine w/ diaeresis in UPPERCASE also
nbUcomp      equ $ - compkeytab
       db 12h   ; E
       db 17h   ; I
       db 15h   ; Y
       db 39h   ; space bar, combines (case insensitive)
COMPTABSIZ  equ $ - compkeytab

       db ""
       db ""
       db ""
       db ""
       db ""
       db 0FFh  ; y (drop circumflex)
       db "^"

       db ""
       db ""
       db ""
       db ""
       db ""
       db ""
       db 0F9h  ; "" median dot
; uppercases + diaeresis:
       db ""
       db ""
       db ""
; note: none uppercase-cum-circumflex.

introu15 ENDP
;----------------------------------------------------------------------

trans   proc near
        assume ds:BIOSSEG
; here we only process 'make' codes : al < 80h
        mov     dx,word ptr [kbdstat1]
        CLD
        push    cs
        pop     es
        mov     bh, [kbdflgs]

deadsc  equ     1ah ; scancode for Fr. dead circumflex/diaeresis
        cmp     al, deadsc; 'dead' key made ?
        jnz     notdeadk

        test    dl,3    ; lookup shift state
        jz      @F
        and     [Cflags], not 1
        or      [Cflags],2 ; now in diaeresis state
dontsav1:   jmp dontsave   ; done, return to BIOS
@@:     and     [Cflags], not 2
        or      [Cflags],1 ; now in circumflex state
        jmp     dontsav1   ; done

notdeadk:
        test    [Cflags],3 ; in dead key state ?
        jz      normstate

;       Process key in 'dead key' state :
; modal keys (shift,caps): eliminated earlier, don't change d.k. state.
; regular key:
; - if in ALT,ALTGR or CTRL state, cancel dead key state & proceed.
; - else scan table of compositions :
;  = if found, save translation to buffer (considering shift/caps state!)
;  = else cancel dead key state & process in regular state.

        test    dl,0Ch          ; in ctrl or alt states ?
        jnz     canceldk        ; skip if so.

        mov     CX,COMPTABSIZ   ; composed characters table
        mov     DI, offset compkeytab
        repne   scasb
        jne     canceldk        ; skip if not in table

        mov     ah,[Cflags]
        test    ah,1            ; dieresis ? / circumflex ?
        jnz     @F              ; circumflex ,skip
        add     di,COMPTABSIZ   ; diresis...
@@:     jcxz    @F              ; case doesn't matter for space bar
        call    getcase         ; lower/upper ?
        jz      @F
        ; in upper case: only    can be made
        test    ah,1
        jnz     canceldk        ; if circumflex, cancel d.k. state & continue
        cmp     CL,(COMPTABSIZ-nbUcomp) ; ch=0
        jb      canceldk        ; cancel dk if not in A O U
        add     di,COMPTABSIZ   ; uppercase cum diaeresis...

@@:     mov     al,es:[di-1+COMPTABSIZ ] ; ASCII translation for compo.
        and     [Cflags],not 3  ; cancel deadkey state
        xor     ah,ah           ; pseudo scan code is zero
        jmp     stuffit         ; go update buffer

canceldk: and   [Cflags],not 3  ; cancel deadkey state
normstate:
; check for 'Control_Alt_Del', if so call along int 15 chain
        cmp     al, 53h ; DEL key being made ?
        jne     @F
        test    dl, 0Ch ; check Alt-Control status
        jpo     @F      ; -> either, not both
        jz      @F      ; -> none
        ; here is the 3-finger salute, call down the chain :
        push    ax      ; save scan code (we won't honor changes)
        stc             ; int 15/4F convention
        pushf
        call   es:[orgint15] ; simulate int to prev hooker
        pop     ax      ; cancel change they( might)'ve done
        jc      @F      ; onwards to our duty
        ; They cleared the Cy! We obey, returning w/o further processing:
        jmp     dontsave
@@:
        MOV     CX,ALTGRTABSIZ          ;ch=0!
        test    bh,08h                  ;right alt (altgr) pressed?
        jz      @F
        test    dx,0204h                ;any ctrl or alt-left pressed?
        jnz     @F
        MOV     DI,offset altgrkeytab
        jmp     scantabX
@@:
        test    dl,08h                  ;any alt pressed?
        jz      @F                      ;skip if NOT alt
        mov     DI,offset altkeytab
        mov     CL,ALTTABSIZ
        repne   scasb
        jne     exit             ; s.c. not in table, just feed it to the BIOS
        mov     AH,es:[di-1-(altkeytab - alttrans)]  ;fake key scan
        sub     AL,AL            ;set ASCII=zero
        JMP     found            ;save (key-down, else quit)

@@:
        MOV     DI,offset ctrlkeytab
        test    dl,04h                  ;any ctrl pressed?
        mov     CL,CTRLTABSIZ
        jnz     scantabX
        MOV     DI,offset stdkeytab
        MOV     cl,STDTABSIZ
        cmp     al,35h              ;numpad '/'?
        jnz     scantab
        test    bh,2                ;extended key (E0)?
        jz      scantab
        ret                         ;hand it back to the BIOS

scantabX:
        mov     dl,0                ;ignore shift state
scantab:
        push    cx
        repne   scasb
        pop     cx
        jne     exit
        dec     di
        add     di,cx

@@:
        cmp     di,offset L02B3X    ;caps lock sensitive?
        jnb     @F

        call    getcase
        jz      unorm1
        jmp     unorm2
@@:
        test    dl,3                ;shift pressed?
        jz      unorm1

unorm2:
        add     di,cx
unorm1:
        mov     ah,al
        mov     al,es:[di]
stuffit:
        cmp     al,0FEh
        ja      exit            ; FF= don't translate, let BIOS process it
        je      dontsave        ; FE= no character (drop!)
found:
        mov     CX, AX          ; Ask the AT-BIOS 
        mov     AH, 05          ; to stuff key into its buffer
        int     16h             ; rather than do it ourselves.

dontsave:                       ; clear BIOS's carry flag, tells it
        and   byte ptr [bp+8*2+2*2],not 1 ; to ignore returned code.
exit:
        ret     ; from 'trans'routine

; -----
getcase:        ; return CapsLock sensitive shift case ; trashes bl !
        mov     bl,dl
        test    dl,3            ;shift pressed?
        jz      @F
        xor     bl,40h          ;invert
@@:     test    bl,40h          ;caps lock?
        retn     ; ->Zeroflag: yes=lower, no=upper
; ----
trans   endp

EndOfInt15 label near
RSiz = 1+((offset EndofInt15)-offset IntRou15 -1)SHR 4
Public Rsiz
         KBRES ENDS
;----------------------------------------------------------------------
        PILE SEGMENT STACK 'stack'
        db      256 dup(?)
        PILE ENDS
;----------------------------------------------------------------------
end

