/*
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/* VER - displays the DOS version number, then quits. */

/* Copyright (C) 1994--1998 Jim Hall, jhall1@isd.net */

#include <stdio.h>
#include <stdlib.h>
#include "getopt.h"


/* Functions */

void usage (void);


/* the program */

int
main (int argc, char **argv)
{
  char c;
  int num_only = 0;				/* bool: show numbers only */

  /* Scan the command line */

  while ((c = getopt (argc, argv, "dDnN?")) != EOF) {
    switch (c) {
    case 'd':
    case 'D':
      /* Ignored, for compatibility */

      fprintf (stderr, "VER: The `D\' option is ignored\n");
      break;

    case 'n':
    case 'N':
      /* Numbers only */

      num_only = 1;
      break;

    default:
      usage ();
      exit (0);
      break;
    }
  }

  if ((argc - optind) > 0) {
    usage ();
    exit (1);
  }

  /* Display the version numbers */

  /* _osmajor and _osminor display the version numbers for DOS */

  if (!num_only) {
    printf ("DOS version ");
  }

  printf ("%u.%2.2u\n", _osmajor, _osminor);
  exit (0);
}
/* usage - print information on how to use the program */

void
usage (void)
{
  fprintf (stderr, "VER - displays your version of DOS\n");
  fprintf (stderr, "Usage:\n");
  fprintf (stderr, "\tVER [/D] [/N]\n");

  fprintf (stderr, "\t\t/D - DOS only.  (ignored, for compatibility.)\n");
  fprintf (stderr, "\t\t/N - Numbers only.  Do not print the string portion.\n");
}
