 ; This file is part of LBAcache, the 386/XMS DOS disk cache by
 ; Eric Auer (eric@coli.uni-sb.de), 2001-2003.

 ; LBAcache is free software; you can redistribute it and/or modify
 ; it under the terms of the GNU General Public License as published
 ; by the Free Software Foundation; either version 2 of the License,
 ; or (at your option) any later version.

 ; LBAcache is distributed in the hope that it will be useful,
 ; but WITHOUT ANY WARRANTY; without even the implied warranty of
 ; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ; GNU General Public License for more details.

 ; You should have received a copy of the GNU General Public License
 ; along with LBAcache; if not, write to the Free Software Foundation,
 ; Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 ; (or try http://www.gnu.org/licenses/licenses.html at www.gnu.org).

; LBAcache - a hard disk cache based on XMS, 386 only,
; and aware of the 64bit LBA BIOS Int 13 Extensions.
; GPL 2 software by Eric Auer <eric@coli.uni-sb.de> 2001-2003




; this is a silly UN-loader:
; It scans through the memory for instances of HDCACHE$ device
; headers, and if they have an XMS handle, it closes the handle
; after disabling the driver.
; If in addition the link to a COMCACHE signature is found, the
; MCB size is reduced to save some RAM.
; If - third case - even int 0x13 is found to be still pointing
; to the device, the oldint vector is restored and the RAM is
; completely freed.
; if an I option rather than an U option is given, will only
; show information and not unload the instances.


; new 01/2002: the F flush option: flush drives A..F ("eject media").
; new 01/2002: uncache is now part of the cache binary :-)
; new 08/2002: no waiting inside status display, dec/percent display
; new 11/2002: more messages and flushes A..J, no longer very suitable
;              for standalone (infolist uses labels, not numbers now).
; new 11/2002: two column output, redirectable, fixed percentage bug.
;              also worked on some crash: resizing MCBs changes owner
;              made output layout generally nicer :-)
;              Had to move messages IN FRONT because they may not be
;              at offset > 0x2000: the offset high bits are FLAGS for
;              pmessage... Could squeeze those flags, though. *******
;              Removed ability to run STANDALONE completely.

; -------------------------------------------------------------

crlfmsg21	db 13,10,"$",0
pmtabmsg21	db 9,"$",0

flushmsg	db "Flush mode - all other options ignored",13,10,"$",0
flushedmsg	db 13,10
		db "If there was a lbacache, it is now flushed",13,10
		db "for drives A..F (also tried to eject media)",13,10,"$"

noxmsmsg	db "XMS driver not found, not searching for caches. $"
yesxmsmsg	db "Starting to scan LBAcache instances. "
		db 9,"XMS pointer is currently    0x$"
curri13msg	db   "Int 0x13 vector found to be 0x$"

keymsg		db "Scanning for further instances...$"
donemsg		db "No more cache instances. INFO Done.$"

foundmsg	db "Found signature at segment      0x$" ; *hex*
xmsmsg		db "Driver XMS handle is number     0x$" ; *hex*
xmsinfomsg	db "XMS handle has size (kB, hex.)  0x$"

infolist	dw rdhit,rhitmsg+0x8000,  rdmiss,rmissmsg+0x8000
		dw wrhit,whitmsg+0x8000,  wrmiss,wmissmsg+0x8000
		dw hint,tabinf1+0x4000,   tabsz,tabinf2+0x4000
		dw sectors,sectmsg+0x4000,oldvec,oldi13msg+0x8000
		dw havelba,hlbamsg+0x4000,drvselmask,dvselmsg+0x4000
		dw 0,0
		; *** NEW 11/2002 must match positions in datahead
		
rhitmsg		db "read  hits (hex.):          0x$"
rmissmsg	db "read  misses (hex.):        0x$"
whitmsg		db "write hits (hex.):          0x$"
wmissmsg	db "write misses (hex.):        0x$"
tabinf1 	db "table offset (hex.):            0x$"
tabinf2 	db "table has log2 sect/bin.byte/bin: $"
sectmsg		db "sectors allocated in XMS (hex.) 0x$"
oldi13msg	db "stored  int 0x13  vector is 0x$"
hlbamsg		db "LBA   enable bits (C:=LSB) are: 0x$"
dvselmsg	db "Cache enable bits (C:=LSB) are: 0x$"

hrdmsg		db "*** kilo-reads (decimal):     $"
hwrmsg		db "*** kilo-writes (decimal):    $"
hhitmsg		db "--> percentage of hits  (decimal):  $"

twocolumns	db 0	; *** 11/2002 start with one column
		; *** also new 11/2002: string lengths tuned :-)

unhookmsg	db "Int 0x13 vector is now again  $" ; *hex*
dangerchainmsg	db "Int 0x13 CANNOT be rechained.",9
		db "DOS RAM will NOT be freed.$"

dangerchain	db 0	; *** 11/2002: is one if we have met any
			; *** non-unchainable instance before!
oldpsp		dw 0	; *** 11/2002: needed to work around the
			; *** DOS oddity that resizing makes you
			; *** own the MCB (so that it will be
			; *** freed when YOU terminate...). Sigh!

nocommsg	db "LBAcache.SYS: cannot free DOS RAM.$"
comsegmsg	db "LBAcache.COM: com PSP segment:  0x$"
reducemsg	db "Reducing MCB to... paras (hex.) 0x$"
mcbfailmsg	db "MCB operation failed, trying UMB variant$"

xmserrmsg	db "XMS problem, function.error is: 0x$"
xmsptr		dd 0	; pointer to the XMS handler
xmswhat		db 0	; function code

unflag		db 0	; what to do:   1:unload 2:info 4:flush
currint13	dd 0	; current value of int 0x13 vector


; -------------------------------------------------------------

showwimp:
	mov si,dx	; show a message before leaving
	call pmessage	; see below :-)
leavethis:
	pop ds
	pop es
	pop eax
	popa
	ret

uncache:		; always called from the cache
	pusha
	push eax
	push es
	push ds
	mov ah,[cs:args]
	test ah,7	; only continue if anything to do
	jz leavethis	; bits: 1 stop (remove all caches with
	mov bx,cs	; the signature and a nonzero XMS handle)
	mov ds,bx	; 2 info (stop should also set bit 1 !)
	mov es,bx	; 4 sync (flush/empty) all caches

; -------------------------------------------------------------

	; .386 (nasm does not have this "enable 80386 code" at)
	; (all, 80386 code is always allowed. Be careful your-)
	; (self thus not to "jz near ..." or so on an 8086... )

	; I know, no 386 presence check. pah. The STANDALONE
	; version is no longer maintained. UNCACHE now is part
	; of LBACACHE itself and gets run AFTER the 386 check...

confirmed:			; ok, so we have a mission now!
	mov [cs:unflag],ah	; store the type of our mission

	test ah,4
	jz confnorm
	mov si,flushmsg
		call pmessage	; message only, no AL AX EAX shown
	mov ax,0x0d00
		int 0x21	; DOS "disk reset" - writes back dirty
				; buffers. And flushes some caches :-)
	mov ax,0x4600		; eject media (int 13 extensions)
	mov dl,0		; A:
		int 0x13	; no error checking: we only care for
	mov ax,0x4600		; the side effect of flushing the cache
	mov dl,0		; B:
		int 0x13
	mov ax,0x4600
	mov dl,0x80		; C:..J:
flushloop:
	push dx
		int 0x13
	pop dx
	inc dl
	cmp dl,0x87		; *** flush C:..J: (0x80..0x87)
	jbe flushloop
	mov al,0
	mov dx,flushedmsg
		jmp showwimp	; we flushed (and maybe ejected) A..F 

; -------------------------------------------------------------

confnorm:
	mov ax,0x4300
	int 0x2f	; XMS install check
	cmp al,0x80
	jz xmsfound
	mov dx,noxmsmsg
	jmp showwimp	; no XMS - no cache to be found

xmsfound:
	push es
	mov ax,0x4310
	int 0x2f	; get the pointer to the xms far call
	mov [cs:xmsptr],bx
	mov ax,es
	mov [cs:xmsptr+2],ax
	shl eax,16
	mov ax,bx
	pop es

	mov si,yesxmsmsg+0x8000	; show message and EAX
		call pmessage	; XMS found, scanning may begin

	mov byte [cs:twocolumns],3	; start with 2 column mode!

	push word 0
	pop es			; ES will change soon anyway
	mov eax,[es:0x4c]	; current int 0x13 vector
	mov [cs:currint13],eax	; store for later
	mov si,curri13msg+0x8000	; show message and EAX
		call pmessage

; -------------------------------------------------------------

	mov bp,0x70	; assume no success before this...

findme:
	mov es,bp	; assume driver to be aligned!
	cmp dword [es:nam],'HDCA'
	jnz findon
	cmp dword [es:nam+4],'CHE$'
	jnz findon
	mov ax, [es:xmshandle]	; XMS handle
	or ax,ax
	jz findon		; no XMS handle - must be already off
	push eax
	mov eax,[es:xmsvec]	; XMS pointer for this one
	cmp eax,[cs:xmsptr]
	pop eax
	jz down1	; XMS pointers match
findon:
	jmp nope	; go on scanning

down1:
	test byte [cs:unflag],1	; UNLOAD requested?
	jz noshutdown
	mov word [es:running],2	; SHUT DOWN driver
noshutdown:

	mov byte [cs:twocolumns],2	; *** left of 2 column mode!

	push ax
	mov si,foundmsg+0x4000	; *offset* - show message and AX
	mov ax,bp
		call pmessage	; show segment
	pop ax

; ----------------------

	mov si,xmsmsg+0x4000	; *offset* - show message and AX
		call pmessage	; show handle

	mov dx,ax	; handle
	  push dx	; **save
	mov ah,0x0e	; INFO handle
		call doxmscall
	jnc xmsok1
	  pop dx	; **restore1
xmswimp:
	jmp instancedone	; wimp out

xmsok1:
	mov ax,dx	; size in kb
	mov si,xmsinfomsg+0x4000	; *offset*, show message and AX
		call pmessage
	  pop dx	; **restore2

	test byte [cs:unflag],1	; do we UNLOAD ?
	jz nofreexms
	mov ah,0x0a	; FREE handle
		call doxmscall
	jc xmswimp
xmsfreeok:
	mov word [es:xmshandle],0	; remove XMS handle ID -> mark
				; driver as uninteresting for UNCACHE
nofreexms:

; ----------------------

	mov bx,infolist		; a list of what we want to show
infoloop:
	mov si,[cs:bx]		; where to read
	or si,si
	jz infodone
	mov eax,[es:si]		; read a value from driver
	inc bx
	inc bx
	mov si,[cs:bx]		; select a message
		call pmessage	; show the message and AL/AX/EAX
	inc bx
	inc bx
	jmp short infoloop	; go on with next info

infodone:

; ----------------------

; *** 8/02: added human readable display
	push edx
	push ebx

humanreadable:
	mov eax,[es:rdhit]	; read hits
		push eax	; * save hits for percent
	xor edx,edx
	add eax,[es:rdmiss]	; read misses added
	adc edx,edx
		push eax	; * save (low part of) sum for percent

	mov ebx,1000
	div ebx			; transform (sum!) to k
	xor edx,edx
		call hex2dec	; transform to packed BCD
	mov si,hrdmsg+0x4000	; human readable read message, 16bit
	test eax,0xffff0000	; need 32bit?
	jz hrd16
hrd32:	xor si,0xc000		; 16->32bit display size
hrd16:		call pmessage

		pop eax		; * total
	mov ebx,eax
		pop eax		; * hits
		push ebx	; * total (>= hits)
	mov ebx,100		; for percent *** BUG fixed
	xor edx,edx
	mul ebx			; *** BUG was: did use edx=100
		pop ebx		; * total
; ???	xor edx,edx		; brute overflow blocking !!!

; ???	ror ebx,1		; rounding (no overflow check)
; ???	add eax,ebx		; add total/2 to 100*hits
; ???	stc
; ???	rcl ebx,1		; restore total count, do "or 1"
				; now ebx is an access count > 0
	or ebx,1		; *** instead of the above round-add

				; EDAX=100*hits EBX=(hits+misses)|1
	div ebx			; calculate percent

	cmp eax,100		; clip to 99%
	jb hrd99
hrd100:	mov eax,99
hrd99:		aam		; AAM: ah=al div 10, al=al mod 10
		shl ah,4
		or al,ah	; now we have packed BCD
	mov si,hhitmsg+0x2000	; percentage message, 8bit
		call pmessage

; ----------------------

humanreadable2:
	mov eax,[es:wrhit]	; write hits
		push eax	; save for percent
	xor edx,edx
	add eax,[es:wrmiss]	; read misses added
	adc edx,edx
		push eax	; save (low part) for percent
	mov ebx,1000
	div ebx			; transform to k
	xor edx,edx
		call hex2dec	; transform to packed BCD
	mov si,hwrmsg+0x4000	; human readable write message, 16bit
	test eax,0xffff0000	; need 32bit?
	jz hwr16
hwr32:	xor si,0xc000		; 16->32bit display size
hwr16:		call pmessage
		pop eax		; * total
	mov ebx,eax
		pop eax		; * hits
		push ebx	; * total
	mov ebx,100		; for percent *** BUG fixed
	xor edx,edx
	mul ebx			; *** BUG was: did use edx=100
		pop ebx		; * total
; ???	xor edx,edx		; brute overflow blocking !!!

; ???	ror ebx,1		; rounding (no overflow check)
; ???	add eax,ebx		; add total/2 to 100*hits
; ???	stc
; ???	rcl ebx,1		; restore total count, do "or 1"
				; now ebx is an access count > 0
	or ebx,1		; *** instead of the above round-add

				; EDAX=100*hits EBX=(hits+misses)|1
	div ebx			; calculate percent

	cmp eax,100		; clip to 99%
	jb hwr99
hwr100:	mov eax,99
hwr99:		aam		; AAM: ah=al div 10, al=al mod 10
		shl ah,4
		or al,ah	; now we have packed BCD
	mov si,hhitmsg+0x2000	; percentage message, 8bit
		call pmessage

	pop ebx
	pop edx

; ----------------------

	test byte [cs:unflag],1	; do we UNLOAD ?
	jz near instancedone	; if not, we are done with the instance

	mov byte [cs:twocolumns],0	; *** 11/2002 if yes, change
					; *** to one column mode!
			; (could check if we are in left column here)

shrinkit:
	mov ax,es		; driver segment
	cmp ax,[cs:currint13+2]	; current int 13 vector segment
	jz fullremove		; int 13 still in driver
	mov eax,[es:oldvec]	; old int 13 vector...
	cmp eax,[cs:currint13]
	jnz partremove		; IF Z: int 13 same as oldint stored
				; in driver, so it was not even hooked

	test byte [cs:dangerchain],1	; *** BUGFIX 11/2002: if the
				; *** removed instance points to yet
				; *** ANOTHER removed instance, we
	jz fullremove		; *** would be doomed!
	mov si,dangerchainmsg	; warning message, 0 bit.
		call pmessage
	jmp short partremove

; ----------------------

fullremove:
	mov eax,[es:oldvec]	; int 13 vector before driver took it
	push es
	  push word 0
	  pop es
	mov [es:0x4c],eax	; un-hook the int 13 vector !!
	pop es
	mov [cs:currint13],eax	; update our notion of int 13

	mov si,unhookmsg+0x8000	; message and EAX
		call pmessage	; tell that we have unhooked

	xchg bx,bx
	xchg bx,bx
	xchg bx,bx

	mov ax,0		; now we can FREE the used memory,
	jmp comremove		; unless the driver was loaded as sys.

; ----------------------

				; we cannot unhook int 0x13, but
partremove:			; we can still reduce the used size,
				; unless the driver was loaded as sys.

	or byte [cs:dangerchain],1	; *** NEW 11/2002 remember
					; *** that we came along this
					; *** cannot-unhook-case!

	mov ax,[es:tsrsize]	; where to end the TSR
	add ax,15
	shr ax,4		; paragraphs - NEEDED BELOW
comremove:
	push es	; **save
	les bx,[es:next]	; device link pointer, because we are
				; looking for the magic that tells us
	cmp dword [es:bx+3],'COMC'	; if the driver is in com mode.
	jnz itsasys		; no removal possible for sys
	cmp dword [es:bx+7],'ACHE'
	jz itsacom
itsasys:
	pop es	; **restore1
	mov si,nocommsg
		call pmessage	; tell about the sys-ness...
	jmp instancedone	; we cannot free the RAM of a SYS !

; ----------------------

itsacom:			; Instance found to be .com version, so
				; we can un-alloc the memory it uses!
	mov bx,es		; where the com code segment is
	pop es	; **restore2

	push ax
	mov ax,bx		; segment of com
		mov si,comsegmsg+0x4000	; show message and AX
		call pmessage
	pop ax

	or ax,ax
	jz vanishing

	or byte [cs:dangerchain],128	; *** NEW 11/2002

	push bx 	; *** WARNING: should depend on distance MCB
	mov bx,es	; *** (BX) to the SYS SEG (ES) in some
	add ax,bx	; *** better/saner way than now probably!
	pop bx		; *** for now: size + (SYS-COM) + 1
	sub ax,bx	; *** is the size to which we reduce
	inc ax
vanishing:

		mov si,reducemsg+0x4000	; show message and AX
		call pmessage	; tell that we are reducing

	mov cx,0x1149	; start by assuming FREE (seg bx)
			; CH is the XMS function, CL the DOS one
	or ax,ax
	jz mcbme	; shrink/remove seg bx to ax paragraphs
	mov cx,0x124a	; resize, do not free

	; *** DOS oddity workaround, as recommended by FreeDOS
	; *** kernel people: If you resize a MCB, you automatically
	; *** own it. Solution: Pretend being the instance to
	; *** be resized...

	test byte [cs:dangerchain],128	; *** NEW 11/2002: COM flag
	jz nopsptrick1
	push ax
	push bx
	mov ah,0x62	; *** get current PSP segment
	int 0x21	; *** probably equal CS of our comcache part
	mov [cs:oldpsp],bx	; *** save it
		pop bx	; *** restore the PSP address of "our victim"
		push bx
	mov ah,0x50	; *** SET your process ID / PSP address
			; *** ... to segment BX
	int 0x21	; *** "be the instance that is resized"
	pop bx
	pop ax
nopsptrick1:

mcbme:	push es
	mov es,bx		; segment
	push bx
	mov bx,ax		; new size (if resize)
	push ax
	mov ah,cl		; the function to do
		int 0x21	; resize/free this MCB
	pop ax
	pop bx
	pop es

	pushf

	test byte [cs:dangerchain],128	; *** NEW 11/2002: COM flag
	jz nopsptrick2
	push ax
	push bx
	mov bx,[cs:oldpsp]	; *** back to original value
	mov ah,0x50	; *** SET your process ID / PSP address
			; *** ... to segment BX
	int 0x21	; *** "be yourself" again (for int 21.4c...)
	pop bx
	pop ax
	and byte [cs:dangerchain],127	; *** clear "is com" flag
nopsptrick2:

	popf

	jnc instancedone	; if it has worked, done with this!

	mov si,mcbfailmsg	; Only reason: this was no MCB
		call pmessage	; MCB operation failed

	; trying UMB mechanism as a second possibility
	; still, segment is BX and new size is AX
	; if DOS=UMB is active, DOS is supposed to have
	; converted all UMB to MCB, but we will see...

	mov dx,bx	; segment
	mov bx,ax	; new size (if resize)
	mov ah,ch	; the XMS function we figured out above
		call doxmscall	; XMS UMB free/resize
	; jc umbfailed... - the user already knows from the XMS error

; -------------------------------------------------------------

; *** Wait removed 8/02
instancedone:
	mov si,keymsg		; only show message
		call pmessage	; tell that we are done ; *** waiting
; ***	mov ah,0
; ***		int 0x16	; wait for a keypress
	
nope:	inc bp			; signature not found
	cmp bp,0xa000	; skip seg 0xa000 ... 0xc1ff in search
	jnz nskip
	mov bp,0xc200	; no VGABIOS would be < 16k, but Xdosemu
			; has an 8k VGABIOS ... http://www.dosemu.org/
nskip:	cmp bp,0xf000	; no we will not check the ROM and HMA area!
	jnz near findme	; go on searching

leavethis0:
	mov si,donemsg		; only show message
		call pmessage	; say goodbye...
	mov al,0		; errorlevel 0
	jmp leavethis

; -------------------------------------------------------------


pmessage:		; show message at (si and 0x1fff) and 
	push dx		; value of N lsby of eax, N being
	push eax	; si shr 13... and then CRLF.
	push ds		; *** NEW 11/2002: twocolumns may skip CRLF
	  push cs	; *** if on, every other CRLF will be a TAB
	  pop ds	; *** IF you turn twocolumns OFF (and ~2),
	  push ax	; *** AND the "test ... 1" is ZR, then you
			; *** have to CRLF before the next string.
	mov dx,si
	and dx,0x1fff	; mask out our flags (offset is max 8k !!!)
	mov ah,9
		int 0x21

	  pop ax
	test si,0xe000	; any bytes to show?
	jz pmdone	; if none, done
	  push ax
	mov ax,si
	shr ax,12	; how many nibbles to show
	and al,14	; only 2/4/6/8/10/12/14, which is
			; AL AX ? EAX ? ? ? (1..7 bytes)
	mov dh,al	; as a counter
	  mov dl,cl	; save
	mov cl,8	; max 8 nibbles
	sub cl,dh	; how many nibbles not to show
	shl cl,2	; nibbles -> bits
	  pop ax
	shl eax,cl	; make EAX "left-bound"
	  mov cl,dl	; restore

showeaxlp:
	rol eax,4	; move digit to show in lowest pos
	  push ax
	and al,0x0f
	add al,'0'	; hex -> ascii
	cmp al,'9'
	jbe nothex
	add al,7	; 'A'-('9'+1)
nothex:	mov dl,al
	mov ah,2
%ifdef REDIRBUG
	call BUGTTY
%else
		int 0x21	; show a char
%endif
	  pop ax
	dec dh
	jnz showeaxlp	; on to the next digit

pmdone:	mov dx,crlfmsg21	; *offset*

	test byte [cs:twocolumns],1	; TAB instead of CRLF ?
	jz pmdonecrlf
	mov dx,pmtabmsg21
pmdonecrlf:
	mov ah,9
		int 0x21
	test byte [cs:twocolumns],2	; toggle mode on?
	jz pmnotoggle
	xor byte [cs:twocolumns],1	; toggle TAB <-> CRLF
pmnotoggle:

	pop ds
	pop eax
	pop dx
	ret

; -------------------------------------------------------------

hex2dec:		; take a longint eax and convert to packed BCD
	push ebx	; overflow handled (0xffffffff has 10 digits)
	push ecx
	push edx
	push edi
	xor edx,edx
	xor ecx,ecx	; shift counter
	xor edi,edi	; result
	mov ebx,10
h2dlp:	div ebx		; remainder in edx, 0..9
	shl edx,cl	; move to position
	or edi,edx	; store digit
	xor edx,edx	; make edx:eax a proper 64bit value again
	or eax,eax	; done?
	jz h2dend
	add cl,4	; next digit
	cmp cl,32	; digit possible?
	jae h2doverflow	; otherwise overflow
	jmp short h2dlp
		
h2dend:	mov eax,edi	; return packed BCD
	pop edi
	pop edx
	pop ecx
	pop ebx
	ret

h2doverflow:
	mov edi,0x99999999
	jmp short h2dend

; -------------------------------------------------------------

doxmscall:		; do an XMS call, with error handling
	mov [cs:xmswhat],ah	; for the error message
	call far [cs:xmsptr]
	or ax,ax
	jz xmserror		; ax=1 if ok
	clc			; ok
xmsdone:
	ret
xmserror:			; ax was 0, error code in BL
	push ax
	push si
	mov al,bl		; error code
	mov ah,[cs:xmswhat]	; verbose :-)
		mov si,xmserrmsg+0x2000	; *offset*, show message and AL
		call pmessage
	pop si
	pop ax
	stc		; error
	jmp short xmsdone

; -------------------------------------------------------------

