#!/bin/bash

# old NASM versions need -d, newer ones -D ...
# Options mean:
# DEBUGNB to see when cache becomes full
# REDIRBUG if redirection of messages does not work on old FreeDOS kernels
# MUTEDISKCHANGE to suppress "disk changed" message
# SANE_A20 to suppress waiting for keyboard controller ready before XMS
#   copy - the waiting works around a Bochs 1.x BIOS bug.
# FORCEFDD to allow caching even floppy drives without change line, like
#   in dosemu. You MUST do LBAcache flush after removing a floppy and before
#   inserting the next floppy manually in that case.
# MUTEFDWRERR to suppress the message about cache flush after write error
#   on floppy disks - partial flush would be better, please contribute it...

echo Now creating lbacache.sys and lbacache.com...
nasm -o comcache.bin comcache.asm

if true; then
  echo Creating normal LBAcache...
  nasm -DMUTEDISKCHANGE=1 -DSANE_A20=1 -DMUTEFDWRERR=1 -o lbacache.sys lbacache.asm
else
  echo Creating DEBUG version of LBAcache, including workarounds...
  nasm -DSDEBUGNB=1 -DREDIRBUG=1 -o lbacachd.sys lbacache.asm
fi

cat comcache.bin lbacache.sys > lbacache.com
upx --8086 lbacache.com lbacache.sys
echo lbacache.com and lbacache.sys have been updated.

ls -l *.com *.sys

echo
echo Please move lbacach*.{com,sys} to ../../BIN/
echo if you want to make them the active version now.

