; LBAcache - a hard disk cache based on XMS, 386 only,
; and aware of the 64bit LBA BIOS Int 13 Extensions.
; GPL 2 software by Eric Auer <eric@coli.uni-sb.de> 2001

; Check out the CHS version as well (limited to 8 GB,
; uses less DOS memory, and wimps out on LBA write)...

.8086

	; main install and setup routine follows (starts with
	; 8086 compatible code to detect 386, then does a check
	; for the existence of XMS, allocates the cache there,
	; and stores the drive geometry information for drives
	; 0x80 .. 0x83 for CHS <-> LBA conversion
	; install: is the entry point.
	; jumps to resinst: at the end.
	; FLOPPY: added change line detection -> fddstat word

install:
;	cli	; cli not really needed...
	mov word [es:bx+0x10],cs	; pointer to first free byte
	mov word [es:bx+0x0e],0		; default: do not use any RAM
		; if load failed... either EOFTSR:
		; (this will leave a minimal "if (!cache enabled)
		;  { goto old int 0x13; }" handler and not much more)
		; OR 0 (do not stay tsr at all, possible only
		; if int 0x13 was not hooked (obviously)

; -------------

; test if we have 386 or better: 
	push ax
	pushf   ; save flags
		xor ax,ax
		push ax
		popf	; try to clear all bits
		pushf
	        pop ax
	and ax,0f000h
	cmp ax,0f000h
	jz noinst1	; 4 msb stuck to 1: 808x or 80186
		mov ax,0f000h
		push ax
		popf	; try to set 4 msb
		pushf
		pop ax
	test ax,0f000h
	jz noinst1	; 4 msb stuck to 0: 80286
	jmp short okinst1
noinst1:	; failed, no 386 found
	push bx
	push si
	push ds
	mov ax,cs
	mov ds,ax
	cld			; flags are saved :-)
	mov si,err386
		call strtty	; complain: no 386 found
	mov si,hello
		call strtty	; show banner
	pop ds
	pop si
	pop bx
	pop ax
	popf
	jmp quitinst
.386
okinst1:
	popf	; good, it is a 386, now restore flags
	pop ax

; -------------

	pusha			; after this point, we must pass
	push ds			; quitpop, not only quitinst...

	mov ax,cs
	mov ds,ax		; save all regs and set DS to our CS
	cld			; flags are saved :-)

	push si
	mov si,hello
		call strtty	; show banner
	pop si


; -------------

	call parsecommandline	; the COMMAND LINE should be parsed as
				; soon as possible, so we do it now.
				; (uses the struct at es:bx)

; -------------

	call uncache		; new 01/2002: call the part that
				; implements the formerly separate
				; UNCACHE functionality (sync, info,
				; stop) (must be -before- we get an
				; XMS handle)
	mov ax,[cs:args]
	test ax,15
	jz go_tsr		; exit here if any uncache thing was
				; our mission - else do cache thing!
	push word notsrmsg
		call meep
	mov si,crlfmsg
		call strtty
	jmp quitpop		; leave this here!

go_tsr:

; -------------

; test if we have XMS. allocate XMS. fail if none/not enough found.

	mov ax,0x4300
		push ax	; for debugging: put "why" code on stack
	mov bl,-1		; clear errorcode value
		int 0x2f	; xms installation check
	cmp al,0x80
	jnz short noxms		; xms not present
	mov ax,0x4310
	push es
		int 0x2f	; get xms call vector (may clobber regs)
	mov [xmsvec],bx
	mov [xmsvec+2],es
	pop es
		pop ax	; for debugging: remove "why" code
	mov ah,8
		push ax	; for debugging: new "why" code
		call far [xmsvec]	; check amount of free XMS
	or ax,ax
	jz short noxms		; errorcode in bl if ax zero
	mov bx,[ds:sectors]	; ds: prefix needed, see above
	inc bx
	shr bx,1	; amount of XMS we need, kbyte / use 512 by sectors
	cmp dx,bx		; DX total, AX biggest chunk (kbyte)
	jb short noxms
	cmp ax,bx
		pop ax	; for debugging: remove "why" code
		push word 0xfe00	; for debugging: new "why" code
	jb short noxms		; not enough XMS free
		pop ax	; for debugging: remove "why" code
	mov ah,9
		push ax	; for debugging: new "why" code
	mov dx,bx
		call far [xmsvec]	; alloc DX kbyte for us
	or ax,ax
	jz short noxms		; errorcode in bl if ax zero
		pop ax	; for debugging: remove "why" code
	mov [xmshandle],dx	; our handle
	; (to free the memory, we would use function 0x0a and handle in DX)
	; (only other function used is copy, 0x0b)
	jmp short findgeom

noxms:	
		pop ax		; meep displays errorcode from bl...
		mov al,bl	; ...and the "why" code from stack.hi
		push word xmserr
		call meep	; give feedback
	mov si,xmserr2		; no or not enough XMS found
		call strtty	; minimalistic error message
instfailed:
	jmp quitpop

; now we have the XMS we need, after flushing the status table and
; finding the geometry we can hook int 0x13 and return...

; -------------

findgeom:
	mov word [cs:havelba],0	; start with assuming no LBA
	mov ax,0x4100
	mov bx,0x55aa
	mov dl,0x80
		int 0x13	; check if BIOS int 13 extension is
				; present (maybe we should store a flag
				; for *** EVERY drive 0x80 .. 0x83 ?)
	cmp bx,0xaa55		; (version info in AH and DH ignored)
	jnz nolbabios		; install check failed
	test cx,1		; 1 LBA 2 removable 3 flatmem/edd
	jz nolbabios
	mov word [cs:havelba],1	; note that LBA was found
	jmp short findgeom2	; ok, LBA BIOS present

nolbabios:
	mov si,errnolba		; error message...
		call strtty
	; *** jmp instfailed	; having no LBA is no longer FATAL :-)


; -------------

findgeom2:
	push es
	  push cs
	  pop es		; so we need no cs: prefix for stosb...
	mov di,geometry
	cld			; flags are saved :-)
	mov ah,08		; read geometry and number of hard disks
	mov dl,0x80		; HDA
	push es
	push di
		int 0x13	; find geometry (bl type, dl drives, dhcx geo)
	pop di			; (esdi -> drive param tab, only for floppies)
	pop es
	jc nodrive
	or dl,dl
	jz nodrive
	and cl,63
	mov al,cl
	stosb			; save max sector num
	mov al,dh
	stosb			; save max head num
	cmp dl,1
	jz short alldrives	; only one hard disk? then we are done
	mov ah,08
	mov dl,0x81		; HDB
	push es
	push di
		int 0x13	; find next geom, no further error checks!
	pop di
	pop es
	and cl,63
	mov al,cl
	stosb
	mov al,dh
	stosb
	cmp dl,2
	jz short alldrives	; yes, it is an unrolled loop...
	mov ah,08
	mov dl,0x82		; HDC
	push es
	push di
		int 0x13	; find next geom, no further error checks!
	pop di
	pop es
	and cl,63
	mov al,cl
	stosb
	mov al,dh
	stosb
	cmp dl,3
	jz short alldrives	; yes, it is an unrolled loop...
	mov ah,08
	mov dl,0x83		; HDD
	push es
	push di
		int 0x13	; find next geom, no further error checks!
	pop di
	pop es
	and cl,63
	mov al,cl
	stosb
	mov al,dh
	stosb
	jmp short alldrives	; if there are more drives, we ignore them!
	
nodrive:			; no drives to cache, not fatal
	mov si,errdrv
		call strtty	; very useful error message :-)
alldrives:			; done with all HARD DISK drives

; -------------

findgeom3:
	push es			; esdi: drive param table (ignored)
	push di			; cx dx: geometry
	push bx			; bx: drive type (floppies only)
	or word [cs:fddstat],0x0300	; potential drives: A: and B:

	mov ax,0x0800		; get drive params
	xor dx,dx		; A:
	xor bx,bx
	xor cx,cx
		int 0x13	; modifies AX BX CX DX ES DI
	jc no_drv_a		; no A installed
	cmp dh,1
	ja no_drv_a		; > 2 head floppies are never cached
	and cl,63		; number of cyls does not matter
	cmp cl,18		; never cache if > 18 sectors / cyl
	ja no_drv_a		; this excludes some xlarge formats
	cmp bl,4		; 2.88 M is 36 sec/cyl, but to be sure
	ja no_drv_a		; 1 360k 2 1200k 3 720k 4 1440k (16 atapi)
	mov ax,0x1500		; get disk type
	xor dx,dx		; A:
		int 0x13	; for floppies, only AX modified (not CX DX)
	jc no_drv_a
	cmp ah,2		; we allow only "removable with change line"
	jnz no_drv_a

	
		; we could say "useable drive A: found" here


	jmp short findgeom4

no_drv_a:
	and word [cs:fddstat],0xfefe	; disable caching of A:

findgeom4:
	mov ax,0x0800		; get drive params
	xor cx,cx
	xor dx,dx
	inc dx			; B:
	xor bx,bx
		int 0x13	; see above
	jc no_drv_b
	cmp dh,1
	ja no_drv_b
	and cl,63
	cmp cl,18
	ja no_drv_b
	cmp bl,4
	ja no_drv_b
	mov ax,0x1500		; get disk type
	xor dx,dx
	inc dx			; B:
		int 0x13	; for floppies, only AX modified (not CX DX)
	jc no_drv_b
	cmp ah,2		; we allow only "removable with change line"
	jnz no_drv_b
	jmp short findgeom5

	
		; we could say "useable drive B: found" here


	jmp short findgeom5

no_drv_b:
	and word [cs:fddstat],0xfdfd	; disable caching of B:

findgeom5:
	test word [cs:fddstat],0x0300	; anything useable?
	jnz some_fdd_found		; (0x0003 would test: ...enabled?)
	mov si,errnofdd	
		call strtty	; warn user: no cacheable floppies

some_fdd_found:

%ifdef FORCEFDD
		or word [cs:fddstat],0x0003
		; FORCEFDD caches floppies even if they have
		; no change line and even w/o the FLOP argument!
%endif

	test word [cs:fddstat],0x0003	; anything really used?
	jz none_fdd_used
	mov ax,[cs:fddstat]
		push word msgwhichfdd	; tell which drives are cached
		call meep
;	mov si,crlfmsg
;		call strtty

none_fdd_used:
	pop bx
	pop es
	pop di

; -------------

	pop es

; -------------

	jmp short malloc

; -------------

smalloc:
	dec word [cs:sectors]	; use less memory

malloc:				; allocate memory for us and the table

	; ptr[es:bx+0x0e] will tell us a limit, but only for DOS 5+
	; *** FIXME: Be nice and listen to DOS 5+ if it is there...
	; *** ...but we have overwritten that value already anyway!

	mov ax,[cs:sectors]		; check size requested...
		call telltabsize	; calculate tab size
	jc smalloc			; was much too big


					; *** new 01/2002
	test word [cs:args],0x8000	; activate local stack?
	jz nomallocstack
mallocstack:
	add ax,table+15+500		; *offset* add 500 byte stack
	pushf
	push ax
	sub ax,4
	and ax,0xfffc
	mov [cs:localsp],ax
		push word stackonmsg
		call meep
		mov si,crlfmsg
		call strtty
	pop ax
	popf
	jmp short knowstack
	
nomallocstack:
	add ax,table+15	; *offset*	; new eof tsr point
knowstack:


	jc smalloc
	jz smalloc			; too big with code
	les bx,[cs:pb]	; driver thing
	mov word [es:bx+0x0e],ax	; new end of our TSR, (seg
					; already set to CS above)
	mov ax,[cs:sectors]
		push word meepsect
		call meep		; give cache size in sectors
	mov ax,[es:bx+0x0e]
		push word meepseg
		call meep		; give size of our CS
	mov si,crlfmsg
		call strtty		; CRLF

; -------------

hookint13:				; hook int 0x13 - we can
	push eax			; ONLY do this already here
	push es 			; because [running] is not set
	xor ax,ax			; yet! Table still unflushed!
	mov es,ax
	mov eax,[es:0x13+0x13+0x13+0x13]        ; read old vector
	mov [oldvec],eax        ; save it for chain and call and uninstall
	mov ax,cs
	shl eax,16                              ; new vector: segment
	mov ax,int13new                         ; * new vector: offset
%ifdef PRETENDER
	; leave original int alone and use a separate api on int 0xea !
        mov [es:0xea+0xea+0xea+0xea],eax        ; hook (no cli, atomic)
%else
        mov [es:0x13+0x13+0x13+0x13],eax        ; hook (no cli, atomic)
%endif
        pop es
        pop eax


; -------------

	jmp resinst	; jump out of the way, rest of inst will be
			; overwritten with the status table!
	; will do: call flush, pop ds, popa, mov word [cs:running],1
	; and jmp nix (to return to the device handler...).

msgwhichfdd	db "Floppy drive cache setup: ",0,"$"
notsrmsg	db 13,10
		db "Not going TSR, not caching - uncache mode: ",0,"$"
stackonmsg	db 13,10,"Activating local stack, 500 byte more TSR: 0x",0

