; LBAcache - a hard disk cache based on XMS, 386 only,
; and aware of the 64bit LBA BIOS Int 13 Extensions.
; GPL 2 software by Eric Auer <eric@coli.uni-sb.de> 2001

; Check out the CHS version as well (limited to 8 GB,
; uses less DOS memory, and wimps out on LBA write)...

	; more helper functions (using int 0x10):
	; meep: makes a beep and shows AX and the message pointed
	;       to by a word found on stack (if not zero).
	;       Takes the word from stack on return and saves ALL
	;       registers and flags. The empty message defaults
	;	to a single beep (char 07).
	; showal: shows AL as hex, trashing many registers.

meep:	push bp	; to have some feedback: BEEP/show message and
	push si	; then the value in AX
	mov bp,sp	; <- stooopid: forgot to init bp here...
	mov si,[ss:bp+6]	; the pushed word, skipping si bp ip
	pushf
	push ax
	push bx

	push ax	; save for later
meepmsgloop:
	mov bx,7
	mov ah,0x0e
	mov al,[cs:si]
	or al,al
	jz short nomeepmeep	; so only beep if no message
	inc si
		int 0x10	; show char
	jmp short meepmsgloop

nomeepmeep:
	pop ax
	push ax
	mov al,ah
		call showal	; show AH
	pop ax
		call showal	; show AL
	cmp word [cs:running],1	; only wait if init already done
	jb nomeepwait		; wait a while if we had a message
	mov bx,22		; *** adjust if you want
%ifdef DBG
	mov bx,222		; *** adjust if you want
%endif
mpwt2:	mov si,-1
%ifdef FASTMEEP
	mov si,42
%endif
mpwt1:	
	; in al,0x80		; I/O is slow, good...
	dec si
	or si,si
	jnz mpwt1
	dec bx
	jnz short mpwt2
nomeepwait:
	pop bx
	pop ax
	popf
	pop si
	pop bp
	ret +2		; take the message offset from stack!


showal:			; helper func to show AL as hex
	push ax
	mov ah,0
	mov bx,ax
	shr bx,4
	mov al,[cs:hexa+bx]
	mov bx,7
	mov ah,0x0e
		int 0x10	; high hex digit
	pop ax
	and ax,0x000f
	mov bx,ax
	mov al,[cs:hexa+bx]
	mov bx,7
	mov ah,0x0e
		int 0x10	; low hex digit
	ret

hexa	db '0123456789abcdef'

	; some useful default messages:
crlfmsg		db 13,10,0
colonmsg	db ':',0
spacemsg	db ' ',0
meepmsg		db 7,0

SHOWDOT:
	pushf
	push ax
	push bx
	mov ah,0x0e	; tty
	mov al,'.'
	mov bx,7
	int 0x10
	pop bx
	pop ax
	popf
	ret

; ---------------------------------------------------------------

	; this is new Jan 2002

REGDUMP:
%ifndef USEREGDUMP
	ret
%else
	pushf
	push eax
	push bx
	push si
		push bx
	mov si,rdmsg1
	ror eax,16
	call onereg		; EAX hi
	mov si,colonmsg
	ror eax,16
	call onereg		; EAX lo
	mov si,rdmsg2
		pop bx		; original BX
	mov ax,bx
	call onereg
	mov si,rdmsg3
	mov ax,cx
	call onereg
	mov si,rdmsg4
	mov ax,dx
	call onereg
	pop ax			; saved SI
	push ax
	mov si,rdmsg5
	call onereg
	mov si,rdmsg6
	mov ax,di
	call onereg
	mov si,rdmsg7
	mov ax,bp
	call onereg
	mov si,rdmsg8
	mov ax,sp
	add ax,12		; what we used on stack
	call onereg
	mov si,sp
	mov ax,[ss:si+10]	; the IP to which we return
	mov si,rdmsg9
	call onereg
	pop si
	pop bx
	pop eax
	popf
	ret

onereg:	push ax
onestr:	mov bx,7
	mov ah,0x0e
	mov al,[cs:si]
	or al,al
	jz short noonestr
	inc si
		int 0x10	; show char
	jmp short onestr
noonestr:
	pop ax
	push ax
	mov al,ah
	call showal
	pop ax
	push ax
	call showal
	pop ax
	ret

rdmsg1	db 13,10,'LBAcache: EAX=',0
rdmsg2	db ' BX=',0
rdmsg3	db ' CX=',0
rdmsg4  db ' DX=',0
rdmsg5	db ' SI=',0
rdmsg6  db ' DI=',0
rdmsg7	db ' BP=',0
rdmsg8	db ' SP=',0
rdmsg9	db ' IP=',0
%endif

