/* PUTC
 * An extended version of put-character.
 * Copyright (C) 1996 James Hall.
 */

#include <stdio.h>

/* Globals */

unsigned long xx_lines = 0;                /* Number of lines printed */
int xx_pause = 0;                          /* Pause at every screenful */
int xx_numrows = 25;                       /* Number of lines per screen */
int xx_tabs = 0;                           /* Print TABS as "^I" */
int xx_controls = 0;                       /* Print controls using "^" */

void x_putc (int ch, FILE *stream)
{
	/* Check for global options */

	switch (ch) {
	case '\n':
		xx_lines++;
		putc ('\n', stream);

		if ((xx_pause) && ((xx_lines % (xx_numrows - 1)) == 0)) {
			printf ("More..");
			x_getkey ();
			putchar ('\n');
		}
		break;

	case '\t':
		if (xx_tabs) {
			fprintf (stream, "^I");
		}
		else {
			putc ('\t', stream);
		}
		break;

	default:
		if ((xx_controls) && (ch < 32)) {
			fprintf (stream, "^%c", ch + 32);
		}
		else {
			putc (ch, stream);
		}
		break;
	}
}
