{$A-,B-,D-,E-,F-,I-,L-,N-,O-,R-,S-,V-}
{$G+ enable 286 opcodes}
{$M $2000,0,0}
Program KBD;
{
ͻ
 Keyboard device driver for FreeDOS. (AT only, no XT)      
 Weitgehend frei konfigurierbar.                           
͹
 Version 1.7.    XX. August 2001. Turbo/Borland Pascal 7.0 
                                                           
 (P) + (C) 1991,1992,1994 Dietmar Hhmann.                 
 (C) 2000-2001 Aitor Santamara Merino. (aitor.sm@terra.es)
ͼ

Posible defines:
        DEBUG   Enables the debugging options
        KBDRES  Compiles the XKEYBRES, the LITE version


History:
         x.x.'xx: Einbau des PI                                   -> V1.1
        17.2.'92: Fehler bei INT15-Aufruf behoben.
        18.2.'92: Implementation von Kombinationszeichen.         -> V1.2
         8.4.'92: Bug-Fix: ALT-1 - ALT-0,ALT- & ALT-'
        26.6.'92: ^Break gendert in INT 1B und ^C.               -> V1.22
                  Funktion 248 :=> Taste bewirkt nichts.
         9.9.'92: Funktion 247: => OS/2: DOS-Box schlieen.       -> V1.24

        14.2.'94: Fehler bei Alt+Ctrl+F2 behoben                  -> V1.3
                  Problem mit Backslash im MS-DOS-Editor behoben.
                  Angepat an AMI-BIOS: Kein Speichertest beim Warmstart.
                  Fehler mit nicht funktionierender automatischer Einrichtung
                       des XString-Speichers behoben.
                  Erweiterter Tastaturstaus wird gepflegt und kann ber die
                       entsprechenden BIOS-Funktionen abgefragt werden.
        27.1.'01  Added function in ReadConfigFile to search for keyfile in
                  path if not in the same directory as program
----- Aitor Santamara Merino new maintainer
        VER 1.5.1  xKEYB 1.5 was packed WITHOUT .key files
                   1.5.1 is just 1.5 with all the .key files packed

        VER 1.6    * Search on PATH capability (Ralf Quint)
                   * Changes to .KEY files (Aitor):
                     - DVORAK.KEY (Eugene Wong)
                     - SU.KEY to RU.KEY
                     - Bug 126 fixed (small patch to IT.KEY)

        VER 1.7    *  LED support removed (Aitor, Axel)
                   *  Improved search of .key files (also in curdir)
                      (Aitor, Ralf)
                   * Added XKEYB.FHL, the fast help, and it is
                     shown with /? (Aitor)
                   * New Copyright notice (Aitor)
                   * XKEYBRES is now included within this file using DEFINEs
                     this way, changes are reflected in both codes (Aitor)
                   * Switched the reported values in BX/CX for int2Fh/AX=AD80h
                     for MS compatibility (Aitor)
			 * New Makefile (Axel, Ralf, Aitor)
			 * Most of the messages are now displayed in English (Ralf)
			 * Added br850.key (for Brazil, codepage 850) (Alain)


}

Uses Dos,Inter2;

Const   VerS        = '1.7';
        Version     = $170;

Procedure Data; Forward;

Type   BuffEntTyp  = Record                 { Art der Eintrge im Tastaturbuffer. }
                     Case Byte of
                        0:(Ascii,Scan : Byte);
                        1:(Entire : Word);
                     End;
       XBufferTyp  = Array[0..63] of BuffEntTyp;
       ActionTyp   = (Install,Uninstall,OverLoad,GetInfo,WrongVers,OtherDrv,FastHlp);
       PtrTyp      = Record Ofs,Seg:Word End;
       TransTabTyp = Array[1..100,0..5] of Byte;
       XFuncTyp    = Record
                        Stat : Byte;
                        Case Byte of
                           0 : (Adr : Pointer);
                           1 : (Proc : Procedure(W : Word));
                     End;

{ ========== Folgende Konstanten bilden das fast access DS ========== }
Const  ScanCode    : Byte = 0;
       BreakCode   : Boolean = False;
       VirtScanCode: Byte = 0;
       XKey        : Boolean = False;
       XShift      : Boolean = False;       { Erweiterte Shift-Taste. }
       ShiftNum    : Byte = 0;
       ShiftBit    : Byte = 0;
       NCS         : Boolean = False;
       WaitLoop    : Word = 0;
       Loop        : Byte = 0;
{ Die 5 folgenden Variablen werden ggf. von der 2. Kopie von XKeyb gelesen und verndert. }
       ShiftKeys   : Array[0..7] of Byte = (0,0,0,0,0,0,0,0);   { ScanCodes des Shifttasten. }
       LastXStr    : Byte = 0;              { Nummer des letzten definierten XStrings. }
       TransTable  : ^TransTabTyp = Nil;    { Zeiger auf die bersetzungstabelle. }
{$IFNDEF KBDRES}
       Inactive    : Boolean = False;       { Gibt an, ob Tastatureingaben von XKeyb oder dem BIOS bearbeitet werden. }
{$ELSE}
       Inactive    : Boolean = True;        { Gibt an, ob Tastatureingaben von XKeyb oder dem BIOS bearbeitet werden. }
{$ENDIF}
       XBuffer     : ^XBufferTyp = Nil;     { Zeiger auf second level Buffer. }
       NextMulti   : Pointer = Nil;         { Verkettung fr Multiplexer-Interrupt. }
       NextInt16   : Pointer = Nil;         { Verkettung fr Int 16. }

       XString     : ^String = Nil;         { Akt. XString. }
       XStrPos     : Byte = 0;              { Position im XString. }
       PutXStr     : Boolean = False;       { Wird momentan XString bearbeitet ? }
       Row         : Byte = 0;              { Zeile in der bersetzungstabelle. }
       LoopRunning : Boolean = False;       { Es wird bereits auf Beendigung des Pausemodus gewartet. }
       XBufferHead : Word = 0;              { Zeiger auf nchstes Zeichen und nchsten }
       XBufferTail : Word = 0;              { freien Eintrag im second level Tastaturbuffer. }
       AltInput    : Byte = 0;              { Char entered by Alt and numberkeys. }
       SnapKey     : Boolean = False;       { MultiplexHandler warted auf Taste. }
       SnapedKey   : Byte = 0;              { Ascii-Wert der Taste. }
       FuncPtr     : Byte = 0;              { Anzahl der wartenden Funktionsaufrufe. }
       CombStat    : Word = 0;              { Status fr die Zeichenkombination. 0=Keine Kombinationszeichen in Arbeit. }
                                            { Sonst Zeiger in die Kombinationstabelle. }
       DownKeys    : Byte = 0;              { Maske fr momentan gedrckte Tasten. }
       KStat       : Byte = 0;              { Status der Umschalttasten. Alt Gr zu Control+Alt aufgelst. }
       EoDS        : Byte = 0;

Procedure FastDS;                           { Speicher fr fast access DS. }
Begin
   ASM
   DD 0,0,0,0,0,0,0,0,0,0,0,0,0,0
   End;
End;

Var    KeyStat     : Byte absolute 0:$417;  { Status der Umschalttasten. }
                                            { 0 : Rechte SHIFT - Taste. }
                                            { 1 : Linke SHIFT - Taste. }
                                            { 2 : CTRL - Taste. }
                                            { 3 : ALT - Taste. }
                                            { 4 : SCROLL LOCK. }
                                            { 5 : NUM LOCK. }
                                            { 6 : CAPS LOCK. }
                                            { 7 : INSERT. }
       KeysDown    : Byte absolute 0:$418;  { Momentan gedrckte Umschalttasten. }
       KeysDown2   : Byte absolute 0:$496;  { Status von rechten ALT und Control-Tasten. }
       LEDs        : Byte absolute 0:$497;  { Status der Leuchtidioten. }
       BufferStart : Word absolute 0:$480;  { Anfangsadresse des Tastaturbuffers. }
       BufferEnd   : Word absolute 0:$482;  { Endadresse des Tastaturbuffers. }
       BufferHead  : Word absolute 0:$41C;  { Nchstes freies Zeichen im Buffer. }
       BufferTail  : Word absolute 0:$41A;  { Nchstes zu lesendes Zeichen. }
       NoMemCheck  : Word absolute 0:$472;

{ -----------------------------------------------------------------------
  Definition eines Records, der Daten enthlt, die resident bleiben.
  Er bildet das slow access DS.
  -----------------------------------------------------------------------}
Type
DR = Record                                 { Alle Daten, die nach der Initialisierung noch gebraucht werden. }
       TransTable  : Array[1..100,0..5]     { 100 Tasten maximal. }
                        of Byte;            { 5 Tastaturebenen (0-4): normal, shift, ctrl, alt, ctrl+alt (alt gr). }
                                            { Ebene 5 Enthlt zu jeder Taste Verwaltungsinformationen: }
                                            { Bits 0-2 geben an, ob die Taste durch Num, Caps oder Scroll beeinflut wird. }
                                            { Bits 3-7 geben fr jede Ebene an, ob diese mit einem XStr belegt ist. }
       Int9Hand    : IntHandObj;
       ConfigFile  : String[64];            { Name der Konfigurationsdatei. }
       DoFuncs     : Array[1..10] of        { Funktionen, die beim nchsten INT 16 ausgefhrt werden mssen. }
                     Record
                        FuncNum : Byte;
                        Case Byte of
                           0:(Stat,Scan:Byte);
                           1:(Entire:Word);
                     End;
       XStrBufSize : Word;                  { Size of buffer for xstrings. }
       XFunc       : Array[201..240] of XFuncTyp;
       CombTab     : Array[0..191] of Byte; { Tabelle fr Kombinationszeichen. }
       XStrings    : Array[0..$FB00] of Byte;{ Up to 63K of Kbdextensions. }
End;

{ ++++++++++ Macros ++++++++++ }
Procedure Push(W : Word); Inline($90);      { Parameter auf dem Stack ablegen. }

Function GetAx : Word; Inline($90);         { Prozessor-Register AX lesen. }

Function GetAl : Byte; Inline($90);         { Prozessor-Register AL lesen. }

Procedure WaitKBDReady;
Inline($64E4/                               { IN AL,64. }
       $0224/                               { AND AL,2. }
       $FA75);                              { JNZ $-6. }


{ ==========================================================
  Routinen fr Tastaturbuffer:
     Procedure StoreKey(Ascii,Scan : Byte);
     Function  BufferSpace : Word;

     + Bearbeitung von Biosaufrufen.
  ==========================================================}


Procedure FindXStr(XStrNum : Byte);         { XString finden und zum Lesen "ffnen". }
                                            { Wird von GetKey aufgerufen, }
Label Ende;                                 { wenn der aus dem 2. Tastaturbuffer gelesene Scancode 128 war. }
Begin
   If XStrNum<=LastXStr Then                { Nummer des ges. XStr darf nicht grer sein, als letzter XStr. }
   Begin
      ASM                                   { Basisadresse der XString-Tabelle nach ES:DI. }
         Mov DI,Offset Data+Offset DR.XStrings
         Push CS
         Pop ES
      End;
      While XStrNum>1 Do                    { n-1 XStrs berspringen. }
      Begin
         ASM                      { Adresse des nchsten XStr. }
            Mov Al,ES:[DI]
            Xor Ah,Ah
            Inc AX
            Add DI,Ax
         End;
         Dec(XStrNum);
      End;
      ASM                         { Adresse in XString speichern. }
         Mov Word Ptr XString,DI
         Mov Word Ptr XString+2,ES
         CMP Byte Ptr ES:[DI],0   { Stringlnge 0 ? }
         JZ  Ende                 { Dann Ende. }
      End;
      XStrPos:=1;                           { Aktuelle Position im XStr auf eins setzen. }
      PutXStr:=True;                        { Flag fr XStr-Bearbeitung setzen. }
                                            { Alle Zeichen die ab jetzt gelesen werden kommen aus diesem XStr. }
   End;                                     { Wenn Nummer des XStrs grer ist als die des letzten, ignorieren. }
Ende:
End;

Function GetKey : Word;                     { Taste aus XBuffer holen. Lo = Ascii, Hi = Scancode. }
Label Skp1,Skp2,Skp3,Skp4;
Begin
   GetKey:=0;

   If not PutXStr Then                      { Wenn kein XStr in Arbeit, }
   ASM                            { Zeichen aus XBuffer holen. }
      Mov AX,XBufferTail
      Shl Ax,1
      Les DI,XBuffer
      Add Di,Ax                   { Adresse der nchsten Taste. }
      Mov Ax,ES:[DI]              { Taste lesen. }
      Cmp Ah,$80
      Jne Skp1
      Push Ax
      Call FindXStr               { Scancode 128 -> Taste mit XString belegt -> XStr suchen und "ffnen". }
      Jmp Skp2
Skp1: Mov [BP-2],Ax
Skp2:
      Mov AX,XBufferTail
      Inc Ax
      And Ax,63
      Mov XBufferTail,Ax          { Zeiger auf nchsten Eintrag. }
   End;

   If PutXStr Then                          { XStr in Arbeit. !Kein ELSE zu obigem IF, }
   Begin                                    { da PutXStr mglicherweise oben erst gesetzt wurde! }
      ASM
         Mov Al,XStrPos
         Xor Ah,AH
         Mov Di,Ax
         Add Di,Word Ptr XString
         Mov Ax,[DI]              { Die nchsten 2 Byte aus dem XString. }
         Inc XStrPos
         Cmp AL,0
         JZ  Skp3                 { 1. Zeichen >0 ? }
         Xor AH,AH                { -> nur ASCII-Wert, kein Scancode. }
         Jmp Skp4

Skp3:    Inc XStrPos              { Ansonsten Scancode zurckgeben, Zeiger um 2 erhhen. }
Skp4:    Mov [BP-2],AX
      End;
      PutXStr:=XStrPos<=Length(XString^);   { Ende des XStrings ? -> PutXStr = False. }
   End;
End;

Procedure StoreKey(A,S : Byte);             { Taste in XBuffer speichern. }
Label XFunction,Skp1;
Begin
   If SnapKey Then                          { Wartet das Program interface auf eine Taste ? }
   Begin
      SnapKey:=False;                       { Taste geht an PI. }
      SnapedKey:=A;
   End
   Else
   If (KeysDown and 8)=8 Then               { Pause ? }
   ASM                                      { Dann Pause zu ende. }
      Mov AL,ES:[Offset KeysDown]           { ES ist noch von der Abfrage auf 0000! }
      And AL,$F7
      Mov ES:[Offset KeysDown],AL
   End
   Else                                     { Ansonsten gedrckte Taste speichern. }
      If (S=128) and (A>200) Then           { Sonderfunktion ? }
      Begin
         Case A of
            255 : Begin
                     NoMemCheck:=$1234;
                     Inline($ea/0/0/$FF/$FF);  { JMP FFFF:0000 -> Reset. }
                  End;
            254 : Inline($CD/5);            { Interrupt 5 -> Print Screen. }
{           253 : ;                         { Reserviert fr Bildschirm dunkelschalten. }
{           252 : ;                         { Reserviert fr Datum. }
{           251 : ;                         { Reserviert fr Uhrzeit. }
            250 : Inactive:=True;           { XKeyb aus. BIOS bernimmt. }
{           249 : ;                         { Reserviert fr Notfalltaste (Programmabbruch). }
            248 : ;                         { Keine Tastenfunktion. }
            247 : Asm INT 19h End;          { OS/2: DOS-Box schlieen. }
            201..240 : Goto XFunction;
         End;
      End
      Else
      Begin
         ASM                      { Zeichen im Buffer eintragen. }
            Mov Ax,XBufferHead
            Shl Ax,1
            LES DI,XBuffer
            Add DI,Ax             { Adresse des nchsten freien Platzes im Buffer. }
            Mov Ah,S              { Scancode. }
            Mov Al,A              { ASCII-Wert. }
            Mov ES:[DI],Ax        { Im Buffer eintragen. }

            Mov Ax,XBufferHead    { Zeiger auf Bufferende weiterrcken. }
            Inc Ax
            And Ax,63

            Cmp Ax,XBufferTail    { Buffer-berlauf ? }
            JE  Skp1              { Dann Taste wegwerfen und XBufferHead unverndert lassen. }
            Mov XBufferHead,Ax
Skp1:
         End;
      End;
   Exit;

XFunction:
   With DR(@Data^) Do                       { Funktionsaufruf. }
   Begin
      Case XFunc[A].Stat of
         $80 : If FuncPtr<10 Then
               Begin
                  Inc(FuncPtr);
                  Asm
                     Xor Ax,Ax
                     Mov Es,Ax
                     Mov BL,ES:KeyStat      { Tastaturstatus holen. }
                     Push CS
                     Pop ES
                     Mov DI,Offset Data+Offset DR.DoFuncs
                     Mov Al,FuncPtr
                     Dec Al
                     Mov Ah,3
                     Mul Ah
                     Add DI,Ax              { Adresse des Eintrags in DoFuncs. }
                     Mov Al,A
                     Mov ES:[DI],Al         { Funktionsnummer. }
                     Mov ES:[DI+1],Bl       { Tastaturstaus. }
                     Mov Al,Scancode
                     Mov ES:[DI+2],Al       { ScanCode. }
                  End;
               End;
         $81 : XFunc[A].Proc(ScanCode*256+KeyStat);
         $82 : Word(XFunc[A].Adr^):=ScanCode*256+KeyStat;
      End;
   End;
End;

Function BufferSpace : Byte;                { Freien Platz im Buffer ermitteln. (first level) }
Label Skp1;
Begin
   ASM
      Xor Ax,Ax
      Mov Es,Ax
      Mov AX,ES:BufferEnd
      Sub AX,ES:BufferStart                 { Buffergre in Byte. }
      Mov BX,ES:BufferHead
      Sub Bx,ES:BufferTail                  { Anzahl Byte im Buffer. }
      JNC Skp1                              { Wenn BX negativ, ist -BX der freie Speicherplatz! }
      Xor Ax,Ax
Skp1: Sub Ax,Bx                             { AX = Freie Bytes. }
      Shr Ax,1                              { AX = Freie Eintrge. }
      Dec AX                                { Ein Eintrag bleibt aus verwaltungstechnischen Grnden leer. }
      Mov [BP-1],AL
   End;
End;

Procedure MoveKeys;
{ Die Aufgabe dieser Routine ist das Auffllen des BIOS-Tastaturbuffers }
{ aus dem second level Buffer. Das Auslesen der Zeichen bernehmen Andere. }
Label Lop1,EoL1,Skp1;
Begin
   ASM
      CLI
      Call BufferSpace
Lop1:    Or Al,Al
         JZ EoL1                  { Schleife max. bis AL=0. }
         Mov Bx,XBufferHead
         Cmp Bx,XBufferTail       { Wenn XBuffer leer }
         JNE Skp1
         CMP PutXStr,0            { und kein XStr in Arbeit }
         JZ  EoL1                 { dann Schleifenende. }
Skp1:
         Push Ax                  { Zhler in AL sichern. }
         Call GetKey              { Taste holen. }
         Xor Si,Si
         Mov Es,Si
         Mov DI,ES:BufferHead     { Zeiger auf Bufferende. }
         Mov ES:[DI+$400],AX      { Taste in [40:BufferHead]. }
         Pop Ax
         Dec Al                   { Freier Platz -1. }

         Add Di,2                 { Zeiger auf nchsten Eintrag. }
         Cmp DI,ES:BufferEnd      { Buffer-Ende erreicht ? }
         Mov ES:BufferHead,DI
         Jne Lop1                 { Nein -> Weiter im Text. }

         Mov DI,ES:BufferStart    { Zeiger zurck zum Anfang. }
         Mov ES:BufferHead,DI
         Jmp Lop1                 { Nchster Schleifendurchlauf. }

EoL1:
   End;
End;

Procedure Int16Handler;
Label Skp1,Lop1,EoL1;
Begin
   ASM
      PushA
      Push DS
      Push CS
      Pop  DS
      Push ES
   End;
   EnableInts;
   For Loop:=1 To FuncPtr Do
      With DR(@Data^),DoFuncs[Loop] Do
         XFunc[FuncNum].Proc(Entire);
   FuncPtr:=0;
   MoveKeys;
   ASM
      Pop  ES
      Pop  DS
      PopA
      Leave
      JMP CS:NextInt16
   End;
End;

Procedure MultiplexHandler;
{ Handler fr Multiplexer-Interrupt. Hierber wird der Installationsstatus }
{ ermittelt. }
Label InsCheck,SetKeyTrans,GetKeyTrans,WaitForKeyHit,PutKey,
      SetX,GetX,SetFunc,ClearFunc,SetMap,SetTable,GetTable,
      GetCombTab,GetShiftTab,
      Ende,Next,Skp1,Skp2,Skp3,Skp4,Skp5,Skp6,Skp7,Skp8,
      Lop1,Lop2,Lop3,Lop4,Lop5,EoL1,EoL2,EoL3,EoL4;
Begin
   ASM
      Push DS                     { DS sichern und auf CS setzen. }
      Push CS
      Pop  DS

      CMP AX,$AD80                { Ist XKeyb angesprochen ? }
      JB  Next                    { (XKeyb belegt den Funktionsbereich AD80 - ADFF.) }
      CMP AX,$ADFF
      JA  Next                    { Nein -> Weiter in der Kette. }

{ Case Selektor. }
      CMP AL,$80                  { AD80 -> Installation Check. }
      JE InsCheck
      CMP AL,$81                  { AD81 -> Set Code Page (Dummy). }
      JNE Skp1
      Mov Ax,0
      CLC
      Jmp Ende
Skp1: CMP AL,$82                  { AD82 -> Set keyboard mapping. }
      JE  SetMap
      CMP AL,$90
      JE  SetKeyTrans             { AD90 -> Set key translation. }
      CMP AL,$91
      JE  GetKeyTrans             { AD91 -> Read key translation. }
      CMP AL,$94
      JE  WaitForKeyHit           { AD94 -> Wait for key hit and return key data. }
      CMP AL,$95
      JE  PutKey                  { AD95 -> Store key into second level buffer. }
      CMP AL,$96
      JE  SetX                    { AD96 -> Set expansion string. }
      CMP AL,$97
      JE  GetX                    { AD97 -> Read expansion string. }
      CMP AL,$98
      JE  SetFunc                 { AD98 -> Assign function. }
      CMP AL,$99
      JE  ClearFunc               { AD99 -> Cancel function assignment. }
      CMP AL,$9A
      JE  SetTable                { AD9A -> Set address of keyboard translation table. }
      CMP AL,$9B
      JE  GetTable                { AD9B -> Read address of keyboard translation table. }
      CMP AL,$9C
      JNE Skp2
      Mov Ax,0                    { AD9C -> Get number of last defined expansion string. }
      Mov BL,LastXStr
      JMP Ende
Skp2: CMP AL,9Dh
      JE  GetCombTab              { Adresse der Kombinationstabelle lesen. }
      CMP Al,9Eh
      JE  GetShiftTab             { Adresse der Shift-Liste lesen. }
      Mov Ax,10                   { Fehler 10 -> unbekannte Funktion. }
      JMP Ende

InsCheck:
      Mov AL,$FF                  { -> Tastaturtreiber installiert. }
      Mov CX,$584B                { Kennung fr XKeyb. }
      Mov BX,Version              { Versionsnummer. }
      Mov DX,Seg Data             { Adresse des Datenblocks. }
      Mov ES,DX
      Mov DI,Offset Data
      Mov DX,$4448                { Kennung fr XKeyb. }
      Mov SI,$5053                { Kennung fr XKeyb. }
      Jmp Ende

SetMap:                           { BL=0 -> BIOS.  BL=FF -> XKeyb. }
      Mov Ax,9
      STC
      INC BL                      { Ergebnis mu 0 oder 1 sein! }
      CMP BL,1
      JA  Ende                    { Ansonsten Fehler 9 -> Unerlaubter mapping code. }
      Mov Inactive,BL             { 0 (False) -> XKeyb, 1 (True) -> BIOS. }
      Mov Ax,0
      CLC
      JMP Ende

SetKeyTrans:
      Mov Ax,4
      Dec DI                      { Ergebnis mu kleiner als 100 sein. (Tasten 1-100 sind erlaubt!) }
      CMP DI,99
      JA  Ende                    { Ansonsten Fehler 4 -> Unzulssige Tastennummer. }
      Shl DI,1
      Mov Ax,Di
      Shl Di,1
      Add Ax,Di                   { (Tastennummer-1)*6 -> Offset zur bersetzungstabelle! }
      LES DI,TransTable           { Basis der bersetzungstabelle. }
      Add DI,Ax                   { Adresse des zu ndernden Eintrages. }
      Mov ES:[DI],BL              { Normale Belegung. }
      Inc DI
      Mov ES:[DI],CH              { Mit Shift. }
      Inc DI
      Mov ES:[DI],CL              { Mit Control. }
      Inc DI
      Mov ES:[DI],DH              { Mit Alt. }
      Inc DI
      Mov ES:[DI],DL              { Mit Alt Gr. }
      Inc DI
      Mov ES:[DI],BH              { Statusbyte. }
      Mov Ax,0
      Jmp Ende

GetKeyTrans:
      Mov Ax,4
      Dec DI
      CMP DI,99
      JA  Ende                    { Fehler wenn Tastennummer 0 oder >100. }
      Shl DI,1
      Mov Ax,Di
      Shl Di,1
      Add Ax,Di
      LES DI,TransTable
      Add DI,Ax                   { Adresse des Eintrages in der Tabelle. }
      Mov BL,ES:[DI]              { Alle Werte lesen. }
      Inc DI
      Mov CH,ES:[DI]
      Inc DI
      Mov CL,ES:[DI]
      Inc DI
      Mov DH,ES:[DI]
      Inc DI
      Mov DL,ES:[DI]
      Inc DI
      Mov BH,ES:[DI]
      Mov Ax,0
      Jmp Ende

WaitForKeyHit:
      Mov SnapKey,True            { -> Das program interface wartet auf eine Taste. }
      STI                         { Interrupts zulassen. }
Lop1: CMP SnapKey,True            { Warten, bis Taste da. }
      JE  Lop1
      CLI                         { Bitte nicht stren. }
      Mov Ah,VirtScanCode         { Virtuellen Scancode lesen. }
      Mov Al,SnapedKey            { ASCII-Wert der Taste. }
      Mov Bh,ScanCode             { Physik. Scancode. }
      Xor Cx,Cx
      Mov Es,CX
      Mov Bl,ES:[Offset KeyStat]  { Tastaturstatus. }
      Mov Dh,Row                  { Tastenebene -> 0=Normal, 1=Shift, 2=Control, 3=Alt, 4=Alt Gr. }
      Mov Cx,Version              { Versionsnummer. }
      Jmp Ende

PutKey:
      Mov CX,XBufferHead          { BufferHead merken. }
      Push CX
      Push BX                     { BL=ASCII-Wert. }
      Mov BL,BH                   { BH=Scancode (virtuell). }
      Push BX
      Call StoreKey               { Eintragen. }
      Xor Ax,Ax
      Pop CX
      Cmp Cx,XBufferHead          { Hat sich BufferHead verndert ? }
      Jne Ende                    { Ja -> alles klar. }
      Mov Ax,5                    { Nein -> Fehler 5: Buffer voll. }
      Jmp Ende

SetX:
      Mov Ax,1
      Dec Bl
      Cmp Bl,199
      JA  Ende                    { XStr Nummer mu im Bereich von 1 bis 200 liegen! }

      Inc Bl                      { XStr-Nummer restaurieren. }
      Mov Bp,Offset Data
      Xor Si,Si
      Cmp Bl,LastXStr             { Ist XStr-Nummer grer als die des letzten? }
      JBE Skp3

         Mov BH,1                 { Ja -> Es mssen diverse Leerstrings erzeugt werden. }
Lop2:       Cmp BH,LastXStr       { Zeiger HINTER den letzten definierten XStr berechnen. }
            JA  EoL3
            Mov Al,Byte Ptr CS:[SI+BP+Offset DR.XStrings] { Lnge des XStr. }
            Xor AH,AH
            Add Si,Ax             { Lnge zu SI addieren. }
            Inc SI                { SI+1 -> wegen Lngenbyte! }
            Inc BH
            Jmp Lop2
EoL3:
         Xor Ch,Ch
         Mov CL,BL
         Sub Cl,LastXStr          { CX = Anzahl zu erzeugende Leerstrings. }
         Mov Ax,2
         Push Cx                  { Sichern. }
         Add Cx,Si                { SI = Zeiger hinter LastXStr. }
         Cmp Cx,Word Ptr CS:[BP+ Offset DR.XStrBufSize]  { Passen die Leerstrings noch in den Buffer ? }
         Pop CX
         JA  Ende                 { Nein -> Fehler 2: Buffer voll. }

         Xor Ax,Ax
         CLD                      { Richtung: vorwrts (inc). }
         Push Di                  { ES:DI sichern. }
         Push ES
         Push CX                  { CX sichern. }
         Push CS
         Pop ES                   { ES = Segmentadresse des Buffers. }
         Mov Di,Si                { DI = Adresse hinter LastXStr rel. zum Bufferanfang! }
         Add Di,BP                { + Offsetadresse des Datenbereiches. }
         Add Di,Offset DR.XStrings{ + Offsetadresse des Buffers im Record. }
         Rep Stosb                { CX Leerstrings erzeugen. }
         Pop CX                   { CX und ES:DI restaurieren. }
         Pop ES
         Pop DI

         Push Cx
         Add CL,LastXStr
         Mov LastXStr,CL          { LastXStr korrigieren. }
         Pop Cx

         Add Si,Cx                { SI enthlt die Adresse des zu definierenden XStrings. }
         Mov Cx,Si                { CX zeigt hinter LastXStr. Beides bezieht sich auf den Anfang des Buffers ! }
         Dec Si
         Jmp Skp4

{ Der ELSE-Zweig, wenn die XStr-Nummer <= LastXStr ist. }
Skp3:
         Mov BH,1
         Mov AX,SI                { SI zeigt auf den ersten XStr. (Enthlt 0.) }
Lop3:       CMP BH,LastXStr       { Zeiger hinter letzten XStr und Zeiger auf gesuchten XStr berechnen. }
            JA  EoL4
            CMP BL,BH
            DB  $75,2             { Wenn BL<>BH nchsten Befehl berspringen. }
            Mov Ax,SI             { Ansonsten Adresse des gesuchten XStr merken. }
            Mov Dl,CS:[SI+BP+Offset DR.XStrings]
            Xor Dh,Dh
            Add Si,Dx
            Inc SI
            Inc BH
            Jmp Lop3

EoL4:    Mov CX,SI                { Wie oben! CX zeigt hinter alles, Si auf den gesuchten String. }
         Mov Si,AX

Skp4:                             { Mit den von einem der IF-Zweige berechneten Werte geht es jetzt weiter. }
      Mov DL,ES:[DI]              { Lnge des einzutragenden XStr. }
      Xor Dh,Dh
      Mov Al,CS:[SI+BP+Offset DR.XStrings] { Lnge des vorhandenen XStr. }
      Xor Ah,Ah
      Sub Dx,Ax                   { DX: notwendige Verschiebung nach HINTEN in Bytes. Kann negativ sein. }
      JZ Skp5                     { Stringlngen gleich? Dann Verschiebung berspringen. }

         Push CX
         Add Cx,Dx                { Ist Die Verschiebung mglich ? }
         Mov Ax,2
         Dec Cx
         Cmp CX,CS:[BP+Offset DR.XStrBufSize]
         Pop CX
         JA  Ende                 { Sorry. Not enough bufferspace. }

         Mov AX,SI
         Add Al,CS:[BP+SI+Offset DR.XStrings]
         Adc AH,0
         Inc Ax                   { Zeiger hinter den einzutragenden String. }
         Mov Bx,Cx
         Sub Bx,Ax                { Anzahl zu kopierende Bytes. }
         Jz  Skp5                 { Nix zu kopieren? Und tschss... }

         Push Dx
         SHL DX,1                 { Oberstes Bit testen -> ist DX positiv oder negativ ? }
         Pop DX
         CLD
         JC Skp6                  { Von vorn nach hinten Kopieren wenn negativ. }

         STD                      { Ansonsten von hinten nach vorn. }
         Add Ax,Bx                { Zeiger korrigieren: Vom ersten zu kopierenden Byte auf das letzte. }
         Dec Ax                   { AUF das letzte, nicht dahinter! }

Skp6:    Push Es                  { ES:DI sicher aufbewahren, wird noch gebraucht! }
         Push Di
         Push Si                  { Ebenso die Startadresse des zu setzenden Strings. }
         Push CS
         Pop Es                   { ES auf Segmentadresse des Buffers. }
         Mov DI,Ax                { ES:DI = Ziel. }
         Add DI,DX                { Ziel=Quelle + Verschiebung. }
         Mov Si,Ax                { DS:SI = Quelle. }
         Mov Cx,Bx                { Anzahl Bytes. }
         Mov AX,Offset DR.XStrings{ Offsetadresse des Buffers rel. zum Anfang des Records. }
         Add Ax,BP                { + Basisadresse des Datenbereiches. }
         Add SI,AX                { Zu Ziel und Quelle addieren. }
         Add DI,AX
         Rep Movsb                { Hau wech die Scheiie. }
         Pop Si                   { Si,Di,Es restaurieren. }
         Pop Di
         Pop Es

Skp5: Mov Cl,ES:[DI]              { Lnge des einzutragenden Strings. }
      Xor Ch,Ch
      Mov BX,DI
      Mov DI,SI                   { DI = Zieloffset. }
      Mov SI,BX                   { SI = Quelloffset. }
      Add DI,BP                   { Zieloffset + Basis des Buffers. }
      Add DI,Offset DR.XStrings
      Mov Bx,Es
      Mov DS,Bx                   { DS = Quellsegment. }
      Push CS
      Pop ES                      { ES = Zielsegment. }
      CLD                         { Vorwrts! }
      Inc CX                      { Auch das Lngenbyte mu mit ! }
      Rep Movsb                   { There is goes ... }

      Xor Ax,Ax                   { UFF. Geschafft. }
      Mov BL,LastXStr
      JMP Ende

GetX:
      Mov AX,1
      Dec Bl
      Cmp Bl,199
      JA  Ende                    { Die Nummer gilt nich. }

      Mov Ax,3
      Inc Bl
      Cmp Bl,LastXStr
      Ja  Ende                    { Der XStr is nich definiert. }

      Mov Si,Offset Data+Offset DR.XStrings { Offsetadresse des Buffers, rel. zum Segmentanfang. }
Lop4:    Cmp BL,1                 { Gewnschten XStr suchen. }
         JE  EoL1
         Mov Al,CS:[SI]
         Xor Ah,Ah
         Add Si,Ax
         Inc Si
         Dec Bl
         Jmp Lop4
EoL1:
      CLD
      Mov CL,CS:[SI]              { Stringlnge nach CX. }
      Xor Ch,Ch
      Inc CX                      { + Lngenbyte. }
      Rep Movsb                   { Und schaufeln ... }

      Xor Ax,Ax
      Mov Bl,LastXStr
      Jmp Ende

SetFunc:
      Mov BP,Offset Data+Offset DR.XFunc { Offsetadresse der XFunction-Tabelle. }
      Cmp Bl,0                    { BL=0 -> Leeren XStr suchen. }
      JNE Skp7                    { Ansonsten angegebene Nummer verwenden. }

         Mov SI,0
         Mov Ax,6
Lop5:    Cmp DS:[BP+SI+Offset XFuncTyp.Stat],Ah { Unbenutzt ? }
         JE  EoL2                 { Dann Ende. }
         Add SI,5                 { Sonst nchsten. }
         Inc BL
         Cmp BL,40                { Keiner mehr da ? }
         Je  Ende                 { Oh Schreck. Fehler 4: Kein freier XStr fr Funktionen. }
         JMP Lop5                 { Nicht mde werden! Weitersuchen! }

EoL2:    Add BL,201               { BL fr Aufrufer anpassen. }
         JMP Skp8                 { SI enthlt Zeiger in die Tabelle. }

{ Else-Zweig. Testen, ob geforderter XStr zulssig. }
Skp7:
         Mov Ax,1
         Sub BL,201
         JC  Ende                 { XStr-Nummer kleiner als 201? Das geht nun wirklich nicht. }
         Cmp BL,39
         JA  Ende                 { Nach der Subtraktion immer noch grer als 39? Das geht auch nicht. }
                                  { Wenn die XFunc schon belegt ist, ist das Sache des Benutzers ! }
         Mov Al,Bl
         Mov Ah,5
         Mul Ah                   { Jeder Eintrag umfasst 5 Byte. }
         Add BL,201               { Wert wieder richtig machen. }
         Mov Si,Ax                { SI enthlt Zeiger in die Tabelle. }

Skp8:
      Mov Ax,7
      CMP BH,2                    { BH>2? Das ist ein Fehler. }
      JA  Ende                    { Fehler 2 -> Unerlaubte Aufrufkonvention. }

      Add BH,$80
      Mov DS:[BP+SI+Offset XFuncTyp.Stat],BH   { Den ganzen Kram in die Tabelle eintragen. }
      Mov DS:[BP+SI+Offset XFuncTyp.Adr],Di
      Mov DS:[BP+SI+Offset XFuncTyp.Adr+2],ES
      Xor Ax,AX
      Jmp Ende

ClearFunc:
      Mov BP,Offset Data+Offset DR.XFunc
      Mov Ax,1
      Sub Bl,201
      Jc  Ende
      Cmp Bl,39
      Ja  Ende                    { Fehler, wenn unerlaubte XFunc-Nummer. }

      Mov Al,Bl
      Mov Ah,5
      Mul Ah
      Mov Si,Ax
      Mov AX,8
      Cmp DS:[BP+SI+Offset XFuncTyp.Stat],AH
      Je  Ende                    { Fehler wenn XFunc unbelegt. }

      Mov DS:[BP+Si+Offset XFuncTyp.Stat],AH { Status = 0. }

      Xor Ax,AX
      Jmp Ende

SetTable:
      Mov Word Ptr TransTable,DI  { Adresse der bersetzungstabelle setzen. }
      Mov Word Ptr TransTable+2,ES

GetTable:
      LES DI,TransTable           { Adresse der bersetzungstabelle auslesen. }
      Xor Ax,Ax
      Jmp Ende

GetCombTab:
      Push Cs
      Pop  Es
      Mov  Di,Offset Data+Offset DR.CombTab
      Xor  Ax,Ax
      Jmp  Ende

GetShiftTab:
      Push Cs
      Pop  Es
      Mov  Di,Offset ShiftKeys
      Xor  Ax,Ax

Ende:
      Pop DS                      { DS restaurieren und Interruptende. }
      Pop BP
      IRET

Next:
      Pop DS                      { DS restaurieren und zum nchsten Interrupthandler. }
      Pop BP
      JMP CS:[NextMulti]
   End;
End;

Procedure KBDOut(B:Byte);
Label Lop1,Lop2,Ok,Err;
Begin
   ASM
Lop1: IN  AL,$64                  { Auf Bereitschaft warten. }
      And AL,2
      JNZ Lop1

      Mov AL,B                    { Byte ausgeben. }
      Out $60,AL

      Xor Ax,Ax
      Mov Es,Ax
      Mov CX,$2000

Lop2: Mov Al,ES:LEDs              { Auf Antwort warten. }
      Test Al,$10
      Jnz Ok
      Test Al,$20
      Jnz Err
      Loop Lop2

Err:  Or ES:LEDs,$80              { Fehler-Flag. }

Ok:   And ES:LEDs,$CF             { Ack & Nak lschen. }
   End;
End;

{***********************************************************
 bersetzungsroutinen.
 ***********************************************************}

{$F+}
Procedure Int9Handler(Var Regs : Registers);{ Handler fr Tastaturinterrupt. }
Label  Ende,BIOS,Combine,NoCombine,
       Skp1,Skp2,Skp3,Skp4,Skp5,Skp6,Skp7,Err,Lop1,Lop2,Lop3;
Begin

   If Inactive Then Goto BIOS;

   WaitKBDReady;
   Port[$64]:=$AD;                          { $AD -> Tastatur 'aus'. }

   ScanCode:=Port[$60];                     { Scancode von der Tastatur bernehmen. }

   ASM
      Mov Al,ScanCode
      Mov Ah,$4F
      STC
      INT 15h                     { -> Mglicherweise externe Scancodebersetzung durch INT 15! }
      JNC Ende                    { Keine weitere Bearbeitung der gedrckten Taste, wenn CARRY gelscht! }
      Mov ScanCode,Al             { Neuer Scancode, falls durch externes Programm bersetzt. }
   End;

{ ********** Test auf Ack, Nak, XKey ********** }

   If ScanCode>=$E0 Then
      Case ScanCode of
         $FA : Begin                        { FAh = Ack. }
               ASM
                  Xor Ax,Ax
                  Mov ES,Ax
                  Or  ES:LEDs,$10           { LEDs enthlt neben dem LED-Status einen erw. Tastaturstatus. }
                  JMP Ende
               End;
               End;
         $FE : Begin                        { FEh = Nak. }
                ASM
                  Xor Ax,Ax
                  Mov Es,Ax
                  Or  Es:LEDs,$20
                  JMP Ende
                End;
               End;
         $E0 : Begin                        { E0h leitet eine 'erweiterte' Taste ein. }
                  Goto Ende;
               End;
      End;


   ASM
      Mov AL,ScanCode
      Xor CL,CL
      SHL AL,1
      ADC CL,0
      Mov BreakCode,CL            { Scancode >7Fh -> Taste wurde losgelassen. }
      SHR AL,1
      Mov ScanCode,AL
      Mov VirtScanCode,Al         { Virtueller Scancode. }
                                  { Die Tasten Crsr-Left, -Right, Pg-Up, -Down, Home, End und Fx }
                                  { erzeugen mit best. Umschalttasten andere Scancodes, einen virt. Scancode. }
   End;

{ ********** Test auf "spezielle" Tasten ********** }
{ Hier werden ggf. die virt. Scancodes fr oben genannte Taste erzeugt. }

   KStat:=KeyStat;
   If (KeysDown2 and 8)=8 Then KStat:=KStat or 12;
   If ((KStat and $C) = 4) and            { Diese Tasten haben NUR mit Control einen abweichenden Scancode. }
      ((ScanCode>54) and (ScanCode<82))
   Then
   Begin
      If not BreakCode Then
         Case ScanCode of
            55 : VirtScanCode:=114;         { ^Druck. }
            71 : VirtScanCode:=119;         { ^Home. }
            73 : VirtScanCode:=132;         { ^Pg Up. }
            75 : VirtScanCode:=115;         { ^Crsr left. }
            77 : VirtScanCode:=116;         { ^Crsr right. }
            79 : VirtScanCode:=117;         { ^End. }
            81 : VirtScanCode:=118;         { ^Pg Down. }
            83 : VirtScanCode:=6;           { ^Del. }
            82 : VirtScanCode:=4;           { ^Ins. }
         End;
   End;

{ ********** Test auf Funktionstasten F1-F10 ********** }
{ Hier werden ggf. die virt. Scancodes fr die Funktionstasten erzeugt. }
{ Diese haben jeweils einen anderen Scancode mit SHIFT, CONTROL und ALT, }
{ nicht jedoch mit ALT GR. }
{ Dies betrifft nur F1 - F10! F11 und F12 bleiben unbeeinflut. }

   If (ScanCode>58) and (ScanCode<69) Then
   Begin
      Case (KStat and $F) of
         1..3 : VirtScanCode:=ScanCode+25;  { Mit Shift. !NCS hat keinen Einflu! Auch nicht, wenn fr die Taste gesetzt! }
         4    : VirtScanCode:=ScanCode+35;  { Mit Control. }
         8    : VirtScanCode:=ScanCode+45;  { Mit Alt. }
      End;
   End;

{ ********** Test auf [2] - [13] ********** }
{ Die Tasten [2] - [13] (= 1234567890') erhhen sich mit ALT um 118. }

   If ((KStat and $F)=8) and
      ((ScanCode>1) and (ScanCode<14)) and
      not BreakCode Then
      VirtScanCode:=ScanCode+118;


{ ********** Test auf Break ********** }
   If XKey and not BreakCode Then
      If ScanCode=70 Then                   { Die erweiterte Taste 70 ist die Break-Taste. Nur bei erweiterten Tastaturen !!! }
      Begin
         Inline($CD/$1B);  { Break. }
         StoreKey(3,0);    { ^C. }
         Goto Ende;
      End;

{ ********** Test auf Umschalttaste ********** }
   ShiftNum:=0;                             { Test, ob der akt. Scancode in der Liste der Umschalttasten steht. }
   While (ShiftNum<=7) and                  { Suchen bis Scancode gefunden oder Listenende. }
      (ScanCode<>ShiftKeys[ShiftNum]) Do
      Inc(ShiftNum);

   ASM                            { In ShiftBit das Bit setzen, das zur gedrckten Umschalttaste gehrt. }
      Mov Cl,ShiftNum
      Mov Al,1
      Shl Al,Cl
      Mov ShiftBit,Al
   End;

   If (ShiftNum<2) Then                     { Erweiterte Shift-Taste wurde gedrckt. }
   Begin
      If XKey Then
      Begin
         XShift:=Not BreakCode;             { Dieses gesondert merken. }
         Goto Ende;
      End
      Else
      If BreakCode Then XShift:=False;
   End;

   If ShiftNum>1 Then                       { Erweiterten Tastaturstatus pflegen. }
   Begin
      If ShiftNum<4 Then DownKeys:=1 shl (ShiftNum-2)
                    Else DownKeys:=1 shl ShiftNum;
      DownKeys:=DownKeys and $7F;           { Prevent INS from being interpret as SYS-REQ }
      If (ShiftNum=3) and XKey Then         { Rechte ALT-Taste hat hier keinen Einflu! }
         KeysDown:=0;
      If BreakCode Then KeysDown:=KeysDown and (not DownKeys)
                   Else KeysDown:=KeysDown or DownKeys;
   End;

   If ShiftNum<4 Then                       { Eine der Tasten LSHift, RShift, Control, Alt wurde gedrckt. }
   Begin
      If ShiftNum>1 Then
         DownKeys:=1 shl(ShiftNum-2);       { Fr erweiterten Tastaturstatus. }
      If (ShiftNum=3) and XKey Then
      Begin
(*         ShiftBit:=$C;                    { Erweiterte ALT-Taste = Alt Gr = Control+Alt! } *)
         If BreakCode Then KeysDown2:=KeysDown2 and $F7   { Status fr rechte ALT-Taste aktualisieren. }
                      Else KeysDown2:=KeysDown2 or 8;
      End;
      If BreakCode Then                     { Wenn Taste losgelassen, }
      Begin
         KeyStat:=KeyStat and               { Entsprechendes Bit im Status lschen. }
                  (not ShiftBit);
         If ShiftBit=8 Then                 { ALT losgelassen ! }
            If AltInput<>0 Then             { Eingabe ber ALT + Zifferntasten ? }
            Begin
               ScanCode:=0;
               Storekey(AltInput,0);        { Eingegebene Taste im Tastaturbuffer speichern. }
               CombStat:=0;                 { Keine Kombinationen mit Alt-Zeichen! }
               AltInput:=0;
            End;
      End
      Else KeyStat:=KeyStat or ShiftBit;    { Wenn Taste gedrckt, entsprechendes Bit im Status setzen. }
      Goto Ende;                            { Ende der Bearbeitung. }
   End;

   If BreakCode Then Goto Ende;             { Das Loslassen von Tasten ist ab hier nicht mehr relevant! }

   If ShiftNum<7 Then                       { Scancode gehrt zu einer der Lock-Tasten. }
   Begin
      If (ShiftNum=5) and ((KeyStat and 4)>0) Then
      ASM                                   { Ctrl-Num = Pause ! }
         Xor AX,AX
         Mov ES,AX
         OR  ES:KeysDown,8                  { Pause-Bit setzen. }
         JMP Ende                           { Und zur Warteschleife am Ende. }
      End;
      ASM
         Xor Ax,Ax
         Mov Es,Ax
         Mov Al,ShiftBit
         Xor ES:KeyStat,Al                  { Status der gedrckten Taste umschalten. }
         JMP Ende                           { Ausgabe an KBD erfolgt am Ende. }
      End;
   End;


{ *********** Test auf Insert *********** }

   If (ShiftNum=7) and                      { Shift-7 = Einfgen (INS). }
      ((KeyStat and $F) =0) Then            { !Hat nur Auswirkungen wenn OHNE Shift, Control und Alt gedrckt! }
   ASM
      Xor Ax,Ax
      Mov Es,Ax
      Xor Es:KeyStat,$80                    { INS-Bit umschalten. }
   End;


{ ********** Test auf ALT + Zifferntaste ********** }

   If (KStat and $F) = 8 Then               { ALT gedrckt? }
      If (TransTable^[ScanCode,5] and 2)=2  { Wird Taste von NUM beeinflut? }
      Then
      Begin
         AltInput:=AltInput*10 +            { -> gedrckte Ziffer zum bereits vorhandenen Wert hinzufgen. }
                   TransTable^[ScanCode,1]-48;
         Goto Ende;                         { Keine weitere Bearbeitung dieser Taste. }
      End;

{ ********** Bearbeitung der brigen Tasten ********** }

   NCS:=(( TransTable^[ScanCode,5] and      { Test, ob Num, Caps oder Scroll eingeschaltet ist }
          (KeyStat shr 4) and               { und ob die gedrckte Taste davon beeinflut wird. }
          $7
        ) > 0) Xor XShift;                  { Erweiterte Shift-Taste hebt NCS auf! }

   Case (KStat and $F) of
      0    : Row:=Byte(NCS);                { No Shifts, depends on NCS. }
      1..3 : Row:=Byte(NCS) xor 1;          { SHIFT, depends on NCS. }
      4    : Row:=2;                        { CTRL, not influenced by NCS. }
      8    : Row:=3;                        { ALT, not influenced by NCS. }
      12   : Row:=4;                        { CTRL & ALT, not influenced by NCS. }
   End;

(*   If (KeysDown2 and 8)=8 Then Row:=4;      { Rechte ALT-Taste ist unten! =>> ALT GR! } *)

   ASM
      Mov Al,ScanCode             { ScanCode. }
      Dec Al                      { Arraystart bei 1. Deshalb Korrektur. }
      Xor AH,AH
      SHL AX,1
      Mov BX,Ax
      Shl Ax,1
      Add Ax,Bx                   { Mal 6 -> Zeiger in TransTable. }
      LES Di,TransTable           { Startadresse der Tabelle. }
      Add Di,Ax                   { Adresse des Tabelleneintrags. }
      Mov Al,ES:[DI+5]            { Statusbyte lesen. }
      Mov Bl,VirtScanCode

      Mov Cl,Row                  { Zeile. }
      Inc Cl
      Shl Al,Cl                   { Das zu Row gehrende XStr-Bit wird ins Carry geshiftet. }
      JNC Skp1                    { Sprung wenn nicht mit XStr belegt. }
      Mov Bl,$80                  { Virtuellen Scancode durch 80h ersetzen. }

Skp1: Mov Cl,Row
      Xor Ch,Ch
      Add Di,CX
      Mov Al,ES:[DI]              { ASCII-Wert oder XStr-Nummer aus Transtable. }

      CMP CombStat,0              { Test, ob Kombinationszeichen in Arbeit. }
      JNZ Combine                 { -> Kombinationsroutine bernimmt das. }

      Mov DI,Offset Data+Offset DR.CombTab  { Test, ob Zeichen erstes Zeichen einer Kombination ist. }
Lop3: Cmp Byte Ptr DS:[Di],0      { Ende der Liste? }
      Jz  Skp6                    { Ja. }
      Cmp Al,DS:[Di]              { Ist das das Zeichen? }
      Jz  Skp7                    { Ja. }
      Inc Di
      Mov Cl,DS:[Di]
      Xor Ch,Ch
      Shl Cx,1
      Add Di,Cx
      Inc Di                      { Nchstes Zeichen. }
      Jmp Lop3

Skp7: Inc Di
      Mov CombStat,Di
      Jmp Ende

Skp6: Push Ax
      Push Bx
      Call StoreKey
   End;




{ Ende der bersetzung. Jetzt noch Interruptende mitteilen und warten falls Pausemodus. }
Ende:
   MoveKeys;                                { BIOS-Buffer auffllen. }
   XKey:=ScanCode=$E0;                      { !Erweiterten Tasten geht der Scancode 224 voraus! }
   EoI;                                     { Interruptcontroller Interruptende mitteilen. }
   EnableInts;                              { Interrupts zulassen. (Werden beim Auslsen des Interrupts automatisch gesperrt. }

   WaitKBDReady;
   Port[$64]:=$AE;                          { AEh -> Tastatur 'ein'. }


{ Aitor:1: REMOVE ALL LED SUPPORT  (as suggested by Axel)}
(*
 { update LED status, if any LED changed }
    ASM
       Xor Ax,Ax
       Mov Es,Ax
       Test ES:LEDs,$40 { LED update in progress? }
       JNZ Skp2 { yes: skip update }

       Cli { disable interrupts }
       Mov Al,ES:KeyStat { check whether LED flags changed }
       Mov Bl,ES:LEDs { get LED flags }
       Mov Cl,4
       Shr Al,Cl
       And Al,7 { unmask LED flags }
       And Bl,7
       CMP Al,Bl { LED flags changed? }
       JE Skp2 { no: skip }

       Or ES:LEDs,$40 { indicate 'LED update in progress' }
       And ES:LEDs,NOT $07 { clear LED flags }
       STI
       Push Ax { save LED status }
       Push $ED { port $64 opcode 'set LED status' }
       Call KBDOut { send opcode to keyboard controller }
       Pop Ax { restore LED status }
       Test ES:LEDs,$80 { transmission error? }
       JNZ Err { yes: skip }
       Push Ax { save LED status }
       Push Ax { push LED status for KbdOut }
       Call KBDOut { send new LED status to keyboard port}
       Pop Ax
       Test ES:LEDs,$80 { transmission error? }
       JNZ Err { yes: exit }

       And ES:LEDs, NOT 7 { clear old LED status in BIOS }  {Axel 1.6}
       Or ES:LEDs,Al { store new LED status }
       Jmp Skp2

 Err: Push $F4 { error code 'pulse output low for 6ms' }
       Call KBDOut { An Tastatur. }
       And ES:LEDs, $3F { clear flags 'transmission error', 'LED update'}
 Skp2: STI
    End;
*)

   If LoopRunning Then Goto Skp3;           { Wenn Warteschleife bereits luft, Interruptroutine verlassen. }

   LoopRunning:=True;
   ASM
      Xor  Ax,Ax
      Mov  Es,Ax
Lop1: Test Es:KeysDown,8          { Warten solange Pausemodus. }
      JNZ  Lop1
   End;
   LoopRunning:=False;
Skp3:
   ExitChain;                               { Interruptroutine verlassen. }

Combine:
   ASM
      Mov Di,CombStat
      Mov CombStat,0

      OR  BL,7Fh                  { ScanCode = 0 oder 80h ? }
      JZ  NoCombine               { Keine Kombination mit XStrings und Zeichen, die ber ALT+Ziffern eingegeben wurden. }

      Mov Si,Di
      Mov CL,DS:[DI]              { Anzahl der Zeichen, die geprft werden mssen. }
      Xor Ch,Ch
      Inc Di
Lop2: Cmp Al,DS:[DI]              { Zweites Zeichen der Kombination gefunden? }
      JNZ Skp5                    { Nein. }

      Inc Di
      Mov Al,DS:[Di]              { Ersatzzeichen. }
      Push Ax
      Push Bx
      Call Storekey               { Den Mist abspeichern. }
      Jmp Ende                    { Dann Ende der Angelegenheit. }

Skp5: Inc Di                      { Nchster Eintrag. }
      Inc Di
      Dec Cx                      { Noch ein Kandidat da? }
      JNZ Lop2                    { Dann weiter. }

NoCombine:
      Push Ax                     { Das ganze war ein Fehlschlag. }
      Push BX                     { Jetzt beide Zeichen einzeln in den Tastaturbuffer werfen. }
      Mov Al,DS:[Si-1]            { Erstes Zeichen. }
      Xor Bl,Bl                   { Scancode nicht mehr bekannt. Deshalb 0. }
      Push Ax
      Push Bx
      Call StoreKey               { Erstes Zeichen ablegen. }
      Call StoreKey               { Zweites Zeichen ablegen. }
      Jmp Ende
   End;

BIOS:                                       { XKeyb ist inaktiv. Tastenbersetzung bernimmt das BIOS. }
   If ((KeyStat and 12) = 12) and           { Ctrl+Alt und }
      (Port[$60]=60) Then                   { F2 gedrckt? }
   Begin                                    { XKeyb bernimmt wieder. }
      Inactive:=False;
      EOI;
      Goto Skp3
   End;


End;
{$F-}

{***********************************************************
 Die folgende Prozedur ist ein Platzhalter.
 Hier wird zur Programmlaufzeit der Datenbereich angelegt.
 ( Fr slow access DS.)
 Die endgltige Gre hngt von der Gre des XStr-Buffers ab.
 ***********************************************************}

Procedure Data;                               { ca. 2K freier Speicher. }
Begin ASM
DD 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DD 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DD 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DD 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DD 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DD 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DD 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DD 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DD 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DD 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DD 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DD 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DD 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DD 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DD 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DD 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
End; End;

Var    DatSeg      : ^DR;                   { Variablen, die nur whrend der Installation bentigt werden. }
       Regs        : Registers;

Procedure Keep(Ende : Pointer; Code : Byte);     { Programm beenden, aber im Speicher lassen. }
Var    Laenge      : Word;                       { !Das Programm bleibt nur bis zur angegebenen Adresse im Speicher! }
Type   PtrTyp      = Record Ofs,Seg : Word; End;
Begin
   Laenge:=PtrTyp(Ende).Seg-PrefixSeg +     { Programmlnge berechnen. }
           (PtrTyp(Ende).Ofs+15) Div 16;
   With Regs Do
   Begin
      AH:=49;                               { Terminate, stay resident. }
      AL:=Code;                             { Ende-Code. }
      DX:=Laenge;                           { Lnge in Paragrafen. }
      Intr($21,Regs);
   End;
End;


{$IFNDEF KBDRES}   {Piece of code which is not neccessary for KBDRES}


Procedure Error(B : Byte);
Begin
   Case B of
      1 : Writeln('Different Version of XKeyb installed.');
      2 : Writeln('Incompatible keyboard driver installed.');
      3 : Writeln('Resident part of xkeyb was NOT installed.');
      4 : Writeln('You made a mistake. The specified file could not be opened.');
      5 : Writeln('The resident part of XKeyb could not be removed at this time.');
   End;
   Halt(1);
End;


{***********************************************************
 bersetzungstabelle laden.
 ***********************************************************}

{ +++++++++++ Sondertasten fr XStrings +++++++++++ }

Const  KeyNames    : Array[1..18] of String[5] =
                     ('HOME','END','PU','PD','CL','CR','CU','CD','DEL','INS',
                      'CHOME','CEND','CPU','CPD','CCL','CCR','F11','F12');
       KeyCodes    : Array[1..18] of Byte =
                     (71,79,73,81,75,77,72,80,83,82,119,117,132,118,115,116,87,88);

{$S+,I+,R+}

Var    XStrEnd     : Word;
       XStrs       : Array[1..200] of String; { Die XStrs werden zunchst hier abgelegt und erst spter in ihren }
                                              { Datenbereich kopiert. Dadurch mssen beim Einfgen eines XStrs die }
                                              { nachfolgenden nicht verschoben werden. Sollten schon XStrs existieren, }
                                              { so werden sie zunchst in diesen Datenbereich bernommen! }


Function ProgramName:String;                { Stellt Name und Pfad des laufenden Programmes fest. }
Var    EnvSeg,                              { Ersetzt ParamStr(0), da dieses bei leerem Environment nicht funktioniert. }
       EnvOfs      : Word;
       S           : String;
Begin
   EnvSeg:=MemW[PrefixSeg:$2C];             { Environment Adress. }
   EnvOfs:=0;
   While MemW[EnvSeg:EnvOfs]>0 Do           { Seek end of environment. }
      Inc(EnvOfs);
   Inc(EnvOfs,4);
   S:='';
   While Mem[EnvSeg:EnvOfs]>0 Do            { Program name. Terminated by zero. }
   Begin
      S:=S+Char(Mem[EnvSeg:EnvOfs]);
      Inc(EnvOfs);
   End;
   ProgramName:=S;                          { Let's give it back ... }
End;



{Aitor, 1.7}
Function ProgramPath: string;
var
   s: string;
begin
     s := ProgramName;
     while s[length(s)]<>'\' do
        delete (s,length(s),1);
     delete (s,length(s),1);
     ProgramPath := s
End; {ProgramPath}



Function GetNumber(Var Line:String; Var LinePtr:Byte):Byte; { Byte aus Line lesen. }
Var    S           : String[8];
       Num         : Byte;
       err         : Integer;
Begin
   S:='0';
   While Line[LinePtr]=' ' Do               { Eventuelle Leerzeichen bergehen. }
      Inc(LinePtr);

   While (Line[LinePtr]>='0') and           { bis keine Ziffer mehr folgt oder Zeilenende erreicht. }
         (Line[LinePtr]<='9') and
         (LinePtr<=Length(Line)) Do
   Begin
      S:=S+Line[LinePtr];
      Inc(LinePtr);
   End;
   Val(S,Num,err);                          { Wert berechnen. }
   GetNumber:=Num;
End;


Procedure SetKey(Var Line:String);          { Abschnitte mit dem Namen KEYS lesen. }
Var    KeyNum      : Byte;
       LinePtr     : Byte;
       C           : Char;
       B           : Byte;
Begin
   LinePtr:=1;

   KeyNum:=GetNumber(Line,LinePtr);      { Read keynumber. }

   If (KeyNum=0) or (KeyNum>100) Then    { Tastennummer zulssig ? }
   Begin
      Writeln('Illegal key number:');
      Writeln(Line);
   End;

   TransTable^[KeyNum,5]:=0;             { Tastenattribut = 0. }

   C:=Line[LinePtr];
   While C<>' ' Do                       { Nach Tastennummer folgt optional NCS, dann Leerzeichen. }
   Begin
      Case UpCase(C) Of
         'N' : Inc(TransTable^[KeyNum,5],2);   { Num-Lock-Bit setzen. }
         'C' : Inc(TransTable^[KeyNum,5],4);   { Caps. }
         'S' : Inc(TransTable^[KeyNum,5],1);   { Scroll. }
      End;
      Inc(LinePtr);                      { Nchstes Zeichen. }
      C:=Line[LinePtr];
   End;

   For B:=0 To 4 Do                      { Belegungen fr 5 Ebenen. }
   Begin
      While Line[LinePtr]=' ' Do
         Inc(LinePtr);                   { Lerrzeichen berlesen. }
      Case Line[LinePtr] of
         '#' : Begin                     { #+ASCII-Wert des Zeichens. }
                  Inc(LinePtr);
                  TransTable^[KeyNum,B]:=GetNumber(Line,LinePtr);
               End;
         '!' : Begin                     { Taste mit XStr belegt. }
                  Inc(LinePtr);
                  TransTable^[KeyNum,B]:=GetNumber(Line,LinePtr);
                  Inc(TransTable^[KeyNum,5],$80 shr B);  { XStr-Bit fr akt. Ebene setzen. }
               End;
         Else  Begin                     { Normale Belegung mit Zeichen. }
                  TransTable^[KeyNum,B]:=Byte(Line[LinePtr]);
                  Inc(LinePtr);
               End;
      End;
   End;
End;

Procedure SetShifts(Var Line:String);       { Scancodes der Umschalttasten aus der Konfigurationsdatei lesen. }
Var    B           : Byte;
       LinePtr     : Byte;
Begin
   LinePtr:=1;
   B:=0;
   While (LinePtr<=Length(Line)) and (B<=7) Do     { Alle Scancodes mssen in einer Zeile stehen! }
   Begin
      ShiftKeys[B]:=GetNumber(Line,LinePtr);       { Diese mu mindesten 8 Scancodes enthalten! }
      Inc(B);
   End;

   If B<=7 Then                          { Weniger als 8 Scancodes gefunden? }
   Begin
      Writeln('Warning:');
      Writeln('Some shift keys remain undefined!');
      Writeln(Line);
   End;
End;


Function GetKeyByName(Var Line:String; Var LinePtr:Byte):String;
Var    KeyName     : String[10];            { Fr die Bearbeitung von XStr-Definitionen. }
       ShiftOffset : Byte;                  { Ermittelt den Scancode einer Taste nach ihrem Namen. }
       B           : Byte;                  { Die Tasten-Namen stehen in KeyNames. }
       I           : Integer;               { Die zugehrigen Scancodes in KeyCodes. }
Begin
   GetKeyByName:='';
   KeyName:='';

   While (LinePtr<Length(Line)) and         { Read name of key. }
         (Line[LinePtr]<>']') and
         (Length(KeyName)<7) Do
   Begin                                    { Zeichen kopieren, bis ']', Zeilenende oder 7 Zeichen gelesen. }
      KeyName:=KeyName+UpCase(Line[LinePtr]);
      Inc(LinePtr);
   End;

   If Line[LinePtr]<>']' Then               { Key not terminated by ']' ? }
   Begin
      Writeln;
      Writeln('"]" missing in xstring definition:');
      Writeln(Line);
      Exit;
   End
   Else Inc(LinePtr);

   B:=0;
   Repeat                                   { Search key in list specified at the top of this program section. }
      Inc(B);
   Until (B=17) or (KeyName=KeyNames[B]);
   If B<17 Then                             { Key found => return its scancode. }
   Begin
      GetKeyByName:=#0+Char(KeyCodes[B]);   { Zurckgegeben wird ein Null-Byte + der Scancode. }
                                            { Der Rckgabestring kann direkt an den XStr angehngt werden. }
   End
   Else
   Begin                                    { Key not found. May be function key. }
      ShiftOffset:=0;
      Case KeyName[1] of                    { Die Scancodes der Funktionstasten sind deren Nummer + eines Offsets. }
         'S' : ShiftOffset:=83;             { Offset fr Shift. }
         'C' : ShiftOffset:=93;             { Control. }
         'A' : ShiftOffset:=103;            { Alt. }
         'F' : ShiftOffset:=58;             { Ohne Umschalttaste. }
      End;
      If (ShiftOffset=0) or
         (
            (ShiftOffset>58) and
            (KeyName[2]<>'F')
         ) Then
      Begin                                 { Name of key is invalid. }
         Writeln;
         Writeln('Invalid keyname ',KeyName,' in xstring definition:');
         Writeln(Line);
         Exit;
      End;

      If ShiftOffset>58 Then Delete(KeyName,1,2) { Funktionstasten-Nummer isolieren }
                        Else Delete(KeyName,1,1);

      Val(KeyName,B,I);                     { und umwandeln. }
      If (B<1) or (B>10) Then               { Nur Werte von 1-10 sind zulssig. }
      Begin
         Writeln;
         Writeln('Invalid function key F',B,' in xstring definition:');
         Writeln(Line);
         Exit;
      End;

      GetKeyByName:=#0+Char(B+ShiftOffset); { Der Scancode ist die Tasten-Nummer + der Ebenenabhngige Offset. }
   End;
End;

Function GetSpecKey(Var Line:String; Var LinePtr : Byte):String;
Var    Len         : Byte;                  { Diese Funktion ist zustndig, wenn in der XStr-Definition ein '\' auftaucht. }
       Number      : Byte;                  { Sie ruft ntigenfalls die Funktion GetKeyByName auf. }
       Select      : Char;
Begin
   Len:=Length(Line);
   GetSpecKey:='';

   If LinePtr>Len Then                      { War '\' das letzte Zeichen im XStr ? }
   Begin
      Writeln;                              { Ja -> Fehler. }
      Writeln('Unexpected end of xstring definition:');
      Writeln(Line);
      Exit;
   End;

   Select:=UpCase(Line[LinePtr]);           { Zeichen nach \ auswerten. }
   Case Select of
      'N' : Begin
               GetSpecKey:=#13;             { \n = CR. }
               Inc(LinePtr);
            End;
      '\' : Begin
               GetSpecKey:='\';             { \\ = \. }
               Inc(LinePtr);
            End;
      'A',
      'S' : Begin                           { \Axxx = Chr(xxx) ; \Sxxx = Key(xxx). }
               If Lineptr+3<Len Then        { Die Nummer hat max. 3 Stellen. }
                  Byte(Line[0]):=           { Die Zeilenlnge wird verkrzt, }
                  LinePtr+3;                { um evtl. auf die Nummer folgende Ziffern zu ignorieren! }
               Inc(LinePtr);
               Number:=GetNumber(Line,LinePtr);
               Byte(Line[0]):=Len;          { Original Zeilenlnge restaurieren. }

               If Select='A'
                  Then GetSpecKey:=Char(Number)
                  Else GetSpecKey:=#0+Char(Number);
            End;
      '[' : Begin                           { In [] steht der Name einer Taste. }
               Inc(LinePtr);                { GetKeyByName ermittelt den zugehrigen Code. }
               GetSpecKey:=GetKeyByName(Line,LinePtr);
            End;
      Else Begin                            { Auf \ folgt unzulssiges Zeichen -> Fehler. }
              Writeln;
              Writeln('Syntax error in xstring definition:');
              Writeln(Line);
           End;
   End;
End;


Procedure ParseXStr(Var Line:String; Var LinePtr:Byte; Var Dest:String);
Begin                                       { Diese Routinen bersetzt einen XStr. }
   Dest:='';
   While LinePtr<=Length(Line) Do           { Alle Zeichen bis zum Zeilenende bearbeiten. }
   Begin
      If Line[LinePtr]='\' Then             { Ist Zeichen ein Backslash ? }
      Begin
         Inc(LinePtr);                      { Ja -> Sonderzeichen. }
         Dest:=Dest+GetSpecKey(Line,LinePtr);    { Bedeutung wird von GetSpecKey ermittelt. }
      End
      Else
      Begin                                 { Nein -> Zeichen unverndert bernehmen. }
         Dest:=Dest+Line[LinePtr];
         Inc(LinePtr);
      End;
   End;
End;


Procedure SetXStr(Var Line : String);       { Abschnitte mit dem Namen [XSTRINGS] auswerten. }
Var    LinePtr     : Byte;
       XStrNum     : Byte;
Begin
   LinePtr:=1;
   XStrNum:=GetNumber(Line,LinePtr);     { Zeile beginnt mit der Nummer des XStr. }

   If (XStrNum=0) or (XStrNum>200) Then  { Nummer gltig ? }
   Begin
      Writeln;
      Writeln('illegal xstring number:');
      Writeln(Line);
      Writeln('legal xstring numbers: 1-200.')
   End
   Else
   Begin
      If XStrNum>LastXStr Then LastXStr:=XStrNum;  { Nummer grer als LastXStr? -> LastXStr neu setzen. }
      Inc(LinePtr);                      { Es folgt exakt EIN Leerzeichen. Dieses berlesen. }

      XStrs[XStrNum]:='';
      ParseXStr(Line,LinePtr,XStrs[XStrNum]); { XStr von ParseXStr bersetzen lassen. }
   End;
End;

Procedure ReadCombis(Var S : String);
{ S[1]=Erstes Zeichen der Kombinationen dieser Liste. }
{ S[2]=Anzahl der Kombinationen in der Liste. Mu bei Aufruf dieser Routine 0 sein. }
Var    Loop        : Byte;
Begin
   With DatSeg^ Do
   Begin
      Loop:=0;
      While (CombTab[Loop]<>0) and (CombTab[Loop]<>Byte(S[1])) Do
      Begin                                 { Kombinationszeichen suchen. }
         Loop:=Loop+2*CombTab[Loop+1]+2;
      End;

      If CombTab[Loop]>0 Then               { Kombinationen mit diesem Zeichen gefunden. }
      Begin
         Byte(S[0]):=CombTab[Loop+1]*2+2;
         Move(CombTab[Loop],S[1],Byte(S[0])); { Bestehende Kombinationen bernehmen. }

         Move(CombTab[Loop+Byte(S[0])],CombTab[Loop],192-Loop);
                                            { Die gelesenen Kombinationen werden gelscht! }
                                            { Evtl. spter erneute Eintragung in genderter Form. }
      End;
   End;
End;

Procedure WriteCombis(Var S : String);
Var    Loop        : Byte;
Begin
   Loop:=0;
   With DatSeg^ Do
   Begin
      While CombTab[Loop]>0 Do
         Loop:=Loop+2*CombTab[Loop+1]+2;

      If Loop+Length(S)>191 Then
      Begin
         Writeln(#10'Warning: berlauf der Kombinationszeichentabelle. ');
         Writeln('Kombinationen mit dem Zeichen ',S[1],' inaktiv.');
      End
      Else
      Begin
         Move(S[1],CombTab[Loop],Length(S)); { Den Kram eintragen. }
         CombTab[Loop+Length(S)]:=0;
      End;
   End;
End;


Procedure SetCombi(Var Line : String);
Var    CombiChars  : String;
       LinePtr     : Byte;
Begin
   LinePtr:=1;
   While (Line[LinePtr]=' ') and (LinePtr<=Length(Line)) Do
      Inc(LinePtr);                         { Skip blanks. }
   If LinePtr>Length(Line) Then Exit;       { Nix drin, in der Zeile? }

   CombiChars:=Line[LinePtr]+#0;            { Das erste Zeichen der Kombination nach CombiChars. }
   ReadCombis(CombiChars);                  { Evtl. bestehende Kombinationen mit diesem Zeichen lesen. }

   Inc(LinePtr);
   While LinePtr<=Length(Line) Do           { Zeile bearbeiten. }
   Begin
      If Line[LinePtr]<>' ' Then            { Leerzeichen ? Igitt. }
      Begin
         If Line[LinePtr]='#' Then          { Auf # folgt ASCII-Wert fr Zeichen! }
         Begin
            Inc(LinePtr);                   { ASCII-Wert holen und in Zeichen umwandeln. }
            CombiChars:=CombiChars+Char(GetNumber(Line,LinePtr));
         End
         Else
         If Line[LinePtr]='!' Then          { ! lscht bestehende Definition. }
         Begin
            CombiChars[0]:=#2;
            CombiChars[2]:=#0;
         End
         Else
         Begin
            CombiChars:=CombiChars+Line[LinePtr];
            Inc(LinePtr);                   { Ansonsten Zeichen direkt bernehmen. }
         End;
      End
      Else
         Inc(LinePtr);                      { Leerzeichen bergehen. }
   End;

   If Odd(Length(CombiChars)) Then
   Begin                                    { Hier hat jemand Mist gebaut und ein halbes Zeichenpaar angegeben. }
      Writeln(#10'Warning: Halbes Zeichenpaar bei Kombinationszeichen:');
      Writeln(#10,Line);
      Writeln(#10'Zeile auf ganze Zeichenpaare gekrzt!');
      Dec(CombiChars[0]);
   End;

   CombiChars[2]:=
      Char(Length(CombiChars) Shr 1 -1);    { Halbe Listenlnge minus 1 ist Anzahl der Kombinationen. }
   If CombiChars[2]>#0 Then
      WriteCombis(CombiChars);              { Kombinationen speichern. }
End;




Procedure CopyXStrs(BufSize:Word);           { XStrings krzen und im Buffer speichern. }
Var    B           : Byte;
       BufferFull  : Boolean;
Begin
   XStrEnd:=0;
   BufferFull:=False;

   With DatSeg^ Do
   Begin
      B:=1;
      While (B<=LastXStr) and not BufferFull Do  { Bis alle XStrs eingetragen sind oder der Buffer voll ist. }
      Begin
         If XStrEnd+Length(XStrs[B])>=BufSize Then    { Passt der String noch in den Buffer ? }
         Begin
            Writeln;                                  { Nein. }
            Writeln('Not enough buffer space for xstring declaration:');
            Writeln(XStrs[B]);
            XStrs[B]:='';                             { XString lschen. }
            BufferFull:=(BufSize-XStrEnd)=0;          { Buffer komplett voll ? => Schleife abbrechen. }
         End
         Else
         Begin
            Move(XStrs[B],XStrings[XStrEnd],Byte(XStrs[B][0])+1); { XStr in den Buffer kopieren und }
            XStrEnd:=XStrEnd+Byte(XStrs[B][0])+1;     { Ende des belegten Speichers neu berechnen. }
            Inc(B);
         End;
      End;
      LastXStr:=B-1;                        { Falls nicht alle Strings eingetragen werden konnten. }

      If XStrBufSize=0 Then
         XStrBufSize:=XStrEnd;              { Buffergre nicht angegeben => minimieren. }
   End;
End;

Procedure GetOldXStrs;                      { XStrings aus residenter Kopie von XKeyb lesen. }
Var    B           : Byte;
       W           : Word;
Begin
   With DatSeg^ Do                          { Es wird der Datenbereich der residenten Kopie verwendet ! }
   Begin
      W:=0;
      For B:=1 To LastXStr Do               { Alle XStrs durchgehen. }
      Begin
         Move(XStrings[W],XStrs[B],XStrings[W]+1);    { XStr in anderen Datenbereich bernehmen. }
         W:=W+XStrings[W]+1;                { Adresse des nchsten XStrs berechnen. }
      End;
   End;
End;





Procedure ExpandFileName(Var Name : String);{ Name der Konfigurationsdatei ntigenfalls erweitern. }
{ No longer used; Aitor 1.7
Var    S           : String;  }
Begin
  { first, we are loading a .KEY file }
   If Pos('.',Name)=0 Then    { filename has no extension -> add .KEY }
      Name:=Name+'.Key';

   If (Pos('\',Name)=0) and
      (Pos(':',Name)=0) Then  { filename contains no path -> add program path }
   Begin
      Name := FSearch (Name, ProgramPath+';'+GetEnv('PATH'));  {RQ 1.6-1.7}
      Name := FExpand (Name);            
   End;

(* OLD CODE COMMENTED, probably removed in the future; Aitor 1.7
{$IFDEF BLABLA}
      S:=ProgramName;                       { Programmname. }
      While (S[Length(S)]<>'\') and         { Nur noch Lfwrk + Pfad. }
            (Length(S)>0) Do
         Dec(S[0]);
      Name:=S+Name;
{$ENDIF}
*)

{$ifdef DEBUG}                  {debug code, Ralf 1.7}
WriteLn ('Loading ', Name);
{$endif}

End;


Type   SectionTyp  = (Keys,Shifts,XStrings,Comment,List,Continue,Combi);

Function GetSection(Var Line : String):SectionTyp;    { Abschnittname auswerten. }
Var    B           : Byte;
Begin
   B:=2;
   While (B<Length(Line)) and               { Zeile in Groschrift wandeln. }
         (Line[B]<>']') Do                  { Alle Zeichen nach ']' werden ignoriert. }
   Begin
      Line[B]:=UpCase(Line[B]);
      Inc(B);
   End;
   Line[0]:=Char(B);                        { Eventuelle Zeichen nach ] ignorieren. }

   If Line='[KEYS]' Then GetSection:=Keys
   Else If Line='[SHIFTS]' Then GetSection:=Shifts
   Else If Line='[XSTRINGS]' Then GetSection:=XStrings
   Else If Line='[COMMENT]' Then GetSection:=Comment
   Else If Line='[LIST]' Then GetSection:=List
   Else If Line='[CONTINUE]' Then GetSection:=Continue
   Else If Line='[COMBI]' Then GetSection:=Combi
   Else
   Begin
      Writeln('Warning:');
      Writeln('Unknown section ',Line,' found.');
      Writeln('Skipping section.');
      GetSection:=Comment;
   End;
End;

Procedure ReadConfigFile(Name:String; BufSize : Word);   { Konfigurationsdatei lesen. }
Var    B           : Byte;
       S           : String;
       Section     : SectionTyp;
       Line        : String;
       ConfigFile  : Text;
Label  Cont;
Begin
   For B:=1 To 200 Do                       { Clear XString workspace. }
      XStrs[B]:='';

   If BufSize=$FFFF Then GetOldXStrs;       { Read old xstrings. BufSize=FFFFh -> XKeyb resident installiert. }

Cont:
   ExpandFileName(Name);
   Assign(ConfigFile,Name);
{$I-}
   Reset(ConfigFile);
{$I+}
   If IOResult<>0 Then Error(4);            { ffnen der Datei fehlgeschlagen. }

   DatSeg^.ConfigFile:=Name;
   Section:=Comment;

   While not Eof(ConfigFile) Do             { Datei vollstndig lesen. }
   Begin
      Readln(ConfigFile,Line);

      If Length(Line)>0 Then                { Leerzeilen ignorieren. }
         If Line[1]='[' Then Section:=GetSection(Line)
         Else
            Case Section of
               Keys     : SetKey(Line);
               Shifts   : SetShifts(Line);
               XStrings : SetXStr(Line);
               List     : Writeln(Line);
               Combi    : SetCombi(Line);   { Kombinationszeichen definieren. }
               Continue : Begin             { Bearbeitung mit neuer Datei fortsetzen. }
                             Close(ConfigFile);
                             Name:=Line;
                             Goto Cont;
                          End;
            End
      Else If Section=List Then Writeln;
   End;
   Close(ConfigFile);
   WriteLn ('Installed ',Name);

   With DatSeg^ Do
      If BufSize<$FFFF Then                 { Noch keine residente Installation. }
      Begin
         XStrBufSize:=BufSize;
         If BufSize>1024 Then BufSize:=1024;{ Bei Installation max. 1K, da sonst Codeberschreibung! }
         If BufSize=0 Then BufSize:=1024;   { Keine Angabe? Minimal, bis zu 1K. }
      End
      Else BufSize:=XStrBufSize;            { Wenn schon installiert, dann bestimmt residente Kopie die Buffergre. }

   CopyXStrs(BufSize);                      { XStrs im dafr vorgesehenen Datenbereich ablegen. }
End;


{***********************************************************
 Hauptprogramm & Test auf bereits installierten Treiber.
 ***********************************************************}

Type   BCDString   = String[2];

Function BCD(B : Byte) : BCDString;         { BCD-Zahl in String wandeln. }
Begin
   If B>15 Then BCD:=Char(B shr 4 + 48)+Char(B and 15 + 48)
           Else BCD:=Char(B+48);
End;

Function VS(W : Word) : String;             { Gibt die Versionsnummer als String zurck. }
Var    S           : String;
Begin
   S:=BCD(LO(W));                           { Hinteren Wert in String wandeln. }
   If Length(S)<2 Then S:='0'+S;            { Evtl. fhrende Null ergnzen. }
   VS:=BCD(Hi(W))+'.'+S;                    { Vorderen Wert und Punkt ergnzen. }
End;

Function TestInstallation : Byte;
{ Prfen, ob bereits eine Kopie von XKeyb installiert ist. }
{ Ergebnis: 0 -> Kein Tastaturtreiber installiert. }
{           1 -> Identische Version von XKeyb installiert. }
{                >> DatSeg wird auf den Datenbereich der residenten Kopie gesetzt. }
{           2 -> Andere Version von XKeyb installiert. }
{           3 -> Anderer Tastaturtreiber installiert. }
Begin
   TestInstallation:=0;
   With Regs Do                             { Schon installiert ? }
   Begin
      AX:=$AD80;                            { Installations-Status prfen. }
      BX:=0;                                { AL=0 -> kein Tastaturtreiber installiert. }
      ES:=0;                                { AL=FFh -> Bereits Tastaturtreiber vorhanden. }
      DI:=0;
      Intr($2F,Regs);

      If AL=$FF Then                        { Schon installiert? }
      Begin                                 { JA! }

         If (SI=$5053) and                  { Ist es XKeyb ? }
            (DX=$4448) and
            (CX=$584B) Then
         Begin                              { JA! }
            If BX=Version Then              { Gleiche Version? }
            Begin                           { JA! -> Tabellen knnen berladen werden. }
               DatSeg:=Ptr(ES,DI);          { Zeiger auf Datensegment der residenten Treiberkopie setzen. }
               TestInstallation:=1;
            End
            Else TestInstallation:=2;       { Andere Version von XKeyb. }
         End
         Else TestInstallation:=3;          { Anderer Tastaturtreiber (wahrscheinlich KEYB.COM) installiert. }
      End;
   End;
End;

Procedure Remove;                           { Remove XKeyb from Memory. }
Var    Removeable  : Boolean;
       IntVec      : Array[Byte] of Pointer absolute 0:0;
       Regs        : Registers;
       MultiHand   : Pointer;
       Int16Hand   : Pointer;
Begin
{ Prfen, ob Remove mglich ist. }

   MultiHand:=DatSeg;
   PtrTyp(MultiHand).Ofs:=Ofs(MultiplexHandler);
   Int16Hand:=DatSeg;
   PtrTyp(Int16Hand).Ofs:=Ofs(Int16Handler);
   With DatSeg^ Do
   Begin
      Removeable:=
         (IntVec[$09]=@Int9Hand) and
         (IntVec[$16]=Int16Hand) and
         (IntVec[$2F]=MultiHand);

      If not Removeable Then Error(5);      { Remove unmglich. Interruptvektoren wurden von anderem Programm verbogen. }

{ Uninstall it. }
      Int9Hand.Dequeue;
      DisableInts;
      IntVec[$16]:=NextInt16;
      IntVec[$2F]:=NextMulti;
      EnableInts;
      With Regs Do
      Begin
         AH:=$49;                           { Speicher freigeben. }
         ES:=MemW[Seg(XBuffer^):$2C];       { Environment-Segment. }
         Intr($21,Regs);
         AH:=$49;
         ES:=Seg(XBuffer^);                 { Programmsegment. }
         Intr($21,Regs);
      End;
   End;

   Writeln('Resident part of XKeyb removed.');
End;

Procedure ShowInfo;
Begin
   With DatSeg^ Do
   Begin
      Writeln('Active definitionfile      : ',ConfigFile);
      Writeln('Number of XStrings defined : ',Byte( Ptr(Seg(DatSeg^) , Ofs(LastXStr))^ ));
      Writeln('XString buffer size        : ',XStrBufSize,' Bytes');
   End;
End;

Function PerformParam:ActionTyp;            { Parameterzeile auswerten. }
Var    B           : Byte;
       I           : Integer;
       S           : String;
       Regs        : Registers;
       ConFileName : String;
       Action      : ActionTyp;
       Installed   : Byte;
       XStrBufSize : Word;
       FastDatSeg  : Word;
       T           : text;
Begin
   FastDatSeg:=CSeg;
   ConFileName:='';
   XStrBufSize:=0;
   Action:=GetInfo;
   Installed:=TestInstallation;

   If Installed=1 Then                      { Wenn schon installiert div. Werte aus residentem FastDS holen. }
      Move(Ptr(PtrTyp(DatSeg).Seg , Ofs(ShiftKeys))^,
           ShiftKeys,26);

   With Regs Do
   Begin
      AX:=$3700;                            { SwitchChar erfragen. (Normal '/') }
      Intr($21,Regs);
   End;

   For B:=1 To ParamCount Do                { Alle Parameter durchgehen. }
   Begin
      S:=ParamStr(B);
      If Byte(S[1])=Regs.DL Then            { parameter starts with switch char. }
      Begin
         Case Upcase(S[2]) of
            'X' : Begin                     { Set buffersize for xstring buffer. }
                     Delete(S,1,2);
                     Val(S,XStrBufSize,I);
                  End;
            'U' : Begin                     { Uninstall.}
                     Action:=Uninstall;
                  End;
            'Q' : Begin                     { Quit. Ignore LIST sections. }
                     Close(OutPut);
                     Assign(OutPut,'Nul');
                     Rewrite(OutPut);
                  End;
            'I' : Begin                     { Install. Ignore other driver. }
                     Installed:=0;
                     Action:=Install;
                  End;
            '?' : begin
                        Action := FastHlp;        { Show the fast help }
                  end;
            Else
            Begin                           { Unbekannte Option angegeben -> Fehler. }
               Writeln;
               Writeln('Invalid modifier -  S');  {Aitor 1.7}
            End;
         End;
      End
      Else
      Begin
         ConFileName:=S;      { a parameter without / is the .KEY file name }
         Case Installed of
            0:Action:=Install;
            1:Action:=OverLoad;
         End;
      End;
   End;

   if action<>FastHlp then
   Case Installed of
      2:Action:=WrongVers;
      3:Action:=OtherDrv;
   End;

{ Geforderte Aktion ausfhren. }

   Case Action of
      Install          : ReadConfigFile(ConFileName,XStrBufSize);
      OverLoad         : ReadConfigFile(ConFileName,$FFFF);
      GetInfo          : If Installed=1 Then ShowInfo Else Error(3);
      Uninstall        : If Installed=1 Then Remove Else Error(3);
      WrongVers        : Error(1);
      OtherDrv         : Error(2);
{      FastHlp          : if fSearch (ProgramPath+'\XKEYB.FHL', '') = '' then
                           begin
                              WriteLn ('xkeyb error: fast help file ',ProgramPath+'\XKEYB.HLP',' was not found.');
                           end
                         else
                           Begin
                              Assign (T, ProgramPath+'\XKEYB.FHL');
                              Reset(T);
                              while not eof(T) do begin
                                    readLn (T,S);
                                    WriteLn (S)
                              end;
                              close(T)
                           end;}
   End;

   If Installed=1 Then                      { Wenn schon installiert, div. Werte in residentes FastDS schreiben. }
   Begin
      If Action=OverLoad Then Inactive:=False;   { Treiber aktivieren, falls Tabelle geladen wurde. }
      Move(ShiftKeys,
           Ptr(PtrTyp(DatSeg).Seg , Ofs(ShiftKeys))^,14);
   End;
   PerformParam:=Action;
End;

(* No longer neccessary
Procedure CopyRight; External;

We replace it for the fast help:*)

Procedure Fasthelp; External;

Procedure ShowFastHelp;
Var
       B           : Byte;
       CopyPtr     : ^Byte;
       CopyLen     : ^Word;
Begin
   Writeln(#10);
   CopyPtr:=Ptr(CSeg,Ofs(FastHelp)+2);
   CopyLen:=@FastHelp;
   B:=CopyPtr^;
{$R-}
   While CopyLen^>0 Do
   Begin
      Inc(PtrTyp(CopyPtr).Ofs);
      Dec(CopyLen^);
      If B>207 Then
      Begin
         Loop:=B-208;
         B:=CopyPtr^-B;
         While Loop>0 Do
         Begin
            Write(Char(B));
            Dec(Loop);
         End;
         Inc(PtrTyp(CopyPtr).Ofs);
         Dec(CopyLen^);
      End
      Else
      If B=126 Then Write(VS(Version))
      Else Write(Char(B));
      B:=CopyPtr^-B;
   End;
{$R+}
   Writeln(#10);
End; {ShowFastHelp}


{$ENDIF}{KBDRES}

Var    B           : Byte;
       Action      : ActionTyp;
{       CopyPtr     : ^Byte;
       CopyLen     : ^Word;     NO LONGER neccessary}

Begin
   If Ofs(EoDS)>Ofs(FindXStr) Then
   Begin
      Writeln('Internal failure:');
      Writeln('Speicher fr Fast Access DS zu klein.');
      Halt(67);
   End;

   WriteLn ('XKEYB ',VerS,': keyboard driver for FreeDOS AT machines (more info: XKEYB /?)');



(*      OLD COPYRIGHT METHOD: now used for fasthelp
   Writeln(#10);                            { Copyright-Meldung ausgeben. }
   CopyPtr:=Ptr(CSeg,Ofs(CopyRight)+2);
   CopyLen:=@CopyRight;
   B:=CopyPtr^;
{$R-}
   While CopyLen^>0 Do
   Begin
      Inc(PtrTyp(CopyPtr).Ofs);
      Dec(CopyLen^);
      If B>207 Then
      Begin
         Loop:=B-208;
         B:=CopyPtr^-B;
         While Loop>0 Do
         Begin
            Write(Char(B));
            Dec(Loop);
         End;
         Inc(PtrTyp(CopyPtr).Ofs);
         Dec(CopyLen^);
      End
      Else
      If B=126 Then Write(VS(Version))
      Else Write(Char(B));
      B:=CopyPtr^-B;
   End;
{$R+}
   Writeln(#10);

*)

                                            { Residentes Datensegment initialisieren. }
                                            { Diese Werte gelten nur, wenn der Treiber neu resident gemacht wird. }
   XBuffer:=Ptr(PrefixSeg,128);
   TransTable:=@DR(@Data^).TransTable;
   DatSeg:=@Data;                           { Zeiger auf residentes Datensegment auf die Prozedur Data initialisieren. }
                                            { Diese Einstellung wird ntigenfalls von TestInstallation gendert. }

{$IFNDEF KBDRES}
   Action:=PerformParam;                    { Kommandozeilenparameter auswerten. }

   If Action=FastHlp Then
      ShowFastHelp
   Else
   If Action=Install Then
{$ENDIF}
   With DatSeg^ Do
   Begin
{$IFNDEF KBDRES}
      XStrBufSize:=                         { Bufferende auf Segmentgrenze aufrunden. }
         XStrBufSize
           +(
               16
              -Ofs(XStrings[XStrBufSize]) and $F
            )
            and $F;
{$ELSE}
      XStrBufSize:=Ofs(Keep)-Ofs(XStrings);                         { Bufferende auf Segmentgrenze aufrunden. }
{$ENDIF}


      GetIntVec($2F,NextMulti);
      GetIntVec($16,NextInt16);

      Move(Ptr(DSeg,0)^,Ptr(CSeg,0)^,Ofs(EoDS)); { Daten in residentes FastDS bertragen. }

      For Loop:=201 To 240 Do
         XFunc[Loop].Stat:=0;

      Int9Hand.Enqueue(9,Int9Handler,CSeg);
      SetIntVec($2F,@MultiPlexHandler);
      SetIntVec($16,@Int16Handler);

      SwapVectors;
{$IFNDEF KBDRES}
      Keep(@XStrings[XStrBufSize],0);
{$ELSE}
      Keep(@Keep,0);
{$ENDIF}
      FastDS;                              { Verhindert, da der Linker FastDS entfernt. }
   End;
(* NO LONGER NECCESSARY, replace by fasthelp
End{$L Copy.OBJ}.  *)
END{$L xkeybhlp.obj}.

