{$A-,B-,D+,E-,F-,I-,L+,N-,O-,R-,S-,V-}
{ ===================================================================
  Turbo Pascal Unit    INTER2          4. September 1991

  Version 2.0   Objektorientiert.  Lst Version 1.2 ab.

  Dient zum einfachen Handling von Interrupts, insbesondere dem
  einfachen Erzeugen von Interrupthandlern, sowie dem Kreieren
  eigener DOS-Kommandos mit Hilfe von CED.

  Funktionsumfang bernommen von Version 1.2.
  CallInt um Register ergnzt.
  ===================================================================
  mgliche Fehler in dieser Unit:

               1: Interrupt-Dequeue nicht mglich.
               2: CED-Enqueue fehlgeschlagen.
               3: CED-Dequeue fehlgeschlagen.
               4: Heap-Overflow bei Parameterlesen.
  ===================================================================}


Unit Inter2;
{$F+}

Interface

Uses Global; 

Const  Modul       = 1;        { Inter2 ist Modul 1 }
       PeriodicInt = $1C;      { timer interrupt }
       SerialInt   = $0C;      { hardware interupt called from uart }
       ParallelInt = $0F;      { hardware interrupt called on ACK }
       PrinterBIOS = $17;      { bios interrupt for printer }
       DosInt      = $21;      { ms-dos interrupt }
       KeyInt      = $09;      { hardware interrupt called when a key is pressed }
       VideoBIOS   = $10;      { bios interrupt for screen }
       TestInt     = $4B;      { unused interrupt }

Type   Registers   = Record    { ersetzt registers der dos-unit }
                       Bp,Es,Ds,Si,Di : Word;
                       Case Boolean Of
                         False : (Dx,Cx,Bx,Ax,Ip,Cs,Flags : Word);
                         True  : (Dl,Dh,Cl,Ch,Bl,Bh,Al,Ah : Byte);
                       End;
       ProcTyp     = Procedure(Var Regs : Registers);
       StringPtr   = ^String;
       BaseObj     = Object
                         PushRegs : Array[1..13] of Byte;
                         MovAx    : Byte;
                         DataSeg  : Word;
                         MovDsAx  : Word;
                         Call     : Byte;
                         IntHand  : Pointer;
                         PopRegs  : Array[1..9] of Byte;
                         Jump     : Byte;
                         NextInt  : Pointer;
                         Error    : Byte;
                      End;


{ Das Objekt IntHandObj ermglicht das einhngen eines eigenen
  Interrupthandlers in einen Interrupt. Dabei wird eine Kette gebildet.
  D.h. beim Auftreten eines Interrupts wird zu erst der eigene Interrupt-
  Handler bearbeitet und anschlieend zum vorhergehende Interrupthandler
  gesprungen.
  Der Destructor Dequeue realisiert das Aushngen des Interrupthandlers
  aus der Kette. Dies funktioniert jedoch nur, wenn es sich um den letzten
  Handler der Kette handelt.
  Die Prozedur ExitChain bietet dem Interrupthandler die
  Mglichkeit,die Bearbeitung der Kette abzubrechen.}

       IntHandObj  = Object(BaseObj)
                        IntNum   : Byte;
                        Constructor Enqueue(Num     : Byte;
                                            Proc    : ProcTyp;
                                            DS      : Word);
                        Destructor Dequeue;
                     End;

{ Das Object CedHandObj dient dazu, unter Zuhilfenahme von CED, eigene
  DOS-Kommandos zu installieren. S.a. CED Manual.}
       CedHandObj  = Object(BaseObj)
                        Name      : String;
                        Constructor Enqueue(ComName     : String;
                                            Proc        : ProcTyp;
                                            DS          : Word;
                                            Mode        : Byte);
                        Destructor Dequeue;
                     End;




Procedure CallInt(Adr : Pointer; Var Regs : Registers);
{ callint ruft eine interrupt-routine, die an adresse adr steht, auf.}


Procedure Intr(IntNum : Byte; Var Regis : Registers);
{ entspricht intr in der dos-unit.}


Procedure MsDos(Var Regs : Registers);


Procedure SetIntVec(IntNum : Byte; Adress : Pointer);
{ entspricht setintvec der dos-unit.}


Procedure GetIntVec(IntNum : Byte; Var Adress : Pointer);


Procedure Jump(P : Pointer); InLine($CB);      { RETF }
{ diese procedure fhrt einen sprung zu der angegebenen adresse aus.}


Procedure MovEs(W : Word); InLine(7);  { POP ES }


Procedure MovDs(W : Word); InLine($1F); { POP DS }


Procedure DisableInts; Inline($Fa);   { Disable Interrupts }
{ sperrt die hardware-interrupts.}


Procedure EnableInts; Inline($Fb);   { Enable    Interrupts }
{ lt die hardware-interrupts zu.}


Procedure Nop; Inline($90);


Procedure EoI; Inline($B0/$20/$E6/$20);
{ MOV AL,20                         End of Interrupt an Interrupt-
  OUT 20,AL                         controller melden.}


Procedure Keep(B : Byte);


Procedure NullOut(Regis : Registers);
{ fr ced-kommandos.
  setzt die eingabezeilenlnge auf null. verhindert dadurch die ausfhrung
  des kommandos durch dos.}


Function CedAllParam(Var R : Registers) : StringPtr;


Function CedParam(n : Byte; Var R : Registers) : StringPtr;
{ Liefert den n-ten Parameter eines Ced-Kommandos zurck.}


Procedure InitStack(Sp,Ss : Word);
Inline($Fa/$58/$5B/$8E/$D0/$89/$DC/$Fb);
{ initialisiert den stack.}

Procedure ExitChain;
Inline($8B/$E5/$5D/$83/$C4/8/$5d/$07/$1f/$5e/$5f/$5a/$59/$5b/$58/$CF);
{ Mov  Sp,Bp
  Pop  Bp
  Add  Sp,8
  Pop  Registers
  IRet
 mit dieser procedure kann die abarbeitung einer kette abgebrochen werden.}


{ ******************************************************************* }

  Implementation

{ ******************************************************************* }


Const  Base        : BaseObj = (PushRegs:($50,$53,$51,$52,$57,$56,$1e,$06,$55,$8B,$C4,$16,$50);
                                MovAx:$B8;
                                DataSeg:0;
                                MovDsAx:$d88e;
                                Call:$9a;
                                IntHand:Nil;
                                PopRegs:($5d,$07,$1f,$5e,$5f,$5a,$59,$5b,$58);
                                Jump:$ea);

Constructor IntHandObj.Enqueue;
Begin
    PushRegs:=Base.PushRegs;
    MovAx:=$B8;
    DataSeg:=DS;
    MovDsAx:=$D88E;
    Call:=$9A;
    IntHand:=@Proc;
    PopRegs:=Base.PopRegs;
    Jump:=$EA;
    IntNum:=Num;
    GetIntVec(IntNum,NextInt);
    SetIntVec(IntNum,@PushRegs);
    Error:=0;
End;

Destructor IntHandObj.Dequeue;
Var    P           : ^IntHandObj;
Begin
   GetIntVec(IntNum,Pointer(P));
   If P=@PushRegs Then
      SetIntVec(IntNum,NextInt)
   Else
      Global.SetError(Modul,1,0);  { Fehler 1: Dequeue nicht mglich.}
End;


Procedure SetIntVec;
Begin
   DisableInts;
   Pointer(Ptr(0,IntNum shl 2)^):=Adress;
   EnableInts;
End;

Procedure GetIntVec;
Begin
   Adress:=Pointer(Ptr(0,IntNum shl 2)^);
End;

Procedure CallInt; External;

Procedure Intr; External;

Procedure MsDos;
Begin
   Intr($21,Regs);
End;

Procedure Keep;
Var    EndSeg      : Word;
       Regs        : Registers;
Type   PSPTyp      = Array[1..2] of Word;
Begin
   EndSeg:=PSPTyp( PTR(PrefixSeg,0)^ )[2];
   With Regs Do
   Begin
      AH:=49;
      AL:=B;
      DX:=EndSeg-PrefixSeg;
      Intr($21,Regs);
   End;
End;


{ ###################################################################
                      Prozeduren fr Ced
  ################################################################### }

Type   BufTyp      = Array[Byte] of Char;

Constructor CedHandObj.Enqueue;
Var    Regs        : Registers;
Begin
   PushRegs:=Base.PushRegs;
   MovAx:=$B8;
   DataSeg:=DS;
   MovDsAx:=$D88E;
   Call:=$9A;
   IntHand:=@Proc;
   PopRegs:=Base.PopRegs;
   Jump:=$CB;
   With Regs Do
   Begin
      Ah:=$FF;       {Ced Service}
      Al:=0;         {Function 0: Enqueue}
      Bl:=Mode;
      Name:=ComName+#13;
      Ds:=Seg(Name);
      Si:=Succ(Ofs(Name));
      Es:=Seg(PushRegs);
      Di:=Ofs(PushRegs);
      MsDos(Regs);
      If Odd(Flags) Then
         Global.SetError(Modul,2,0);           { Fehler 2: CED-Enqueue fehlgeschlagen.}
   End;
End;

Destructor CedHandObj.Dequeue;
Var    Regs        : Registers;
Begin
   With Regs Do
   Begin
      AH:=$FF;
      AL:=1;                 { Funktion 1:Dequeue.}
      DS:=Seg(Name);
      SI:=Ofs(Name)+1;
      MsDos(Regs);
      If Odd(Flags) Then
         Global.SetError(Modul,3,0);  { Fehler 3: CED-Dequeue fehlgeschlagen.}
   End;
End;


Procedure NullOut;
Begin
   With Regis Do
      Mem[Ds:Si]:=13;
End;

Function CedAllParam(Var R : Registers) : StringPtr;
Var    S           : StringPtr;
       Buffer      : ^BufTyp;
       BP          : Byte;
Begin
   If MaxAvail<256 Then
   Begin
      Global.SetError(Modul,4,0);       { Fehler 4: Kein Heapspeicher bei Parameterlesen.}
      CedAllParam:=Nil;
      Exit;
   End;
   New(S);
   S^:='';
   Buffer:=Ptr(R.DS,R.Dx);
   BP:=0;
   While Buffer^[BP]<>#13 Do
   Begin
      S^:=S^+Buffer^[BP];
      Inc(BP);
   End;
   CedAllParam:=S;
   Dispose(S);
End;

Function CedParam(n : Byte; Var R : Registers) : StringPtr;
Var    Buffer      : ^BufTyp;
       BP          : Byte;
       S           : StringPtr;
Begin
   Buffer:=Ptr(R.Ds,R.Dx);
   BP:=0;
   If MaxAvail<256 Then
   Begin
      Global.SetError(Modul,4,0);             { Fehler 4: Kein Heapspeicher bei Parameterlesen.}
      CedParam:=Nil;
      Exit;
   End;
   New(S);
   S^:='';
   While (n>0) and (Buffer^[BP]<>#13) Do
   Begin
      Inc(BP);
      If (Buffer^[Pred(BP)]=' ') and (Buffer^[BP]<>' ') Then
         Dec(n);
   End;
   If n=0 Then
      While (Buffer^[BP]<>' ') and (Buffer^[BP]<>#13) Do
      Begin
         S^:=S^+Buffer^[BP];
         Inc(BP);
      End;
   CedParam:=S;
   Dispose(S);
End;

{$L CallInt2}
{$L Intr}

End.
