; File:
;                         int2526.asm
; Description:
;     Interface code for int 25h and int 26h
;
;                       Copyright (c) 1997
;                           Svante Frey
;                       All Rights Reserved
;
; This file is part of DOS-C.
;
; DOS-C is free software; you can redistribute it and/or
; modify it under the terms of the GNU General Public License
; as published by the Free Software Foundation; either version
; 2, or (at your option) any later version.
;
; DOS-C is distributed in the hope that it will be useful, but
; WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
; the GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public
; License along with DOS-C; see the file COPYING.  If not,
; write to the Free Software Foundation, 675 Mass Ave,
; Cambridge, MA 02139, USA.
;
; $Logfile:   C:/dos-c/src/kernel/int2526.asv  $
;
; $Header:   C:/dos-c/src/kernel/int2526.asv   1.0   16 Jan 1997 21:43:12   patv  $
;
; $Log:   C:/dos-c/src/kernel/int2526.asv  $
;  
;     Rev 1.0   16 Jan 1997 21:43:12   patv
;  Initial revision.
;

		page    60,132
		title   Interface code for int 25h and int 26h

IFDEF ??version
_TEXT           segment byte public 'CODE'
DGROUP          group   _DATA,_BSS,_BSSEND              ; small model
                assume  cs:_TEXT,ds:DGROUP,ss:DGROUP
_TEXT           ends

_DATA           segment word public 'DATA'
_DATA           ends

_BSS            segment word public 'BSS'
_BSS            ends

_BSSEND         segment byte public 'STACK'
_BSSEND         ends

ELSE
_TEXT           segment byte public 'CODE'
_TEXT           ends

_DATA           segment word public 'DATA'
_DATA           ends

CONST           segment word public 'CONST'
CONST           ends

_BSS            segment word public 'BSS'
_BSS            ends

_BSSEND         segment byte public 'STACK'
_BSSEND         ends

DGROUP          group   CONST,_DATA,_BSS,_BSSEND        ; small/tiny model
                assume  ds:DGROUP, ss:DGROUP
ENDIF

_TEXT           segment byte public 'CODE'
                assume  cs:_TEXT

extrn  _int25_handler:NEAR, _int26_handler:NEAR
extrn  _set_stack:FAR
extrn  _restore_stack:FAR
extrn  _api_sp:WORD
extrn  _api_ss:WORD
extrn  _disk_api_tos:WORD

stkframe        dd      ?

public  _low_int25_handler
_low_int25_handler  proc far
        sti
        pushf
        push    ax
        push    cx
        push    dx
        push    bx
        push    sp
        push    bp
        push    si
        push    di
        push    ds
        push    es
        
        mov     word ptr cs:stkframe, sp     ; save stack frame
        mov     word ptr cs:stkframe+2, ss

        cld
        mov     ax, seg DGROUP
        mov     ds, ax

        mov     word ptr DGROUP:_api_sp, offset DGROUP:_disk_api_tos
        mov     word ptr DGROUP:_api_ss, ds

        call    far ptr _set_stack

        push    word ptr cs:stkframe+2
        push    word ptr cs:stkframe
        call    _int25_handler
        add     sp, 4

        call    far ptr _restore_stack

        pop     es
        pop     ds
        pop     di
        pop     si
        pop     bp
        pop     bx      ; pop off sp value
        pop     bx
        pop     dx
        pop     cx
        pop     ax
        popf
        retf            ; Bug-compatiblity with MS-DOS.
                        ; This function is supposed to leave the original
                        ; flag image on the stack.
_low_int25_handler  endp

public  _low_int26_handler
_low_int26_handler  proc far
        sti
        pushf
        push    ax
        push    cx
        push    dx
        push    bx
        push    sp
        push    bp
        push    si
        push    di
        push    ds
        push    es
        
        mov     word ptr cs:stkframe, sp     ; save stack frame
        mov     word ptr cs:stkframe+2, ss

        cld
        mov     ax, seg DGROUP
        mov     ds, ax

        mov     word ptr DGROUP:_api_sp, offset DGROUP:_disk_api_tos
        mov     word ptr DGROUP:_api_ss, ds

        call    far ptr _set_stack

        push    word ptr cs:stkframe+2
        push    word ptr cs:stkframe
        call    _int26_handler
        add     sp, 4
        
        call    far ptr _restore_stack

        pop     es
        pop     ds
        pop     di
        pop     si
        pop     bp
        pop     bx      ; pop off sp value
        pop     bx
        pop     dx
        pop     cx
        pop     ax
        popf
        retf            
_low_int26_handler  endp

_TEXT           ends

                end
